package WSDiscovery::Types::AppSequenceType;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(0);

sub get_xmlns { 'http://docs.oasis-open.org/ws-dd/ns/discovery/2009/01' };

our $XML_ATTRIBUTE_CLASS = 'WSDiscovery::Types::AppSequenceType::_AppSequenceType::XmlAttr';

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use base qw();

package WSDiscovery::Types::AppSequenceType::_AppSequenceType::XmlAttr;
use base qw(SOAP::WSDL::XSD::Typelib::AttributeSet);

{ # BLOCK to scope variables

my %InstanceId_of :ATTR(:get<InstanceId>);
my %SequenceId_of :ATTR(:get<SequenceId>);
my %MessageNumber_of :ATTR(:get<MessageNumber>);

__PACKAGE__->_factory(
    [ qw(
        InstanceId
        SequenceId
        MessageNumber
    ) ],
    {

        InstanceId => \%InstanceId_of,

        SequenceId => \%SequenceId_of,

        MessageNumber => \%MessageNumber_of,
    },
    {
        InstanceId => 'SOAP::WSDL::XSD::Typelib::Builtin::unsignedInt',
        SequenceId => 'SOAP::WSDL::XSD::Typelib::Builtin::anyURI',
        MessageNumber => 'SOAP::WSDL::XSD::Typelib::Builtin::unsignedInt',
    }
);

} # end BLOCK




1;


=pod

=head1 NAME

WSDiscovery::Types::AppSequenceType

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
AppSequenceType from the namespace http://docs.oasis-open.org/ws-dd/ns/discovery/2009/01.






=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over



=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # WSDiscovery::Types::AppSequenceType
 },



=head2 attr

NOTE: Attribute documentation is experimental, and may be inaccurate.
See the correspondent WSDL/XML Schema if in question.

This class has additional attributes, accessibly via the C<attr()> method.

attr() returns an object of the class WSDiscovery::Types::AppSequenceType::_AppSequenceType::XmlAttr.

The following attributes can be accessed on this object via the corresponding
get_/set_ methods:

=over

=item * InstanceId



This attribute is of type L<SOAP::WSDL::XSD::Typelib::Builtin::unsignedInt|SOAP::WSDL::XSD::Typelib::Builtin::unsignedInt>.

=item * SequenceId



This attribute is of type L<SOAP::WSDL::XSD::Typelib::Builtin::anyURI|SOAP::WSDL::XSD::Typelib::Builtin::anyURI>.

=item * MessageNumber



This attribute is of type L<SOAP::WSDL::XSD::Typelib::Builtin::unsignedInt|SOAP::WSDL::XSD::Typelib::Builtin::unsignedInt>.


=back




=head1 AUTHOR

Generated by SOAP::WSDL

=cut

