package ONVIF::PTZ::Types::IrCutFilterAutoAdjustmentOptions;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'http://www.onvif.org/ver10/schema' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %BoundaryType_of :ATTR(:get<BoundaryType>);
my %BoundaryOffset_of :ATTR(:get<BoundaryOffset>);
my %ResponseTimeRange_of :ATTR(:get<ResponseTimeRange>);
my %Extension_of :ATTR(:get<Extension>);

__PACKAGE__->_factory(
    [ qw(        BoundaryType
        BoundaryOffset
        ResponseTimeRange
        Extension

    ) ],
    {
        'BoundaryType' => \%BoundaryType_of,
        'BoundaryOffset' => \%BoundaryOffset_of,
        'ResponseTimeRange' => \%ResponseTimeRange_of,
        'Extension' => \%Extension_of,
    },
    {
        'BoundaryType' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'BoundaryOffset' => 'SOAP::WSDL::XSD::Typelib::Builtin::boolean',
        'ResponseTimeRange' => 'ONVIF::PTZ::Types::DurationRange',
        'Extension' => 'ONVIF::PTZ::Types::IrCutFilterAutoAdjustmentOptionsExtension',
    },
    {

        'BoundaryType' => 'BoundaryType',
        'BoundaryOffset' => 'BoundaryOffset',
        'ResponseTimeRange' => 'ResponseTimeRange',
        'Extension' => 'Extension',
    }
);

} # end BLOCK








1;


=pod

=head1 NAME

ONVIF::PTZ::Types::IrCutFilterAutoAdjustmentOptions

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
IrCutFilterAutoAdjustmentOptions from the namespace http://www.onvif.org/ver10/schema.






=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * BoundaryType


=item * BoundaryOffset


=item * ResponseTimeRange


=item * Extension




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # ONVIF::PTZ::Types::IrCutFilterAutoAdjustmentOptions
   BoundaryType =>  $some_value, # string
   BoundaryOffset =>  $some_value, # boolean
   ResponseTimeRange =>  { # ONVIF::PTZ::Types::DurationRange
     Min =>  $some_value, # duration
     Max =>  $some_value, # duration
   },
   Extension =>  { # ONVIF::PTZ::Types::IrCutFilterAutoAdjustmentOptionsExtension
   },
 },




=head1 AUTHOR

Generated by SOAP::WSDL

=cut

