const std = @import("std");
const neg = @import("negXi2.zig");
const testing = std.testing;

const print = std.debug.print;

fn test__negsi2(a: i32, expected: i32) !void {
    const result = neg.__negsi2(a);
    try testing.expectEqual(expected, result);
}

test "negsi2" {
    // TODO ensuring that math.minInt(i32); returns error

    try test__negsi2(-3, 3);
    try test__negsi2(-2, 2);
    try test__negsi2(-1, 1);
    try test__negsi2(0, 0); // special case for 2s complement
    try test__negsi2(1, -1);
    try test__negsi2(2, -2);
    try test__negsi2(3, -3);

    // max_usable == MAX(i32) == -MIN(i32) == 2147483647 == 7fffffff
    // divTrunc: max_usable / i, i=1,2,3,5,100
    // 7fffffff / i
    try test__negsi2(-715827882, 715827882);
    try test__negsi2(715827882, -715827882);
    try test__negsi2(-429496729, 429496729);
    try test__negsi2(429496729, -429496729);
    try test__negsi2(-214748364, 214748364);
    try test__negsi2(214748364, -214748364);
    // shifting: max_usable >> i, i=0..bitsize-4
    // 7fffffff >> i
    // 7fffffff >> i + 1
    // 7fffffff >> i + 3
    // 7fffffff >> i + 7
    try test__negsi2(-2147483647, 2147483647);
    try test__negsi2(2147483647, -2147483647);
    try test__negsi2(-2147483646, 2147483646);
    try test__negsi2(2147483646, -2147483646);
    try test__negsi2(-2147483644, 2147483644);
    try test__negsi2(2147483644, -2147483644);
    try test__negsi2(-2147483640, 2147483640);
    try test__negsi2(2147483640, -2147483640);
    try test__negsi2(-1073741823, 1073741823);
    try test__negsi2(1073741823, -1073741823);
    try test__negsi2(-1073741822, 1073741822);
    try test__negsi2(1073741822, -1073741822);
    try test__negsi2(-1073741820, 1073741820);
    try test__negsi2(1073741820, -1073741820);
    try test__negsi2(-1073741816, 1073741816);
    try test__negsi2(1073741816, -1073741816);
    try test__negsi2(-536870911, 536870911);
    try test__negsi2(536870911, -536870911);
    try test__negsi2(-536870910, 536870910);
    try test__negsi2(536870910, -536870910);
    try test__negsi2(-536870908, 536870908);
    try test__negsi2(536870908, -536870908);
    try test__negsi2(-536870904, 536870904);
    try test__negsi2(536870904, -536870904);
    try test__negsi2(-268435455, 268435455);
    try test__negsi2(268435455, -268435455);
    try test__negsi2(-268435454, 268435454);
    try test__negsi2(268435454, -268435454);
    try test__negsi2(-268435452, 268435452);
    try test__negsi2(268435452, -268435452);
    try test__negsi2(-268435448, 268435448);
    try test__negsi2(268435448, -268435448);
    try test__negsi2(-134217727, 134217727);
    try test__negsi2(134217727, -134217727);
    try test__negsi2(-134217726, 134217726);
    try test__negsi2(134217726, -134217726);
    try test__negsi2(-134217724, 134217724);
    try test__negsi2(134217724, -134217724);
    try test__negsi2(-134217720, 134217720);
    try test__negsi2(134217720, -134217720);
    try test__negsi2(-67108863, 67108863);
    try test__negsi2(67108863, -67108863);
    try test__negsi2(-67108862, 67108862);
    try test__negsi2(67108862, -67108862);
    try test__negsi2(-67108860, 67108860);
    try test__negsi2(67108860, -67108860);
    try test__negsi2(-67108856, 67108856);
    try test__negsi2(67108856, -67108856);
    try test__negsi2(-33554431, 33554431);
    try test__negsi2(33554431, -33554431);
    try test__negsi2(-33554430, 33554430);
    try test__negsi2(33554430, -33554430);
    try test__negsi2(-33554428, 33554428);
    try test__negsi2(33554428, -33554428);
    try test__negsi2(-33554424, 33554424);
    try test__negsi2(33554424, -33554424);
    try test__negsi2(-16777215, 16777215);
    try test__negsi2(16777215, -16777215);
    try test__negsi2(-16777214, 16777214);
    try test__negsi2(16777214, -16777214);
    try test__negsi2(-16777212, 16777212);
    try test__negsi2(16777212, -16777212);
    try test__negsi2(-16777208, 16777208);
    try test__negsi2(16777208, -16777208);
    try test__negsi2(-8388607, 8388607);
    try test__negsi2(8388607, -8388607);
    try test__negsi2(-8388606, 8388606);
    try test__negsi2(8388606, -8388606);
    try test__negsi2(-8388604, 8388604);
    try test__negsi2(8388604, -8388604);
    try test__negsi2(-8388600, 8388600);
    try test__negsi2(8388600, -8388600);
    try test__negsi2(-4194303, 4194303);
    try test__negsi2(4194303, -4194303);
    try test__negsi2(-4194302, 4194302);
    try test__negsi2(4194302, -4194302);
    try test__negsi2(-4194300, 4194300);
    try test__negsi2(4194300, -4194300);
    try test__negsi2(-4194296, 4194296);
    try test__negsi2(4194296, -4194296);
    try test__negsi2(-2097151, 2097151);
    try test__negsi2(2097151, -2097151);
    try test__negsi2(-2097150, 2097150);
    try test__negsi2(2097150, -2097150);
    try test__negsi2(-2097148, 2097148);
    try test__negsi2(2097148, -2097148);
    try test__negsi2(-2097144, 2097144);
    try test__negsi2(2097144, -2097144);
    try test__negsi2(-1048575, 1048575);
    try test__negsi2(1048575, -1048575);
    try test__negsi2(-1048574, 1048574);
    try test__negsi2(1048574, -1048574);
    try test__negsi2(-1048572, 1048572);
    try test__negsi2(1048572, -1048572);
    try test__negsi2(-1048568, 1048568);
    try test__negsi2(1048568, -1048568);
    try test__negsi2(-524287, 524287);
    try test__negsi2(524287, -524287);
    try test__negsi2(-524286, 524286);
    try test__negsi2(524286, -524286);
    try test__negsi2(-524284, 524284);
    try test__negsi2(524284, -524284);
    try test__negsi2(-524280, 524280);
    try test__negsi2(524280, -524280);
    try test__negsi2(-262143, 262143);
    try test__negsi2(262143, -262143);
    try test__negsi2(-262142, 262142);
    try test__negsi2(262142, -262142);
    try test__negsi2(-262140, 262140);
    try test__negsi2(262140, -262140);
    try test__negsi2(-262136, 262136);
    try test__negsi2(262136, -262136);
    try test__negsi2(-131071, 131071);
    try test__negsi2(131071, -131071);
    try test__negsi2(-131070, 131070);
    try test__negsi2(131070, -131070);
    try test__negsi2(-131068, 131068);
    try test__negsi2(131068, -131068);
    try test__negsi2(-131064, 131064);
    try test__negsi2(131064, -131064);
    try test__negsi2(-65535, 65535);
    try test__negsi2(65535, -65535);
    try test__negsi2(-65534, 65534);
    try test__negsi2(65534, -65534);
    try test__negsi2(-65532, 65532);
    try test__negsi2(65532, -65532);
    try test__negsi2(-65528, 65528);
    try test__negsi2(65528, -65528);
    try test__negsi2(-32767, 32767);
    try test__negsi2(32767, -32767);
    try test__negsi2(-32766, 32766);
    try test__negsi2(32766, -32766);
    try test__negsi2(-32764, 32764);
    try test__negsi2(32764, -32764);
    try test__negsi2(-32760, 32760);
    try test__negsi2(32760, -32760);
    try test__negsi2(-16383, 16383);
    try test__negsi2(16383, -16383);
    try test__negsi2(-16382, 16382);
    try test__negsi2(16382, -16382);
    try test__negsi2(-16380, 16380);
    try test__negsi2(16380, -16380);
    try test__negsi2(-16376, 16376);
    try test__negsi2(16376, -16376);
    try test__negsi2(-8191, 8191);
    try test__negsi2(8191, -8191);
    try test__negsi2(-8190, 8190);
    try test__negsi2(8190, -8190);
    try test__negsi2(-8188, 8188);
    try test__negsi2(8188, -8188);
    try test__negsi2(-8184, 8184);
    try test__negsi2(8184, -8184);
    try test__negsi2(-4095, 4095);
    try test__negsi2(4095, -4095);
    try test__negsi2(-4094, 4094);
    try test__negsi2(4094, -4094);
    try test__negsi2(-4092, 4092);
    try test__negsi2(4092, -4092);
    try test__negsi2(-4088, 4088);
    try test__negsi2(4088, -4088);
    try test__negsi2(-2047, 2047);
    try test__negsi2(2047, -2047);
    try test__negsi2(-2046, 2046);
    try test__negsi2(2046, -2046);
    try test__negsi2(-2044, 2044);
    try test__negsi2(2044, -2044);
    try test__negsi2(-2040, 2040);
    try test__negsi2(2040, -2040);
    try test__negsi2(-1023, 1023);
    try test__negsi2(1023, -1023);
    try test__negsi2(-1022, 1022);
    try test__negsi2(1022, -1022);
    try test__negsi2(-1020, 1020);
    try test__negsi2(1020, -1020);
    try test__negsi2(-1016, 1016);
    try test__negsi2(1016, -1016);
    try test__negsi2(-511, 511);
    try test__negsi2(511, -511);
    try test__negsi2(-510, 510);
    try test__negsi2(510, -510);
    try test__negsi2(-508, 508);
    try test__negsi2(508, -508);
    try test__negsi2(-504, 504);
    try test__negsi2(504, -504);
    try test__negsi2(-255, 255);
    try test__negsi2(255, -255);
    try test__negsi2(-254, 254);
    try test__negsi2(254, -254);
    try test__negsi2(-252, 252);
    try test__negsi2(252, -252);
    try test__negsi2(-248, 248);
    try test__negsi2(248, -248);
    try test__negsi2(-127, 127);
    try test__negsi2(127, -127);
    try test__negsi2(-126, 126);
    try test__negsi2(126, -126);
    try test__negsi2(-124, 124);
    try test__negsi2(124, -124);
    try test__negsi2(-120, 120);
    try test__negsi2(120, -120);
    try test__negsi2(-63, 63);
    try test__negsi2(63, -63);
    try test__negsi2(-62, 62);
    try test__negsi2(62, -62);
    try test__negsi2(-60, 60);
    try test__negsi2(60, -60);
    try test__negsi2(-56, 56);
    try test__negsi2(56, -56);
    try test__negsi2(-31, 31);
    try test__negsi2(31, -31);
    try test__negsi2(-30, 30);
    try test__negsi2(30, -30);
    try test__negsi2(-28, 28);
    try test__negsi2(28, -28);
    try test__negsi2(-24, 24);
    try test__negsi2(24, -24);
    try test__negsi2(-15, 15);
    try test__negsi2(15, -15);
    try test__negsi2(-14, 14);
    try test__negsi2(14, -14);
    try test__negsi2(-12, 12);
    try test__negsi2(12, -12);
    try test__negsi2(-8, 8);
    try test__negsi2(8, -8);
}
