#![allow(non_upper_case_globals)]

use rustc_span::symbol::PREDEFINED_SYMBOLS_COUNT;

#[doc(no_inline)]
pub use rustc_span::sym::*;

macro_rules! val {
    ($name:ident) => {
        stringify!($name)
    };
    ($name:ident $value:literal) => {
        $value
    };
}

macro_rules! generate {
    ($($name:ident $(: $value:literal)? ,)*) => {
        /// To be supplied to `rustc_interface::Config`
        pub const EXTRA_SYMBOLS: &[&str] = &[
            $(
                val!($name $($value)?),
            )*
        ];

        $(
            pub const $name: rustc_span::Symbol = rustc_span::Symbol::new(PREDEFINED_SYMBOLS_COUNT + ${index()});
        )*
    };
}

// List of extra symbols to be included in Clippy (for example, as `sym::ambiguous_glob_reexports`).
// An alternative content can be specified using a colon after the symbol name.
//
// `cargo dev fmt` ensures that the content of the `generate!()` macro call stays sorted.
generate! {
    AsyncReadExt,
    AsyncWriteExt,
    BACKSLASH_SINGLE_QUOTE: r"\'",
    Binary,
    CLIPPY_ARGS,
    CLIPPY_CONF_DIR,
    CRLF: "\r\n",
    Cargo_toml: "Cargo.toml",
    Current,
    DOUBLE_QUOTE: "\"",
    Deserialize,
    EarlyLintPass,
    ErrorKind,
    IntoIter,
    Itertools,
    LF: "\n",
    Lazy,
    Lint,
    LowerExp,
    LowerHex,
    MAX,
    MIN,
    MsrvStack,
    Octal,
    OpenOptions,
    Other,
    PathLookup,
    Regex,
    RegexBuilder,
    RegexSet,
    Start,
    Step,
    Symbol,
    SyntaxContext,
    TBD,
    UpperExp,
    UpperHex,
    V4,
    V6,
    Visitor,
    Weak,
    abs,
    ambiguous_glob_reexports,
    append,
    arg,
    as_bytes,
    as_deref,
    as_deref_mut,
    as_mut,
    as_path,
    assert_failed,
    author,
    borrow,
    borrow_mut,
    build_hasher,
    by_ref,
    bytes,
    capacity,
    cargo_clippy: "cargo-clippy",
    cast,
    cast_const,
    cast_mut,
    ceil,
    ceil_char_boundary,
    chain,
    chars,
    checked_abs,
    checked_add,
    checked_isqrt,
    checked_mul,
    checked_pow,
    checked_rem_euclid,
    checked_sub,
    clamp,
    clippy_utils,
    clone_into,
    cloned,
    cognitive_complexity,
    collect,
    const_ptr,
    contains,
    copied,
    copy_from,
    copy_from_nonoverlapping,
    copy_to,
    copy_to_nonoverlapping,
    count_ones,
    create,
    create_new,
    cycle,
    cyclomatic_complexity,
    de,
    diagnostics,
    disallowed_types,
    drain,
    dump,
    ends_with,
    enum_glob_use,
    enumerate,
    err,
    exp,
    expect_err,
    expn_data,
    extend,
    filter,
    filter_map,
    find,
    find_map,
    finish,
    finish_non_exhaustive,
    first,
    flat_map,
    flatten,
    floor,
    floor_char_boundary,
    fold,
    for_each,
    from_be_bytes,
    from_bytes_with_nul,
    from_bytes_with_nul_unchecked,
    from_le_bytes,
    from_ne_bytes,
    from_ptr,
    from_raw,
    from_ref,
    from_str,
    from_str_radix,
    fs,
    fuse,
    futures_util,
    get,
    get_mut,
    get_or_insert_with,
    get_unchecked,
    get_unchecked_mut,
    has_significant_drop,
    hidden_glob_reexports,
    hygiene,
    if_chain,
    insert,
    inspect,
    int_roundings,
    into,
    into_bytes,
    into_ok,
    into_owned,
    io,
    is_ascii,
    is_char_boundary,
    is_digit,
    is_empty,
    is_err,
    is_file,
    is_none,
    is_none_or,
    is_ok,
    is_some,
    is_some_and,
    isqrt,
    itertools,
    join,
    kw,
    last,
    lazy_static,
    ln,
    lock,
    lock_api,
    log,
    log10,
    log2,
    macro_use_imports,
    map_break,
    map_continue,
    map_or,
    map_or_else,
    match_indices,
    matches,
    max,
    max_by,
    max_by_key,
    max_value,
    maximum,
    mem,
    min,
    min_by,
    min_by_key,
    min_value,
    minimum,
    mode,
    module_name_repetitions,
    msrv,
    msrvs,
    mut_ptr,
    mutex,
    needless_return,
    next_back,
    next_if,
    next_if_eq,
    next_tuple,
    nth,
    ok,
    ok_or,
    once_cell,
    open,
    or_default,
    or_else,
    or_insert,
    or_insert_with,
    outer_expn,
    panic_cold_display,
    panic_cold_explicit,
    panic_display,
    panic_str,
    parse,
    partition,
    paths,
    peek,
    peek_mut,
    peekable,
    pow,
    powf,
    powi,
    product,
    push,
    read,
    read_exact,
    read_line,
    read_to_end,
    read_to_string,
    read_unaligned,
    redundant_pub_crate,
    regex,
    rem_euclid,
    repeat,
    replace,
    replacen,
    reserve,
    resize,
    restriction,
    rev,
    rfind,
    rmatch_indices,
    rmatches,
    round,
    rposition,
    rsplit,
    rsplit_once,
    rsplit_terminator,
    rsplitn,
    rsplitn_mut,
    rustc_lint,
    rustc_lint_defs,
    rustc_span,
    rustfmt_skip,
    rwlock,
    saturating_abs,
    saturating_pow,
    scan,
    seek,
    serde,
    set_len,
    set_mode,
    set_readonly,
    signum,
    single_component_path_imports,
    skip_while,
    slice_mut_unchecked,
    slice_unchecked,
    sort,
    sort_by,
    sort_unstable_by,
    span_lint_and_then,
    split,
    split_at,
    split_at_checked,
    split_at_mut,
    split_at_mut_checked,
    split_inclusive,
    split_once,
    split_terminator,
    split_whitespace,
    splitn,
    splitn_mut,
    sqrt,
    starts_with,
    step_by,
    strlen,
    style,
    subsec_micros,
    subsec_nanos,
    sum,
    symbol,
    take,
    take_while,
    then,
    then_some,
    to_ascii_lowercase,
    to_ascii_uppercase,
    to_be_bytes,
    to_digit,
    to_le_bytes,
    to_lowercase,
    to_ne_bytes,
    to_os_string,
    to_owned,
    to_path_buf,
    to_uppercase,
    tokio,
    trim,
    trim_end,
    trim_end_matches,
    trim_start,
    trim_start_matches,
    truncate,
    unreachable_pub,
    unsafe_removed_from_name,
    unused,
    unused_braces,
    unused_extern_crates,
    unused_import_braces,
    unused_trait_names,
    unwrap_err,
    unwrap_err_unchecked,
    unwrap_or_default,
    unwrap_or_else,
    unwrap_unchecked,
    unzip,
    utils,
    visit_str,
    visit_string,
    wake,
    warnings,
    wildcard_imports,
    with_capacity,
    wrapping_offset,
    write,
    write_unaligned,
    writeln,
    zip,
}
