# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.servicebus import ServiceBusManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestServiceBusManagementRulesOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(ServiceBusManagementClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_list_by_subscriptions(self, resource_group):
        response = self.client.rules.list_by_subscriptions(
            resource_group_name=resource_group.name,
            namespace_name="str",
            topic_name="str",
            subscription_name="str",
            api_version="2021-11-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_create_or_update(self, resource_group):
        response = self.client.rules.create_or_update(
            resource_group_name=resource_group.name,
            namespace_name="str",
            topic_name="str",
            subscription_name="str",
            rule_name="str",
            parameters={
                "action": {"compatibilityLevel": 0, "requiresPreprocessing": True, "sqlExpression": "str"},
                "correlationFilter": {
                    "contentType": "str",
                    "correlationId": "str",
                    "label": "str",
                    "messageId": "str",
                    "properties": {"str": "str"},
                    "replyTo": "str",
                    "replyToSessionId": "str",
                    "requiresPreprocessing": True,
                    "sessionId": "str",
                    "to": "str",
                },
                "filterType": "str",
                "id": "str",
                "location": "str",
                "name": "str",
                "sqlFilter": {"compatibilityLevel": 0, "requiresPreprocessing": True, "sqlExpression": "str"},
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "type": "str",
            },
            api_version="2021-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_delete(self, resource_group):
        response = self.client.rules.delete(
            resource_group_name=resource_group.name,
            namespace_name="str",
            topic_name="str",
            subscription_name="str",
            rule_name="str",
            api_version="2021-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_get(self, resource_group):
        response = self.client.rules.get(
            resource_group_name=resource_group.name,
            namespace_name="str",
            topic_name="str",
            subscription_name="str",
            rule_name="str",
            api_version="2021-11-01",
        )

        # please add some check logic here by yourself
        # ...
