FIND_PATH(LZO_INCLUDE_DIR NAMES lzo/lzo1x.h)
FIND_LIBRARY(LZO_LIBRARY NAMES lzo2)

include(FindPackageHandleStandardArgs)
FIND_PACKAGE_HANDLE_STANDARD_ARGS(
  LZO DEFAULT_MSG
  LZO_LIBRARY LZO_INCLUDE_DIR
  )

if(LZO_LIBRARY AND NOT TARGET lzo::lzo)
  add_library(lzo::lzo UNKNOWN IMPORTED)
  set_target_properties(lzo::lzo PROPERTIES
    INTERFACE_INCLUDE_DIRECTORIES "${LZO_INCLUDE_DIR}")
  set_target_properties(lzo::lzo PROPERTIES
    IMPORTED_LINK_INTERFACE_LANGUAGES "C"
    IMPORTED_LOCATION "${LZO_LIBRARY}")
endif()

mark_as_advanced(LZO_INCLUDE_DIR LZO_LIBRARY)
