
/*******************************  LICENSE  *******************************

 * (C) Copyright 1996-2016 ECMWF.
 *
 * This software is licensed under the terms of the Apache Licence Version 2.0
 * which can be obtained at http://www.apache.org/licenses/LICENSE-2.0.
 * In applying this licence, ECMWF does not waive the privileges and immunities
 * granted to it by virtue of its status as an intergovernmental organisation nor
 * does it submit to any jurisdiction.

 *******************************  LICENSE  *******************************/

/*! \fileIsoPlotAttributes.h
    \brief Definition of IsoPlot Attributes class.

    This file is automatically generated.
    Do Not Edit!

    Generated: 
*/


#ifndef IsoPlotWrapper_H
#define IsoPlotWrapper_H

#include "magics.h"
#include "ParameterManager.h"
#include "Factory.h"



#include "IsoPlot.h"








#include "ColourTechniqueWrapper.h"
#include "NoIsoHighlightWrapper.h"
#include "LevelSelectionWrapper.h"
#include "NoIsoLabelWrapper.h"
#include "NoIsoShadingWrapper.h"


namespace magics {

class MagRequest;



class IsoPlotWrapper

{
public:
//  --  constructor
    IsoPlotWrapper();
    IsoPlotWrapper(IsoPlot*);
//  --  destructor
    virtual ~IsoPlotWrapper();
    virtual void set(const MagRequest&);

    IsoPlot* me()   { return isoplot_; }

   	virtual IsoPlot* object() { return isoplot_; }


	virtual void object(IsoPlot* o) {
		// Remember to delete the previous object
		isoplot_ = o;
		

	}



protected:
    IsoPlot* isoplot_;


//  --  method
	virtual void print(ostream&) const;


private:
    string tag_;
	friend ostream& operator<<(ostream& s,const IsoPlotWrapper& p)
	{ p.print(s); return s; }
};

} // namespace magics

#endif