# NOTE: Assertions have been autogenerated by utils/update_mca_test_checks.py
# RUN: llvm-mca -mtriple=x86_64-unknown-unknown -mcpu=bdver2 -instruction-tables < %s | FileCheck %s

addsubpd  %xmm0, %xmm2
addsubpd  (%rax),  %xmm2

addsubps  %xmm0, %xmm2
addsubps  (%rax), %xmm2

haddpd    %xmm0, %xmm2
haddpd    (%rax), %xmm2

haddps    %xmm0, %xmm2
haddps    (%rax), %xmm2

hsubpd    %xmm0, %xmm2
hsubpd    (%rax), %xmm2

hsubps    %xmm0, %xmm2
hsubps    (%rax), %xmm2

lddqu     (%rax), %xmm2

monitor

movddup   %xmm0, %xmm2
movddup   (%rax), %xmm2

movshdup  %xmm0, %xmm2
movshdup  (%rax), %xmm2

movsldup  %xmm0, %xmm2
movsldup  (%rax), %xmm2

mwait

# CHECK:      Instruction Info:
# CHECK-NEXT: [1]: #uOps
# CHECK-NEXT: [2]: Latency
# CHECK-NEXT: [3]: RThroughput
# CHECK-NEXT: [4]: MayLoad
# CHECK-NEXT: [5]: MayStore
# CHECK-NEXT: [6]: HasSideEffects (U)

# CHECK:      [1]    [2]    [3]    [4]    [5]    [6]    Instructions:
# CHECK-NEXT:  1      5     1.00                        addsubpd	%xmm0, %xmm2
# CHECK-NEXT:  1      10    1.50    *                   addsubpd	(%rax), %xmm2
# CHECK-NEXT:  1      5     1.00                        addsubps	%xmm0, %xmm2
# CHECK-NEXT:  1      10    1.50    *                   addsubps	(%rax), %xmm2
# CHECK-NEXT:  3      11    2.50                        haddpd	%xmm0, %xmm2
# CHECK-NEXT:  4      16    2.50    *                   haddpd	(%rax), %xmm2
# CHECK-NEXT:  3      11    2.50                        haddps	%xmm0, %xmm2
# CHECK-NEXT:  4      16    2.50    *                   haddps	(%rax), %xmm2
# CHECK-NEXT:  3      11    2.50                        hsubpd	%xmm0, %xmm2
# CHECK-NEXT:  4      16    2.50    *                   hsubpd	(%rax), %xmm2
# CHECK-NEXT:  3      11    2.50                        hsubps	%xmm0, %xmm2
# CHECK-NEXT:  4      16    2.50    *                   hsubps	(%rax), %xmm2
# CHECK-NEXT:  1      5     1.50    *                   lddqu	(%rax), %xmm2
# CHECK-NEXT:  1      100   0.50                  U     monitor
# CHECK-NEXT:  1      2     1.00                        movddup	%xmm0, %xmm2
# CHECK-NEXT:  1      7     1.50    *                   movddup	(%rax), %xmm2
# CHECK-NEXT:  1      2     1.00                        movshdup	%xmm0, %xmm2
# CHECK-NEXT:  1      7     1.50    *                   movshdup	(%rax), %xmm2
# CHECK-NEXT:  1      2     1.00                        movsldup	%xmm0, %xmm2
# CHECK-NEXT:  1      7     1.50    *                   movsldup	(%rax), %xmm2
# CHECK-NEXT:  1      100   0.50    *      *      U     mwait

# CHECK:      Resources:
# CHECK-NEXT: [0.0] - PdAGLU01
# CHECK-NEXT: [0.1] - PdAGLU01
# CHECK-NEXT: [1]   - PdBranch
# CHECK-NEXT: [2]   - PdCount
# CHECK-NEXT: [3]   - PdDiv
# CHECK-NEXT: [4]   - PdEX0
# CHECK-NEXT: [5]   - PdEX1
# CHECK-NEXT: [6]   - PdFPCVT
# CHECK-NEXT: [7.0] - PdFPFMA
# CHECK-NEXT: [7.1] - PdFPFMA
# CHECK-NEXT: [8.0] - PdFPMAL
# CHECK-NEXT: [8.1] - PdFPMAL
# CHECK-NEXT: [9]   - PdFPMMA
# CHECK-NEXT: [10]  - PdFPSTO
# CHECK-NEXT: [11]  - PdFPU0
# CHECK-NEXT: [12]  - PdFPU1
# CHECK-NEXT: [13]  - PdFPU2
# CHECK-NEXT: [14]  - PdFPU3
# CHECK-NEXT: [15]  - PdFPXBR
# CHECK-NEXT: [16.0] - PdLoad
# CHECK-NEXT: [16.1] - PdLoad
# CHECK-NEXT: [17]  - PdMul
# CHECK-NEXT: [18]  - PdStore

# CHECK:      Resource pressure per iteration:
# CHECK-NEXT: [0.0]  [0.1]  [1]    [2]    [3]    [4]    [5]    [6]    [7.0]  [7.1]  [8.0]  [8.1]  [9]    [10]   [11]   [12]   [13]   [14]   [15]   [16.0] [16.1] [17]   [18]
# CHECK-NEXT: 15.00  15.00   -      -      -     1.00   1.00    -     28.00  28.00  1.50   1.50    -      -     15.50  3.50    -      -      -     15.00  15.00   -      -

# CHECK:      Resource pressure by instruction:
# CHECK-NEXT: [0.0]  [0.1]  [1]    [2]    [3]    [4]    [5]    [6]    [7.0]  [7.1]  [8.0]  [8.1]  [9]    [10]   [11]   [12]   [13]   [14]   [15]   [16.0] [16.1] [17]   [18]   Instructions:
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50    -      -      -      -     1.00    -      -      -      -      -      -      -      -     addsubpd	%xmm0, %xmm2
# CHECK-NEXT: 1.50   1.50    -      -      -      -      -      -     0.50   0.50    -      -      -      -     1.00    -      -      -      -     1.50   1.50    -      -     addsubpd	(%rax), %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50    -      -      -      -     1.00    -      -      -      -      -      -      -      -     addsubps	%xmm0, %xmm2
# CHECK-NEXT: 1.50   1.50    -      -      -      -      -      -     0.50   0.50    -      -      -      -     1.00    -      -      -      -     1.50   1.50    -      -     addsubps	(%rax), %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -     2.50   2.50    -      -      -      -     1.00    -      -      -      -      -      -      -      -     haddpd	%xmm0, %xmm2
# CHECK-NEXT: 1.50   1.50    -      -      -      -      -      -     2.50   2.50    -      -      -      -     1.00    -      -      -      -     1.50   1.50    -      -     haddpd	(%rax), %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -     2.50   2.50    -      -      -      -     1.00    -      -      -      -      -      -      -      -     haddps	%xmm0, %xmm2
# CHECK-NEXT: 1.50   1.50    -      -      -      -      -      -     2.50   2.50    -      -      -      -     1.00    -      -      -      -     1.50   1.50    -      -     haddps	(%rax), %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -     2.50   2.50    -      -      -      -     1.00    -      -      -      -      -      -      -      -     hsubpd	%xmm0, %xmm2
# CHECK-NEXT: 1.50   1.50    -      -      -      -      -      -     2.50   2.50    -      -      -      -     1.00    -      -      -      -     1.50   1.50    -      -     hsubpd	(%rax), %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -     2.50   2.50    -      -      -      -     1.00    -      -      -      -      -      -      -      -     hsubps	%xmm0, %xmm2
# CHECK-NEXT: 1.50   1.50    -      -      -      -      -      -     2.50   2.50    -      -      -      -     1.00    -      -      -      -     1.50   1.50    -      -     hsubps	(%rax), %xmm2
# CHECK-NEXT: 1.50   1.50    -      -      -      -      -      -      -      -     1.50   1.50    -      -     0.50   0.50    -      -      -     1.50   1.50    -      -     lddqu	(%rax), %xmm2
# CHECK-NEXT:  -      -      -      -      -     0.50   0.50    -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -     monitor
# CHECK-NEXT:  -      -      -      -      -      -      -      -     1.00   1.00    -      -      -      -     0.50   0.50    -      -      -      -      -      -      -     movddup	%xmm0, %xmm2
# CHECK-NEXT: 1.50   1.50    -      -      -      -      -      -     1.00   1.00    -      -      -      -     0.50   0.50    -      -      -     1.50   1.50    -      -     movddup	(%rax), %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -     1.00   1.00    -      -      -      -     0.50   0.50    -      -      -      -      -      -      -     movshdup	%xmm0, %xmm2
# CHECK-NEXT: 1.50   1.50    -      -      -      -      -      -     1.00   1.00    -      -      -      -     0.50   0.50    -      -      -     1.50   1.50    -      -     movshdup	(%rax), %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -     1.00   1.00    -      -      -      -     0.50   0.50    -      -      -      -      -      -      -     movsldup	%xmm0, %xmm2
# CHECK-NEXT: 1.50   1.50    -      -      -      -      -      -     1.00   1.00    -      -      -      -     0.50   0.50    -      -      -     1.50   1.50    -      -     movsldup	(%rax), %xmm2
# CHECK-NEXT:  -      -      -      -      -     0.50   0.50    -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -     mwait
