; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -verify-scev -passes='loop(require<iv-users>),loop-mssa(loop-simplifycfg)' -S %s | FileCheck --check-prefixes=CHECK,IVUSERS %s
; RUN: opt -verify-scev -passes="indvars,loop-simplifycfg" -S %s | FileCheck --check-prefixes=CHECK,INDVARS %s

target datalayout = "p:16:16-n16:32"

define void @test_pr58179_remove_dead_block_from_loop() {
; CHECK-LABEL: @test_pr58179_remove_dead_block_from_loop(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[A:%.*]] = alloca [10 x i64], align 1
; CHECK-NEXT:    br label [[OUTER_HEADER:%.*]]
; CHECK:       outer.header:
; CHECK-NEXT:    br label [[OUTER_HEADER]]
;
entry:
  %a = alloca [10 x i64], align 1
  br label %outer.header

outer.header:
  br i1 false, label %inner, label %outer.header

inner:
  %iv = phi i16 [ 0, %outer.header ], [ %iv.next, %inner ]
  %gep = getelementptr inbounds [10 x i64], ptr %a, i32 0, i16 %iv
  store i64 0, ptr %gep
  %iv.next = add nsw i16 %iv, 1
  br i1 false, label %inner, label %outer.header
}

define void @test_remove_instrs_in_exit_block() {
; IVUSERS-LABEL: @test_remove_instrs_in_exit_block(
; IVUSERS-NEXT:  entry:
; IVUSERS-NEXT:    [[A:%.*]] = alloca [10 x i64], align 1
; IVUSERS-NEXT:    br label [[OUTER_HEADER:%.*]]
; IVUSERS:       outer.header:
; IVUSERS-NEXT:    [[OUTER_IV:%.*]] = phi i16 [ 0, [[ENTRY:%.*]] ], [ [[OUTER_IV_NEXT:%.*]], [[OUTER_LATCH:%.*]] ]
; IVUSERS-NEXT:    switch i32 0, label [[OUTER_HEADER_SPLIT:%.*]] [
; IVUSERS-NEXT:    i32 1, label [[OUTER_LATCH]]
; IVUSERS-NEXT:    ]
; IVUSERS:       outer.header.split:
; IVUSERS-NEXT:    br label [[INNER:%.*]]
; IVUSERS:       inner:
; IVUSERS-NEXT:    [[IV:%.*]] = phi i16 [ 0, [[OUTER_HEADER_SPLIT]] ], [ [[IV_NEXT:%.*]], [[INNER]] ]
; IVUSERS-NEXT:    [[GEP:%.*]] = getelementptr inbounds [10 x i64], ptr [[A]], i32 0, i16 [[IV]]
; IVUSERS-NEXT:    store i64 0, ptr [[GEP]], align 4
; IVUSERS-NEXT:    [[L:%.*]] = call i16 @get()
; IVUSERS-NEXT:    [[IV_NEXT]] = add nsw i16 [[IV]], 1
; IVUSERS-NEXT:    br label [[INNER]]
; IVUSERS:       outer.latch:
; IVUSERS-NEXT:    [[OUTER_IV_NEXT]] = add nsw i16 [[OUTER_IV]], 1
; IVUSERS-NEXT:    [[CMP_2:%.*]] = icmp eq i16 poison, [[OUTER_IV]]
; IVUSERS-NEXT:    br i1 [[CMP_2]], label [[OUTER_HEADER]], label [[EXIT:%.*]]
; IVUSERS:       exit:
; IVUSERS-NEXT:    ret void
;
; INDVARS-LABEL: @test_remove_instrs_in_exit_block(
; INDVARS-NEXT:  entry:
; INDVARS-NEXT:    [[A:%.*]] = alloca [10 x i64], align 1
; INDVARS-NEXT:    br label [[OUTER_HEADER:%.*]]
; INDVARS:       outer.header:
; INDVARS-NEXT:    [[OUTER_IV:%.*]] = phi i16 [ 0, [[ENTRY:%.*]] ], [ [[OUTER_IV_NEXT:%.*]], [[OUTER_LATCH:%.*]] ]
; INDVARS-NEXT:    switch i32 0, label [[OUTER_HEADER_SPLIT:%.*]] [
; INDVARS-NEXT:    i32 1, label [[OUTER_LATCH]]
; INDVARS-NEXT:    ]
; INDVARS:       outer.header.split:
; INDVARS-NEXT:    br label [[INNER:%.*]]
; INDVARS:       inner:
; INDVARS-NEXT:    [[IV:%.*]] = phi i16 [ 0, [[OUTER_HEADER_SPLIT]] ], [ [[IV_NEXT:%.*]], [[INNER]] ]
; INDVARS-NEXT:    [[GEP:%.*]] = getelementptr inbounds [10 x i64], ptr [[A]], i32 0, i16 [[IV]]
; INDVARS-NEXT:    store i64 0, ptr [[GEP]], align 4
; INDVARS-NEXT:    [[L:%.*]] = call i16 @get()
; INDVARS-NEXT:    [[IV_NEXT]] = add nuw nsw i16 [[IV]], 1
; INDVARS-NEXT:    br label [[INNER]]
; INDVARS:       outer.latch:
; INDVARS-NEXT:    [[OUTER_IV_NEXT]] = add nuw nsw i16 [[OUTER_IV]], 1
; INDVARS-NEXT:    [[CMP_2:%.*]] = icmp eq i16 poison, [[OUTER_IV]]
; INDVARS-NEXT:    br i1 [[CMP_2]], label [[OUTER_HEADER]], label [[EXIT:%.*]]
; INDVARS:       exit:
; INDVARS-NEXT:    ret void
;
entry:
  %a = alloca [10 x i64], align 1
  br label %outer.header

outer.header:
  %outer.iv = phi i16 [ 0, %entry ], [ %outer.iv.next, %outer.latch ]
  br label %inner

inner:
  %iv = phi i16 [ 0, %outer.header ], [ %iv.next, %inner ]
  %gep = getelementptr inbounds [10 x i64], ptr %a, i32 0, i16 %iv
  store i64 0, ptr %gep
  %l = call i16 @get()
  %iv.next = add nsw i16 %iv, 1
  br i1 true, label %inner, label %outer.latch

outer.latch:
  %l.lcssa = phi i16 [ %l, %inner ]
  %outer.iv.next = add nsw i16 %outer.iv, 1
  %cmp.2 = icmp eq i16 %l.lcssa, %outer.iv
  br i1 %cmp.2, label %outer.header, label %exit

exit:
  ret void
}

declare i16 @get()

define i32 @test_pr58489(i32 %a) {
; CHECK-LABEL: @test_pr58489(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[C_1:%.*]] = icmp slt i32 [[A:%.*]], -23
; CHECK-NEXT:    call void @llvm.assume(i1 [[C_1]])
; CHECK-NEXT:    switch i32 0, label [[ENTRY_SPLIT:%.*]] [
; CHECK-NEXT:    i32 1, label [[EXIT:%.*]]
; CHECK-NEXT:    ]
; CHECK:       entry.split:
; CHECK-NEXT:    br label [[LOOP_HEADER:%.*]]
; CHECK:       loop.header:
; CHECK-NEXT:    [[P:%.*]] = phi i32 [ 0, [[ENTRY_SPLIT]] ], [ [[SHIFT:%.*]], [[LOOP_HEADER]] ]
; CHECK-NEXT:    [[C_2:%.*]] = icmp ne i32 [[P]], 0
; CHECK-NEXT:    [[C_2_EXT:%.*]] = zext i1 [[C_2]] to i16
; CHECK-NEXT:    call void @use(i16 [[C_2_EXT]])
; CHECK-NEXT:    [[SHIFT]] = ashr exact i32 [[A]], 16
; CHECK-NEXT:    br label [[LOOP_HEADER]]
; CHECK:       exit:
; CHECK-NEXT:    ret i32 poison
;
entry:
  %c.1 = icmp slt i32 %a, -23
  call void @llvm.assume(i1 %c.1)
  br label %loop.header

loop.header:
  %p = phi i32 [ 0, %entry ], [ %shift, %loop.latch ]
  br label %loop.latch

loop.latch:
  %c.2 = icmp ne i32 %p, 0
  %c.2.ext = zext i1 %c.2 to i16
  call void @use(i16 %c.2.ext)
  %shift = ashr exact i32 %a, 16
  switch i32 50, label %exit [
  i32 50, label %loop.header
  ]

exit:
  %shift.lcssa = phi i32 [ %shift, %loop.latch ]
  ret i32 %shift.lcssa
}

declare void @llvm.assume(i1 noundef) #0

declare void @use(i16)
