; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -passes=instcombine -S | FileCheck %s

declare i16 @llvm.bswap.i16(i16)
declare i32 @llvm.bswap.i32(i32)
declare <2 x i64> @llvm.bswap.v2i64(<2 x i64>)
declare i32 @llvm.cttz.i32(i32, i1)
declare i33 @llvm.cttz.i33(i33, i1)
declare i32 @llvm.ctlz.i32(i32, i1)
declare i8 @llvm.umax.i8(i8, i8)
declare i8 @llvm.uadd.sat.i8(i8, i8)
declare i8 @llvm.ssub.sat.i8(i8, i8)
declare i33 @llvm.ctlz.i33(i33, i1)
declare i8 @llvm.ctpop.i8(i8)
declare i11 @llvm.ctpop.i11(i11)
declare <2 x i32> @llvm.cttz.v2i32(<2 x i32>, i1)
declare <2 x i32> @llvm.ctlz.v2i32(<2 x i32>, i1)
declare <2 x i32> @llvm.ctpop.v2i32(<2 x i32>)
declare i8 @llvm.bitreverse.i8(i8)
declare <2 x i8> @llvm.bitreverse.v2i8(<2 x i8>)
declare void @use6(i6)
declare void @use8(i8)

define i1 @bswap_eq_i16(i16 %x) {
; CHECK-LABEL: @bswap_eq_i16(
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq i16 [[X:%.*]], 256
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %bs = call i16 @llvm.bswap.i16(i16 %x)
  %cmp = icmp eq i16 %bs, 1
  ret i1 %cmp
}

define i1 @bswap_ne_i32(i32 %x) {
; CHECK-LABEL: @bswap_ne_i32(
; CHECK-NEXT:    [[CMP:%.*]] = icmp ne i32 [[X:%.*]], 33554432
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %bs = tail call i32 @llvm.bswap.i32(i32 %x)
  %cmp = icmp ne i32 %bs, 2
  ret i1 %cmp
}

define <2 x i1> @bswap_eq_v2i64(<2 x i64> %x) {
; CHECK-LABEL: @bswap_eq_v2i64(
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq <2 x i64> [[X:%.*]], <i64 216172782113783808, i64 216172782113783808>
; CHECK-NEXT:    ret <2 x i1> [[CMP]]
;
  %bs = tail call <2 x i64> @llvm.bswap.v2i64(<2 x i64> %x)
  %cmp = icmp eq <2 x i64> %bs, <i64 3, i64 3>
  ret <2 x i1> %cmp
}

define i1 @ctlz_eq_bitwidth_i32(i32 %x) {
; CHECK-LABEL: @ctlz_eq_bitwidth_i32(
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq i32 [[X:%.*]], 0
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %lz = tail call i32 @llvm.ctlz.i32(i32 %x, i1 false)
  %cmp = icmp eq i32 %lz, 32
  ret i1 %cmp
}

define i1 @ctlz_eq_zero_i32(i32 %x) {
; CHECK-LABEL: @ctlz_eq_zero_i32(
; CHECK-NEXT:    [[CMP:%.*]] = icmp slt i32 [[X:%.*]], 0
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %lz = tail call i32 @llvm.ctlz.i32(i32 %x, i1 false)
  %cmp = icmp eq i32 %lz, 0
  ret i1 %cmp
}

define <2 x i1> @ctlz_ne_zero_v2i32(<2 x i32> %a) {
; CHECK-LABEL: @ctlz_ne_zero_v2i32(
; CHECK-NEXT:    [[CMP:%.*]] = icmp sgt <2 x i32> [[A:%.*]], <i32 -1, i32 -1>
; CHECK-NEXT:    ret <2 x i1> [[CMP]]
;
  %x = tail call <2 x i32> @llvm.ctlz.v2i32(<2 x i32> %a, i1 false)
  %cmp = icmp ne <2 x i32> %x, zeroinitializer
  ret <2 x i1> %cmp
}

define i1 @ctlz_eq_bw_minus_1_i32(i32 %x) {
; CHECK-LABEL: @ctlz_eq_bw_minus_1_i32(
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq i32 [[X:%.*]], 1
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %lz = tail call i32 @llvm.ctlz.i32(i32 %x, i1 false)
  %cmp = icmp eq i32 %lz, 31
  ret i1 %cmp
}

define <2 x i1> @ctlz_ne_bw_minus_1_v2i32(<2 x i32> %a) {
; CHECK-LABEL: @ctlz_ne_bw_minus_1_v2i32(
; CHECK-NEXT:    [[CMP:%.*]] = icmp ne <2 x i32> [[A:%.*]], <i32 1, i32 1>
; CHECK-NEXT:    ret <2 x i1> [[CMP]]
;
  %x = tail call <2 x i32> @llvm.ctlz.v2i32(<2 x i32> %a, i1 false)
  %cmp = icmp ne <2 x i32> %x, <i32 31, i32 31>
  ret <2 x i1> %cmp
}

define i1 @ctlz_eq_other_i32(i32 %x) {
; CHECK-LABEL: @ctlz_eq_other_i32(
; CHECK-NEXT:    [[TMP1:%.*]] = and i32 [[X:%.*]], -128
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq i32 [[TMP1]], 128
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %lz = tail call i32 @llvm.ctlz.i32(i32 %x, i1 false)
  %cmp = icmp eq i32 %lz, 24
  ret i1 %cmp
}

define <2 x i1> @ctlz_ne_other_v2i32(<2 x i32> %a) {
; CHECK-LABEL: @ctlz_ne_other_v2i32(
; CHECK-NEXT:    [[TMP1:%.*]] = and <2 x i32> [[A:%.*]], <i32 -128, i32 -128>
; CHECK-NEXT:    [[CMP:%.*]] = icmp ne <2 x i32> [[TMP1]], <i32 128, i32 128>
; CHECK-NEXT:    ret <2 x i1> [[CMP]]
;
  %x = tail call <2 x i32> @llvm.ctlz.v2i32(<2 x i32> %a, i1 false)
  %cmp = icmp ne <2 x i32> %x, <i32 24, i32 24>
  ret <2 x i1> %cmp
}

define i1 @ctlz_eq_other_i32_multiuse(i32 %x, ptr %p) {
; CHECK-LABEL: @ctlz_eq_other_i32_multiuse(
; CHECK-NEXT:    [[LZ:%.*]] = tail call range(i32 0, 33) i32 @llvm.ctlz.i32(i32 [[X:%.*]], i1 false)
; CHECK-NEXT:    store i32 [[LZ]], ptr [[P:%.*]], align 4
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq i32 [[LZ]], 24
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %lz = tail call i32 @llvm.ctlz.i32(i32 %x, i1 false)
  store i32 %lz, ptr %p
  %cmp = icmp eq i32 %lz, 24
  ret i1 %cmp
}

define <2 x i1> @ctlz_ne_bitwidth_v2i32(<2 x i32> %a) {
; CHECK-LABEL: @ctlz_ne_bitwidth_v2i32(
; CHECK-NEXT:    [[CMP:%.*]] = icmp ne <2 x i32> [[A:%.*]], zeroinitializer
; CHECK-NEXT:    ret <2 x i1> [[CMP]]
;
  %x = tail call <2 x i32> @llvm.ctlz.v2i32(<2 x i32> %a, i1 false)
  %cmp = icmp ne <2 x i32> %x, <i32 32, i32 32>
  ret <2 x i1> %cmp
}

define i1 @ctlz_ugt_zero_i32(i32 %x) {
; CHECK-LABEL: @ctlz_ugt_zero_i32(
; CHECK-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[X:%.*]], -1
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %lz = tail call i32 @llvm.ctlz.i32(i32 %x, i1 false)
  %cmp = icmp ugt i32 %lz, 0
  ret i1 %cmp
}

define i1 @ctlz_ugt_one_i32(i32 %x) {
; CHECK-LABEL: @ctlz_ugt_one_i32(
; CHECK-NEXT:    [[CMP:%.*]] = icmp ult i32 [[X:%.*]], 1073741824
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %lz = tail call i32 @llvm.ctlz.i32(i32 %x, i1 false)
  %cmp = icmp ugt i32 %lz, 1
  ret i1 %cmp
}

define i1 @ctlz_ugt_other_i32(i32 %x) {
; CHECK-LABEL: @ctlz_ugt_other_i32(
; CHECK-NEXT:    [[CMP:%.*]] = icmp ult i32 [[X:%.*]], 32768
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %lz = tail call i32 @llvm.ctlz.i32(i32 %x, i1 false)
  %cmp = icmp ugt i32 %lz, 16
  ret i1 %cmp
}

define i1 @ctlz_ugt_other_multiuse_i32(i32 %x, ptr %p) {
; CHECK-LABEL: @ctlz_ugt_other_multiuse_i32(
; CHECK-NEXT:    [[LZ:%.*]] = tail call range(i32 0, 33) i32 @llvm.ctlz.i32(i32 [[X:%.*]], i1 false)
; CHECK-NEXT:    store i32 [[LZ]], ptr [[P:%.*]], align 4
; CHECK-NEXT:    [[CMP:%.*]] = icmp ult i32 [[X]], 32768
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %lz = tail call i32 @llvm.ctlz.i32(i32 %x, i1 false)
  store i32 %lz, ptr %p
  %cmp = icmp ugt i32 %lz, 16
  ret i1 %cmp
}

define i1 @ctlz_ugt_bw_minus_one_i32(i32 %x) {
; CHECK-LABEL: @ctlz_ugt_bw_minus_one_i32(
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq i32 [[X:%.*]], 0
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %lz = tail call i32 @llvm.ctlz.i32(i32 %x, i1 false)
  %cmp = icmp ugt i32 %lz, 31
  ret i1 %cmp
}

define <2 x i1> @ctlz_ult_one_v2i32(<2 x i32> %x) {
; CHECK-LABEL: @ctlz_ult_one_v2i32(
; CHECK-NEXT:    [[CMP:%.*]] = icmp slt <2 x i32> [[X:%.*]], zeroinitializer
; CHECK-NEXT:    ret <2 x i1> [[CMP]]
;
  %lz = tail call <2 x i32> @llvm.ctlz.v2i32(<2 x i32> %x, i1 false)
  %cmp = icmp ult <2 x i32> %lz, <i32 1, i32 1>
  ret <2 x i1> %cmp
}

define <2 x i1> @ctlz_ult_other_v2i32(<2 x i32> %x) {
; CHECK-LABEL: @ctlz_ult_other_v2i32(
; CHECK-NEXT:    [[CMP:%.*]] = icmp ugt <2 x i32> [[X:%.*]], <i32 65535, i32 65535>
; CHECK-NEXT:    ret <2 x i1> [[CMP]]
;
  %lz = tail call <2 x i32> @llvm.ctlz.v2i32(<2 x i32> %x, i1 false)
  %cmp = icmp ult <2 x i32> %lz, <i32 16, i32 16>
  ret <2 x i1> %cmp
}

define <2 x i1> @ctlz_ult_other_multiuse_v2i32(<2 x i32> %x, ptr %p) {
; CHECK-LABEL: @ctlz_ult_other_multiuse_v2i32(
; CHECK-NEXT:    [[LZ:%.*]] = tail call range(i32 0, 33) <2 x i32> @llvm.ctlz.v2i32(<2 x i32> [[X:%.*]], i1 false)
; CHECK-NEXT:    store <2 x i32> [[LZ]], ptr [[P:%.*]], align 8
; CHECK-NEXT:    [[CMP:%.*]] = icmp ugt <2 x i32> [[X]], <i32 65535, i32 65535>
; CHECK-NEXT:    ret <2 x i1> [[CMP]]
;
  %lz = tail call <2 x i32> @llvm.ctlz.v2i32(<2 x i32> %x, i1 false)
  store <2 x i32> %lz, ptr %p
  %cmp = icmp ult <2 x i32> %lz, <i32 16, i32 16>
  ret <2 x i1> %cmp
}

define <2 x i1> @ctlz_ult_bw_minus_one_v2i32(<2 x i32> %x) {
; CHECK-LABEL: @ctlz_ult_bw_minus_one_v2i32(
; CHECK-NEXT:    [[CMP:%.*]] = icmp ugt <2 x i32> [[X:%.*]], <i32 1, i32 1>
; CHECK-NEXT:    ret <2 x i1> [[CMP]]
;
  %lz = tail call <2 x i32> @llvm.ctlz.v2i32(<2 x i32> %x, i1 false)
  %cmp = icmp ult <2 x i32> %lz, <i32 31, i32 31>
  ret <2 x i1> %cmp
}

define <2 x i1> @ctlz_ult_bitwidth_v2i32(<2 x i32> %x) {
; CHECK-LABEL: @ctlz_ult_bitwidth_v2i32(
; CHECK-NEXT:    [[CMP:%.*]] = icmp ne <2 x i32> [[X:%.*]], zeroinitializer
; CHECK-NEXT:    ret <2 x i1> [[CMP]]
;
  %lz = tail call <2 x i32> @llvm.ctlz.v2i32(<2 x i32> %x, i1 false)
  %cmp = icmp ult <2 x i32> %lz, <i32 32, i32 32>
  ret <2 x i1> %cmp
}

define i1 @cttz_ne_bitwidth_i33(i33 %x) {
; CHECK-LABEL: @cttz_ne_bitwidth_i33(
; CHECK-NEXT:    [[CMP:%.*]] = icmp ne i33 [[X:%.*]], 0
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %tz = tail call i33 @llvm.cttz.i33(i33 %x, i1 false)
  %cmp = icmp ne i33 %tz, 33
  ret i1 %cmp
}

define <2 x i1> @cttz_eq_bitwidth_v2i32(<2 x i32> %a) {
; CHECK-LABEL: @cttz_eq_bitwidth_v2i32(
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq <2 x i32> [[A:%.*]], zeroinitializer
; CHECK-NEXT:    ret <2 x i1> [[CMP]]
;
  %x = tail call <2 x i32> @llvm.cttz.v2i32(<2 x i32> %a, i1 false)
  %cmp = icmp eq <2 x i32> %x, <i32 32, i32 32>
  ret <2 x i1> %cmp
}

define i1 @cttz_eq_zero_i33(i33 %x) {
; CHECK-LABEL: @cttz_eq_zero_i33(
; CHECK-NEXT:    [[TMP1:%.*]] = and i33 [[X:%.*]], 1
; CHECK-NEXT:    [[CMP:%.*]] = icmp ne i33 [[TMP1]], 0
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %tz = tail call i33 @llvm.cttz.i33(i33 %x, i1 false)
  %cmp = icmp eq i33 %tz, 0
  ret i1 %cmp
}

define <2 x i1> @cttz_ne_zero_v2i32(<2 x i32> %a) {
; CHECK-LABEL: @cttz_ne_zero_v2i32(
; CHECK-NEXT:    [[TMP1:%.*]] = and <2 x i32> [[A:%.*]], <i32 1, i32 1>
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq <2 x i32> [[TMP1]], zeroinitializer
; CHECK-NEXT:    ret <2 x i1> [[CMP]]
;
  %x = tail call <2 x i32> @llvm.cttz.v2i32(<2 x i32> %a, i1 false)
  %cmp = icmp ne <2 x i32> %x, zeroinitializer
  ret <2 x i1> %cmp
}

define i1 @cttz_eq_bw_minus_1_i33(i33 %x) {
; CHECK-LABEL: @cttz_eq_bw_minus_1_i33(
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq i33 [[X:%.*]], -4294967296
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %tz = tail call i33 @llvm.cttz.i33(i33 %x, i1 false)
  %cmp = icmp eq i33 %tz, 32
  ret i1 %cmp
}

define <2 x i1> @cttz_ne_bw_minus_1_v2i32(<2 x i32> %a) {
; CHECK-LABEL: @cttz_ne_bw_minus_1_v2i32(
; CHECK-NEXT:    [[CMP:%.*]] = icmp ne <2 x i32> [[A:%.*]], <i32 -2147483648, i32 -2147483648>
; CHECK-NEXT:    ret <2 x i1> [[CMP]]
;
  %x = tail call <2 x i32> @llvm.cttz.v2i32(<2 x i32> %a, i1 false)
  %cmp = icmp ne <2 x i32> %x, <i32 31, i32 31>
  ret <2 x i1> %cmp
}

define i1 @cttz_eq_other_i33(i33 %x) {
; CHECK-LABEL: @cttz_eq_other_i33(
; CHECK-NEXT:    [[TMP1:%.*]] = and i33 [[X:%.*]], 31
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq i33 [[TMP1]], 16
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %tz = tail call i33 @llvm.cttz.i33(i33 %x, i1 false)
  %cmp = icmp eq i33 %tz, 4
  ret i1 %cmp
}

define <2 x i1> @cttz_ne_other_v2i32(<2 x i32> %a) {
; CHECK-LABEL: @cttz_ne_other_v2i32(
; CHECK-NEXT:    [[TMP1:%.*]] = and <2 x i32> [[A:%.*]], <i32 31, i32 31>
; CHECK-NEXT:    [[CMP:%.*]] = icmp ne <2 x i32> [[TMP1]], <i32 16, i32 16>
; CHECK-NEXT:    ret <2 x i1> [[CMP]]
;
  %x = tail call <2 x i32> @llvm.cttz.v2i32(<2 x i32> %a, i1 false)
  %cmp = icmp ne <2 x i32> %x, <i32 4, i32 4>
  ret <2 x i1> %cmp
}

define i1 @cttz_eq_other_i33_multiuse(i33 %x, ptr %p) {
; CHECK-LABEL: @cttz_eq_other_i33_multiuse(
; CHECK-NEXT:    [[TZ:%.*]] = tail call range(i33 0, 34) i33 @llvm.cttz.i33(i33 [[X:%.*]], i1 false)
; CHECK-NEXT:    store i33 [[TZ]], ptr [[P:%.*]], align 4
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq i33 [[TZ]], 4
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %tz = tail call i33 @llvm.cttz.i33(i33 %x, i1 false)
  store i33 %tz, ptr %p
  %cmp = icmp eq i33 %tz, 4
  ret i1 %cmp
}

define i1 @cttz_ugt_zero_i33(i33 %x) {
; CHECK-LABEL: @cttz_ugt_zero_i33(
; CHECK-NEXT:    [[TMP1:%.*]] = and i33 [[X:%.*]], 1
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq i33 [[TMP1]], 0
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %tz = tail call i33 @llvm.cttz.i33(i33 %x, i1 false)
  %cmp = icmp ugt i33 %tz, 0
  ret i1 %cmp
}

define i1 @cttz_ugt_one_i33(i33 %x) {
; CHECK-LABEL: @cttz_ugt_one_i33(
; CHECK-NEXT:    [[TMP1:%.*]] = and i33 [[X:%.*]], 3
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq i33 [[TMP1]], 0
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %tz = tail call i33 @llvm.cttz.i33(i33 %x, i1 false)
  %cmp = icmp ugt i33 %tz, 1
  ret i1 %cmp
}

define i1 @cttz_ugt_other_i33(i33 %x) {
; CHECK-LABEL: @cttz_ugt_other_i33(
; CHECK-NEXT:    [[TMP1:%.*]] = and i33 [[X:%.*]], 131071
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq i33 [[TMP1]], 0
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %tz = tail call i33 @llvm.cttz.i33(i33 %x, i1 false)
  %cmp = icmp ugt i33 %tz, 16
  ret i1 %cmp
}

define i1 @cttz_ugt_other_multiuse_i33(i33 %x, ptr %p) {
; CHECK-LABEL: @cttz_ugt_other_multiuse_i33(
; CHECK-NEXT:    [[TZ:%.*]] = tail call range(i33 0, 34) i33 @llvm.cttz.i33(i33 [[X:%.*]], i1 false)
; CHECK-NEXT:    store i33 [[TZ]], ptr [[P:%.*]], align 4
; CHECK-NEXT:    [[CMP:%.*]] = icmp ugt i33 [[TZ]], 16
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %tz = tail call i33 @llvm.cttz.i33(i33 %x, i1 false)
  store i33 %tz, ptr %p
  %cmp = icmp ugt i33 %tz, 16
  ret i1 %cmp
}

define i1 @cttz_ugt_bw_minus_one_i33(i33 %x) {
; CHECK-LABEL: @cttz_ugt_bw_minus_one_i33(
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq i33 [[X:%.*]], 0
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %tz = tail call i33 @llvm.cttz.i33(i33 %x, i1 false)
  %cmp = icmp ugt i33 %tz, 32
  ret i1 %cmp
}

define <2 x i1> @cttz_ult_one_v2i32(<2 x i32> %x) {
; CHECK-LABEL: @cttz_ult_one_v2i32(
; CHECK-NEXT:    [[CMP:%.*]] = trunc <2 x i32> [[X:%.*]] to <2 x i1>
; CHECK-NEXT:    ret <2 x i1> [[CMP]]
;
  %tz = tail call <2 x i32> @llvm.cttz.v2i32(<2 x i32> %x, i1 false)
  %cmp = icmp ult <2 x i32> %tz, <i32 1, i32 1>
  ret <2 x i1> %cmp
}

define <2 x i1> @cttz_ult_other_v2i32(<2 x i32> %x) {
; CHECK-LABEL: @cttz_ult_other_v2i32(
; CHECK-NEXT:    [[TMP1:%.*]] = and <2 x i32> [[X:%.*]], <i32 65535, i32 65535>
; CHECK-NEXT:    [[CMP:%.*]] = icmp ne <2 x i32> [[TMP1]], zeroinitializer
; CHECK-NEXT:    ret <2 x i1> [[CMP]]
;
  %tz = tail call <2 x i32> @llvm.cttz.v2i32(<2 x i32> %x, i1 false)
  %cmp = icmp ult <2 x i32> %tz, <i32 16, i32 16>
  ret <2 x i1> %cmp
}

define <2 x i1> @cttz_ult_other_multiuse_v2i32(<2 x i32> %x, ptr %p) {
; CHECK-LABEL: @cttz_ult_other_multiuse_v2i32(
; CHECK-NEXT:    [[TZ:%.*]] = tail call range(i32 0, 33) <2 x i32> @llvm.cttz.v2i32(<2 x i32> [[X:%.*]], i1 false)
; CHECK-NEXT:    store <2 x i32> [[TZ]], ptr [[P:%.*]], align 8
; CHECK-NEXT:    [[CMP:%.*]] = icmp ult <2 x i32> [[TZ]], <i32 16, i32 16>
; CHECK-NEXT:    ret <2 x i1> [[CMP]]
;
  %tz = tail call <2 x i32> @llvm.cttz.v2i32(<2 x i32> %x, i1 false)
  store <2 x i32> %tz, ptr %p
  %cmp = icmp ult <2 x i32> %tz, <i32 16, i32 16>
  ret <2 x i1> %cmp
}

define <2 x i1> @cttz_ult_bw_minus_one_v2i32(<2 x i32> %x) {
; CHECK-LABEL: @cttz_ult_bw_minus_one_v2i32(
; CHECK-NEXT:    [[TMP1:%.*]] = and <2 x i32> [[X:%.*]], <i32 2147483647, i32 2147483647>
; CHECK-NEXT:    [[CMP:%.*]] = icmp ne <2 x i32> [[TMP1]], zeroinitializer
; CHECK-NEXT:    ret <2 x i1> [[CMP]]
;
  %tz = tail call <2 x i32> @llvm.cttz.v2i32(<2 x i32> %x, i1 false)
  %cmp = icmp ult <2 x i32> %tz, <i32 31, i32 31>
  ret <2 x i1> %cmp
}

define <2 x i1> @cttz_ult_bitwidth_v2i32(<2 x i32> %x) {
; CHECK-LABEL: @cttz_ult_bitwidth_v2i32(
; CHECK-NEXT:    [[CMP:%.*]] = icmp ne <2 x i32> [[X:%.*]], zeroinitializer
; CHECK-NEXT:    ret <2 x i1> [[CMP]]
;
  %tz = tail call <2 x i32> @llvm.cttz.v2i32(<2 x i32> %x, i1 false)
  %cmp = icmp ult <2 x i32> %tz, <i32 32, i32 32>
  ret <2 x i1> %cmp
}

define i1 @ctpop_eq_zero_i11(i11 %x) {
; CHECK-LABEL: @ctpop_eq_zero_i11(
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq i11 [[X:%.*]], 0
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %pop = tail call i11 @llvm.ctpop.i11(i11 %x)
  %cmp = icmp eq i11 %pop, 0
  ret i1 %cmp
}

define <2 x i1> @ctpop_ne_zero_v2i32(<2 x i32> %x) {
; CHECK-LABEL: @ctpop_ne_zero_v2i32(
; CHECK-NEXT:    [[CMP:%.*]] = icmp ne <2 x i32> [[X:%.*]], zeroinitializer
; CHECK-NEXT:    ret <2 x i1> [[CMP]]
;
  %pop = tail call <2 x i32> @llvm.ctpop.v2i32(<2 x i32> %x)
  %cmp = icmp ne <2 x i32> %pop, zeroinitializer
  ret <2 x i1> %cmp
}

define i1 @ctpop_eq_bitwidth_i8(i8 %x) {
; CHECK-LABEL: @ctpop_eq_bitwidth_i8(
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq i8 [[X:%.*]], -1
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %pop = tail call i8 @llvm.ctpop.i8(i8 %x)
  %cmp = icmp eq i8 %pop, 8
  ret i1 %cmp
}

define <2 x i1> @ctpop_ne_bitwidth_v2i32(<2 x i32> %x) {
; CHECK-LABEL: @ctpop_ne_bitwidth_v2i32(
; CHECK-NEXT:    [[CMP:%.*]] = icmp ne <2 x i32> [[X:%.*]], <i32 -1, i32 -1>
; CHECK-NEXT:    ret <2 x i1> [[CMP]]
;
  %pop = tail call <2 x i32> @llvm.ctpop.v2i32(<2 x i32> %x)
  %cmp = icmp ne <2 x i32> %pop, <i32 32, i32 32>
  ret <2 x i1> %cmp
}

define i1 @ctpop_ugt_bitwidth_minus_one_i8(i8 %x, ptr %p) {
; CHECK-LABEL: @ctpop_ugt_bitwidth_minus_one_i8(
; CHECK-NEXT:    [[POP:%.*]] = tail call range(i8 0, 9) i8 @llvm.ctpop.i8(i8 [[X:%.*]])
; CHECK-NEXT:    store i8 [[POP]], ptr [[P:%.*]], align 1
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq i8 [[X]], -1
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %pop = tail call i8 @llvm.ctpop.i8(i8 %x)
  store i8 %pop, ptr %p
  %cmp = icmp ugt i8 %pop, 7
  ret i1 %cmp
}

define <2 x i1> @ctpop_ult_bitwidth_v2i32(<2 x i32> %x) {
; CHECK-LABEL: @ctpop_ult_bitwidth_v2i32(
; CHECK-NEXT:    [[CMP:%.*]] = icmp ne <2 x i32> [[X:%.*]], <i32 -1, i32 -1>
; CHECK-NEXT:    ret <2 x i1> [[CMP]]
;
  %pop = tail call <2 x i32> @llvm.ctpop.v2i32(<2 x i32> %x)
  %cmp = icmp ult <2 x i32> %pop, <i32 32, i32 32>
  ret <2 x i1> %cmp
}

define i1 @trunc_cttz_eq_other_i33_i15(i33 %x) {
; CHECK-LABEL: @trunc_cttz_eq_other_i33_i15(
; CHECK-NEXT:    [[TMP1:%.*]] = and i33 [[X:%.*]], 31
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq i33 [[TMP1]], 16
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %tz = tail call i33 @llvm.cttz.i33(i33 %x, i1 false)
  %trunc = trunc i33 %tz to i15
  %cmp = icmp eq i15 %trunc, 4
  ret i1 %cmp
}

define i1 @trunc_cttz_ugt_other_i33_i15(i33 %x) {
; CHECK-LABEL: @trunc_cttz_ugt_other_i33_i15(
; CHECK-NEXT:    [[TMP1:%.*]] = and i33 [[X:%.*]], 15
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq i33 [[TMP1]], 0
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %tz = tail call i33 @llvm.cttz.i33(i33 %x, i1 false)
  %trunc = trunc i33 %tz to i15
  %cmp = icmp ugt i15 %trunc, 3
  ret i1 %cmp
}

define i1 @trunc_cttz_ult_other_i33_i6(i33 %x) {
; CHECK-LABEL: @trunc_cttz_ult_other_i33_i6(
; CHECK-NEXT:    [[TMP1:%.*]] = and i33 [[X:%.*]], 127
; CHECK-NEXT:    [[CMP:%.*]] = icmp ne i33 [[TMP1]], 0
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %tz = tail call i33 @llvm.cttz.i33(i33 %x, i1 true)
  %trunc = trunc i33 %tz to i6
  %cmp = icmp ult i6 %trunc, 7
  ret i1 %cmp
}

; negative case: log2(33 - is_zero_poison ? 1 : 0) + 1 > 5

define i1 @trunc_cttz_ult_other_i33_i5(i33 %x) {
; CHECK-LABEL: @trunc_cttz_ult_other_i33_i5(
; CHECK-NEXT:    [[TZ:%.*]] = tail call range(i33 0, 34) i33 @llvm.cttz.i33(i33 [[X:%.*]], i1 true)
; CHECK-NEXT:    [[TRUNC:%.*]] = trunc i33 [[TZ]] to i5
; CHECK-NEXT:    [[CMP:%.*]] = icmp ult i5 [[TRUNC]], 7
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %tz = tail call i33 @llvm.cttz.i33(i33 %x, i1 true)
  %trunc = trunc i33 %tz to i5
  %cmp = icmp ult i5 %trunc, 7
  ret i1 %cmp
}

define i1 @trunc_cttz_true_ult_other_i32_i5(i32 %x) {
; CHECK-LABEL: @trunc_cttz_true_ult_other_i32_i5(
; CHECK-NEXT:    [[TMP1:%.*]] = and i32 [[X:%.*]], 127
; CHECK-NEXT:    [[CMP:%.*]] = icmp ne i32 [[TMP1]], 0
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %tz = tail call i32 @llvm.cttz.i32(i32 %x, i1 true)
  %trunc = trunc i32 %tz to i5
  %cmp = icmp ult i5 %trunc, 7
  ret i1 %cmp
}

; negative case, is_zero_poison == false && log2(src bitwidth) == dest bitwidth

define i1 @trunc_cttz_false_ult_other_i32_i5(i32 %x) {
; CHECK-LABEL: @trunc_cttz_false_ult_other_i32_i5(
; CHECK-NEXT:    [[TZ:%.*]] = tail call range(i32 0, 33) i32 @llvm.cttz.i32(i32 [[X:%.*]], i1 false)
; CHECK-NEXT:    [[TRUNC:%.*]] = trunc i32 [[TZ]] to i5
; CHECK-NEXT:    [[CMP:%.*]] = icmp ult i5 [[TRUNC]], 7
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %tz = tail call i32 @llvm.cttz.i32(i32 %x, i1 false)
  %trunc = trunc i32 %tz to i5
  %cmp = icmp ult i5 %trunc, 7
  ret i1 %cmp
}

define i1 @trunc_cttz_false_ult_other_i32_i6(i32 %x) {
; CHECK-LABEL: @trunc_cttz_false_ult_other_i32_i6(
; CHECK-NEXT:    [[TMP1:%.*]] = and i32 [[X:%.*]], 127
; CHECK-NEXT:    [[CMP:%.*]] = icmp ne i32 [[TMP1]], 0
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %tz = tail call i32 @llvm.cttz.i32(i32 %x, i1 false)
  %trunc = trunc i32 %tz to i6
  %cmp = icmp ult i6 %trunc, 7
  ret i1 %cmp
}

; negative case, trunc is not one use

define i1 @trunc_cttz_false_ult_other_i32_i6_extra_use(i32 %x) {
; CHECK-LABEL: @trunc_cttz_false_ult_other_i32_i6_extra_use(
; CHECK-NEXT:    [[TZ:%.*]] = tail call range(i32 0, 33) i32 @llvm.cttz.i32(i32 [[X:%.*]], i1 false)
; CHECK-NEXT:    [[TRUNC:%.*]] = trunc nuw i32 [[TZ]] to i6
; CHECK-NEXT:    call void @use6(i6 [[TRUNC]])
; CHECK-NEXT:    [[CMP:%.*]] = icmp ult i6 [[TRUNC]], 7
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %tz = tail call i32 @llvm.cttz.i32(i32 %x, i1 false)
  %trunc = trunc i32 %tz to i6
  call void @use6(i6 %trunc)
  %cmp = icmp ult i6 %trunc, 7
  ret i1 %cmp
}

define i1 @trunc_ctlz_ugt_zero_i32(i32 %x) {
; CHECK-LABEL: @trunc_ctlz_ugt_zero_i32(
; CHECK-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[X:%.*]], -1
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %lz = tail call i32 @llvm.ctlz.i32(i32 %x, i1 false)
  %trunc = trunc i32 %lz to i15
  %cmp = icmp ugt i15 %trunc, 0
  ret i1 %cmp
}

define i1 @trunc_ctlz_ugt_one_i32(i32 %x) {
; CHECK-LABEL: @trunc_ctlz_ugt_one_i32(
; CHECK-NEXT:    [[CMP:%.*]] = icmp ult i32 [[X:%.*]], 1073741824
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %lz = tail call i32 @llvm.ctlz.i32(i32 %x, i1 false)
  %trunc = trunc i32 %lz to i15
  %cmp = icmp ugt i15 %trunc, 1
  ret i1 %cmp
}

define i1 @trunc_ctlz_ugt_other_i33_i6(i33 %x) {
; CHECK-LABEL: @trunc_ctlz_ugt_other_i33_i6(
; CHECK-NEXT:    [[CMP:%.*]] = icmp ult i33 [[X:%.*]], 268435456
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %lz = tail call i33 @llvm.ctlz.i33(i33 %x, i1 true)
  %trunc = trunc i33 %lz to i6
  %cmp = icmp ugt i6 %trunc, 4
  ret i1 %cmp
}

; negative case: log2(33 - is_zero_poison ? 1 : 0) + 1 > 5

define i1 @trunc_ctlz_ugt_other_i33_i5(i33 %x) {
; CHECK-LABEL: @trunc_ctlz_ugt_other_i33_i5(
; CHECK-NEXT:    [[LZ:%.*]] = tail call range(i33 0, 34) i33 @llvm.ctlz.i33(i33 [[X:%.*]], i1 true)
; CHECK-NEXT:    [[TRUNC:%.*]] = trunc i33 [[LZ]] to i5
; CHECK-NEXT:    [[CMP:%.*]] = icmp ugt i5 [[TRUNC]], 4
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %lz = tail call i33 @llvm.ctlz.i33(i33 %x, i1 true)
  %trunc = trunc i33 %lz to i5
  %cmp = icmp ugt i5 %trunc, 4
  ret i1 %cmp
}

define i1 @trunc_ctlz_true_ugt_other_i32_i5(i32 %x) {
; CHECK-LABEL: @trunc_ctlz_true_ugt_other_i32_i5(
; CHECK-NEXT:    [[CMP:%.*]] = icmp ult i32 [[X:%.*]], 134217728
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %lz = tail call i32 @llvm.ctlz.i32(i32 %x, i1 true)
  %trunc = trunc i32 %lz to i5
  %cmp = icmp ugt i5 %trunc, 4
  ret i1 %cmp
}

; negative case, is_zero_poison == false && log2(src bitwidth) == dest bitwidth

define i1 @trunc_ctlz_false_ugt_other_i32_i5(i32 %x) {
; CHECK-LABEL: @trunc_ctlz_false_ugt_other_i32_i5(
; CHECK-NEXT:    [[LZ:%.*]] = tail call range(i32 0, 33) i32 @llvm.ctlz.i32(i32 [[X:%.*]], i1 false)
; CHECK-NEXT:    [[TRUNC:%.*]] = trunc i32 [[LZ]] to i5
; CHECK-NEXT:    [[CMP:%.*]] = icmp ugt i5 [[TRUNC]], 4
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %lz = tail call i32 @llvm.ctlz.i32(i32 %x, i1 false)
  %trunc = trunc i32 %lz to i5
  %cmp = icmp ugt i5 %trunc, 4
  ret i1 %cmp
}

define i1 @trunc_ctlz_false_ugt_other_i32_i6(i32 %x) {
; CHECK-LABEL: @trunc_ctlz_false_ugt_other_i32_i6(
; CHECK-NEXT:    [[CMP:%.*]] = icmp ult i32 [[X:%.*]], 134217728
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %lz = tail call i32 @llvm.ctlz.i32(i32 %x, i1 false)
  %trunc = trunc i32 %lz to i6
  %cmp = icmp ugt i6 %trunc, 4
  ret i1 %cmp
}

; negative case, trunc is not one use

define i1 @trunc_ctlz_false_ugt_other_i32_i6_extra_use(i32 %x) {
; CHECK-LABEL: @trunc_ctlz_false_ugt_other_i32_i6_extra_use(
; CHECK-NEXT:    [[LZ:%.*]] = tail call range(i32 0, 33) i32 @llvm.ctlz.i32(i32 [[X:%.*]], i1 false)
; CHECK-NEXT:    [[TRUNC:%.*]] = trunc nuw i32 [[LZ]] to i6
; CHECK-NEXT:    call void @use6(i6 [[TRUNC]])
; CHECK-NEXT:    [[CMP:%.*]] = icmp ugt i6 [[TRUNC]], 4
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %lz = tail call i32 @llvm.ctlz.i32(i32 %x, i1 false)
  %trunc = trunc i32 %lz to i6
  call void @use6(i6 %trunc)
  %cmp = icmp ugt i6 %trunc, 4
  ret i1 %cmp
}

define i1 @trunc_ctpop_eq_zero_i11(i11 %x) {
; CHECK-LABEL: @trunc_ctpop_eq_zero_i11(
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq i11 [[X:%.*]], 0
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %pop = tail call i11 @llvm.ctpop.i11(i11 %x)
  %trunc = trunc i11 %pop to i5
  %cmp = icmp eq i5 %trunc, 0
  ret i1 %cmp
}

define i1 @trunc_ctpop_eq_bitwidth_i8(i8 %x) {
; CHECK-LABEL: @trunc_ctpop_eq_bitwidth_i8(
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq i8 [[X:%.*]], -1
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %pop = tail call i8 @llvm.ctpop.i8(i8 %x)
  %trunc = trunc i8 %pop to i5
  %cmp = icmp eq i5 %trunc, 8
  ret i1 %cmp
}

; negative case: log2(33) + 1 > 4

define i1 @trunc_negative_destbits_not_enough(i33 %x) {
; CHECK-LABEL: @trunc_negative_destbits_not_enough(
; CHECK-NEXT:    [[TZ:%.*]] = tail call range(i33 0, 34) i33 @llvm.cttz.i33(i33 [[X:%.*]], i1 false)
; CHECK-NEXT:    [[TRUNC:%.*]] = trunc i33 [[TZ]] to i4
; CHECK-NEXT:    [[CMP:%.*]] = icmp ult i4 [[TRUNC]], 7
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %tz = tail call i33 @llvm.cttz.i33(i33 %x, i1 false)
  %trunc = trunc i33 %tz to i4
  %cmp = icmp ult i4 %trunc, 7
  ret i1 %cmp
}

define i1 @bitreverse_ne_22(i8 %x) {
; CHECK-LABEL: @bitreverse_ne_22(
; CHECK-NEXT:    [[Z:%.*]] = icmp ne i8 [[X:%.*]], 104
; CHECK-NEXT:    ret i1 [[Z]]
;
  %y = call i8 @llvm.bitreverse.i8(i8 %x)
  %z = icmp ne i8 %y, 22
  ret i1 %z
}

define i1 @bitreverse_ult_22_fail_not_equality_pred(i8 %x) {
; CHECK-LABEL: @bitreverse_ult_22_fail_not_equality_pred(
; CHECK-NEXT:    [[Y:%.*]] = call i8 @llvm.bitreverse.i8(i8 [[X:%.*]])
; CHECK-NEXT:    [[Z:%.*]] = icmp ult i8 [[Y]], 22
; CHECK-NEXT:    ret i1 [[Z]]
;
  %y = call i8 @llvm.bitreverse.i8(i8 %x)
  %z = icmp ult i8 %y, 22
  ret i1 %z
}

define <2 x i1> @bitreverse_vec_eq_2_2(<2 x i8> %x) {
; CHECK-LABEL: @bitreverse_vec_eq_2_2(
; CHECK-NEXT:    [[Z:%.*]] = icmp eq <2 x i8> [[X:%.*]], <i8 64, i8 64>
; CHECK-NEXT:    ret <2 x i1> [[Z]]
;
  %y = call <2 x i8> @llvm.bitreverse.v2i8(<2 x i8> %x)
  %z = icmp eq <2 x i8> %y, <i8 2, i8 2>
  ret <2 x i1> %z
}

define <2 x i1> @bitreverse_vec_eq_1_2_todo_no_splat(<2 x i8> %x) {
; CHECK-LABEL: @bitreverse_vec_eq_1_2_todo_no_splat(
; CHECK-NEXT:    [[Y:%.*]] = call <2 x i8> @llvm.bitreverse.v2i8(<2 x i8> [[X:%.*]])
; CHECK-NEXT:    [[Z:%.*]] = icmp eq <2 x i8> [[Y]], <i8 1, i8 2>
; CHECK-NEXT:    ret <2 x i1> [[Z]]
;
  %y = call <2 x i8> @llvm.bitreverse.v2i8(<2 x i8> %x)
  %z = icmp eq <2 x i8> %y, <i8 1, i8 2>
  ret <2 x i1> %z
}

define i1 @umax_eq_zero(i8 %x, i8 %y) {
; CHECK-LABEL: @umax_eq_zero(
; CHECK-NEXT:    [[TMP1:%.*]] = or i8 [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    [[R:%.*]] = icmp eq i8 [[TMP1]], 0
; CHECK-NEXT:    ret i1 [[R]]
;
  %m = call i8 @llvm.umax.i8(i8 %x, i8 %y)
  %r = icmp eq i8 %m, 0
  ret i1 %r
}

define i1 @umax_eq_1_fail(i8 %x, i8 %y) {
; CHECK-LABEL: @umax_eq_1_fail(
; CHECK-NEXT:    [[M:%.*]] = call i8 @llvm.umax.i8(i8 [[X:%.*]], i8 [[Y:%.*]])
; CHECK-NEXT:    [[R:%.*]] = icmp eq i8 [[M]], 1
; CHECK-NEXT:    ret i1 [[R]]
;
  %m = call i8 @llvm.umax.i8(i8 %x, i8 %y)
  %r = icmp eq i8 %m, 1
  ret i1 %r
}

define i1 @umax_sle_zero_fail(i8 %x, i8 %y) {
; CHECK-LABEL: @umax_sle_zero_fail(
; CHECK-NEXT:    [[M:%.*]] = call i8 @llvm.umax.i8(i8 [[X:%.*]], i8 [[Y:%.*]])
; CHECK-NEXT:    [[R:%.*]] = icmp slt i8 [[M]], 1
; CHECK-NEXT:    ret i1 [[R]]
;
  %m = call i8 @llvm.umax.i8(i8 %x, i8 %y)
  %r = icmp sle i8 %m, 0
  ret i1 %r
}

define i1 @umax_ne_zero(i8 %x, i8 %y) {
; CHECK-LABEL: @umax_ne_zero(
; CHECK-NEXT:    [[TMP1:%.*]] = or i8 [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    [[R:%.*]] = icmp ne i8 [[TMP1]], 0
; CHECK-NEXT:    ret i1 [[R]]
;
  %m = call i8 @llvm.umax.i8(i8 %x, i8 %y)
  %r = icmp ne i8 %m, 0
  ret i1 %r
}

define i1 @umax_ne_zero_fail_multiuse(i8 %x, i8 %y) {
; CHECK-LABEL: @umax_ne_zero_fail_multiuse(
; CHECK-NEXT:    [[M:%.*]] = call i8 @llvm.umax.i8(i8 [[X:%.*]], i8 [[Y:%.*]])
; CHECK-NEXT:    call void @use8(i8 [[M]])
; CHECK-NEXT:    [[R:%.*]] = icmp ne i8 [[M]], 0
; CHECK-NEXT:    ret i1 [[R]]
;
  %m = call i8 @llvm.umax.i8(i8 %x, i8 %y)
  call void @use8(i8 %m)
  %r = icmp ne i8 %m, 0
  ret i1 %r
}


define i1 @uadd_sat_ne_zero_fail_multiuse(i8 %x, i8 %y) {
; CHECK-LABEL: @uadd_sat_ne_zero_fail_multiuse(
; CHECK-NEXT:    [[M:%.*]] = call i8 @llvm.uadd.sat.i8(i8 [[X:%.*]], i8 [[Y:%.*]])
; CHECK-NEXT:    call void @use8(i8 [[M]])
; CHECK-NEXT:    [[R:%.*]] = icmp ne i8 [[M]], 0
; CHECK-NEXT:    ret i1 [[R]]
;
  %m = call i8 @llvm.uadd.sat.i8(i8 %x, i8 %y)
  call void @use8(i8 %m)
  %r = icmp ne i8 %m, 0
  ret i1 %r
}


define i1 @ssub_sat_ne_zero(i8 %x, i8 %y) {
; CHECK-LABEL: @ssub_sat_ne_zero(
; CHECK-NEXT:    [[R:%.*]] = icmp ne i8 [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    ret i1 [[R]]
;
  %m = call i8 @llvm.ssub.sat.i8(i8 %x, i8 %y)
  %r = icmp ne i8 %m, 0
  ret i1 %r
}

define i1 @ssub_sat_ne_fail_nonzero(i8 %x, i8 %y) {
; CHECK-LABEL: @ssub_sat_ne_fail_nonzero(
; CHECK-NEXT:    [[M:%.*]] = call i8 @llvm.ssub.sat.i8(i8 [[X:%.*]], i8 [[Y:%.*]])
; CHECK-NEXT:    [[R:%.*]] = icmp ne i8 [[M]], 4
; CHECK-NEXT:    ret i1 [[R]]
;
  %m = call i8 @llvm.ssub.sat.i8(i8 %x, i8 %y)
  %r = icmp ne i8 %m, 4
  ret i1 %r
}

define i1 @ssub_sat_eq_zero(i8 %x, i8 %y) {
; CHECK-LABEL: @ssub_sat_eq_zero(
; CHECK-NEXT:    [[R:%.*]] = icmp eq i8 [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    ret i1 [[R]]
;
  %m = call i8 @llvm.ssub.sat.i8(i8 %x, i8 %y)
  %r = icmp eq i8 %m, 0
  ret i1 %r
}

define i1 @ssub_sat_sle_zero(i8 %x, i8 %y) {
; CHECK-LABEL: @ssub_sat_sle_zero(
; CHECK-NEXT:    [[R:%.*]] = icmp sle i8 [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    ret i1 [[R]]
;
  %m = call i8 @llvm.ssub.sat.i8(i8 %x, i8 %y)
  %r = icmp sle i8 %m, 0
  ret i1 %r
}

define i1 @ssub_sat_sge_zero(i8 %x, i8 %y) {
; CHECK-LABEL: @ssub_sat_sge_zero(
; CHECK-NEXT:    [[R:%.*]] = icmp sge i8 [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    ret i1 [[R]]
;
  %m = call i8 @llvm.ssub.sat.i8(i8 %x, i8 %y)
  %r = icmp sge i8 %m, 0
  ret i1 %r
}

define i1 @ssub_sat_slt_zero(i8 %x, i8 %y) {
; CHECK-LABEL: @ssub_sat_slt_zero(
; CHECK-NEXT:    [[R:%.*]] = icmp slt i8 [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    ret i1 [[R]]
;
  %m = call i8 @llvm.ssub.sat.i8(i8 %x, i8 %y)
  %r = icmp slt i8 %m, 0
  ret i1 %r
}

define i1 @ssub_sat_slt_neg1_fail(i8 %x, i8 %y) {
; CHECK-LABEL: @ssub_sat_slt_neg1_fail(
; CHECK-NEXT:    [[M:%.*]] = call i8 @llvm.ssub.sat.i8(i8 [[X:%.*]], i8 [[Y:%.*]])
; CHECK-NEXT:    [[R:%.*]] = icmp slt i8 [[M]], -1
; CHECK-NEXT:    ret i1 [[R]]
;
  %m = call i8 @llvm.ssub.sat.i8(i8 %x, i8 %y)
  %r = icmp slt i8 %m, -1
  ret i1 %r
}

define i1 @ssub_sat_sgt_zero(i8 %x, i8 %y) {
; CHECK-LABEL: @ssub_sat_sgt_zero(
; CHECK-NEXT:    [[R:%.*]] = icmp sgt i8 [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    ret i1 [[R]]
;
  %m = call i8 @llvm.ssub.sat.i8(i8 %x, i8 %y)
  %r = icmp sgt i8 %m, 0
  ret i1 %r
}

define i1 @ssub_sat_sgt_one_fail(i8 %x, i8 %y) {
; CHECK-LABEL: @ssub_sat_sgt_one_fail(
; CHECK-NEXT:    [[M:%.*]] = call i8 @llvm.ssub.sat.i8(i8 [[X:%.*]], i8 [[Y:%.*]])
; CHECK-NEXT:    [[R:%.*]] = icmp sgt i8 [[M]], 1
; CHECK-NEXT:    ret i1 [[R]]
;
  %m = call i8 @llvm.ssub.sat.i8(i8 %x, i8 %y)
  %r = icmp sgt i8 %m, 1
  ret i1 %r
}
