# FreeCAD Project Code of Conduct

## Statement

The FreeCAD Project community covers people from a wide variety of countries,
backgrounds and positions. This global diversity is a great strength of the
project, but can also lead to communication issues, which may in turn cause
unhappiness. To maximise happiness of the project community taken as a whole,
all members (whether users, contributors or committers) are expected to abide
by the project's code of conduct. At a high level the code can be summarized
as *"be excellent to each other"*. Expanding on this:

* **Be respectful**: disagreements between people are to be expected and are
  usually the sign of healthy debate and engagement. Disagreements can lead to
  frustration and even anger for some members. Turning to personal insults,
  intimidation or threatening behaviour does not improve the situation though.
  Participants should thus take care to ensure all communications /
  interactions stay professional at all times.

* **Be considerate**: remember that the community has members with a diverse
  background many of whom have English as a second language. What might appear
  impolite, may simply be a result of a lack of knowledge of the English
  language. Bear in mind that actions will have an impact on other community
  members and the project as a whole, so take potential consequences into
  account before pursuing a course of action.

* **Be forgiving**: humans are fallible and as such prone to make mistakes and
  inexplicably change their positions at times. Don't assume that other members
  are acting with malicious intent. Be prepared to forgive people who make
  mistakes and assist each other in learning from them. Playing a blame game
  doesn't help anyone.


## Our Responsibilities

Project maintainers are responsible for clarifying the standards of acceptable
behavior and are expected to take appropriate and fair corrective action in
response to any instances of unacceptable behavior.

Project maintainers have the right and responsibility to remove, edit, or
reject comments, commits, code, wiki edits, issues, and other contributions
that are not aligned to this Code of Conduct, or to ban temporarily or
permanently any contributor for other behaviors that they deem inappropriate,
threatening, offensive, or harmful.

## Scope

This Code of Conduct applies both within project spaces and in public spaces
when an individual is representing the project or its community. Examples of
representing a project or community include using an official project e-mail
address, posting via an official social media account, or acting as an appointed
representative at an online or offline event. Representation of a project may be
further defined and clarified by project maintainers.

## Enforcement

Instances of abusive, harassing, or otherwise unacceptable behavior may be
reported by contacting any of the community admins or moderators at
https://forum.freecad.org/memberlist.php?mode=team . All
complaints will be reviewed and investigated and will result in a response that
is deemed necessary and appropriate to the circumstances. The project team is
obligated to maintain confidentiality with regard to the reporter of an incident.
Further details of specific enforcement policies may be posted separately.

Project maintainers who do not follow or enforce the Code of Conduct in good
faith may face temporary or permanent repercussions as determined by other
members of the project's leadership.

## Attribution

This Code of Conduct is adapted from the [Contributor Covenant][homepage], version 1.4,
available at https://www.contributor-covenant.org/version/1/4/code-of-conduct.html
and the [libvirt Code of Conduct][libvirtcoc], available at https://libvirt.org/governance.html.

[homepage]: https://www.contributor-covenant.org
[libvirtcoc]: https://libvirt.org/governance.html

For answers to common questions about the Contributor Covenant, see
https://www.contributor-covenant.org/faq
