// Copyright 2016 Proyectos y Sistemas de Mantenimiento SL (eProsima).
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/*!
 * @file string_struct.hpp
 * This header file contains the declaration of the described types in the IDL file.
 *
 * This file was generated by the tool fastddsgen.
 */

#ifndef FAST_DDS_GENERATED__STRING_STRUCT_HPP
#define FAST_DDS_GENERATED__STRING_STRUCT_HPP

#include <cstdint>
#include <string>
#include <utility>
#include <fastcdr/cdr/fixed_size_string.hpp>

#if defined(_WIN32)
#if defined(EPROSIMA_USER_DLL_EXPORT)
#define eProsima_user_DllExport __declspec( dllexport )
#else
#define eProsima_user_DllExport
#endif  // EPROSIMA_USER_DLL_EXPORT
#else
#define eProsima_user_DllExport
#endif  // _WIN32

#if defined(_WIN32)
#if defined(EPROSIMA_USER_DLL_EXPORT)
#if defined(STRING_STRUCT_SOURCE)
#define STRING_STRUCT_DllAPI __declspec( dllexport )
#else
#define STRING_STRUCT_DllAPI __declspec( dllimport )
#endif // STRING_STRUCT_SOURCE
#else
#define STRING_STRUCT_DllAPI
#endif  // EPROSIMA_USER_DLL_EXPORT
#else
#define STRING_STRUCT_DllAPI
#endif // _WIN32

/*!
 * @brief This class represents the structure StringStruct defined by the user in the IDL file.
 * @ingroup string_struct
 */
class StringStruct
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport StringStruct()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~StringStruct()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object StringStruct that will be copied.
     */
    eProsima_user_DllExport StringStruct(
            const StringStruct& x)
    {
                    m_my_string = x.m_my_string;

                    m_my_wstring = x.m_my_wstring;

                    m_my_bounded_string = x.m_my_bounded_string;

                    m_my_bounded_wstring = x.m_my_bounded_wstring;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object StringStruct that will be copied.
     */
    eProsima_user_DllExport StringStruct(
            StringStruct&& x) noexcept
    {
        m_my_string = std::move(x.m_my_string);
        m_my_wstring = std::move(x.m_my_wstring);
        m_my_bounded_string = std::move(x.m_my_bounded_string);
        m_my_bounded_wstring = std::move(x.m_my_bounded_wstring);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object StringStruct that will be copied.
     */
    eProsima_user_DllExport StringStruct& operator =(
            const StringStruct& x)
    {

                    m_my_string = x.m_my_string;

                    m_my_wstring = x.m_my_wstring;

                    m_my_bounded_string = x.m_my_bounded_string;

                    m_my_bounded_wstring = x.m_my_bounded_wstring;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object StringStruct that will be copied.
     */
    eProsima_user_DllExport StringStruct& operator =(
            StringStruct&& x) noexcept
    {

        m_my_string = std::move(x.m_my_string);
        m_my_wstring = std::move(x.m_my_wstring);
        m_my_bounded_string = std::move(x.m_my_bounded_string);
        m_my_bounded_wstring = std::move(x.m_my_bounded_wstring);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x StringStruct object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const StringStruct& x) const
    {
        return (m_my_string == x.m_my_string &&
           m_my_wstring == x.m_my_wstring &&
           m_my_bounded_string == x.m_my_bounded_string &&
           m_my_bounded_wstring == x.m_my_bounded_wstring);
    }

    /*!
     * @brief Comparison operator.
     * @param x StringStruct object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const StringStruct& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member my_string
     * @param _my_string New value to be copied in member my_string
     */
    eProsima_user_DllExport void my_string(
            const std::string& _my_string)
    {
        m_my_string = _my_string;
    }

    /*!
     * @brief This function moves the value in member my_string
     * @param _my_string New value to be moved in member my_string
     */
    eProsima_user_DllExport void my_string(
            std::string&& _my_string)
    {
        m_my_string = std::move(_my_string);
    }

    /*!
     * @brief This function returns a constant reference to member my_string
     * @return Constant reference to member my_string
     */
    eProsima_user_DllExport const std::string& my_string() const
    {
        return m_my_string;
    }

    /*!
     * @brief This function returns a reference to member my_string
     * @return Reference to member my_string
     */
    eProsima_user_DllExport std::string& my_string()
    {
        return m_my_string;
    }


    /*!
     * @brief This function copies the value in member my_wstring
     * @param _my_wstring New value to be copied in member my_wstring
     */
    eProsima_user_DllExport void my_wstring(
            const std::wstring& _my_wstring)
    {
        m_my_wstring = _my_wstring;
    }

    /*!
     * @brief This function moves the value in member my_wstring
     * @param _my_wstring New value to be moved in member my_wstring
     */
    eProsima_user_DllExport void my_wstring(
            std::wstring&& _my_wstring)
    {
        m_my_wstring = std::move(_my_wstring);
    }

    /*!
     * @brief This function returns a constant reference to member my_wstring
     * @return Constant reference to member my_wstring
     */
    eProsima_user_DllExport const std::wstring& my_wstring() const
    {
        return m_my_wstring;
    }

    /*!
     * @brief This function returns a reference to member my_wstring
     * @return Reference to member my_wstring
     */
    eProsima_user_DllExport std::wstring& my_wstring()
    {
        return m_my_wstring;
    }


    /*!
     * @brief This function copies the value in member my_bounded_string
     * @param _my_bounded_string New value to be copied in member my_bounded_string
     */
    eProsima_user_DllExport void my_bounded_string(
            const eprosima::fastcdr::fixed_string<41925>& _my_bounded_string)
    {
        m_my_bounded_string = _my_bounded_string;
    }

    /*!
     * @brief This function moves the value in member my_bounded_string
     * @param _my_bounded_string New value to be moved in member my_bounded_string
     */
    eProsima_user_DllExport void my_bounded_string(
            eprosima::fastcdr::fixed_string<41925>&& _my_bounded_string)
    {
        m_my_bounded_string = std::move(_my_bounded_string);
    }

    /*!
     * @brief This function returns a constant reference to member my_bounded_string
     * @return Constant reference to member my_bounded_string
     */
    eProsima_user_DllExport const eprosima::fastcdr::fixed_string<41925>& my_bounded_string() const
    {
        return m_my_bounded_string;
    }

    /*!
     * @brief This function returns a reference to member my_bounded_string
     * @return Reference to member my_bounded_string
     */
    eProsima_user_DllExport eprosima::fastcdr::fixed_string<41925>& my_bounded_string()
    {
        return m_my_bounded_string;
    }


    /*!
     * @brief This function copies the value in member my_bounded_wstring
     * @param _my_bounded_wstring New value to be copied in member my_bounded_wstring
     */
    eProsima_user_DllExport void my_bounded_wstring(
            const std::wstring& _my_bounded_wstring)
    {
        m_my_bounded_wstring = _my_bounded_wstring;
    }

    /*!
     * @brief This function moves the value in member my_bounded_wstring
     * @param _my_bounded_wstring New value to be moved in member my_bounded_wstring
     */
    eProsima_user_DllExport void my_bounded_wstring(
            std::wstring&& _my_bounded_wstring)
    {
        m_my_bounded_wstring = std::move(_my_bounded_wstring);
    }

    /*!
     * @brief This function returns a constant reference to member my_bounded_wstring
     * @return Constant reference to member my_bounded_wstring
     */
    eProsima_user_DllExport const std::wstring& my_bounded_wstring() const
    {
        return m_my_bounded_wstring;
    }

    /*!
     * @brief This function returns a reference to member my_bounded_wstring
     * @return Reference to member my_bounded_wstring
     */
    eProsima_user_DllExport std::wstring& my_bounded_wstring()
    {
        return m_my_bounded_wstring;
    }



private:

    std::string m_my_string;
    std::wstring m_my_wstring;
    eprosima::fastcdr::fixed_string<41925> m_my_bounded_string;
    std::wstring m_my_bounded_wstring;

};

#endif // _FAST_DDS_GENERATED_STRING_STRUCT_HPP_


