// Copyright 2016 Proyectos y Sistemas de Mantenimiento SL (eProsima).
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/*!
 * @file rpc_typesCdrAux.hpp
 * This source file contains some definitions of CDR related functions.
 *
 * This file was generated by the tool fastddsgen.
 */

#ifndef FAST_DDS_GENERATED__EPROSIMA_FASTDDS_DDS_RPC_RPC_TYPESCDRAUX_HPP
#define FAST_DDS_GENERATED__EPROSIMA_FASTDDS_DDS_RPC_RPC_TYPESCDRAUX_HPP

#include "rpc_types.hpp"

constexpr uint32_t eprosima_fastdds_dds_rpc_RequestHeader_max_cdr_typesize {284UL};
constexpr uint32_t eprosima_fastdds_dds_rpc_RequestHeader_max_key_cdr_typesize {0UL};


constexpr uint32_t eprosima_fastdds_dds_EntityId_t_max_cdr_typesize {4UL};
constexpr uint32_t eprosima_fastdds_dds_EntityId_t_max_key_cdr_typesize {0UL};

constexpr uint32_t eprosima_fastdds_dds_GUID_t_max_cdr_typesize {16UL};
constexpr uint32_t eprosima_fastdds_dds_GUID_t_max_key_cdr_typesize {0UL};


constexpr uint32_t eprosima_fastdds_dds_rpc_ReplyHeader_max_cdr_typesize {28UL};
constexpr uint32_t eprosima_fastdds_dds_rpc_ReplyHeader_max_key_cdr_typesize {0UL};




constexpr uint32_t eprosima_fastdds_dds_SequenceNumber_t_max_cdr_typesize {8UL};
constexpr uint32_t eprosima_fastdds_dds_SequenceNumber_t_max_key_cdr_typesize {0UL};

constexpr uint32_t eprosima_fastdds_dds_SampleIdentity_max_cdr_typesize {24UL};
constexpr uint32_t eprosima_fastdds_dds_SampleIdentity_max_key_cdr_typesize {0UL};


namespace eprosima {
namespace fastcdr {

class Cdr;
class CdrSizeCalculator;

eProsima_user_DllExport void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::dds::EntityId_t& data);

eProsima_user_DllExport void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::dds::GUID_t& data);

eProsima_user_DllExport void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::dds::SequenceNumber_t& data);

eProsima_user_DllExport void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::dds::SampleIdentity& data);

eProsima_user_DllExport void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::dds::rpc::RequestHeader& data);

eProsima_user_DllExport void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::dds::rpc::ReplyHeader& data);


} // namespace fastcdr
} // namespace eprosima

#endif // FAST_DDS_GENERATED__EPROSIMA_FASTDDS_DDS_RPC_RPC_TYPESCDRAUX_HPP

