// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.

.intel_syntax noprefix
#include <AsmOffsets.inc>         // generated by the build from AsmOffsets.cpp
#include <unixasmmacros.inc>
#define POINTER_SIZE 8

LEAF_ENTRY RhCommonStub, _TEXT

    PUSH_ARGUMENT_REGISTERS
    push_register    r10

    alloc_stack    SIZEOF_FP_REGS
    SAVE_FLOAT_ARGUMENT_REGISTERS 0

#ifdef FEATURE_EMULATED_TLS
    call    C_FUNC(RhpGetThunkData)
#else
    INLINE_GET_TLS_VAR  tls_thunkData
#endif

    RESTORE_FLOAT_ARGUMENT_REGISTERS 0
    free_stack    SIZEOF_FP_REGS

    pop_register    r10
    POP_ARGUMENT_REGISTERS

    mov    r11, [r10]
    mov    qword ptr [rax], r11

    mov    rax, [r10 + POINTER_SIZE]
    jmp    rax
LEAF_END RhCommonStub, _TEXT


LEAF_ENTRY RhGetCommonStubAddress, _TEXT
    lea rax, [rip + C_FUNC(RhCommonStub)]
    ret
LEAF_END RhGetCommonStubAddress, _TEXT
