// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.

using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;

namespace Microsoft.EntityFrameworkCore.TestModels.MusicStore;

#nullable disable

public class Album
{
    [ScaffoldColumn(false)]
    public int AlbumId { get; set; }

    public int GenreId { get; set; }

    public int ArtistId { get; set; }

    [Required]
    [StringLength(160, MinimumLength = 2)]
    public string Title { get; set; }

    [Required]
    [Range(0.01, 100.00)]
    [DataType(DataType.Currency)]
    [Column(TypeName = "decimal(18,2)")]
    public decimal Price { get; set; }

    [Display(Name = "Album Art URL")]
    [StringLength(1024)]
    public string AlbumArtUrl { get; set; }

    public virtual Genre Genre { get; set; }
    public virtual Artist Artist { get; set; }
    public virtual List<OrderDetail> OrderDetails { get; set; }

    [ScaffoldColumn(false)]
    [Required]
    public DateTime Created { get; set; } = DateTime.UtcNow;
}
