#
# -*- coding: utf-8 -*-
# Copyright 2023 Dell Inc. or its subsidiaries. All Rights Reserved
# GNU General Public License v3.0+
# (see COPYING or https://www.gnu.org/licenses/gpl-3.0.txt)

#############################################
#                WARNING                    #
#############################################
#
# This file is auto generated by the resource
#   module builder playbook.
#
# Do not edit this file manually.
#
# Changes to this file will be over written
#   by the resource module builder.
#
# Changes should be made in the model used to
#   generate this file or in the resource module
#   builder template.
#
#############################################

"""
The arg spec for the sonic_poe module
"""

from __future__ import absolute_import, division, print_function
__metaclass__ = type


class PoeArgs(object):  # pylint: disable=R0903
    """The arg spec for the sonic_poe module
    """

    def __init__(self, **kwargs):
        pass

    argument_spec = {
        'config': {
            'options': {
                'cards': {
                    'elements': 'dict',
                    'options': {
                        'auto_reset': {'type': 'bool'},
                        'card_id': {'required': True, 'type': 'int'},
                        'power_mgmt_model': {
                            'choices': [
                                'dynamic',
                                'dynamic-priority',
                                'static',
                                'static-priority',
                                'class'
                            ],
                            'type': 'str'
                        },
                        'usage_threshold': {'type': 'int'}
                    },
                    'type': 'list'
                },
                'global': {
                    'options': {
                        'auto_reset': {'type': 'bool'},
                        'power_mgmt_model': {
                            'choices': [
                                'dynamic',
                                'dynamic-priority',
                                'static',
                                'static-priority',
                                'class'
                            ],
                            'type': 'str'
                        },
                        'usage_threshold': {'type': 'int'}
                    },
                    'type': 'dict'
                },
                'interfaces': {
                    'elements': 'dict',
                    'options': {
                        'detection': {
                            'choices': [
                                '2pt-dot3af',
                                '2pt-dot3af+legacy',
                                '4pt-dot3af',
                                '4pt-dot3af+legacy',
                                'dot3bt',
                                'dot3bt+legacy',
                                'legacy'
                            ],
                            'type': 'str'
                        },
                        'disconnect_type': {'choices': ['ac', 'dc'], 'type': 'str'},
                        'enabled': {'type': 'bool'},
                        'four_pair': {'type': 'bool'},
                        'high_power': {'type': 'bool'},
                        'name': {'required': True, 'type': 'str'},
                        'power_classification': {
                            'choices': ['normal', 'bypass'],
                            'type': 'str'
                        },
                        'power_limit': {'type': 'int'},
                        'power_limit_type': {
                            'choices': ['class-based', 'user-defined'],
                            'type': 'str'
                        },
                        'power_pairs': {
                            'choices': ['signal', 'spare'],
                            'type': 'str'
                        },
                        'power_up_mode': {
                            'choices': [
                                'dot3af',
                                'dot3at',
                                'dot3bt',
                                'dot3bt-type3',
                                'dot3bt-type4',
                                'high-inrush',
                                'pre-dot3at',
                                'pre-dot3bt'
                            ],
                            'type': 'str'
                        },
                        'priority': {'choices': ['low', 'medium', 'high', 'critical'], 'type': 'str'},
                        'use_spare_pair': {'type': 'bool'}
                    },
                    'type': 'list'
                }
            },
            'type': 'dict'
        },
        'state': {
            'choices': ['merged', 'deleted', 'replaced', 'overridden'],
            'default': 'merged',
            'type': 'str'
        }
    }  # pylint: disable=C0301
