// Copyright 2018 The Rust Project Developers. See the COPYRIGHT
// file at the top-level directory of this distribution and at
// http://rust-lang.org/COPYRIGHT.
//
// Licensed under the Apache License, Version 2.0 <LICENSE-APACHE or
// http://www.apache.org/licenses/LICENSE-2.0> or the MIT license
// <LICENSE-MIT or http://opensource.org/licenses/MIT>, at your
// option. This file may not be copied, modified, or distributed
// except according to those terms.

// DO NOT EDIT. Automatically generated by 'scripts/scrape_crates_io.py'
// on 2018-06-20 09:56:32.820354.



// autoshutdown-0.1.0: r"\s*(\d+)(\w)\s*"
consistent!(autoshutdown_0, r"\s*(\d+)(\w)\s*");

// epub-1.1.1: r"/"
consistent!(epub_0, r"/");

// rpi-info-0.2.0: "^Revision\t+: ([0-9a-fA-F]+)"
consistent!(rpi_info_0, "^Revision\t+: ([0-9a-fA-F]+)");

// rpi-info-0.2.0: "Serial\t+: ([0-9a-fA-F]+)"
consistent!(rpi_info_1, "Serial\t+: ([0-9a-fA-F]+)");

// pnet_macros-0.21.0: r"^u([0-9]+)(be|le|he)?$"
consistent!(pnet_macros_0, r"^u([0-9]+)(be|le|he)?$");

// iban_validate-1.0.3: r"^[A-Z]{2}\d{2}[A-Z\d]{1,30}$"
consistent!(iban_validate_0, r"^[A-Z]{2}\d{2}[A-Z\d]{1,30}$");

// markifier-0.1.0: r".*\[(?P<percent>.+)%.*\].*"
consistent!(markifier_0, r".*\[(?P<percent>.+)%.*\].*");

// mallumo-0.3.0: r"(#include) (\S*)(.*)"
consistent!(mallumo_0, r"(#include) (\S*)(.*)");

// mallumo-0.3.0: r"(ERROR: \d+:)(\d+)(: )(.+)"
consistent!(mallumo_1, r"(ERROR: \d+:)(\d+)(: )(.+)");

// mallumo-0.3.0: r"(\d+\()(\d+)(?:\) : )(.+)"
consistent!(mallumo_2, r"(\d+\()(\d+)(?:\) : )(.+)");

// magnet_more-0.0.1: r"(.+?)(\[.*?\])?"
consistent!(magnet_more_0, r"(.+?)(\[.*?\])?");

// magnet_app-0.0.1: r":(?P<k>[a-zA-Z_]+)"
consistent!(magnet_app_0, r":(?P<k>[a-zA-Z_]+)");

// yubibomb-0.2.0: r"^\d{6}(?:\s*,\s*\d{6})*$"
consistent!(yubibomb_0, r"^\d{6}(?:\s*,\s*\d{6})*$");

// multirust-rs-0.0.4: r"[\\/]([^\\/?]+)(\?.*)?$"
consistent!(multirust_rs_0, r"[\\/]([^\\/?]+)(\?.*)?$");

// hueclient-0.3.2: "\"[a-z]*\":null"
consistent!(hueclient_0, "\"[a-z]*\":null");

// hueclient-0.3.2: ",+"
consistent!(hueclient_1, ",+");

// hueclient-0.3.2: ",\\}"
consistent!(hueclient_2, ",\\}");

// hueclient-0.3.2: "\\{,"
consistent!(hueclient_3, "\\{,");

// aerial-0.1.0: r"[a-zA-Z_\$][a-zA-Z_0-9]*"
consistent!(aerial_0, r"[a-zA-Z_\$][a-zA-Z_0-9]*");

// aerial-0.1.0: r"thi[sng]+"
consistent!(aerial_1, r"thi[sng]+");

// rvue-0.1.0: r"(.+)\s+\((.+?)\)"
consistent!(rvue_0, r"(.+)\s+\((.+?)\)");

// rvue-0.1.0: r"([\d\.]+)\s*out\s*of\s*([\d\.]+)"
consistent!(rvue_1, r"([\d\.]+)\s*out\s*of\s*([\d\.]+)");

// rvue-0.1.0: r"^([\d\.]+)\s*(?:\(\))?$"
consistent!(rvue_2, r"^([\d\.]+)\s*(?:\(\))?$");

// rvue-0.1.0: r"([\d\.]+)\s*Points\s*Possible"
consistent!(rvue_3, r"([\d\.]+)\s*Points\s*Possible");

// rvue-0.1.0: r"([\d\.]+)\s*/\s*([\d\.]+)"
consistent!(rvue_4, r"([\d\.]+)\s*/\s*([\d\.]+)");

// rvsim-0.1.0: r"_?([_a-z0-9]+)\s*:\s*([_a-z0-9]+)\s*[,)]"
consistent!(rvsim_0, r"_?([_a-z0-9]+)\s*:\s*([_a-z0-9]+)\s*[,)]");

// nereon-0.1.4: "(.*[^\\\\])\\{\\}(.*)"
consistent!(nereon_0, "(.*[^\\\\])\\{\\}(.*)");

// next_episode-0.3.0: r"((?i)^(.+).s(\d+)e(\d+).*)$"
consistent!(next_episode_0, r"((?i)^(.+).s(\d+)e(\d+).*)$");

// migrant_lib-0.19.2: r"[^a-z0-9-]+"
consistent!(migrant_lib_0, r"[^a-z0-9-]+");

// migrant_lib-0.19.2: r"[0-9]{14}_[a-z0-9-]+"
consistent!(migrant_lib_1, r"[0-9]{14}_[a-z0-9-]+");

// migrant_lib-0.19.2: r"([0-9]{14}_)?[a-z0-9-]+"
consistent!(migrant_lib_2, r"([0-9]{14}_)?[a-z0-9-]+");

// minipre-0.2.0: "$_"
consistent!(minipre_0, "$_");

// minifier-0.0.13: r">\s+<"
consistent!(minifier_0, r">\s+<");

// minifier-0.0.13: r"\s{2,}|[\r\n]"
consistent!(minifier_1, r"\s{2,}|[\r\n]");

// minifier-0.0.13: r"<(style|script)[\w|\s].*?>"
consistent!(minifier_2, r"<(style|script)[\w|\s].*?>");

// minifier-0.0.13: "<!--(.|\n)*?-->"
consistent!(minifier_3, "<!--(.|\n)*?-->");

// minifier-0.0.13: r"<\w.*?>"
consistent!(minifier_4, r"<\w.*?>");

// minifier-0.0.13: r" \s+|\s +"
consistent!(minifier_5, r" \s+|\s +");

// minifier-0.0.13: r"\w\s+\w"
consistent!(minifier_6, r"\w\s+\w");

// minifier-0.0.13: r"'\s+>"
consistent!(minifier_7, r"'\s+>");

// minifier-0.0.13: r"\d\s+>"
consistent!(minifier_8, r"\d\s+>");

// ggp-rs-0.1.2: r"(?P<relation>\([^)]+\))|(?P<prop>[a-zA-Z0-9_]+)"
consistent!(ggp_rs_0, r"(?P<relation>\([^)]+\))|(?P<prop>[a-zA-Z0-9_]+)");

// ggp-rs-0.1.2: r"\((.*)\)."
consistent!(ggp_rs_1, r"\((.*)\).");

// poe-superfilter-0.2.0: "[A-Za-z0-9_]"
consistent!(poe_superfilter_0, "[A-Za-z0-9_]");

// poke-a-mango-0.5.0: r"(\d+)x(\d+)"
consistent!(poke_a_mango_0, r"(\d+)x(\d+)");

// pop3-rs-0.1.0: r"(?P<nmsg>\d+) (?P<size>\d+)"
consistent!(pop3_rs_0, r"(?P<nmsg>\d+) (?P<size>\d+)");

// pop3-rs-0.1.0: r"(?P<msgid>\d+) (?P<uidl>[\x21-\x7E]{1,70})"
consistent!(pop3_rs_1, r"(?P<msgid>\d+) (?P<uidl>[\x21-\x7E]{1,70})");

// pop3-rs-0.1.0: r"(<.*>)\r\n$"
consistent!(pop3_rs_2, r"(<.*>)\r\n$");

// pop3-rs-0.1.0: r"^(?P<status>\+OK|-ERR) (?P<statustext>.*)"
consistent!(pop3_rs_3, r"^(?P<status>\+OK|-ERR) (?P<statustext>.*)");

// pop3-1.0.6: r"^\.\r\n$"
consistent!(pop3_0, r"^\.\r\n$");

// pop3-1.0.6: r"\+OK(.*)"
consistent!(pop3_1, r"\+OK(.*)");

// pop3-1.0.6: r"-ERR(.*)"
consistent!(pop3_2, r"-ERR(.*)");

// pop3-1.0.6: r"\+OK (\d+) (\d+)\r\n"
consistent!(pop3_3, r"\+OK (\d+) (\d+)\r\n");

// pop3-1.0.6: r"(\d+) ([\x21-\x7e]+)\r\n"
consistent!(pop3_4, r"(\d+) ([\x21-\x7e]+)\r\n");

// pop3-1.0.6: r"\+OK (\d+) ([\x21-\x7e]+)\r\n"
consistent!(pop3_5, r"\+OK (\d+) ([\x21-\x7e]+)\r\n");

// pop3-1.0.6: r"(\d+) (\d+)\r\n"
consistent!(pop3_6, r"(\d+) (\d+)\r\n");

// pop3-1.0.6: r"\+OK (\d+) (\d+)\r\n"
consistent!(pop3_7, r"\+OK (\d+) (\d+)\r\n");

// polk-1.1.3: "github:(\\w+)/?(\\w+)?"
consistent!(polk_0, "github:(\\w+)/?(\\w+)?");

// geochunk-0.1.5: "^[0-9]{5}"
consistent!(geochunk_0, "^[0-9]{5}");

// generic-dns-update-1.1.4: r"((?:(?:0|1[\d]{0,2}|2(?:[0-4]\d?|5[0-5]?|[6-9])?|[3-9]\d?)\.){3}(?:0|1[\d]{0,2}|2(?:[0-4]\d?|5[0-5]?|[6-9])?|[3-9]\d?))"
consistent!(generic_dns_update_0, r"((?:(?:0|1[\d]{0,2}|2(?:[0-4]\d?|5[0-5]?|[6-9])?|[3-9]\d?)\.){3}(?:0|1[\d]{0,2}|2(?:[0-4]\d?|5[0-5]?|[6-9])?|[3-9]\d?))");

// generic-dns-update-1.1.4: r"((([0-9A-Fa-f]{1,4}:){7}[0-9A-Fa-f]{1,4})|(([0-9A-Fa-f]{1,4}:){6}:[0-9A-Fa-f]{1,4})|(([0-9A-Fa-f]{1,4}:){5}:([0-9A-Fa-f]{1,4}:)?[0-9A-Fa-f]{1,4})|(([0-9A-Fa-f]{1,4}:){4}:([0-9A-Fa-f]{1,4}:){0,2}[0-9A-Fa-f]{1,4})|(([0-9A-Fa-f]{1,4}:){3}:([0-9A-Fa-f]{1,4}:){0,3}[0-9A-Fa-f]{1,4})|(([0-9A-Fa-f]{1,4}:){2}:([0-9A-Fa-f]{1,4}:){0,4}[0-9A-Fa-f]{1,4})|(([0-9A-Fa-f]{1,4}:){6}((\d((25[0-5])|(1\d{2})|(2[0-4]\d)|(\d{1,2}))\d)\.){3}(\d((25[0-5])|(1\d{2})|(2[0-4]\d)|(\d{1,2}))\d))|(([0-9A-Fa-f]{1,4}:){0,5}:((\d((25[0-5])|(1\d{2})|(2[0-4]\d)|(\d{1,2}))\d)\.){3}(\d((25[0-5])|(1\d{2})|(2[0-4]\d)|(\d{1,2}))\d))|(::([0-9A-Fa-f]{1,4}:){0,5}((\d((25[0-5])|(1\d{2})|(2[0-4]\d)|(\d{1,2}))\d)\.){3}(\d((25[0-5])|(1\d{2})|(2[0-4]\d)|(\d{1,2}))\d))|([0-9A-Fa-f]{1,4}::([0-9A-Fa-f]{1,4}:){0,5}[0-9A-Fa-f]{1,4})|(::([0-9A-Fa-f]{1,4}:){0,6}[0-9A-Fa-f]{1,4})|(([0-9A-Fa-f]{1,4}:){1,7}:))"
consistent!(generic_dns_update_1, r"((([0-9A-Fa-f]{1,4}:){7}[0-9A-Fa-f]{1,4})|(([0-9A-Fa-f]{1,4}:){6}:[0-9A-Fa-f]{1,4})|(([0-9A-Fa-f]{1,4}:){5}:([0-9A-Fa-f]{1,4}:)?[0-9A-Fa-f]{1,4})|(([0-9A-Fa-f]{1,4}:){4}:([0-9A-Fa-f]{1,4}:){0,2}[0-9A-Fa-f]{1,4})|(([0-9A-Fa-f]{1,4}:){3}:([0-9A-Fa-f]{1,4}:){0,3}[0-9A-Fa-f]{1,4})|(([0-9A-Fa-f]{1,4}:){2}:([0-9A-Fa-f]{1,4}:){0,4}[0-9A-Fa-f]{1,4})|(([0-9A-Fa-f]{1,4}:){6}((\d((25[0-5])|(1\d{2})|(2[0-4]\d)|(\d{1,2}))\d)\.){3}(\d((25[0-5])|(1\d{2})|(2[0-4]\d)|(\d{1,2}))\d))|(([0-9A-Fa-f]{1,4}:){0,5}:((\d((25[0-5])|(1\d{2})|(2[0-4]\d)|(\d{1,2}))\d)\.){3}(\d((25[0-5])|(1\d{2})|(2[0-4]\d)|(\d{1,2}))\d))|(::([0-9A-Fa-f]{1,4}:){0,5}((\d((25[0-5])|(1\d{2})|(2[0-4]\d)|(\d{1,2}))\d)\.){3}(\d((25[0-5])|(1\d{2})|(2[0-4]\d)|(\d{1,2}))\d))|([0-9A-Fa-f]{1,4}::([0-9A-Fa-f]{1,4}:){0,5}[0-9A-Fa-f]{1,4})|(::([0-9A-Fa-f]{1,4}:){0,6}[0-9A-Fa-f]{1,4})|(([0-9A-Fa-f]{1,4}:){1,7}:))");

// generic-dns-update-1.1.4: r"<value><string>([0-9.]*)</string></value>"
consistent!(generic_dns_update_2, r"<value><string>([0-9.]*)</string></value>");

// generic-dns-update-1.1.4: r"<int>([0-9]+)</int>"
consistent!(generic_dns_update_3, r"<int>([0-9]+)</int>");

// generic-dns-update-1.1.4: r"<int>([0-9]+)</int>"
consistent!(generic_dns_update_4, r"<int>([0-9]+)</int>");

// generic-dns-update-1.1.4: r"<boolean>([0-1]*)</boolean>"
consistent!(generic_dns_update_5, r"<boolean>([0-1]*)</boolean>");

// generate-nix-pkg-0.3.0: r"(\d*)\.(\d*)\.(\d*)(-(\S*))?"
consistent!(generate_nix_pkg_0, r"(\d*)\.(\d*)\.(\d*)(-(\S*))?");

// generate-nix-pkg-0.3.0: r"^(\S*) (\d*)\.(\d*)\.(\d*)(-(\S*))?"
consistent!(generate_nix_pkg_1, r"^(\S*) (\d*)\.(\d*)\.(\d*)(-(\S*))?");

// genact-0.6.0: r"arch/([a-z0-9_])+/"
consistent!(genact_0, r"arch/([a-z0-9_])+/");

// genact-0.6.0: r"arch/([a-z0-9_])+/"
consistent!(genact_1, r"arch/([a-z0-9_])+/");

// cron_rs-0.1.6: r"^\s*((\*(/\d+)?)|[0-9-,/]+)(\s+((\*(/\d+)?)|[0-9-,/]+)){4,5}\s*$"
consistent!(cron_rs_0, r"^\s*((\*(/\d+)?)|[0-9-,/]+)(\s+((\*(/\d+)?)|[0-9-,/]+)){4,5}\s*$");

// systemfd-0.3.0: r"^([a-zA-Z]+)::(.+)$"
consistent!(systemfd_0, r"^([a-zA-Z]+)::(.+)$");

// symbolic-debuginfo-5.0.2: "__?hidden#\\d+_"
consistent!(symbolic_debuginfo_0, "__?hidden#\\d+_");

// symbolic-minidump-5.0.2: r"^Linux ([^ ]+) (.*) \w+(?: GNU/Linux)?$"
consistent!(symbolic_minidump_0, r"^Linux ([^ ]+) (.*) \w+(?: GNU/Linux)?$");

// graphql-idl-parser-0.1.1: "^(?u:\\#)(?u:[\t-\r - \u{85}-\u{85}\u{a0}-\u{a0}\u{1680}-\u{1680}\u{2000}-\u{200a}\u{2028}-\u{2029}\u{202f}-\u{202f}\u{205f}-\u{205f}\u{3000}-\u{3000}])*(?u:.)+"
consistent!(graphql_idl_parser_0, "^(?u:\\#)(?u:[\t-\r - \u{85}-\u{85}\u{a0}-\u{a0}\u{1680}-\u{1680}\u{2000}-\u{200a}\u{2028}-\u{2029}\u{202f}-\u{202f}\u{205f}-\u{205f}\u{3000}-\u{3000}])*(?u:.)+");

// graphql-idl-parser-0.1.1: "^(?u:=)(?u:[\t-\r - \u{85}-\u{85}\u{a0}-\u{a0}\u{1680}-\u{1680}\u{2000}-\u{200a}\u{2028}-\u{2029}\u{202f}-\u{202f}\u{205f}-\u{205f}\u{3000}-\u{3000}])*(?u:.)+"
consistent!(graphql_idl_parser_1, "^(?u:=)(?u:[\t-\r - \u{85}-\u{85}\u{a0}-\u{a0}\u{1680}-\u{1680}\u{2000}-\u{200a}\u{2028}-\u{2029}\u{202f}-\u{202f}\u{205f}-\u{205f}\u{3000}-\u{3000}])*(?u:.)+");

// graphql-idl-parser-0.1.1: "^(?u:[A-Z_-_a-z])(?u:[0-9A-Z_-_a-z])*"
consistent!(graphql_idl_parser_2, "^(?u:[A-Z_-_a-z])(?u:[0-9A-Z_-_a-z])*");

// graphql-idl-parser-0.1.1: "^(?u:!)"
consistent!(graphql_idl_parser_3, "^(?u:!)");

// graphql-idl-parser-0.1.1: "^(?u:\\()"
consistent!(graphql_idl_parser_4, "^(?u:\\()");

// graphql-idl-parser-0.1.1: "^(?u:\\))"
consistent!(graphql_idl_parser_5, "^(?u:\\))");

// graphql-idl-parser-0.1.1: "^(?u:,)"
consistent!(graphql_idl_parser_6, "^(?u:,)");

// graphql-idl-parser-0.1.1: "^(?u::)"
consistent!(graphql_idl_parser_7, "^(?u::)");

// graphql-idl-parser-0.1.1: "^(?u:@)"
consistent!(graphql_idl_parser_8, "^(?u:@)");

// graphql-idl-parser-0.1.1: "^(?u:\\[)"
consistent!(graphql_idl_parser_9, "^(?u:\\[)");

// graphql-idl-parser-0.1.1: "^(?u:\\])"
consistent!(graphql_idl_parser_10, "^(?u:\\])");

// graphql-idl-parser-0.1.1: "^(?u:enum)"
consistent!(graphql_idl_parser_11, "^(?u:enum)");

// graphql-idl-parser-0.1.1: "^(?u:implements)"
consistent!(graphql_idl_parser_12, "^(?u:implements)");

// graphql-idl-parser-0.1.1: "^(?u:input)"
consistent!(graphql_idl_parser_13, "^(?u:input)");

// graphql-idl-parser-0.1.1: "^(?u:interface)"
consistent!(graphql_idl_parser_14, "^(?u:interface)");

// graphql-idl-parser-0.1.1: "^(?u:scalar)"
consistent!(graphql_idl_parser_15, "^(?u:scalar)");

// graphql-idl-parser-0.1.1: "^(?u:type)"
consistent!(graphql_idl_parser_16, "^(?u:type)");

// graphql-idl-parser-0.1.1: "^(?u:union)"
consistent!(graphql_idl_parser_17, "^(?u:union)");

// graphql-idl-parser-0.1.1: "^(?u:\\{)"
consistent!(graphql_idl_parser_18, "^(?u:\\{)");

// graphql-idl-parser-0.1.1: "^(?u:\\})"
consistent!(graphql_idl_parser_19, "^(?u:\\})");

// grimoire-0.1.0: r"(?s)/\*(?P<config>.*?)\*/"
consistent!(grimoire_0, r"(?s)/\*(?P<config>.*?)\*/");

// phonenumber-0.2.0+8.9.0: r"[\d]+(?:[~\x{2053}\x{223C}\x{FF5E}][\d]+)?"
consistent!(phonenumber_0, r"[\d]+(?:[~\x{2053}\x{223C}\x{FF5E}][\d]+)?");

// phonenumber-0.2.0+8.9.0: r"[, \[\]]"
consistent!(phonenumber_1, r"[, \[\]]");

// phonenumber-0.2.0+8.9.0: r"[\\/] *x"
consistent!(phonenumber_2, r"[\\/] *x");

// phonenumber-0.2.0+8.9.0: r"[[\P{N}&&\P{L}]&&[^#]]+$"
consistent!(phonenumber_3, r"[[\P{N}&&\P{L}]&&[^#]]+$");

// phonenumber-0.2.0+8.9.0: r"(?:.*?[A-Za-z]){3}.*"
consistent!(phonenumber_4, r"(?:.*?[A-Za-z]){3}.*");

// phonenumber-0.2.0+8.9.0: r"(\D+)"
consistent!(phonenumber_5, r"(\D+)");

// phonenumber-0.2.0+8.9.0: r"(\$\d)"
consistent!(phonenumber_6, r"(\$\d)");

// phonenumber-0.2.0+8.9.0: r"\(?\$1\)?"
consistent!(phonenumber_7, r"\(?\$1\)?");

// phone_number-0.1.0: r"\D"
consistent!(phone_number_0, r"\D");

// phone_number-0.1.0: r"^0+"
consistent!(phone_number_1, r"^0+");

// phone_number-0.1.0: r"^89"
consistent!(phone_number_2, r"^89");

// phone_number-0.1.0: r"^8+"
consistent!(phone_number_3, r"^8+");

// phile-0.1.4: r"^ *(\^_*\^) *$"
consistent!(phile_0, r"^ *(\^_*\^) *$");

// phile-0.1.4: r"^[_\p{XID_Start}]$"
consistent!(phile_1, r"^[_\p{XID_Start}]$");

// phile-0.1.4: r"^\p{XID_Continue}$"
consistent!(phile_2, r"^\p{XID_Continue}$");

// uritemplate-0.1.2: "%25(?P<hex>[0-9a-fA-F][0-9a-fA-F])"
consistent!(uritemplate_0, "%25(?P<hex>[0-9a-fA-F][0-9a-fA-F])");

// urdf-rs-0.4.2: "^package://(\\w+)/"
consistent!(urdf_rs_0, "^package://(\\w+)/");

// url-match-0.1.7: r"(?P<key>[?&.])"
consistent!(url_match_0, r"(?P<key>[?&.])");

// url-match-0.1.7: r":(?P<key>[a-zA-Z0-9_-]+)"
consistent!(url_match_1, r":(?P<key>[a-zA-Z0-9_-]+)");

// tsm-sys-0.1.0: r"hello world"
consistent!(tsm_sys_0, r"hello world");

// deb-version-0.1.0: "^(?:(?:(?:\\d+:).+)|(?:[^:]+))$"
consistent!(deb_version_0, "^(?:(?:(?:\\d+:).+)|(?:[^:]+))$");

// debcargo-2.1.0: r"^(?i)(a|an|the)\s+"
consistent!(debcargo_0, r"^(?i)(a|an|the)\s+");

// debcargo-2.1.0: r"^(?i)(rust\s+)?(implementation|library|tool|crate)\s+(of|to|for)\s+"
consistent!(debcargo_1, r"^(?i)(rust\s+)?(implementation|library|tool|crate)\s+(of|to|for)\s+");

// feaders-0.2.0: r"^.*\.h$"
consistent!(feaders_0, r"^.*\.h$");

// feaders-0.2.0: r"^.*\.c$"
consistent!(feaders_1, r"^.*\.c$");

// feaders-0.2.0: r"^.*\.hpp$"
consistent!(feaders_2, r"^.*\.hpp$");

// feaders-0.2.0: r"^.*\.cc$"
consistent!(feaders_3, r"^.*\.cc$");

// feaders-0.2.0: r"^.*\.cpp$"
consistent!(feaders_4, r"^.*\.cpp$");

// hyperscan-0.1.6: r"CPtr\(\w+\)"
consistent!(hyperscan_0, r"CPtr\(\w+\)");

// hyperscan-0.1.6: r"^Version:\s(\d\.\d\.\d)\sFeatures:\s+(\w+)?\sMode:\s(\w+)$"
consistent!(hyperscan_1, r"^Version:\s(\d\.\d\.\d)\sFeatures:\s+(\w+)?\sMode:\s(\w+)$");

// hyperscan-0.1.6: r"RawDatabase<Block>\{db: \w+\}"
consistent!(hyperscan_2, r"RawDatabase<Block>\{db: \w+\}");

// hyperscan-0.1.6: r"RawSerializedDatabase\{p: \w+, len: \d+\}"
consistent!(hyperscan_3, r"RawSerializedDatabase\{p: \w+, len: \d+\}");

// ucd-parse-0.1.1: r"[0-9A-F]+"
consistent!(ucd_parse_0, r"[0-9A-F]+");

// afsort-0.2.0: r".*"
consistent!(afsort_0, r".*");

// afsort-0.2.0: r".*"
consistent!(afsort_1, r".*");

// afsort-0.2.0: r".*"
consistent!(afsort_2, r".*");

// afsort-0.2.0: r".*"
consistent!(afsort_3, r".*");

// afsort-0.2.0: r".*"
consistent!(afsort_4, r".*");

// afsort-0.2.0: r".*"
consistent!(afsort_5, r".*");

// afsort-0.2.0: r"^[a-z]+$"
consistent!(afsort_6, r"^[a-z]+$");

// afsort-0.2.0: r"^[a-z]+$"
consistent!(afsort_7, r"^[a-z]+$");

// tin-summer-1.21.4: r"(\.git|\.pijul|_darcs|\.hg)$"
consistent!(tin_summer_0, r"(\.git|\.pijul|_darcs|\.hg)$");

// tin-drummer-1.0.1: r".*?\.(a|la|lo|o|ll|keter|bc|dyn_o|d|rlib|crate|min\.js|hi|dyn_hi|S|jsexe|webapp|js\.externs|ibc|toc|aux|fdb_latexmk|fls|egg-info|whl|js_a|js_hi|jld|ji|js_o|so.*|dump-.*|vmb|crx|orig|elmo|elmi|pyc|mod|p_hi|p_o|prof|tix)$"
consistent!(tin_drummer_0, r".*?\.(a|la|lo|o|ll|keter|bc|dyn_o|d|rlib|crate|min\.js|hi|dyn_hi|S|jsexe|webapp|js\.externs|ibc|toc|aux|fdb_latexmk|fls|egg-info|whl|js_a|js_hi|jld|ji|js_o|so.*|dump-.*|vmb|crx|orig|elmo|elmi|pyc|mod|p_hi|p_o|prof|tix)$");

// tin-drummer-1.0.1: r".*?\.(stats|conf|h|out|cache.*|dat|pc|info|\.js)$"
consistent!(tin_drummer_1, r".*?\.(stats|conf|h|out|cache.*|dat|pc|info|\.js)$");

// tin-drummer-1.0.1: r".*?\.(exe|a|la|o|ll|keter|bc|dyn_o|d|rlib|crate|min\.js|hi|dyn_hi|jsexe|webapp|js\.externs|ibc|toc|aux|fdb_latexmk|fls|egg-info|whl|js_a|js_hi|jld|ji|js_o|so.*|dump-.*|vmb|crx|orig|elmo|elmi|pyc|mod|p_hi|p_o|prof|tix)$"
consistent!(tin_drummer_2, r".*?\.(exe|a|la|o|ll|keter|bc|dyn_o|d|rlib|crate|min\.js|hi|dyn_hi|jsexe|webapp|js\.externs|ibc|toc|aux|fdb_latexmk|fls|egg-info|whl|js_a|js_hi|jld|ji|js_o|so.*|dump-.*|vmb|crx|orig|elmo|elmi|pyc|mod|p_hi|p_o|prof|tix)$");

// tin-drummer-1.0.1: r".*?\.(stats|conf|h|out|cache.*|\.js)$"
consistent!(tin_drummer_3, r".*?\.(stats|conf|h|out|cache.*|\.js)$");

// tin-drummer-1.0.1: r"(\.git|\.pijul|_darcs|\.hg)$"
consistent!(tin_drummer_4, r"(\.git|\.pijul|_darcs|\.hg)$");

// tin-drummer-1.0.1: r".*?\.(dyn_o|out|d|hi|dyn_hi|dump-.*|p_hi|p_o|prof|tix)$"
consistent!(tin_drummer_5, r".*?\.(dyn_o|out|d|hi|dyn_hi|dump-.*|p_hi|p_o|prof|tix)$");

// tin-drummer-1.0.1: r".*?\.(ibc)$"
consistent!(tin_drummer_6, r".*?\.(ibc)$");

// tin-drummer-1.0.1: r"\.stack-work|dist-newstyle"
consistent!(tin_drummer_7, r"\.stack-work|dist-newstyle");

// timmy-0.3.0: r"_NET_WM_PID\(CARDINAL\) = (\d+)"
consistent!(timmy_0, r"_NET_WM_PID\(CARDINAL\) = (\d+)");

// timmy-0.3.0: r"today|yesterday|now"
consistent!(timmy_1, r"today|yesterday|now");

// timmy-0.3.0: r"(?P<day>\d{1,2})/(?P<month>\d{1,2})(/(?P<year>\d{4}|\d{2}))?"
consistent!(timmy_2, r"(?P<day>\d{1,2})/(?P<month>\d{1,2})(/(?P<year>\d{4}|\d{2}))?");

// timmy-0.3.0: r"(?P<n>\d+) (days?|ds?)(?P<ago>( ago)?)"
consistent!(timmy_3, r"(?P<n>\d+) (days?|ds?)(?P<ago>( ago)?)");

// timmy-0.3.0: r"(?P<hr>\d{2}):(?P<mins>\d{2})"
consistent!(timmy_4, r"(?P<hr>\d{2}):(?P<mins>\d{2})");

// tinfo-0.5.0: r"^(\d+): \d+ windows \(.*\) \[\d+x\d+\]( \(attached\))?"
consistent!(tinfo_0, r"^(\d+): \d+ windows \(.*\) \[\d+x\d+\]( \(attached\))?");

// tinfo-0.5.0: r"^(\d+):(\d+): (.*) \((\d+) panes\) \[(\d+)x(\d+)\]"
consistent!(tinfo_1, r"^(\d+):(\d+): (.*) \((\d+) panes\) \[(\d+)x(\d+)\]");

// timespan-0.0.4: r"(?:\\\{start\\\}|\\\{end\\\})"
consistent!(timespan_0, r"(?:\\\{start\\\}|\\\{end\\\})");

// timespan-0.0.4: r"(.*)\s+-\s+(.*)"
consistent!(timespan_1, r"(.*)\s+-\s+(.*)");

// timespan-0.0.4: r"(.*)\s+(\w+)$"
consistent!(timespan_2, r"(.*)\s+(\w+)$");

// timespan-0.0.4: r"(.*)\s+(\w+)$"
consistent!(timespan_3, r"(.*)\s+(\w+)$");

// timespan-0.0.4: r"(.*)\s+-\s+(.*)"
consistent!(timespan_4, r"(.*)\s+-\s+(.*)");

// titlecase-0.10.0: r"[[:lower:]]"
consistent!(titlecase_0, r"[[:lower:]]");

// tight-0.1.3: r"^\d+ (day|week|month|year)s?$"
consistent!(tight_0, r"^\d+ (day|week|month|year)s?$");

// tight-0.1.3: r"^\d+ (day|week|month|year)s?$"
consistent!(tight_1, r"^\d+ (day|week|month|year)s?$");

// yaml-0.2.1: r"^[-+]?(0|[1-9][0-9_]*)$"
consistent!(yaml_0, r"^[-+]?(0|[1-9][0-9_]*)$");

// yaml-0.2.1: r"^([-+]?)0o?([0-7_]+)$"
consistent!(yaml_1, r"^([-+]?)0o?([0-7_]+)$");

// yaml-0.2.1: r"^([-+]?)0x([0-9a-fA-F_]+)$"
consistent!(yaml_2, r"^([-+]?)0x([0-9a-fA-F_]+)$");

// yaml-0.2.1: r"^([-+]?)0b([0-1_]+)$"
consistent!(yaml_3, r"^([-+]?)0b([0-1_]+)$");

// yaml-0.2.1: r"^([-+]?)(\.[0-9]+|[0-9]+(\.[0-9]*)?([eE][-+]?[0-9]+)?)$"
consistent!(yaml_4, r"^([-+]?)(\.[0-9]+|[0-9]+(\.[0-9]*)?([eE][-+]?[0-9]+)?)$");

// yaml-0.2.1: r"^[+]?(\.inf|\.Inf|\.INF)$"
consistent!(yaml_5, r"^[+]?(\.inf|\.Inf|\.INF)$");

// yaml-0.2.1: r"^-(\.inf|\.Inf|\.INF)$"
consistent!(yaml_6, r"^-(\.inf|\.Inf|\.INF)$");

// yaml-0.2.1: r"^(\.nan|\.NaN|\.NAN)$"
consistent!(yaml_7, r"^(\.nan|\.NaN|\.NAN)$");

// yaml-0.2.1: r"^(null|Null|NULL|~)$"
consistent!(yaml_8, r"^(null|Null|NULL|~)$");

// yaml-0.2.1: r"^(true|True|TRUE|yes|Yes|YES)$"
consistent!(yaml_9, r"^(true|True|TRUE|yes|Yes|YES)$");

// yaml-0.2.1: r"^(false|False|FALSE|no|No|NO)$"
consistent!(yaml_10, r"^(false|False|FALSE|no|No|NO)$");

// kefia-0.1.0: r"(?m)^(\S+)/(\S+) (\S+)(?: \((.*)\))?$"
consistent!(kefia_0, r"(?m)^(\S+)/(\S+) (\S+)(?: \((.*)\))?$");

// risp-0.7.0: "^(\\s+|;.*?(\n|$))+"
consistent!(risp_0, "^(\\s+|;.*?(\n|$))+");

// risp-0.7.0: "^\".*?\""
consistent!(risp_1, "^\".*?\"");

// risp-0.7.0: r"^[^\s\{\}()\[\]]+"
consistent!(risp_2, r"^[^\s\{\}()\[\]]+");

// risp-0.7.0: r"^-?\d+"
consistent!(risp_3, r"^-?\d+");

// ripgrep-0.8.1: "^([0-9]+)([KMG])?$"
consistent!(ripgrep_0, "^([0-9]+)([KMG])?$");

// riquid-0.0.1: r"^\w+"
consistent!(riquid_0, r"^\w+");

// riquid-0.0.1: r"^\d+"
consistent!(riquid_1, r"^\d+");

// recursive_disassembler-2.1.2: r"\A(0x)?([a-fA-F0-9]+)\z"
consistent!(recursive_disassembler_0, r"\A(0x)?([a-fA-F0-9]+)\z");

// remake-0.1.0: r"^[a-zA-Z_][a-zA-Z0-9_]*"
consistent!(remake_0, r"^[a-zA-Z_][a-zA-Z0-9_]*");

// regex-decode-0.1.0: r"'(?P<title>[^']+)'\s+\((?P<year>\d{4})\)"
consistent!(regex_decode_0, r"'(?P<title>[^']+)'\s+\((?P<year>\d{4})\)");

// regex-decode-0.1.0: r"'(?P<title>[^']+)'\s+\((?P<year>\d{4})\)"
consistent!(regex_decode_1, r"'(?P<title>[^']+)'\s+\((?P<year>\d{4})\)");

// regex-decode-0.1.0: r"'(?P<title>[^']+)'\s+\((?P<year>\d{4})\)"
consistent!(regex_decode_2, r"'(?P<title>[^']+)'\s+\((?P<year>\d{4})\)");

// regex-decode-0.1.0: r"'(?P<title>[^']+)'\s+\((?P<year>\d{4})\)"
consistent!(regex_decode_3, r"'(?P<title>[^']+)'\s+\((?P<year>\d{4})\)");

// regex-decode-0.1.0: r"'(?P<title>[^']+)'\s+\((?P<year>\d{4})\)"
consistent!(regex_decode_4, r"'(?P<title>[^']+)'\s+\((?P<year>\d{4})\)");

// regex-decode-0.1.0: r"'(?P<title>[^']+)'\s+\((?P<year>\d{4})\)"
consistent!(regex_decode_5, r"'(?P<title>[^']+)'\s+\((?P<year>\d{4})\)");

// regex-decode-0.1.0: r"'(?P<title>[^']+)'\s+\((?P<year>\d{2})\)"
consistent!(regex_decode_6, r"'(?P<title>[^']+)'\s+\((?P<year>\d{2})\)");

// regex-decode-0.1.0: r"'(?P<title>[^']+)'\s+\((?P<year>\d{4})\)"
consistent!(regex_decode_7, r"'(?P<title>[^']+)'\s+\((?P<year>\d{4})\)");

// regex-decode-0.1.0: r"'(?P<title>[^']+)'\s+\((?P<year>\d{4})\)"
consistent!(regex_decode_8, r"'(?P<title>[^']+)'\s+\((?P<year>\d{4})\)");

// regex-decode-0.1.0: r"'(?P<title>[^']+)'\s+\((?P<year>\d{4})?\)"
consistent!(regex_decode_9, r"'(?P<title>[^']+)'\s+\((?P<year>\d{4})?\)");

// regex-decode-0.1.0: r"'(?P<title>[^']+)'\s+\((?P<year>\d{4})?\)"
consistent!(regex_decode_10, r"'(?P<title>[^']+)'\s+\((?P<year>\d{4})?\)");

// regex-decode-0.1.0: r"'(?P<title>[^']+)'\s+\((?P<year>\d{4})?\)"
consistent!(regex_decode_11, r"'(?P<title>[^']+)'\s+\((?P<year>\d{4})?\)");

// regex-decode-0.1.0: r"'(?P<title>[^']+)'\s+\((?P<year>\d{4})?\)"
consistent!(regex_decode_12, r"'(?P<title>[^']+)'\s+\((?P<year>\d{4})?\)");

// regex-decode-0.1.0: r"'(?P<title>[^']+)'\s+\((?P<year>\d{4})?\)"
consistent!(regex_decode_13, r"'(?P<title>[^']+)'\s+\((?P<year>\d{4})?\)");

// regex-cache-0.2.0: "[0-9]{3}-[0-9]{3}-[0-9]{4}"
consistent!(regex_cache_0, "[0-9]{3}-[0-9]{3}-[0-9]{4}");

// regex-cache-0.2.0: r"^\d+$"
consistent!(regex_cache_1, r"^\d+$");

// regex-cache-0.2.0: r"^[a-z]+$"
consistent!(regex_cache_2, r"^[a-z]+$");

// regex-cache-0.2.0: r"^\d+$"
consistent!(regex_cache_3, r"^\d+$");

// regex-cache-0.2.0: r"^\d+$"
consistent!(regex_cache_4, r"^\d+$");

// regex_dfa-0.5.0: r"\d{4}-\d{2}-\d{2}"
consistent!(regex_dfa_0, r"\d{4}-\d{2}-\d{2}");

// reaper-2.0.0: r"^[0-9\p{L} _\\.]{3,16}$"
consistent!(reaper_0, r"^[0-9\p{L} _\\.]{3,16}$");

// retdec-0.1.0: r"^attachment; filename=(.+)$"
consistent!(retdec_0, r"^attachment; filename=(.+)$");

// renvsubst-0.1.2: r"(\\)(?P<head>\$[0-9A-Za-z_{])"
consistent!(renvsubst_0, r"(\\)(?P<head>\$[0-9A-Za-z_{])");

// renvsubst-0.1.2: r"\$([[:word:]]+)"
consistent!(renvsubst_1, r"\$([[:word:]]+)");

// renvsubst-0.1.2: r"\$\{([[:word:]]+)\}"
consistent!(renvsubst_2, r"\$\{([[:word:]]+)\}");

// rexpect-0.3.0: r"'[a-z]+'"
consistent!(rexpect_0, r"'[a-z]+'");

// rexpect-0.3.0: r"^\d{4}-\d{2}-\d{2}$"
consistent!(rexpect_1, r"^\d{4}-\d{2}-\d{2}$");

// rexpect-0.3.0: r"-\d{2}-"
consistent!(rexpect_2, r"-\d{2}-");

// luther-0.1.0: "^a(b|c)c*$"
consistent!(luther_0, "^a(b|c)c*$");

// little_boxes-1.6.0: r"(\x9B|\x1B\[)[0-?]*[ -/]*[@-~]"
consistent!(little_boxes_0, r"(\x9B|\x1B\[)[0-?]*[ -/]*[@-~]");

// libimagentrytag-0.8.0: "^[a-zA-Z]([a-zA-Z0-9_-]*)$"
consistent!(libimagentrytag_0, "^[a-zA-Z]([a-zA-Z0-9_-]*)$");

// libimaginteraction-0.8.0: r"^[Yy](\n?)$"
consistent!(libimaginteraction_0, r"^[Yy](\n?)$");

// libimaginteraction-0.8.0: r"^[Nn](\n?)$"
consistent!(libimaginteraction_1, r"^[Nn](\n?)$");

// libimagutil-0.8.0: "^(?P<KEY>([^=]*))=(.*)$"
consistent!(libimagutil_0, "^(?P<KEY>([^=]*))=(.*)$");

// libimagutil-0.8.0: "(.*)=(\"(?P<QVALUE>([^\"]*))\"|(?P<VALUE>(.*)))$"
consistent!(libimagutil_1, "(.*)=(\"(?P<QVALUE>([^\"]*))\"|(?P<VALUE>(.*)))$");

// linux_ip-0.1.0: r"\s+"
consistent!(linux_ip_0, r"\s+");

// linux_ip-0.1.0: r"\s*[\n\r]+\s*"
consistent!(linux_ip_1, r"\s*[\n\r]+\s*");

// linux_ip-0.1.0: r"^([0-9a-fA-F\.:/]+)\s+dev\s+([a-z0-9\.]+)\s*(.*)$"
consistent!(linux_ip_2, r"^([0-9a-fA-F\.:/]+)\s+dev\s+([a-z0-9\.]+)\s*(.*)$");

// linux_ip-0.1.0: r"^([0-9a-fA-F\.:/]+|default)\s+via\s+([a-z0-9\.:]+)\s+dev\s+([a-z0-9\.]+)\s*(.*)$"
consistent!(linux_ip_3, r"^([0-9a-fA-F\.:/]+|default)\s+via\s+([a-z0-9\.:]+)\s+dev\s+([a-z0-9\.]+)\s*(.*)$");

// linux_ip-0.1.0: r"^(blackhole)\s+([0-9a-fA-F\.:/]+)$"
consistent!(linux_ip_4, r"^(blackhole)\s+([0-9a-fA-F\.:/]+)$");

// linux_ip-0.1.0: r"^(unreachable)\s+([0-9a-fA-F\.:/]+)\s+dev\s+([a-z0-9\.]+)\s+(.*)$"
consistent!(linux_ip_5, r"^(unreachable)\s+([0-9a-fA-F\.:/]+)\s+dev\s+([a-z0-9\.]+)\s+(.*)$");

// linux_ip-0.1.0: r"\s*[\n\r]+\s*"
consistent!(linux_ip_6, r"\s*[\n\r]+\s*");

// linux_ip-0.1.0: r"^\d+:\s+([a-zA-Z0-9\.-]+)(@\S+)*:\s+(.*)$"
consistent!(linux_ip_7, r"^\d+:\s+([a-zA-Z0-9\.-]+)(@\S+)*:\s+(.*)$");

// linux_ip-0.1.0: r"\s*link/ether\s+([a-f0-9:]+)\s+.*"
consistent!(linux_ip_8, r"\s*link/ether\s+([a-f0-9:]+)\s+.*");

// linux_ip-0.1.0: r"\s*inet[6]*\s+([0-9a-f:\./]+)\s+.*"
consistent!(linux_ip_9, r"\s*inet[6]*\s+([0-9a-f:\./]+)\s+.*");

// linky-0.1.4: r"[^\w -]"
consistent!(linky_0, r"[^\w -]");

// linky-0.1.4: r"^(.*):(\d+): [^ ]* ([^ ]*)$"
consistent!(linky_1, r"^(.*):(\d+): [^ ]* ([^ ]*)$");

// limonite-0.2.1: r"^(\d{4}-\d{2}-\d{2})-(\d{3})-(.+)$"
consistent!(limonite_0, r"^(\d{4}-\d{2}-\d{2})-(\d{3})-(.+)$");

// process-queue-0.1.1: r"^[a-zA-Z]+$"
consistent!(process_queue_0, r"^[a-zA-Z]+$");

// pronghorn-0.1.2: r"^\{([a-zA-Z_]+)\}$"
consistent!(pronghorn_0, r"^\{([a-zA-Z_]+)\}$");

// protocol-ftp-client-0.1.1: "(?m:^(\\d{3}) (.+)\r$)"
consistent!(protocol_ftp_client_0, "(?m:^(\\d{3}) (.+)\r$)");

// protocol-ftp-client-0.1.1: "\"(.+)\""
consistent!(protocol_ftp_client_1, "\"(.+)\"");

// protocol-ftp-client-0.1.1: "(\\w+) [Tt]ype: (\\w+)"
consistent!(protocol_ftp_client_2, "(\\w+) [Tt]ype: (\\w+)");

// protocol-ftp-client-0.1.1: "(?m:^(\\d{3})-.+\r$)"
consistent!(protocol_ftp_client_3, "(?m:^(\\d{3})-.+\r$)");

// protocol-ftp-client-0.1.1: "Entering Passive Mode \\((\\d+),(\\d+),(\\d+),(\\d+),(\\d+),(\\d+)\\)"
consistent!(protocol_ftp_client_4, "Entering Passive Mode \\((\\d+),(\\d+),(\\d+),(\\d+),(\\d+),(\\d+)\\)");

// protocol-ftp-client-0.1.1: "(?m:^(.+)\r$)"
consistent!(protocol_ftp_client_5, "(?m:^(.+)\r$)");

// protocol-ftp-client-0.1.1: "^([d-])(?:[rwx-]{3}){3} +\\d+ +\\w+ +\\w+ +(\\d+) +(.+) +(.+)$"
consistent!(protocol_ftp_client_6, "^([d-])(?:[rwx-]{3}){3} +\\d+ +\\w+ +\\w+ +(\\d+) +(.+) +(.+)$");

// article-date-extractor-0.1.1: r"([\./\-_]{0,1}(19|20)\d{2})[\./\-_]{0,1}(([0-3]{0,1}[0-9][\./\-_])|(\w{3,5}[\./\-_]))([0-3]{0,1}[0-9][\./\-]{0,1})"
consistent!(article_date_extractor_0, r"([\./\-_]{0,1}(19|20)\d{2})[\./\-_]{0,1}(([0-3]{0,1}[0-9][\./\-_])|(\w{3,5}[\./\-_]))([0-3]{0,1}[0-9][\./\-]{0,1})");

// article-date-extractor-0.1.1: r"(?i)publishdate|pubdate|timestamp|article_date|articledate|date"
consistent!(article_date_extractor_1, r"(?i)publishdate|pubdate|timestamp|article_date|articledate|date");

// arthas_plugin-0.1.1: r"type\((.*)\)"
consistent!(arthas_plugin_0, r"type\((.*)\)");

// arthas_plugin-0.1.1: r"Vec<(.*)>"
consistent!(arthas_plugin_1, r"Vec<(.*)>");

// arthas_plugin-0.1.1: r"Option<(.*)>"
consistent!(arthas_plugin_2, r"Option<(.*)>");

// arthas_plugin-0.1.1: r"HashMap<[a-z0-9A-Z]+, *(.*)>"
consistent!(arthas_plugin_3, r"HashMap<[a-z0-9A-Z]+, *(.*)>");

// arthas_derive-0.1.0: "Vec *< *(.*) *>"
consistent!(arthas_derive_0, "Vec *< *(.*) *>");

// arthas_derive-0.1.0: r"Option *< *(.*) *>"
consistent!(arthas_derive_1, r"Option *< *(.*) *>");

// arthas_derive-0.1.0: r"HashMap *< *[a-z0-9A-Z]+ *, *(.*) *>"
consistent!(arthas_derive_2, r"HashMap *< *[a-z0-9A-Z]+ *, *(.*) *>");

// arpabet-0.2.0: r"^([\w\-\(\)\.']+)\s+([^\s].*)\s*$"
consistent!(arpabet_0, r"^([\w\-\(\)\.']+)\s+([^\s].*)\s*$");

// arpabet-0.2.0: r"^;;;\s+"
consistent!(arpabet_1, r"^;;;\s+");

// glossy_codegen-0.2.0: r"/\*.*?\*/|//.*"
consistent!(glossy_codegen_0, r"/\*.*?\*/|//.*");

// glossy_codegen-0.2.0: "^\\s*#\\s*include\\s+<([:print:]+)>\\s*$"
consistent!(glossy_codegen_1, "^\\s*#\\s*include\\s+<([:print:]+)>\\s*$");

// glossy_codegen-0.2.0: "^\\s*#\\s*include\\s+\"([:print:]+)\"\\s*$"
consistent!(glossy_codegen_2, "^\\s*#\\s*include\\s+\"([:print:]+)\"\\s*$");

// glossy_codegen-0.2.0: r"^\s*#\s*version\s+(\d+)"
consistent!(glossy_codegen_3, r"^\s*#\s*version\s+(\d+)");

// glossy_codegen-0.2.0: r"^\s*$"
consistent!(glossy_codegen_4, r"^\s*$");

// gluster-1.0.1: r"(?P<addr>via \S+)"
consistent!(gluster_0, r"(?P<addr>via \S+)");

// gluster-1.0.1: r"(?P<src>src \S+)"
consistent!(gluster_1, r"(?P<src>src \S+)");

// gl_helpers-0.1.7: r"(.*)\[\d+\]"
consistent!(gl_helpers_0, r"(.*)\[\d+\]");

// gl_helpers-0.1.7: r"(\d+).(\d+)"
consistent!(gl_helpers_1, r"(\d+).(\d+)");

// glr-parser-0.0.1: r"(?P<c>[\\\.\+\*\?\(\)\|\[\]\{\}\^\$])"
consistent!(glr_parser_0, r"(?P<c>[\\\.\+\*\?\(\)\|\[\]\{\}\^\$])");

// glr-parser-0.0.1: r"^\w+$"
consistent!(glr_parser_1, r"^\w+$");

// glr-parser-0.0.1: "'[^']+'"
consistent!(glr_parser_2, "'[^']+'");

// hoodlum-0.5.0: r"(?m)//.*"
consistent!(hoodlum_0, r"(?m)//.*");

// form-checker-0.2.2: r"^1\d{10}$"
consistent!(form_checker_0, r"^1\d{10}$");

// form-checker-0.2.2: r"(?i)^[\w.%+-]+@(?:[A-Z0-9-]+\.)+[A-Z]{2,4}$"
consistent!(form_checker_1, r"(?i)^[\w.%+-]+@(?:[A-Z0-9-]+\.)+[A-Z]{2,4}$");

// wikibase-0.2.0: r"(?P<user_agent>[a-zA-Z0-9-_]+/[0-9\.]+)"
consistent!(wikibase_0, r"(?P<user_agent>[a-zA-Z0-9-_]+/[0-9\.]+)");

// wifiscanner-0.3.6: r"Cell [0-9]{2,} - Address:"
consistent!(wifiscanner_0, r"Cell [0-9]{2,} - Address:");

// wifiscanner-0.3.6: r"([0-9a-zA-Z]{1}[0-9a-zA-Z]{1}[:]{1}){5}[0-9a-zA-Z]{1}[0-9a-zA-Z]{1}"
consistent!(wifiscanner_1, r"([0-9a-zA-Z]{1}[0-9a-zA-Z]{1}[:]{1}){5}[0-9a-zA-Z]{1}[0-9a-zA-Z]{1}");

// wifiscanner-0.3.6: r"Signal level=(\d+)/100"
consistent!(wifiscanner_2, r"Signal level=(\d+)/100");

// bbcode-1.0.2: r"(?s)\[b\](.*?)\[/b\]"
consistent!(bbcode_0, r"(?s)\[b\](.*?)\[/b\]");

// bbcode-1.0.2: r"(?s)\[i\](.*?)\[/i\]"
consistent!(bbcode_1, r"(?s)\[i\](.*?)\[/i\]");

// bbcode-1.0.2: r"(?s)\[u\](.*?)\[/u\]"
consistent!(bbcode_2, r"(?s)\[u\](.*?)\[/u\]");

// bbcode-1.0.2: r"(?s)\[s\](.*?)\[/s\]"
consistent!(bbcode_3, r"(?s)\[s\](.*?)\[/s\]");

// bbcode-1.0.2: r"(?s)\[size=(\d+)](.*?)\[/size\]"
consistent!(bbcode_4, r"(?s)\[size=(\d+)](.*?)\[/size\]");

// bbcode-1.0.2: r"(?s)\[color=(.+)](.*?)\[/color\]"
consistent!(bbcode_5, r"(?s)\[color=(.+)](.*?)\[/color\]");

// bbcode-1.0.2: r"(?s)\[center\](.*?)\[/center\]"
consistent!(bbcode_6, r"(?s)\[center\](.*?)\[/center\]");

// bbcode-1.0.2: r"(?s)\[left\](.*?)\[/left\]"
consistent!(bbcode_7, r"(?s)\[left\](.*?)\[/left\]");

// bbcode-1.0.2: r"(?s)\[right\](.*?)\[/right\]"
consistent!(bbcode_8, r"(?s)\[right\](.*?)\[/right\]");

// bbcode-1.0.2: r"(?s)\[table\](.*?)\[/table\]"
consistent!(bbcode_9, r"(?s)\[table\](.*?)\[/table\]");

// bbcode-1.0.2: r"(?s)\[td\](.*?)\[/td\]"
consistent!(bbcode_10, r"(?s)\[td\](.*?)\[/td\]");

// bbcode-1.0.2: r"(?s)\[tr\](.*?)\[/tr\]"
consistent!(bbcode_11, r"(?s)\[tr\](.*?)\[/tr\]");

// bbcode-1.0.2: r"(?s)\[th\](.*?)\[/th\]"
consistent!(bbcode_12, r"(?s)\[th\](.*?)\[/th\]");

// bbcode-1.0.2: r"(?s)\[url\](.*?)\[/url\]"
consistent!(bbcode_13, r"(?s)\[url\](.*?)\[/url\]");

// bbcode-1.0.2: r"(?s)\[url=(.+)\](.*?)\[/url\]"
consistent!(bbcode_14, r"(?s)\[url=(.+)\](.*?)\[/url\]");

// bbcode-1.0.2: r"(?s)\[quote\](.*?)\[/quote\]"
consistent!(bbcode_15, r"(?s)\[quote\](.*?)\[/quote\]");

// bbcode-1.0.2: r"(?s)\[quote=(.+)\](.*?)\[/quote\]"
consistent!(bbcode_16, r"(?s)\[quote=(.+)\](.*?)\[/quote\]");

// bbcode-1.0.2: r"(?s)\[img=(\d+)x(\d+)(\b.*)?\](.*?)\[/img\]"
consistent!(bbcode_17, r"(?s)\[img=(\d+)x(\d+)(\b.*)?\](.*?)\[/img\]");

// bbcode-1.0.2: r"(?s)\[img=(.+)(\b.*)?\](.*?)\[/img\]"
consistent!(bbcode_18, r"(?s)\[img=(.+)(\b.*)?\](.*?)\[/img\]");

// bbcode-1.0.2: r"(?s)\[img(\b.*)?\](.*?)\[/img\]"
consistent!(bbcode_19, r"(?s)\[img(\b.*)?\](.*?)\[/img\]");

// bbcode-1.0.2: r"(?s)\[ol\](.*?)\[/ol\]"
consistent!(bbcode_20, r"(?s)\[ol\](.*?)\[/ol\]");

// bbcode-1.0.2: r"(?s)\[ul\](.*?)\[/ul\]"
consistent!(bbcode_21, r"(?s)\[ul\](.*?)\[/ul\]");

// bbcode-1.0.2: r"(?s)\[list\](.*?)\[/list\]"
consistent!(bbcode_22, r"(?s)\[list\](.*?)\[/list\]");

// bbcode-1.0.2: r"(?s)\[youtube\](.*?)\[/youtube\]"
consistent!(bbcode_23, r"(?s)\[youtube\](.*?)\[/youtube\]");

// bbcode-1.0.2: r"(?s)\[youtube=(\d+)x(\d+)\](.*?)\[/youtube\]"
consistent!(bbcode_24, r"(?s)\[youtube=(\d+)x(\d+)\](.*?)\[/youtube\]");

// bbcode-1.0.2: r"(?s)\[li\](.*?)\[/li\]"
consistent!(bbcode_25, r"(?s)\[li\](.*?)\[/li\]");

// block-utils-0.5.0: r"loop\d+"
consistent!(block_utils_0, r"loop\d+");

// block-utils-0.5.0: r"ram\d+"
consistent!(block_utils_1, r"ram\d+");

// block-utils-0.5.0: r"md\d+"
consistent!(block_utils_2, r"md\d+");

// kvvliveapi-0.1.0: r"^([1-9]) min$"
consistent!(kvvliveapi_0, r"^([1-9]) min$");

// rfc822_sanitizer-0.3.3: r"(\d{2}):(\d{2}):(\d{2})"
consistent!(rfc822_sanitizer_0, r"(\d{2}):(\d{2}):(\d{2})");

// rfc822_sanitizer-0.3.3: r"(\d{1,2}):(\d{1,2}):(\d{1,2})"
consistent!(rfc822_sanitizer_1, r"(\d{1,2}):(\d{1,2}):(\d{1,2})");

// faker-0.0.4: r"[2-9]"
consistent!(faker_0, r"[2-9]");

// faker-0.0.4: r"[1-9]"
consistent!(faker_1, r"[1-9]");

// faker-0.0.4: r"[0-9]"
consistent!(faker_2, r"[0-9]");

// faker-0.0.4: r"\d{10}"
consistent!(faker_3, r"\d{10}");

// faker-0.0.4: r"\d{1}"
consistent!(faker_4, r"\d{1}");

// faker-0.0.4: r"^\w+"
consistent!(faker_5, r"^\w+");

// faker-0.0.4: r"^\w+"
consistent!(faker_6, r"^\w+");

// faker-0.0.4: r"^(\w+\.? ?){2,3}$"
consistent!(faker_7, r"^(\w+\.? ?){2,3}$");

// faker-0.0.4: r"^[A-Z][a-z]+\.?$"
consistent!(faker_8, r"^[A-Z][a-z]+\.?$");

// faker-0.0.4: r"^[A-Z][A-Za-z]*\.?$"
consistent!(faker_9, r"^[A-Z][A-Za-z]*\.?$");

// faker-0.0.4: r"http://lorempixel.com/100/100/\w+"
consistent!(faker_10, r"http://lorempixel.com/100/100/\w+");

// faker-0.0.4: r"http://lorempixel.com/100/100/cats"
consistent!(faker_11, r"http://lorempixel.com/100/100/cats");

// fancy-regex-0.1.0: "(?i:ß)"
consistent!(fancy_regex_0, "(?i:ß)");

// fancy-regex-0.1.0: "(?i:\\x{0587})"
consistent!(fancy_regex_1, "(?i:\\x{0587})");

// fancy-regex-0.1.0: "^\\\\([!-/:-@\\[-`\\{-~aftnrv]|[0-7]{1,3}|x[0-9a-fA-F]{2}|x\\{[0-9a-fA-F]{1,6}\\})"
consistent!(fancy_regex_2, "^\\\\([!-/:-@\\[-`\\{-~aftnrv]|[0-7]{1,3}|x[0-9a-fA-F]{2}|x\\{[0-9a-fA-F]{1,6}\\})");

// fancy-prompt-0.1.5: r"/([^/])[^/]+/"
consistent!(fancy_prompt_0, r"/([^/])[^/]+/");

// fancy-prompt-0.1.5: r"^([^:]+):.*?(?::([^:]+))?$"
consistent!(fancy_prompt_1, r"^([^:]+):.*?(?::([^:]+))?$");

// fanta-0.2.0: r"^(/?__\w+__)/(.*)"
consistent!(fanta_0, r"^(/?__\w+__)/(.*)");

// fanta-cli-0.1.1: r"(.)([A-Z])"
consistent!(fanta_cli_0, r"(.)([A-Z])");

// fanta-cli-0.1.1: "\\{:[^\\s]+\\}"
consistent!(fanta_cli_1, "\\{:[^\\s]+\\}");

// amethyst_tools-0.7.1: "(?P<last>[^\r])\n"
consistent!(amethyst_tools_0, "(?P<last>[^\r])\n");

// amigo-0.3.1: r"^-?\d+(\.\d)?"
consistent!(amigo_0, r"^-?\d+(\.\d)?");

// amigo-0.3.1: r"^[a-zA-Z_]+[\w-]*[!?_]?"
consistent!(amigo_1, r"^[a-zA-Z_]+[\w-]*[!?_]?");

// amigo-0.3.1: r"^\("
consistent!(amigo_2, r"^\(");

// amigo-0.3.1: r"^\)"
consistent!(amigo_3, r"^\)");

// amigo-0.3.1: r"^\s+"
consistent!(amigo_4, r"^\s+");

// ethcore-logger-1.12.0: "\x1b\\[[^m]+m"
consistent!(ethcore_logger_0, "\x1b\\[[^m]+m");

// dash2html-1.0.1: r"__.*?__"
consistent!(dash2html_0, r"__.*?__");

// dash2html-1.0.1: r"(?i)@(?:time|clipboard|cursor|date)"
consistent!(dash2html_1, r"(?i)@(?:time|clipboard|cursor|date)");

// os_type-2.0.0: r"^Microsoft Windows \[Version\s(\d+\.\d+\.\d+)\]$"
consistent!(os_type_0, r"^Microsoft Windows \[Version\s(\d+\.\d+\.\d+)\]$");

// os_type-2.0.0: r"ProductName:\s([\w\s]+)\n"
consistent!(os_type_1, r"ProductName:\s([\w\s]+)\n");

// os_type-2.0.0: r"ProductVersion:\s(\w+\.\w+\.\w+)"
consistent!(os_type_2, r"ProductVersion:\s(\w+\.\w+\.\w+)");

// os_type-2.0.0: r"BuildVersion:\s(\w+)"
consistent!(os_type_3, r"BuildVersion:\s(\w+)");

// os_type-2.0.0: r"(\w+) Linux release"
consistent!(os_type_4, r"(\w+) Linux release");

// os_type-2.0.0: r"release\s([\w\.]+)"
consistent!(os_type_5, r"release\s([\w\.]+)");

// os_type-2.0.0: r"Distributor ID:\s(\w+)"
consistent!(os_type_6, r"Distributor ID:\s(\w+)");

// os_type-2.0.0: r"Release:\s([\w\.]+)"
consistent!(os_type_7, r"Release:\s([\w\.]+)");

// bindgen-0.37.0: r"typename type\-parameter\-\d+\-\d+::.+"
consistent!(bindgen_0, r"typename type\-parameter\-\d+\-\d+::.+");

// imap-0.8.1: "^+(.*)\r\n"
consistent!(imap_0, "^+(.*)\r\n");

// image-base64-0.1.0: r"^ffd8ffe0"
consistent!(image_base64_0, r"^ffd8ffe0");

// image-base64-0.1.0: r"^89504e47"
consistent!(image_base64_1, r"^89504e47");

// image-base64-0.1.0: r"^47494638"
consistent!(image_base64_2, r"^47494638");

// json-pointer-0.3.2: "^(/([^/~]|~[01])*)*$"
consistent!(json_pointer_0, "^(/([^/~]|~[01])*)*$");

// json-pointer-0.3.2: "^#(/([^/~%]|~[01]|%[0-9a-fA-F]{2})*)*$"
consistent!(json_pointer_1, "^#(/([^/~%]|~[01]|%[0-9a-fA-F]{2})*)*$");

// mysql_common-0.7.0: r"^5.5.5-(\d{1,2})\.(\d{1,2})\.(\d{1,3})-MariaDB"
consistent!(mysql_common_0, r"^5.5.5-(\d{1,2})\.(\d{1,2})\.(\d{1,3})-MariaDB");

// mysql_common-0.7.0: r"^(\d{1,2})\.(\d{1,2})\.(\d{1,3})(.*)"
consistent!(mysql_common_1, r"^(\d{1,2})\.(\d{1,2})\.(\d{1,3})(.*)");

// government_id-0.1.0: r"^[0-9]{4}[0-9A-Z]{2}[0-9]{3}$"
consistent!(government_id_0, r"^[0-9]{4}[0-9A-Z]{2}[0-9]{3}$");

// ohmers-0.1.1: r"UniqueIndexViolation: (\w+)"
consistent!(ohmers_0, r"UniqueIndexViolation: (\w+)");

// eliza-1.0.0: r"(.*) you are (.*)"
consistent!(eliza_0, r"(.*) you are (.*)");

// eliza-1.0.0: r"(.*) you are (.*)"
consistent!(eliza_1, r"(.*) you are (.*)");

// eliza-1.0.0: r"(.*) you are (.*)"
consistent!(eliza_2, r"(.*) you are (.*)");

// chema-0.0.5: "^\\s*\\*"
consistent!(chema_0, "^\\s*\\*");

// chema-0.0.5: "^\\s*@(\\w+)\\s+(.*)"
consistent!(chema_1, "^\\s*@(\\w+)\\s+(.*)");

// chord3-0.3.0: r"^\s*#"
consistent!(chord3_0, r"^\s*#");

// chord3-0.3.0: r"\{(?P<cmd>\w+)(?::?\s*(?P<arg>.*))?\}"
consistent!(chord3_1, r"\{(?P<cmd>\w+)(?::?\s*(?P<arg>.*))?\}");

// chord3-0.3.0: r"\{(eot|end_of_tab):?\s*"
consistent!(chord3_2, r"\{(eot|end_of_tab):?\s*");

// chord3-0.3.0: r"([^\[]*)(?:\[([^\]]*)\])?"
consistent!(chord3_3, r"([^\[]*)(?:\[([^\]]*)\])?");

// checkmail-0.1.1: "^[a-zA-Z0-9.!#$%&'*+/=?^_`{|}~-]+@[a-zA-Z0-9](?:[a-zA-Z0-9-]{0,61}[a-zA-Z0-9])?(?:\\.[a-zA-Z0-9](?:[a-zA-Z0-9-]{0,61}[a-zA-Z0-9])?)*$"
consistent!(checkmail_0, "^[a-zA-Z0-9.!#$%&'*+/=?^_`{|}~-]+@[a-zA-Z0-9](?:[a-zA-Z0-9-]{0,61}[a-zA-Z0-9])?(?:\\.[a-zA-Z0-9](?:[a-zA-Z0-9-]{0,61}[a-zA-Z0-9])?)*$");

// cntk-0.2.1: r"\b\w\w+\b"
consistent!(cntk_0, r"\b\w\w+\b");

// cntk-0.2.1: r"\b\w\w+\b"
consistent!(cntk_1, r"\b\w\w+\b");

// cniguru-0.1.0: r"\(id: (\d+)\)"
consistent!(cniguru_0, r"\(id: (\d+)\)");

// upm_lib-0.3.0: r"^(\d+)\.(\d+)\.(\d+)(?:-([\dA-Za-z-]+(?:\.[\dA-Za-z-]+)*))?(?:\+([\dA-Za-z-]+(?:\.[\dA-Za-z-]+)*))?$"
consistent!(upm_lib_0, r"^(\d+)\.(\d+)\.(\d+)(?:-([\dA-Za-z-]+(?:\.[\dA-Za-z-]+)*))?(?:\+([\dA-Za-z-]+(?:\.[\dA-Za-z-]+)*))?$");

// avro-0.2.1: r"^\s*(\*+(\s+))?"
consistent!(avro_0, r"^\s*(\*+(\s+))?");

// avro-0.2.1: r"^\s*(\*+)?"
consistent!(avro_1, r"^\s*(\*+)?");

// nomi-0.0.2: "[0-9]+"
consistent!(nomi_0, "[0-9]+");

// nodes-0.1.0: "([0-9]+)@(?:nodes|n)?:([^@]+)?"
consistent!(nodes_0, "([0-9]+)@(?:nodes|n)?:([^@]+)?");

// not-stakkr-1.0.0: r"(?i)in (\d+) (second|minute|hour|day|week)s?"
consistent!(not_stakkr_0, r"(?i)in (\d+) (second|minute|hour|day|week)s?");

// notetxt-0.0.1: "^([A-Za-z0-9 -_:]+)\n-+\n"
consistent!(notetxt_0, "^([A-Za-z0-9 -_:]+)\n-+\n");

// nail-0.1.0-pre.0: r"^-?[0-9]+(\.[0-9]+)?([eE]-?[0-9]+)?$"
consistent!(nail_0, r"^-?[0-9]+(\.[0-9]+)?([eE]-?[0-9]+)?$");

// nail-0.1.0-pre.0: r"^-?[0-9]+$"
consistent!(nail_1, r"^-?[0-9]+$");

// askalono-0.2.0: r"[^\w\s\pP]+"
consistent!(askalono_0, r"[^\w\s\pP]+");

// askalono-0.2.0: r"(?x)[ \t\p{Zs} \\ / \| \x2044 ]+"
consistent!(askalono_1, r"(?x)[ \t\p{Zs} \\ / \| \x2044 ]+");

// askalono-0.2.0: r"\p{Pd}+"
consistent!(askalono_2, r"\p{Pd}+");

// askalono-0.2.0: r"\p{Ps}+"
consistent!(askalono_3, r"\p{Ps}+");

// askalono-0.2.0: r"\p{Pe}+"
consistent!(askalono_4, r"\p{Pe}+");

// askalono-0.2.0: r"\p{Pc}+"
consistent!(askalono_5, r"\p{Pc}+");

// askalono-0.2.0: r"[©Ⓒⓒ]"
consistent!(askalono_6, r"[©Ⓒⓒ]");

// askalono-0.2.0: r"[\r\n\v\f]"
consistent!(askalono_7, r"[\r\n\v\f]");

// askalono-0.2.0: r"\n{3,}"
consistent!(askalono_8, r"\n{3,}");

// askalono-0.2.0: r"[^\w\s]+"
consistent!(askalono_9, r"[^\w\s]+");

// askalono-0.2.0: r"\s+"
consistent!(askalono_10, r"\s+");

// assembunny_plus-0.0.3: r"[^0-9a-zA-Z_]"
consistent!(assembunny_plus_0, r"[^0-9a-zA-Z_]");

// assembunny_plus-0.0.3: r"[0-9]"
consistent!(assembunny_plus_1, r"[0-9]");

// salt-compressor-0.4.0: r"(?m)^Minion (\S*) did not respond\. No job will be sent\.$"
consistent!(salt_compressor_0, r"(?m)^Minion (\S*) did not respond\. No job will be sent\.$");

// sabisabi-0.4.1: r"</?[^>]+?>"
consistent!(sabisabi_0, r"</?[^>]+?>");

// sabisabi-0.4.1: r"\([^)]*\)"
consistent!(sabisabi_1, r"\([^)]*\)");

// sassers-0.13.5-h28: "@import \"([^\"]*)\";"
consistent!(sassers_0, "@import \"([^\"]*)\";");

// shadowsocks-0.6.2: r"[A-Za-z\d-]{1,63}$"
consistent!(shadowsocks_0, r"[A-Za-z\d-]{1,63}$");

// shkeleton-0.1.5: "[abc]+"
consistent!(shkeleton_0, "[abc]+");

// shellwords-0.1.0: r"([^A-Za-z0-9_\-.,:/@\n])"
consistent!(shellwords_0, r"([^A-Za-z0-9_\-.,:/@\n])");

// shellwords-0.1.0: r"\n"
consistent!(shellwords_1, r"\n");

// shush-0.1.5: "(?P<num>[0-9]+)(?P<units>[dhms])"
consistent!(shush_0, "(?P<num>[0-9]+)(?P<units>[dhms])");

// woothee-0.8.0: r"(?:Chrome|CrMo|CriOS)/([.0-9]+)"
consistent!(woothee_0, r"(?:Chrome|CrMo|CriOS)/([.0-9]+)");

// woothee-0.8.0: r"Vivaldi/([.0-9]+)"
consistent!(woothee_1, r"Vivaldi/([.0-9]+)");

// woothee-0.8.0: r"Firefox/([.0-9]+)"
consistent!(woothee_2, r"Firefox/([.0-9]+)");

// woothee-0.8.0: r"^Mozilla/[.0-9]+ \((?:Mobile|Tablet);(?:.*;)? rv:([.0-9]+)\) Gecko/[.0-9]+ Firefox/[.0-9]+$"
consistent!(woothee_3, r"^Mozilla/[.0-9]+ \((?:Mobile|Tablet);(?:.*;)? rv:([.0-9]+)\) Gecko/[.0-9]+ Firefox/[.0-9]+$");

// woothee-0.8.0: r"FxiOS/([.0-9]+)"
consistent!(woothee_4, r"FxiOS/([.0-9]+)");

// woothee-0.8.0: r"\(([^;)]+);FOMA;"
consistent!(woothee_5, r"\(([^;)]+);FOMA;");

// woothee-0.8.0: r"jig browser[^;]+; ([^);]+)"
consistent!(woothee_6, r"jig browser[^;]+; ([^);]+)");

// woothee-0.8.0: r"(?i)rss(?:reader|bar|[-_ /;()]|[ +]*/)"
consistent!(woothee_7, r"(?i)rss(?:reader|bar|[-_ /;()]|[ +]*/)");

// woothee-0.8.0: r"(?i)(?:bot|crawler|spider)(?:[-_ ./;@()]|$)"
consistent!(woothee_8, r"(?i)(?:bot|crawler|spider)(?:[-_ ./;@()]|$)");

// woothee-0.8.0: r"(?i)(?:feed|web) ?parser"
consistent!(woothee_9, r"(?i)(?:feed|web) ?parser");

// woothee-0.8.0: r"(?i)watch ?dog"
consistent!(woothee_10, r"(?i)watch ?dog");

// woothee-0.8.0: r"Edge/([.0-9]+)"
consistent!(woothee_11, r"Edge/([.0-9]+)");

// woothee-0.8.0: r"MSIE ([.0-9]+);"
consistent!(woothee_12, r"MSIE ([.0-9]+);");

// woothee-0.8.0: r"Version/([.0-9]+)"
consistent!(woothee_13, r"Version/([.0-9]+)");

// woothee-0.8.0: r"Opera[/ ]([.0-9]+)"
consistent!(woothee_14, r"Opera[/ ]([.0-9]+)");

// woothee-0.8.0: r"OPR/([.0-9]+)"
consistent!(woothee_15, r"OPR/([.0-9]+)");

// woothee-0.8.0: r"Version/([.0-9]+)"
consistent!(woothee_16, r"Version/([.0-9]+)");

// woothee-0.8.0: r"(?:SoftBank|Vodafone|J-PHONE)/[.0-9]+/([^ /;()]+)"
consistent!(woothee_17, r"(?:SoftBank|Vodafone|J-PHONE)/[.0-9]+/([^ /;()]+)");

// woothee-0.8.0: r"Trident/([.0-9]+);"
consistent!(woothee_18, r"Trident/([.0-9]+);");

// woothee-0.8.0: r" rv:([.0-9]+)"
consistent!(woothee_19, r" rv:([.0-9]+)");

// woothee-0.8.0: r"IEMobile/([.0-9]+);"
consistent!(woothee_20, r"IEMobile/([.0-9]+);");

// woothee-0.8.0: r"(?:WILLCOM|DDIPOCKET);[^/]+/([^ /;()]+)"
consistent!(woothee_21, r"(?:WILLCOM|DDIPOCKET);[^/]+/([^ /;()]+)");

// woothee-0.8.0: r"Windows ([ .a-zA-Z0-9]+)[;\\)]"
consistent!(woothee_22, r"Windows ([ .a-zA-Z0-9]+)[;\\)]");

// woothee-0.8.0: r"^Phone(?: OS)? ([.0-9]+)"
consistent!(woothee_23, r"^Phone(?: OS)? ([.0-9]+)");

// woothee-0.8.0: r"iP(hone;|ad;|od) .*like Mac OS X"
consistent!(woothee_24, r"iP(hone;|ad;|od) .*like Mac OS X");

// woothee-0.8.0: r"Version/([.0-9]+)"
consistent!(woothee_25, r"Version/([.0-9]+)");

// woothee-0.8.0: r"rv:(\d+\.\d+\.\d+)"
consistent!(woothee_26, r"rv:(\d+\.\d+\.\d+)");

// woothee-0.8.0: r"FreeBSD ([^;\)]+);"
consistent!(woothee_27, r"FreeBSD ([^;\)]+);");

// woothee-0.8.0: r"CrOS ([^\)]+)\)"
consistent!(woothee_28, r"CrOS ([^\)]+)\)");

// woothee-0.8.0: r"Android[- ](\d+\.\d+(?:\.\d+)?)"
consistent!(woothee_29, r"Android[- ](\d+\.\d+(?:\.\d+)?)");

// woothee-0.8.0: r"PSP \(PlayStation Portable\); ([.0-9]+)\)"
consistent!(woothee_30, r"PSP \(PlayStation Portable\); ([.0-9]+)\)");

// woothee-0.8.0: r"PLAYSTATION 3;? ([.0-9]+)\)"
consistent!(woothee_31, r"PLAYSTATION 3;? ([.0-9]+)\)");

// woothee-0.8.0: r"PlayStation Vita ([.0-9]+)\)"
consistent!(woothee_32, r"PlayStation Vita ([.0-9]+)\)");

// woothee-0.8.0: r"PlayStation 4 ([.0-9]+)\)"
consistent!(woothee_33, r"PlayStation 4 ([.0-9]+)\)");

// woothee-0.8.0: r"BB10(?:.+)Version/([.0-9]+) "
consistent!(woothee_34, r"BB10(?:.+)Version/([.0-9]+) ");

// woothee-0.8.0: r"BlackBerry(?:\d+)/([.0-9]+) "
consistent!(woothee_35, r"BlackBerry(?:\d+)/([.0-9]+) ");

// woothee-0.8.0: r"; CPU(?: iPhone)? OS (\d+_\d+(?:_\d+)?) like Mac OS X"
consistent!(woothee_36, r"; CPU(?: iPhone)? OS (\d+_\d+(?:_\d+)?) like Mac OS X");

// woothee-0.8.0: r"Mac OS X (10[._]\d+(?:[._]\d+)?)(?:\)|;)"
consistent!(woothee_37, r"Mac OS X (10[._]\d+(?:[._]\d+)?)(?:\)|;)");

// woothee-0.8.0: r"^(?:Apache-HttpClient/|Jakarta Commons-HttpClient/|Java/)"
consistent!(woothee_38, r"^(?:Apache-HttpClient/|Jakarta Commons-HttpClient/|Java/)");

// woothee-0.8.0: r"[- ]HttpClient(/|$)"
consistent!(woothee_39, r"[- ]HttpClient(/|$)");

// woothee-0.8.0: r"^(?:PHP|WordPress|CakePHP|PukiWiki|PECL::HTTP)(?:/| |$)"
consistent!(woothee_40, r"^(?:PHP|WordPress|CakePHP|PukiWiki|PECL::HTTP)(?:/| |$)");

// woothee-0.8.0: r"(?:PEAR HTTP_Request|HTTP_Request)(?: class|2)"
consistent!(woothee_41, r"(?:PEAR HTTP_Request|HTTP_Request)(?: class|2)");

// woothee-0.8.0: r"(?:Rome Client |UnwindFetchor/|ia_archiver |Summify |PostRank/)"
consistent!(woothee_42, r"(?:Rome Client |UnwindFetchor/|ia_archiver |Summify |PostRank/)");

// woothee-0.8.0: r"Sleipnir/([.0-9]+)"
consistent!(woothee_43, r"Sleipnir/([.0-9]+)");

// word_replace-0.0.3: r"@@[a-z|A-Z|\d]+@@"
consistent!(word_replace_0, r"@@[a-z|A-Z|\d]+@@");

// wordcount-0.1.0: r"\w+"
consistent!(wordcount_0, r"\w+");

// just-0.3.12: "^([^=]+)=(.*)$"
consistent!(just_0, "^([^=]+)=(.*)$");

// emote-0.1.0: r":[a-zA-Z_]+?:"
consistent!(emote_0, r":[a-zA-Z_]+?:");

// emojicons-1.0.1: r":([a-zA-Z0-9_+-]+):"
consistent!(emojicons_0, r":([a-zA-Z0-9_+-]+):");

// git2_codecommit-0.1.2: r"git-codecommit\.([a-z0-9-]+)\.amazonaws\.com"
consistent!(git2_codecommit_0, r"git-codecommit\.([a-z0-9-]+)\.amazonaws\.com");

// git-workarea-3.1.2: r"^submodule\.(?P<name>.*)\.(?P<key>[^=]*)=(?P<value>.*)$"
consistent!(git_workarea_0, r"^submodule\.(?P<name>.*)\.(?P<key>[^=]*)=(?P<value>.*)$");

// git-shell-enforce-directory-1.0.0: r"^(?P<command>git-(?:receive|upload)-pack) '(?P<path>.+)'$"
consistent!(git_shell_enforce_directory_0, r"^(?P<command>git-(?:receive|upload)-pack) '(?P<path>.+)'$");

// git-journal-1.6.3: r"[ \n]:(.*?):"
consistent!(git_journal_0, r"[ \n]:(.*?):");

// git-find-0.3.2: r"^git@(?P<host>[[:alnum:]\._-]+):(?P<path>[[:alnum:]\._\-/]+).git$"
consistent!(git_find_0, r"^git@(?P<host>[[:alnum:]\._-]+):(?P<path>[[:alnum:]\._\-/]+).git$");

// gitlab-api-0.6.0: r"private_token=\w{20}"
consistent!(gitlab_api_0, r"private_token=\w{20}");

// td-client-0.7.0: "^(http://|https://)"
consistent!(td_client_0, "^(http://|https://)");

// karaconv-0.3.0: r"--(?P<type>[a-zA-Z]+)-- (?P<contents>.*)"
consistent!(karaconv_0, r"--(?P<type>[a-zA-Z]+)-- (?P<contents>.*)");

// katana-1.0.2: r"(?P<comp>et al\.)(?:\.)"
consistent!(katana_0, r"(?P<comp>et al\.)(?:\.)");

// katana-1.0.2: r"\.{3}"
consistent!(katana_1, r"\.{3}");

// katana-1.0.2: r"(?P<number>[0-9]+)\.(?P<decimal>[0-9]+)"
consistent!(katana_2, r"(?P<number>[0-9]+)\.(?P<decimal>[0-9]+)");

// katana-1.0.2: r"\s\.(?P<nums>[0-9]+)"
consistent!(katana_3, r"\s\.(?P<nums>[0-9]+)");

// katana-1.0.2: r"(?:[A-Za-z]\.){2,}"
consistent!(katana_4, r"(?:[A-Za-z]\.){2,}");

// katana-1.0.2: r"(?P<init>[A-Z])(?P<point>\.)"
consistent!(katana_5, r"(?P<init>[A-Z])(?P<point>\.)");

// katana-1.0.2: r"(?P<title>[A-Z][a-z]{1,3})(\.)"
consistent!(katana_6, r"(?P<title>[A-Z][a-z]{1,3})(\.)");

// katana-1.0.2: r"&==&(?P<p>[.!?])"
consistent!(katana_7, r"&==&(?P<p>[.!?])");

// katana-1.0.2: r"&\^&(?P<p>[.!?])"
consistent!(katana_8, r"&\^&(?P<p>[.!?])");

// katana-1.0.2: r"&\*\*&(?P<p>[.!?])"
consistent!(katana_9, r"&\*\*&(?P<p>[.!?])");

// katana-1.0.2: r"&=&(?P<p>[.!?])"
consistent!(katana_10, r"&=&(?P<p>[.!?])");

// katana-1.0.2: r"&##&(?P<p>[.!?])"
consistent!(katana_11, r"&##&(?P<p>[.!?])");

// katana-1.0.2: r"&\$&(?P<p>[.!?])"
consistent!(katana_12, r"&\$&(?P<p>[.!?])");

// kailua_syntax-1.1.0: r"@(?:_|\d+(?:/\d+(?:-\d+)?)?)"
consistent!(kailua_syntax_0, r"@(?:_|\d+(?:/\d+(?:-\d+)?)?)");

// kailua_syntax-1.1.0: r"<(\d+)>"
consistent!(kailua_syntax_1, r"<(\d+)>");

// ftp-3.0.1: r"\((\d+),(\d+),(\d+),(\d+),(\d+),(\d+)\)"
consistent!(ftp_0, r"\((\d+),(\d+),(\d+),(\d+),(\d+),(\d+)\)");

// ftp-3.0.1: r"\b(\d{4})(\d{2})(\d{2})(\d{2})(\d{2})(\d{2})\b"
consistent!(ftp_1, r"\b(\d{4})(\d{2})(\d{2})(\d{2})(\d{2})(\d{2})\b");

// ftp-3.0.1: r"\s+(\d+)\s*$"
consistent!(ftp_2, r"\s+(\d+)\s*$");

// vat-0.1.0: r"<countryCode>(.*?)</countryCode>"
consistent!(vat_0, r"<countryCode>(.*?)</countryCode>");

// vat-0.1.0: r"<vatNumber>(.*?)</vatNumber>"
consistent!(vat_1, r"<vatNumber>(.*?)</vatNumber>");

// vat-0.1.0: r"<name>(.*?)</name>"
consistent!(vat_2, r"<name>(.*?)</name>");

// vat-0.1.0: r"<address>(?s)(.*?)(?-s)</address>"
consistent!(vat_3, r"<address>(?s)(.*?)(?-s)</address>");

// vat-0.1.0: r"<valid>(true|false)</valid>"
consistent!(vat_4, r"<valid>(true|false)</valid>");

// vat-0.1.0: r"^ATU\d{8}$"
consistent!(vat_5, r"^ATU\d{8}$");

// vat-0.1.0: r"^BE0?\d{9, 10}$"
consistent!(vat_6, r"^BE0?\d{9, 10}$");

// vat-0.1.0: r"^BG\d{9,10}$"
consistent!(vat_7, r"^BG\d{9,10}$");

// vat-0.1.0: r"^HR\d{11}$"
consistent!(vat_8, r"^HR\d{11}$");

// vat-0.1.0: r"^CY\d{8}[A-Z]$"
consistent!(vat_9, r"^CY\d{8}[A-Z]$");

// vat-0.1.0: r"^CZ\d{8,10}$"
consistent!(vat_10, r"^CZ\d{8,10}$");

// vat-0.1.0: r"^DK\d{8}$"
consistent!(vat_11, r"^DK\d{8}$");

// vat-0.1.0: r"^EE\d{9}$"
consistent!(vat_12, r"^EE\d{9}$");

// vat-0.1.0: r"^FI\d{8}$"
consistent!(vat_13, r"^FI\d{8}$");

// vat-0.1.0: r"^FR[A-HJ-NP-Z0-9][A-HJ-NP-Z0-9]\d{9}$"
consistent!(vat_14, r"^FR[A-HJ-NP-Z0-9][A-HJ-NP-Z0-9]\d{9}$");

// vat-0.1.0: r"^DE\d{9}$"
consistent!(vat_15, r"^DE\d{9}$");

// vat-0.1.0: r"^EL\d{9}$"
consistent!(vat_16, r"^EL\d{9}$");

// vat-0.1.0: r"^HU\d{8}$"
consistent!(vat_17, r"^HU\d{8}$");

// vat-0.1.0: r"^IE\d[A-Z0-9\+\*]\d{5}[A-Z]{1,2}$"
consistent!(vat_18, r"^IE\d[A-Z0-9\+\*]\d{5}[A-Z]{1,2}$");

// vat-0.1.0: r"^IT\d{11}$"
consistent!(vat_19, r"^IT\d{11}$");

// vat-0.1.0: r"^LV\d{11}$"
consistent!(vat_20, r"^LV\d{11}$");

// vat-0.1.0: r"^LT(\d{9}|\d{12})$"
consistent!(vat_21, r"^LT(\d{9}|\d{12})$");

// vat-0.1.0: r"^LU\d{8}$"
consistent!(vat_22, r"^LU\d{8}$");

// vat-0.1.0: r"^MT\d{8}$"
consistent!(vat_23, r"^MT\d{8}$");

// vat-0.1.0: r"^NL\d{9}B\d{2}$"
consistent!(vat_24, r"^NL\d{9}B\d{2}$");

// vat-0.1.0: r"^PL\d{10}$"
consistent!(vat_25, r"^PL\d{10}$");

// vat-0.1.0: r"^PT\d{9}$"
consistent!(vat_26, r"^PT\d{9}$");

// vat-0.1.0: r"^RO\d{2,10}$"
consistent!(vat_27, r"^RO\d{2,10}$");

// vat-0.1.0: r"^SK\d{10}$"
consistent!(vat_28, r"^SK\d{10}$");

// vat-0.1.0: r"^SI\d{8}$"
consistent!(vat_29, r"^SI\d{8}$");

// vat-0.1.0: r"^ES[A-Z0-9]\d{7}[A-Z0-9]$"
consistent!(vat_30, r"^ES[A-Z0-9]\d{7}[A-Z0-9]$");

// vat-0.1.0: r"^SE\d{10}01$"
consistent!(vat_31, r"^SE\d{10}01$");

// vat-0.1.0: r"^(GB(GD|HA)\d{3}|GB\d{9}|GB\d{12})$"
consistent!(vat_32, r"^(GB(GD|HA)\d{3}|GB\d{9}|GB\d{12})$");

// eve-0.1.1: r"\{\{(.*)\}\}"
consistent!(eve_0, r"\{\{(.*)\}\}");

// egc-0.1.2: "^mio"
consistent!(egc_0, "^mio");

// pew-0.2.3: ""
consistent!(pew_0, "");

// pew-0.2.3: ""
consistent!(pew_1, "");

// mob-0.4.3: "y"
consistent!(mob_0, "y");

// lit-0.2.8: "@([a-z]+)"
consistent!(lit_0, "@([a-z]+)");

// lit-0.2.8: "([A-Z-]+):(.*)"
consistent!(lit_1, "([A-Z-]+):(.*)");

// lit-0.2.8: "^[a-zA-Z_][a-zA-Z0-9_]*$"
consistent!(lit_2, "^[a-zA-Z_][a-zA-Z0-9_]*$");

// avm-1.0.1: r"\d+\.\d+\.\d+"
consistent!(avm_0, r"\d+\.\d+\.\d+");

// avm-1.0.1: r"\d+\.\d+\.\d+"
consistent!(avm_1, r"\d+\.\d+\.\d+");

// orm-0.2.0: r"^Vec<(.+)>$"
consistent!(orm_0, r"^Vec<(.+)>$");

// sgf-0.1.5: r"\\(\r\n|\n\r|\n|\r)"
consistent!(sgf_0, r"\\(\r\n|\n\r|\n|\r)");

// sgf-0.1.5: r"\\(.)"
consistent!(sgf_1, r"\\(.)");

// sgf-0.1.5: r"\r\n|\n\r|\n|\r"
consistent!(sgf_2, r"\r\n|\n\r|\n|\r");

// sgf-0.1.5: r"([\]\\:])"
consistent!(sgf_3, r"([\]\\:])");

// dok-0.2.0: "^Bearer realm=\"(.+?)\",service=\"(.+?)\",scope=\"(.+?)\"$"
consistent!(dok_0, "^Bearer realm=\"(.+?)\",service=\"(.+?)\",scope=\"(.+?)\"$");

// d20-0.1.0: r"([+-]?\s*\d+[dD]\d+|[+-]?\s*\d+)"
consistent!(d20_0, r"([+-]?\s*\d+[dD]\d+|[+-]?\s*\d+)");

// dvb-0.3.0: "E"
consistent!(dvb_0, "E");

// dvb-0.3.0: "^F"
consistent!(dvb_1, "^F");

// dvb-0.3.0: "^S"
consistent!(dvb_2, "^S");

// ger-0.2.0: r"Change-Id: (I[a-f0-9]{40})$"
consistent!(ger_0, r"Change-Id: (I[a-f0-9]{40})$");

// ger-0.2.0: r"(refs|ref|fix|fixes|close|closes)\s+([A-Z]{2,5}-[0-9]{1,5})$"
consistent!(ger_1, r"(refs|ref|fix|fixes|close|closes)\s+([A-Z]{2,5}-[0-9]{1,5})$");

// n5-0.2.1: r"(\d+)(\.(\d+))?(\.(\d+))?(.*)"
consistent!(n5_0, r"(\d+)(\.(\d+))?(\.(\d+))?(.*)");

// po-0.1.4: r"[A-Za-z0-9]"
consistent!(po_0, r"[A-Za-z0-9]");

// carnix-0.8.5: "path is (‘|')?([^’'\n]*)(’|')?"
consistent!(carnix_0, "path is (‘|')?([^’'\n]*)(’|')?");

// carnix-0.8.5: r"^(\S*) (\d*)\.(\d*)\.(\d*)(-(\S*))?(.*)?"
consistent!(carnix_1, r"^(\S*) (\d*)\.(\d*)\.(\d*)(-(\S*))?(.*)?");

// carnix-0.8.5: r"(\d*)\.(\d*)\.(\d*)(-(\S*))?"
consistent!(carnix_2, r"(\d*)\.(\d*)\.(\d*)(-(\S*))?");

// carnix-0.8.5: r"(\S*)-(\d*)\.(\d*)\.(\d*)(-(\S*))?"
consistent!(carnix_3, r"(\S*)-(\d*)\.(\d*)\.(\d*)(-(\S*))?");

// caseless-0.2.1: r"^# CaseFolding-(\d+)\.(\d+)\.(\d+).txt$"
consistent!(caseless_0, r"^# CaseFolding-(\d+)\.(\d+)\.(\d+).txt$");

// caseless-0.2.1: r"^([0-9A-F]+); [CF]; ([0-9A-F ]+);"
consistent!(caseless_1, r"^([0-9A-F]+); [CF]; ([0-9A-F ]+);");

// cabot-0.2.0: "\r?\n\r?\n"
consistent!(cabot_0, "\r?\n\r?\n");

// cabot-0.2.0: "\r?\n"
consistent!(cabot_1, "\r?\n");

// card-validate-2.2.1: r"^600"
consistent!(card_validate_0, r"^600");

// card-validate-2.2.1: r"^5019"
consistent!(card_validate_1, r"^5019");

// card-validate-2.2.1: r"^4"
consistent!(card_validate_2, r"^4");

// card-validate-2.2.1: r"^(5[1-5]|2[2-7])"
consistent!(card_validate_3, r"^(5[1-5]|2[2-7])");

// card-validate-2.2.1: r"^3[47]"
consistent!(card_validate_4, r"^3[47]");

// card-validate-2.2.1: r"^3[0689]"
consistent!(card_validate_5, r"^3[0689]");

// card-validate-2.2.1: r"^6([045]|22)"
consistent!(card_validate_6, r"^6([045]|22)");

// card-validate-2.2.1: r"^(62|88)"
consistent!(card_validate_7, r"^(62|88)");

// card-validate-2.2.1: r"^35"
consistent!(card_validate_8, r"^35");

// card-validate-2.2.1: r"^[0-9]+$"
consistent!(card_validate_9, r"^[0-9]+$");

// cargo-testify-0.3.0: r"\d{1,} passed.*filtered out"
consistent!(cargo_testify_0, r"\d{1,} passed.*filtered out");

// cargo-testify-0.3.0: r"error(:|\[).*"
consistent!(cargo_testify_1, r"error(:|\[).*");

// cargo-wix-0.0.5: r"<(.*?)>"
consistent!(cargo_wix_0, r"<(.*?)>");

// cargo-wix-0.0.5: r"<(.*?)>"
consistent!(cargo_wix_1, r"<(.*?)>");

// cargo-wix-0.0.5: r"<(.*?)>"
consistent!(cargo_wix_2, r"<(.*?)>");

// cargo-wix-0.0.5: r"<(.*?)>"
consistent!(cargo_wix_3, r"<(.*?)>");

// cargo-incremental-0.1.23: r"(?m)^incremental: re-using (\d+) out of (\d+) modules$"
consistent!(cargo_incremental_0, r"(?m)^incremental: re-using (\d+) out of (\d+) modules$");

// cargo-incremental-0.1.23: "(?m)(warning|error): (.*)\n  --> ([^:]:\\d+:\\d+)$"
consistent!(cargo_incremental_1, "(?m)(warning|error): (.*)\n  --> ([^:]:\\d+:\\d+)$");

// cargo-incremental-0.1.23: r"(?m)^test (.*) \.\.\. (\w+)"
consistent!(cargo_incremental_2, r"(?m)^test (.*) \.\.\. (\w+)");

// cargo-incremental-0.1.23: r"(?m)(\d+) passed; (\d+) failed; (\d+) ignored; \d+ measured"
consistent!(cargo_incremental_3, r"(?m)(\d+) passed; (\d+) failed; (\d+) ignored; \d+ measured");

// cargo-testjs-0.1.2: r"^[^-]+-[0-9a-f]+\.js$"
consistent!(cargo_testjs_0, r"^[^-]+-[0-9a-f]+\.js$");

// cargo-tarpaulin-0.6.2: r"\s*//"
consistent!(cargo_tarpaulin_0, r"\s*//");

// cargo-tarpaulin-0.6.2: r"/\*"
consistent!(cargo_tarpaulin_1, r"/\*");

// cargo-tarpaulin-0.6.2: r"\*/"
consistent!(cargo_tarpaulin_2, r"\*/");

// cargo-culture-kit-0.1.0: r"^fo"
consistent!(cargo_culture_kit_0, r"^fo");

// cargo-screeps-0.1.3: "\\s+"
consistent!(cargo_screeps_0, "\\s+");

// cargo-brew-0.1.4: r"`(\S+) v([0-9.]+)"
consistent!(cargo_brew_0, r"`(\S+) v([0-9.]+)");

// cargo-release-0.10.2: "^\\[.+\\]"
consistent!(cargo_release_0, "^\\[.+\\]");

// cargo-release-0.10.2: "^\\[\\[.+\\]\\]"
consistent!(cargo_release_1, "^\\[\\[.+\\]\\]");

// cargo-edit-0.3.0-beta.1: r"^https://github.com/([-_0-9a-zA-Z]+)/([-_0-9a-zA-Z]+)(/|.git)?$"
consistent!(cargo_edit_0, r"^https://github.com/([-_0-9a-zA-Z]+)/([-_0-9a-zA-Z]+)(/|.git)?$");

// cargo-edit-0.3.0-beta.1: r"^https://gitlab.com/([-_0-9a-zA-Z]+)/([-_0-9a-zA-Z]+)(/|.git)?$"
consistent!(cargo_edit_1, r"^https://gitlab.com/([-_0-9a-zA-Z]+)/([-_0-9a-zA-Z]+)(/|.git)?$");

// cargo-disassemble-0.1.1: ".*"
consistent!(cargo_disassemble_0, ".*");

// cargo-demangle-0.1.2: r"(?m)(?P<symbol>_ZN[0-9]+.*E)"
consistent!(cargo_demangle_0, r"(?m)(?P<symbol>_ZN[0-9]+.*E)");

// cargo-coverage-annotations-0.1.5: r"^\s*\}(?:\)*;?|\s*else\s*\{)$"
consistent!(cargo_coverage_annotations_0, r"^\s*\}(?:\)*;?|\s*else\s*\{)$");

// cargo-urlcrate-1.0.1: "[\u{001b}\u{009b}][\\[()#;?]*(?:[0-9]{1,4}(?:;[0-9]{0,4})*)?[0-9A-PRZcf-nqry=><]"
consistent!(cargo_urlcrate_0, "[\u{001b}\u{009b}][\\[()#;?]*(?:[0-9]{1,4}(?:;[0-9]{0,4})*)?[0-9A-PRZcf-nqry=><]");

// cargo-script-0.2.8: r"^\s*\*( |$)"
consistent!(cargo_script_0, r"^\s*\*( |$)");

// cargo-script-0.2.8: r"^(\s+)"
consistent!(cargo_script_1, r"^(\s+)");

// cargo-script-0.2.8: r"/\*|\*/"
consistent!(cargo_script_2, r"/\*|\*/");

// cargo-script-0.2.8: r"^\s*//!"
consistent!(cargo_script_3, r"^\s*//!");

// cargo-script-0.2.8: r"^#![^\[].*?(\r\n|\n)"
consistent!(cargo_script_4, r"^#![^\[].*?(\r\n|\n)");

// cargo-update-1.5.2: r"cargo-install-update\.exe-v.+"
consistent!(cargo_update_0, r"cargo-install-update\.exe-v.+");

// canteen-0.4.1: r"^<(?:(int|uint|str|float|path):)?([\w_][a-zA-Z0-9_]*)>$"
consistent!(canteen_0, r"^<(?:(int|uint|str|float|path):)?([\w_][a-zA-Z0-9_]*)>$");

// thruster-cli-0.1.3: r"(.)([A-Z])"
consistent!(thruster_cli_0, r"(.)([A-Z])");

// thieves-cant-0.1.0: "([Z]+)$"
consistent!(thieves_cant_0, "([Z]+)$");

// codeowners-0.1.3: r"^@\S+/\S+"
consistent!(codeowners_0, r"^@\S+/\S+");

// codeowners-0.1.3: r"^@\S+"
consistent!(codeowners_1, r"^@\S+");

// codeowners-0.1.3: r"^\S+@\S+"
consistent!(codeowners_2, r"^\S+@\S+");

// conserve-0.4.2: r"^b0000 {21} complete   20[-0-9T:+]+\s +\d+s\n$"
consistent!(conserve_0, r"^b0000 {21} complete   20[-0-9T:+]+\s +\d+s\n$");

// commodore-0.3.0: r"(?P<greeting>\S+?) (?P<name>\S+?)$"
consistent!(commodore_0, r"(?P<greeting>\S+?) (?P<name>\S+?)$");

// corollary-0.3.0: r"([ \t]*)```haskell([\s\S]*?)```"
consistent!(corollary_0, r"([ \t]*)```haskell([\s\S]*?)```");

// corollary-0.3.0: r"\b((?:a|b|t)\d*)\b"
consistent!(corollary_1, r"\b((?:a|b|t)\d*)\b");

// colorizex-0.1.3: "NB"
consistent!(colorizex_0, "NB");

// colorstring-0.0.1: r"(?i)\[[a-z0-9_-]+\]"
consistent!(colorstring_0, r"(?i)\[[a-z0-9_-]+\]");

// colorstring-0.0.1: r"^(?i)(\[[a-z0-9_-]+\])+"
consistent!(colorstring_1, r"^(?i)(\[[a-z0-9_-]+\])+");

// cosmogony-0.3.0: "name:(.+)"
consistent!(cosmogony_0, "name:(.+)");

// cobalt-bin-0.12.1: r"(?m:^ {0,3}\[[^\]]+\]:.+$)"
consistent!(cobalt_bin_0, r"(?m:^ {0,3}\[[^\]]+\]:.+$)");

// comrak-0.2.12: r"[^\p{L}\p{M}\p{N}\p{Pc} -]"
consistent!(comrak_0, r"[^\p{L}\p{M}\p{N}\p{Pc} -]");

// content-blocker-0.2.3: ""
consistent!(content_blocker_0, "");

// content-blocker-0.2.3: "(?i)hi"
consistent!(content_blocker_1, "(?i)hi");

// content-blocker-0.2.3: "http[s]?://domain.org"
consistent!(content_blocker_2, "http[s]?://domain.org");

// content-blocker-0.2.3: "(?i)http[s]?://domain.org"
consistent!(content_blocker_3, "(?i)http[s]?://domain.org");

// content-blocker-0.2.3: "http://domain.org"
consistent!(content_blocker_4, "http://domain.org");

// content-blocker-0.2.3: "http://domain.org"
consistent!(content_blocker_5, "http://domain.org");

// content-blocker-0.2.3: "ad.html"
consistent!(content_blocker_6, "ad.html");

// content-blocker-0.2.3: "ad.html"
consistent!(content_blocker_7, "ad.html");

// content-blocker-0.2.3: "http://domain.org"
consistent!(content_blocker_8, "http://domain.org");

// content-blocker-0.2.3: "http://domain.org/nocookies.sjs"
consistent!(content_blocker_9, "http://domain.org/nocookies.sjs");

// content-blocker-0.2.3: "http://domain.org/nocookies.sjs"
consistent!(content_blocker_10, "http://domain.org/nocookies.sjs");

// content-blocker-0.2.3: "http://domain.org/hideme.jpg"
consistent!(content_blocker_11, "http://domain.org/hideme.jpg");

// content-blocker-0.2.3: "http://domain.org/ok.html"
consistent!(content_blocker_12, "http://domain.org/ok.html");

// content-blocker-0.2.3: "http://domain.org/ok.html\\?except_this=1"
consistent!(content_blocker_13, "http://domain.org/ok.html\\?except_this=1");

// victoria-dom-0.1.2: "[A-Za-z0-9=]"
consistent!(victoria_dom_0, "[A-Za-z0-9=]");

// numbat-1.0.0: r"^nsq://"
consistent!(numbat_0, r"^nsq://");

// airkorea-0.1.2: r"[\s\t\r\n]"
consistent!(airkorea_0, r"[\s\t\r\n]");

// airkorea-0.1.2: r"([\{\[,])|([\}\]])"
consistent!(airkorea_1, r"([\{\[,])|([\}\]])");

// airkorea-0.1.2: r"[^.\d]+$"
consistent!(airkorea_2, r"[^.\d]+$");

// rofl-0.0.1: r"\b"
// consistent!(rofl_0, r"\b");

// rogcat-0.2.15: r"--------- beginning of.*"
consistent!(rogcat_0, r"--------- beginning of.*");

// rogcat-0.2.15: r"a|e|i|o|u"
consistent!(rogcat_1, r"a|e|i|o|u");

// rogcat-0.2.15: r"^(\d+)([kMG])$"
consistent!(rogcat_2, r"^(\d+)([kMG])$");

// media_filename-0.1.4: "\\.([A-Za-z0-9]{2,4})$"
consistent!(media_filename_0, "\\.([A-Za-z0-9]{2,4})$");

// media_filename-0.1.4: "([0-9]{3,4}p|[0-9]{3,4}x[0-9]{3,4})"
consistent!(media_filename_1, "([0-9]{3,4}p|[0-9]{3,4}x[0-9]{3,4})");

// media_filename-0.1.4: "(?:^\\[([^]]+)\\]|- ?([^-]+)$)"
consistent!(media_filename_2, "(?:^\\[([^]]+)\\]|- ?([^-]+)$)");

// media_filename-0.1.4: "(?:[eE]([0-9]{2,3})|[^0-9A-Za-z]([0-9]{2,3})(?:v[0-9])?[^0-9A-Za-z])"
consistent!(media_filename_3, "(?:[eE]([0-9]{2,3})|[^0-9A-Za-z]([0-9]{2,3})(?:v[0-9])?[^0-9A-Za-z])");

// media_filename-0.1.4: "[sS]([0-9]{1,2})"
consistent!(media_filename_4, "[sS]([0-9]{1,2})");

// media_filename-0.1.4: "((?i)(?:PPV.)?[HP]DTV|(?:HD)?CAM|BRRIP|[^a-z]TS[^a-z]|(?:PPV )?WEB.?DL(?: DVDRip)?|HDRip|DVDRip|CamRip|W[EB]BRip|BluRay|BD|DVD|DvDScr|hdtv)"
consistent!(media_filename_5, "((?i)(?:PPV.)?[HP]DTV|(?:HD)?CAM|BRRIP|[^a-z]TS[^a-z]|(?:PPV )?WEB.?DL(?: DVDRip)?|HDRip|DVDRip|CamRip|W[EB]BRip|BluRay|BD|DVD|DvDScr|hdtv)");

// media_filename-0.1.4: "((19[0-9]|20[01])[0-9])"
consistent!(media_filename_6, "((19[0-9]|20[01])[0-9])");

// media_filename-0.1.4: "((?i)xvid|x264|h\\.?264)"
consistent!(media_filename_7, "((?i)xvid|x264|h\\.?264)");

// media_filename-0.1.4: "((?i)MP3|DD5\\.?1|Dual[- ]Audio|LiNE|DTS|AAC(?:\\.?2\\.0)?|AC3(?:\\.5\\.1)?)"
consistent!(media_filename_8, "((?i)MP3|DD5\\.?1|Dual[- ]Audio|LiNE|DTS|AAC(?:\\.?2\\.0)?|AC3(?:\\.5\\.1)?)");

// media_filename-0.1.4: "\\[([0-9A-F]{8})\\]"
consistent!(media_filename_9, "\\[([0-9A-F]{8})\\]");

// termimage-0.3.2: r"(\d+)[xX](\d+)"
consistent!(termimage_0, r"(\d+)[xX](\d+)");

// teensy-0.1.0: r".*(\d{4}-\d{2}-\d{2}).*"
consistent!(teensy_0, r".*(\d{4}-\d{2}-\d{2}).*");

// telescreen-0.1.3: r"<@(.+)>"
consistent!(telescreen_0, r"<@(.+)>");

// tempus_fugit-0.4.4: r"^(\d+)"
consistent!(tempus_fugit_0, r"^(\d+)");

// fselect-0.4.1: "(\\?|\\.|\\*|\\[|\\]|\\(|\\)|\\^|\\$)"
consistent!(fselect_0, "(\\?|\\.|\\*|\\[|\\]|\\(|\\)|\\^|\\$)");

// fselect-0.4.1: "(%|_|\\?|\\.|\\*|\\[|\\]|\\(|\\)|\\^|\\$)"
consistent!(fselect_1, "(%|_|\\?|\\.|\\*|\\[|\\]|\\(|\\)|\\^|\\$)");

// fs_eventbridge-0.1.0: r"^([A-Z]+)(?:\s(.+))?\s*"
consistent!(fs_eventbridge_0, r"^([A-Z]+)(?:\s(.+))?\s*");

// joseki-0.0.1: r"(\w{1,2})\[(.+?)\]"
consistent!(joseki_0, r"(\w{1,2})\[(.+?)\]");

// tweetr-0.2.1: r"(?i)in (\d+) (second|minute|hour|day|week)s?"
consistent!(tweetr_0, r"(?i)in (\d+) (second|minute|hour|day|week)s?");

// bullet_core-0.1.1: "^(?u:[0-9])+"
consistent!(bullet_core_0, "^(?u:[0-9])+");

// bullet_core-0.1.1: "^(?u:[0-9])+(?u:\\.)(?u:[0-9])+"
consistent!(bullet_core_1, "^(?u:[0-9])+(?u:\\.)(?u:[0-9])+");

// bullet_core-0.1.1: "^(?u:[A-Za-zª-ªµ-µº-ºÀ-ÖØ-öø-ˁˆ-ˑˠ-ˤˬ-ˬˮ-ˮͰ-ʹͶ-ͷͺ-ͽͿ-ͿΆ-ΆΈ-ΊΌ-ΌΎ-ΡΣ-ϵϷ-ҁҊ-ԯԱ-Ֆՙ-ՙա-ևא-תװ-ײؠ-يٮ-ٯٱ-ۓە-ەۥ-ۦۮ-ۯۺ-ۼۿ-ۿܐ-ܐܒ-ܯݍ-ޥޱ-ޱߊ-ߪߴ-ߵߺ-ߺࠀ-ࠕࠚ-ࠚࠤ-ࠤࠨ-ࠨࡀ-ࡘࢠ-ࢴऄ-हऽ-ऽॐ-ॐक़-ॡॱ-ঀঅ-ঌএ-ঐও-নপ-রল-লশ-হঽ-ঽৎ-ৎড়-ঢ়য়-ৡৰ-ৱਅ-ਊਏ-ਐਓ-ਨਪ-ਰਲ-ਲ਼ਵ-ਸ਼ਸ-ਹਖ਼-ੜਫ਼-ਫ਼ੲ-ੴઅ-ઍએ-ઑઓ-નપ-રલ-ળવ-હઽ-ઽૐ-ૐૠ-ૡૹ-ૹଅ-ଌଏ-ଐଓ-ନପ-ରଲ-ଳଵ-ହଽ-ଽଡ଼-ଢ଼ୟ-ୡୱ-ୱஃ-ஃஅ-ஊஎ-ஐஒ-கங-சஜ-ஜஞ-டண-தந-பம-ஹௐ-ௐఅ-ఌఎ-ఐఒ-నప-హఽ-ఽౘ-ౚౠ-ౡಅ-ಌಎ-ಐಒ-ನಪ-ಳವ-ಹಽ-ಽೞ-ೞೠ-ೡೱ-ೲഅ-ഌഎ-ഐഒ-ഺഽ-ഽൎ-ൎൟ-ൡൺ-ൿඅ-ඖක-නඳ-රල-ලව-ෆก-ะา-ำเ-ๆກ-ຂຄ-ຄງ-ຈຊ-ຊຍ-ຍດ-ທນ-ຟມ-ຣລ-ລວ-ວສ-ຫອ-ະາ-ຳຽ-ຽເ-ໄໆ-ໆໜ-ໟༀ-ༀཀ-ཇཉ-ཬྈ-ྌက-ဪဿ-ဿၐ-ၕၚ-ၝၡ-ၡၥ-ၦၮ-ၰၵ-ႁႎ-ႎႠ-ჅჇ-ჇჍ-Ⴭა-ჺჼ-ቈቊ-ቍቐ-ቖቘ-ቘቚ-ቝበ-ኈኊ-ኍነ-ኰኲ-ኵኸ-ኾዀ-ዀዂ-ዅወ-ዖዘ-ጐጒ-ጕጘ-ፚᎀ-ᎏᎠ-Ᏽᏸ-ᏽᐁ-ᙬᙯ-ᙿᚁ-ᚚᚠ-ᛪᛱ-ᛸᜀ-ᜌᜎ-ᜑᜠ-ᜱᝀ-ᝑᝠ-ᝬᝮ-ᝰក-ឳៗ-ៗៜ-ៜᠠ-ᡷᢀ-ᢨᢪ-ᢪᢰ-ᣵᤀ-ᤞᥐ-ᥭᥰ-ᥴᦀ-ᦫᦰ-ᧉᨀ-ᨖᨠ-ᩔᪧ-ᪧᬅ-ᬳᭅ-ᭋᮃ-ᮠᮮ-ᮯᮺ-ᯥᰀ-ᰣᱍ-ᱏᱚ-ᱽᳩ-ᳬᳮ-ᳱᳵ-ᳶᴀ-ᶿḀ-ἕἘ-Ἕἠ-ὅὈ-Ὅὐ-ὗὙ-ὙὛ-ὛὝ-ὝὟ-ώᾀ-ᾴᾶ-ᾼι-ιῂ-ῄῆ-ῌῐ-ΐῖ-Ίῠ-Ῥῲ-ῴῶ-ῼⁱ-ⁱⁿ-ⁿₐ-ₜℂ-ℂℇ-ℇℊ-ℓℕ-ℕℙ-ℝℤ-ℤΩ-Ωℨ-ℨK-ℭℯ-ℹℼ-ℿⅅ-ⅉⅎ-ⅎↃ-ↄⰀ-Ⱞⰰ-ⱞⱠ-ⳤⳫ-ⳮⳲ-ⳳⴀ-ⴥⴧ-ⴧⴭ-ⴭⴰ-ⵧⵯ-ⵯⶀ-ⶖⶠ-ⶦⶨ-ⶮⶰ-ⶶⶸ-ⶾⷀ-ⷆⷈ-ⷎⷐ-ⷖⷘ-ⷞⸯ-ⸯ々-〆〱-〵〻-〼ぁ-ゖゝ-ゟァ-ヺー-ヿㄅ-ㄭㄱ-ㆎㆠ-ㆺㇰ-ㇿ㐀-䶵一-鿕ꀀ-ꒌꓐ-ꓽꔀ-ꘌꘐ-ꘟꘪ-ꘫꙀ-ꙮꙿ-ꚝꚠ-ꛥꜗ-ꜟꜢ-ꞈꞋ-ꞭꞰ-ꞷꟷ-ꠁꠃ-ꠅꠇ-ꠊꠌ-ꠢꡀ-ꡳꢂ-ꢳꣲ-ꣷꣻ-ꣻꣽ-ꣽꤊ-ꤥꤰ-ꥆꥠ-ꥼꦄ-ꦲꧏ-ꧏꧠ-ꧤꧦ-ꧯꧺ-ꧾꨀ-ꨨꩀ-ꩂꩄ-ꩋꩠ-ꩶꩺ-ꩺꩾ-ꪯꪱ-ꪱꪵ-ꪶꪹ-ꪽꫀ-ꫀꫂ-ꫂꫛ-ꫝꫠ-ꫪꫲ-ꫴꬁ-ꬆꬉ-ꬎꬑ-ꬖꬠ-ꬦꬨ-ꬮꬰ-ꭚꭜ-ꭥꭰ-ꯢ가-힣ힰ-ퟆퟋ-ퟻ豈-舘並-龎ﬀ-ﬆﬓ-ﬗיִ-יִײַ-ﬨשׁ-זּטּ-לּמּ-מּנּ-סּףּ-פּצּ-ﮱﯓ-ﴽﵐ-ﶏﶒ-ﷇﷰ-ﷻﹰ-ﹴﹶ-ﻼＡ-Ｚａ-ｚｦ-ﾾￂ-ￇￊ-ￏￒ-ￗￚ-ￜ𐀀-𐀋𐀍-𐀦𐀨-𐀺𐀼-𐀽𐀿-𐁍𐁐-𐁝𐂀-𐃺𐊀-𐊜𐊠-𐋐𐌀-𐌟𐌰-𐍀𐍂-𐍉𐍐-𐍵𐎀-𐎝𐎠-𐏃𐏈-𐏏𐐀-𐒝𐔀-𐔧𐔰-𐕣𐘀-𐜶𐝀-𐝕𐝠-𐝧𐠀-𐠅𐠈-𐠈𐠊-𐠵𐠷-𐠸𐠼-𐠼𐠿-𐡕𐡠-𐡶𐢀-𐢞𐣠-𐣲𐣴-𐣵𐤀-𐤕𐤠-𐤹𐦀-𐦷𐦾-𐦿𐨀-𐨀𐨐-𐨓𐨕-𐨗𐨙-𐨳𐩠-𐩼𐪀-𐪜𐫀-𐫇𐫉-𐫤𐬀-𐬵𐭀-𐭕𐭠-𐭲𐮀-𐮑𐰀-𐱈𐲀-𐲲𐳀-𐳲𑀃-𑀷𑂃-𑂯𑃐-𑃨𑄃-𑄦𑅐-𑅲𑅶-𑅶𑆃-𑆲𑇁-𑇄𑇚-𑇚𑇜-𑇜𑈀-𑈑𑈓-𑈫𑊀-𑊆𑊈-𑊈𑊊-𑊍𑊏-𑊝𑊟-𑊨𑊰-𑋞𑌅-𑌌𑌏-𑌐𑌓-𑌨𑌪-𑌰𑌲-𑌳𑌵-𑌹𑌽-𑌽𑍐-𑍐𑍝-𑍡𑒀-𑒯𑓄-𑓅𑓇-𑓇𑖀-𑖮𑗘-𑗛𑘀-𑘯𑙄-𑙄𑚀-𑚪𑜀-𑜙𑢠-𑣟𑣿-𑣿𑫀-𑫸𒀀-𒎙𒒀-𒕃𓀀-𓐮𔐀-𔙆𖠀-𖨸𖩀-𖩞𖫐-𖫭𖬀-𖬯𖭀-𖭃𖭣-𖭷𖭽-𖮏𖼀-𖽄𖽐-𖽐𖾓-𖾟𛀀-𛀁𛰀-𛱪𛱰-𛱼𛲀-𛲈𛲐-𛲙𝐀-𝑔𝑖-𝒜𝒞-𝒟𝒢-𝒢𝒥-𝒦𝒩-𝒬𝒮-𝒹𝒻-𝒻𝒽-𝓃𝓅-𝔅𝔇-𝔊𝔍-𝔔𝔖-𝔜𝔞-𝔹𝔻-𝔾𝕀-𝕄𝕆-𝕆𝕊-𝕐𝕒-𝚥𝚨-𝛀𝛂-𝛚𝛜-𝛺𝛼-𝜔𝜖-𝜴𝜶-𝝎𝝐-𝝮𝝰-𝞈𝞊-𝞨𝞪-𝟂𝟄-𝟋𞠀-𞣄𞸀-𞸃𞸅-𞸟𞸡-𞸢𞸤-𞸤𞸧-𞸧𞸩-𞸲𞸴-𞸷𞸹-𞸹𞸻-𞸻𞹂-𞹂𞹇-𞹇𞹉-𞹉𞹋-𞹋𞹍-𞹏𞹑-𞹒𞹔-𞹔𞹗-𞹗𞹙-𞹙𞹛-𞹛𞹝-𞹝𞹟-𞹟𞹡-𞹢𞹤-𞹤𞹧-𞹪𞹬-𞹲𞹴-𞹷𞹹-𞹼𞹾-𞹾𞺀-𞺉𞺋-𞺛𞺡-𞺣𞺥-𞺩𞺫-𞺻𠀀-𪛖𪜀-𫜴𫝀-𫠝𫠠-𬺡丽-𪘀])+"
consistent!(bullet_core_2, "^(?u:[A-Za-zª-ªµ-µº-ºÀ-ÖØ-öø-ˁˆ-ˑˠ-ˤˬ-ˬˮ-ˮͰ-ʹͶ-ͷͺ-ͽͿ-ͿΆ-ΆΈ-ΊΌ-ΌΎ-ΡΣ-ϵϷ-ҁҊ-ԯԱ-Ֆՙ-ՙա-ևא-תװ-ײؠ-يٮ-ٯٱ-ۓە-ەۥ-ۦۮ-ۯۺ-ۼۿ-ۿܐ-ܐܒ-ܯݍ-ޥޱ-ޱߊ-ߪߴ-ߵߺ-ߺࠀ-ࠕࠚ-ࠚࠤ-ࠤࠨ-ࠨࡀ-ࡘࢠ-ࢴऄ-हऽ-ऽॐ-ॐक़-ॡॱ-ঀঅ-ঌএ-ঐও-নপ-রল-লশ-হঽ-ঽৎ-ৎড়-ঢ়য়-ৡৰ-ৱਅ-ਊਏ-ਐਓ-ਨਪ-ਰਲ-ਲ਼ਵ-ਸ਼ਸ-ਹਖ਼-ੜਫ਼-ਫ਼ੲ-ੴઅ-ઍએ-ઑઓ-નપ-રલ-ળવ-હઽ-ઽૐ-ૐૠ-ૡૹ-ૹଅ-ଌଏ-ଐଓ-ନପ-ରଲ-ଳଵ-ହଽ-ଽଡ଼-ଢ଼ୟ-ୡୱ-ୱஃ-ஃஅ-ஊஎ-ஐஒ-கங-சஜ-ஜஞ-டண-தந-பம-ஹௐ-ௐఅ-ఌఎ-ఐఒ-నప-హఽ-ఽౘ-ౚౠ-ౡಅ-ಌಎ-ಐಒ-ನಪ-ಳವ-ಹಽ-ಽೞ-ೞೠ-ೡೱ-ೲഅ-ഌഎ-ഐഒ-ഺഽ-ഽൎ-ൎൟ-ൡൺ-ൿඅ-ඖක-නඳ-රල-ලව-ෆก-ะา-ำเ-ๆກ-ຂຄ-ຄງ-ຈຊ-ຊຍ-ຍດ-ທນ-ຟມ-ຣລ-ລວ-ວສ-ຫອ-ະາ-ຳຽ-ຽເ-ໄໆ-ໆໜ-ໟༀ-ༀཀ-ཇཉ-ཬྈ-ྌက-ဪဿ-ဿၐ-ၕၚ-ၝၡ-ၡၥ-ၦၮ-ၰၵ-ႁႎ-ႎႠ-ჅჇ-ჇჍ-Ⴭა-ჺჼ-ቈቊ-ቍቐ-ቖቘ-ቘቚ-ቝበ-ኈኊ-ኍነ-ኰኲ-ኵኸ-ኾዀ-ዀዂ-ዅወ-ዖዘ-ጐጒ-ጕጘ-ፚᎀ-ᎏᎠ-Ᏽᏸ-ᏽᐁ-ᙬᙯ-ᙿᚁ-ᚚᚠ-ᛪᛱ-ᛸᜀ-ᜌᜎ-ᜑᜠ-ᜱᝀ-ᝑᝠ-ᝬᝮ-ᝰក-ឳៗ-ៗៜ-ៜᠠ-ᡷᢀ-ᢨᢪ-ᢪᢰ-ᣵᤀ-ᤞᥐ-ᥭᥰ-ᥴᦀ-ᦫᦰ-ᧉᨀ-ᨖᨠ-ᩔᪧ-ᪧᬅ-ᬳᭅ-ᭋᮃ-ᮠᮮ-ᮯᮺ-ᯥᰀ-ᰣᱍ-ᱏᱚ-ᱽᳩ-ᳬᳮ-ᳱᳵ-ᳶᴀ-ᶿḀ-ἕἘ-Ἕἠ-ὅὈ-Ὅὐ-ὗὙ-ὙὛ-ὛὝ-ὝὟ-ώᾀ-ᾴᾶ-ᾼι-ιῂ-ῄῆ-ῌῐ-ΐῖ-Ίῠ-Ῥῲ-ῴῶ-ῼⁱ-ⁱⁿ-ⁿₐ-ₜℂ-ℂℇ-ℇℊ-ℓℕ-ℕℙ-ℝℤ-ℤΩ-Ωℨ-ℨK-ℭℯ-ℹℼ-ℿⅅ-ⅉⅎ-ⅎↃ-ↄⰀ-Ⱞⰰ-ⱞⱠ-ⳤⳫ-ⳮⳲ-ⳳⴀ-ⴥⴧ-ⴧⴭ-ⴭⴰ-ⵧⵯ-ⵯⶀ-ⶖⶠ-ⶦⶨ-ⶮⶰ-ⶶⶸ-ⶾⷀ-ⷆⷈ-ⷎⷐ-ⷖⷘ-ⷞⸯ-ⸯ々-〆〱-〵〻-〼ぁ-ゖゝ-ゟァ-ヺー-ヿㄅ-ㄭㄱ-ㆎㆠ-ㆺㇰ-ㇿ㐀-䶵一-鿕ꀀ-ꒌꓐ-ꓽꔀ-ꘌꘐ-ꘟꘪ-ꘫꙀ-ꙮꙿ-ꚝꚠ-ꛥꜗ-ꜟꜢ-ꞈꞋ-ꞭꞰ-ꞷꟷ-ꠁꠃ-ꠅꠇ-ꠊꠌ-ꠢꡀ-ꡳꢂ-ꢳꣲ-ꣷꣻ-ꣻꣽ-ꣽꤊ-ꤥꤰ-ꥆꥠ-ꥼꦄ-ꦲꧏ-ꧏꧠ-ꧤꧦ-ꧯꧺ-ꧾꨀ-ꨨꩀ-ꩂꩄ-ꩋꩠ-ꩶꩺ-ꩺꩾ-ꪯꪱ-ꪱꪵ-ꪶꪹ-ꪽꫀ-ꫀꫂ-ꫂꫛ-ꫝꫠ-ꫪꫲ-ꫴꬁ-ꬆꬉ-ꬎꬑ-ꬖꬠ-ꬦꬨ-ꬮꬰ-ꭚꭜ-ꭥꭰ-ꯢ가-힣ힰ-ퟆퟋ-ퟻ豈-舘並-龎ﬀ-ﬆﬓ-ﬗיִ-יִײַ-ﬨשׁ-זּטּ-לּמּ-מּנּ-סּףּ-פּצּ-ﮱﯓ-ﴽﵐ-ﶏﶒ-ﷇﷰ-ﷻﹰ-ﹴﹶ-ﻼＡ-Ｚａ-ｚｦ-ﾾￂ-ￇￊ-ￏￒ-ￗￚ-ￜ𐀀-𐀋𐀍-𐀦𐀨-𐀺𐀼-𐀽𐀿-𐁍𐁐-𐁝𐂀-𐃺𐊀-𐊜𐊠-𐋐𐌀-𐌟𐌰-𐍀𐍂-𐍉𐍐-𐍵𐎀-𐎝𐎠-𐏃𐏈-𐏏𐐀-𐒝𐔀-𐔧𐔰-𐕣𐘀-𐜶𐝀-𐝕𐝠-𐝧𐠀-𐠅𐠈-𐠈𐠊-𐠵𐠷-𐠸𐠼-𐠼𐠿-𐡕𐡠-𐡶𐢀-𐢞𐣠-𐣲𐣴-𐣵𐤀-𐤕𐤠-𐤹𐦀-𐦷𐦾-𐦿𐨀-𐨀𐨐-𐨓𐨕-𐨗𐨙-𐨳𐩠-𐩼𐪀-𐪜𐫀-𐫇𐫉-𐫤𐬀-𐬵𐭀-𐭕𐭠-𐭲𐮀-𐮑𐰀-𐱈𐲀-𐲲𐳀-𐳲𑀃-𑀷𑂃-𑂯𑃐-𑃨𑄃-𑄦𑅐-𑅲𑅶-𑅶𑆃-𑆲𑇁-𑇄𑇚-𑇚𑇜-𑇜𑈀-𑈑𑈓-𑈫𑊀-𑊆𑊈-𑊈𑊊-𑊍𑊏-𑊝𑊟-𑊨𑊰-𑋞𑌅-𑌌𑌏-𑌐𑌓-𑌨𑌪-𑌰𑌲-𑌳𑌵-𑌹𑌽-𑌽𑍐-𑍐𑍝-𑍡𑒀-𑒯𑓄-𑓅𑓇-𑓇𑖀-𑖮𑗘-𑗛𑘀-𑘯𑙄-𑙄𑚀-𑚪𑜀-𑜙𑢠-𑣟𑣿-𑣿𑫀-𑫸𒀀-𒎙𒒀-𒕃𓀀-𓐮𔐀-𔙆𖠀-𖨸𖩀-𖩞𖫐-𖫭𖬀-𖬯𖭀-𖭃𖭣-𖭷𖭽-𖮏𖼀-𖽄𖽐-𖽐𖾓-𖾟𛀀-𛀁𛰀-𛱪𛱰-𛱼𛲀-𛲈𛲐-𛲙𝐀-𝑔𝑖-𝒜𝒞-𝒟𝒢-𝒢𝒥-𝒦𝒩-𝒬𝒮-𝒹𝒻-𝒻𝒽-𝓃𝓅-𝔅𝔇-𝔊𝔍-𝔔𝔖-𝔜𝔞-𝔹𝔻-𝔾𝕀-𝕄𝕆-𝕆𝕊-𝕐𝕒-𝚥𝚨-𝛀𝛂-𝛚𝛜-𝛺𝛼-𝜔𝜖-𝜴𝜶-𝝎𝝐-𝝮𝝰-𝞈𝞊-𝞨𝞪-𝟂𝟄-𝟋𞠀-𞣄𞸀-𞸃𞸅-𞸟𞸡-𞸢𞸤-𞸤𞸧-𞸧𞸩-𞸲𞸴-𞸷𞸹-𞸹𞸻-𞸻𞹂-𞹂𞹇-𞹇𞹉-𞹉𞹋-𞹋𞹍-𞹏𞹑-𞹒𞹔-𞹔𞹗-𞹗𞹙-𞹙𞹛-𞹛𞹝-𞹝𞹟-𞹟𞹡-𞹢𞹤-𞹤𞹧-𞹪𞹬-𞹲𞹴-𞹷𞹹-𞹼𞹾-𞹾𞺀-𞺉𞺋-𞺛𞺡-𞺣𞺥-𞺩𞺫-𞺻𠀀-𪛖𪜀-𫜴𫝀-𫠝𫠠-𬺡丽-𪘀])+");

// bullet_core-0.1.1: "^(?u:d/d)((?u:[A-Za-zª-ªµ-µº-ºÀ-ÖØ-öø-ˁˆ-ˑˠ-ˤˬ-ˬˮ-ˮͰ-ʹͶ-ͷͺ-ͽͿ-ͿΆ-ΆΈ-ΊΌ-ΌΎ-ΡΣ-ϵϷ-ҁҊ-ԯԱ-Ֆՙ-ՙա-ևא-תװ-ײؠ-يٮ-ٯٱ-ۓە-ەۥ-ۦۮ-ۯۺ-ۼۿ-ۿܐ-ܐܒ-ܯݍ-ޥޱ-ޱߊ-ߪߴ-ߵߺ-ߺࠀ-ࠕࠚ-ࠚࠤ-ࠤࠨ-ࠨࡀ-ࡘࢠ-ࢴऄ-हऽ-ऽॐ-ॐक़-ॡॱ-ঀঅ-ঌএ-ঐও-নপ-রল-লশ-হঽ-ঽৎ-ৎড়-ঢ়য়-ৡৰ-ৱਅ-ਊਏ-ਐਓ-ਨਪ-ਰਲ-ਲ਼ਵ-ਸ਼ਸ-ਹਖ਼-ੜਫ਼-ਫ਼ੲ-ੴઅ-ઍએ-ઑઓ-નપ-રલ-ળવ-હઽ-ઽૐ-ૐૠ-ૡૹ-ૹଅ-ଌଏ-ଐଓ-ନପ-ରଲ-ଳଵ-ହଽ-ଽଡ଼-ଢ଼ୟ-ୡୱ-ୱஃ-ஃஅ-ஊஎ-ஐஒ-கங-சஜ-ஜஞ-டண-தந-பம-ஹௐ-ௐఅ-ఌఎ-ఐఒ-నప-హఽ-ఽౘ-ౚౠ-ౡಅ-ಌಎ-ಐಒ-ನಪ-ಳವ-ಹಽ-ಽೞ-ೞೠ-ೡೱ-ೲഅ-ഌഎ-ഐഒ-ഺഽ-ഽൎ-ൎൟ-ൡൺ-ൿඅ-ඖක-නඳ-රල-ලව-ෆก-ะา-ำเ-ๆກ-ຂຄ-ຄງ-ຈຊ-ຊຍ-ຍດ-ທນ-ຟມ-ຣລ-ລວ-ວສ-ຫອ-ະາ-ຳຽ-ຽເ-ໄໆ-ໆໜ-ໟༀ-ༀཀ-ཇཉ-ཬྈ-ྌက-ဪဿ-ဿၐ-ၕၚ-ၝၡ-ၡၥ-ၦၮ-ၰၵ-ႁႎ-ႎႠ-ჅჇ-ჇჍ-Ⴭა-ჺჼ-ቈቊ-ቍቐ-ቖቘ-ቘቚ-ቝበ-ኈኊ-ኍነ-ኰኲ-ኵኸ-ኾዀ-ዀዂ-ዅወ-ዖዘ-ጐጒ-ጕጘ-ፚᎀ-ᎏᎠ-Ᏽᏸ-ᏽᐁ-ᙬᙯ-ᙿᚁ-ᚚᚠ-ᛪᛱ-ᛸᜀ-ᜌᜎ-ᜑᜠ-ᜱᝀ-ᝑᝠ-ᝬᝮ-ᝰក-ឳៗ-ៗៜ-ៜᠠ-ᡷᢀ-ᢨᢪ-ᢪᢰ-ᣵᤀ-ᤞᥐ-ᥭᥰ-ᥴᦀ-ᦫᦰ-ᧉᨀ-ᨖᨠ-ᩔᪧ-ᪧᬅ-ᬳᭅ-ᭋᮃ-ᮠᮮ-ᮯᮺ-ᯥᰀ-ᰣᱍ-ᱏᱚ-ᱽᳩ-ᳬᳮ-ᳱᳵ-ᳶᴀ-ᶿḀ-ἕἘ-Ἕἠ-ὅὈ-Ὅὐ-ὗὙ-ὙὛ-ὛὝ-ὝὟ-ώᾀ-ᾴᾶ-ᾼι-ιῂ-ῄῆ-ῌῐ-ΐῖ-Ίῠ-Ῥῲ-ῴῶ-ῼⁱ-ⁱⁿ-ⁿₐ-ₜℂ-ℂℇ-ℇℊ-ℓℕ-ℕℙ-ℝℤ-ℤΩ-Ωℨ-ℨK-ℭℯ-ℹℼ-ℿⅅ-ⅉⅎ-ⅎↃ-ↄⰀ-Ⱞⰰ-ⱞⱠ-ⳤⳫ-ⳮⳲ-ⳳⴀ-ⴥⴧ-ⴧⴭ-ⴭⴰ-ⵧⵯ-ⵯⶀ-ⶖⶠ-ⶦⶨ-ⶮⶰ-ⶶⶸ-ⶾⷀ-ⷆⷈ-ⷎⷐ-ⷖⷘ-ⷞⸯ-ⸯ々-〆〱-〵〻-〼ぁ-ゖゝ-ゟァ-ヺー-ヿㄅ-ㄭㄱ-ㆎㆠ-ㆺㇰ-ㇿ㐀-䶵一-鿕ꀀ-ꒌꓐ-ꓽꔀ-ꘌꘐ-ꘟꘪ-ꘫꙀ-ꙮꙿ-ꚝꚠ-ꛥꜗ-ꜟꜢ-ꞈꞋ-ꞭꞰ-ꞷꟷ-ꠁꠃ-ꠅꠇ-ꠊꠌ-ꠢꡀ-ꡳꢂ-ꢳꣲ-ꣷꣻ-ꣻꣽ-ꣽꤊ-ꤥꤰ-ꥆꥠ-ꥼꦄ-ꦲꧏ-ꧏꧠ-ꧤꧦ-ꧯꧺ-ꧾꨀ-ꨨꩀ-ꩂꩄ-ꩋꩠ-ꩶꩺ-ꩺꩾ-ꪯꪱ-ꪱꪵ-ꪶꪹ-ꪽꫀ-ꫀꫂ-ꫂꫛ-ꫝꫠ-ꫪꫲ-ꫴꬁ-ꬆꬉ-ꬎꬑ-ꬖꬠ-ꬦꬨ-ꬮꬰ-ꭚꭜ-ꭥꭰ-ꯢ가-힣ힰ-ퟆퟋ-ퟻ豈-舘並-龎ﬀ-ﬆﬓ-ﬗיִ-יִײַ-ﬨשׁ-זּטּ-לּמּ-מּנּ-סּףּ-פּצּ-ﮱﯓ-ﴽﵐ-ﶏﶒ-ﷇﷰ-ﷻﹰ-ﹴﹶ-ﻼＡ-Ｚａ-ｚｦ-ﾾￂ-ￇￊ-ￏￒ-ￗￚ-ￜ𐀀-𐀋𐀍-𐀦𐀨-𐀺𐀼-𐀽𐀿-𐁍𐁐-𐁝𐂀-𐃺𐊀-𐊜𐊠-𐋐𐌀-𐌟𐌰-𐍀𐍂-𐍉𐍐-𐍵𐎀-𐎝𐎠-𐏃𐏈-𐏏𐐀-𐒝𐔀-𐔧𐔰-𐕣𐘀-𐜶𐝀-𐝕𐝠-𐝧𐠀-𐠅𐠈-𐠈𐠊-𐠵𐠷-𐠸𐠼-𐠼𐠿-𐡕𐡠-𐡶𐢀-𐢞𐣠-𐣲𐣴-𐣵𐤀-𐤕𐤠-𐤹𐦀-𐦷𐦾-𐦿𐨀-𐨀𐨐-𐨓𐨕-𐨗𐨙-𐨳𐩠-𐩼𐪀-𐪜𐫀-𐫇𐫉-𐫤𐬀-𐬵𐭀-𐭕𐭠-𐭲𐮀-𐮑𐰀-𐱈𐲀-𐲲𐳀-𐳲𑀃-𑀷𑂃-𑂯𑃐-𑃨𑄃-𑄦𑅐-𑅲𑅶-𑅶𑆃-𑆲𑇁-𑇄𑇚-𑇚𑇜-𑇜𑈀-𑈑𑈓-𑈫𑊀-𑊆𑊈-𑊈𑊊-𑊍𑊏-𑊝𑊟-𑊨𑊰-𑋞𑌅-𑌌𑌏-𑌐𑌓-𑌨𑌪-𑌰𑌲-𑌳𑌵-𑌹𑌽-𑌽𑍐-𑍐𑍝-𑍡𑒀-𑒯𑓄-𑓅𑓇-𑓇𑖀-𑖮𑗘-𑗛𑘀-𑘯𑙄-𑙄𑚀-𑚪𑜀-𑜙𑢠-𑣟𑣿-𑣿𑫀-𑫸𒀀-𒎙𒒀-𒕃𓀀-𓐮𔐀-𔙆𖠀-𖨸𖩀-𖩞𖫐-𖫭𖬀-𖬯𖭀-𖭃𖭣-𖭷𖭽-𖮏𖼀-𖽄𖽐-𖽐𖾓-𖾟𛀀-𛀁𛰀-𛱪𛱰-𛱼𛲀-𛲈𛲐-𛲙𝐀-𝑔𝑖-𝒜𝒞-𝒟𝒢-𝒢𝒥-𝒦𝒩-𝒬𝒮-𝒹𝒻-𝒻𝒽-𝓃𝓅-𝔅𝔇-𝔊𝔍-𝔔𝔖-𝔜𝔞-𝔹𝔻-𝔾𝕀-𝕄𝕆-𝕆𝕊-𝕐𝕒-𝚥𝚨-𝛀𝛂-𝛚𝛜-𝛺𝛼-𝜔𝜖-𝜴𝜶-𝝎𝝐-𝝮𝝰-𝞈𝞊-𝞨𝞪-𝟂𝟄-𝟋𞠀-𞣄𞸀-𞸃𞸅-𞸟𞸡-𞸢𞸤-𞸤𞸧-𞸧𞸩-𞸲𞸴-𞸷𞸹-𞸹𞸻-𞸻𞹂-𞹂𞹇-𞹇𞹉-𞹉𞹋-𞹋𞹍-𞹏𞹑-𞹒𞹔-𞹔𞹗-𞹗𞹙-𞹙𞹛-𞹛𞹝-𞹝𞹟-𞹟𞹡-𞹢𞹤-𞹤𞹧-𞹪𞹬-𞹲𞹴-𞹷𞹹-𞹼𞹾-𞹾𞺀-𞺉𞺋-𞺛𞺡-𞺣𞺥-𞺩𞺫-𞺻𠀀-𪛖𪜀-𫜴𫝀-𫠝𫠠-𬺡丽-𪘀])+)"
consistent!(bullet_core_3, "^(?u:d/d)((?u:[A-Za-zª-ªµ-µº-ºÀ-ÖØ-öø-ˁˆ-ˑˠ-ˤˬ-ˬˮ-ˮͰ-ʹͶ-ͷͺ-ͽͿ-ͿΆ-ΆΈ-ΊΌ-ΌΎ-ΡΣ-ϵϷ-ҁҊ-ԯԱ-Ֆՙ-ՙա-ևא-תװ-ײؠ-يٮ-ٯٱ-ۓە-ەۥ-ۦۮ-ۯۺ-ۼۿ-ۿܐ-ܐܒ-ܯݍ-ޥޱ-ޱߊ-ߪߴ-ߵߺ-ߺࠀ-ࠕࠚ-ࠚࠤ-ࠤࠨ-ࠨࡀ-ࡘࢠ-ࢴऄ-हऽ-ऽॐ-ॐक़-ॡॱ-ঀঅ-ঌএ-ঐও-নপ-রল-লশ-হঽ-ঽৎ-ৎড়-ঢ়য়-ৡৰ-ৱਅ-ਊਏ-ਐਓ-ਨਪ-ਰਲ-ਲ਼ਵ-ਸ਼ਸ-ਹਖ਼-ੜਫ਼-ਫ਼ੲ-ੴઅ-ઍએ-ઑઓ-નપ-રલ-ળવ-હઽ-ઽૐ-ૐૠ-ૡૹ-ૹଅ-ଌଏ-ଐଓ-ନପ-ରଲ-ଳଵ-ହଽ-ଽଡ଼-ଢ଼ୟ-ୡୱ-ୱஃ-ஃஅ-ஊஎ-ஐஒ-கங-சஜ-ஜஞ-டண-தந-பம-ஹௐ-ௐఅ-ఌఎ-ఐఒ-నప-హఽ-ఽౘ-ౚౠ-ౡಅ-ಌಎ-ಐಒ-ನಪ-ಳವ-ಹಽ-ಽೞ-ೞೠ-ೡೱ-ೲഅ-ഌഎ-ഐഒ-ഺഽ-ഽൎ-ൎൟ-ൡൺ-ൿඅ-ඖක-නඳ-රල-ලව-ෆก-ะา-ำเ-ๆກ-ຂຄ-ຄງ-ຈຊ-ຊຍ-ຍດ-ທນ-ຟມ-ຣລ-ລວ-ວສ-ຫອ-ະາ-ຳຽ-ຽເ-ໄໆ-ໆໜ-ໟༀ-ༀཀ-ཇཉ-ཬྈ-ྌက-ဪဿ-ဿၐ-ၕၚ-ၝၡ-ၡၥ-ၦၮ-ၰၵ-ႁႎ-ႎႠ-ჅჇ-ჇჍ-Ⴭა-ჺჼ-ቈቊ-ቍቐ-ቖቘ-ቘቚ-ቝበ-ኈኊ-ኍነ-ኰኲ-ኵኸ-ኾዀ-ዀዂ-ዅወ-ዖዘ-ጐጒ-ጕጘ-ፚᎀ-ᎏᎠ-Ᏽᏸ-ᏽᐁ-ᙬᙯ-ᙿᚁ-ᚚᚠ-ᛪᛱ-ᛸᜀ-ᜌᜎ-ᜑᜠ-ᜱᝀ-ᝑᝠ-ᝬᝮ-ᝰក-ឳៗ-ៗៜ-ៜᠠ-ᡷᢀ-ᢨᢪ-ᢪᢰ-ᣵᤀ-ᤞᥐ-ᥭᥰ-ᥴᦀ-ᦫᦰ-ᧉᨀ-ᨖᨠ-ᩔᪧ-ᪧᬅ-ᬳᭅ-ᭋᮃ-ᮠᮮ-ᮯᮺ-ᯥᰀ-ᰣᱍ-ᱏᱚ-ᱽᳩ-ᳬᳮ-ᳱᳵ-ᳶᴀ-ᶿḀ-ἕἘ-Ἕἠ-ὅὈ-Ὅὐ-ὗὙ-ὙὛ-ὛὝ-ὝὟ-ώᾀ-ᾴᾶ-ᾼι-ιῂ-ῄῆ-ῌῐ-ΐῖ-Ίῠ-Ῥῲ-ῴῶ-ῼⁱ-ⁱⁿ-ⁿₐ-ₜℂ-ℂℇ-ℇℊ-ℓℕ-ℕℙ-ℝℤ-ℤΩ-Ωℨ-ℨK-ℭℯ-ℹℼ-ℿⅅ-ⅉⅎ-ⅎↃ-ↄⰀ-Ⱞⰰ-ⱞⱠ-ⳤⳫ-ⳮⳲ-ⳳⴀ-ⴥⴧ-ⴧⴭ-ⴭⴰ-ⵧⵯ-ⵯⶀ-ⶖⶠ-ⶦⶨ-ⶮⶰ-ⶶⶸ-ⶾⷀ-ⷆⷈ-ⷎⷐ-ⷖⷘ-ⷞⸯ-ⸯ々-〆〱-〵〻-〼ぁ-ゖゝ-ゟァ-ヺー-ヿㄅ-ㄭㄱ-ㆎㆠ-ㆺㇰ-ㇿ㐀-䶵一-鿕ꀀ-ꒌꓐ-ꓽꔀ-ꘌꘐ-ꘟꘪ-ꘫꙀ-ꙮꙿ-ꚝꚠ-ꛥꜗ-ꜟꜢ-ꞈꞋ-ꞭꞰ-ꞷꟷ-ꠁꠃ-ꠅꠇ-ꠊꠌ-ꠢꡀ-ꡳꢂ-ꢳꣲ-ꣷꣻ-ꣻꣽ-ꣽꤊ-ꤥꤰ-ꥆꥠ-ꥼꦄ-ꦲꧏ-ꧏꧠ-ꧤꧦ-ꧯꧺ-ꧾꨀ-ꨨꩀ-ꩂꩄ-ꩋꩠ-ꩶꩺ-ꩺꩾ-ꪯꪱ-ꪱꪵ-ꪶꪹ-ꪽꫀ-ꫀꫂ-ꫂꫛ-ꫝꫠ-ꫪꫲ-ꫴꬁ-ꬆꬉ-ꬎꬑ-ꬖꬠ-ꬦꬨ-ꬮꬰ-ꭚꭜ-ꭥꭰ-ꯢ가-힣ힰ-ퟆퟋ-ퟻ豈-舘並-龎ﬀ-ﬆﬓ-ﬗיִ-יִײַ-ﬨשׁ-זּטּ-לּמּ-מּנּ-סּףּ-פּצּ-ﮱﯓ-ﴽﵐ-ﶏﶒ-ﷇﷰ-ﷻﹰ-ﹴﹶ-ﻼＡ-Ｚａ-ｚｦ-ﾾￂ-ￇￊ-ￏￒ-ￗￚ-ￜ𐀀-𐀋𐀍-𐀦𐀨-𐀺𐀼-𐀽𐀿-𐁍𐁐-𐁝𐂀-𐃺𐊀-𐊜𐊠-𐋐𐌀-𐌟𐌰-𐍀𐍂-𐍉𐍐-𐍵𐎀-𐎝𐎠-𐏃𐏈-𐏏𐐀-𐒝𐔀-𐔧𐔰-𐕣𐘀-𐜶𐝀-𐝕𐝠-𐝧𐠀-𐠅𐠈-𐠈𐠊-𐠵𐠷-𐠸𐠼-𐠼𐠿-𐡕𐡠-𐡶𐢀-𐢞𐣠-𐣲𐣴-𐣵𐤀-𐤕𐤠-𐤹𐦀-𐦷𐦾-𐦿𐨀-𐨀𐨐-𐨓𐨕-𐨗𐨙-𐨳𐩠-𐩼𐪀-𐪜𐫀-𐫇𐫉-𐫤𐬀-𐬵𐭀-𐭕𐭠-𐭲𐮀-𐮑𐰀-𐱈𐲀-𐲲𐳀-𐳲𑀃-𑀷𑂃-𑂯𑃐-𑃨𑄃-𑄦𑅐-𑅲𑅶-𑅶𑆃-𑆲𑇁-𑇄𑇚-𑇚𑇜-𑇜𑈀-𑈑𑈓-𑈫𑊀-𑊆𑊈-𑊈𑊊-𑊍𑊏-𑊝𑊟-𑊨𑊰-𑋞𑌅-𑌌𑌏-𑌐𑌓-𑌨𑌪-𑌰𑌲-𑌳𑌵-𑌹𑌽-𑌽𑍐-𑍐𑍝-𑍡𑒀-𑒯𑓄-𑓅𑓇-𑓇𑖀-𑖮𑗘-𑗛𑘀-𑘯𑙄-𑙄𑚀-𑚪𑜀-𑜙𑢠-𑣟𑣿-𑣿𑫀-𑫸𒀀-𒎙𒒀-𒕃𓀀-𓐮𔐀-𔙆𖠀-𖨸𖩀-𖩞𖫐-𖫭𖬀-𖬯𖭀-𖭃𖭣-𖭷𖭽-𖮏𖼀-𖽄𖽐-𖽐𖾓-𖾟𛀀-𛀁𛰀-𛱪𛱰-𛱼𛲀-𛲈𛲐-𛲙𝐀-𝑔𝑖-𝒜𝒞-𝒟𝒢-𝒢𝒥-𝒦𝒩-𝒬𝒮-𝒹𝒻-𝒻𝒽-𝓃𝓅-𝔅𝔇-𝔊𝔍-𝔔𝔖-𝔜𝔞-𝔹𝔻-𝔾𝕀-𝕄𝕆-𝕆𝕊-𝕐𝕒-𝚥𝚨-𝛀𝛂-𝛚𝛜-𝛺𝛼-𝜔𝜖-𝜴𝜶-𝝎𝝐-𝝮𝝰-𝞈𝞊-𝞨𝞪-𝟂𝟄-𝟋𞠀-𞣄𞸀-𞸃𞸅-𞸟𞸡-𞸢𞸤-𞸤𞸧-𞸧𞸩-𞸲𞸴-𞸷𞸹-𞸹𞸻-𞸻𞹂-𞹂𞹇-𞹇𞹉-𞹉𞹋-𞹋𞹍-𞹏𞹑-𞹒𞹔-𞹔𞹗-𞹗𞹙-𞹙𞹛-𞹛𞹝-𞹝𞹟-𞹟𞹡-𞹢𞹤-𞹤𞹧-𞹪𞹬-𞹲𞹴-𞹷𞹹-𞹼𞹾-𞹾𞺀-𞺉𞺋-𞺛𞺡-𞺣𞺥-𞺩𞺫-𞺻𠀀-𪛖𪜀-𫜴𫝀-𫠝𫠠-𬺡丽-𪘀])+)");

// bullet_core-0.1.1: "^(?u:\\()"
consistent!(bullet_core_4, "^(?u:\\()");

// bullet_core-0.1.1: "^(?u:\\))"
consistent!(bullet_core_5, "^(?u:\\))");

// bullet_core-0.1.1: "^(?u:\\*)"
consistent!(bullet_core_6, "^(?u:\\*)");

// bullet_core-0.1.1: "^(?u:\\+)"
consistent!(bullet_core_7, "^(?u:\\+)");

// bullet_core-0.1.1: "^(?u:,)"
consistent!(bullet_core_8, "^(?u:,)");

// bullet_core-0.1.1: "^(?u:\\-)"
consistent!(bullet_core_9, "^(?u:\\-)");

// bullet_core-0.1.1: "^(?u:/)"
consistent!(bullet_core_10, "^(?u:/)");

// bullet_core-0.1.1: "^(?u:\\[)"
consistent!(bullet_core_11, "^(?u:\\[)");

// bullet_core-0.1.1: "^(?u:\\])"
consistent!(bullet_core_12, "^(?u:\\])");

// bullet_core-0.1.1: "^(?u:\\^)"
consistent!(bullet_core_13, "^(?u:\\^)");

// bullet_core-0.1.1: "^(?u:·)"
consistent!(bullet_core_14, "^(?u:·)");

// actix-web-0.6.13: "//+"
consistent!(actix_web_0, "//+");

// actix-web-0.6.13: "//+"
consistent!(actix_web_1, "//+");

// althea_kernel_interface-0.1.0: r"(\S*) .* (\S*) (REACHABLE|STALE|DELAY)"
consistent!(althea_kernel_interface_0, r"(\S*) .* (\S*) (REACHABLE|STALE|DELAY)");

// althea_kernel_interface-0.1.0: r"-s (.*) --ip6-dst (.*)/.* bcnt = (.*)"
consistent!(althea_kernel_interface_1, r"-s (.*) --ip6-dst (.*)/.* bcnt = (.*)");

// alcibiades-0.3.0: r"\buci(?:\s|$)"
consistent!(alcibiades_0, r"\buci(?:\s|$)");

// ruma-identifiers-0.11.0: r"\A[a-z0-9._=-]+\z"
consistent!(ruma_identifiers_0, r"\A[a-z0-9._=-]+\z");

// rusqbin-0.2.3: r"/rusqbins/((?i)[A-F0-9]{8}\-[A-F0-9]{4}\-4[A-F0-9]{3}\-[89AB][A-F0-9]{3}\-[A-F0-9]{12})$"
consistent!(rusqbin_0, r"/rusqbins/((?i)[A-F0-9]{8}\-[A-F0-9]{4}\-4[A-F0-9]{3}\-[89AB][A-F0-9]{3}\-[A-F0-9]{12})$");

// rusqbin-0.2.3: r"/rusqbins/((?i)[A-F0-9]{8}\-[A-F0-9]{4}\-4[A-F0-9]{3}\-[89AB][A-F0-9]{3}\-[A-F0-9]{12})/requests/?$"
consistent!(rusqbin_1, r"/rusqbins/((?i)[A-F0-9]{8}\-[A-F0-9]{4}\-4[A-F0-9]{3}\-[89AB][A-F0-9]{3}\-[A-F0-9]{12})/requests/?$");

// rust-install-0.0.4: r"^(nightly|beta|stable)(?:-(\d{4}-\d{2}-\d{2}))?$"
consistent!(rust_install_0, r"^(nightly|beta|stable)(?:-(\d{4}-\d{2}-\d{2}))?$");

// rust_inbox-0.0.5: "^+(.*)\r\n"
consistent!(rust_inbox_0, "^+(.*)\r\n");

// rust_inbox-0.0.5: r"^\* CAPABILITY (.*)\r\n"
consistent!(rust_inbox_1, r"^\* CAPABILITY (.*)\r\n");

// rust_inbox-0.0.5: r"^([a-zA-Z0-9]+) (OK|NO|BAD)(.*)"
consistent!(rust_inbox_2, r"^([a-zA-Z0-9]+) (OK|NO|BAD)(.*)");

// rust_inbox-0.0.5: r"^\* (\d+) EXISTS\r\n"
consistent!(rust_inbox_3, r"^\* (\d+) EXISTS\r\n");

// rust_inbox-0.0.5: r"^\* (\d+) RECENT\r\n"
consistent!(rust_inbox_4, r"^\* (\d+) RECENT\r\n");

// rust_inbox-0.0.5: r"^\* FLAGS (.+)\r\n"
consistent!(rust_inbox_5, r"^\* FLAGS (.+)\r\n");

// rust_inbox-0.0.5: r"^\* OK \[UNSEEN (\d+)\](.*)\r\n"
consistent!(rust_inbox_6, r"^\* OK \[UNSEEN (\d+)\](.*)\r\n");

// rust_inbox-0.0.5: r"^\* OK \[UIDVALIDITY (\d+)\](.*)\r\n"
consistent!(rust_inbox_7, r"^\* OK \[UIDVALIDITY (\d+)\](.*)\r\n");

// rust_inbox-0.0.5: r"^\* OK \[UIDNEXT (\d+)\](.*)\r\n"
consistent!(rust_inbox_8, r"^\* OK \[UIDNEXT (\d+)\](.*)\r\n");

// rust_inbox-0.0.5: r"^\* OK \[PERMANENTFLAGS (.+)\](.*)\r\n"
consistent!(rust_inbox_9, r"^\* OK \[PERMANENTFLAGS (.+)\](.*)\r\n");

// rustml-0.0.7: r"^[a-z]+ (\d+)$"
consistent!(rustml_0, r"^[a-z]+ (\d+)$");

// rustml-0.0.7: r"^[a-z]+ (\d+)$"
consistent!(rustml_1, r"^[a-z]+ (\d+)$");

// rustml-0.0.7: r"^[a-z]+ (\d+)$"
consistent!(rustml_2, r"^[a-z]+ (\d+)$");

// rustfmt-0.10.0: r"([^\\](\\\\)*)\\[\n\r][[:space:]]*"
consistent!(rustfmt_0, r"([^\\](\\\\)*)\\[\n\r][[:space:]]*");

// rustfmt-core-0.4.0: r"(^\s*$)|(^\s*//\s*rustfmt-[^:]+:\s*\S+)"
consistent!(rustfmt_core_0, r"(^\s*$)|(^\s*//\s*rustfmt-[^:]+:\s*\S+)");

// rustfmt-core-0.4.0: r"^## `([^`]+)`"
consistent!(rustfmt_core_1, r"^## `([^`]+)`");

// rustfmt-core-0.4.0: r"([^\\](\\\\)*)\\[\n\r][[:space:]]*"
consistent!(rustfmt_core_2, r"([^\\](\\\\)*)\\[\n\r][[:space:]]*");

// rustfmt-core-0.4.0: r"\s;"
consistent!(rustfmt_core_3, r"\s;");

// rust-enum-derive-0.4.0: r"^(0x)?([:digit:]+)$"
consistent!(rust_enum_derive_0, r"^(0x)?([:digit:]+)$");

// rust-enum-derive-0.4.0: r"^([:digit:]+)[:space:]*<<[:space:]*([:digit:]+)$"
consistent!(rust_enum_derive_1, r"^([:digit:]+)[:space:]*<<[:space:]*([:digit:]+)$");

// rust-enum-derive-0.4.0: r"^[:space:]*([[:alnum:]_]+)([:space:]*=[:space:]*([:graph:]+))?[:space:]*,"
consistent!(rust_enum_derive_2, r"^[:space:]*([[:alnum:]_]+)([:space:]*=[:space:]*([:graph:]+))?[:space:]*,");

// rust-enum-derive-0.4.0: r"^#define[:space:]+([:graph:]+)[:space:]+([:graph:]+)"
consistent!(rust_enum_derive_3, r"^#define[:space:]+([:graph:]+)[:space:]+([:graph:]+)");

// rustsourcebundler-0.2.0: r"^\s*pub mod (.+);$"
consistent!(rustsourcebundler_0, r"^\s*pub mod (.+);$");

// rustsourcebundler-0.2.0: r"^\s*pub mod (.+);$"
consistent!(rustsourcebundler_1, r"^\s*pub mod (.+);$");

// rustfmt-nightly-0.8.2: r"([^\\](\\\\)*)\\[\n\r][[:space:]]*"
consistent!(rustfmt_nightly_0, r"([^\\](\\\\)*)\\[\n\r][[:space:]]*");

// rustfmt-nightly-0.8.2: r"\s;"
consistent!(rustfmt_nightly_1, r"\s;");

// rustache-0.1.0: r"(?s)(.*?)([ \t\r\n]*)(\{\{(\{?\S?\s*?[\w\.\s]*.*?\s*?\}?)\}\})([ \t\r\n]*)"
consistent!(rustache_0, r"(?s)(.*?)([ \t\r\n]*)(\{\{(\{?\S?\s*?[\w\.\s]*.*?\s*?\}?)\}\})([ \t\r\n]*)");

// rustfilt-0.2.0: r"_ZN[\$\._[:alnum:]]*"
consistent!(rustfilt_0, r"_ZN[\$\._[:alnum:]]*");

// rustache-lists-0.1.2: r"(?s)(.*?)([ \t\r\n]*)(\{\{(\{?\S?\s*?[\w\.\s]*.*?\s*?\}?)\}\})([ \t\r\n]*)"
consistent!(rustache_lists_0, r"(?s)(.*?)([ \t\r\n]*)(\{\{(\{?\S?\s*?[\w\.\s]*.*?\s*?\}?)\}\})([ \t\r\n]*)");

// rural-0.7.3: "(.+)=(.+)"
consistent!(rural_0, "(.+)=(.+)");

// rural-0.7.3: "(.*):(.+)"
consistent!(rural_1, "(.*):(.+)");

// rural-0.7.3: "(.+):=(.+)"
consistent!(rural_2, "(.+):=(.+)");

// rural-0.7.3: "(.*)==(.+)"
consistent!(rural_3, "(.*)==(.+)");

// rusoto_credential-0.11.0: r"^\[([^\]]+)\]$"
consistent!(rusoto_credential_0, r"^\[([^\]]+)\]$");

// rumblebars-0.3.0: "([:blank:]*)$"
consistent!(rumblebars_0, "([:blank:]*)$");

// rumblebars-0.3.0: "(\r?\n)[:blank:]*(\\{\\{~?[#!/](?:\\}?[^}])*\\}\\})[:blank:]*(:?\r?\n)?\\z"
consistent!(rumblebars_1, "(\r?\n)[:blank:]*(\\{\\{~?[#!/](?:\\}?[^}])*\\}\\})[:blank:]*(:?\r?\n)?\\z");

// rumblebars-0.3.0: "(\r?\n[:blank:]*)(\\{\\{~?>(?:\\}?[^}])*\\}\\})[:blank:]*(:?\r?\n)?\\z"
consistent!(rumblebars_2, "(\r?\n[:blank:]*)(\\{\\{~?>(?:\\}?[^}])*\\}\\})[:blank:]*(:?\r?\n)?\\z");

// rumblebars-0.3.0: "((?:[:blank:]|\r?\n)*)(\r?\n)[:blank:]*$"
consistent!(rumblebars_3, "((?:[:blank:]|\r?\n)*)(\r?\n)[:blank:]*$");

// rumblebars-0.3.0: "^([:blank:]*\r?\n)(.*)"
consistent!(rumblebars_4, "^([:blank:]*\r?\n)(.*)");

// diesel_cli-1.3.1: r"(?P<stamp>[\d-]*)_hello"
consistent!(diesel_cli_0, r"(?P<stamp>[\d-]*)_hello");

// dishub-0.1.1: r"(\d+)s"
consistent!(dishub_0, r"(\d+)s");

// spreadsheet_textconv-0.1.0: r"\n"
consistent!(spreadsheet_textconv_0, r"\n");

// spreadsheet_textconv-0.1.0: r"\r"
consistent!(spreadsheet_textconv_1, r"\r");

// spreadsheet_textconv-0.1.0: r"\t"
consistent!(spreadsheet_textconv_2, r"\t");

// split_aud-0.1.0: r"DELAY (-?\d+)ms"
consistent!(split_aud_0, r"DELAY (-?\d+)ms");

// split_aud-0.1.0: r"Trim\((\d+), ?(\d+)\)"
consistent!(split_aud_1, r"Trim\((\d+), ?(\d+)\)");

// spotrust-0.0.5: r"spotify:[a-z]+:[a-zA-Z0-9]+"
consistent!(spotrust_0, r"spotify:[a-z]+:[a-zA-Z0-9]+");

// spaceslugs-0.1.0: r"[^\x00-\x7F]"
consistent!(spaceslugs_0, r"[^\x00-\x7F]");

// spaceslugs-0.1.0: r"[']+"
consistent!(spaceslugs_1, r"[']+");

// spaceslugs-0.1.0: r"\W+"
consistent!(spaceslugs_2, r"\W+");

// spaceslugs-0.1.0: r"[ ]+"
consistent!(spaceslugs_3, r"[ ]+");

// space_email_api-0.1.1: "PHPSESSID=([0-9a-f]+)"
consistent!(space_email_api_0, "PHPSESSID=([0-9a-f]+)");

// lorikeet-0.7.0: "[^0-9.,]"
consistent!(lorikeet_0, "[^0-9.,]");

// claude-0.3.0: r"^(?:\b|(-)?)(\p{Currency_Symbol})?((?:(?:\d{1,3}[\.,])+\d{3})|\d+)(?:[\.,](\d{2}))?\b$"
consistent!(claude_0, r"^(?:\b|(-)?)(\p{Currency_Symbol})?((?:(?:\d{1,3}[\.,])+\d{3})|\d+)(?:[\.,](\d{2}))?\b$");

// clam-0.1.6: r"<%=\s*(.+?)\s*%>"
consistent!(clam_0, r"<%=\s*(.+?)\s*%>");

// classifier-0.0.3: r"(\s)"
consistent!(classifier_0, r"(\s)");

// click-0.3.2: r"(-----BEGIN .*-----\n)((?:(?:[A-Za-z0-9+/]{4})*(?:[A-Za-z0-9+/]{2}==|[A-Za-z0-9+/]{3}=)*\n)+)(-----END .*-----)"
consistent!(click_0, r"(-----BEGIN .*-----\n)((?:(?:[A-Za-z0-9+/]{4})*(?:[A-Za-z0-9+/]{2}==|[A-Za-z0-9+/]{3}=)*\n)+)(-----END .*-----)");

// click-0.3.2: r"-----BEGIN PRIVATE KEY-----"
consistent!(click_1, r"-----BEGIN PRIVATE KEY-----");

// ultrastar-txt-0.1.2: r"#([A-Z3a-z]*):(.*)"
consistent!(ultrastar_txt_0, r"#([A-Z3a-z]*):(.*)");

// ultrastar-txt-0.1.2: "^-\\s?(-?[0-9]+)\\s*$"
consistent!(ultrastar_txt_1, "^-\\s?(-?[0-9]+)\\s*$");

// ultrastar-txt-0.1.2: "^-\\s?(-?[0-9]+)\\s+(-?[0-9]+)"
consistent!(ultrastar_txt_2, "^-\\s?(-?[0-9]+)\\s+(-?[0-9]+)");

// ultrastar-txt-0.1.2: "^(.)\\s*(-?[0-9]+)\\s+(-?[0-9]+)\\s+(-?[0-9]+)\\s?(.*)"
consistent!(ultrastar_txt_3, "^(.)\\s*(-?[0-9]+)\\s+(-?[0-9]+)\\s+(-?[0-9]+)\\s?(.*)");

// ultrastar-txt-0.1.2: "^P\\s?(-?[0-9]+)"
consistent!(ultrastar_txt_4, "^P\\s?(-?[0-9]+)");

// db-accelerate-2.0.0: r"^template\.add($|\..+$)"
consistent!(db_accelerate_0, r"^template\.add($|\..+$)");

// db-accelerate-2.0.0: r"^template\.sub($|\..+$)"
consistent!(db_accelerate_1, r"^template\.sub($|\..+$)");

// sterling-0.3.0: r"(\d+)([cegps])"
consistent!(sterling_0, r"(\d+)([cegps])");

// stache-0.2.0: r"[^\w]"
consistent!(stache_0, r"[^\w]");

// strukt-0.1.0: "\"([<>]?)([xcbB\\?hHiIlLqQfdspP]*)\""
consistent!(strukt_0, "\"([<>]?)([xcbB\\?hHiIlLqQfdspP]*)\"");

// steamid-ng-0.3.1: r"^STEAM_([0-4]):([0-1]):([0-9]{1,10})$"
consistent!(steamid_ng_0, r"^STEAM_([0-4]):([0-1]):([0-9]{1,10})$");

// steamid-ng-0.3.1: r"^\[([AGMPCgcLTIUai]):([0-4]):([0-9]{1,10})(:([0-9]+))?\]$"
consistent!(steamid_ng_1, r"^\[([AGMPCgcLTIUai]):([0-4]):([0-9]{1,10})(:([0-9]+))?\]$");

// strscan-0.1.1: r"^\w+"
consistent!(strscan_0, r"^\w+");

// strscan-0.1.1: r"^\s+"
consistent!(strscan_1, r"^\s+");

// strscan-0.1.1: r"^\w+"
consistent!(strscan_2, r"^\w+");

// strscan-0.1.1: r"^\s+"
consistent!(strscan_3, r"^\s+");

// strscan-0.1.1: r"^(\w+)\s+"
consistent!(strscan_4, r"^(\w+)\s+");

// tk-carbon-0.2.0: r"^([a-zA-Z0-9\.-]+)(?:\s+(\d+))$"
consistent!(tk_carbon_0, r"^([a-zA-Z0-9\.-]+)(?:\s+(\d+))$");

// tk-carbon-0.2.0: r"^([a-zA-Z0-9\.-]+)(?:\s+(\d+))$"
consistent!(tk_carbon_1, r"^([a-zA-Z0-9\.-]+)(?:\s+(\d+))$");

// evalrs-0.0.10: r"extern\s+crate\s+([a-z0-9_]+)\s*;(\s*//(.+))?"
consistent!(evalrs_0, r"extern\s+crate\s+([a-z0-9_]+)\s*;(\s*//(.+))?");

// evalrs-0.0.10: r"(?m)^# "
consistent!(evalrs_1, r"(?m)^# ");

// evalrs-0.0.10: r"(?m)^\s*fn +main *\( *\)"
consistent!(evalrs_2, r"(?m)^\s*fn +main *\( *\)");

// evalrs-0.0.10: r"(extern\s+crate\s+[a-z0-9_]+\s*;)"
consistent!(evalrs_3, r"(extern\s+crate\s+[a-z0-9_]+\s*;)");

// gate_build-0.5.0: "(.*)_t([0-9]+)"
consistent!(gate_build_0, "(.*)_t([0-9]+)");

// rake-0.1.1: r"[^\P{P}-]|\s+-\s+"
consistent!(rake_0, r"[^\P{P}-]|\s+-\s+");

// rafy-0.2.1: r"^.*(?:(?:youtu\.be/|v/|vi/|u/w/|embed/)|(?:(?:watch)?\?v(?:i)?=|\&v(?:i)?=))([^#\&\?]*).*"
consistent!(rafy_0, r"^.*(?:(?:youtu\.be/|v/|vi/|u/w/|embed/)|(?:(?:watch)?\?v(?:i)?=|\&v(?:i)?=))([^#\&\?]*).*");

// raven-0.2.1: r"^(?P<protocol>.*?)://(?P<public_key>.*?):(?P<secret_key>.*?)@(?P<host>.*?)/(?P<path>.*/)?(?P<project_id>.*)$"
consistent!(raven_0, r"^(?P<protocol>.*?)://(?P<public_key>.*?):(?P<secret_key>.*?)@(?P<host>.*?)/(?P<path>.*/)?(?P<project_id>.*)$");

// rargs-0.2.0: r"\{[[:space:]]*[^{}]*[[:space:]]*\}"
consistent!(rargs_0, r"\{[[:space:]]*[^{}]*[[:space:]]*\}");

// rargs-0.2.0: r"^\{[[:space:]]*(?P<name>[[:word:]]*)[[:space:]]*\}$"
consistent!(rargs_1, r"^\{[[:space:]]*(?P<name>[[:word:]]*)[[:space:]]*\}$");

// rargs-0.2.0: r"^\{[[:space:]]*(?P<num>-?\d+)[[:space:]]*\}$"
consistent!(rargs_2, r"^\{[[:space:]]*(?P<num>-?\d+)[[:space:]]*\}$");

// rargs-0.2.0: r"^\{(?P<left>-?\d*)?\.\.(?P<right>-?\d*)?(?::(?P<sep>.*))?\}$"
consistent!(rargs_3, r"^\{(?P<left>-?\d*)?\.\.(?P<right>-?\d*)?(?::(?P<sep>.*))?\}$");

// rargs-0.2.0: r"(.*?)[[:space:]]+|(.*?)$"
consistent!(rargs_4, r"(.*?)[[:space:]]+|(.*?)$");

// indradb-lib-0.15.0: r"[a-zA-Z0-9]{8}"
consistent!(indradb_lib_0, r"[a-zA-Z0-9]{8}");

// fungi-lang-0.1.50: r"::"
consistent!(fungi_lang_0, r"::");

// nickel-0.10.1: "/hello/(?P<name>[a-zA-Z]+)"
consistent!(nickel_0, "/hello/(?P<name>[a-zA-Z]+)");

// nickel-0.10.1: "/hello/(?P<name>[a-zA-Z]+)"
consistent!(nickel_1, "/hello/(?P<name>[a-zA-Z]+)");

// pact_verifier-0.4.0: r"\{(\w+)\}"
consistent!(pact_verifier_0, r"\{(\w+)\}");

// pact_matching-0.4.1: "application/.*json"
consistent!(pact_matching_0, "application/.*json");

// pact_matching-0.4.1: "application/json.*"
consistent!(pact_matching_1, "application/json.*");

// pact_matching-0.4.1: "application/.*xml"
consistent!(pact_matching_2, "application/.*xml");

// pangu-0.2.0: "([\"'\\(\\[\\{{<\u{201c}])(\\s*)(.+?)(\\s*)([\"'\\)\\]\\}}>\u{201d}])"
consistent!(pangu_0, "([\"'\\(\\[\\{{<\u{201c}])(\\s*)(.+?)(\\s*)([\"'\\)\\]\\}}>\u{201d}])");

// pangu-0.2.0: "([\\(\\[\\{{<\u{201c}]+)(\\s*)(.+?)(\\s*)([\\)\\]\\}}>\u{201d}]+)"
consistent!(pangu_1, "([\\(\\[\\{{<\u{201c}]+)(\\s*)(.+?)(\\s*)([\\)\\]\\}}>\u{201d}]+)");

// parser-haskell-0.2.0: r"\{-[\s\S]*?-\}"
consistent!(parser_haskell_0, r"\{-[\s\S]*?-\}");

// parser-haskell-0.2.0: r"(?m);+\s*$"
consistent!(parser_haskell_1, r"(?m);+\s*$");

// parser-haskell-0.2.0: r"(?m)^#(if|ifn?def|endif|else|include|elif).*"
consistent!(parser_haskell_2, r"(?m)^#(if|ifn?def|endif|else|include|elif).*");

// parser-haskell-0.2.0: r"'([^'\\]|\\[A-Z]{1,3}|\\.)'"
consistent!(parser_haskell_3, r"'([^'\\]|\\[A-Z]{1,3}|\\.)'");

// parser-haskell-0.2.0: r"forall\s+(.*?)\."
consistent!(parser_haskell_4, r"forall\s+(.*?)\.");

// html2md-0.2.1: "\\s{2,}"
consistent!(html2md_0, "\\s{2,}");

// html2md-0.2.1: "\\n{2,}"
consistent!(html2md_1, "\\n{2,}");

// html2md-0.2.1: "(?m)(\\S) $"
consistent!(html2md_2, "(?m)(\\S) $");

// html2md-0.2.1: "(?m)^[-*] "
consistent!(html2md_3, "(?m)^[-*] ");

// ovpnfile-0.1.2: r"#.*$"
consistent!(ovpnfile_0, r"#.*$");

// ovpnfile-0.1.2: r"^<(\S+)>"
consistent!(ovpnfile_1, r"^<(\S+)>");

// ovpnfile-0.1.2: r"^</(\S+)>"
consistent!(ovpnfile_2, r"^</(\S+)>");

// screenruster-saver-fractal-0.1.1: r"#([:xdigit:]{2})([:xdigit:]{2})([:xdigit:]{2})"
consistent!(screenruster_saver_fractal_0, r"#([:xdigit:]{2})([:xdigit:]{2})([:xdigit:]{2})");

// scarlet-0.2.2: r"rgb\((?: *(\d{1,3}),)(?: *(\d{1,3}),)(?: *(\d{1,3}))\)"
consistent!(scarlet_0, r"rgb\((?: *(\d{1,3}),)(?: *(\d{1,3}),)(?: *(\d{1,3}))\)");

// cpp_to_rust_generator-0.2.0: r"^([\w:]+)<(.+)>$"
consistent!(cpp_to_rust_generator_0, r"^([\w:]+)<(.+)>$");

// cpp_to_rust_generator-0.2.0: r"^type-parameter-(\d+)-(\d+)$"
consistent!(cpp_to_rust_generator_1, r"^type-parameter-(\d+)-(\d+)$");

// cpp_to_rust_generator-0.2.0: r"^([\w~]+)<[^<>]+>$"
consistent!(cpp_to_rust_generator_2, r"^([\w~]+)<[^<>]+>$");

// cpp_to_rust_generator-0.2.0: r"(signals|Q_SIGNALS)\s*:"
consistent!(cpp_to_rust_generator_3, r"(signals|Q_SIGNALS)\s*:");

// cpp_to_rust_generator-0.2.0: r"(slots|Q_SLOTS)\s*:"
consistent!(cpp_to_rust_generator_4, r"(slots|Q_SLOTS)\s*:");

// cpp_to_rust_generator-0.2.0: r"(public|protected|private)\s*:"
consistent!(cpp_to_rust_generator_5, r"(public|protected|private)\s*:");

// cpp_to_rust-0.5.3: r"^([\w:]+)<(.+)>$"
consistent!(cpp_to_rust_0, r"^([\w:]+)<(.+)>$");

// cpp_to_rust-0.5.3: r"^type-parameter-(\d+)-(\d+)$"
consistent!(cpp_to_rust_1, r"^type-parameter-(\d+)-(\d+)$");

// cpp_to_rust-0.5.3: r"^([\w~]+)<[^<>]+>$"
consistent!(cpp_to_rust_2, r"^([\w~]+)<[^<>]+>$");

// cpp_to_rust-0.5.3: r"(signals|Q_SIGNALS)\s*:"
consistent!(cpp_to_rust_3, r"(signals|Q_SIGNALS)\s*:");

// cpp_to_rust-0.5.3: r"(slots|Q_SLOTS)\s*:"
consistent!(cpp_to_rust_4, r"(slots|Q_SLOTS)\s*:");

// cpp_to_rust-0.5.3: r"(public|protected|private)\s*:"
consistent!(cpp_to_rust_5, r"(public|protected|private)\s*:");

// fritzbox_logs-0.2.0: "(\\d{2}\\.\\d{2}\\.\\d{2}) (\\d{2}:\\d{2}:\\d{2}) (.*)"
consistent!(fritzbox_logs_0, "(\\d{2}\\.\\d{2}\\.\\d{2}) (\\d{2}:\\d{2}:\\d{2}) (.*)");

// fractal-matrix-api-3.29.0: r"mxc://(?P<server>[^/]+)/(?P<media>.+)"
consistent!(fractal_matrix_api_0, r"mxc://(?P<server>[^/]+)/(?P<media>.+)");

// smtp2go-0.1.4: r"^api-[a-zA-Z0-9]{32}$"
consistent!(smtp2go_0, r"^api-[a-zA-Z0-9]{32}$");

// pusher-0.3.1: r"^[-a-zA-Z0-9_=@,.;]+$"
consistent!(pusher_0, r"^[-a-zA-Z0-9_=@,.;]+$");

// pusher-0.3.1: r"\A\d+\.\d+\z"
consistent!(pusher_1, r"\A\d+\.\d+\z");

// bakervm-0.9.0: r"^\.(.+?) +?(.+)$"
consistent!(bakervm_0, r"^\.(.+?) +?(.+)$");

// bakervm-0.9.0: r"^\.([^\s]+)$"
consistent!(bakervm_1, r"^\.([^\s]+)$");

// bakervm-0.9.0: r"^include! +([^\s]+)$"
consistent!(bakervm_2, r"^include! +([^\s]+)$");

// bakervm-0.9.0: r"^@(\d+)$"
consistent!(bakervm_3, r"^@(\d+)$");

// bakervm-0.9.0: r"^true|false$"
consistent!(bakervm_4, r"^true|false$");

// bakervm-0.9.0: r"^(-?\d+)?\.[0-9]+$"
consistent!(bakervm_5, r"^(-?\d+)?\.[0-9]+$");

// bakervm-0.9.0: r"^(-?\d+)?$"
consistent!(bakervm_6, r"^(-?\d+)?$");

// bakervm-0.9.0: r"^#([0-9abcdefABCDEF]{6})$"
consistent!(bakervm_7, r"^#([0-9abcdefABCDEF]{6})$");

// bakervm-0.9.0: r"^'(.)'$"
consistent!(bakervm_8, r"^'(.)'$");

// bakervm-0.9.0: r"^\$vi\((\d+)\)$"
consistent!(bakervm_9, r"^\$vi\((\d+)\)$");

// bakervm-0.9.0: r"^\$key\((\d+)\)$"
consistent!(bakervm_10, r"^\$key\((\d+)\)$");

// banana-0.0.2: "(?P<type>[A-Z^']+) (?P<route>[^']+) HTTP/(?P<http>[^']+)"
consistent!(banana_0, "(?P<type>[A-Z^']+) (?P<route>[^']+) HTTP/(?P<http>[^']+)");

// serial-key-2.0.0: r"[A-F0-9]{8}"
consistent!(serial_key_0, r"[A-F0-9]{8}");

// serde-hjson-0.8.1: "[\\\\\"\x00-\x1f\x7f-\u{9f}\u{00ad}\u{0600}-\u{0604}\u{070f}\u{17b4}\u{17b5}\u{200c}-\u{200f}\u{2028}-\u{202f}\u{2060}-\u{206f}\u{feff}\u{fff0}-\u{ffff}]"
consistent!(serde_hjson_0, "[\\\\\"\x00-\x1f\x7f-\u{9f}\u{00ad}\u{0600}-\u{0604}\u{070f}\u{17b4}\u{17b5}\u{200c}-\u{200f}\u{2028}-\u{202f}\u{2060}-\u{206f}\u{feff}\u{fff0}-\u{ffff}]");

// serde-hjson-0.8.1: "[\x00-\x1f\x7f-\u{9f}\u{00ad}\u{0600}-\u{0604}\u{070f}\u{17b4}\u{17b5}\u{200c}-\u{200f}\u{2028}-\u{202f}\u{2060}-\u{206f}\u{feff}\u{fff0}-\u{ffff}]"
consistent!(serde_hjson_1, "[\x00-\x1f\x7f-\u{9f}\u{00ad}\u{0600}-\u{0604}\u{070f}\u{17b4}\u{17b5}\u{200c}-\u{200f}\u{2028}-\u{202f}\u{2060}-\u{206f}\u{feff}\u{fff0}-\u{ffff}]");

// serde-hjson-0.8.1: "'''|[\x00-\x09\x0b\x0c\x0e-\x1f\x7f-\u{9f}\u{00ad}\u{0600}-\u{0604}\u{070f}\u{17b4}\u{17b5}\u{200c}-\u{200f}\u{2028}-\u{202f}\u{2060}-\u{206f}\u{feff}\u{fff0}-\u{ffff}]"
consistent!(serde_hjson_2, "'''|[\x00-\x09\x0b\x0c\x0e-\x1f\x7f-\u{9f}\u{00ad}\u{0600}-\u{0604}\u{070f}\u{17b4}\u{17b5}\u{200c}-\u{200f}\u{2028}-\u{202f}\u{2060}-\u{206f}\u{feff}\u{fff0}-\u{ffff}]");

// serde-odbc-0.1.0: r"/todos/(?P<id>\d+)"
consistent!(serde_odbc_0, r"/todos/(?P<id>\d+)");

// sentry-0.6.0: r"^(?:_<)?([a-zA-Z0-9_]+?)(?:\.\.|::)"
consistent!(sentry_0, r"^(?:_<)?([a-zA-Z0-9_]+?)(?:\.\.|::)");

// sentiment-0.1.1: r"[^a-zA-Z0 -]+"
consistent!(sentiment_0, r"[^a-zA-Z0 -]+");

// sentiment-0.1.1: r" {2,}"
consistent!(sentiment_1, r" {2,}");

// verilog-0.0.1: r"(?m)//.*"
consistent!(verilog_0, r"(?m)//.*");

// verex-0.2.2: "(?P<robot>C3PO)"
consistent!(verex_0, "(?P<robot>C3PO)");

// handlebars-0.32.4: ">|<|\"|&"
consistent!(handlebars_0, ">|<|\"|&");

// haikunator-0.1.2: r"^\w+-\w+-[0123456789]{4}$"
consistent!(haikunator_0, r"^\w+-\w+-[0123456789]{4}$");

// haikunator-0.1.2: r"^\w+@\w+@[0123456789]{4}$"
consistent!(haikunator_1, r"^\w+@\w+@[0123456789]{4}$");

// haikunator-0.1.2: r"^\w+-\w+-[0123456789abcdef]{4}$"
consistent!(haikunator_2, r"^\w+-\w+-[0123456789abcdef]{4}$");

// haikunator-0.1.2: r"^\w+-\w+-[0123456789忠犬ハチ公]{10}$"
consistent!(haikunator_3, r"^\w+-\w+-[0123456789忠犬ハチ公]{10}$");

// haikunator-0.1.2: r"^\w+-\w+$"
consistent!(haikunator_4, r"^\w+-\w+$");

// haikunator-0.1.2: r"^\w+-\w+-[foo]{4}$"
consistent!(haikunator_5, r"^\w+-\w+-[foo]{4}$");

// haikunator-0.1.2: r"^\w+-\w+-[0123456789忠犬ハチ公]{5}$"
consistent!(haikunator_6, r"^\w+-\w+-[0123456789忠犬ハチ公]{5}$");

// bobbin-cli-0.8.3: r"(.*)"
consistent!(bobbin_cli_0, r"(.*)");

// bobbin-cli-0.8.3: r"rustc (.*)"
consistent!(bobbin_cli_1, r"rustc (.*)");

// bobbin-cli-0.8.3: r"cargo (.*)"
consistent!(bobbin_cli_2, r"cargo (.*)");

// bobbin-cli-0.8.3: r"xargo (.*)\n"
consistent!(bobbin_cli_3, r"xargo (.*)\n");

// bobbin-cli-0.8.3: r"Open On-Chip Debugger (.*)"
consistent!(bobbin_cli_4, r"Open On-Chip Debugger (.*)");

// bobbin-cli-0.8.3: r"arm-none-eabi-gcc \(GNU Tools for ARM Embedded Processors[^\)]*\) (.*)"
consistent!(bobbin_cli_5, r"arm-none-eabi-gcc \(GNU Tools for ARM Embedded Processors[^\)]*\) (.*)");

// bobbin-cli-0.8.3: r"(?m).*\nBasic Open Source SAM-BA Application \(BOSSA\) Version (.*)\n"
consistent!(bobbin_cli_6, r"(?m).*\nBasic Open Source SAM-BA Application \(BOSSA\) Version (.*)\n");

// bobbin-cli-0.8.3: r"(?m)SEGGER J-Link Commander (.*)\n"
consistent!(bobbin_cli_7, r"(?m)SEGGER J-Link Commander (.*)\n");

// bobbin-cli-0.8.3: r"(?m)Teensy Loader, Command Line, Version (.*)\n"
consistent!(bobbin_cli_8, r"(?m)Teensy Loader, Command Line, Version (.*)\n");

// bobbin-cli-0.8.3: r"dfu-util (.*)\n"
consistent!(bobbin_cli_9, r"dfu-util (.*)\n");

// borsholder-0.9.1: r"^/static/[\w.]+$"
consistent!(borsholder_0, r"^/static/[\w.]+$");

// borsholder-0.9.1: r"^/timeline/([0-9]+)$"
consistent!(borsholder_1, r"^/timeline/([0-9]+)$");

// fblog-1.0.1: "\u{001B}\\[[\\d;]*[^\\d;]"
consistent!(fblog_0, "\u{001B}\\[[\\d;]*[^\\d;]");

// fblog-1.0.1: "\u{001B}\\[[\\d;]*[^\\d;]"
consistent!(fblog_1, "\u{001B}\\[[\\d;]*[^\\d;]");

// toml-query-0.6.0: r"^\[\d+\]$"
consistent!(toml_query_0, r"^\[\d+\]$");

// todo-txt-1.1.0: r" (?P<key>[^\s]+):(?P<value>[^\s^/]+)"
consistent!(todo_txt_0, r" (?P<key>[^\s]+):(?P<value>[^\s^/]+)");

// findr-0.1.5: r"\band\b"
consistent!(findr_0, r"\band\b");

// findr-0.1.5: r"\bor\b"
consistent!(findr_1, r"\bor\b");

// findr-0.1.5: r"\bnot\b"
consistent!(findr_2, r"\bnot\b");

// file-sniffer-3.0.1: r".*?\.(a|la|lo|o|ll|keter|bc|dyn_o|out|d|rlib|crate|min\.js|hi|dyn_hi|S|jsexe|webapp|js\.externs|ibc|toc|aux|fdb_latexmk|fls|egg-info|whl|js_a|js_hi|jld|ji|js_o|so.*|dump-.*|vmb|crx|orig|elmo|elmi|pyc|mod|p_hi|p_o|prof|tix)$"
consistent!(file_sniffer_0, r".*?\.(a|la|lo|o|ll|keter|bc|dyn_o|out|d|rlib|crate|min\.js|hi|dyn_hi|S|jsexe|webapp|js\.externs|ibc|toc|aux|fdb_latexmk|fls|egg-info|whl|js_a|js_hi|jld|ji|js_o|so.*|dump-.*|vmb|crx|orig|elmo|elmi|pyc|mod|p_hi|p_o|prof|tix)$");

// file-sniffer-3.0.1: r".*?\.(stats|conf|h|cache.*|dat|pc|info)$"
consistent!(file_sniffer_1, r".*?\.(stats|conf|h|cache.*|dat|pc|info)$");

// file-sniffer-3.0.1: r".*?\.(exe|a|la|o|ll|keter|bc|dyn_o|out|d|rlib|crate|min\.js|hi|dyn_hi|jsexe|webapp|js\.externs|ibc|toc|aux|fdb_latexmk|fls|egg-info|whl|js_a|js_hi|jld|ji|js_o|so.*|dump-.*|vmb|crx|orig|elmo|elmi|pyc|mod|p_hi|p_o|prof|tix)$"
consistent!(file_sniffer_2, r".*?\.(exe|a|la|o|ll|keter|bc|dyn_o|out|d|rlib|crate|min\.js|hi|dyn_hi|jsexe|webapp|js\.externs|ibc|toc|aux|fdb_latexmk|fls|egg-info|whl|js_a|js_hi|jld|ji|js_o|so.*|dump-.*|vmb|crx|orig|elmo|elmi|pyc|mod|p_hi|p_o|prof|tix)$");

// file-sniffer-3.0.1: r".*?\.(stats|conf|h|cache.*)$"
consistent!(file_sniffer_3, r".*?\.(stats|conf|h|cache.*)$");

// file-sniffer-3.0.1: r"(\.git|\.pijul|_darcs|\.hg)$"
consistent!(file_sniffer_4, r"(\.git|\.pijul|_darcs|\.hg)$");

// file_logger-0.1.0: "test"
consistent!(file_logger_0, "test");

// file_scanner-0.2.0: r"foo"
consistent!(file_scanner_0, r"foo");

// file_scanner-0.2.0: r"a+b"
consistent!(file_scanner_1, r"a+b");

// file_scanner-0.2.0: r"a[ab]*b"
consistent!(file_scanner_2, r"a[ab]*b");

// file_scanner-0.2.0: r"\s+"
consistent!(file_scanner_3, r"\s+");

// file_scanner-0.2.0: r"\s+"
consistent!(file_scanner_4, r"\s+");

// cellsplit-0.2.1: r"^\s*([^\s]+) %cellsplit<\d+>$"
consistent!(cellsplit_0, r"^\s*([^\s]+) %cellsplit<\d+>$");

// cellsplit-0.2.1: r"^\s*([^\s]+) %cellsplit<\d+>$"
consistent!(cellsplit_1, r"^\s*([^\s]+) %cellsplit<\d+>$");

// aterm-0.20.0: r"^[+\-]?[0-9]+"
consistent!(aterm_0, r"^[+\-]?[0-9]+");

// aterm-0.20.0: r"^[+\-]?[0-9]+\.[0-9]*([eE][+\-]?[0-9]+)?"
consistent!(aterm_1, r"^[+\-]?[0-9]+\.[0-9]*([eE][+\-]?[0-9]+)?");

// atarashii_imap-0.3.0: r"^[*] OK"
consistent!(atarashii_imap_0, r"^[*] OK");

// atarashii_imap-0.3.0: r"FLAGS\s\((.+)\)"
consistent!(atarashii_imap_1, r"FLAGS\s\((.+)\)");

// atarashii_imap-0.3.0: r"\[PERMANENTFLAGS\s\((.+)\)\]"
consistent!(atarashii_imap_2, r"\[PERMANENTFLAGS\s\((.+)\)\]");

// atarashii_imap-0.3.0: r"\[UIDVALIDITY\s(\d+)\]"
consistent!(atarashii_imap_3, r"\[UIDVALIDITY\s(\d+)\]");

// atarashii_imap-0.3.0: r"(\d+)\sEXISTS"
consistent!(atarashii_imap_4, r"(\d+)\sEXISTS");

// atarashii_imap-0.3.0: r"(\d+)\sRECENT"
consistent!(atarashii_imap_5, r"(\d+)\sRECENT");

// atarashii_imap-0.3.0: r"\[UNSEEN\s(\d+)\]"
consistent!(atarashii_imap_6, r"\[UNSEEN\s(\d+)\]");

// atarashii_imap-0.3.0: r"\[UIDNEXT\s(\d+)\]"
consistent!(atarashii_imap_7, r"\[UIDNEXT\s(\d+)\]");

// editorconfig-1.0.0: r"\\(\{|\})"
consistent!(editorconfig_0, r"\\(\{|\})");

// editorconfig-1.0.0: r"(^|[^\\])\\\|"
consistent!(editorconfig_1, r"(^|[^\\])\\\|");

// editorconfig-1.0.0: r"\[([^\]]*)$"
consistent!(editorconfig_2, r"\[([^\]]*)$");

// editorconfig-1.0.0: r"\[(.*/.*)\]"
consistent!(editorconfig_3, r"\[(.*/.*)\]");

// editorconfig-1.0.0: r"\{(-?\d+\\\.\\\.-?\d+)\}"
consistent!(editorconfig_4, r"\{(-?\d+\\\.\\\.-?\d+)\}");

// editorconfig-1.0.0: r"\{([^,]+)\}"
consistent!(editorconfig_5, r"\{([^,]+)\}");

// editorconfig-1.0.0: r"\{(([^\}].*)?(,|\|)(.*[^\\])?)\}"
consistent!(editorconfig_6, r"\{(([^\}].*)?(,|\|)(.*[^\\])?)\}");

// editorconfig-1.0.0: r"^/"
consistent!(editorconfig_7, r"^/");

// editorconfig-1.0.0: r"(^|[^\\])(\{|\})"
consistent!(editorconfig_8, r"(^|[^\\])(\{|\})");

// edmunge-1.0.0: "^#!.*\n"
consistent!(edmunge_0, "^#!.*\n");

// unicode_names2_macros-0.2.0: r"\\N\{(.*?)(?:\}|$)"
consistent!(unicode_names2_macros_0, r"\\N\{(.*?)(?:\}|$)");

// unidiff-0.2.1: r"^--- (?P<filename>[^\t\n]+)(?:\t(?P<timestamp>[^\n]+))?"
consistent!(unidiff_0, r"^--- (?P<filename>[^\t\n]+)(?:\t(?P<timestamp>[^\n]+))?");

// unidiff-0.2.1: r"^\+\+\+ (?P<filename>[^\t\n]+)(?:\t(?P<timestamp>[^\n]+))?"
consistent!(unidiff_1, r"^\+\+\+ (?P<filename>[^\t\n]+)(?:\t(?P<timestamp>[^\n]+))?");

// unidiff-0.2.1: r"^@@ -(\d+)(?:,(\d+))? \+(\d+)(?:,(\d+))? @@[ ]?(.*)"
consistent!(unidiff_2, r"^@@ -(\d+)(?:,(\d+))? \+(\d+)(?:,(\d+))? @@[ ]?(.*)");

// unidiff-0.2.1: r"^(?P<line_type>[- \n\+\\]?)(?P<value>.*)"
consistent!(unidiff_3, r"^(?P<line_type>[- \n\+\\]?)(?P<value>.*)");

// slippy-map-tiles-0.13.1: "/?(?P<zoom>[0-9]?[0-9])/(?P<x>[0-9]{1,10})/(?P<y>[0-9]{1,10})(\\.[a-zA-Z]{3,4})?$"
consistent!(slippy_map_tiles_0, "/?(?P<zoom>[0-9]?[0-9])/(?P<x>[0-9]{1,10})/(?P<y>[0-9]{1,10})(\\.[a-zA-Z]{3,4})?$");

// slippy-map-tiles-0.13.1: r"^(?P<minlon>-?[0-9]{1,3}(\.[0-9]{1,10})?) (?P<minlat>-?[0-9]{1,3}(\.[0-9]{1,10})?) (?P<maxlon>-?[0-9]{1,3}(\.[0-9]{1,10})?) (?P<maxlat>-?[0-9]{1,3}(\.[0-9]{1,10})?)$"
consistent!(slippy_map_tiles_1, r"^(?P<minlon>-?[0-9]{1,3}(\.[0-9]{1,10})?) (?P<minlat>-?[0-9]{1,3}(\.[0-9]{1,10})?) (?P<maxlon>-?[0-9]{1,3}(\.[0-9]{1,10})?) (?P<maxlat>-?[0-9]{1,3}(\.[0-9]{1,10})?)$");

// slippy-map-tiles-0.13.1: r"^(?P<minlon>-?[0-9]{1,3}(\.[0-9]{1,10})?),(?P<minlat>-?[0-9]{1,3}(\.[0-9]{1,10})?),(?P<maxlon>-?[0-9]{1,3}(\.[0-9]{1,10})?),(?P<maxlat>-?[0-9]{1,3}(\.[0-9]{1,10})?)$"
consistent!(slippy_map_tiles_2, r"^(?P<minlon>-?[0-9]{1,3}(\.[0-9]{1,10})?),(?P<minlat>-?[0-9]{1,3}(\.[0-9]{1,10})?),(?P<maxlon>-?[0-9]{1,3}(\.[0-9]{1,10})?),(?P<maxlat>-?[0-9]{1,3}(\.[0-9]{1,10})?)$");

// sonos-0.1.2: r"^https?://(.+?):1400/xml"
consistent!(sonos_0, r"^https?://(.+?):1400/xml");

// validator_derive-0.7.0: r"^[a-z]{2}$"
consistent!(validator_derive_0, r"^[a-z]{2}$");

// validator_derive-0.7.0: r"[a-z]{2}"
consistent!(validator_derive_1, r"[a-z]{2}");

// validator_derive-0.7.0: r"[a-z]{2}"
consistent!(validator_derive_2, r"[a-z]{2}");

// nginx-config-0.8.0: r"one of \d+ options"
consistent!(nginx_config_0, r"one of \d+ options");

// waltz-0.4.0: r"[\s,]"
consistent!(waltz_0, r"[\s,]");

// warheadhateus-0.2.1: r"^aws_access_key_id = (.*)"
consistent!(warheadhateus_0, r"^aws_access_key_id = (.*)");

// warheadhateus-0.2.1: r"^aws_secret_access_key = (.*)"
consistent!(warheadhateus_1, r"^aws_secret_access_key = (.*)");

// warheadhateus-0.2.1: r"^aws_access_key_id = (.*)"
consistent!(warheadhateus_2, r"^aws_access_key_id = (.*)");

// warheadhateus-0.2.1: r"^aws_secret_access_key = (.*)"
consistent!(warheadhateus_3, r"^aws_secret_access_key = (.*)");

// jieba-rs-0.2.2: r"([\u{4E00}-\u{9FD5}a-zA-Z0-9+#&\._%]+)"
consistent!(jieba_rs_0, r"([\u{4E00}-\u{9FD5}a-zA-Z0-9+#&\._%]+)");

// jieba-rs-0.2.2: r"(\r\n|\s)"
consistent!(jieba_rs_1, r"(\r\n|\s)");

// jieba-rs-0.2.2: "([\u{4E00}-\u{9FD5}]+)"
consistent!(jieba_rs_2, "([\u{4E00}-\u{9FD5}]+)");

// jieba-rs-0.2.2: r"[^a-zA-Z0-9+#\n]"
consistent!(jieba_rs_3, r"[^a-zA-Z0-9+#\n]");

// jieba-rs-0.2.2: r"([\u{4E00}-\u{9FD5}]+)"
consistent!(jieba_rs_4, r"([\u{4E00}-\u{9FD5}]+)");

// jieba-rs-0.2.2: r"([a-zA-Z0-9]+(?:.\d+)?%?)"
consistent!(jieba_rs_5, r"([a-zA-Z0-9]+(?:.\d+)?%?)");

// lalrpop-0.15.2: r"Span\([0-9 ,]*\)"
consistent!(lalrpop_0, r"Span\([0-9 ,]*\)");

// lalrpop-snap-0.15.2: r"Span\([0-9 ,]*\)"
consistent!(lalrpop_snap_0, r"Span\([0-9 ,]*\)");

// nlp-tokenize-0.1.0: r"[\S]+"
consistent!(nlp_tokenize_0, r"[\S]+");

// kbgpg-0.1.2: "[[:xdigit:]][70]"
consistent!(kbgpg_0, "[[:xdigit:]][70]");

// cdbd-0.1.1: r"^((?P<address>.*):)?(?P<port>\d+)$"
consistent!(cdbd_0, r"^((?P<address>.*):)?(?P<port>\d+)$");

// mbutiles-0.1.1: r"[\w\s=+-/]+\((\{(.|\n)*\})\);?"
consistent!(mbutiles_0, r"[\w\s=+-/]+\((\{(.|\n)*\})\);?");

// extrahop-0.2.5: r"^-\d+(?:ms|s|m|h|d|w|y)?$"
consistent!(extrahop_0, r"^-\d+(?:ms|s|m|h|d|w|y)?$");

// pippin-0.1.0: "^((?:.*)-)?ss(0|[1-9][0-9]*)\\.pip$"
consistent!(pippin_0, "^((?:.*)-)?ss(0|[1-9][0-9]*)\\.pip$");

// pippin-0.1.0: "^((?:.*)-)?ss(0|[1-9][0-9]*)-cl(0|[1-9][0-9]*)\\.piplog$"
consistent!(pippin_1, "^((?:.*)-)?ss(0|[1-9][0-9]*)-cl(0|[1-9][0-9]*)\\.piplog$");

// pippin-0.1.0: "^((?:.*)-)?ss(0|[1-9][0-9]*)\\.pip$"
consistent!(pippin_2, "^((?:.*)-)?ss(0|[1-9][0-9]*)\\.pip$");

// pippin-0.1.0: "^((?:.*)-)?ss(0|[1-9][0-9]*)-cl(0|[1-9][0-9]*)\\.piplog$"
consistent!(pippin_3, "^((?:.*)-)?ss(0|[1-9][0-9]*)-cl(0|[1-9][0-9]*)\\.piplog$");

// pippin-0.1.0: "^.*pn(0|[1-9][0-9]*)(-ss(0|[1-9][0-9]*)(\\.pip|-cl(0|[1-9][0-9]*)\\.piplog))?$"
consistent!(pippin_4, "^.*pn(0|[1-9][0-9]*)(-ss(0|[1-9][0-9]*)(\\.pip|-cl(0|[1-9][0-9]*)\\.piplog))?$");

// pippin-0.1.0: "^(.*)-ss(?:0|[1-9][0-9]*)(?:\\.pip|-cl(?:0|[1-9][0-9]*)\\.piplog)$"
consistent!(pippin_5, "^(.*)-ss(?:0|[1-9][0-9]*)(?:\\.pip|-cl(?:0|[1-9][0-9]*)\\.piplog)$");

// pinyin-0.3.0: r"(?i)[āáǎàēéěèōóǒòīíǐìūúǔùüǘǚǜńň]"
consistent!(pinyin_0, r"(?i)[āáǎàēéěèōóǒòīíǐìūúǔùüǘǚǜńň]");

// pinyin-0.3.0: r"([aeoiuvnm])([0-4])$"
consistent!(pinyin_1, r"([aeoiuvnm])([0-4])$");

// duration-parser-0.2.0: r"(?P<value>\d+)(?P<units>[a-z])"
consistent!(duration_parser_0, r"(?P<value>\d+)(?P<units>[a-z])");

// dutree-0.2.7: r"^\d+\D?$"
consistent!(dutree_0, r"^\d+\D?$");

// djangohashers-0.3.0: r"^[A-Za-z0-9]*$"
consistent!(djangohashers_0, r"^[A-Za-z0-9]*$");

// rtag-0.3.5: r"^[A-Z][A-Z0-9]{2,}$"
consistent!(rtag_0, r"^[A-Z][A-Z0-9]{2,}$");

// rtag-0.3.5: r"^http://www\.emusic\.com"
consistent!(rtag_1, r"^http://www\.emusic\.com");

// rtag-0.3.5: r"^[A-Z][A-Z0-9]{2,}"
consistent!(rtag_2, r"^[A-Z][A-Z0-9]{2,}");

// rtag-0.3.5: r"(^[\x{0}|\x{feff}|\x{fffe}]*|[\x{0}|\x{feff}|\x{fffe}]*$)"
consistent!(rtag_3, r"(^[\x{0}|\x{feff}|\x{fffe}]*|[\x{0}|\x{feff}|\x{fffe}]*$)");

// rtow-0.1.0: r"(\d+)[xX](\d+)"
consistent!(rtow_0, r"(\d+)[xX](\d+)");

// pleingres-sql-plugin-0.1.0: r"\$([a-zA-Z0-9_]+)"
consistent!(pleingres_sql_plugin_0, r"\$([a-zA-Z0-9_]+)");

// dono-2.0.0: "[\\n]+"
consistent!(dono_0, "[\\n]+");

// dono-2.0.0: "(?m)^\\n"
consistent!(dono_1, "(?m)^\\n");

// dono-2.0.0: "(?m)^\\n"
consistent!(dono_2, "(?m)^\\n");

// ssb-common-0.3.0: r"^[0-9A-Za-z\+/]{43}=\.ed25519$"
consistent!(ssb_common_0, r"^[0-9A-Za-z\+/]{43}=\.ed25519$");

// ssb-common-0.3.0: r"^[0-9A-Za-z\+/]{86}==\.ed25519$"
consistent!(ssb_common_1, r"^[0-9A-Za-z\+/]{86}==\.ed25519$");

// ssb-common-0.3.0: r"^[0-9A-Za-z\+/]{43}=\.sha256$"
consistent!(ssb_common_2, r"^[0-9A-Za-z\+/]{43}=\.sha256$");

// mozversion-0.1.3: r"^(?P<major>\d+)\.(?P<minor>\d+)(?:\.(?P<patch>\d+))?(?:(?P<pre0>[a-z]+)(?P<pre1>\d*))?$"
consistent!(mozversion_0, r"^(?P<major>\d+)\.(?P<minor>\d+)(?:\.(?P<patch>\d+))?(?:(?P<pre0>[a-z]+)(?P<pre1>\d*))?$");

// monger-0.5.6: r"^(\d+)\.(\d+)$"
consistent!(monger_0, r"^(\d+)\.(\d+)$");

// mongo_rub-0.0.2: r"^[rv]2\.6"
consistent!(mongo_rub_0, r"^[rv]2\.6");

// flow-0.3.5: "body value"
consistent!(flow_0, "body value");

// flow-0.3.5: "start marker"
consistent!(flow_1, "start marker");

// flow-0.3.5: "end marker"
consistent!(flow_2, "end marker");

// flow-0.3.5: "body value"
consistent!(flow_3, "body value");

// vobsub-0.2.3: "^([A-Za-z/ ]+): (.*)"
consistent!(vobsub_0, "^([A-Za-z/ ]+): (.*)");

// voidmap-1.1.2: r"#([^\s=]+)*"
consistent!(voidmap_0, r"#([^\s=]+)*");

// voidmap-1.1.2: r"#(\S+)*"
consistent!(voidmap_1, r"#(\S+)*");

// voidmap-1.1.2: r"#prio=(\d+)"
consistent!(voidmap_2, r"#prio=(\d+)");

// voidmap-1.1.2: r"\[(\S+)\]"
consistent!(voidmap_3, r"\[(\S+)\]");

// voidmap-1.1.2: r"#limit=(\d+)"
consistent!(voidmap_4, r"#limit=(\d+)");

// voidmap-1.1.2: r"#tagged=(\S+)"
consistent!(voidmap_5, r"#tagged=(\S+)");

// voidmap-1.1.2: r"#rev\b"
consistent!(voidmap_6, r"#rev\b");

// voidmap-1.1.2: r"#done\b"
consistent!(voidmap_7, r"#done\b");

// voidmap-1.1.2: r"#open\b"
consistent!(voidmap_8, r"#open\b");

// voidmap-1.1.2: r"#since=(\S+)"
consistent!(voidmap_9, r"#since=(\S+)");

// voidmap-1.1.2: r"#until=(\S+)"
consistent!(voidmap_10, r"#until=(\S+)");

// voidmap-1.1.2: r"#plot=(\S+)"
consistent!(voidmap_11, r"#plot=(\S+)");

// voidmap-1.1.2: r"#n=(\d+)"
consistent!(voidmap_12, r"#n=(\d+)");

// voidmap-1.1.2: r"(\S+)"
consistent!(voidmap_13, r"(\S+)");

// voidmap-1.1.2: r"(?P<y>\d+)y"
consistent!(voidmap_14, r"(?P<y>\d+)y");

// voidmap-1.1.2: r"(?P<m>\d+)m"
consistent!(voidmap_15, r"(?P<m>\d+)m");

// voidmap-1.1.2: r"(?P<w>\d+)w"
consistent!(voidmap_16, r"(?P<w>\d+)w");

// voidmap-1.1.2: r"(?P<d>\d+)d"
consistent!(voidmap_17, r"(?P<d>\d+)d");

// voidmap-1.1.2: r"(?P<h>\d+)h"
consistent!(voidmap_18, r"(?P<h>\d+)h");

// voidmap-1.1.2: r"C-(.)"
consistent!(voidmap_19, r"C-(.)");

// qt_generator-0.2.0: r"^\.\./qt[^/]+/"
consistent!(qt_generator_0, r"^\.\./qt[^/]+/");

// qt_generator-0.2.0: "(href|src)=\"([^\"]*)\""
consistent!(qt_generator_1, "(href|src)=\"([^\"]*)\"");

// kryptos-0.6.1: r"[01]{5}"
consistent!(kryptos_0, r"[01]{5}");

// cifar_10_loader-0.2.0: "data_batch_[1-5].bin"
consistent!(cifar_10_loader_0, "data_batch_[1-5].bin");

// cifar_10_loader-0.2.0: "test_batch.bin"
consistent!(cifar_10_loader_1, "test_batch.bin");

// circadian-0.6.0: r"^\d+.\d+s$"
consistent!(circadian_0, r"^\d+.\d+s$");

// circadian-0.6.0: r"^\d+:\d+$"
consistent!(circadian_1, r"^\d+:\d+$");

// circadian-0.6.0: r"^\d+:\d+m$"
consistent!(circadian_2, r"^\d+:\d+m$");

// cicada-0.8.1: r"!!"
consistent!(cicada_0, r"!!");

// cicada-0.8.1: r"^([^`]*)`([^`]+)`(.*)$"
consistent!(cicada_1, r"^([^`]*)`([^`]+)`(.*)$");

// cicada-0.8.1: r"\*+"
consistent!(cicada_2, r"\*+");

// cicada-0.8.1: r"([^\$]*)\$\{?([A-Za-z0-9\?\$_]+)\}?(.*)"
consistent!(cicada_3, r"([^\$]*)\$\{?([A-Za-z0-9\?\$_]+)\}?(.*)");

// cicada-0.8.1: r"^ *alias +([a-zA-Z0-9_\.-]+)=(.*)$"
consistent!(cicada_4, r"^ *alias +([a-zA-Z0-9_\.-]+)=(.*)$");

// vterm-sys-0.1.0: r"hi"
consistent!(vterm_sys_0, r"hi");

// skim-0.5.0: r".*?\t"
consistent!(skim_0, r".*?\t");

// skim-0.5.0: r".*?[\t ]"
consistent!(skim_1, r".*?[\t ]");

// skim-0.5.0: r"(\{-?[0-9.,q]*?})"
consistent!(skim_2, r"(\{-?[0-9.,q]*?})");

// skim-0.5.0: r"[ \t\n]+"
consistent!(skim_3, r"[ \t\n]+");

// skim-0.5.0: r"[ \t\n]+"
consistent!(skim_4, r"[ \t\n]+");

// skim-0.5.0: r"([^ |]+( +\| +[^ |]*)+)|( +)"
consistent!(skim_5, r"([^ |]+( +\| +[^ |]*)+)|( +)");

// skim-0.5.0: r" +\| +"
consistent!(skim_6, r" +\| +");

// skim-0.5.0: r"^(?P<left>-?\d+)?(?P<sep>\.\.)?(?P<right>-?\d+)?$"
consistent!(skim_7, r"^(?P<left>-?\d+)?(?P<sep>\.\.)?(?P<right>-?\d+)?$");

// skim-0.5.0: ","
consistent!(skim_8, ",");

// skim-0.5.0: ".*?,"
consistent!(skim_9, ".*?,");

// skim-0.5.0: ".*?,"
consistent!(skim_10, ".*?,");

// skim-0.5.0: ","
consistent!(skim_11, ",");

// skim-0.5.0: r"\x1B\[(?:([0-9]+;[0-9]+[Hf])|([0-9]+[ABCD])|(s|u|2J|K)|([0-9;]*m)|(=[0-9]+[hI]))"
consistent!(skim_12, r"\x1B\[(?:([0-9]+;[0-9]+[Hf])|([0-9]+[ABCD])|(s|u|2J|K)|([0-9;]*m)|(=[0-9]+[hI]))");

// egg-mode-text-1.14.7: r"[-_./]\z"
consistent!(egg_mode_text_0, r"[-_./]\z");

// java-properties-1.1.1: "^[ \t\r\n\x0c]*[#!]"
consistent!(java_properties_0, "^[ \t\r\n\x0c]*[#!]");

// java-properties-1.1.1: r"^[ \t\x0c]*[#!][^\r\n]*$"
consistent!(java_properties_1, r"^[ \t\x0c]*[#!][^\r\n]*$");

// java-properties-1.1.1: r"^([ \t\x0c]*[:=][ \t\x0c]*|[ \t\x0c]+)$"
consistent!(java_properties_2, r"^([ \t\x0c]*[:=][ \t\x0c]*|[ \t\x0c]+)$");

// ipaddress-0.1.2: r":.+\."
consistent!(ipaddress_0, r":.+\.");

// ipaddress-0.1.2: r"\."
consistent!(ipaddress_1, r"\.");

// ipaddress-0.1.2: r":"
consistent!(ipaddress_2, r":");

// iptables-0.2.2: r"v(\d+)\.(\d+)\.(\d+)"
consistent!(iptables_0, r"v(\d+)\.(\d+)\.(\d+)");

// rsure-0.8.1: r"^([^-]+)-(.*)\.dat\.gz$"
consistent!(rsure_0, r"^([^-]+)-(.*)\.dat\.gz$");

// rs-jsonpath-0.1.0: "^(.*?)(<=|<|==|>=|>)(.*?)$"
consistent!(rs_jsonpath_0, "^(.*?)(<=|<|==|>=|>)(.*?)$");

// oatie-0.3.0: r"(\n|^)(\w+):([\n\w\W]+?)(\n(?:\w)|(\n\]))"
consistent!(oatie_0, r"(\n|^)(\w+):([\n\w\W]+?)(\n(?:\w)|(\n\]))");

// weld-0.2.0: "#.*$"
consistent!(weld_0, "#.*$");

// weld-0.2.0: r"^[A-Za-z$_][A-Za-z0-9$_]*$"
consistent!(weld_1, r"^[A-Za-z$_][A-Za-z0-9$_]*$");

// weld-0.2.0: r"^[0-9]+[cC]$"
consistent!(weld_2, r"^[0-9]+[cC]$");

// weld-0.2.0: r"^0b[0-1]+[cC]$"
consistent!(weld_3, r"^0b[0-1]+[cC]$");

// weld-0.2.0: r"^0x[0-9a-fA-F]+[cC]$"
consistent!(weld_4, r"^0x[0-9a-fA-F]+[cC]$");

// weld-0.2.0: r"^[0-9]+$"
consistent!(weld_5, r"^[0-9]+$");

// weld-0.2.0: r"^0b[0-1]+$"
consistent!(weld_6, r"^0b[0-1]+$");

// weld-0.2.0: r"^0x[0-9a-fA-F]+$"
consistent!(weld_7, r"^0x[0-9a-fA-F]+$");

// weld-0.2.0: r"^[0-9]+[lL]$"
consistent!(weld_8, r"^[0-9]+[lL]$");

// weld-0.2.0: r"^0b[0-1]+[lL]$"
consistent!(weld_9, r"^0b[0-1]+[lL]$");

// weld-0.2.0: r"^0x[0-9a-fA-F]+[lL]$"
consistent!(weld_10, r"^0x[0-9a-fA-F]+[lL]$");

// webgl_generator-0.1.0: "([(, ])enum\\b"
consistent!(webgl_generator_0, "([(, ])enum\\b");

// webgl_generator-0.1.0: "\\bAcquireResourcesCallback\\b"
consistent!(webgl_generator_1, "\\bAcquireResourcesCallback\\b");

// weave-0.2.0: r"^(\d+)(,(\d+))?([acd]).*$"
consistent!(weave_0, r"^(\d+)(,(\d+))?([acd]).*$");

// wemo-0.0.12: r"<BinaryState>(\d)(\|-?\d+)*</BinaryState>"
consistent!(wemo_0, r"<BinaryState>(\d)(\|-?\d+)*</BinaryState>");

// webscale-0.9.4: r"(http[s]?://[^\s]+)"
consistent!(webscale_0, r"(http[s]?://[^\s]+)");

// svgrep-1.1.0: r"^\d+.*$"
consistent!(svgrep_0, r"^\d+.*$");

// ignore-0.4.2: r"^[\pL\pN]+$"
consistent!(ignore_0, r"^[\pL\pN]+$");

// ommui_string_patterns-0.1.2: r"^([A-Za-z][0-9A-Za-z_]*)?$"
consistent!(ommui_string_patterns_0, r"^([A-Za-z][0-9A-Za-z_]*)?$");

// ommui_string_patterns-0.1.2: r"^(\S+(?:.*\S)?)?$"
consistent!(ommui_string_patterns_1, r"^(\S+(?:.*\S)?)?$");

// opcua-types-0.3.0: "^(?P<min>[0-9]{1,10})(:(?P<max>[0-9]{1,10}))?$"
consistent!(opcua_types_0, "^(?P<min>[0-9]{1,10})(:(?P<max>[0-9]{1,10}))?$");

// opcua-types-0.3.0: r"^(ns=(?P<ns>[0-9]+);)?(?P<t>[isgb])=(?P<v>.+)$"
consistent!(opcua_types_1, r"^(ns=(?P<ns>[0-9]+);)?(?P<t>[isgb])=(?P<v>.+)$");

// open_read_later-1.1.1: r"^(.+?)\s*:\s*(.+)$"
consistent!(open_read_later_0, r"^(.+?)\s*:\s*(.+)$");

// youtube-downloader-0.1.0: r"^.*(?:(?:youtu\.be/|v/|vi/|u/w/|embed/)|(?:(?:watch)?\?v(?:i)?=|\&v(?:i)?=))([^#\&\?]*).*"
consistent!(youtube_downloader_0, r"^.*(?:(?:youtu\.be/|v/|vi/|u/w/|embed/)|(?:(?:watch)?\?v(?:i)?=|\&v(?:i)?=))([^#\&\?]*).*");

// yobot-0.1.1: "."
consistent!(yobot_0, ".");

// yobot-0.1.1: r"."
consistent!(yobot_1, r".");

// yobot-0.1.1: r".+"
consistent!(yobot_2, r".+");

// yobot-0.1.1: r"."
consistent!(yobot_3, r".");

// ubiquity-0.1.5: r"foo"
consistent!(ubiquity_0, r"foo");

// ubiquity-0.1.5: r"/target/"
consistent!(ubiquity_1, r"/target/");

// ubiquity-0.1.5: r".DS_Store"
consistent!(ubiquity_2, r".DS_Store");

// qasm-1.0.0: r"//.*"
consistent!(qasm_0, r"//.*");

// drill-0.3.5: r"\{\{ *([a-z\._]+) *\}\}"
consistent!(drill_0, r"\{\{ *([a-z\._]+) *\}\}");

// queryst-2.0.0: r"^([^\]\[]+)"
consistent!(queryst_0, r"^([^\]\[]+)");

// queryst-2.0.0: r"(\[[^\]\[]*\])"
consistent!(queryst_1, r"(\[[^\]\[]*\])");

// qui-vive-0.1.0: r"^/(\w+)$"
consistent!(qui_vive_0, r"^/(\w+)$");

// qui-vive-0.1.0: r"^/key$"
consistent!(qui_vive_1, r"^/key$");

// qui-vive-0.1.0: r"^/key/(\w+)$"
consistent!(qui_vive_2, r"^/key/(\w+)$");

// qui-vive-0.1.0: r"^/url$"
consistent!(qui_vive_3, r"^/url$");

// qui-vive-0.1.0: r"^/url/(\w+)$"
consistent!(qui_vive_4, r"^/url/(\w+)$");

// qui-vive-0.1.0: r"^/inv$"
consistent!(qui_vive_5, r"^/inv$");

// qui-vive-0.1.0: r"^/inv/(\w+)$"
consistent!(qui_vive_6, r"^/inv/(\w+)$");

// subdiff-0.1.0: r"\b"
// consistent!(subdiff_0, r"\b");

// substudy-0.4.5: r"^(\d+)/(\d+)$"
consistent!(substudy_0, r"^(\d+)/(\d+)$");

// substudy-0.4.5: r"\s+"
consistent!(substudy_1, r"\s+");

// substudy-0.4.5: r"<[a-z/][^>]*>"
consistent!(substudy_2, r"<[a-z/][^>]*>");

// substudy-0.4.5: r"(\([^)]*\)|♪[^♪]*♪|[A-Z]{2,} ?:)"
consistent!(substudy_3, r"(\([^)]*\)|♪[^♪]*♪|[A-Z]{2,} ?:)");

// substudy-0.4.5: r"\s+"
consistent!(substudy_4, r"\s+");

// isbnid-0.1.3: r"^(\d(-| )?){9}(x|X|\d|(\d(-| )?){3}\d)$"
consistent!(isbnid_0, r"^(\d(-| )?){9}(x|X|\d|(\d(-| )?){3}\d)$");

// isbnid-0.1.3: r"[^0-9X]"
consistent!(isbnid_1, r"[^0-9X]");

// ispc-0.3.5: r"Intel\(r\) SPMD Program Compiler \(ispc\), (\d+\.\d+\.\d+)"
consistent!(ispc_0, r"Intel\(r\) SPMD Program Compiler \(ispc\), (\d+\.\d+\.\d+)");

