/*
 * Copyright (c) 2023, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/**
 * Mechanically generated JDK 8 specific serialization bytes for XMLGregorianCalendar and Duration data type.
 * Do not edit this file.
 */
public class JDK8GregorianCalendarAndDurationSerData extends GregorianCalendarAndDurationSerData {
    private final byte[] gregorianCalendarBytes = {
            (byte) 0xac, (byte) 0xed, (byte) 0x0, (byte) 0x5, (byte) 0x73, (byte) 0x72, (byte) 0x0, (byte) 0x49,
            (byte) 0x63, (byte) 0x6f, (byte) 0x6d, (byte) 0x2e, (byte) 0x73, (byte) 0x75, (byte) 0x6e, (byte) 0x2e,
            (byte) 0x6f, (byte) 0x72, (byte) 0x67, (byte) 0x2e, (byte) 0x61, (byte) 0x70, (byte) 0x61, (byte) 0x63,
            (byte) 0x68, (byte) 0x65, (byte) 0x2e, (byte) 0x78, (byte) 0x65, (byte) 0x72, (byte) 0x63, (byte) 0x65,
            (byte) 0x73, (byte) 0x2e, (byte) 0x69, (byte) 0x6e, (byte) 0x74, (byte) 0x65, (byte) 0x72, (byte) 0x6e,
            (byte) 0x61, (byte) 0x6c, (byte) 0x2e, (byte) 0x6a, (byte) 0x61, (byte) 0x78, (byte) 0x70, (byte) 0x2e,
            (byte) 0x64, (byte) 0x61, (byte) 0x74, (byte) 0x61, (byte) 0x74, (byte) 0x79, (byte) 0x70, (byte) 0x65,
            (byte) 0x2e, (byte) 0x58, (byte) 0x4d, (byte) 0x4c, (byte) 0x47, (byte) 0x72, (byte) 0x65, (byte) 0x67,
            (byte) 0x6f, (byte) 0x72, (byte) 0x69, (byte) 0x61, (byte) 0x6e, (byte) 0x43, (byte) 0x61, (byte) 0x6c,
            (byte) 0x65, (byte) 0x6e, (byte) 0x64, (byte) 0x61, (byte) 0x72, (byte) 0x49, (byte) 0x6d, (byte) 0x70,
            (byte) 0x6c, (byte) 0x0, (byte) 0x0, (byte) 0x0, (byte) 0x0, (byte) 0x0, (byte) 0x0, (byte) 0x0,
            (byte) 0x1, (byte) 0x2, (byte) 0x0, (byte) 0x9, (byte) 0x49, (byte) 0x0, (byte) 0x3, (byte) 0x64,
            (byte) 0x61, (byte) 0x79, (byte) 0x49, (byte) 0x0, (byte) 0x4, (byte) 0x68, (byte) 0x6f, (byte) 0x75,
            (byte) 0x72, (byte) 0x49, (byte) 0x0, (byte) 0x6, (byte) 0x6d, (byte) 0x69, (byte) 0x6e, (byte) 0x75,
            (byte) 0x74, (byte) 0x65, (byte) 0x49, (byte) 0x0, (byte) 0x5, (byte) 0x6d, (byte) 0x6f, (byte) 0x6e,
            (byte) 0x74, (byte) 0x68, (byte) 0x49, (byte) 0x0, (byte) 0x6, (byte) 0x73, (byte) 0x65, (byte) 0x63,
            (byte) 0x6f, (byte) 0x6e, (byte) 0x64, (byte) 0x49, (byte) 0x0, (byte) 0x8, (byte) 0x74, (byte) 0x69,
            (byte) 0x6d, (byte) 0x65, (byte) 0x7a, (byte) 0x6f, (byte) 0x6e, (byte) 0x65, (byte) 0x49, (byte) 0x0,
            (byte) 0x4, (byte) 0x79, (byte) 0x65, (byte) 0x61, (byte) 0x72, (byte) 0x4c, (byte) 0x0, (byte) 0x3,
            (byte) 0x65, (byte) 0x6f, (byte) 0x6e, (byte) 0x74, (byte) 0x0, (byte) 0x16, (byte) 0x4c, (byte) 0x6a,
            (byte) 0x61, (byte) 0x76, (byte) 0x61, (byte) 0x2f, (byte) 0x6d, (byte) 0x61, (byte) 0x74, (byte) 0x68,
            (byte) 0x2f, (byte) 0x42, (byte) 0x69, (byte) 0x67, (byte) 0x49, (byte) 0x6e, (byte) 0x74, (byte) 0x65,
            (byte) 0x67, (byte) 0x65, (byte) 0x72, (byte) 0x3b, (byte) 0x4c, (byte) 0x0, (byte) 0x10, (byte) 0x66,
            (byte) 0x72, (byte) 0x61, (byte) 0x63, (byte) 0x74, (byte) 0x69, (byte) 0x6f, (byte) 0x6e, (byte) 0x61,
            (byte) 0x6c, (byte) 0x53, (byte) 0x65, (byte) 0x63, (byte) 0x6f, (byte) 0x6e, (byte) 0x64, (byte) 0x74,
            (byte) 0x0, (byte) 0x16, (byte) 0x4c, (byte) 0x6a, (byte) 0x61, (byte) 0x76, (byte) 0x61, (byte) 0x2f,
            (byte) 0x6d, (byte) 0x61, (byte) 0x74, (byte) 0x68, (byte) 0x2f, (byte) 0x42, (byte) 0x69, (byte) 0x67,
            (byte) 0x44, (byte) 0x65, (byte) 0x63, (byte) 0x69, (byte) 0x6d, (byte) 0x61, (byte) 0x6c, (byte) 0x3b,
            (byte) 0x78, (byte) 0x70, (byte) 0x0, (byte) 0x0, (byte) 0x0, (byte) 0x1, (byte) 0x0, (byte) 0x0,
            (byte) 0x0, (byte) 0x0, (byte) 0x0, (byte) 0x0, (byte) 0x0, (byte) 0x0, (byte) 0x0, (byte) 0x0,
            (byte) 0x0, (byte) 0x1, (byte) 0x0, (byte) 0x0, (byte) 0x0, (byte) 0x0, (byte) 0xff, (byte) 0xff,
            (byte) 0xfe, (byte) 0xd4, (byte) 0x0, (byte) 0x0, (byte) 0x0, (byte) 0x1, (byte) 0x70, (byte) 0x73,
            (byte) 0x72, (byte) 0x0, (byte) 0x14, (byte) 0x6a, (byte) 0x61, (byte) 0x76, (byte) 0x61, (byte) 0x2e,
            (byte) 0x6d, (byte) 0x61, (byte) 0x74, (byte) 0x68, (byte) 0x2e, (byte) 0x42, (byte) 0x69, (byte) 0x67,
            (byte) 0x44, (byte) 0x65, (byte) 0x63, (byte) 0x69, (byte) 0x6d, (byte) 0x61, (byte) 0x6c, (byte) 0x54,
            (byte) 0xc7, (byte) 0x15, (byte) 0x57, (byte) 0xf9, (byte) 0x81, (byte) 0x28, (byte) 0x4f, (byte) 0x3,
            (byte) 0x0, (byte) 0x2, (byte) 0x49, (byte) 0x0, (byte) 0x5, (byte) 0x73, (byte) 0x63, (byte) 0x61,
            (byte) 0x6c, (byte) 0x65, (byte) 0x4c, (byte) 0x0, (byte) 0x6, (byte) 0x69, (byte) 0x6e, (byte) 0x74,
            (byte) 0x56, (byte) 0x61, (byte) 0x6c, (byte) 0x71, (byte) 0x0, (byte) 0x7e, (byte) 0x0, (byte) 0x1,
            (byte) 0x78, (byte) 0x72, (byte) 0x0, (byte) 0x10, (byte) 0x6a, (byte) 0x61, (byte) 0x76, (byte) 0x61,
            (byte) 0x2e, (byte) 0x6c, (byte) 0x61, (byte) 0x6e, (byte) 0x67, (byte) 0x2e, (byte) 0x4e, (byte) 0x75,
            (byte) 0x6d, (byte) 0x62, (byte) 0x65, (byte) 0x72, (byte) 0x86, (byte) 0xac, (byte) 0x95, (byte) 0x1d,
            (byte) 0xb, (byte) 0x94, (byte) 0xe0, (byte) 0x8b, (byte) 0x2, (byte) 0x0, (byte) 0x0, (byte) 0x78,
            (byte) 0x70, (byte) 0x0, (byte) 0x0, (byte) 0x0, (byte) 0x7, (byte) 0x73, (byte) 0x72, (byte) 0x0,
            (byte) 0x14, (byte) 0x6a, (byte) 0x61, (byte) 0x76, (byte) 0x61, (byte) 0x2e, (byte) 0x6d, (byte) 0x61,
            (byte) 0x74, (byte) 0x68, (byte) 0x2e, (byte) 0x42, (byte) 0x69, (byte) 0x67, (byte) 0x49, (byte) 0x6e,
            (byte) 0x74, (byte) 0x65, (byte) 0x67, (byte) 0x65, (byte) 0x72, (byte) 0x8c, (byte) 0xfc, (byte) 0x9f,
            (byte) 0x1f, (byte) 0xa9, (byte) 0x3b, (byte) 0xfb, (byte) 0x1d, (byte) 0x3, (byte) 0x0, (byte) 0x6,
            (byte) 0x49, (byte) 0x0, (byte) 0x8, (byte) 0x62, (byte) 0x69, (byte) 0x74, (byte) 0x43, (byte) 0x6f,
            (byte) 0x75, (byte) 0x6e, (byte) 0x74, (byte) 0x49, (byte) 0x0, (byte) 0x9, (byte) 0x62, (byte) 0x69,
            (byte) 0x74, (byte) 0x4c, (byte) 0x65, (byte) 0x6e, (byte) 0x67, (byte) 0x74, (byte) 0x68, (byte) 0x49,
            (byte) 0x0, (byte) 0x13, (byte) 0x66, (byte) 0x69, (byte) 0x72, (byte) 0x73, (byte) 0x74, (byte) 0x4e,
            (byte) 0x6f, (byte) 0x6e, (byte) 0x7a, (byte) 0x65, (byte) 0x72, (byte) 0x6f, (byte) 0x42, (byte) 0x79,
            (byte) 0x74, (byte) 0x65, (byte) 0x4e, (byte) 0x75, (byte) 0x6d, (byte) 0x49, (byte) 0x0, (byte) 0xc,
            (byte) 0x6c, (byte) 0x6f, (byte) 0x77, (byte) 0x65, (byte) 0x73, (byte) 0x74, (byte) 0x53, (byte) 0x65,
            (byte) 0x74, (byte) 0x42, (byte) 0x69, (byte) 0x74, (byte) 0x49, (byte) 0x0, (byte) 0x6, (byte) 0x73,
            (byte) 0x69, (byte) 0x67, (byte) 0x6e, (byte) 0x75, (byte) 0x6d, (byte) 0x5b, (byte) 0x0, (byte) 0x9,
            (byte) 0x6d, (byte) 0x61, (byte) 0x67, (byte) 0x6e, (byte) 0x69, (byte) 0x74, (byte) 0x75, (byte) 0x64,
            (byte) 0x65, (byte) 0x74, (byte) 0x0, (byte) 0x2, (byte) 0x5b, (byte) 0x42, (byte) 0x78, (byte) 0x71,
            (byte) 0x0, (byte) 0x7e, (byte) 0x0, (byte) 0x5, (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff,
            (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xfe,
            (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xfe, (byte) 0x0, (byte) 0x0, (byte) 0x0, (byte) 0x0,
            (byte) 0x75, (byte) 0x72, (byte) 0x0, (byte) 0x2, (byte) 0x5b, (byte) 0x42, (byte) 0xac, (byte) 0xf3,
            (byte) 0x17, (byte) 0xf8, (byte) 0x6, (byte) 0x8, (byte) 0x54, (byte) 0xe0, (byte) 0x2, (byte) 0x0,
            (byte) 0x0, (byte) 0x78, (byte) 0x70, (byte) 0x0, (byte) 0x0, (byte) 0x0, (byte) 0x0, (byte) 0x78,
            (byte) 0x78,
    };
    private final byte[] durationBytes = {
            (byte) 0xac, (byte) 0xed, (byte) 0x0, (byte) 0x5, (byte) 0x73, (byte) 0x72, (byte) 0x0, (byte) 0x4c,
            (byte) 0x63, (byte) 0x6f, (byte) 0x6d, (byte) 0x2e, (byte) 0x73, (byte) 0x75, (byte) 0x6e, (byte) 0x2e,
            (byte) 0x6f, (byte) 0x72, (byte) 0x67, (byte) 0x2e, (byte) 0x61, (byte) 0x70, (byte) 0x61, (byte) 0x63,
            (byte) 0x68, (byte) 0x65, (byte) 0x2e, (byte) 0x78, (byte) 0x65, (byte) 0x72, (byte) 0x63, (byte) 0x65,
            (byte) 0x73, (byte) 0x2e, (byte) 0x69, (byte) 0x6e, (byte) 0x74, (byte) 0x65, (byte) 0x72, (byte) 0x6e,
            (byte) 0x61, (byte) 0x6c, (byte) 0x2e, (byte) 0x6a, (byte) 0x61, (byte) 0x78, (byte) 0x70, (byte) 0x2e,
            (byte) 0x64, (byte) 0x61, (byte) 0x74, (byte) 0x61, (byte) 0x74, (byte) 0x79, (byte) 0x70, (byte) 0x65,
            (byte) 0x2e, (byte) 0x44, (byte) 0x75, (byte) 0x72, (byte) 0x61, (byte) 0x74, (byte) 0x69, (byte) 0x6f,
            (byte) 0x6e, (byte) 0x49, (byte) 0x6d, (byte) 0x70, (byte) 0x6c, (byte) 0x24, (byte) 0x44, (byte) 0x75,
            (byte) 0x72, (byte) 0x61, (byte) 0x74, (byte) 0x69, (byte) 0x6f, (byte) 0x6e, (byte) 0x53, (byte) 0x74,
            (byte) 0x72, (byte) 0x65, (byte) 0x61, (byte) 0x6d, (byte) 0x0, (byte) 0x0, (byte) 0x0, (byte) 0x0,
            (byte) 0x0, (byte) 0x0, (byte) 0x0, (byte) 0x1, (byte) 0x2, (byte) 0x0, (byte) 0x1, (byte) 0x4c,
            (byte) 0x0, (byte) 0x7, (byte) 0x6c, (byte) 0x65, (byte) 0x78, (byte) 0x69, (byte) 0x63, (byte) 0x61,
            (byte) 0x6c, (byte) 0x74, (byte) 0x0, (byte) 0x12, (byte) 0x4c, (byte) 0x6a, (byte) 0x61, (byte) 0x76,
            (byte) 0x61, (byte) 0x2f, (byte) 0x6c, (byte) 0x61, (byte) 0x6e, (byte) 0x67, (byte) 0x2f, (byte) 0x53,
            (byte) 0x74, (byte) 0x72, (byte) 0x69, (byte) 0x6e, (byte) 0x67, (byte) 0x3b, (byte) 0x78, (byte) 0x70,
            (byte) 0x74, (byte) 0x0, (byte) 0xe, (byte) 0x50, (byte) 0x31, (byte) 0x59, (byte) 0x31, (byte) 0x4d,
            (byte) 0x31, (byte) 0x44, (byte) 0x54, (byte) 0x31, (byte) 0x48, (byte) 0x31, (byte) 0x4d, (byte) 0x31,
            (byte) 0x53,
    };

    @Override
    public byte[] getGregorianCalendarByteArray() {
        return gregorianCalendarBytes;
    }

    @Override
    public byte[] getDurationBytes() {
        return durationBytes;
    }
}
