/*
 * Copyright (C) 2023, KylinSoft Co., Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
**/
#ifndef KEYBOARDLAYOUT_H
#define KEYBOARDLAYOUT_H

#include <QWidget>
#include <QX11Info>

/* qt会将glib里的signals成员识别为宏，所以取消该宏
 * 后面如果用到signals时，使用Q_SIGNALS代替即可
 **/
#ifdef signals
#undef signals
#endif


typedef struct _Layout Layout;

struct _Layout{
    QString desc;
    QString name;
};

class KeyboardLayout : public QWidget
{
    Q_OBJECT

public:
    explicit KeyboardLayout();
    ~KeyboardLayout();

    void data_init();

    QString kbd_get_description_by_id(const char *visible);

};

#endif // KEYBOARDLAYOUT_H
