/*
 * Copyright (C) 2023, KylinSoft Co., Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
**/
#ifndef CREATEUSERNEW_H
#define CREATEUSERNEW_H

#include <QDialog>

#include "passwdcheckutil.h"

#ifdef ENABLEPQ
extern "C" {

#include <pwquality.h>

}
#define PWCONF "/etc/security/pwquality.conf"
#define RFLAG 0x1
#define CFLAG 0x2
#endif

class QVBoxLayout;
class QHBoxLayout;
class QLabel;
class QRadioButton;
class QFrame;
class QLineEdit;
class QPushButton;
class QButtonGroup;

class CreateUserNew : public QDialog
{
    Q_OBJECT

public:
    explicit CreateUserNew(QStringList allUsers, QWidget *parent = nullptr);
    ~CreateUserNew();

public:
    void initUI();
    void setConnect();
    void refreshConfirmBtnStatus();
    void makeSurePwdNeedCheck();
    void nameLegalityCheck(QString username);
    void nameLegalityCheck2(QString nickname);
    void pwdLegalityCheck(QString pwd);

public:
    QVBoxLayout * mainVerLayout;
    QHBoxLayout * usernameHorLayout;
    QHBoxLayout * nicknameHorLayout;
    QHBoxLayout *hostnameHorLayout;
    QHBoxLayout * newPwdHorLayout;
    QHBoxLayout * surePwdHorLayout;
    QHBoxLayout * tipHorLayout;
    QHBoxLayout * typeNoteHorLayout;
    QHBoxLayout * adminHorLayout;
    QVBoxLayout * admin1VerLayout;
    QVBoxLayout * admin2VerLayout;
    QHBoxLayout * standardHorLayout;
    QVBoxLayout * standard1VerLayout;
    QVBoxLayout * standard2VerLayout;
    QHBoxLayout * bottomHorLayout;
    QHBoxLayout *usernameTipHorLayout;
    QHBoxLayout *nicknameTipHorLayout;
    QHBoxLayout *hostnameTipHorLayout;
    QHBoxLayout *newPwdTipHorLayout;

    QLabel * usernameLabel;
    QLabel * nicknameLabel;
    QLabel *hostnameLabel;
    QLabel * newPwdLabel;
    QLabel * surePwdLabel;
    QLabel * tipLabel;
    QLabel * typeNoteLabel;
    QLabel * adminLabel;
    QLabel * adminDetailLabel;
    QLabel * standardLabel;
    QLabel * standardDetailLabel;
    QLabel *usernameTipLabel;
    QLabel *nicknameTipLabel;
    QLabel *hostnameTipLabel;
    QLabel *newpwdTipLabel;


    QLineEdit * usernameLineEdit;
    QLineEdit * nicknameLineEdit;
    QLineEdit *hostnameLineEdit;
    QLineEdit * newPwdLineEdit;
    QLineEdit * surePwdLineEdit;

    QFrame * adminFrame;
    QFrame * standardFrame;

    QRadioButton * adminRadioBtn;
    QRadioButton * standardRadioBtn;

    QPushButton * cancelBtn;
    QPushButton * confirmBtn;

    QButtonGroup * typeBtnGroup;

public:
    QString userNameTip;
    QString nickNameTip;
    QString newPwdTip;
    QString surePwdTip;
    QString oldName;
    QString oldNickName;

    QStringList _allNames;

    bool enablePwdQuality;
    bool hasNickName = false;

protected:
    bool eventFilter(QObject *watched, QEvent *event);
    void keyPressEvent(QKeyEvent *);
    bool setCunTextDynamic(QLabel * label, QString string);

private:
    bool nameTraverse(QString username);
    bool isHomeUserExists(QString username);
    bool isGroupNameEixsts(QString username);
    bool checkCharLegitimacy(QString password);

#ifdef ENABLEPQ
    pwquality_settings_t *settings;
#endif

signals:
    void confirmCreated(QString name, QString fullname, int accounttype, QString pwd);

};

#endif // CREATEUSERNEW_H
