// Copyright 2014 PDFium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// Original code copyright 2014 Foxit Software Inc. http://www.foxitsoftware.com

#include "xfa/fxgraphics/cfx_graphics.h"

#include <memory>

#include "core/fxge/cfx_fxgedevice.h"
#include "core/fxge/cfx_gemodule.h"
#include "core/fxge/cfx_renderdevice.h"
#include "core/fxge/cfx_unicodeencoding.h"
#include "xfa/fxgraphics/cagg_graphics.h"
#include "xfa/fxgraphics/cfx_color.h"
#include "xfa/fxgraphics/cfx_path.h"
#include "xfa/fxgraphics/cfx_path_generator.h"
#include "xfa/fxgraphics/cfx_pattern.h"
#include "xfa/fxgraphics/cfx_shading.h"

namespace {

enum {
  FX_CONTEXT_None = 0,
  FX_CONTEXT_Device,
};

#define FX_HATCHSTYLE_Total 53

struct FX_HATCHDATA {
  int32_t width;
  int32_t height;
  uint8_t maskBits[64];
};

const FX_HATCHDATA hatchBitmapData[FX_HATCHSTYLE_Total] = {
    {16,
     16,
     {
         0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00,
     }},
    {16,
     16,
     {
         0x80, 0x80, 0x00, 0x00, 0x80, 0x80, 0x00, 0x00, 0x80, 0x80, 0x00, 0x00,
         0x80, 0x80, 0x00, 0x00, 0x80, 0x80, 0x00, 0x00, 0x80, 0x80, 0x00, 0x00,
         0x80, 0x80, 0x00, 0x00, 0x80, 0x80, 0x00, 0x00, 0x80, 0x80, 0x00, 0x00,
         0x80, 0x80, 0x00, 0x00, 0x80, 0x80, 0x00, 0x00, 0x80, 0x80, 0x00, 0x00,
         0x80, 0x80, 0x00, 0x00, 0x80, 0x80, 0x00, 0x00, 0x80, 0x80, 0x00, 0x00,
         0x80, 0x80, 0x00, 0x00,
     }},
    {16,
     16,
     {
         0x80, 0x80, 0x00, 0x00, 0x40, 0x40, 0x00, 0x00, 0x20, 0x20, 0x00, 0x00,
         0x10, 0x10, 0x00, 0x00, 0x08, 0x08, 0x00, 0x00, 0x04, 0x04, 0x00, 0x00,
         0x02, 0x02, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00, 0x80, 0x80, 0x00, 0x00,
         0x40, 0x40, 0x00, 0x00, 0x20, 0x20, 0x00, 0x00, 0x10, 0x10, 0x00, 0x00,
         0x08, 0x08, 0x00, 0x00, 0x04, 0x04, 0x00, 0x00, 0x02, 0x02, 0x00, 0x00,
         0x01, 0x01, 0x00, 0x00,
     }},
    {16,
     16,
     {
         0x01, 0x01, 0x00, 0x00, 0x02, 0x02, 0x00, 0x00, 0x04, 0x04, 0x00, 0x00,
         0x08, 0x08, 0x00, 0x00, 0x10, 0x10, 0x00, 0x00, 0x20, 0x20, 0x00, 0x00,
         0x40, 0x40, 0x00, 0x00, 0x80, 0x80, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00,
         0x02, 0x02, 0x00, 0x00, 0x04, 0x04, 0x00, 0x00, 0x08, 0x08, 0x00, 0x00,
         0x10, 0x10, 0x00, 0x00, 0x20, 0x20, 0x00, 0x00, 0x40, 0x40, 0x00, 0x00,
         0x80, 0x80, 0x00, 0x00,
     }},
    {16,
     16,
     {
         0xff, 0xff, 0x00, 0x00, 0x80, 0x80, 0x00, 0x00, 0x80, 0x80, 0x00, 0x00,
         0x80, 0x80, 0x00, 0x00, 0x80, 0x80, 0x00, 0x00, 0x80, 0x80, 0x00, 0x00,
         0x80, 0x80, 0x00, 0x00, 0x80, 0x80, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00,
         0x80, 0x80, 0x00, 0x00, 0x80, 0x80, 0x00, 0x00, 0x80, 0x80, 0x00, 0x00,
         0x80, 0x80, 0x00, 0x00, 0x80, 0x80, 0x00, 0x00, 0x80, 0x80, 0x00, 0x00,
         0x80, 0x80, 0x00, 0x00,
     }},
    {16,
     16,
     {
         0x81, 0x81, 0x00, 0x00, 0x42, 0x42, 0x00, 0x00, 0x24, 0x24, 0x00, 0x00,
         0x18, 0x18, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x24, 0x24, 0x00, 0x00,
         0x42, 0x42, 0x00, 0x00, 0x81, 0x81, 0x00, 0x00, 0x81, 0x81, 0x00, 0x00,
         0x42, 0x42, 0x00, 0x00, 0x24, 0x24, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00,
         0x18, 0x18, 0x00, 0x00, 0x24, 0x24, 0x00, 0x00, 0x42, 0x42, 0x00, 0x00,
         0x81, 0x81, 0x00, 0x00,
     }},
    {16,
     16,
     {
         0x80, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x80, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x08, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00,
     }},
    {16,
     16,
     {
         0x80, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x80, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x08, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x80, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x80, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00,
     }},
    {16,
     16,
     {
         0x88, 0x88, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x22, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x88, 0x88, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x22, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x88, 0x88, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x22, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x88, 0x88, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x22, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00,
     }},
    {16,
     16,
     {
         0x88, 0x88, 0x00, 0x00, 0x22, 0x22, 0x00, 0x00, 0x88, 0x88, 0x00, 0x00,
         0x22, 0x22, 0x00, 0x00, 0x88, 0x88, 0x00, 0x00, 0x22, 0x22, 0x00, 0x00,
         0x88, 0x88, 0x00, 0x00, 0x22, 0x22, 0x00, 0x00, 0x88, 0x88, 0x00, 0x00,
         0x22, 0x22, 0x00, 0x00, 0x88, 0x88, 0x00, 0x00, 0x22, 0x22, 0x00, 0x00,
         0x88, 0x88, 0x00, 0x00, 0x22, 0x22, 0x00, 0x00, 0x88, 0x88, 0x00, 0x00,
         0x22, 0x22, 0x00, 0x00,
     }},
    {16,
     16,
     {
         0xaa, 0xaa, 0x00, 0x00, 0x44, 0x44, 0x00, 0x00, 0xaa, 0xaa, 0x00, 0x00,
         0x11, 0x11, 0x00, 0x00, 0xaa, 0xaa, 0x00, 0x00, 0x44, 0x44, 0x00, 0x00,
         0xaa, 0xaa, 0x00, 0x00, 0x11, 0x11, 0x00, 0x00, 0xaa, 0xaa, 0x00, 0x00,
         0x44, 0x44, 0x00, 0x00, 0xaa, 0xaa, 0x00, 0x00, 0x11, 0x11, 0x00, 0x00,
         0xaa, 0xaa, 0x00, 0x00, 0x44, 0x44, 0x00, 0x00, 0xaa, 0xaa, 0x00, 0x00,
         0x11, 0x11, 0x00, 0x00,
     }},
    {16,
     16,
     {
         0xaa, 0xaa, 0x00, 0x00, 0x55, 0x55, 0x00, 0x00, 0xaa, 0xaa, 0x00, 0x00,
         0x51, 0x51, 0x00, 0x00, 0xaa, 0xaa, 0x00, 0x00, 0x55, 0x55, 0x00, 0x00,
         0xaa, 0xaa, 0x00, 0x00, 0x15, 0x15, 0x00, 0x00, 0xaa, 0xaa, 0x00, 0x00,
         0x55, 0x55, 0x00, 0x00, 0xaa, 0xaa, 0x00, 0x00, 0x51, 0x51, 0x00, 0x00,
         0xaa, 0xaa, 0x00, 0x00, 0x55, 0x55, 0x00, 0x00, 0xaa, 0xaa, 0x00, 0x00,
         0x15, 0x15, 0x00, 0x00,
     }},
    {16,
     16,
     {
         0xaa, 0xaa, 0x00, 0x00, 0x55, 0x55, 0x00, 0x00, 0xaa, 0xaa, 0x00, 0x00,
         0x55, 0x55, 0x00, 0x00, 0xaa, 0xaa, 0x00, 0x00, 0x55, 0x55, 0x00, 0x00,
         0xaa, 0xaa, 0x00, 0x00, 0x55, 0x55, 0x00, 0x00, 0xaa, 0xaa, 0x00, 0x00,
         0x55, 0x55, 0x00, 0x00, 0xaa, 0xaa, 0x00, 0x00, 0x55, 0x55, 0x00, 0x00,
         0xaa, 0xaa, 0x00, 0x00, 0x55, 0x55, 0x00, 0x00, 0xaa, 0xaa, 0x00, 0x00,
         0x55, 0x55, 0x00, 0x00,
     }},
    {16,
     16,
     {
         0xee, 0xee, 0x00, 0x00, 0x55, 0x55, 0x00, 0x00, 0xbb, 0xbb, 0x00, 0x00,
         0x55, 0x55, 0x00, 0x00, 0xee, 0xee, 0x00, 0x00, 0x55, 0x55, 0x00, 0x00,
         0xbb, 0xbb, 0x00, 0x00, 0x55, 0x55, 0x00, 0x00, 0xee, 0xee, 0x00, 0x00,
         0x55, 0x55, 0x00, 0x00, 0xbb, 0xbb, 0x00, 0x00, 0x55, 0x55, 0x00, 0x00,
         0xee, 0xee, 0x00, 0x00, 0x55, 0x55, 0x00, 0x00, 0xbb, 0xbb, 0x00, 0x00,
         0x55, 0x55, 0x00, 0x00,
     }},
    {16,
     16,
     {
         0x77, 0x77, 0x00, 0x00, 0xdd, 0xdd, 0x00, 0x00, 0x77, 0x77, 0x00, 0x00,
         0xdd, 0xdd, 0x00, 0x00, 0x77, 0x77, 0x00, 0x00, 0xdd, 0xdd, 0x00, 0x00,
         0x77, 0x77, 0x00, 0x00, 0xdd, 0xdd, 0x00, 0x00, 0x77, 0x77, 0x00, 0x00,
         0xdd, 0xdd, 0x00, 0x00, 0x77, 0x77, 0x00, 0x00, 0xdd, 0xdd, 0x00, 0x00,
         0x77, 0x77, 0x00, 0x00, 0xdd, 0xdd, 0x00, 0x00, 0x77, 0x77, 0x00, 0x00,
         0xdd, 0xdd, 0x00, 0x00,
     }},
    {16,
     16,
     {
         0x77, 0x77, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0xdd, 0xdd, 0x00, 0x00,
         0xff, 0xff, 0x00, 0x00, 0x77, 0x77, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00,
         0xdd, 0xdd, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x77, 0x77, 0x00, 0x00,
         0xff, 0xff, 0x00, 0x00, 0xdd, 0xdd, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00,
         0x77, 0x77, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0xdd, 0xdd, 0x00, 0x00,
         0xff, 0xff, 0x00, 0x00,
     }},
    {16,
     16,
     {
         0xef, 0xef, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0xfe, 0xfe, 0x00, 0x00,
         0xff, 0xff, 0x00, 0x00, 0xef, 0xef, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00,
         0xfe, 0xfe, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0xef, 0xef, 0x00, 0x00,
         0xff, 0xff, 0x00, 0x00, 0xfe, 0xfe, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00,
         0xef, 0xef, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0xfe, 0xfe, 0x00, 0x00,
         0xff, 0xff, 0x00, 0x00,
     }},
    {16,
     16,
     {
         0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00,
         0xf7, 0xf7, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00,
         0xff, 0xff, 0x00, 0x00, 0x7f, 0x7f, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00,
         0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0xf7, 0xf7, 0x00, 0x00,
         0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00,
         0x7f, 0x7f, 0x00, 0x00,
     }},
    {16,
     16,
     {
         0x88, 0x88, 0x00, 0x00, 0x44, 0x44, 0x00, 0x00, 0x22, 0x22, 0x00, 0x00,
         0x11, 0x11, 0x00, 0x00, 0x88, 0x88, 0x00, 0x00, 0x44, 0x44, 0x00, 0x00,
         0x22, 0x22, 0x00, 0x00, 0x11, 0x11, 0x00, 0x00, 0x88, 0x88, 0x00, 0x00,
         0x44, 0x44, 0x00, 0x00, 0x22, 0x22, 0x00, 0x00, 0x11, 0x11, 0x00, 0x00,
         0x88, 0x88, 0x00, 0x00, 0x44, 0x44, 0x00, 0x00, 0x22, 0x22, 0x00, 0x00,
         0x11, 0x11, 0x00, 0x00,
     }},
    {16,
     16,
     {
         0x11, 0x11, 0x00, 0x00, 0x22, 0x22, 0x00, 0x00, 0x44, 0x44, 0x00, 0x00,
         0x88, 0x88, 0x00, 0x00, 0x11, 0x11, 0x00, 0x00, 0x22, 0x22, 0x00, 0x00,
         0x44, 0x44, 0x00, 0x00, 0x88, 0x88, 0x00, 0x00, 0x11, 0x11, 0x00, 0x00,
         0x22, 0x22, 0x00, 0x00, 0x44, 0x44, 0x00, 0x00, 0x88, 0x88, 0x00, 0x00,
         0x11, 0x11, 0x00, 0x00, 0x22, 0x22, 0x00, 0x00, 0x44, 0x44, 0x00, 0x00,
         0x88, 0x88, 0x00, 0x00,
     }},
    {16,
     16,
     {
         0xcc, 0xcc, 0x00, 0x00, 0x66, 0x66, 0x00, 0x00, 0x33, 0x33, 0x00, 0x00,
         0x99, 0x99, 0x00, 0x00, 0xcc, 0xcc, 0x00, 0x00, 0x66, 0x66, 0x00, 0x00,
         0x33, 0x33, 0x00, 0x00, 0x99, 0x99, 0x00, 0x00, 0xcc, 0xcc, 0x00, 0x00,
         0x66, 0x66, 0x00, 0x00, 0x33, 0x33, 0x00, 0x00, 0x99, 0x99, 0x00, 0x00,
         0xcc, 0xcc, 0x00, 0x00, 0x66, 0x66, 0x00, 0x00, 0x33, 0x33, 0x00, 0x00,
         0x99, 0x99, 0x00, 0x00,
     }},
    {16,
     16,
     {
         0x33, 0x33, 0x00, 0x00, 0x66, 0x66, 0x00, 0x00, 0xcc, 0xcc, 0x00, 0x00,
         0x99, 0x99, 0x00, 0x00, 0x33, 0x33, 0x00, 0x00, 0x66, 0x66, 0x00, 0x00,
         0xcc, 0xcc, 0x00, 0x00, 0x99, 0x99, 0x00, 0x00, 0x33, 0x33, 0x00, 0x00,
         0x66, 0x66, 0x00, 0x00, 0xcc, 0xcc, 0x00, 0x00, 0x99, 0x99, 0x00, 0x00,
         0x33, 0x33, 0x00, 0x00, 0x66, 0x66, 0x00, 0x00, 0xcc, 0xcc, 0x00, 0x00,
         0x99, 0x99, 0x00, 0x00,
     }},
    {16,
     16,
     {
         0xc1, 0xc1, 0x00, 0x00, 0xe0, 0xe0, 0x00, 0x00, 0x70, 0x70, 0x00, 0x00,
         0x38, 0x38, 0x00, 0x00, 0x1c, 0x1c, 0x00, 0x00, 0x0e, 0x0e, 0x00, 0x00,
         0x07, 0x07, 0x00, 0x00, 0x83, 0x83, 0x00, 0x00, 0xc1, 0xc1, 0x00, 0x00,
         0xe0, 0xe0, 0x00, 0x00, 0x70, 0x70, 0x00, 0x00, 0x38, 0x38, 0x00, 0x00,
         0x1c, 0x1c, 0x00, 0x00, 0x0e, 0x0e, 0x00, 0x00, 0x07, 0x07, 0x00, 0x00,
         0x83, 0x83, 0x00, 0x00,
     }},
    {16,
     16,
     {
         0x83, 0x83, 0x00, 0x00, 0x07, 0x07, 0x00, 0x00, 0x0e, 0x0e, 0x00, 0x00,
         0x1c, 0x1c, 0x00, 0x00, 0x38, 0x38, 0x00, 0x00, 0x70, 0x70, 0x00, 0x00,
         0xe0, 0xe0, 0x00, 0x00, 0xc1, 0xc1, 0x00, 0x00, 0x83, 0x83, 0x00, 0x00,
         0x07, 0x07, 0x00, 0x00, 0x0e, 0x0e, 0x00, 0x00, 0x1c, 0x1c, 0x00, 0x00,
         0x38, 0x38, 0x00, 0x00, 0x70, 0x70, 0x00, 0x00, 0xe0, 0xe0, 0x00, 0x00,
         0xc1, 0xc1, 0x00, 0x00,
     }},
    {16,
     16,
     {
         0x88, 0x88, 0x00, 0x00, 0x88, 0x88, 0x00, 0x00, 0x88, 0x88, 0x00, 0x00,
         0x88, 0x88, 0x00, 0x00, 0x88, 0x88, 0x00, 0x00, 0x88, 0x88, 0x00, 0x00,
         0x88, 0x88, 0x00, 0x00, 0x88, 0x88, 0x00, 0x00, 0x88, 0x88, 0x00, 0x00,
         0x88, 0x88, 0x00, 0x00, 0x88, 0x88, 0x00, 0x00, 0x88, 0x88, 0x00, 0x00,
         0x88, 0x88, 0x00, 0x00, 0x88, 0x88, 0x00, 0x00, 0x88, 0x88, 0x00, 0x00,
         0x88, 0x88, 0x00, 0x00,
     }},
    {16,
     16,
     {
         0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00,
     }},
    {16,
     16,
     {
         0x55, 0x55, 0x00, 0x00, 0x55, 0x55, 0x00, 0x00, 0x55, 0x55, 0x00, 0x00,
         0x55, 0x55, 0x00, 0x00, 0x55, 0x55, 0x00, 0x00, 0x55, 0x55, 0x00, 0x00,
         0x55, 0x55, 0x00, 0x00, 0x55, 0x55, 0x00, 0x00, 0x55, 0x55, 0x00, 0x00,
         0x55, 0x55, 0x00, 0x00, 0x55, 0x55, 0x00, 0x00, 0x55, 0x55, 0x00, 0x00,
         0x55, 0x55, 0x00, 0x00, 0x55, 0x55, 0x00, 0x00, 0x55, 0x55, 0x00, 0x00,
         0x55, 0x55, 0x00, 0x00,
     }},
    {16,
     16,
     {
         0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00,
     }},
    {16,
     16,
     {
         0xcc, 0xcc, 0x00, 0x00, 0xcc, 0xcc, 0x00, 0x00, 0xcc, 0xcc, 0x00, 0x00,
         0xcc, 0xcc, 0x00, 0x00, 0xcc, 0xcc, 0x00, 0x00, 0xcc, 0xcc, 0x00, 0x00,
         0xcc, 0xcc, 0x00, 0x00, 0xcc, 0xcc, 0x00, 0x00, 0xcc, 0xcc, 0x00, 0x00,
         0xcc, 0xcc, 0x00, 0x00, 0xcc, 0xcc, 0x00, 0x00, 0xcc, 0xcc, 0x00, 0x00,
         0xcc, 0xcc, 0x00, 0x00, 0xcc, 0xcc, 0x00, 0x00, 0xcc, 0xcc, 0x00, 0x00,
         0xcc, 0xcc, 0x00, 0x00,
     }},
    {16,
     16,
     {
         0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00,
         0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00,
     }},
    {16,
     16,
     {
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x88, 0x88, 0x00, 0x00,
         0x44, 0x44, 0x00, 0x00, 0x22, 0x22, 0x00, 0x00, 0x11, 0x11, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x88, 0x88, 0x00, 0x00, 0x44, 0x44, 0x00, 0x00,
         0x22, 0x22, 0x00, 0x00, 0x11, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00,
     }},
    {16,
     16,
     {
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x11, 0x00, 0x00,
         0x22, 0x22, 0x00, 0x00, 0x44, 0x44, 0x00, 0x00, 0x88, 0x88, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x11, 0x11, 0x00, 0x00, 0x22, 0x22, 0x00, 0x00,
         0x44, 0x44, 0x00, 0x00, 0x88, 0x88, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00,
     }},
    {16,
     16,
     {
         0xf0, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x0f, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf0, 0xf0, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x0f, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00,
     }},
    {16,
     16,
     {
         0x80, 0x80, 0x00, 0x00, 0x80, 0x80, 0x00, 0x00, 0x80, 0x80, 0x00, 0x00,
         0x80, 0x80, 0x00, 0x00, 0x08, 0x08, 0x00, 0x00, 0x08, 0x08, 0x00, 0x00,
         0x08, 0x08, 0x00, 0x00, 0x08, 0x08, 0x00, 0x00, 0x80, 0x80, 0x00, 0x00,
         0x80, 0x80, 0x00, 0x00, 0x80, 0x80, 0x00, 0x00, 0x80, 0x80, 0x00, 0x00,
         0x08, 0x08, 0x00, 0x00, 0x08, 0x08, 0x00, 0x00, 0x08, 0x08, 0x00, 0x00,
         0x08, 0x08, 0x00, 0x00,
     }},
    {16,
     16,
     {
         0x80, 0x80, 0x00, 0x00, 0x08, 0x08, 0x00, 0x00, 0x40, 0x40, 0x00, 0x00,
         0x02, 0x02, 0x00, 0x00, 0x10, 0x10, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00,
         0x20, 0x20, 0x00, 0x00, 0x04, 0x04, 0x00, 0x00, 0x80, 0x80, 0x00, 0x00,
         0x08, 0x08, 0x00, 0x00, 0x40, 0x40, 0x00, 0x00, 0x02, 0x02, 0x00, 0x00,
         0x10, 0x10, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00, 0x20, 0x20, 0x00, 0x00,
         0x04, 0x04, 0x00, 0x00,
     }},
    {16,
     16,
     {
         0xb1, 0xb1, 0x00, 0x00, 0x30, 0x30, 0x00, 0x00, 0x03, 0x03, 0x00, 0x00,
         0x1b, 0x1b, 0x00, 0x00, 0xd8, 0xd8, 0x00, 0x00, 0xc0, 0xc0, 0x00, 0x00,
         0x0c, 0x0c, 0x00, 0x00, 0x8d, 0x8d, 0x00, 0x00, 0xb1, 0xb1, 0x00, 0x00,
         0x30, 0x30, 0x00, 0x00, 0x03, 0x03, 0x00, 0x00, 0x1b, 0x1b, 0x00, 0x00,
         0xd8, 0xd8, 0x00, 0x00, 0xc0, 0xc0, 0x00, 0x00, 0x0c, 0x0c, 0x00, 0x00,
         0x8d, 0x8d, 0x00, 0x00,
     }},
    {16,
     16,
     {
         0x81, 0x81, 0x00, 0x00, 0x42, 0x42, 0x00, 0x00, 0x24, 0x24, 0x00, 0x00,
         0x18, 0x18, 0x00, 0x00, 0x81, 0x81, 0x00, 0x00, 0x42, 0x42, 0x00, 0x00,
         0x24, 0x24, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x81, 0x81, 0x00, 0x00,
         0x42, 0x42, 0x00, 0x00, 0x24, 0x24, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00,
         0x81, 0x81, 0x00, 0x00, 0x42, 0x42, 0x00, 0x00, 0x24, 0x24, 0x00, 0x00,
         0x18, 0x18, 0x00, 0x00,
     }},
    {16,
     16,
     {
         0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x25, 0x25, 0x00, 0x00,
         0xc0, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00,
         0x25, 0x25, 0x00, 0x00, 0xc0, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x18, 0x18, 0x00, 0x00, 0x25, 0x25, 0x00, 0x00, 0xc0, 0xc0, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x25, 0x25, 0x00, 0x00,
         0xc0, 0xc0, 0x00, 0x00,
     }},
    {16,
     16,
     {
         0x01, 0x01, 0x00, 0x00, 0x02, 0x02, 0x00, 0x00, 0x04, 0x04, 0x00, 0x00,
         0x08, 0x08, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x24, 0x24, 0x00, 0x00,
         0x42, 0x42, 0x00, 0x00, 0x81, 0x81, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00,
         0x02, 0x02, 0x00, 0x00, 0x04, 0x04, 0x00, 0x00, 0x08, 0x08, 0x00, 0x00,
         0x18, 0x18, 0x00, 0x00, 0x24, 0x24, 0x00, 0x00, 0x42, 0x42, 0x00, 0x00,
         0x81, 0x81, 0x00, 0x00,
     }},
    {16,
     16,
     {
         0xff, 0xff, 0x00, 0x00, 0x80, 0x80, 0x00, 0x00, 0x80, 0x80, 0x00, 0x00,
         0x80, 0x80, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x08, 0x08, 0x00, 0x00,
         0x08, 0x08, 0x00, 0x00, 0x08, 0x08, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00,
         0x80, 0x80, 0x00, 0x00, 0x80, 0x80, 0x00, 0x00, 0x80, 0x80, 0x00, 0x00,
         0xff, 0xff, 0x00, 0x00, 0x08, 0x08, 0x00, 0x00, 0x08, 0x08, 0x00, 0x00,
         0x08, 0x08, 0x00, 0x00,
     }},
    {16,
     16,
     {
         0x88, 0x88, 0x00, 0x00, 0x54, 0x54, 0x00, 0x00, 0x22, 0x22, 0x00, 0x00,
         0x45, 0x45, 0x00, 0x00, 0x88, 0x88, 0x00, 0x00, 0x14, 0x14, 0x00, 0x00,
         0x22, 0x22, 0x00, 0x00, 0x51, 0x51, 0x00, 0x00, 0x88, 0x88, 0x00, 0x00,
         0x54, 0x54, 0x00, 0x00, 0x22, 0x22, 0x00, 0x00, 0x45, 0x45, 0x00, 0x00,
         0x88, 0x88, 0x00, 0x00, 0x14, 0x14, 0x00, 0x00, 0x22, 0x22, 0x00, 0x00,
         0x51, 0x51, 0x00, 0x00,
     }},
    {16,
     16,
     {
         0xaa, 0xaa, 0x00, 0x00, 0x55, 0x55, 0x00, 0x00, 0xaa, 0xaa, 0x00, 0x00,
         0x55, 0x55, 0x00, 0x00, 0xf0, 0xf0, 0x00, 0x00, 0xf0, 0xf0, 0x00, 0x00,
         0xf0, 0xf0, 0x00, 0x00, 0xf0, 0xf0, 0x00, 0x00, 0xaa, 0xaa, 0x00, 0x00,
         0x55, 0x55, 0x00, 0x00, 0xaa, 0xaa, 0x00, 0x00, 0x55, 0x55, 0x00, 0x00,
         0xf0, 0xf0, 0x00, 0x00, 0xf0, 0xf0, 0x00, 0x00, 0xf0, 0xf0, 0x00, 0x00,
         0xf0, 0xf0, 0x00, 0x00,
     }},
    {16,
     16,
     {
         0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x00, 0x00, 0x08, 0x08, 0x00, 0x00,
         0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x80, 0x00, 0x00,
         0x01, 0x01, 0x00, 0x00, 0x80, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x10, 0x10, 0x00, 0x00, 0x08, 0x08, 0x00, 0x00, 0x10, 0x10, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x80, 0x80, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00,
         0x80, 0x80, 0x00, 0x00,
     }},
    {16,
     16,
     {
         0xaa, 0xaa, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x80, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x80, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x80, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xaa, 0xaa, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x80, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x80, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x80, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00,
     }},
    {16,
     16,
     {
         0x80, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x22, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x22, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x80, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x22, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x08, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x22, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00,
     }},
    {16,
     16,
     {
         0x03, 0x03, 0x00, 0x00, 0x84, 0x84, 0x00, 0x00, 0x48, 0x48, 0x00, 0x00,
         0x30, 0x30, 0x00, 0x00, 0x0c, 0x0c, 0x00, 0x00, 0x02, 0x02, 0x00, 0x00,
         0x01, 0x01, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00, 0x03, 0x03, 0x00, 0x00,
         0x84, 0x84, 0x00, 0x00, 0x48, 0x48, 0x00, 0x00, 0x30, 0x30, 0x00, 0x00,
         0x0c, 0x0c, 0x00, 0x00, 0x02, 0x02, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00,
         0x01, 0x01, 0x00, 0x00,
     }},
    {16,
     16,
     {
         0xff, 0xff, 0x00, 0x00, 0x66, 0x66, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00,
         0x99, 0x99, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x66, 0x66, 0x00, 0x00,
         0xff, 0xff, 0x00, 0x00, 0x99, 0x99, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00,
         0x66, 0x66, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x99, 0x99, 0x00, 0x00,
         0xff, 0xff, 0x00, 0x00, 0x66, 0x66, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00,
         0x99, 0x99, 0x00, 0x00,
     }},
    {16,
     16,
     {
         0x77, 0x77, 0x00, 0x00, 0x89, 0x89, 0x00, 0x00, 0x8f, 0x8f, 0x00, 0x00,
         0x8f, 0x8f, 0x00, 0x00, 0x77, 0x77, 0x00, 0x00, 0x98, 0x98, 0x00, 0x00,
         0xf8, 0xf8, 0x00, 0x00, 0xf8, 0xf8, 0x00, 0x00, 0x77, 0x77, 0x00, 0x00,
         0x89, 0x89, 0x00, 0x00, 0x8f, 0x8f, 0x00, 0x00, 0x8f, 0x8f, 0x00, 0x00,
         0x77, 0x77, 0x00, 0x00, 0x98, 0x98, 0x00, 0x00, 0xf8, 0xf8, 0x00, 0x00,
         0xf8, 0xf8, 0x00, 0x00,
     }},
    {16,
     16,
     {
         0xff, 0xff, 0x00, 0x00, 0x88, 0x88, 0x00, 0x00, 0x88, 0x88, 0x00, 0x00,
         0x88, 0x88, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x88, 0x88, 0x00, 0x00,
         0x88, 0x88, 0x00, 0x00, 0x88, 0x88, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00,
         0x88, 0x88, 0x00, 0x00, 0x88, 0x88, 0x00, 0x00, 0x88, 0x88, 0x00, 0x00,
         0xff, 0xff, 0x00, 0x00, 0x88, 0x88, 0x00, 0x00, 0x88, 0x88, 0x00, 0x00,
         0x88, 0x88, 0x00, 0x00,
     }},
    {16,
     16,
     {
         0x99, 0x99, 0x00, 0x00, 0x66, 0x66, 0x00, 0x00, 0x66, 0x66, 0x00, 0x00,
         0x99, 0x99, 0x00, 0x00, 0x99, 0x99, 0x00, 0x00, 0x66, 0x66, 0x00, 0x00,
         0x66, 0x66, 0x00, 0x00, 0x99, 0x99, 0x00, 0x00, 0x99, 0x99, 0x00, 0x00,
         0x66, 0x66, 0x00, 0x00, 0x66, 0x66, 0x00, 0x00, 0x99, 0x99, 0x00, 0x00,
         0x99, 0x99, 0x00, 0x00, 0x66, 0x66, 0x00, 0x00, 0x66, 0x66, 0x00, 0x00,
         0x99, 0x99, 0x00, 0x00,
     }},
    {16,
     16,
     {
         0xf0, 0xf0, 0x00, 0x00, 0xf0, 0xf0, 0x00, 0x00, 0xf0, 0xf0, 0x00, 0x00,
         0xf0, 0xf0, 0x00, 0x00, 0x0f, 0x0f, 0x00, 0x00, 0x0f, 0x0f, 0x00, 0x00,
         0x0f, 0x0f, 0x00, 0x00, 0x0f, 0x0f, 0x00, 0x00, 0xf0, 0xf0, 0x00, 0x00,
         0xf0, 0xf0, 0x00, 0x00, 0xf0, 0xf0, 0x00, 0x00, 0xf0, 0xf0, 0x00, 0x00,
         0x0f, 0x0f, 0x00, 0x00, 0x0f, 0x0f, 0x00, 0x00, 0x0f, 0x0f, 0x00, 0x00,
         0x0f, 0x0f, 0x00, 0x00,
     }},
    {16,
     16,
     {
         0x82, 0x82, 0x00, 0x00, 0x44, 0x44, 0x00, 0x00, 0x28, 0x28, 0x00, 0x00,
         0x10, 0x10, 0x00, 0x00, 0x28, 0x28, 0x00, 0x00, 0x44, 0x44, 0x00, 0x00,
         0x82, 0x82, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00, 0x82, 0x82, 0x00, 0x00,
         0x44, 0x44, 0x00, 0x00, 0x28, 0x28, 0x00, 0x00, 0x10, 0x10, 0x00, 0x00,
         0x28, 0x28, 0x00, 0x00, 0x44, 0x44, 0x00, 0x00, 0x82, 0x82, 0x00, 0x00,
         0x01, 0x01, 0x00, 0x00,
     }},
    {16,
     16,
     {
         0x10, 0x10, 0x00, 0x00, 0x38, 0x38, 0x00, 0x00, 0x7c, 0x7c, 0x00, 0x00,
         0xfe, 0xfe, 0x00, 0x00, 0x7c, 0x7c, 0x00, 0x00, 0x38, 0x38, 0x00, 0x00,
         0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x00, 0x00,
         0x38, 0x38, 0x00, 0x00, 0x7c, 0x7c, 0x00, 0x00, 0xfe, 0xfe, 0x00, 0x00,
         0x7c, 0x7c, 0x00, 0x00, 0x38, 0x38, 0x00, 0x00, 0x10, 0x10, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00,
     }},
};

}  // namespace

CFX_Graphics::CFX_Graphics()
    : m_type(FX_CONTEXT_None), m_renderDevice(nullptr) {}

FWL_Error CFX_Graphics::Create(CFX_RenderDevice* renderDevice,
                               bool isAntialiasing) {
  if (!renderDevice)
    return FWL_Error::ParameterInvalid;
  if (m_type != FX_CONTEXT_None)
    return FWL_Error::PropertyInvalid;

  m_type = FX_CONTEXT_Device;
  m_info.isAntialiasing = isAntialiasing;
  m_renderDevice = renderDevice;
  if (m_renderDevice->GetDeviceCaps(FXDC_RENDER_CAPS) & FXRC_SOFT_CLIP)
    return FWL_Error::Succeeded;
  return FWL_Error::Indefinite;
}

FWL_Error CFX_Graphics::Create(int32_t width,
                               int32_t height,
                               FXDIB_Format format,
                               bool isNative,
                               bool isAntialiasing) {
  if (m_type != FX_CONTEXT_None)
    return FWL_Error::PropertyInvalid;

  m_type = FX_CONTEXT_Device;
  m_info.isAntialiasing = isAntialiasing;
  m_aggGraphics.reset(new CAGG_Graphics);
  return m_aggGraphics->Create(this, width, height, format);
}

CFX_Graphics::~CFX_Graphics() {}

FWL_Error CFX_Graphics::GetDeviceCap(const int32_t capID,
                                     FX_DeviceCap& capVal) {
  if (m_type == FX_CONTEXT_Device && m_renderDevice) {
    capVal = m_renderDevice->GetDeviceCaps(capID);
    return FWL_Error::Succeeded;
  }
  return FWL_Error::PropertyInvalid;
}

FWL_Error CFX_Graphics::IsPrinterDevice(bool& isPrinter) {
  if (m_type == FX_CONTEXT_Device && m_renderDevice) {
    isPrinter = m_renderDevice->GetDeviceClass() == FXDC_PRINTER;
    return FWL_Error::Succeeded;
  }
  return FWL_Error::PropertyInvalid;
}

FWL_Error CFX_Graphics::EnableAntialiasing(bool isAntialiasing) {
  if (m_type == FX_CONTEXT_Device && m_renderDevice) {
    m_info.isAntialiasing = isAntialiasing;
    return FWL_Error::Succeeded;
  }
  return FWL_Error::PropertyInvalid;
}

FWL_Error CFX_Graphics::SaveGraphState() {
  if (m_type == FX_CONTEXT_Device && m_renderDevice) {
    m_renderDevice->SaveState();
    m_infoStack.Add(new TInfo(m_info));
    return FWL_Error::Succeeded;
  }
  return FWL_Error::PropertyInvalid;
}

FWL_Error CFX_Graphics::RestoreGraphState() {
  if (m_type == FX_CONTEXT_Device && m_renderDevice) {
    m_renderDevice->RestoreState(false);
    int32_t size = m_infoStack.GetSize();
    if (size <= 0) {
      return FWL_Error::IntermediateValueInvalid;
    }
    int32_t topIndex = size - 1;
    std::unique_ptr<TInfo> info(m_infoStack.GetAt(topIndex));
    if (!info)
      return FWL_Error::IntermediateValueInvalid;
    m_info = *info;
    m_infoStack.RemoveAt(topIndex);
    return FWL_Error::Succeeded;
  }
  return FWL_Error::PropertyInvalid;
}

FWL_Error CFX_Graphics::GetLineCap(CFX_GraphStateData::LineCap& lineCap) const {
  if (m_type == FX_CONTEXT_Device && m_renderDevice) {
    lineCap = m_info.graphState.m_LineCap;
    return FWL_Error::Succeeded;
  }
  return FWL_Error::PropertyInvalid;
}

FWL_Error CFX_Graphics::SetLineCap(CFX_GraphStateData::LineCap lineCap) {
  if (m_type == FX_CONTEXT_Device && m_renderDevice) {
    m_info.graphState.m_LineCap = lineCap;
    return FWL_Error::Succeeded;
  }
  return FWL_Error::PropertyInvalid;
}

FWL_Error CFX_Graphics::GetDashCount(int32_t& dashCount) const {
  if (m_type == FX_CONTEXT_Device && m_renderDevice) {
    dashCount = m_info.graphState.m_DashCount;
    return FWL_Error::Succeeded;
  }
  return FWL_Error::PropertyInvalid;
}

FWL_Error CFX_Graphics::GetLineDash(FX_FLOAT& dashPhase,
                                    FX_FLOAT* dashArray) const {
  if (!dashArray)
    return FWL_Error::ParameterInvalid;
  if (m_type == FX_CONTEXT_Device && m_renderDevice) {
    dashPhase = m_info.graphState.m_DashPhase;
    FXSYS_memcpy(dashArray, m_info.graphState.m_DashArray,
                 m_info.graphState.m_DashCount * sizeof(FX_FLOAT));
    return FWL_Error::Succeeded;
  }
  return FWL_Error::PropertyInvalid;
}

FWL_Error CFX_Graphics::SetLineDash(FX_FLOAT dashPhase,
                                    FX_FLOAT* dashArray,
                                    int32_t dashCount) {
  if (dashCount > 0 && !dashArray)
    return FWL_Error::ParameterInvalid;

  dashCount = dashCount < 0 ? 0 : dashCount;
  if (m_type == FX_CONTEXT_Device && m_renderDevice) {
    FX_FLOAT scale = 1.0;
    if (m_info.isActOnDash) {
      scale = m_info.graphState.m_LineWidth;
    }
    m_info.graphState.m_DashPhase = dashPhase;
    m_info.graphState.SetDashCount(dashCount);
    for (int32_t i = 0; i < dashCount; i++) {
      m_info.graphState.m_DashArray[i] = dashArray[i] * scale;
    }
    return FWL_Error::Succeeded;
  }
  return FWL_Error::PropertyInvalid;
}

FWL_Error CFX_Graphics::SetLineDash(FX_DashStyle dashStyle) {
  if (m_type == FX_CONTEXT_Device && m_renderDevice)
    return RenderDeviceSetLineDash(dashStyle);
  return FWL_Error::PropertyInvalid;
}

FWL_Error CFX_Graphics::GetLineJoin(
    CFX_GraphStateData::LineJoin& lineJoin) const {
  if (m_type == FX_CONTEXT_Device && m_renderDevice) {
    lineJoin = m_info.graphState.m_LineJoin;
    return FWL_Error::Succeeded;
  }
  return FWL_Error::PropertyInvalid;
}

FWL_Error CFX_Graphics::SetLineJoin(CFX_GraphStateData::LineJoin lineJoin) {
  if (m_type == FX_CONTEXT_Device && m_renderDevice) {
    m_info.graphState.m_LineJoin = lineJoin;
    return FWL_Error::Succeeded;
  }
  return FWL_Error::PropertyInvalid;
}

FWL_Error CFX_Graphics::GetMiterLimit(FX_FLOAT& miterLimit) const {
  if (m_type == FX_CONTEXT_Device && m_renderDevice) {
    miterLimit = m_info.graphState.m_MiterLimit;
    return FWL_Error::Succeeded;
  }
  return FWL_Error::PropertyInvalid;
}

FWL_Error CFX_Graphics::SetMiterLimit(FX_FLOAT miterLimit) {
  if (m_type == FX_CONTEXT_Device && m_renderDevice) {
    m_info.graphState.m_MiterLimit = miterLimit;
    return FWL_Error::Succeeded;
  }
  return FWL_Error::PropertyInvalid;
}

FWL_Error CFX_Graphics::GetLineWidth(FX_FLOAT& lineWidth) const {
  if (m_type == FX_CONTEXT_Device && m_renderDevice) {
    lineWidth = m_info.graphState.m_LineWidth;
    return FWL_Error::Succeeded;
  }
  return FWL_Error::PropertyInvalid;
}

FWL_Error CFX_Graphics::SetLineWidth(FX_FLOAT lineWidth, bool isActOnDash) {
  if (m_type == FX_CONTEXT_Device && m_renderDevice) {
    m_info.graphState.m_LineWidth = lineWidth;
    m_info.isActOnDash = isActOnDash;
    return FWL_Error::Succeeded;
  }
  return FWL_Error::PropertyInvalid;
}

FWL_Error CFX_Graphics::GetStrokeAlignment(
    FX_StrokeAlignment& strokeAlignment) const {
  if (m_type == FX_CONTEXT_Device && m_renderDevice) {
    strokeAlignment = m_info.strokeAlignment;
    return FWL_Error::Succeeded;
  }
  return FWL_Error::PropertyInvalid;
}

FWL_Error CFX_Graphics::SetStrokeAlignment(FX_StrokeAlignment strokeAlignment) {
  if (m_type == FX_CONTEXT_Device && m_renderDevice) {
    m_info.strokeAlignment = strokeAlignment;
    return FWL_Error::Succeeded;
  }
  return FWL_Error::PropertyInvalid;
}

FWL_Error CFX_Graphics::SetStrokeColor(CFX_Color* color) {
  if (!color)
    return FWL_Error::ParameterInvalid;
  if (m_type == FX_CONTEXT_Device && m_renderDevice) {
    m_info.strokeColor = color;
    return FWL_Error::Succeeded;
  }
  return FWL_Error::PropertyInvalid;
}

FWL_Error CFX_Graphics::SetFillColor(CFX_Color* color) {
  if (!color)
    return FWL_Error::ParameterInvalid;
  if (m_type == FX_CONTEXT_Device && m_renderDevice) {
    m_info.fillColor = color;
    return FWL_Error::Succeeded;
  }
  return FWL_Error::PropertyInvalid;
}

FWL_Error CFX_Graphics::StrokePath(CFX_Path* path, CFX_Matrix* matrix) {
  if (!path)
    return FWL_Error::ParameterInvalid;
  if (m_type == FX_CONTEXT_Device && m_renderDevice)
    return RenderDeviceStrokePath(path, matrix);
  return FWL_Error::PropertyInvalid;
}

FWL_Error CFX_Graphics::FillPath(CFX_Path* path,
                                 FX_FillMode fillMode,
                                 CFX_Matrix* matrix) {
  if (!path)
    return FWL_Error::ParameterInvalid;
  if (m_type == FX_CONTEXT_Device && m_renderDevice)
    return RenderDeviceFillPath(path, fillMode, matrix);
  return FWL_Error::PropertyInvalid;
}

FWL_Error CFX_Graphics::ClipPath(CFX_Path* path,
                                 FX_FillMode fillMode,
                                 CFX_Matrix* matrix) {
  if (!path)
    return FWL_Error::ParameterInvalid;
  if (m_type == FX_CONTEXT_Device && m_renderDevice) {
    bool result =
        m_renderDevice->SetClip_PathFill(path->GetPathData(), matrix, fillMode);
    if (!result)
      return FWL_Error::Indefinite;
    return FWL_Error::Succeeded;
  }
  return FWL_Error::PropertyInvalid;
}

FWL_Error CFX_Graphics::DrawImage(CFX_DIBSource* source,
                                  const CFX_PointF& point,
                                  CFX_Matrix* matrix) {
  if (!source)
    return FWL_Error::ParameterInvalid;
  if (m_type == FX_CONTEXT_Device && m_renderDevice)
    return RenderDeviceDrawImage(source, point, matrix);
  return FWL_Error::PropertyInvalid;
}

FWL_Error CFX_Graphics::StretchImage(CFX_DIBSource* source,
                                     const CFX_RectF& rect,
                                     CFX_Matrix* matrix) {
  if (!source)
    return FWL_Error::ParameterInvalid;
  if (m_type == FX_CONTEXT_Device && m_renderDevice)
    return RenderDeviceStretchImage(source, rect, matrix);
  return FWL_Error::PropertyInvalid;
}

FWL_Error CFX_Graphics::ConcatMatrix(const CFX_Matrix* matrix) {
  if (!matrix)
    return FWL_Error::ParameterInvalid;
  if (m_type == FX_CONTEXT_Device && m_renderDevice) {
    m_info.CTM.Concat(*matrix);
    return FWL_Error::Succeeded;
  }
  return FWL_Error::PropertyInvalid;
}

CFX_Matrix* CFX_Graphics::GetMatrix() {
  if (m_type == FX_CONTEXT_Device && m_renderDevice)
    return &m_info.CTM;
  return nullptr;
}

FWL_Error CFX_Graphics::GetClipRect(CFX_RectF& rect) const {
  if (m_type == FX_CONTEXT_Device && m_renderDevice) {
    FX_RECT r = m_renderDevice->GetClipBox();
    rect.left = (FX_FLOAT)r.left;
    rect.top = (FX_FLOAT)r.top;
    rect.width = (FX_FLOAT)r.Width();
    rect.height = (FX_FLOAT)r.Height();
    return FWL_Error::Succeeded;
  }
  return FWL_Error::PropertyInvalid;
}

FWL_Error CFX_Graphics::SetClipRect(const CFX_RectF& rect) {
  if (m_type == FX_CONTEXT_Device && m_renderDevice) {
    if (!m_renderDevice->SetClip_Rect(
            FX_RECT(FXSYS_round(rect.left), FXSYS_round(rect.top),
                    FXSYS_round(rect.right()), FXSYS_round(rect.bottom())))) {
      return FWL_Error::MethodNotSupported;
    }
    return FWL_Error::Succeeded;
  }
  return FWL_Error::PropertyInvalid;
}

FWL_Error CFX_Graphics::ClearClip() {
  if (m_type == FX_CONTEXT_Device && m_renderDevice)
    return FWL_Error::Succeeded;
  return FWL_Error::PropertyInvalid;
}

FWL_Error CFX_Graphics::SetFont(CFX_Font* font) {
  if (!font)
    return FWL_Error::ParameterInvalid;
  if (m_type == FX_CONTEXT_Device && m_renderDevice) {
    m_info.font = font;
    return FWL_Error::Succeeded;
  }
  return FWL_Error::PropertyInvalid;
}

FWL_Error CFX_Graphics::SetFontSize(const FX_FLOAT size) {
  if (m_type == FX_CONTEXT_Device && m_renderDevice) {
    m_info.fontSize = size <= 0 ? 1.0f : size;
    return FWL_Error::Succeeded;
  }
  return FWL_Error::PropertyInvalid;
}

FWL_Error CFX_Graphics::SetFontHScale(const FX_FLOAT scale) {
  if (m_type == FX_CONTEXT_Device && m_renderDevice) {
    m_info.fontHScale = scale <= 0 ? 1.0f : scale;
    return FWL_Error::Succeeded;
  }
  return FWL_Error::PropertyInvalid;
}

FWL_Error CFX_Graphics::SetCharSpacing(const FX_FLOAT spacing) {
  if (m_type == FX_CONTEXT_Device && m_renderDevice) {
    m_info.fontSpacing = spacing < 0 ? 0 : spacing;
    return FWL_Error::Succeeded;
  }
  return FWL_Error::PropertyInvalid;
}

FWL_Error CFX_Graphics::SetTextDrawingMode(const int32_t mode) {
  if (m_type == FX_CONTEXT_Device && m_renderDevice)
    return FWL_Error::Succeeded;
  return FWL_Error::PropertyInvalid;
}

FWL_Error CFX_Graphics::ShowText(const CFX_PointF& point,
                                 const CFX_WideString& text,
                                 CFX_Matrix* matrix) {
  if (m_type == FX_CONTEXT_Device && m_renderDevice)
    return RenderDeviceShowText(point, text, matrix);
  return FWL_Error::PropertyInvalid;
}

void CFX_Graphics::CalcTextRect(CFX_RectF& rect,
                                const CFX_WideString& text,
                                bool isMultiline,
                                CFX_Matrix* matrix) {
  if (m_type != FX_CONTEXT_Device || !m_renderDevice)
    return;

  int32_t length = text.GetLength();
  uint32_t* charCodes = FX_Alloc(uint32_t, length);
  FXTEXT_CHARPOS* charPos = FX_Alloc(FXTEXT_CHARPOS, length);
  CalcTextInfo(text, charCodes, charPos, rect);
  FX_Free(charPos);
  FX_Free(charCodes);
}

FWL_Error CFX_Graphics::Transfer(CFX_Graphics* graphics,
                                 const CFX_Matrix* matrix) {
  if (!graphics || !graphics->m_renderDevice)
    return FWL_Error::ParameterInvalid;
  CFX_Matrix m;
  m.Set(m_info.CTM.a, m_info.CTM.b, m_info.CTM.c, m_info.CTM.d, m_info.CTM.e,
        m_info.CTM.f);
  if (matrix) {
    m.Concat(*matrix);
  }
  if (m_type == FX_CONTEXT_Device && m_renderDevice) {
    CFX_DIBitmap* bitmap = graphics->m_renderDevice->GetBitmap();
    bool result = m_renderDevice->SetDIBits(bitmap, 0, 0);
    if (!result)
      return FWL_Error::MethodNotSupported;
    return FWL_Error::Succeeded;
  }
  return FWL_Error::PropertyInvalid;
}

FWL_Error CFX_Graphics::Transfer(CFX_Graphics* graphics,
                                 FX_FLOAT srcLeft,
                                 FX_FLOAT srcTop,
                                 const CFX_RectF& dstRect,
                                 const CFX_Matrix* matrix) {
  if (!graphics || !graphics->m_renderDevice)
    return FWL_Error::ParameterInvalid;
  CFX_Matrix m;
  m.Set(m_info.CTM.a, m_info.CTM.b, m_info.CTM.c, m_info.CTM.d, m_info.CTM.e,
        m_info.CTM.f);
  if (matrix) {
    m.Concat(*matrix);
  }
  if (m_type == FX_CONTEXT_Device && m_renderDevice) {
    CFX_DIBitmap bmp;
    bool result =
        bmp.Create((int32_t)dstRect.width, (int32_t)dstRect.height,
                   graphics->m_renderDevice->GetBitmap()->GetFormat());
    if (!result)
      return FWL_Error::IntermediateValueInvalid;
    result = graphics->m_renderDevice->GetDIBits(&bmp, (int32_t)srcLeft,
                                                 (int32_t)srcTop);
    if (!result)
      return FWL_Error::MethodNotSupported;
    result = m_renderDevice->SetDIBits(&bmp, (int32_t)dstRect.left,
                                       (int32_t)dstRect.top);
    if (!result)
      return FWL_Error::MethodNotSupported;
    return FWL_Error::Succeeded;
  }
  return FWL_Error::PropertyInvalid;
}

CFX_RenderDevice* CFX_Graphics::GetRenderDevice() {
  return m_renderDevice;
}

FWL_Error CFX_Graphics::InverseRect(const CFX_RectF& rect) {
  if (!m_renderDevice)
    return FWL_Error::PropertyInvalid;
  CFX_DIBitmap* bitmap = m_renderDevice->GetBitmap();
  if (!bitmap)
    return FWL_Error::PropertyInvalid;
  CFX_RectF temp(rect);
  m_info.CTM.TransformRect(temp);
  CFX_RectF r;
  r.Set(0, 0, (FX_FLOAT)bitmap->GetWidth(), (FX_FLOAT)bitmap->GetWidth());
  r.Intersect(temp);
  if (r.IsEmpty()) {
    return FWL_Error::ParameterInvalid;
  }
  FX_ARGB* pBuf =
      (FX_ARGB*)(bitmap->GetBuffer() + int32_t(r.top) * bitmap->GetPitch());
  int32_t bottom = (int32_t)r.bottom();
  int32_t right = (int32_t)r.right();
  for (int32_t i = (int32_t)r.top; i < bottom; i++) {
    FX_ARGB* pLine = pBuf + (int32_t)r.left;
    for (int32_t j = (int32_t)r.left; j < right; j++) {
      FX_ARGB c = *pLine;
      *pLine++ = (c & 0xFF000000) | (0xFFFFFF - (c & 0x00FFFFFF));
    }
    pBuf = (FX_ARGB*)((uint8_t*)pBuf + bitmap->GetPitch());
  }
  return FWL_Error::Succeeded;
}

FWL_Error CFX_Graphics::XorDIBitmap(const CFX_DIBitmap* srcBitmap,
                                    const CFX_RectF& rect) {
  if (!m_renderDevice)
    return FWL_Error::PropertyInvalid;
  CFX_DIBitmap* dst = m_renderDevice->GetBitmap();
  if (!dst)
    return FWL_Error::PropertyInvalid;
  CFX_RectF temp(rect);
  m_info.CTM.TransformRect(temp);
  CFX_RectF r;
  r.Set(0, 0, (FX_FLOAT)dst->GetWidth(), (FX_FLOAT)dst->GetWidth());
  r.Intersect(temp);
  if (r.IsEmpty()) {
    return FWL_Error::ParameterInvalid;
  }
  FX_ARGB* pSrcBuf = (FX_ARGB*)(srcBitmap->GetBuffer() +
                                int32_t(r.top) * srcBitmap->GetPitch());
  FX_ARGB* pDstBuf =
      (FX_ARGB*)(dst->GetBuffer() + int32_t(r.top) * dst->GetPitch());
  int32_t bottom = (int32_t)r.bottom();
  int32_t right = (int32_t)r.right();
  for (int32_t i = (int32_t)r.top; i < bottom; i++) {
    FX_ARGB* pSrcLine = pSrcBuf + (int32_t)r.left;
    FX_ARGB* pDstLine = pDstBuf + (int32_t)r.left;
    for (int32_t j = (int32_t)r.left; j < right; j++) {
      FX_ARGB c = *pDstLine;
      *pDstLine++ =
          ArgbEncode(FXARGB_A(c), (c & 0xFFFFFF) ^ (*pSrcLine & 0xFFFFFF));
      pSrcLine++;
    }
    pSrcBuf = (FX_ARGB*)((uint8_t*)pSrcBuf + srcBitmap->GetPitch());
    pDstBuf = (FX_ARGB*)((uint8_t*)pDstBuf + dst->GetPitch());
  }
  return FWL_Error::Succeeded;
}

FWL_Error CFX_Graphics::EqvDIBitmap(const CFX_DIBitmap* srcBitmap,
                                    const CFX_RectF& rect) {
  if (!m_renderDevice)
    return FWL_Error::PropertyInvalid;
  CFX_DIBitmap* dst = m_renderDevice->GetBitmap();
  if (!dst)
    return FWL_Error::PropertyInvalid;
  CFX_RectF temp(rect);
  m_info.CTM.TransformRect(temp);
  CFX_RectF r;
  r.Set(0, 0, (FX_FLOAT)dst->GetWidth(), (FX_FLOAT)dst->GetWidth());
  r.Intersect(temp);
  if (r.IsEmpty()) {
    return FWL_Error::ParameterInvalid;
  }
  FX_ARGB* pSrcBuf = (FX_ARGB*)(srcBitmap->GetBuffer() +
                                int32_t(r.top) * srcBitmap->GetPitch());
  FX_ARGB* pDstBuf =
      (FX_ARGB*)(dst->GetBuffer() + int32_t(r.top) * dst->GetPitch());
  int32_t bottom = (int32_t)r.bottom();
  int32_t right = (int32_t)r.right();
  for (int32_t i = (int32_t)r.top; i < bottom; i++) {
    FX_ARGB* pSrcLine = pSrcBuf + (int32_t)r.left;
    FX_ARGB* pDstLine = pDstBuf + (int32_t)r.left;
    for (int32_t j = (int32_t)r.left; j < right; j++) {
      FX_ARGB c = *pDstLine;
      *pDstLine++ =
          ArgbEncode(FXARGB_A(c), ~((c & 0xFFFFFF) ^ (*pSrcLine & 0xFFFFFF)));
      pSrcLine++;
    }
    pSrcBuf = (FX_ARGB*)((uint8_t*)pSrcBuf + srcBitmap->GetPitch());
    pDstBuf = (FX_ARGB*)((uint8_t*)pDstBuf + dst->GetPitch());
  }
  return FWL_Error::Succeeded;
}

FWL_Error CFX_Graphics::RenderDeviceSetLineDash(FX_DashStyle dashStyle) {
  switch (dashStyle) {
    case FX_DASHSTYLE_Solid: {
      m_info.graphState.SetDashCount(0);
      return FWL_Error::Succeeded;
    }
    case FX_DASHSTYLE_Dash: {
      FX_FLOAT dashArray[] = {3, 1};
      SetLineDash(0, dashArray, 2);
      return FWL_Error::Succeeded;
    }
    case FX_DASHSTYLE_Dot: {
      FX_FLOAT dashArray[] = {1, 1};
      SetLineDash(0, dashArray, 2);
      return FWL_Error::Succeeded;
    }
    case FX_DASHSTYLE_DashDot: {
      FX_FLOAT dashArray[] = {3, 1, 1, 1};
      SetLineDash(0, dashArray, 4);
      return FWL_Error::Succeeded;
    }
    case FX_DASHSTYLE_DashDotDot: {
      FX_FLOAT dashArray[] = {4, 1, 2, 1, 2, 1};
      SetLineDash(0, dashArray, 6);
      return FWL_Error::Succeeded;
    }
    default:
      return FWL_Error::ParameterInvalid;
  }
}

FWL_Error CFX_Graphics::RenderDeviceStrokePath(CFX_Path* path,
                                               CFX_Matrix* matrix) {
  if (!m_info.strokeColor)
    return FWL_Error::PropertyInvalid;
  CFX_Matrix m;
  m.Set(m_info.CTM.a, m_info.CTM.b, m_info.CTM.c, m_info.CTM.d, m_info.CTM.e,
        m_info.CTM.f);
  if (matrix) {
    m.Concat(*matrix);
  }
  switch (m_info.strokeColor->m_type) {
    case FX_COLOR_Solid: {
      bool result =
          m_renderDevice->DrawPath(path->GetPathData(), &m, &m_info.graphState,
                                   0x0, m_info.strokeColor->m_info.argb, 0);
      if (!result)
        return FWL_Error::Indefinite;
      return FWL_Error::Succeeded;
    }
    case FX_COLOR_Pattern:
      return StrokePathWithPattern(path, &m);
    case FX_COLOR_Shading:
      return StrokePathWithShading(path, &m);
    default:
      return FWL_Error::PropertyInvalid;
  }
}

FWL_Error CFX_Graphics::RenderDeviceFillPath(CFX_Path* path,
                                             FX_FillMode fillMode,
                                             CFX_Matrix* matrix) {
  if (!m_info.fillColor)
    return FWL_Error::PropertyInvalid;
  CFX_Matrix m;
  m.Set(m_info.CTM.a, m_info.CTM.b, m_info.CTM.c, m_info.CTM.d, m_info.CTM.e,
        m_info.CTM.f);
  if (matrix) {
    m.Concat(*matrix);
  }
  switch (m_info.fillColor->m_type) {
    case FX_COLOR_Solid: {
      bool result = m_renderDevice->DrawPath(
          path->GetPathData(), &m, &m_info.graphState,
          m_info.fillColor->m_info.argb, 0x0, fillMode);
      if (!result)
        return FWL_Error::Indefinite;
      return FWL_Error::Succeeded;
    }
    case FX_COLOR_Pattern:
      return FillPathWithPattern(path, fillMode, &m);
    case FX_COLOR_Shading:
      return FillPathWithShading(path, fillMode, &m);
    default:
      return FWL_Error::PropertyInvalid;
  }
}

FWL_Error CFX_Graphics::RenderDeviceDrawImage(CFX_DIBSource* source,
                                              const CFX_PointF& point,
                                              CFX_Matrix* matrix) {
  CFX_Matrix m1;
  m1.Set(m_info.CTM.a, m_info.CTM.b, m_info.CTM.c, m_info.CTM.d, m_info.CTM.e,
         m_info.CTM.f);
  if (matrix) {
    m1.Concat(*matrix);
  }
  CFX_Matrix m2;
  m2.Set((FX_FLOAT)source->GetWidth(), 0.0, 0.0, (FX_FLOAT)source->GetHeight(),
         point.x, point.y);
  m2.Concat(m1);
  int32_t left, top;
  std::unique_ptr<CFX_DIBitmap> bmp1(source->FlipImage(false, true));
  std::unique_ptr<CFX_DIBitmap> bmp2(bmp1->TransformTo(&m2, left, top));
  CFX_RectF r;
  GetClipRect(r);
  CFX_DIBitmap* bitmap = m_renderDevice->GetBitmap();
  CFX_DIBitmap bmp;
  if (bmp.Create(bitmap->GetWidth(), bitmap->GetHeight(), FXDIB_Argb) &&
      m_renderDevice->GetDIBits(&bmp, 0, 0) &&
      bmp.TransferBitmap(FXSYS_round(r.left), FXSYS_round(r.top),
                         FXSYS_round(r.Width()), FXSYS_round(r.Height()),
                         bmp2.get(), FXSYS_round(r.left - left),
                         FXSYS_round(r.top - top)) &&
      m_renderDevice->SetDIBits(&bmp, 0, 0)) {
    return FWL_Error::Succeeded;
  }
  return FWL_Error::Indefinite;
}

FWL_Error CFX_Graphics::RenderDeviceStretchImage(CFX_DIBSource* source,
                                                 const CFX_RectF& rect,
                                                 CFX_Matrix* matrix) {
  CFX_Matrix m1;
  m1.Set(m_info.CTM.a, m_info.CTM.b, m_info.CTM.c, m_info.CTM.d, m_info.CTM.e,
         m_info.CTM.f);
  if (matrix) {
    m1.Concat(*matrix);
  }
  std::unique_ptr<CFX_DIBitmap> bmp1(
      source->StretchTo((int32_t)rect.Width(), (int32_t)rect.Height()));
  CFX_Matrix m2;
  m2.Set(rect.Width(), 0.0, 0.0, rect.Height(), rect.left, rect.top);
  m2.Concat(m1);
  int32_t left, top;
  std::unique_ptr<CFX_DIBitmap> bmp2(bmp1->FlipImage(false, true));
  std::unique_ptr<CFX_DIBitmap> bmp3(bmp2->TransformTo(&m2, left, top));
  CFX_RectF r;
  GetClipRect(r);
  CFX_DIBitmap* bitmap = m_renderDevice->GetBitmap();
  if (bitmap->CompositeBitmap(FXSYS_round(r.left), FXSYS_round(r.top),
                              FXSYS_round(r.Width()), FXSYS_round(r.Height()),
                              bmp3.get(), FXSYS_round(r.left - left),
                              FXSYS_round(r.top - top))) {
    return FWL_Error::Succeeded;
  }
  return FWL_Error::Indefinite;
}

FWL_Error CFX_Graphics::RenderDeviceShowText(const CFX_PointF& point,
                                             const CFX_WideString& text,
                                             CFX_Matrix* matrix) {
  int32_t length = text.GetLength();
  uint32_t* charCodes = FX_Alloc(uint32_t, length);
  FXTEXT_CHARPOS* charPos = FX_Alloc(FXTEXT_CHARPOS, length);
  CFX_RectF rect;
  rect.Set(point.x, point.y, 0, 0);
  CalcTextInfo(text, charCodes, charPos, rect);
  CFX_Matrix m;
  m.Set(m_info.CTM.a, m_info.CTM.b, m_info.CTM.c, m_info.CTM.d, m_info.CTM.e,
        m_info.CTM.f);
  m.Translate(0, m_info.fontSize * m_info.fontHScale);
  if (matrix) {
    m.Concat(*matrix);
  }
  bool result = m_renderDevice->DrawNormalText(
      length, charPos, m_info.font, -m_info.fontSize * m_info.fontHScale, &m,
      m_info.fillColor->m_info.argb, FXTEXT_CLEARTYPE);
  if (!result)
    return FWL_Error::Indefinite;
  FX_Free(charPos);
  FX_Free(charCodes);
  return FWL_Error::Succeeded;
}

FWL_Error CFX_Graphics::StrokePathWithPattern(CFX_Path* path,
                                              CFX_Matrix* matrix) {
  return FWL_Error::MethodNotSupported;
}

FWL_Error CFX_Graphics::StrokePathWithShading(CFX_Path* path,
                                              CFX_Matrix* matrix) {
  return FWL_Error::MethodNotSupported;
}

FWL_Error CFX_Graphics::FillPathWithPattern(CFX_Path* path,
                                            FX_FillMode fillMode,
                                            CFX_Matrix* matrix) {
  CFX_Pattern* pattern = m_info.fillColor->m_info.pattern;
  CFX_DIBitmap* bitmap = m_renderDevice->GetBitmap();
  int32_t width = bitmap->GetWidth();
  int32_t height = bitmap->GetHeight();
  CFX_DIBitmap bmp;
  bmp.Create(width, height, FXDIB_Argb);
  m_renderDevice->GetDIBits(&bmp, 0, 0);

  FX_HatchStyle hatchStyle = m_info.fillColor->m_info.pattern->m_hatchStyle;
  if (hatchStyle < FX_HATCHSTYLE_Horizontal ||
      hatchStyle > FX_HATCHSTYLE_SolidDiamond) {
    return FWL_Error::IntermediateValueInvalid;
  }
  const FX_HATCHDATA& data = hatchBitmapData[hatchStyle];
  CFX_DIBitmap mask;
  mask.Create(data.width, data.height, FXDIB_1bppMask);
  FXSYS_memcpy(mask.GetBuffer(), data.maskBits, mask.GetPitch() * data.height);
  CFX_FloatRect rectf = path->GetPathData()->GetBoundingBox();
  if (matrix) {
    rectf.Transform(matrix);
  }
  FX_RECT rect(FXSYS_round(rectf.left), FXSYS_round(rectf.top),
               FXSYS_round(rectf.right), FXSYS_round(rectf.bottom));
  CFX_FxgeDevice device;
  device.Attach(&bmp, false, nullptr, false);
  device.FillRect(&rect, m_info.fillColor->m_info.pattern->m_backArgb);
  for (int32_t j = rect.bottom; j < rect.top; j += mask.GetHeight()) {
    for (int32_t i = rect.left; i < rect.right; i += mask.GetWidth()) {
      device.SetBitMask(&mask, i, j,
                        m_info.fillColor->m_info.pattern->m_foreArgb);
    }
  }

  m_renderDevice->SaveState();
  m_renderDevice->SetClip_PathFill(path->GetPathData(), matrix, fillMode);
  SetDIBitsWithMatrix(&bmp, &pattern->m_matrix);
  m_renderDevice->RestoreState(false);
  return FWL_Error::Succeeded;
}

FWL_Error CFX_Graphics::FillPathWithShading(CFX_Path* path,
                                            FX_FillMode fillMode,
                                            CFX_Matrix* matrix) {
  CFX_DIBitmap* bitmap = m_renderDevice->GetBitmap();
  int32_t width = bitmap->GetWidth();
  int32_t height = bitmap->GetHeight();
  FX_FLOAT start_x = m_info.fillColor->m_shading->m_beginPoint.x;
  FX_FLOAT start_y = m_info.fillColor->m_shading->m_beginPoint.y;
  FX_FLOAT end_x = m_info.fillColor->m_shading->m_endPoint.x;
  FX_FLOAT end_y = m_info.fillColor->m_shading->m_endPoint.y;
  CFX_DIBitmap bmp;
  bmp.Create(width, height, FXDIB_Argb);
  m_renderDevice->GetDIBits(&bmp, 0, 0);
  int32_t pitch = bmp.GetPitch();
  bool result = false;
  switch (m_info.fillColor->m_shading->m_type) {
    case FX_SHADING_Axial: {
      FX_FLOAT x_span = end_x - start_x;
      FX_FLOAT y_span = end_y - start_y;
      FX_FLOAT axis_len_square = (x_span * x_span) + (y_span * y_span);
      for (int32_t row = 0; row < height; row++) {
        uint32_t* dib_buf = (uint32_t*)(bmp.GetBuffer() + row * pitch);
        for (int32_t column = 0; column < width; column++) {
          FX_FLOAT x = (FX_FLOAT)(column);
          FX_FLOAT y = (FX_FLOAT)(row);
          FX_FLOAT scale =
              (((x - start_x) * x_span) + ((y - start_y) * y_span)) /
              axis_len_square;
          if (scale < 0) {
            if (!m_info.fillColor->m_shading->m_isExtendedBegin) {
              continue;
            }
            scale = 0;
          } else if (scale > 1.0f) {
            if (!m_info.fillColor->m_shading->m_isExtendedEnd) {
              continue;
            }
            scale = 1.0f;
          }
          int32_t index = (int32_t)(scale * (FX_SHADING_Steps - 1));
          dib_buf[column] = m_info.fillColor->m_shading->m_argbArray[index];
        }
      }
      result = true;
      break;
    }
    case FX_SHADING_Radial: {
      FX_FLOAT start_r = m_info.fillColor->m_shading->m_beginRadius;
      FX_FLOAT end_r = m_info.fillColor->m_shading->m_endRadius;
      FX_FLOAT a = ((start_x - end_x) * (start_x - end_x)) +
                   ((start_y - end_y) * (start_y - end_y)) -
                   ((start_r - end_r) * (start_r - end_r));
      for (int32_t row = 0; row < height; row++) {
        uint32_t* dib_buf = (uint32_t*)(bmp.GetBuffer() + row * pitch);
        for (int32_t column = 0; column < width; column++) {
          FX_FLOAT x = (FX_FLOAT)(column);
          FX_FLOAT y = (FX_FLOAT)(row);
          FX_FLOAT b = -2 * (((x - start_x) * (end_x - start_x)) +
                             ((y - start_y) * (end_y - start_y)) +
                             (start_r * (end_r - start_r)));
          FX_FLOAT c = ((x - start_x) * (x - start_x)) +
                       ((y - start_y) * (y - start_y)) - (start_r * start_r);
          FX_FLOAT s;
          if (a == 0) {
            s = -c / b;
          } else {
            FX_FLOAT b2_4ac = (b * b) - 4 * (a * c);
            if (b2_4ac < 0) {
              continue;
            }
            FX_FLOAT root = (FXSYS_sqrt(b2_4ac));
            FX_FLOAT s1, s2;
            if (a > 0) {
              s1 = (-b - root) / (2 * a);
              s2 = (-b + root) / (2 * a);
            } else {
              s2 = (-b - root) / (2 * a);
              s1 = (-b + root) / (2 * a);
            }
            if (s2 <= 1.0f || m_info.fillColor->m_shading->m_isExtendedEnd) {
              s = (s2);
            } else {
              s = (s1);
            }
            if ((start_r) + s * (end_r - start_r) < 0) {
              continue;
            }
          }
          if (s < 0) {
            if (!m_info.fillColor->m_shading->m_isExtendedBegin) {
              continue;
            }
            s = 0;
          }
          if (s > 1.0f) {
            if (!m_info.fillColor->m_shading->m_isExtendedEnd) {
              continue;
            }
            s = 1.0f;
          }
          int index = (int32_t)(s * (FX_SHADING_Steps - 1));
          dib_buf[column] = m_info.fillColor->m_shading->m_argbArray[index];
        }
      }
      result = true;
      break;
    }
    default: {
      result = false;
      break;
    }
  }
  if (result) {
    m_renderDevice->SaveState();
    m_renderDevice->SetClip_PathFill(path->GetPathData(), matrix, fillMode);
    SetDIBitsWithMatrix(&bmp, matrix);
    m_renderDevice->RestoreState(false);
  }
  return result ? FWL_Error::Succeeded : FWL_Error::PropertyInvalid;
}

FWL_Error CFX_Graphics::SetDIBitsWithMatrix(CFX_DIBSource* source,
                                            CFX_Matrix* matrix) {
  if (matrix->IsIdentity()) {
    m_renderDevice->SetDIBits(source, 0, 0);
  } else {
    CFX_Matrix m;
    m.Set((FX_FLOAT)source->GetWidth(), 0, 0, (FX_FLOAT)source->GetHeight(), 0,
          0);
    m.Concat(*matrix);
    int32_t left, top;
    std::unique_ptr<CFX_DIBitmap> bmp1(source->FlipImage(false, true));
    std::unique_ptr<CFX_DIBitmap> bmp2(bmp1->TransformTo(&m, left, top));
    m_renderDevice->SetDIBits(bmp2.get(), left, top);
  }
  return FWL_Error::Succeeded;
}

FWL_Error CFX_Graphics::CalcTextInfo(const CFX_WideString& text,
                                     uint32_t* charCodes,
                                     FXTEXT_CHARPOS* charPos,
                                     CFX_RectF& rect) {
  std::unique_ptr<CFX_UnicodeEncoding> encoding(
      new CFX_UnicodeEncoding(m_info.font));
  int32_t length = text.GetLength();
  FX_FLOAT penX = (FX_FLOAT)rect.left;
  FX_FLOAT penY = (FX_FLOAT)rect.top;
  FX_FLOAT left = (FX_FLOAT)(0);
  FX_FLOAT top = (FX_FLOAT)(0);
  charCodes[0] = text.GetAt(0);
  charPos[0].m_OriginX = penX + left;
  charPos[0].m_OriginY = penY + top;
  charPos[0].m_GlyphIndex = encoding->GlyphFromCharCode(charCodes[0]);
  charPos[0].m_FontCharWidth = FXSYS_round(
      m_info.font->GetGlyphWidth(charPos[0].m_GlyphIndex) * m_info.fontHScale);
  charPos[0].m_bGlyphAdjust = true;
  charPos[0].m_AdjustMatrix[0] = -1;
  charPos[0].m_AdjustMatrix[1] = 0;
  charPos[0].m_AdjustMatrix[2] = 0;
  charPos[0].m_AdjustMatrix[3] = 1;
  penX += (FX_FLOAT)(charPos[0].m_FontCharWidth) * m_info.fontSize / 1000 +
          m_info.fontSpacing;
  for (int32_t i = 1; i < length; i++) {
    charCodes[i] = text.GetAt(i);
    charPos[i].m_OriginX = penX + left;
    charPos[i].m_OriginY = penY + top;
    charPos[i].m_GlyphIndex = encoding->GlyphFromCharCode(charCodes[i]);
    charPos[i].m_FontCharWidth =
        FXSYS_round(m_info.font->GetGlyphWidth(charPos[i].m_GlyphIndex) *
                    m_info.fontHScale);
    charPos[i].m_bGlyphAdjust = true;
    charPos[i].m_AdjustMatrix[0] = -1;
    charPos[i].m_AdjustMatrix[1] = 0;
    charPos[i].m_AdjustMatrix[2] = 0;
    charPos[i].m_AdjustMatrix[3] = 1;
    penX += (FX_FLOAT)(charPos[i].m_FontCharWidth) * m_info.fontSize / 1000 +
            m_info.fontSpacing;
  }
  rect.width = (FX_FLOAT)penX - rect.left;
  rect.height = rect.top + m_info.fontSize * m_info.fontHScale - rect.top;
  return FWL_Error::Succeeded;
}

CFX_Graphics::TInfo::TInfo()
    : isAntialiasing(true),
      strokeAlignment(FX_STROKEALIGNMENT_Center),
      isActOnDash(false),
      strokeColor(nullptr),
      fillColor(nullptr),
      font(nullptr),
      fontSize(40.0),
      fontHScale(1.0),
      fontSpacing(0.0) {}

CFX_Graphics::TInfo::TInfo(const TInfo& info)
    : graphState(info.graphState),
      isAntialiasing(info.isAntialiasing),
      strokeAlignment(info.strokeAlignment),
      CTM(info.CTM),
      isActOnDash(info.isActOnDash),
      strokeColor(info.strokeColor),
      fillColor(info.fillColor),
      font(info.font),
      fontSize(info.fontSize),
      fontHScale(info.fontHScale),
      fontSpacing(info.fontSpacing) {}

CFX_Graphics::TInfo& CFX_Graphics::TInfo::operator=(const TInfo& other) {
  graphState.Copy(other.graphState);
  isAntialiasing = other.isAntialiasing;
  strokeAlignment = other.strokeAlignment;
  CTM = other.CTM;
  isActOnDash = other.isActOnDash;
  strokeColor = other.strokeColor;
  fillColor = other.fillColor;
  font = other.font;
  fontSize = other.fontSize;
  fontHScale = other.fontHScale;
  fontSpacing = other.fontSpacing;
  return *this;
}
