## TFSA-2020-023: Memory corruption in `dlpack.to_dlpack`

### CVE Number
CVE-2020-15193

### Impact
The implementation of `dlpack.to_dlpack` can be made to use uninitialized
memory resulting in further memory corruption. This is because the pybind11
glue code [assumes that the argument is a
tensor](https://github.com/tensorflow/tensorflow/blob/0e68f4d3295eb0281a517c3662f6698992b7b2cf/tensorflow/python/tfe_wrapper.cc#L1361):
```cc
    TFE_TensorHandle* thandle = EagerTensor_Handle(eager_tensor_pyobject_ptr);
```

However, there is nothing stopping users from passing in a Python object instead of a tensor.
```python
In [2]: tf.experimental.dlpack.to_dlpack([2])
==1720623==WARNING: MemorySanitizer: use-of-uninitialized-value
    #0 0x55b0ba5c410a in tensorflow::(anonymous namespace)::GetTensorFromHandle(TFE_TensorHandle*, TF_Status*) third_party/tensorflow/c/eager/dlpack.cc:46:7
    #1 0x55b0ba5c38f4 in tensorflow::TFE_HandleToDLPack(TFE_TensorHandle*, TF_Status*) third_party/tensorflow/c/eager/dlpack.cc:252:26
...
```

The uninitialized memory address is due to a
[`reinterpret_cast`](https://github.com/tensorflow/tensorflow/blob/0e68f4d3295eb0281a517c3662f6698992b7b2cf/tensorflow/python/eager/pywrap_tensor.cc#L848-L850):
```cc
TFE_TensorHandle* EagerTensor_Handle(const PyObject* o) {
  return reinterpret_cast<const EagerTensor*>(o)->handle;
}
```

Since the `PyObject` is a Python object, not a TensorFlow Tensor, the cast to `EagerTensor` fails.

### Vulnerable Versions
TensorFlow 2.2.0, 2.3.0.

### Patches
We have patched the issue in
[22e07fb204386768e5bcbea563641ea11f96ceb8](https://github.com/tensorflow/tensorflow/commit/22e07fb204386768e5bcbea563641ea11f96ceb8)
and will release a patch release for all affected versions.

We recommend users to upgrade to TensorFlow 2.2.1 or 2.3.1.

### For more information
Please consult [our security
guide](https://github.com/tensorflow/tensorflow/blob/master/SECURITY.md) for
more information regarding the security model and how to contact us with issues
and questions.

### Attribution
This vulnerability has been reported by members of the Aivul Team from Qihoo
360.
