# SwiftPM 5.4 Release Notes

SwiftPM 5.4 includes several improvements, all of which are opt-in based on specifying a tools version of 5.4.


### Executable targets

Swift packages that specify a 5.4 tools version can now explicitly declare targets as executable, which allows the use of the `@main` keyword in package code.

This is done by declaring the target using `executableTarget()` in the package manifest, telling SwiftPM that the target should be considered to be executable regardless of whether it contains a file with a base name of `main`.

The compiler still applies its usual rules when compiling an executable module, so a single target cannot, for example, have a file named `main.swift` and another file that uses `@main`.

### Automatic test discovery

Automatic test discovery is now the default on all platforms, removing the need in `LinuxMain.swift`, which has been deprecated. This file is still honored if it is present.

### More flexible tools version formatting

`Package` manifests can now have any combination of leading whitespace characters before the tools version comment. This allows more flexibility in formatting manifests.
    
Specifically, the Swift tools version specification in each manifest file now accepts any combination of _horizontal_ whitespace characters surrounding `swift-tools-version`, if and only if the specified version ≥ `5.4`. For example, `//swift-tools-version:	5.4` and `//		 swift-tools-version: 5.4` are valid.
  
All [Unicode line terminators](https://www.unicode.org/reports/tr14/) are now recognised in `Package` manifests. This ensures correctness in parsing manifests that are edited and/or built on many non-Unix-like platforms that use ASCII or Unicode encodings. 

### Package dependency caching

Swift Package Manager now caches package dependency repositories on a per-user basis, which reduces the amount of network traffic and increases performance of dependency resolution for subsequent uses of the same package.

The default location of the cache differs depending on the platform, but can be controlled using the new `--cache-path` option. SwiftPM also creates a symbolic link at `~/.swiftpm` referencing the default cache location.

Compiled package manifests are also now cached on a per-user basis. This can be overridden using the new `--manifest-cache` option.
