; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -O0 -mtriple=mipsel-linux-gnu -global-isel \
; RUN:     -verify-machineinstrs %s -o -| FileCheck %s
; RUN: llc -O0 -mtriple=mipsel-linux-gnu -mattr=+fp64,+mips32r2 -global-isel \
; RUN:     -verify-machineinstrs %s -o -| FileCheck %s

define i1 @false_s(float %x, float %y) {
; CHECK-LABEL: false_s:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    ori $2, $zero, 0
; CHECK-NEXT:    jr $ra
; CHECK-NEXT:    nop
entry:
  %cmp = fcmp false float %x, %y
  ret i1 %cmp
}
define i1 @true_s(float %x, float %y) {
; CHECK-LABEL: true_s:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    ori $2, $zero, 1
; CHECK-NEXT:    jr $ra
; CHECK-NEXT:    nop
entry:
  %cmp = fcmp true float %x, %y
  ret i1 %cmp
}


define i1 @uno_s(float %x, float %y) {
; CHECK-LABEL: uno_s:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addiu $2, $zero, 1
; CHECK-NEXT:    c.un.s $f12, $f14
; CHECK-NEXT:    movf $2, $zero, $fcc0
; CHECK-NEXT:    jr $ra
; CHECK-NEXT:    nop
entry:
  %cmp = fcmp uno float %x, %y
  ret i1 %cmp
}
define i1 @ord_s(float %x, float %y) {
; CHECK-LABEL: ord_s:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addiu $2, $zero, 1
; CHECK-NEXT:    c.un.s $f12, $f14
; CHECK-NEXT:    movt $2, $zero, $fcc0
; CHECK-NEXT:    jr $ra
; CHECK-NEXT:    nop
entry:
  %cmp = fcmp ord float %x, %y
  ret i1 %cmp
}


define i1 @oeq_s(float %x, float %y) {
; CHECK-LABEL: oeq_s:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addiu $2, $zero, 1
; CHECK-NEXT:    c.eq.s $f12, $f14
; CHECK-NEXT:    movf $2, $zero, $fcc0
; CHECK-NEXT:    jr $ra
; CHECK-NEXT:    nop
entry:
  %cmp = fcmp oeq float %x, %y
  ret i1 %cmp
}
define i1 @une_s(float %x, float %y) {
; CHECK-LABEL: une_s:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addiu $2, $zero, 1
; CHECK-NEXT:    c.eq.s $f12, $f14
; CHECK-NEXT:    movt $2, $zero, $fcc0
; CHECK-NEXT:    jr $ra
; CHECK-NEXT:    nop
entry:
  %cmp = fcmp une float %x, %y
  ret i1 %cmp
}


define i1 @ueq_s(float %x, float %y) {
; CHECK-LABEL: ueq_s:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addiu $2, $zero, 1
; CHECK-NEXT:    c.ueq.s $f12, $f14
; CHECK-NEXT:    movf $2, $zero, $fcc0
; CHECK-NEXT:    jr $ra
; CHECK-NEXT:    nop
entry:
  %cmp = fcmp ueq float %x, %y
  ret i1 %cmp
}
define i1 @one_s(float %x, float %y) {
; CHECK-LABEL: one_s:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addiu $2, $zero, 1
; CHECK-NEXT:    c.ueq.s $f12, $f14
; CHECK-NEXT:    movt $2, $zero, $fcc0
; CHECK-NEXT:    jr $ra
; CHECK-NEXT:    nop
entry:
  %cmp = fcmp one float %x, %y
  ret i1 %cmp
}


define i1 @olt_s(float %x, float %y) {
; CHECK-LABEL: olt_s:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addiu $2, $zero, 1
; CHECK-NEXT:    c.olt.s $f12, $f14
; CHECK-NEXT:    movf $2, $zero, $fcc0
; CHECK-NEXT:    jr $ra
; CHECK-NEXT:    nop
entry:
  %cmp = fcmp olt float %x, %y
  ret i1 %cmp
}
define i1 @uge_s(float %x, float %y) {
; CHECK-LABEL: uge_s:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addiu $2, $zero, 1
; CHECK-NEXT:    c.olt.s $f12, $f14
; CHECK-NEXT:    movt $2, $zero, $fcc0
; CHECK-NEXT:    jr $ra
; CHECK-NEXT:    nop
entry:
  %cmp = fcmp uge float %x, %y
  ret i1 %cmp
}


define i1 @ult_s(float %x, float %y) {
; CHECK-LABEL: ult_s:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addiu $2, $zero, 1
; CHECK-NEXT:    c.ult.s $f12, $f14
; CHECK-NEXT:    movf $2, $zero, $fcc0
; CHECK-NEXT:    jr $ra
; CHECK-NEXT:    nop
entry:
  %cmp = fcmp ult float %x, %y
  ret i1 %cmp
}
define i1 @oge_s(float %x, float %y) {
; CHECK-LABEL: oge_s:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addiu $2, $zero, 1
; CHECK-NEXT:    c.ult.s $f12, $f14
; CHECK-NEXT:    movt $2, $zero, $fcc0
; CHECK-NEXT:    jr $ra
; CHECK-NEXT:    nop
entry:
  %cmp = fcmp oge float %x, %y
  ret i1 %cmp
}


define i1 @ole_s(float %x, float %y) {
; CHECK-LABEL: ole_s:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addiu $2, $zero, 1
; CHECK-NEXT:    c.ole.s $f12, $f14
; CHECK-NEXT:    movf $2, $zero, $fcc0
; CHECK-NEXT:    jr $ra
; CHECK-NEXT:    nop
entry:
  %cmp = fcmp ole float %x, %y
  ret i1 %cmp
}
define i1 @ugt_s(float %x, float %y) {
; CHECK-LABEL: ugt_s:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addiu $2, $zero, 1
; CHECK-NEXT:    c.ole.s $f12, $f14
; CHECK-NEXT:    movt $2, $zero, $fcc0
; CHECK-NEXT:    jr $ra
; CHECK-NEXT:    nop
entry:
  %cmp = fcmp ugt float %x, %y
  ret i1 %cmp
}


define i1 @ule_s(float %x, float %y) {
; CHECK-LABEL: ule_s:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addiu $2, $zero, 1
; CHECK-NEXT:    c.ule.s $f12, $f14
; CHECK-NEXT:    movf $2, $zero, $fcc0
; CHECK-NEXT:    jr $ra
; CHECK-NEXT:    nop
entry:
  %cmp = fcmp ule float %x, %y
  ret i1 %cmp
}
define i1 @ogt_s(float %x, float %y) {
; CHECK-LABEL: ogt_s:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addiu $2, $zero, 1
; CHECK-NEXT:    c.ule.s $f12, $f14
; CHECK-NEXT:    movt $2, $zero, $fcc0
; CHECK-NEXT:    jr $ra
; CHECK-NEXT:    nop
entry:
  %cmp = fcmp ogt float %x, %y
  ret i1 %cmp
}


define i1 @false_d(double %x, double %y) {
; CHECK-LABEL: false_d:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    ori $2, $zero, 0
; CHECK-NEXT:    jr $ra
; CHECK-NEXT:    nop
entry:
  %cmp = fcmp false double %x, %y
  ret i1 %cmp
}
define i1 @true_d(double %x, double %y) {
; CHECK-LABEL: true_d:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    ori $2, $zero, 1
; CHECK-NEXT:    jr $ra
; CHECK-NEXT:    nop
entry:
  %cmp = fcmp true double %x, %y
  ret i1 %cmp
}


define i1 @uno_d(double %x, double %y) {
; CHECK-LABEL: uno_d:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addiu $2, $zero, 1
; CHECK-NEXT:    c.un.d $f12, $f14
; CHECK-NEXT:    movf $2, $zero, $fcc0
; CHECK-NEXT:    jr $ra
; CHECK-NEXT:    nop
entry:
  %cmp = fcmp uno double %x, %y
  ret i1 %cmp
}
define i1 @ord_d(double %x, double %y) {
; CHECK-LABEL: ord_d:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addiu $2, $zero, 1
; CHECK-NEXT:    c.un.d $f12, $f14
; CHECK-NEXT:    movt $2, $zero, $fcc0
; CHECK-NEXT:    jr $ra
; CHECK-NEXT:    nop
entry:
  %cmp = fcmp ord double %x, %y
  ret i1 %cmp
}


define i1 @oeq_d(double %x, double %y) {
; CHECK-LABEL: oeq_d:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addiu $2, $zero, 1
; CHECK-NEXT:    c.eq.d $f12, $f14
; CHECK-NEXT:    movf $2, $zero, $fcc0
; CHECK-NEXT:    jr $ra
; CHECK-NEXT:    nop
entry:
  %cmp = fcmp oeq double %x, %y
  ret i1 %cmp
}
define i1 @une_d(double %x, double %y) {
; CHECK-LABEL: une_d:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addiu $2, $zero, 1
; CHECK-NEXT:    c.eq.d $f12, $f14
; CHECK-NEXT:    movt $2, $zero, $fcc0
; CHECK-NEXT:    jr $ra
; CHECK-NEXT:    nop
entry:
  %cmp = fcmp une double %x, %y
  ret i1 %cmp
}


define i1 @ueq_d(double %x, double %y) {
; CHECK-LABEL: ueq_d:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addiu $2, $zero, 1
; CHECK-NEXT:    c.ueq.d $f12, $f14
; CHECK-NEXT:    movf $2, $zero, $fcc0
; CHECK-NEXT:    jr $ra
; CHECK-NEXT:    nop
entry:
  %cmp = fcmp ueq double %x, %y
  ret i1 %cmp
}
define i1 @one_d(double %x, double %y) {
; CHECK-LABEL: one_d:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addiu $2, $zero, 1
; CHECK-NEXT:    c.ueq.d $f12, $f14
; CHECK-NEXT:    movt $2, $zero, $fcc0
; CHECK-NEXT:    jr $ra
; CHECK-NEXT:    nop
entry:
  %cmp = fcmp one double %x, %y
  ret i1 %cmp
}


define i1 @olt_d(double %x, double %y) {
; CHECK-LABEL: olt_d:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addiu $2, $zero, 1
; CHECK-NEXT:    c.olt.d $f12, $f14
; CHECK-NEXT:    movf $2, $zero, $fcc0
; CHECK-NEXT:    jr $ra
; CHECK-NEXT:    nop
entry:
  %cmp = fcmp olt double %x, %y
  ret i1 %cmp
}
define i1 @uge_d(double %x, double %y) {
; CHECK-LABEL: uge_d:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addiu $2, $zero, 1
; CHECK-NEXT:    c.olt.d $f12, $f14
; CHECK-NEXT:    movt $2, $zero, $fcc0
; CHECK-NEXT:    jr $ra
; CHECK-NEXT:    nop
entry:
  %cmp = fcmp uge double %x, %y
  ret i1 %cmp
}


define i1 @ult_d(double %x, double %y) {
; CHECK-LABEL: ult_d:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addiu $2, $zero, 1
; CHECK-NEXT:    c.ult.d $f12, $f14
; CHECK-NEXT:    movf $2, $zero, $fcc0
; CHECK-NEXT:    jr $ra
; CHECK-NEXT:    nop
entry:
  %cmp = fcmp ult double %x, %y
  ret i1 %cmp
}
define i1 @oge_d(double %x, double %y) {
; CHECK-LABEL: oge_d:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addiu $2, $zero, 1
; CHECK-NEXT:    c.ult.d $f12, $f14
; CHECK-NEXT:    movt $2, $zero, $fcc0
; CHECK-NEXT:    jr $ra
; CHECK-NEXT:    nop
entry:
  %cmp = fcmp oge double %x, %y
  ret i1 %cmp
}


define i1 @ole_d(double %x, double %y) {
; CHECK-LABEL: ole_d:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addiu $2, $zero, 1
; CHECK-NEXT:    c.ole.d $f12, $f14
; CHECK-NEXT:    movf $2, $zero, $fcc0
; CHECK-NEXT:    jr $ra
; CHECK-NEXT:    nop
entry:
  %cmp = fcmp ole double %x, %y
  ret i1 %cmp
}
define i1 @ugt_d(double %x, double %y) {
; CHECK-LABEL: ugt_d:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addiu $2, $zero, 1
; CHECK-NEXT:    c.ole.d $f12, $f14
; CHECK-NEXT:    movt $2, $zero, $fcc0
; CHECK-NEXT:    jr $ra
; CHECK-NEXT:    nop
entry:
  %cmp = fcmp ugt double %x, %y
  ret i1 %cmp
}


define i1 @ule_d(double %x, double %y) {
; CHECK-LABEL: ule_d:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addiu $2, $zero, 1
; CHECK-NEXT:    c.ule.d $f12, $f14
; CHECK-NEXT:    movf $2, $zero, $fcc0
; CHECK-NEXT:    jr $ra
; CHECK-NEXT:    nop
entry:
  %cmp = fcmp ule double %x, %y
  ret i1 %cmp
}
define i1 @ogt_d(double %x, double %y) {
; CHECK-LABEL: ogt_d:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addiu $2, $zero, 1
; CHECK-NEXT:    c.ule.d $f12, $f14
; CHECK-NEXT:    movt $2, $zero, $fcc0
; CHECK-NEXT:    jr $ra
; CHECK-NEXT:    nop
entry:
  %cmp = fcmp ogt double %x, %y
  ret i1 %cmp
}
