/*
 * Decompiled with CFR 0.152.
 */
package uk.me.nxg.unity.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PushbackReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class SimpleCSVReader
implements Iterable<List<String>> {
    final BufferedReader in;
    final boolean sloppyReader;

    public SimpleCSVReader(Reader reader) {
        this(reader, false);
    }

    public SimpleCSVReader(Reader reader, boolean bl) {
        this.in = new BufferedReader(reader);
        this.sloppyReader = bl;
    }

    @Override
    public Iterator<List<String>> iterator() {
        return new CSVIterator();
    }

    class CSVIterator
    implements Iterator<List<String>> {
        boolean atEOF = false;
        PushbackReader line;
        String oneLine = null;

        CSVIterator() {
        }

        @Override
        public boolean hasNext() {
            boolean bl;
            if (this.atEOF) {
                bl = false;
            } else {
                try {
                    if (SimpleCSVReader.this.sloppyReader) {
                        if (this.oneLine == null) {
                            do {
                                this.oneLine = SimpleCSVReader.this.in.readLine();
                            } while (this.oneLine != null && (this.oneLine.length() == 0 || this.oneLine.charAt(0) == '#'));
                        }
                    } else if (this.oneLine == null) {
                        this.oneLine = SimpleCSVReader.this.in.readLine();
                    }
                }
                catch (IOException iOException) {
                    this.oneLine = null;
                }
                if (this.oneLine == null) {
                    this.atEOF = true;
                }
                boolean bl2 = bl = this.oneLine != null;
            }
            assert (this.atEOF ^ bl);
            return bl;
        }

        @Override
        public List<String> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("Attempt to read past end of CSV file" + SimpleCSVReader.this.in);
            }
            assert (this.oneLine != null);
            try {
                ArrayList<String> arrayList;
                block8: {
                    int n;
                    this.line = new PushbackReader(new StringReader(this.oneLine));
                    arrayList = new ArrayList<String>();
                    while (true) {
                        if ((n = this.line.read()) < 0) break block8;
                        if (n == 34) {
                            arrayList.add(this.readToQuote(this.line));
                        } else {
                            this.line.unread(n);
                            arrayList.add(this.readToCommaOrEnd(this.line));
                        }
                        n = this.line.read();
                        assert (n == 44);
                    }
                }
                this.oneLine = null;
                assert (arrayList != null && arrayList.size() > 0);
                return arrayList;
            }
            catch (IOException iOException) {
                throw new AssertionError((Object)("Odd: uncaught IOException reading CSV file " + SimpleCSVReader.this.in));
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("SimpleCSVReader doesn't support remove()");
        }

        private String readToQuote(PushbackReader pushbackReader) throws IOException {
            StringBuilder stringBuilder = new StringBuilder();
            boolean bl = false;
            while (!bl) {
                int n = pushbackReader.read();
                if (n < 0) {
                    throw new IOException("Malformed CSV file: EOF in quote");
                }
                if (n == 34) {
                    int n2 = pushbackReader.read();
                    if (n2 < 0 || n2 == 44) {
                        pushbackReader.unread(44);
                        bl = true;
                        continue;
                    }
                    if (n2 == 34) {
                        stringBuilder.append('\"');
                        continue;
                    }
                    throw new IOException("Malformed CSV file: quote not followed by comma or EOL");
                }
                stringBuilder.append((char)n);
            }
            return stringBuilder.toString();
        }

        private String readToCommaOrEnd(PushbackReader pushbackReader) throws IOException {
            int n;
            StringBuilder stringBuilder = new StringBuilder();
            boolean bl = false;
            if (SimpleCSVReader.this.sloppyReader) {
                n = 1;
                while (n != 0) {
                    int n2 = pushbackReader.read();
                    if (Character.isWhitespace(n2)) continue;
                    pushbackReader.unread(n2);
                    n = 0;
                }
            }
            while (!bl) {
                n = pushbackReader.read();
                if (n == 44 || n < 0) {
                    pushbackReader.unread(44);
                    bl = true;
                    continue;
                }
                stringBuilder.append((char)n);
            }
            return stringBuilder.toString();
        }
    }
}

