// SPDX-FileCopyrightText: 2006-2024 Knut Reinert & Freie Universität Berlin
// SPDX-FileCopyrightText: 2016-2024 Knut Reinert & MPI für molekulare Genetik
// SPDX-License-Identifier: BSD-3-Clause

/*!\file
 * \brief Meta-header for the \link utility_container Utility / Container submodule \endlink.
 * \author Marcel Ehrhardt <marcel.ehrhardt AT fu-berlin.de>
 */

/*!\defgroup utility_container Container
 * \brief Provides various general purpose container and concepts.
 * \ingroup utility
 * \see utility
 */

#pragma once

#include <seqan3/utility/container/aligned_allocator.hpp>
#include <seqan3/utility/container/concept.hpp>
#include <seqan3/utility/container/dynamic_bitset.hpp>
#include <seqan3/utility/container/small_string.hpp>
#include <seqan3/utility/container/small_vector.hpp>
