// SPDX-FileCopyrightText: 2006-2025 Knut Reinert & Freie Universität Berlin
// SPDX-FileCopyrightText: 2016-2025 Knut Reinert & MPI für molekulare Genetik
// SPDX-License-Identifier: BSD-3-Clause

/*!\file
 * \brief Meta-include for the structure IO submodule.
 * \author Jörg Winkler <j.winkler AT fu-berlin.de>
 */

/*!\defgroup io_structure_file Structure File
 * \ingroup io
 * \brief Provides files and formats for handling structure data.
 *
 * \include{doc} doc/fragments/io_structure_input.md
 *
 * \include{doc} doc/fragments/io_structure_output.md
 */

#pragma once

#include <seqan3/io/structure_file/format_vienna.hpp>
#include <seqan3/io/structure_file/input.hpp>
#include <seqan3/io/structure_file/input_format_concept.hpp>
#include <seqan3/io/structure_file/input_options.hpp>
#include <seqan3/io/structure_file/output.hpp>
#include <seqan3/io/structure_file/output_format_concept.hpp>
#include <seqan3/io/structure_file/output_options.hpp>
#include <seqan3/io/structure_file/record.hpp>
