
///////////////////////////////////////////////////////////
//                                                       //
//                         SAGA                          //
//                                                       //
//      System for Automated Geoscientific Analyses      //
//                                                       //
//                     Tool Library                      //
//                       TIN_Tools                       //
//                                                       //
//-------------------------------------------------------//
//                                                       //
//                   TIN_From_Grid.cpp                   //
//                                                       //
//                 Copyright (C) 2003 by                 //
//                      Olaf Conrad                      //
//                                                       //
//-------------------------------------------------------//
//                                                       //
// This file is part of 'SAGA - System for Automated     //
// Geoscientific Analyses'. SAGA is free software; you   //
// can redistribute it and/or modify it under the terms  //
// of the GNU General Public License as published by the //
// Free Software Foundation, either version 2 of the     //
// License, or (at your option) any later version.       //
//                                                       //
// SAGA is distributed in the hope that it will be       //
// useful, but WITHOUT ANY WARRANTY; without even the    //
// implied warranty of MERCHANTABILITY or FITNESS FOR A  //
// PARTICULAR PURPOSE. See the GNU General Public        //
// License for more details.                             //
//                                                       //
// You should have received a copy of the GNU General    //
// Public License along with this program; if not, see   //
// <http://www.gnu.org/licenses/>.                       //
//                                                       //
//-------------------------------------------------------//
//                                                       //
//    e-mail:     oconrad@saga-gis.org                   //
//                                                       //
//    contact:    Olaf Conrad                            //
//                Institute of Geography                 //
//                University of Goettingen               //
//                Goldschmidtstr. 5                      //
//                37077 Goettingen                       //
//                Germany                                //
//                                                       //
///////////////////////////////////////////////////////////

//---------------------------------------------------------
#include "TIN_From_Grid.h"


///////////////////////////////////////////////////////////
//                                                       //
//                                                       //
//                                                       //
///////////////////////////////////////////////////////////

//---------------------------------------------------------
CTIN_From_Grid::CTIN_From_Grid(void)
{
	Set_Name		(_TL("Grid to TIN"));

	Set_Author		("O.Conrad (c) 2004");

	Set_Description	(_TW(
		"Creates a TIN from grid points. No data values will be ignored.\n\n"
	));

	Parameters.Add_Grid     ("", "GRID"  , _TL("Grid"  ), _TL(""), PARAMETER_INPUT         );
	Parameters.Add_Grid_List("", "VALUES", _TL("Values"), _TL(""), PARAMETER_INPUT_OPTIONAL);
	Parameters.Add_TIN      ("", "TIN"   , _TL("TIN"   ), _TL(""), PARAMETER_OUTPUT        );
}


///////////////////////////////////////////////////////////
//                                                       //
///////////////////////////////////////////////////////////

//---------------------------------------------------------
bool CTIN_From_Grid::On_Execute(void)
{
	CSG_Grid *pGrid = Parameters("GRID")->asGrid();

	CSG_Parameter_Grid_List *pValues = Parameters("VALUES")->asGridList();

	CSG_Shapes Points(SHAPE_TYPE_Point); Points.Add_Field("VALUE", SG_DATATYPE_Double);

	for(int i=0; i<pValues->Get_Grid_Count(); i++)
	{
		Points.Add_Field(pValues->Get_Grid(i)->Get_Name(), SG_DATATYPE_Double);
	}

	//-----------------------------------------------------
	for(int y=0; y<pGrid->Get_NY() && Set_Progress(y, pGrid->Get_NY()); y++)
	{
		for(int x=0; x<pGrid->Get_NX(); x++)
		{
			if( !pGrid->is_NoData(x, y) )
			{
				CSG_Shape &Point = *Points.Add_Shape();

				Point.Set_Point(
					pGrid->Get_XMin() + pGrid->Get_Cellsize() * x,
					pGrid->Get_YMin() + pGrid->Get_Cellsize() * y
				);

				Point.Set_Value(0, pGrid->asDouble(x, y));

				for(int i=0; i<pValues->Get_Grid_Count(); i++)
				{
					if( pValues->Get_Grid(i)->is_NoData(x, y) )
					{
						Point.Set_NoData(1 + i);
					}
					else
					{
						Point.Set_Value(1 + i, pValues->Get_Grid(i)->asDouble(x, y));
					}
				}
			}
		}
	}

	//-----------------------------------------------------
	if( Points.Get_Count() >= 3 )
	{
		CSG_TIN &TIN = *Parameters("TIN")->asTIN();

		TIN.Create(&Points); TIN.Set_Name(pGrid->Get_Name());

		return( true );
	}

	return( false );
}


///////////////////////////////////////////////////////////
//                                                       //
//                                                       //
//                                                       //
///////////////////////////////////////////////////////////

//---------------------------------------------------------
