% This LilyPond file was generated by Rosegarden 23.06
\include "nederlands.ly"
\version "2.12.0"
\header {
    arranger = "Aere Greenway"
    composer = "Frederick Chopin"
    copyright = "Unknown"
    subtitle = "with Cello \& Flute Obligato"
    title = "Prelude in E-Minor"
    tagline = "Created using Rosegarden 23.06 and LilyPond"
}
#(set-global-staff-size 18)
#(set-default-paper-size "a4")
global = { 
    \time 4/4
    \skip 1*73 
}
globalTempo = {
    \override Score.MetronomeMark #'transparent = ##t
    \tempo 4 = 120  
}
\score {
    << % common
        % Force offset of colliding notes in chords:
        \override Score.NoteColumn #'force-hshift = #1.0
        % Allow fingerings inside the staff (configured from export options):
        \override Score.Fingering #'staff-padding = #'()

        \context Staff = "track 3, G04 Atmosphere" << 
            \set Staff.instrumentName = \markup { \center-column { "G04 Atmosphere " } }
            \set Staff.midiInstrument = "G04 Atmosphere"
            \set Score.skipBars = ##t
            \set Staff.printKeyCancellation = ##f
            \new Voice \global
            \new Voice \globalTempo
            \set Staff.autoBeaming = ##f % turns off all autobeaming

            \context Voice = "voice 2.0" {
                % Segment: VibeString (recorded)
                \override Voice.TextScript #'padding = #2.0
                \override MultiMeasureRest #'expand-limit = 1

                \clef "treble"
                R1  |
                r2 r8 b 4. -\tenuto 
                % warning: overlong bar truncated here |
                \skip 8 r16 r32 b' 4 < g e' b b' > -\tenuto r32 < b e' g > 8 -\tenuto \sustainOn 
                % warning: overlong bar truncated here
                % warning: bar too short, padding with rests
                % 7680 + 3360 < 11520  &&  7/8 < 4/4
                r8  |
                r8 \sustainOn < b e' g > 4 -\tenuto < b e' g > \sustainOff \sustainOn r \sustainOff \sustainOn 
                % warning: bar too short, padding with rests
                % 11520 + 3360 < 15360  &&  7/8 < 4/4
                r8  |
%% 5
                \skip 8 r16 \sustainOn r32 < b e' g > 4 -\staccato r32 r16 < c'' b e' g > 4 -\tenuto \sustainOff r8 \sustainOn 
                % warning: bar too short, padding with rests
                % 15360 + 3600 < 19200  &&  15/16 < 4/4
                r16  |
                < e' g b > 4 -\staccato r e' 64 -\tenuto \sustainOff < fis a > 4 -\tenuto b' 2 -\tenuto < e' a fis > 8 -\tenuto \sustainOn 
                % warning: overlong bar truncated here |
                r32 r16 < e' a > 32 -\tenuto fis 8. r32 r8 < a e' fis > 4 -\staccato r8 < ees' a fis > -\tenuto \sustainOff 
                % warning: overlong bar truncated here
                % warning: bar too short, padding with rests
                % 23040 + 3720 < 26880  &&  31/32 < 4/4
                r32  |
                r8 \sustainOn < ees' a fis > 4 -\staccato < c'' ees' fis > 8. -\tenuto a r16 \sustainOff \sustainOn r r32 < ees' fis a > 8 -\tenuto r32  |
                r8 r16 < ees' b' > 4 -\tenuto < a f > 8. -\tenuto \sustainOff r16 \sustainOn < a ees' > -\tenuto f 4 -\staccato r16 < a ees' f > 8 -\tenuto  |
%% 10
                r8 r16 r32 < ees' a f > 4 -\staccato r32 r16 < a d' f > 4 -\tenuto r16 \sustainOff \sustainOn r < a d' f > -\tenuto 
                % warning: overlong bar truncated here |
                \skip 32 \skip 64 r64 r16 r8 c'' 4 -\tenuto < d' aes f > < aes f d' > 8 -\staccato \sustainOff \sustainOn r r r16 < b' aes d' e > -\tenuto 
                % warning: overlong bar truncated here |
                \skip 8 r16 \sustainOn r r32 < aes d' > 4 -\staccato e -\staccato r32 < aes d' e > 4 -\staccato r16 < aes d' e > -\tenuto 
                % warning: overlong bar truncated here |
                r16 r8 < g d' > 4 e < g d' e > 8 -\tenuto \sustainOff \sustainOn \sustainOff \sustainOn r r < cis' bes' g e > -\tenuto 
                % warning: overlong bar truncated here |
                \skip 16 r16 \sustainOn r < cis' g e > 4 -\staccato r16 g 4 -\tenuto < c' a' e > -\tenuto r8 \sustainOff \sustainOn \sustainOff \sustainOn r16 < g c' e > 
                % warning: overlong bar truncated here |
%% 15
                r8 < g c' e > 4 -\staccato < g e c' > 8 -\tenuto r r16 fis 8. -\tenuto < c' e > -\tenuto 
                % warning: overlong bar truncated here |
                r16 \sustainOn r32 < fis c' e > 4 -\staccato r32 r16 b' 4 -\tenuto < fis c' e > < fis c' e > -\staccato \sustainOff \sustainOn  |
                r8 < a' fis c' e > 2.. -\tenuto r8 \sustainOff \sustainOn < fis c' e > 4 r16 \sustainOff \sustainOn r32 fis -\tenuto c' 64 -\tenuto e 8 -\tenuto 
                % warning: overlong bar truncated here |
                r32 r16 < fis c' > 32 -\tenuto e 8 r32 \sustainOff r16 \sustainOn r8 < fis ees c' > 4 -\tenuto r16 \sustainOff \sustainOn r32 fis -\tenuto ees 64 -\tenuto c' 8 -\tenuto 
                % warning: overlong bar truncated here |
                r32 \sustainOn r16 r < b' c' > 64 -\tenuto fis 32 -\tenuto ees 4 r32 \sustainOff \sustainOn < fis ees c' > 4 -\staccato r32 r16 < fis a' d c' > 8. -\tenuto 
                % warning: overlong bar truncated here |
%% 20
                r16 \sustainOn r < fis c' d > 4 r16 < fis c' d > 8. r16 r fis 8. -\tenuto < c' d > -\tenuto 
                % warning: overlong bar truncated here |
                r32 r16 < fis c' d > 4 -\tenuto r8 \sustainOff \sustainOn < fis c' d > 4 r16 < b' fis c' d > 8. -\tenuto 
                % warning: overlong bar truncated here
                % warning: bar too short, padding with rests
                % 76800 + 3720 < 80640  &&  31/32 < 4/4
                r32  |
                r16 \sustainOn c' 32 -\tenuto fis 64 -\tenuto d 8. -\tenuto a' 8 -\tenuto r16 < a' f d c' > 2 -\tenuto \sustainOff r8 \sustainOn r32 < f d > 16. -\tenuto 
                % warning: overlong bar truncated here |
                \skip 32 r32 r16 r32 < f c' d > 8. r32 r16 < f c' d > 8. -\tenuto r8 < f b d > 4 -\tenuto  |
                < f b d > 4 -\staccato r16 < aes' b f d > 2 -\tenuto r8 \sustainOff \sustainOn < b f d > 4 -\staccato r8 
                % warning: overlong bar truncated here |
%% 25
                < e b c > 4 r16 \sustainOn < e b c > 4 -\staccato r16 < a' e a c > 4 -\tenuto r8 \sustainOff \sustainOn  |
                < e a c b' > 8. -\tenuto r16 \sustainOff \sustainOn \sustainOff \sustainOn < e d'' a c > 4 -\tenuto r8 \sustainOff \sustainOn < c'' e a c > 8. -\tenuto r16 \sustainOff \sustainOn \sustainOff \sustainOn < e' e c > 8 -\tenuto a \sustainOff 
                % warning: overlong bar truncated here |
                r8 \sustainOn < e a' a c > 8. -\tenuto r16 \sustainOff \sustainOn \sustainOff \sustainOn r8 r16 fis' 4 -\tenuto < b, e a > 4 -\tenuto \sustainOff r16 \sustainOn 
                % warning: overlong bar truncated here |
                r16 < e b, a > 8 -\tenuto r16 r8 < ees a > 4 -\tenuto b, -\tenuto \sustainOff r16 \sustainOn r32 < a ees b, > 4 -\staccato r32  |
                < e a c > 4 -\tenuto r8 \sustainOff \sustainOn < e a c > 8. -\tenuto r16 r a' 8.. -\tenuto < c e a > -\tenuto r32 \sustainOff \sustainOn r16  |
%% 30
                < e a c > 8 -\staccato r r16 < fis' ees a > 2 -\tenuto b, 4 -\tenuto r16 \sustainOff \sustainOn r < ees a b, > 8. r8 
                % warning: overlong bar truncated here |
                r16 r32 < b, a ees > 4 -\staccato r32 < e a c > 4 -\tenuto r16 \sustainOff \sustainOn \sustainOff \sustainOn r32 < e a c > 16. -\tenuto 
                % warning: overlong bar truncated here
                % warning: bar too short, padding with rests
                % 115200 + 3120 < 119040  &&  13/16 < 4/4
                r16 r8  |
                \skip 32 r32 b' 8 < a' c a e > 4 -\tenuto r16 \sustainOff \sustainOn < e a c > 8 -\staccato r r < ees a > 64 -\tenuto < g' b, > 8 -\tenuto 
                % warning: overlong bar truncated here |
                fis' 4. -\tenuto c' 4 -\tenuto 
                % warning: overlong bar truncated here
                % warning: bar too short, padding with rests
                % 122880 + 2400 < 126720  &&  5/8 < 4/4
                r8 r4  |
                \skip 8 b 4. ees' fis' 8 
                % warning: overlong bar truncated here |
%% 35
                \skip 32 d'' 8. -\tenuto [ c'' -\tenuto ] b' 4 < b' e' b g > 8 -\tenuto 
                % warning: overlong bar truncated here
                % warning: bar too short, padding with rests
                % 130560 + 3000 < 134400  &&  25/32 < 4/4
                r32 r16 r8  |
                \skip 8 r8 r16 \sustainOn < b g e' > 4 r16 < b g e' > 4 -\tenuto r8 \sustainOff \sustainOn \sustainOff \sustainOn  |
                < b e' g > 4 -\staccato r16 < b e' g > 4 -\tenuto r16 \sustainOff \sustainOn r < b e' g > 4 r16  |
                < c'' e' b g > 4 -\tenuto r8 \sustainOff \sustainOn < b g e' > -\staccato r4 < b' e' a fis > -\tenuto 
                % warning: overlong bar truncated here |
                r8 r16 < a e' fis > 4 r16 < a e' fis > 4 -\staccato r16 r32 < a e' fis > 8 -\staccato r32  |
%% 40
                r8 r16 < a ees' f > 4 -\tenuto r16 \sustainOff \sustainOn r < a ees' f > 4 -\staccato r16 < ees' a c'' > 32 -\tenuto f 16. -\tenuto 
                % warning: overlong bar truncated here |
                \skip 16 r8 \sustainOn < a ees' f > 4 -\staccato r8 < aes ees' b' f > 8. -\tenuto \sustainOff r8 \sustainOn 
                % warning: bar too short, padding with rests
                % 153600 + 3360 < 157440  &&  7/8 < 4/4
                r8  |
                r32 < aes ees' f > 4 -\staccato r32 r16 < aes f d' > 4 -\tenuto r16 \sustainOff \sustainOn r32 < aes d' f > 8 -\staccato r32 r8  |
                aes 4 < d' e > r8 \sustainOff \sustainOn \sustainOff \sustainOn r32 < aes d' e > 4 -\staccato r32 < aes d' e > 16 -\tenuto c'' 4 -\tenuto  |
                r16 < aes d' e > 8 -\tenuto r16 r8 < d' g > 4 \sustainOff < e b' > -\tenuto r8 \sustainOn < g d' e > -\tenuto bes' -\tenuto  |
%% 45
                cis' 8. -\tenuto < g e bes' > -\tenuto-\staccato \sustainOff b' 16. -\tenuto \sustainOn \sustainOff [ bes' -\tenuto ] < a' cis' g e > 8 -\tenuto \sustainOn r32 \sustainOff bes' 8 -\tenuto r32 r16 < cis g'' bes e fis'' > 4 -\tenuto-\staccato  |
                r16 r32 < bes e cis > 4 -\staccato r32 r16 < c a fis'' e > 4 -\tenuto \sustainOff r16 \sustainOn r < e a c > 8. -\tenuto  |
                e'' 4 < b,, b, e'' > -\tenuto \sustainOff < a' fis' a c' > 8 -\tenuto ees'' 4.  |
                r16 \sustainOff \sustainOn r < a' fis' ees'' c' a > 4 -\tenuto \sustainOff \sustainOn r16 \sustainOff \sustainOn < ees' g' > 32 -\tenuto \sustainOff < b b > 64 -\staccato g 16 -\tenuto ees'' 4 -\tenuto r16 
                % warning: bar too short, padding with rests
                % 180480 + 3300 < 184320  &&  55/64 < 4/4
                r64 r8  |
                < e' g e'' > 4 -\tenuto r8 < b e' bes g'' > 16 -\tenuto r r4 < b b' e' g > -\tenuto  |
%% 50
                r8 r16 < c' e' d'' a > 4. -\tenuto \sustainOff r16 \sustainOn < a c'' > 4. -\tenuto < e' c' > -\tenuto  |
                < a, e'' > 4 e' 8 -\tenuto \sustainOn r32 < e e > 64 -\tenuto < c' fis > 8 -\tenuto a' 4 -\tenuto \sustainOff r16 < b, b fis' > 8. -\tenuto 
                % warning: overlong bar truncated here |
                \skip 16 \skip 32 < b e b, > 4 \sustainOn r16 r < a e c > 4 \sustainOff 
                % warning: overlong bar truncated here
                % warning: bar too short, padding with rests
                % 195840 + 3000 < 199680  &&  23/32 < 4/4
                r32 r16 r8  |
                r16 < a' a c e > 8. -\tenuto r16 \sustainOff \sustainOn r8 r16 < e b, b fis' > 4. -\tenuto \sustainOff 
                % warning: bar too short, padding with rests
                % 199680 + 3360 < 203520  &&  7/8 < 4/4
                r8  |
                < e b b, > 4 r8 < b b, e > 4 -\staccato r8 < e b b, > 4 -\staccato  |
%% 55
                r8 < e a c > 4 -\tenuto r8 \sustainOn \sustainOff \sustainOn < a c e > 4 b' 16 -\tenuto [ < a' c a > -\tenuto ] e 8 
                % warning: overlong bar truncated here |
                r16 \sustainOn a 32 -\tenuto < c e > 16. -\tenuto r16 r8 r < fis' e b b, > 4. -\tenuto r8 \sustainOff \sustainOn 
                % warning: overlong bar truncated here |
                r16 < b, b e > 4 r16 < b e b, > 4 -\tenuto r8 < e b b, > 4 -\staccato  |
                r8 < ees b b, > 4. < ees b b, > 8. \sustainOff \sustainOn \sustainOff \sustainOn r16 r < ees a b, > 8. 
                % warning: overlong bar truncated here |
                r16 \sustainOn r < a ees b, > 4 -\staccato r16 < c g e' > 4 -\tenuto \sustainOff 
                % warning: bar too short, padding with rests
                % 222720 + 2640 < 226560  &&  11/16 < 4/4
                r16 r4  |
%% 60
                < g c > 4 r16 < g c > 8. r16 r32 g 4 -\staccato c -\staccato r32 r8  |
                r8 \sustainOn < bes c > 4 -\staccato r8 < c fis' e a > 64 -\tenuto g 32 r4 
                % warning: bar too short, padding with rests
                % 230400 + 3060 < 234240  &&  51/64 < 4/4
                r64 r16 r8  |
                r8 < c e a > -\tenuto r4 e' 64 -\tenuto [ < a b, > 16. -\tenuto \sustainOff a, 64 -\staccato ] e 4 r  |
                < b, e a > 4 -\staccato r32 < e aes > 64 -\tenuto b, 4 r16 \sustainOff \sustainOn r32 < b, e aes > 4 -\staccato r32 r16 < b, e g > 
                % warning: overlong bar truncated here |
                r16 \sustainOff \sustainOn < g e b, > 4 -\tenuto r8 \sustainOff \sustainOn \sustainOff \sustainOn < fis' g b, e > 4 -\tenuto 
                % warning: overlong bar truncated here
                % warning: bar too short, padding with rests
                % 241920 + 2640 < 245760  &&  11/16 < 4/4
                r16 r4  |
%% 65
                r8 r16 < b, e g > 4 -\tenuto r16 \sustainOff \sustainOn r4 < e' g bes, c > -\tenuto 
                % warning: overlong bar truncated here |
                r4 
                % warning: bar too short, padding with rests
                % 249600 + 960 < 253440  &&  1/4 < 4/4
                r4 r2  |
                r2 < b,, fis e' e b b, > 
                % warning: overlong bar truncated here |
                \skip 4 r4 r8 < b,, ees' ees fis > 64 -\tenuto < fis, b > 16 -\tenuto \sustainOff b, 4 
                % warning: overlong bar truncated here |
                \skip 8 r16 \sustainOn r4 r8 < e' g e b e,, e, > -\tenuto 
                % warning: overlong bar truncated here
                % warning: bar too short, padding with rests
                % 261120 + 2640 < 264960  &&  11/16 < 4/4
                r16 r4  |
%% 70
                \skip 2 
                % warning: bar too short, padding with rests
                % 264960 + 1920 < 268800  &&  1/2 < 4/4
                r2  |
                
                % warning: bar too short, padding with rests
                % 268800 + 0 < 272640  &&  0/1 < 4/4
                R1  |
                r8 
                % warning: bar too short, padding with rests
                % 272640 + 480 < 276480  &&  1/8 < 4/4
                r8 r4 r2  |
                R1  |
                \bar "|."
            } % Voice

            % End of segment VibeString (recorded)

            % End voice 0
        >> % Staff ends

        \context Staff = "track 4, Cello 2" << 
            \set Staff.instrumentName = \markup { \center-column { "Cello 2 " } }
            \set Staff.midiInstrument = "C11 Cello 3"
            \set Score.skipBars = ##t
            \set Staff.printKeyCancellation = ##f
            \new Voice \global
            \new Voice \globalTempo
            \set Staff.autoBeaming = ##f % turns off all autobeaming

            \context Voice = "voice 3.0" {
                % Segment: Cello 2 (recorded)
                \override Voice.TextScript #'padding = #2.0
                \override MultiMeasureRest #'expand-limit = 1

                \clef "treble"
                R1  |
                r2 r8 b 4. -\tenuto 
                % warning: overlong bar truncated here |
                \skip 8 r16 b' 8. r16 b' 2 -\tenuto 
                % warning: overlong bar truncated here |
                \skip 1  |
%% 5
                \skip 4 \skip 8 \skip 16 r16 r8 c'' 4. -\tenuto 
                % warning: overlong bar truncated here |
                \skip 4 \skip 8 b' 2 -\tenuto 
                % warning: overlong bar truncated here |
                \skip 1  |
                \skip 4 \skip 8 r8 c'' 2 
                % warning: overlong bar truncated here |
                \skip 4 b' 2. -\tenuto 
                % warning: overlong bar truncated here |
%% 10
                \skip 1  |
                \skip 4 c'' 2 -\tenuto r8 r16 b' 
                % warning: overlong bar truncated here |
                \skip 1 \skip 2 \skip 4 \skip 8  |
                \skip 2 \skip 4 \skip 8 bes' 8 -\tenuto 
                % warning: overlong bar truncated here |
                \skip 4 \skip 8 r8 a' 2 
                % warning: overlong bar truncated here |
%% 15
                \skip 1 \skip 2  |
                \skip 2 b' 2 -\tenuto  |
                r8 a' 2.. -\tenuto 
                % warning: overlong bar truncated here |
                \skip 1  |
                \skip 8 b' 2 -\tenuto r8 r16 a' 8. 
                % warning: overlong bar truncated here |
%% 20
                \skip 1 \skip 2 \skip 4  |
                \skip 2 \skip 4 b' 4 -\tenuto 
                % warning: overlong bar truncated here |
                \skip 4 r16 a' 4 a' 4.. -\tenuto 
                % warning: overlong bar truncated here |
                \skip 1  |
                \skip 4 r16 aes' 2 -\tenuto 
                % warning: overlong bar truncated here
                % warning: bar too short, padding with rests
                % 88320 + 3600 < 92160  &&  13/16 < 4/4
                r16  |
%% 25
                \skip 4 \skip 8 r8 r a' 4 -\tenuto r8  |
                b' 4 -\tenuto r16 d'' 4 -\tenuto c'' -\tenuto r16 e' 8 
                % warning: overlong bar truncated here |
                \skip 4 a' 4. -\tenuto fis' -\tenuto 
                % warning: overlong bar truncated here |
                \skip 1 \skip 2  |
                \skip 2 r8 a' 4 -\tenuto 
                % warning: overlong bar truncated here
                % warning: bar too short, padding with rests
                % 107520 + 3360 < 111360  &&  7/8 < 4/4
                r8  |
%% 30
                \skip 4 r8 fis' 2 -\tenuto 
                % warning: overlong bar truncated here |
                \skip 2 \skip 4 \skip 8 r8  |
                r16 r32 b' 16. -\tenuto a' 2 -\tenuto r16 r8 g' -\tenuto 
                % warning: overlong bar truncated here |
                \skip 4 fis' 4 -\tenuto r16 c' 4. 
                % warning: overlong bar truncated here
                % warning: bar too short, padding with rests
                % 122880 + 3600 < 126720  &&  15/16 < 4/4
                r16  |
                \skip 8 b 4. -\tenuto ees' fis' 8 
                % warning: overlong bar truncated here |
%% 35
                \skip 8 \skip 16 d'' 4 -\tenuto c'' 8. -\tenuto b' 4 b' 16 -\tenuto 
                % warning: overlong bar truncated here
                % warning: bar too short, padding with rests
                % 130560 + 3600 < 134400  &&  15/16 < 4/4
                r16  |
                \skip 1 \skip 2 \skip 4 \skip 8 \skip 16  |
                \skip 2 \skip 4 \skip 8 \skip 16 r16  |
                c'' 2. -\tenuto b' 4 -\tenuto 
                % warning: overlong bar truncated here |
                \skip 1 \skip 2 \skip 4  |
%% 40
                \skip 2 \skip 4 r8 c'' -\tenuto 
                % warning: overlong bar truncated here |
                \skip 2 b' 4. -\tenuto 
                % warning: overlong bar truncated here
                % warning: bar too short, padding with rests
                % 153600 + 3360 < 157440  &&  7/8 < 4/4
                r8  |
                \skip 1 \skip 2  |
                \skip 2 r8 c'' 4 -\tenuto 
                % warning: overlong bar truncated here
                % warning: bar too short, padding with rests
                % 161280 + 3360 < 165120  &&  7/8 < 4/4
                r8  |
                \skip 4 r8 b' 2 -\tenuto bes' 8 -\tenuto  |
%% 45
                r16 bes' 8 [ b' 16. -\tenuto bes' -\tenuto a' 8 ] bes' 4 g'' -\tenuto 
                % warning: overlong bar truncated here |
                \skip 4 r8 r16 fis'' 2 -\tenuto r16  |
                e'' 4 e'' 4. -\tenuto ees'' 4 -\tenuto r16 c''' -\tenuto 
                % warning: overlong bar truncated here |
                \skip 4 ees'' 4 -\tenuto r16 r ees'' 4 -\tenuto r16 
                % warning: bar too short, padding with rests
                % 180480 + 3600 < 184320  &&  15/16 < 4/4
                r16  |
                e'' 4. g'' -\tenuto r16 b' 8. -\tenuto 
                % warning: overlong bar truncated here |
%% 50
                \skip 8 \skip 16 d'' 4.. c'' 4. 
                % warning: overlong bar truncated here |
                \skip 16 e'' 4 -\tenuto e' 8. -\tenuto a' 4 -\tenuto r8 fis' -\tenuto 
                % warning: overlong bar truncated here |
                \skip 2 \skip 4 \skip 8 r8  |
                r8 a' 4.. -\tenuto fis' -\tenuto 
                % warning: overlong bar truncated here |
                \skip 1 \skip 2  |
%% 55
                \skip 2 r16 r8 b' a' 
                % warning: overlong bar truncated here
                % warning: bar too short, padding with rests
                % 207360 + 3600 < 211200  &&  15/16 < 4/4
                r16  |
                \skip 2 fis' 4. -\tenuto 
                % warning: overlong bar truncated here
                % warning: bar too short, padding with rests
                % 211200 + 3360 < 215040  &&  7/8 < 4/4
                r8  |
                \skip 1 \skip 2  |
                \skip 2 r8 r4 
                % warning: bar too short, padding with rests
                % 218880 + 3360 < 222720  &&  7/8 < 4/4
                r8  |
                r4 r8 e' 8. r16 < e' f' > 4. -\tenuto-\staccato r64 r32 r16 r4 
                % warning: overlong bar truncated here |
%% 60
                R1  |
                r2 r8 r16 fis' 4 -\tenuto 
                % warning: overlong bar truncated here |
                \skip 4 \skip 8 \skip 16 r16 e' 2 -\tenuto 
                % warning: overlong bar truncated here |
                \skip 1 \skip 2  |
                \skip 2 r4 fis' 
                % warning: overlong bar truncated here |
%% 65
                \skip 2 \skip 4 e' 4 
                % warning: overlong bar truncated here |
                \skip 1  |
                \skip 16 \skip 32 r4 e 2 -\tenuto 
                % warning: overlong bar truncated here
                % warning: bar too short, padding with rests
                % 253440 + 3240 < 257280  &&  27/32 < 4/4
                r32 r8  |
                \skip 4 r8 ees 4. -\tenuto 
                % warning: overlong bar truncated here
                % warning: bar too short, padding with rests
                % 257280 + 2880 < 261120  &&  3/4 < 4/4
                r4  |
                \skip 8 r8 r e -\tenuto 
                % warning: overlong bar truncated here
                % warning: bar too short, padding with rests
                % 261120 + 1920 < 264960  &&  1/2 < 4/4
                r2  |
%% 70
                \skip 16 
                % warning: bar too short, padding with rests
                % 264960 + 240 < 268800  &&  1/16 < 4/4
                r16 r8 r4 r2  |
                
                % warning: bar too short, padding with rests
                % 268800 + 0 < 272640  &&  0/1 < 4/4
                R1  |
                r8 
                % warning: bar too short, padding with rests
                % 272640 + 480 < 276480  &&  1/8 < 4/4
                r8 r4 r2  |
                R1  |
                \bar "|."
            } % Voice

            % End of segment Cello 2 (recorded)

            % End voice 0
        >> % Staff ends

        \context Staff = "track 5, Flute 2" << 
            \set Staff.instrumentName = \markup { \center-column { "Flute 2 " } }
            \set Staff.midiInstrument = "E10 Flute"
            \set Score.skipBars = ##t
            \set Staff.printKeyCancellation = ##f
            \new Voice \global
            \new Voice \globalTempo
            \set Staff.autoBeaming = ##f % turns off all autobeaming

            \context Voice = "voice 4.0" {
                % Segment: Flute 2 (recorded)
                \override Voice.TextScript #'padding = #2.0
                \override MultiMeasureRest #'expand-limit = 1

                \clef "treble"
                R1  |
                R1  |
                r2 e''' 
                % warning: overlong bar truncated here |
                \skip 4 g''' 2.  |
%% 5
                b''' 2 -\tenuto r8 r16 c'''' 4 -\tenuto r16  |
                b''' 4. -\tenuto r8 fis''' 2 -\tenuto  |
                r8 r16 fis''' 4 -\tenuto e''' 8 -\tenuto r16 d''' 4 -\tenuto r8  |
                b'' 2 -\tenuto b''  |
                a'' 8 [ b'' ) ] d''' 2 d''' 8 r  |
%% 10
                d''' 4 -\tenuto b'' -\staccato a'' 8 -\tenuto b'' 4. -\tenuto 
                % warning: overlong bar truncated here |
                \skip 8 r8 b'' 4 -\tenuto r16 a'' 4. fis'' 16 
                % warning: overlong bar truncated here |
                \skip 2 fis'' 4 -\tenuto r16 
                % warning: bar too short, padding with rests
                % 42240 + 3120 < 46080  &&  13/16 < 4/4
                r16 r8  |
                e'' 4 -\tenuto b' 2 -\tenuto r8 d'' 
                % warning: overlong bar truncated here |
                \skip 4 e'' 4 -\tenuto fis'' 2 
                % warning: overlong bar truncated here |
%% 15
                \skip 4 a'' 4.. fis'' 16 -\tenuto e'' 8 fis'' -\tenuto 
                % warning: overlong bar truncated here |
                \skip 4 \skip 8 r8 r16 a'' 4.. -\tenuto  |
                fis'' 8 -\tenuto r16 fis'' 4.. -\tenuto r32 fis'' 4 r32 
                % warning: bar too short, padding with rests
                % 61440 + 3600 < 65280  &&  15/16 < 4/4
                r16  |
                \skip 8 e'' 4 fis'' 8. fis'' 4.. -\tenuto 
                % warning: overlong bar truncated here |
                \skip 16 r16 r8 a'' 4.. -\tenuto fis'' 8 -\tenuto r16 fis'' 8 -\tenuto 
                % warning: overlong bar truncated here |
%% 20
                \skip 4 \skip 8 r8 e'' 4 -\tenuto r16 fis'' 8. -\tenuto 
                % warning: overlong bar truncated here |
                \skip 16 r16 a'' 2. b'' 8 -\tenuto 
                % warning: overlong bar truncated here |
                \skip 4 \skip 8 r8 d''' 2 
                % warning: overlong bar truncated here |
                \skip 4 b'' 4 -\tenuto d''' -\tenuto r16 fis''' 8. -\tenuto 
                % warning: overlong bar truncated here |
                \skip 4 r16 e''' 2 -\tenuto r8 
                % warning: bar too short, padding with rests
                % 88320 + 3600 < 92160  &&  15/16 < 4/4
                r16  |
%% 25
                b'' 2 -\tenuto r8 a'' 4. -\tenuto 
                % warning: overlong bar truncated here |
                \skip 8 r8 r16 fis'' 2 -\tenuto r16 r e'' -\tenuto 
                % warning: overlong bar truncated here |
                \skip 8 \skip 16 r16 fis'' 4. -\tenuto a'' -\tenuto 
                % warning: overlong bar truncated here |
                \skip 4 \skip 8 fis'' 2 -\tenuto r32 e'' 16. -\tenuto 
                % warning: overlong bar truncated here |
                \skip 8 fis'' 2 -\tenuto r8 a'' 4 -\tenuto 
                % warning: overlong bar truncated here |
%% 30
                \skip 4 r16 fis'' 2 r16 fis'' 8 -\tenuto  |
                fis'' 4 e'' fis'' 8. fis'' 4 -\tenuto 
                % warning: overlong bar truncated here |
                \skip 8 \skip 16 r16 a'' 2 -\tenuto r4  |
                g'' 4 -\tenuto r16 fis'' 4 -\tenuto r16 r8 a'' 4 -\tenuto 
                % warning: overlong bar truncated here |
                \skip 8 b'' 4. -\tenuto ees''' fis''' 8 -\tenuto 
                % warning: overlong bar truncated here |
%% 35
                \skip 8 r8 c'''' 4 < b''' c'''' > -\tenuto-\staccato a'''  |
                fis''' 1 -\tenuto  |
                e''' 4. -\tenuto b'' 2 -\tenuto r8  |
                b'' 2 -\tenuto r16 a'' 4 b'' 8. -\tenuto 
                % warning: overlong bar truncated here |
                \skip 4 r16 d''' 8 -\tenuto d''' 2 
                % warning: bar too short, padding with rests
                % 145920 + 3600 < 149760  &&  15/16 < 4/4
                r16  |
%% 40
                r32 b'' 16. -\tenuto a'' 8 -\tenuto b'' 2 -\tenuto r8 r16 a'' -\tenuto 
                % warning: overlong bar truncated here |
                \skip 4 g'' 4 -\tenuto r16 fis'' 4. 
                % warning: overlong bar truncated here
                % warning: bar too short, padding with rests
                % 153600 + 3600 < 157440  &&  15/16 < 4/4
                r16  |
                \skip 4 \skip 8 ees'' 4. e'' 4 -\tenuto  |
                r16 fis'' 2 -\tenuto r16 r8 b'' 4 -\tenuto  |
                r8 a'' 4 -\tenuto r16 b'' 2 -\tenuto r16  |
%% 45
                r8 fis''' 4 -\tenuto r16 e''' 4 -\tenuto r16 d''' 4 -\tenuto 
                % warning: overlong bar truncated here |
                \skip 4 r4 b'' -\tenuto r16 a'' 8. -\tenuto 
                % warning: overlong bar truncated here |
                \skip 8 \skip 16 r16 b'' 4. -\tenuto fis'' 4 -\tenuto r8  |
                fis'' 4. -\tenuto ees''' 4 -\tenuto r16 ees''' 4 -\tenuto r16  |
                b'' 4. d''' 4.. -\tenuto b'' 8. 
                % warning: overlong bar truncated here |
%% 50
                \skip 8 \skip 16 r16 b'' 4. -\tenuto a'' -\tenuto  |
                fis'' 2 a'' 4.. -\tenuto r16  |
                fis'' 2 -\tenuto r8 r16 e'' 4 -\tenuto 
                % warning: overlong bar truncated here |
                \skip 8 a'' 4.. fis'' -\tenuto 
                % warning: overlong bar truncated here |
                \skip 4 r16 fis'' 4 e'' -\tenuto fis'' 8 
                % warning: overlong bar truncated here
                % warning: bar too short, padding with rests
                % 203520 + 3600 < 207360  &&  15/16 < 4/4
                r16  |
%% 55
                \skip 8 fis'' 2. -\tenuto r8  |
                b'' 2 -\tenuto r8 r16 fis'' 4 -\tenuto 
                % warning: overlong bar truncated here |
                \skip 2 r16 e'' 4 
                % warning: overlong bar truncated here
                % warning: bar too short, padding with rests
                % 215040 + 3120 < 218880  &&  13/16 < 4/4
                r16 r8  |
                \skip 8 \skip 16 fis'' 2 -\tenuto r16 r8 fis'' -\tenuto 
                % warning: overlong bar truncated here |
                \skip 4 \skip 8 e'' 4 e'' 4. -\tenuto 
                % warning: overlong bar truncated here |
%% 60
                \skip 2 g'' 4 -\tenuto r8 
                % warning: bar too short, padding with rests
                % 226560 + 3360 < 230400  &&  7/8 < 4/4
                r8  |
                g'' 4. -\tenuto fis'' 4 -\tenuto r8 fis'' 4 -\tenuto 
                % warning: overlong bar truncated here |
                \skip 8 e'' 4. e'' 2 -\tenuto 
                % warning: overlong bar truncated here |
                \skip 4 r8 b'' 2 -\tenuto r8  |
                e'' 2. -\tenuto fis'' 4 
                % warning: overlong bar truncated here |
%% 65
                \skip 2 \skip 4 e'' 4 -\tenuto 
                % warning: overlong bar truncated here |
                \skip 2 \skip 4 r4  |
                r2 r8 b' 4. -\tenuto 
                % warning: overlong bar truncated here |
                \skip 2 fis' 4. -\tenuto 
                % warning: overlong bar truncated here
                % warning: bar too short, padding with rests
                % 257280 + 3360 < 261120  &&  7/8 < 4/4
                r8  |
                \skip 2 r8 r4 
                % warning: bar too short, padding with rests
                % 261120 + 3360 < 264960  &&  7/8 < 4/4
                r8  |
%% 70
                e' 1 -\tenuto 
                % warning: overlong bar truncated here |
                \skip 4 \skip 8 \skip 16 \skip 32 
                % warning: bar too short, padding with rests
                % 268800 + 1800 < 272640  &&  15/32 < 4/4
                r32 r2  |
                \skip 8 
                % warning: bar too short, padding with rests
                % 272640 + 480 < 276480  &&  1/8 < 4/4
                r8 r4 r2  |
                R1  |
                \bar "|."
            } % Voice

            % End of segment Flute 2 (recorded)

            % End voice 0
        >> % Staff ends

    >> % notes

    \layout {
        indent = 3.0\cm
        short-indent = 1.5\cm
        \context { \Staff \RemoveEmptyStaves }
        \context { \GrandStaff \accepts "Lyrics" }
    }
%     uncomment to enable generating midi file from the lilypond source
%         \midi {
%         } 
} % score
