#!/bin/bash
set -e
set +x

if ! test -d debian; then
	echo run outside of the debian directory
	exit 1
fi

echo "1. preparing debian/changelog ..."

sed '/^ --/q' debian/changelog > debian/changelog.rocm
head -n1 debian/changelog.rocm > debian/changelog.rocm.head
tail -n1 debian/changelog.rocm > debian/changelog.rocm.tail
rm debian/changelog.rocm

truncate --size 0 debian/changelog

sed -e 's/pytorch/pytorch-rocm/' debian/changelog.rocm.head >> debian/changelog
rm debian/changelog.rocm.head

echo "" >> debian/changelog
echo "  * Rebuild src:pytorch with ROCM enabled." >> debian/changelog
echo "    Due to non-free B-D, section is changed from main to contrib." >> debian/changelog
echo "  * Automatically generated by src:pytorch :: debian/rocmbuild.sh" >> debian/changelog
echo "    Please always merge the changes to the rocm variant back to" >> debian/changelog
echo "    src:pytorch, thanks." >> debian/changelog
echo "" >> debian/changelog

cat debian/changelog.rocm.tail >> debian/changelog
rm debian/changelog.rocm.tail

echo "2. switching debian/control to the rocm version ..."

ln -sf control.rocm debian/control

echo "3. Maintainer notes are shown below"

echo --------------------------------------------------------------------------
echo You can revert the changes using git checkout
echo --------------------------------------------------------------------------
echo Copy the source package of src:pytorch as the source package of
echo src:pytorch-rocm if sbuild cannot find it. PLS use the identical source.
echo --------------------------------------------------------------------------
