// Created on: 2000-05-11
// Created by: data exchange team
// Copyright (c) 2000-2014 OPEN CASCADE SAS
//
// This file is part of Open CASCADE Technology software library.
//
// This library is free software; you can redistribute it and/or modify it under
// the terms of the GNU Lesser General Public License version 2.1 as published
// by the Free Software Foundation, with special exception defined in the file
// OCCT_LGPL_EXCEPTION.txt. Consult the file LICENSE_LGPL_21.txt included in OCCT
// distribution for complete text of the license and disclaimer of any warranty.
//
// Alternatively, this file may be used under the terms of Open CASCADE
// commercial license or contractual agreement.

// Generator:	ExpToCas (EXPRESS -> CASCADE/XSTEP Translator) V1.1

#include <StepBasic_CharacterizedObject.hxx>
#include <TCollection_HAsciiString.hxx>

IMPLEMENT_STANDARD_RTTIEXT(StepBasic_CharacterizedObject, Standard_Transient)

//=================================================================================================

StepBasic_CharacterizedObject::StepBasic_CharacterizedObject()
{
  defDescription = Standard_False;
}

//=================================================================================================

void StepBasic_CharacterizedObject::Init(const Handle(TCollection_HAsciiString)& aName,
                                         const Standard_Boolean                  hasDescription,
                                         const Handle(TCollection_HAsciiString)& aDescription)
{
  theName = aName;

  defDescription = hasDescription;
  if (defDescription)
  {
    theDescription = aDescription;
  }
  else
    theDescription.Nullify();
}

//=================================================================================================

Handle(TCollection_HAsciiString) StepBasic_CharacterizedObject::Name() const
{
  return theName;
}

//=================================================================================================

void StepBasic_CharacterizedObject::SetName(const Handle(TCollection_HAsciiString)& aName)
{
  theName = aName;
}

//=================================================================================================

Handle(TCollection_HAsciiString) StepBasic_CharacterizedObject::Description() const
{
  return theDescription;
}

//=================================================================================================

void StepBasic_CharacterizedObject::SetDescription(
  const Handle(TCollection_HAsciiString)& aDescription)
{
  theDescription = aDescription;
}

//=================================================================================================

Standard_Boolean StepBasic_CharacterizedObject::HasDescription() const
{
  return defDescription;
}
