import textwrap

import pytest

from debputy.lsp.debputy_ls import DebputyLanguageServer
from debputy.lsp.lsp_test_support import (
    resolved_semantic_token,
    resolve_semantic_tokens,
)
from debputy.lsprotocol.types import (
    TextDocumentIdentifier,
    SemanticTokensParams,
)

try:
    from debputy.lsp.languages.lsp_debian_patches_series import (
        _debian_patches_semantic_tokens_full,
        _debian_patches_series_completions,
    )

    from pygls.server import LanguageServer
except ImportError:
    pass
from lsp_tests.lsp_tutil import (
    put_doc_no_cursor,
)


@pytest.mark.asyncio
async def test_dpatches_series_semantic_tokens(ls: "DebputyLanguageServer") -> None:
    doc_uri = "file:///nowhere/debian/patches/series"
    content = textwrap.dedent(
        """\
        # Some leading comment

        some.patch

        another-delta.diff # foo
"""
    )
    put_doc_no_cursor(
        ls,
        doc_uri,
        "debian/patches/series",
        content,
    )

    lines = content.splitlines(keepends=True)
    semantic_tokens = await _debian_patches_semantic_tokens_full(
        ls,
        SemanticTokensParams(TextDocumentIdentifier(doc_uri)),
    )
    resolved_semantic_tokens = resolve_semantic_tokens(lines, semantic_tokens)
    assert resolved_semantic_tokens is not None
    assert resolved_semantic_tokens == [
        resolved_semantic_token(0, 0, "# Some leading comment", "comment"),
        resolved_semantic_token(2, 0, "some.patch", "string"),
        resolved_semantic_token(4, 0, "another-delta.diff", "string"),
        resolved_semantic_token(4, len("another-delta.diff") + 1, "# foo", "comment"),
    ]
