// show how to add descriptions with classes and functions
// using @doc; descriptions added in this manner are associatd
// with respective classes and functions and will appear in the
// .help() runtime info mechanism, as well as in documentation
// generated using CKDoc.
//
// requires: chuck-1.5.4.5 or higher

// add inline documenation (processed at compile-time)
// (@doc must appear right before the class definition)
@doc "this is a description for the class Foo"
class Foo
{
    // add inline documenation (processed at compile-time)
    // (@doc must appear immediately before the function definition)
    @doc "a function in Foo, bar() likes calling his friends"
    fun void bar()
    {
        beth();
        kenny();
    }

    // add inline documenation (processed at compile-time)
    @doc "beth() is working on a novel about shared memory"
    fun static void beth()
    { }

    // add inline documenation (processed at compile-time)
    @doc "kenny() is fun, and expects nothing in return"
    fun static void kenny()
    { }

    // add inline documentation for variable
    @doc "this here is a variable called varFoo"
    5 => int varFoo;

    // add inline documentation for variable
    @doc "this here is a static variable called varBar"
    10 => static int varBar;

    // add inline documentation for variable (but hide it)
    @doc "(hidden) this variable is documented but hidden from ckdoc"
    15 => static int varBarHidden;
}

// print runtime info about Foo...
// (will also appear in documentation generated by CKDoc)
<<< CKDoc.describe( Foo ) >>>;
<<< CKDoc.describe( Foo.beth ) >>>;
<<< CKDoc.describe( Foo.kenny ) >>>;

// with an instance, can also get info about instanced functions
Foo f;
<<< CKDoc.describe( f ) >>>;
<<< CKDoc.describe( f.bar ) >>>;

// print the ckdoc for Foo
Foo.help();
