/*******************************************************************************
Copyright (C) 2017 Marvell International Ltd.

This software file (the "File") is owned and distributed by Marvell
International Ltd. and/or its affiliates ("Marvell") under the following
alternative licensing terms.  Once you have made an election to distribute the
File under one of the following license alternatives, please (i) delete this
introductory statement regarding license alternatives, (ii) delete the three
license alternatives that you have not elected to use and (iii) preserve the
Marvell copyright notice above.

********************************************************************************
Marvell Commercial License Option

If you received this File from Marvell and you have entered into a commercial
license agreement (a "Commercial License") with Marvell, the File is licensed
to you under the terms of the applicable Commercial License.

********************************************************************************
Marvell GPL License Option

This program is free software: you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by the Free
Software Foundation, either version 2 of the License, or any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.

********************************************************************************
Marvell GNU General Public License FreeRTOS Exception

If you received this File from Marvell, you may opt to use, redistribute and/or
modify this File in accordance with the terms and conditions of the Lesser
General Public License Version 2.1 plus the following FreeRTOS exception.
An independent module is a module which is not derived from or based on
FreeRTOS.
Clause 1:
Linking FreeRTOS statically or dynamically with other modules is making a
combined work based on FreeRTOS. Thus, the terms and conditions of the GNU
General Public License cover the whole combination.
As a special exception, the copyright holder of FreeRTOS gives you permission
to link FreeRTOS with independent modules that communicate with FreeRTOS solely
through the FreeRTOS API interface, regardless of the license terms of these
independent modules, and to copy and distribute the resulting combined work
under terms of your choice, provided that:
1. Every copy of the combined work is accompanied by a written statement that
details to the recipient the version of FreeRTOS used and an offer by yourself
to provide the FreeRTOS source code (including any modifications you may have
made) should the recipient request it.
2. The combined work is not itself an RTOS, scheduler, kernel or related
product.
3. The independent modules add significant and primary functionality to
FreeRTOS and do not merely extend the existing functionality already present in
FreeRTOS.
Clause 2:
FreeRTOS may not be used for any competitive or comparative purpose, including
the publication of any form of run time or compile time metric, without the
express permission of Real Time Engineers Ltd. (this is the norm within the
industry and is intended to ensure information accuracy).

********************************************************************************
Marvell BSD License Option

If you received this File from Marvell, you may opt to use, redistribute and/or
modify this File under the following licensing terms.
Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

	* Redistributions of source code must retain the above copyright notice,
	  this list of conditions and the following disclaimer.

	* Redistributions in binary form must reproduce the above copyright
	  notice, this list of conditions and the following disclaimer in the
	  documentation and/or other materials provided with the distribution.

	* Neither the name of Marvell nor the names of its contributors may be
	  used to endorse or promote products derived from this software without
	  specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

*******************************************************************************/

#ifndef _SNPS_MAILBOX_H_
#define _SNPS_MAILBOX_H_

/* #define FULL_MAIL_BOX_1D */
/* #define FULL_MAIL_BOX_2D */

/* MailBox Dictionary for one_d_messages training stage */
static const struct mail_box_stream_message one_d_messages[] = {
	{0x0  , 	0x1,	 LOG_LEVEL_30,	{"PMU1:prbsGenCtl:", "HEX", " \n"} },
#if defined(FULL_MAIL_BOX_1D)
	{0x1  , 	0x0,	 LOG_LEVEL_30,	{"PMU1: loading 2D acsm sequence\n"} },
	{0x2  , 	0x0,	 LOG_LEVEL_30,	{"PMU1: loading 1D acsm sequence\n"} },
	{0x3  , 	0x2,	 LOG_LEVEL_30,	{"PMU3: ", "INT", "  memclocks @ ", "INT", "  to get half of 300ns\n"} },
	{0x4  , 	0x0,	 LOG_LEVEL_30,	{"PMU: Error: User requested MPR read pattern for read DQS training in DDR3 Mode\n"} },
	{0x5  , 	0x0,	 LOG_LEVEL_30,	{"PMU3: Running 1D search for left eye edge\n"} },
	{0x6  , 	0x1,	 LOG_LEVEL_30,	{"PMU1: In Phase Left Edge Search cs ", "INT", " \n"} },
	{0x7  , 	0x1,	 LOG_LEVEL_30,	{"PMU1: Out of Phase Left Edge Search cs ", "INT", " \n"} },
	{0x8  , 	0x0,	 LOG_LEVEL_30,	{"PMU3: Running 1D search for right eye edge\n"} },
	{0x9  , 	0x1,	 LOG_LEVEL_30,	{"PMU1: In Phase Right Edge Search cs ", "INT", " \n"} },
	{0xa  , 	0x1,	 LOG_LEVEL_30,	{"PMU1: Out of Phase Right Edge Search cs ", "INT", " \n"} },
	{0xb  , 	0x1,	 LOG_LEVEL_30,	{"PMU1: mxRdLat training pstate ", "INT", " \n"} },
	{0xc  , 	0x1,	 LOG_LEVEL_30,	{"PMU1: mxRdLat search for cs ", "INT", " \n"} },
	{0xd  , 	0x1,	 LOG_LEVEL_30,	{"PMU0: MaxRdLat non consistant DtsmLoThldXingInd ", "HEX", " \n"} },
	{0xe  , 	0x3,	 LOG_LEVEL_30,	{"PMU4: CS ", "INT", "  Dbyte ", "INT", "  worked with DFIMRL = ", "INT", "  DFICLKs \n"} },
	{0xf  , 	0x4,	 LOG_LEVEL_30,	{"PMU3: MaxRdLat Read Lane err mask for csn ", "INT", " , DFIMRL ", "INT", "  DFIClks, dbyte ", "INT", "  = ", "HEX", " \n"} },
	{0x10 , 	0x3,	 LOG_LEVEL_30,	{"PMU3: MaxRdLat Read Lane err mask for csn ", "INT", "  DFIMRL ", "INT", " , All dbytes = ", "HEX", " \n"} },
	{0x11 , 	0x1,	 LOG_LEVEL_30,	{"PMU: Error: CS", "INT", "  failed to find a DFIMRL setting that worked for all bytes during MaxRdLat training\n"} },
	{0x12 , 	0x2,	 LOG_LEVEL_30,	{"PMU3: Smallest passing DFIMRL for all dbytes in CS", "INT", "  = ", "INT", "  DFIClks\n"} },
	{0x13 , 	0x0,	 LOG_LEVEL_30,	{"PMU: Error: No passing DFIMRL value found for any chip select during MaxRdLat training\n"} },
	{0x14 , 	0x3,	 LOG_LEVEL_30,	{"PMU: Error: Dbyte ", "INT", "  lane ", "INT", "  txDqDly passing region is too small (width = ", "INT", " )\n"} },
	{0x15 , 	0x0,	 LOG_LEVEL_30,	{"PMU4: TxDqDly Passing Regions (EyeLeft EyeRight -> EyeCenter) Units=1/32 UI\n"} },
	{0x16 , 	0x5,	 LOG_LEVEL_30,	{"PMU4: DB ", "INT", "  Lane ", "INT", " : ", "INT", "  ", "INT", "  -> ", "INT", " \n"} },
	{0x17 , 	0x2,	 LOG_LEVEL_30,	{"PMU2: TXDQ delayLeft[", "INT", " ] = ", "INT", "  (DISCONNECTED)\n"} },
	{0x18 , 	0x4,	 LOG_LEVEL_30,	{"PMU2: TXDQ delayLeft[", "INT", " ] = ", "INT", "  oopScaled = ", "INT", "  selectOop ", "INT", " \n"} },
	{0x19 , 	0x2,	 LOG_LEVEL_30,	{"PMU2: TXDQ delayRight[", "INT", " ] = ", "INT", "  (DISCONNECTED)\n"} },
	{0x1a , 	0x4,	 LOG_LEVEL_30,	{"PMU2: TXDQ delayRight[", "INT", " ] = ", "INT", "  oopScaled = ", "INT", "  selectOop ", "INT", " \n"} },
	{0x1b , 	0x3,	 LOG_LEVEL_30,	{"PMU: Error: Dbyte ", "INT", "  lane ", "INT", "  txDqDly passing region is too small (width = ", "INT", " )\n"} },
	{0x1c , 	0x0,	 LOG_LEVEL_30,	{"PMU4: TxDqDly Passing Regions (EyeLeft EyeRight -> EyeCenter) Units=1/32 UI\n"} },
	{0x1d , 	0x2,	 LOG_LEVEL_30,	{"PMU4: DB ", "INT", "  Lane ", "INT", " : (DISCONNECTED)\n"} },
	{0x1e , 	0x5,	 LOG_LEVEL_30,	{"PMU4: DB ", "INT", "  Lane ", "INT", " : ", "INT", "  ", "INT", "  -> ", "INT", " \n"} },
	{0x1f , 	0x2,	 LOG_LEVEL_30,	{"PMU3: Running 1D search csn ", "INT", "  for DM Right/NotLeft(", "INT", " ) eye edge\n"} },
	{0x20 , 	0x2,	 LOG_LEVEL_30,	{"PMU3: WrDq DM byte", "INT", "  with Errcnt ", "INT", " \n"} },
	{0x21 , 	0x2,	 LOG_LEVEL_30,	{"PMU3: WrDq DM byte", "INT", "  avgDly ", "HEX", " \n"} },
	{0x22 , 	0x2,	 LOG_LEVEL_30,	{"PMU1: WrDq DM byte", "INT", "  with Errcnt ", "INT", " \n"} },
	{0x23 , 	0x1,	 LOG_LEVEL_30,	{"PMU: Error: Dbyte ", "INT", "  txDqDly DM training did not start inside the eye\n"} },
	{0x24 , 	0x0,	 LOG_LEVEL_30,	{"PMU4: DM TxDqDly Passing Regions (EyeLeft EyeRight -> EyeCenter) Units=1/32 UI\n"} },
	{0x25 , 	0x2,	 LOG_LEVEL_30,	{"PMU4: DB ", "INT", "  Lane ", "INT", " : (DISCONNECTED)\n"} },
	{0x26 , 	0x5,	 LOG_LEVEL_30,	{"PMU4: DB ", "INT", "  Lane ", "INT", " : ", "INT", "  ", "INT", "  -> ", "INT", " \n"} },
	{0x27 , 	0x3,	 LOG_LEVEL_30,	{"PMU: Error: Dbyte ", "INT", "  lane ", "INT", "  txDqDly DM passing region is too small (width = ", "INT", " )\n"} },
	{0x28 , 	0x4,	 LOG_LEVEL_30,	{"PMU3: Errcnt for MRD/MWD search nib ", "INT", "  delay = (", "INT", " , ", "HEX", " ) = ", "INT", " \n"} },
	{0x29 , 	0x0,	 LOG_LEVEL_30,	{"PMU3: Precharge all open banks\n"} },
	{0x2a , 	0x2,	 LOG_LEVEL_30,	{"PMU: Error: Dbyte ", "INT", "  nibble ", "INT", "  found mutliple working coarse delay setting for MRD/MWD\n"} },
	{0x2b , 	0x0,	 LOG_LEVEL_30,	{"PMU4: MRD Passing Regions (coarseVal, fineLeft fineRight -> fineCenter)\n"} },
	{0x2c , 	0x0,	 LOG_LEVEL_30,	{"PMU4: MRW Passing Regions (coarseVal, fineLeft fineRight -> fineCenter)\n"} },
	{0x2d , 	0x4,	 LOG_LEVEL_30,	{"PMU10: Warning: DB ", "INT", "  nibble ", "INT", "  has multiple working coarse delays, ", "INT", "  and ", "INT", " , choosing the smaller delay\n"} },
	{0x2e , 	0x3,	 LOG_LEVEL_30,	{"PMU: Error: Dbyte ", "INT", "  nibble ", "INT", "  MRD/MWD passing region is too small (width = ", "INT", " )\n"} },
	{0x2f , 	0x6,	 LOG_LEVEL_30,	{"PMU4: DB ", "INT", "  nibble ", "INT", " : ", "INT", " , ", "INT", "  ", "INT", "  -> ", "INT", " \n"} },
	{0x30 , 	0x2,	 LOG_LEVEL_30,	{"PMU1: Start MRD/nMWD ", "INT", "  for csn ", "INT", " \n"} },
	{0x31 , 	0x2,	 LOG_LEVEL_30,	{"PMU2: RXDQS delayLeft[", "INT", " ] = ", "INT", "  (DISCONNECTED)\n"} },
	{0x32 , 	0x6,	 LOG_LEVEL_30,	{"PMU2: RXDQS delayLeft[", "INT", " ] = ", "INT", "  delayOop[", "INT", " ] = ", "INT", "  OopScaled ", "INT", " , selectOop ", "INT", " \n"} },
	{0x33 , 	0x2,	 LOG_LEVEL_30,	{"PMU2: RXDQS delayRight[", "INT", " ] = ", "INT", "  (DISCONNECTED)\n"} },
	{0x34 , 	0x6,	 LOG_LEVEL_30,	{"PMU2: RXDQS delayRight[", "INT", " ] = ", "INT", "  delayOop[", "INT", " ] = ", "INT", "  OopScaled ", "INT", " , selectOop ", "INT", " \n"} },
	{0x35 , 	0x0,	 LOG_LEVEL_30,	{"PMU4: RxClkDly Passing Regions (EyeLeft EyeRight -> EyeCenter)\n"} },
	{0x36 , 	0x2,	 LOG_LEVEL_30,	{"PMU4: DB ", "INT", "  nibble ", "INT", " : (DISCONNECTED)\n"} },
	{0x37 , 	0x5,	 LOG_LEVEL_30,	{"PMU4: DB ", "INT", "  nibble ", "INT", " : ", "INT", "  ", "INT", "  -> ", "INT", " \n"} },
	{0x38 , 	0x3,	 LOG_LEVEL_30,	{"PMU: Error: Dbyte ", "INT", "  nibble ", "INT", "  rxClkDly passing region is too small (width = ", "INT", " )\n"} },
	{0x39 , 	0x2,	 LOG_LEVEL_30,	{"PMU0: goodbar = ", "INT", "  for RDWR_BLEN ", "INT", " \n"} },
	{0x3a , 	0x1,	 LOG_LEVEL_30,	{"PMU3: RxClkDly = ", "INT", " \n"} },
	{0x3b , 	0x5,	 LOG_LEVEL_30,	{"PMU0: db ", "INT", "  l ", "INT", "  absLane ", "INT", "  -> bottom ", "INT", "  top ", "INT", " \n"} },
	{0x3c , 	0x9,	 LOG_LEVEL_30,	{"PMU3: BYTE ", "INT", "  - ", "INT", "  ", "INT", "  ", "INT", "  ", "INT", "  ", "INT", "  ", "INT", "  ", "INT", "  ", "INT", " \n"} },
	{0x3d , 	0x2,	 LOG_LEVEL_30,	{"PMU: Error: dbyte ", "INT", "  lane ", "INT", " 's per-lane vrefDAC's had no passing region\n"} },
	{0x3e , 	0x4,	 LOG_LEVEL_30,	{"PMU0: db", "INT", "  l", "INT", "  - ", "INT", "  ", "INT", " \n"} },
	{0x3f , 	0x2,	 LOG_LEVEL_30,	{"PMU0: goodbar = ", "INT", "  for RDWR_BLEN ", "INT", " \n"} },
	{0x40 , 	0x4,	 LOG_LEVEL_30,	{"PMU3: db", "INT", "  l", "INT", "  saw ", "INT", "  issues at rxClkDly ", "INT", " \n"} },
	{0x41 , 	0x3,	 LOG_LEVEL_30,	{"PMU3: db", "INT", "  l", "INT", "  first saw a pass->fail edge at rxClkDly ", "INT", " \n"} },
	{0x42 , 	0x2,	 LOG_LEVEL_30,	{"PMU3: lane ", "INT", "  PBD = ", "INT", " \n"} },
	{0x43 , 	0x3,	 LOG_LEVEL_30,	{"PMU3: db", "INT", "  l", "INT", "  first saw a DBI pass->fail edge at rxClkDly ", "INT", " \n"} },
	{0x44 , 	0x3,	 LOG_LEVEL_30,	{"PMU2: db", "INT", "  l", "INT", "  already passed rxPBD = ", "INT", " \n"} },
	{0x45 , 	0x3,	 LOG_LEVEL_30,	{"PMU0: db", "INT", "  l", "INT", " , PBD = ", "INT", " \n"} },
	{0x46 , 	0x2,	 LOG_LEVEL_30,	{"PMU: Error: dbyte ", "INT", "  lane ", "INT", "  failed read deskew\n"} },
	{0x47 , 	0x3,	 LOG_LEVEL_30,	{"PMU1: Running lane deskew on pstate ", "INT", "  csn ", "INT", "  rdDBIEn ", "INT", " \n"} },
	{0x48 , 	0x0,	 LOG_LEVEL_30,	{"PMU: Error: Read deskew training has been requested, but csrMajorModeDbyte[2] is set\n"} },
	{0x49 , 	0x2,	 LOG_LEVEL_30,	{"PMU1: AcsmCsMapCtrl", "INT", "  ", "HEX", " \n"} },
	{0x4a , 	0x2,	 LOG_LEVEL_30,	{"PMU1: AcsmCsMapCtrl", "INT", "  ", "HEX", " \n"} },
	{0x4b , 	0x1,	 LOG_LEVEL_30,	{"PMU: Error: Wrong PMU image loaded. message Block DramType = ", "HEX", " , but image built for D3U Type\n"} },
	{0x4c , 	0x1,	 LOG_LEVEL_30,	{"PMU: Error: Wrong PMU image loaded. message Block DramType = ", "HEX", " , but image built for D3R Type\n"} },
	{0x4d , 	0x1,	 LOG_LEVEL_30,	{"PMU: Error: Wrong PMU image loaded. message Block DramType = ", "HEX", " , but image built for D4U Type\n"} },
	{0x4e , 	0x1,	 LOG_LEVEL_30,	{"PMU: Error: Wrong PMU image loaded. message Block DramType = ", "HEX", " , but image built for D4R Type\n"} },
	{0x4f , 	0x1,	 LOG_LEVEL_30,	{"PMU: Error: Wrong PMU image loaded. message Block DramType = ", "HEX", " , but image built for D4LR Type\n"} },
	{0x50 , 	0x0,	 LOG_LEVEL_30,	{"PMU: Error: Both 2t timing mode and ddr4 geardown mode specifed in the messageblock's PhyCfg and MR3 fields. Only one can be enabled\n"} },
	{0x51 , 	0x3,	 LOG_LEVEL_30,	{"PMU10: PHY TOTALS - NUM_DBYTES ", "INT", "  NUM_NIBBLES ", "INT", "  NUM_ANIBS ", "INT", " \n"} },
	{0x52 , 	0x6,	 LOG_LEVEL_30,	{"PMU10: CSA=", "HEX", " , CSB=", "HEX", " , TSTAGES=", "HEX", " , HDTOUT=", "INT", " , MMISC=", "INT", "  DRAMFreq=", "INT", " MT DramType=LPDDR3\n"} },
	{0x53 , 	0x6,	 LOG_LEVEL_30,	{"PMU10: CSA=", "HEX", " , CSB=", "HEX", " , TSTAGES=", "HEX", " , HDTOUT=", "INT", " , MMISC=", "INT", "  DRAMFreq=", "INT", " MT DramType=LPDDR4\n"} },
	{0x54 , 	0x8,	 LOG_LEVEL_30,	{"PMU10: CS=", "HEX", " , TSTAGES=", "HEX", " , HDTOUT=", "INT", " , 2T=", "INT", " , MMISC=", "INT", "  AddrMirror=", "INT", "  DRAMFreq=", "INT", " MT DramType=", "INT", " \n"} },
	{0x55 , 	0x4,	 LOG_LEVEL_30,	{"PMU10: Pstate", "INT", "  MR0=", "HEX", "  MR1=", "HEX", "  MR2=", "HEX", " \n"} },
	{0x56 , 	0x8,	 LOG_LEVEL_30,	{"PMU10: Pstate", "INT", "  MRS MR0=", "HEX", "  MR1=", "HEX", "  MR2=", "HEX", "  MR3=", "HEX", "  MR4=", "HEX", "  MR5=", "HEX", "  MR6=", "HEX", " \n"} },
	{0x57 , 	0x5,	 LOG_LEVEL_30,	{"PMU10: Pstate", "INT", "  MRS MR1_A0=", "HEX", "  MR2_A0=", "HEX", "  MR3_A0=", "HEX", "  MR11_A0=", "HEX", " \n"} },
	{0x58 , 	0x0,	 LOG_LEVEL_30,	{"PMU10: UseBroadcastMR set. All ranks and channels use MRXX_A0 for MR settings.\n"} },
	{0x59 , 	0x5,	 LOG_LEVEL_30,	{"PMU10: Pstate", "INT", "  MRS MR01_A0=", "HEX", "  MR02_A0=", "HEX", "  MR03_A0=", "HEX", "  MR11_A0=", "HEX", " \n"} },
	{0x5a , 	0x5,	 LOG_LEVEL_30,	{"PMU10: Pstate", "INT", "  MRS MR12_A0=", "HEX", "  MR13_A0=", "HEX", "  MR14_A0=", "HEX", "  MR22_A0=", "HEX", " \n"} },
	{0x5b , 	0x5,	 LOG_LEVEL_30,	{"PMU10: Pstate", "INT", "  MRS MR01_A1=", "HEX", "  MR02_A1=", "HEX", "  MR03_A1=", "HEX", "  MR11_A1=", "HEX", " \n"} },
	{0x5c , 	0x5,	 LOG_LEVEL_30,	{"PMU10: Pstate", "INT", "  MRS MR12_A1=", "HEX", "  MR13_A1=", "HEX", "  MR14_A1=", "HEX", "  MR22_A1=", "HEX", " \n"} },
	{0x5d , 	0x5,	 LOG_LEVEL_30,	{"PMU10: Pstate", "INT", "  MRS MR01_B0=", "HEX", "  MR02_B0=", "HEX", "  MR03_B0=", "HEX", "  MR11_B0=", "HEX", " \n"} },
	{0x5e , 	0x5,	 LOG_LEVEL_30,	{"PMU10: Pstate", "INT", "  MRS MR12_B0=", "HEX", "  MR13_B0=", "HEX", "  MR14_B0=", "HEX", "  MR22_B0=", "HEX", " \n"} },
	{0x5f , 	0x5,	 LOG_LEVEL_30,	{"PMU10: Pstate", "INT", "  MRS MR01_B1=", "HEX", "  MR02_B1=", "HEX", "  MR03_B1=", "HEX", "  MR11_B1=", "HEX", " \n"} },
	{0x60 , 	0x5,	 LOG_LEVEL_30,	{"PMU10: Pstate", "INT", "  MRS MR12_B1=", "HEX", "  MR13_B1=", "HEX", "  MR14_B1=", "HEX", "  MR22_B1=", "HEX", " \n"} },
	{0x61 , 	0x2,	 LOG_LEVEL_30,	{"PMU1: AcsmOdtCtrl", "INT", "  ", "HEX", " \n"} },
	{0x62 , 	0x2,	 LOG_LEVEL_30,	{"PMU1: AcsmCsMapCtrl", "INT", "  ", "HEX", " \n"} },
	{0x63 , 	0x2,	 LOG_LEVEL_30,	{"PMU1: AcsmCsMapCtrl", "INT", "  ", "HEX", " \n"} },
	{0x64 , 	0x0,	 LOG_LEVEL_30,	{"PMU1: HwtCAMode set\n"} },
	{0x65 , 	0x1,	 LOG_LEVEL_30,	{"PMU3: DDR4 infinite preamble enter/exit mode ", "INT", " \n"} },
	{0x66 , 	0x2,	 LOG_LEVEL_30,	{"PMU1: In rxenb_train() csn=", "INT", "  pstate=", "INT", " \n"} },
	{0x67 , 	0x0,	 LOG_LEVEL_30,	{"PMU3: Finding DQS falling edge\n"} },
	{0x68 , 	0x0,	 LOG_LEVEL_30,	{"PMU3: Searching for DDR3/LPDDR3/LPDDR4 read preamble\n"} },
	{0x69 , 	0x9,	 LOG_LEVEL_30,	{"PMU3: dtsm fails Even Nibbles : ", "HEX", "  ", "HEX", "  ", "HEX", "  ", "HEX", "  ", "HEX", "  ", "HEX", "  ", "HEX", "  ", "HEX", "  ", "HEX", " \n"} },
	{0x6a , 	0x9,	 LOG_LEVEL_30,	{"PMU3: dtsm fails Odd  Nibbles : ", "HEX", "  ", "HEX", "  ", "HEX", "  ", "HEX", "  ", "HEX", "  ", "HEX", "  ", "HEX", "  ", "HEX", "  ", "HEX", " \n"} },
	{0x6b , 	0x2,	 LOG_LEVEL_30,	{"PMU3: Preamble search pass=", "INT", "  anyfail=", "INT", " \n"} },
	{0x6c , 	0x0,	 LOG_LEVEL_30,	{"PMU: Error: RxEn training preamble not found\n"} },
	{0x6d , 	0x0,	 LOG_LEVEL_30,	{"PMU3: Found DQS pre-amble\n"} },
	{0x6e , 	0x1,	 LOG_LEVEL_30,	{"PMU: Error: Dbyte ", "INT", "  couldn't find the rising edge of DQS during RxEn Training\n"} },
	{0x6f , 	0x0,	 LOG_LEVEL_30,	{"PMU3: RxEn aligning to first rising edge of burst\n"} },
	{0x70 , 	0x1,	 LOG_LEVEL_30,	{"PMU3: Decreasing RxEn delay by ", "INT", "  fine step to allow full capture of reads\n"} },
	{0x71 , 	0x1,	 LOG_LEVEL_30,	{"PMU3: MREP Delay = ", "INT", " \n"} },
	{0x72 , 	0x3,	 LOG_LEVEL_30,	{"PMU3: Errcnt for MREP nib ", "INT", "  delay = ", "INT", "  is ", "INT", " \n"} },
	{0x73 , 	0x2,	 LOG_LEVEL_30,	{"PMU3: MREP nibble ", "INT", "  sampled a 1 at data buffer delay ", "INT", " \n"} },
	{0x74 , 	0x2,	 LOG_LEVEL_30,	{"PMU3: MREP nibble ", "INT", "  saw a 0 to 1 transition at data buffer delay ", "INT", " \n"} },
	{0x75 , 	0x0,	 LOG_LEVEL_30,	{"PMU2:  MREP did not find a 0 to 1 transition for all nibbles. Assuming 0 delay was already in the passing region for failing nibbles\n"} },
	{0x76 , 	0x2,	 LOG_LEVEL_30,	{"PMU3: Training DIMM ", "INT", "  CSn ", "INT", " \n"} },
	{0x77 , 	0x1,	 LOG_LEVEL_30,	{"PMU3: exitCAtrain_lp3 cs ", "HEX", " \n"} },
	{0x78 , 	0x1,	 LOG_LEVEL_30,	{"PMU3: enterCAtrain_lp3 cs ", "HEX", " \n"} },
	{0x79 , 	0x1,	 LOG_LEVEL_30,	{"PMU3: CAtrain_switchmsb_lp3 cs ", "HEX", " \n"} },
	{0x7a , 	0x1,	 LOG_LEVEL_30,	{"PMU3: CATrain_rdwr_lp3 looking for pattern ", "HEX", " \n"} },
	{0x7b , 	0x0,	 LOG_LEVEL_30,	{"PMU3: exitCAtrain_lp4\n"} },
	{0x7c , 	0x1,	 LOG_LEVEL_30,	{"PMU3: DEBUG enterCAtrain_lp4 1: cs ", "HEX", " \n"} },
	{0x7d , 	0x1,	 LOG_LEVEL_30,	{"PMU3: DEBUG enterCAtrain_lp4 3: Put dbyte ", "INT", "  in async mode\n"} },
	{0x7e , 	0x0,	 LOG_LEVEL_30,	{"PMU3: DEBUG enterCAtrain_lp4 5: Send MR13 to turn on CA training\n"} },
	{0x7f , 	0x3,	 LOG_LEVEL_30,	{"PMU3: DEBUG enterCAtrain_lp4 7: idx = ", "INT", "  vref = ", "HEX", "  mr12 = ", "HEX", "  \n"} },
	{0x80 , 	0x1,	 LOG_LEVEL_30,	{"PMU3: CATrain_rdwr_lp4 looking for pattern ", "HEX", " \n"} },
	{0x81 , 	0x4,	 LOG_LEVEL_30,	{"PMU3: Phase ", "INT", "  CAreadbackA db:", "INT", "  ", "HEX", "  xo:", "HEX", " \n"} },
	{0x82 , 	0x4,	 LOG_LEVEL_30,	{"PMU3: Phase ", "INT", "  CAreadbackB db:", "INT", "  ", "HEX", "  xo:", "HEX", " \n"} },
	{0x83 , 	0x5,	 LOG_LEVEL_30,	{"PMU3: DEBUG lp4SetCatrVref 1: cs=", "INT", "  chan=", "INT", "  mr12=", "HEX", "  vref=", "INT", " .", "INT", " %%\n"} },
	{0x84 , 	0x3,	 LOG_LEVEL_30,	{"PMU3: DEBUG lp4SetCatrVref 3: mr12 = ", "HEX", "  send vref= ", "HEX", "  to db=", "INT", " \n"} },
	{0x85 , 	0x3,	 LOG_LEVEL_30,	{"PMU3: DEBUG lp4SetCatrVref 4: mr12= ", "HEX", "  send vref= ", "HEX", "  to db=", "INT", " \n"} },
	{0x86 , 	0x0,	 LOG_LEVEL_30,	{"PMU10:Optimizing vref\n"} },
	{0x87 , 	0x4,	 LOG_LEVEL_30,	{"PMU4:mr12:", "HEX", "  cs:", "INT", "  chan ", "INT", "  r:", "HEX", " \n"} },
	{0x88 , 	0x5,	 LOG_LEVEL_30,	{"PMU3: i:", "INT", "  bstr:", "INT", "  bsto:", "INT", "  st:", "INT", "  r:", "INT", " \n"} },
	{0x89 , 	0x2,	 LOG_LEVEL_30,	{"Failed to find sufficient CA Vref Passing Region for CS ", "INT", "  channel ", "INT", " \n"} },
	{0x8a , 	0x5,	 LOG_LEVEL_30,	{"PMU3:Found ", "INT", " .", "INT", " %% MR12:", "HEX", "  for cs:", "INT", "  chan ", "INT", " \n"} },
	{0x8b , 	0x2,	 LOG_LEVEL_30,	{"PMU3:Calculated ", "INT", "  for AtxImpedence from acx ", "INT", " .\n"} },
	{0x8c , 	0x0,	 LOG_LEVEL_30,	{"PMU3:CA Odt impedence ==0.  Use default vref.\n"} },
	{0x8d , 	0x3,	 LOG_LEVEL_30,	{"PMU3:Calculated ", "INT", " .", "INT", " %% for Vref MR12=", "HEX", " .\n"} },
	{0x8e , 	0x0,	 LOG_LEVEL_30,	{"PMU3: CAtrain_lp\n"} },
	{0x8f , 	0x0,	 LOG_LEVEL_30,	{"PMU3: CAtrain Begins.\n"} },
	{0x90 , 	0x1,	 LOG_LEVEL_30,	{"PMU3: CAtrain_lp testing dly ", "INT", " \n"} },
	{0x91 , 	0x1,	 LOG_LEVEL_30,	{"PMU5: CA bitmap dump for cs ", "HEX", " \n"} },
	{0x92 , 	0x1,	 LOG_LEVEL_30,	{"PMU5: CAA", "INT", "  "} },
	{0x93 , 	0x1,	 LOG_LEVEL_30,	{"", "HEX", " "} },
	{0x94 , 	0x0,	 LOG_LEVEL_30,	{"\n"} },
	{0x95 , 	0x1,	 LOG_LEVEL_30,	{"PMU5: CAB", "INT", "  "} },
	{0x96 , 	0x1,	 LOG_LEVEL_30,	{"", "HEX", " "} },
	{0x97 , 	0x0,	 LOG_LEVEL_30,	{"\n"} },
	{0x98 , 	0x3,	 LOG_LEVEL_30,	{"PMU3: anibi=", "INT", " , anibichan[anibi]=", "INT", "  ,chan=", "INT", " \n"} },
	{0x99 , 	0x1,	 LOG_LEVEL_30,	{"", "HEX", " "} },
	{0x9a , 	0x1,	 LOG_LEVEL_30,	{"\nPMU3:Raw CA setting :", "HEX", " "} },
	{0x9b , 	0x2,	 LOG_LEVEL_30,	{"\nPMU3:ATxDly setting:", "HEX", "  margin:", "INT", " \n"} },
	{0x9c , 	0x2,	 LOG_LEVEL_30,	{"\nPMU3:InvClk ATxDly setting:", "HEX", "  margin:", "INT", " \n"} },
	{0x9d , 	0x0,	 LOG_LEVEL_30,	{"\nPMU3:No Range found!\n"} },
	{0x9e , 	0x3,	 LOG_LEVEL_30,	{"PMU3: 2 anibi=", "INT", " , anibichan[anibi]=", "INT", "  ,chan=", "INT", " "} },
	{0x9f , 	0x2,	 LOG_LEVEL_30,	{"\nPMU3: no neg clock => CA setting anib=", "INT", " , :", "INT", " \n"} },
	{0xa0 , 	0x1,	 LOG_LEVEL_30,	{"PMU3:Normal margin:", "INT", " \n"} },
	{0xa1 , 	0x1,	 LOG_LEVEL_30,	{"PMU3:Inverted margin:", "INT", " \n"} },
	{0xa2 , 	0x0,	 LOG_LEVEL_30,	{"PMU3:Using Inverted clock\n"} },
	{0xa3 , 	0x0,	 LOG_LEVEL_30,	{"PMU3:Using normal clk\n"} },
	{0xa4 , 	0x3,	 LOG_LEVEL_30,	{"PMU3: 3 anibi=", "INT", " , anibichan[anibi]=", "INT", "  ,chan=", "INT", " \n"} },
	{0xa5 , 	0x2,	 LOG_LEVEL_30,	{"PMU3: Setting ATxDly for anib ", "HEX", "  to ", "HEX", " \n"} },
	{0xa6 , 	0x0,	 LOG_LEVEL_30,	{"PMU: Error: CA Training Failed.\n"} },
	{0xa7 , 	0x0,	 LOG_LEVEL_30,	{"PMU1: Writing MRs\n"} },
	{0xa8 , 	0x0,	 LOG_LEVEL_30,	{"PMU4:Using MR12 values from 1D CA VREF training.\n"} },
	{0xa9 , 	0x0,	 LOG_LEVEL_30,	{"PMU3:Writing all MRs to fsp 1\n"} },
	{0xaa , 	0x0,	 LOG_LEVEL_30,	{"PMU10:Lp4Quickboot mode.\n"} },
	{0xab , 	0x0,	 LOG_LEVEL_30,	{"PMU3: Writing MRs\n"} },
	{0xac , 	0x1,	 LOG_LEVEL_30,	{"PMU10: Setting boot clock divider to ", "INT", " \n"} },
	{0xad , 	0x0,	 LOG_LEVEL_30,	{"PMU3: Resetting DRAM\n"} },
	{0xae , 	0x0,	 LOG_LEVEL_30,	{"PMU3: setup for RCD initalization\n"} },
	{0xaf , 	0x0,	 LOG_LEVEL_30,	{"PMU3: pmu_exit_SR from dev_init()\n"} },
	{0xb0 , 	0x0,	 LOG_LEVEL_30,	{"PMU3: initializing RCD\n"} },
	{0xb1 , 	0x0,	 LOG_LEVEL_30,	{"PMU10: **** Executing 2D Image ****\n"} },
	{0xb2 , 	0x1,	 LOG_LEVEL_30,	{"PMU10: **** Start DDR4 Training. PMU Firmware Revision ", "HEX", "  ****\n"} },
	{0xb3 , 	0x1,	 LOG_LEVEL_30,	{"PMU10: **** Start DDR3 Training. PMU Firmware Revision ", "HEX", "  ****\n"} },
	{0xb4 , 	0x1,	 LOG_LEVEL_30,	{"PMU10: **** Start LPDDR3 Training. PMU Firmware Revision ", "HEX", "  ****\n"} },
	{0xb5 , 	0x1,	 LOG_LEVEL_30,	{"PMU10: **** Start LPDDR4 Training. PMU Firmware Revision ", "HEX", "  ****\n"} },
	{0xb6 , 	0x0,	 LOG_LEVEL_30,	{"PMU: Error: Mismatched internal revision between DCCM and ICCM images\n"} },
	{0xb7 , 	0x1,	 LOG_LEVEL_30,	{"PMU10: **** Testchip ", "INT", "  Specific Firmware ****\n"} },
	{0xb8 , 	0x0,	 LOG_LEVEL_30,	{"PMU1: LRDIMM with EncodedCS mode, one DIMM\n"} },
	{0xb9 , 	0x0,	 LOG_LEVEL_30,	{"PMU1: LRDIMM with EncodedCS mode, two DIMMs\n"} },
	{0xba , 	0x0,	 LOG_LEVEL_30,	{"PMU1: RDIMM with EncodedCS mode, one DIMM\n"} },
	{0xbb , 	0x0,	 LOG_LEVEL_30,	{"PMU2: Starting LRDIMM MREP training for all ranks\n"} },
	{0xbc , 	0x0,	 LOG_LEVEL_30,	{"PMU199: LRDIMM MREP training for all ranks completed\n"} },
	{0xbd , 	0x0,	 LOG_LEVEL_30,	{"PMU2: Starting LRDIMM DWL training for all ranks\n"} },
	{0xbe , 	0x0,	 LOG_LEVEL_30,	{"PMU199: LRDIMM DWL training for all ranks completed\n"} },
	{0xbf , 	0x0,	 LOG_LEVEL_30,	{"PMU2: Starting LRDIMM MRD training for all ranks\n"} },
	{0xc0 , 	0x0,	 LOG_LEVEL_30,	{"PMU199: LRDIMM MRD training for all ranks completed\n"} },
	{0xc1 , 	0x0,	 LOG_LEVEL_30,	{"PMU2: Starting RXEN training for all ranks\n"} },
	{0xc2 , 	0x0,	 LOG_LEVEL_30,	{"PMU2: Starting write leveling fine delay training for all ranks\n"} },
	{0xc3 , 	0x0,	 LOG_LEVEL_30,	{"PMU2: Starting LRDIMM MWD training for all ranks\n"} },
	{0xc4 , 	0x0,	 LOG_LEVEL_30,	{"PMU199: LRDIMM MWD training for all ranks completed\n"} },
	{0xc5 , 	0x0,	 LOG_LEVEL_30,	{"PMU2: Starting read deskew training\n"} },
	{0xc6 , 	0x0,	 LOG_LEVEL_30,	{"PMU2: Starting SI friendly 1d RdDqs training for all ranks\n"} },
	{0xc7 , 	0x0,	 LOG_LEVEL_30,	{"PMU2: Starting write leveling coarse delay training for all ranks\n"} },
	{0xc8 , 	0x0,	 LOG_LEVEL_30,	{"PMU2: Starting 1d WrDq training for all ranks\n"} },
	{0xc9 , 	0x0,	 LOG_LEVEL_30,	{"PMU2: Running DQS2DQ Oscillator for all ranks\n"} },
	{0xca , 	0x0,	 LOG_LEVEL_30,	{"PMU2: Starting 1d RdDqs training for all ranks\n"} },
	{0xcb , 	0x0,	 LOG_LEVEL_30,	{"PMU2: Starting MaxRdLat training\n"} },
	{0xcc , 	0x0,	 LOG_LEVEL_30,	{"PMU2: Redoing LRDIMM MREP training for all ranks\n"} },
	{0xcd , 	0x0,	 LOG_LEVEL_30,	{"PMU199: LRDIMM MREP training for all ranks completed\n"} },
	{0xce , 	0x0,	 LOG_LEVEL_30,	{"PMU2: Redoing LRDIMM DWL training for all ranks\n"} },
	{0xcf , 	0x0,	 LOG_LEVEL_30,	{"PMU199: LRDIMM DWL training for all ranks completed\n"} },
	{0xd0 , 	0x0,	 LOG_LEVEL_30,	{"PMU2: Redoing LRDIMM MRD training for all ranks\n"} },
	{0xd1 , 	0x0,	 LOG_LEVEL_30,	{"PMU199: LRDIMM MRD training for all ranks completed\n"} },
	{0xd2 , 	0x0,	 LOG_LEVEL_30,	{"PMU2: Redoing LRDIMM MWD training for all ranks\n"} },
	{0xd3 , 	0x0,	 LOG_LEVEL_30,	{"PMU199: LRDIMM MWD training for all ranks completed\n"} },
	{0xd4 , 	0x0,	 LOG_LEVEL_30,	{"PMU2: Starting 2d RdDqs training for all ranks\n"} },
	{0xd5 , 	0x0,	 LOG_LEVEL_30,	{"PMU2: Starting 2d WrDq training for all ranks\n"} },
	{0xd6 , 	0x2,	 LOG_LEVEL_30,	{"PMU3:read_fifo ", "HEX", "  ", "HEX", " \n"} },
	{0xd7 , 	0x1,	 LOG_LEVEL_30,	{"PMU: Error: Invalid PhyDrvImpedance of ", "HEX", "  specified in message block.\n"} },
	{0xd8 , 	0x1,	 LOG_LEVEL_30,	{"PMU: Error: Invalid PhyOdtImpedance of ", "HEX", "  specified in message block.\n"} },
	{0xd9 , 	0x1,	 LOG_LEVEL_30,	{"PMU: Error: Invalid BPZNResVal of ", "HEX", "  specified in message block.\n"} },
	{0xda , 	0x5,	 LOG_LEVEL_30,	{"PMU3: fixRxEnBackOff csn:", "INT", "  db:", "INT", "  dn:", "INT", "  bo:", "INT", "  dly:", "HEX", " \n"} },
	{0xdb , 	0x1,	 LOG_LEVEL_30,	{"PMU3: fixRxEnBackOff dly:", "HEX", " \n"} },
	{0xdc , 	0x0,	 LOG_LEVEL_30,	{"PMU3: Entering setupPpt\n"} },
	{0xdd , 	0x0,	 LOG_LEVEL_30,	{"PMU3: Start lp4PopulateHighLowBytes\n"} },
	{0xde , 	0x2,	 LOG_LEVEL_30,	{"PMU3:Dbyte Detect: db", "INT", "  received ", "HEX", " \n"} },
	{0xdf , 	0x2,	 LOG_LEVEL_30,	{"PMU3:getDqs2Dq read ", "HEX", "  from dbyte ", "INT", " \n"} },
	{0xe0 , 	0x2,	 LOG_LEVEL_30,	{"PMU3:getDqs2Dq(2) read ", "HEX", "  from dbyte ", "INT", " \n"} },
	{0xe1 , 	0x1,	 LOG_LEVEL_30,	{"PMU: Error: Dbyte ", "INT", "  read 0 from the DQS oscillator it is connected to\n"} },
	{0xe2 , 	0x2,	 LOG_LEVEL_30,	{"PMU4: Dbyte ", "INT", "  dqs2dq = ", "INT", " /32 UI\n"} },
	{0xe3 , 	0x3,	 LOG_LEVEL_30,	{"PMU3:getDqs2Dq set dqs2dq:", "INT", " /32 ui (", "INT", "  ps) from dbyte ", "INT", " \n"} },
	{0xe4 , 	0x3,	 LOG_LEVEL_30,	{"PMU3: Setting coarse delay in AtxDly chiplet ", "INT", "  from ", "HEX", "  to ", "HEX", "  \n"} },
	{0xe5 , 	0x3,	 LOG_LEVEL_30,	{"PMU3: Clearing coarse delay in AtxDly chiplet ", "INT", "  from ", "HEX", "  to ", "HEX", "  \n"} },
	{0xe6 , 	0x0,	 LOG_LEVEL_30,	{"PMU3: Performing DDR4 geardown sync sequence\n"} },
	{0xe7 , 	0x0,	 LOG_LEVEL_30,	{"PMU1: Enter self refresh\n"} },
	{0xe8 , 	0x0,	 LOG_LEVEL_30,	{"PMU1: Exit self refresh\n"} },
	{0xe9 , 	0x0,	 LOG_LEVEL_30,	{"PMU: Error: No dbiEnable with lp4\n"} },
	{0xea , 	0x0,	 LOG_LEVEL_30,	{"PMU: Error: No dbiDisable with lp4\n"} },
	{0xeb , 	0x1,	 LOG_LEVEL_30,	{"PMU1: DDR4 update Rx DBI Setting disable ", "INT", " \n"} },
	{0xec , 	0x1,	 LOG_LEVEL_30,	{"PMU1: DDR4 update 2nCk WPre Setting disable ", "INT", " \n"} },
	{0xed , 	0x5,	 LOG_LEVEL_30,	{"PMU1: read_delay: db", "INT", "  lane", "INT", "  delays[", "INT", " ] = ", "HEX", "  (max ", "HEX", " )\n"} },
	{0xee , 	0x1,	 LOG_LEVEL_30,	{"PMU5: ID=", "INT", "  -- db0  db1  db2  db3  db4  db5  db6  db7  db8  db9 --\n"} },
	{0xef , 	0xb,	 LOG_LEVEL_30,	{"PMU5: [", "INT", " ]:0x ", "HEX", "  ", "HEX", "  ", "HEX", "  ", "HEX", "  ", "HEX", "  ", "HEX", "  ", "HEX", "  ", "HEX", "  ", "HEX", "  ", "HEX", " \n"} },
	{0xf0 , 	0x3,	 LOG_LEVEL_30,	{"PMU2: dump delays - pstate=", "INT", "  dimm=", "INT", "  csn=", "INT", " \n"} },
	{0xf1 , 	0x0,	 LOG_LEVEL_30,	{"PMU3: Printing Mid-Training Delay Information\n"} },
	{0xf2 , 	0x1,	 LOG_LEVEL_30,	{"PMU5: CS", "INT", "  <<KEY>> 0 TrainingCntr <<KEY>> coarse(15:10) fine(9:0)\n"} },
	{0xf3 , 	0x1,	 LOG_LEVEL_30,	{"PMU5: CS", "INT", "  <<KEY>> 0 RxEnDly, 1 RxClkDly <<KEY>> coarse(10:6) fine(5:0)\n"} },
	{0xf4 , 	0x1,	 LOG_LEVEL_30,	{"PMU5: CS", "INT", "  <<KEY>> 0 TxDqsDly, 1 TxDqDly <<KEY>> coarse(9:6) fine(5:0)\n"} },
	{0xf5 , 	0x1,	 LOG_LEVEL_30,	{"PMU5: CS", "INT", "  <<KEY>> 0 RxPBDly <<KEY>> 1 Delay Unit ~= 7ps \n"} },
	{0xf6 , 	0x0,	 LOG_LEVEL_30,	{"PMU5: all CS <<KEY>> 0 DFIMRL <<KEY>> Units = DFI clocks\n"} },
	{0xf7 , 	0x0,	 LOG_LEVEL_30,	{"PMU5: all CS <<KEY>> VrefDACs <<KEY>> DAC(6:0)\n"} },
	{0xf8 , 	0x0,	 LOG_LEVEL_30,	{"PMU1: Set DMD in MR13 and wrDBI in MR3 for training\n"} },
	{0xf9 , 	0x0,	 LOG_LEVEL_30,	{"PMU: Error: getMaxRxen() failed to find largest rxen nibble delay\n"} },
	{0xfa , 	0x3,	 LOG_LEVEL_30,	{"PMU2: getMaxRxen(): maxDly ", "INT", "  maxTg ", "INT", "  maxNib ", "INT", " \n"} },
	{0xfb , 	0x3,	 LOG_LEVEL_30,	{"PMU2: getRankMaxRxen(): maxDly ", "INT", "  Tg ", "INT", "  maxNib ", "INT", " \n"} },
	{0xfc , 	0x0,	 LOG_LEVEL_30,	{"PMU1: skipping CDD calculation in 2D image\n"} },
	{0xfd , 	0x1,	 LOG_LEVEL_30,	{"PMU3: Calculating CDDs for pstate ", "INT", " \n"} },
	{0xfe , 	0x3,	 LOG_LEVEL_30,	{"PMU3: rxDly[", "INT", " ][", "INT", " ] = ", "INT", " \n"} },
	{0xff , 	0x3,	 LOG_LEVEL_30,	{"PMU3: txDly[", "INT", " ][", "INT", " ] = ", "INT", " \n"} },
	{0x100, 	0x3,	 LOG_LEVEL_30,	{"PMU3: allFine CDD_RR_", "INT", " _", "INT", "  = ", "INT", " \n"} },
	{0x101, 	0x3,	 LOG_LEVEL_30,	{"PMU3: allFine CDD_WW_", "INT", " _", "INT", "  = ", "INT", " \n"} },
	{0x102, 	0x3,	 LOG_LEVEL_30,	{"PMU3: CDD_RR_", "INT", " _", "INT", "  = ", "INT", " \n"} },
	{0x103, 	0x3,	 LOG_LEVEL_30,	{"PMU3: CDD_WW_", "INT", " _", "INT", "  = ", "INT", " \n"} },
	{0x104, 	0x3,	 LOG_LEVEL_30,	{"PMU3: allFine CDD_RW_", "INT", " _", "INT", "  = ", "INT", " \n"} },
	{0x105, 	0x3,	 LOG_LEVEL_30,	{"PMU3: allFine CDD_WR_", "INT", " _", "INT", "  = ", "INT", " \n"} },
	{0x106, 	0x3,	 LOG_LEVEL_30,	{"PMU3: CDD_RW_", "INT", " _", "INT", "  = ", "INT", " \n"} },
	{0x107, 	0x3,	 LOG_LEVEL_30,	{"PMU3: CDD_WR_", "INT", " _", "INT", "  = ", "INT", " \n"} },
	{0x108, 	0x4,	 LOG_LEVEL_30,	{"PMU3: F", "INT", " BC2x_B", "INT", " _D", "INT", "  = ", "HEX", " \n"} },
	{0x109, 	0x4,	 LOG_LEVEL_30,	{"PMU3: F", "INT", " BC3x_B", "INT", " _D", "INT", "  = ", "HEX", " \n"} },
	{0x10a, 	0x4,	 LOG_LEVEL_30,	{"PMU3: F", "INT", " BC4x_B", "INT", " _D", "INT", "  = ", "HEX", " \n"} },
	{0x10b, 	0x4,	 LOG_LEVEL_30,	{"PMU3: F", "INT", " BC5x_B", "INT", " _D", "INT", "  = ", "HEX", " \n"} },
	{0x10c, 	0x4,	 LOG_LEVEL_30,	{"PMU3: F", "INT", " BC8x_B", "INT", " _D", "INT", "  = ", "HEX", " \n"} },
	{0x10d, 	0x4,	 LOG_LEVEL_30,	{"PMU3: F", "INT", " BC9x_B", "INT", " _D", "INT", "  = ", "HEX", " \n"} },
	{0x10e, 	0x4,	 LOG_LEVEL_30,	{"PMU3: F", "INT", " BCAx_B", "INT", " _D", "INT", "  = ", "HEX", " \n"} },
	{0x10f, 	0x4,	 LOG_LEVEL_30,	{"PMU3: F", "INT", " BCBx_B", "INT", " _D", "INT", "  = ", "HEX", " \n"} },
	{0x110, 	0x1,	 LOG_LEVEL_30,	{"PMU1: enter_lp3: DEBUG: pstate = ", "INT", " \n"} },
	{0x111, 	0x1,	 LOG_LEVEL_30,	{"PMU1: enter_lp3: DEBUG: dfifreqxlat_pstate = ", "INT", " \n"} },
	{0x112, 	0x1,	 LOG_LEVEL_30,	{"PMU1: enter_lp3: DEBUG: pllbypass = ", "INT", " \n"} },
	{0x113, 	0x1,	 LOG_LEVEL_30,	{"PMU1: enter_lp3: DEBUG: forcecal = ", "INT", " \n"} },
	{0x114, 	0x1,	 LOG_LEVEL_30,	{"PMU1: enter_lp3: DEBUG: pllmaxrange = ", "HEX", " \n"} },
	{0x115, 	0x1,	 LOG_LEVEL_30,	{"PMU1: enter_lp3: DEBUG: dacval_out = ", "HEX", " \n"} },
	{0x116, 	0x1,	 LOG_LEVEL_30,	{"PMU1: enter_lp3: DEBUG: pllctrl3 = ", "HEX", " \n"} },
	{0x117, 	0x0,	 LOG_LEVEL_30,	{"PMU3: Loading DRAM with BIOS supplied MR values and entering self refresh prior to exiting PMU code.\n"} },
	{0x118, 	0x2,	 LOG_LEVEL_30,	{"PMU3: Setting DataBuffer function space of dimmcs ", "HEX", "  to ", "INT", " \n"} },
	{0x119, 	0x2,	 LOG_LEVEL_30,	{"PMU4: Setting RCW FxRC", "HEX", " x = ", "HEX", " \n"} },
	{0x11a, 	0x2,	 LOG_LEVEL_30,	{"PMU4: Setting RCW FxRC", "HEX", "  = ", "HEX", " \n"} },
	{0x11b, 	0x1,	 LOG_LEVEL_30,	{"PMU1: DDR4 update Rd Pre Setting disable ", "INT", " \n"} },
	{0x11c, 	0x2,	 LOG_LEVEL_30,	{"PMU2: Setting BCW FxBC", "HEX", " x = ", "HEX", " \n"} },
	{0x11d, 	0x2,	 LOG_LEVEL_30,	{"PMU2: Setting BCW BC", "HEX", "  = ", "HEX", " \n"} },
	{0x11e, 	0x2,	 LOG_LEVEL_30,	{"PMU2: Setting BCW PBA mode FxBC", "HEX", " x = ", "HEX", " \n"} },
	{0x11f, 	0x2,	 LOG_LEVEL_30,	{"PMU2: Setting BCW PBA mode BC", "HEX", "  = ", "HEX", " \n"} },
	{0x120, 	0x3,	 LOG_LEVEL_30,	{"PMU4: BCW value for dimm ", "INT", " , fspace ", "INT", " , addr ", "HEX", " \n"} },
	{0x121, 	0x2,	 LOG_LEVEL_30,	{"PMU4: DB ", "INT", " , value ", "HEX", " \n"} },
	{0x122, 	0x0,	 LOG_LEVEL_30,	{"PMU6: WARNING MREP underflow, set to min value -2 coarse, 0 fine\n"} },
	{0x123, 	0x4,	 LOG_LEVEL_30,	{"PMU6: LRDIMM Writing final data buffer fine delay value nib ", "INT", " , trainDly ", "INT", " , fineDly code ", "INT", " , new MREP fine ", "INT", " \n"} },
	{0x124, 	0x3,	 LOG_LEVEL_30,	{"PMU6: LRDIMM Writing final data buffer fine delay value nib ", "INT", " , trainDly ", "INT", " , fineDly code ", "INT", " \n"} },
	{0x125, 	0x3,	 LOG_LEVEL_30,	{"PMU6: LRDIMM Writing data buffer fine delay type ", "INT", "  nib ", "INT", " , code ", "INT", " \n"} },
	{0x126, 	0x2,	 LOG_LEVEL_30,	{"PMU6: Writing final data buffer coarse delay value dbyte ", "INT", " , coarse = ", "HEX", " \n"} },
	{0x127, 	0x3,	 LOG_LEVEL_30,	{"PMU4: data ", "HEX", "  at MB addr ", "HEX", "  saved at CSR addr ", "HEX", " \n"} },
	{0x128, 	0x3,	 LOG_LEVEL_30,	{"PMU4: data ", "HEX", "  at MB addr ", "HEX", "  restored from CSR addr ", "HEX", " \n"} },
	{0x129, 	0x3,	 LOG_LEVEL_30,	{"PMU4: data ", "HEX", "  at MB addr ", "HEX", "  saved at CSR addr ", "HEX", " \n"} },
	{0x12a, 	0x3,	 LOG_LEVEL_30,	{"PMU4: data ", "HEX", "  at MB addr ", "HEX", "  restored from CSR addr ", "HEX", " \n"} },
	{0x12b, 	0x1,	 LOG_LEVEL_30,	{"PMU3: Update BC00, BC01, BC02 for rank-dimm ", "HEX", " \n"} },
	{0x12c, 	0x0,	 LOG_LEVEL_30,	{"PMU3: Writing D4 RDIMM RCD Control words F0RC00 -> F0RC0F\n"} },
	{0x12d, 	0x0,	 LOG_LEVEL_30,	{"PMU3: Disable parity in F0RC0E\n"} },
	{0x12e, 	0x0,	 LOG_LEVEL_30,	{"PMU3: Writing D4 Data buffer Control words BC00 -> BC0E\n"} },
	{0x12f, 	0x2,	 LOG_LEVEL_30,	{"PMU1: setAltCL Sending MR0 ", "HEX", "  cl=", "INT", " \n"} },
	{0x130, 	0x2,	 LOG_LEVEL_30,	{"PMU1: restoreFromAltCL Sending MR0 ", "HEX", "  cl=", "INT", " \n"} },
	{0x131, 	0x2,	 LOG_LEVEL_30,	{"PMU1: restoreAcsmFromAltCL Sending MR0 ", "HEX", "  cl=", "INT", " \n"} },
	{0x132, 	0x2,	 LOG_LEVEL_30,	{"PMU2: Setting D3R RC", "INT", "  = ", "HEX", " \n"} },
	{0x133, 	0x0,	 LOG_LEVEL_30,	{"PMU3: Writing D3 RDIMM RCD Control words RC0 -> RC11\n"} },
	{0x134, 	0x2,	 LOG_LEVEL_30,	{"PMU0: VrefDAC0/1 vddqStart ", "INT", "  dacToVddq ", "INT", " \n"} },
	{0x135, 	0x1,	 LOG_LEVEL_30,	{"PMU: Error: Messageblock phyVref=", "HEX", "  is above the limit for TSMC28's attenuated LPDDR4 receivers. Please see the pub databook\n"} },
	{0x136, 	0x1,	 LOG_LEVEL_30,	{"PMU: Error: Messageblock phyVref=", "HEX", "  is above the limit for TSMC28's attenuated DDR4 receivers. Please see the pub databook\n"} },
	{0x137, 	0x1,	 LOG_LEVEL_30,	{"PMU0: PHY VREF @ (", "INT", " /1000) VDDQ\n"} },
	{0x138, 	0x2,	 LOG_LEVEL_30,	{"PMU0: initalizing phy vrefDacs to ", "INT", "  ExtVrefRange ", "HEX", " \n"} },
	{0x139, 	0x2,	 LOG_LEVEL_30,	{"PMU0: initalizing global vref to ", "INT", "  range ", "INT", " \n"} },
	{0x13a, 	0x2,	 LOG_LEVEL_30,	{"PMU4: Setting initial device vrefDQ for CS", "INT", "  to MR6 = ", "HEX", " \n"} },
	{0x13b, 	0x3,	 LOG_LEVEL_30,	{"PMU1: In write_level_fine() csn=", "INT", "  dimm=", "INT", "  pstate=", "INT", " \n"} },
	{0x13c, 	0x0,	 LOG_LEVEL_30,	{"PMU3: Fine write leveling hardware search increasing TxDqsDly until full bursts are seen\n"} },
	{0x13d, 	0x0,	 LOG_LEVEL_30,	{"PMU3: Exiting write leveling mode\n"} },
	{0x13e, 	0x1,	 LOG_LEVEL_30,	{"PMU3: got ", "INT", "  for cl in load_wrlvl_acsm\n"} },
	{0x13f, 	0x3,	 LOG_LEVEL_30,	{"PMU1: In write_level_coarse() csn=", "INT", "  dimm=", "INT", "  pstate=", "INT", " \n"} },
	{0x140, 	0x3,	 LOG_LEVEL_30,	{"PMU3: left eye edge search db:", "INT", "  ln:", "INT", "  dly:", "HEX", " \n"} },
	{0x141, 	0x3,	 LOG_LEVEL_30,	{"PMU3: right eye edge search db:", "INT", "  ln:", "INT", "  dly:", "HEX", " \n"} },
	{0x142, 	0x4,	 LOG_LEVEL_30,	{"PMU3: eye center db:", "INT", "  ln:", "INT", "  dly:", "HEX", "  (maxdq:", "HEX", " )\n"} },
	{0x143, 	0x3,	 LOG_LEVEL_30,	{"PMU3: Wrote to TxDqDly db:", "INT", "  ln:", "INT", "  dly:", "HEX", " \n"} },
	{0x144, 	0x3,	 LOG_LEVEL_30,	{"PMU3: Wrote to TxDqDly db:", "INT", "  ln:", "INT", "  dly:", "HEX", " \n"} },
	{0x145, 	0x2,	 LOG_LEVEL_30,	{"PMU3: Coarse write leveling dbyte", "INT", "  is still failing for TxDqsDly=", "HEX", " \n"} },
	{0x146, 	0x2,	 LOG_LEVEL_30,	{"PMU4: Coarse write leveling iteration ", "INT", "  saw ", "INT", "  data miscompares across the entire phy\n"} },
	{0x147, 	0x0,	 LOG_LEVEL_30,	{"PMU: Error: Failed write leveling coarse\n"} },
	{0x148, 	0x1,	 LOG_LEVEL_30,	{"PMU3: got ", "INT", "  for cl in load_wrlvl_acsm\n"} },
	{0x149, 	0x3,	 LOG_LEVEL_30,	{"PMU3: In write_level_coarse() csn=", "INT", "  dimm=", "INT", "  pstate=", "INT", " \n"} },
	{0x14a, 	0x3,	 LOG_LEVEL_30,	{"PMU3: left eye edge search db:", "INT", "  ln:", "INT", "  dly:", "HEX", " \n"} },
	{0x14b, 	0x3,	 LOG_LEVEL_30,	{"PMU3: right eye edge search db: ", "INT", "  ln: ", "INT", "  dly: ", "HEX", " \n"} },
	{0x14c, 	0x4,	 LOG_LEVEL_30,	{"PMU3: eye center db: ", "INT", "  ln: ", "INT", "  dly: ", "HEX", "  (maxdq: ", "HEX", " )\n"} },
	{0x14d, 	0x3,	 LOG_LEVEL_30,	{"PMU3: Wrote to TxDqDly db: ", "INT", "  ln: ", "INT", "  dly: ", "HEX", " \n"} },
	{0x14e, 	0x3,	 LOG_LEVEL_30,	{"PMU3: Wrote to TxDqDly db: ", "INT", "  ln: ", "INT", "  dly: ", "HEX", " \n"} },
	{0x14f, 	0x2,	 LOG_LEVEL_30,	{"PMU3: Coarse write leveling nibble", "INT", "  is still failing for TxDqsDly=", "HEX", " \n"} },
	{0x150, 	0x2,	 LOG_LEVEL_30,	{"PMU4: Coarse write leveling iteration ", "INT", "  saw ", "INT", "  data miscompares across the entire phy\n"} },
	{0x151, 	0x0,	 LOG_LEVEL_30,	{"PMU: Error: Failed write leveling coarse\n"} },
	{0x152, 	0x3,	 LOG_LEVEL_30,	{"PMU3: In write_level_coarse() csn=", "INT", "  dimm=", "INT", "  pstate=", "INT", " \n"} },
	{0x153, 	0x5,	 LOG_LEVEL_30,	{"PMU2: Write level: dbyte ", "INT", "  nib", "INT", "  dq/dmbi ", "INT", "  dqsfine ", "HEX", "  dqDly ", "HEX", " \n"} },
	{0x154, 	0x2,	 LOG_LEVEL_30,	{"PMU3: Coarse write leveling nibble", "INT", "  is still failing for TxDqsDly=", "HEX", " \n"} },
	{0x155, 	0x2,	 LOG_LEVEL_30,	{"PMU4: Coarse write leveling iteration ", "INT", "  saw ", "INT", "  data miscompares across the entire phy\n"} },
	{0x156, 	0x0,	 LOG_LEVEL_30,	{"PMU: Error: Failed write leveling coarse\n"} },
	{0x157, 	0x1,	 LOG_LEVEL_30,	{"PMU3: DWL delay = ", "INT", " \n"} },
	{0x158, 	0x3,	 LOG_LEVEL_30,	{"PMU3: Errcnt for DWL nib ", "INT", "  delay = ", "INT", "  is ", "INT", " \n"} },
	{0x159, 	0x2,	 LOG_LEVEL_30,	{"PMU3: DWL nibble ", "INT", "  sampled a 1 at delay ", "INT", " \n"} },
	{0x15a, 	0x3,	 LOG_LEVEL_30,	{"PMU3: DWL nibble ", "INT", "  passed at delay ", "INT", " . Rising edge was at ", "INT", " \n"} },
	{0x15b, 	0x0,	 LOG_LEVEL_30,	{"PMU2: DWL did nto find a rising edge of memclk for all nibbles. Failing nibbles assumed to have rising edge at fine delay 63\n"} },
	{0x400, 	0x0,	 LOG_LEVEL_30,	{"PMU: Error:Mailbox Buffer Overflowed.\n"} },
	{0x401, 	0x0,	 LOG_LEVEL_30,	{"PMU: Error:Mailbox Buffer Overflowed.\n"} },
	{0x402, 	0x0,	 LOG_LEVEL_30,	{"PMU: ***** Assertion Error - terminating *****\n"} },
	{0x403, 	0x2,	 LOG_LEVEL_30,	{"PMU1: swapByte db ", "INT", "  by ", "INT", " \n"} },
	{0x404, 	0x3,	 LOG_LEVEL_30,	{"PMU3: get_cmd_dly max(", "INT", "  ps, ", "INT", "  memclk) = ", "INT", " \n"} },
	{0x405, 	0x2,	 LOG_LEVEL_30,	{"PMU0: Write CSR ", "HEX", "  ", "HEX", " \n"} },
	{0x406, 	0x2,	 LOG_LEVEL_30,	{"PMU0: hwt_init_ppgc_prbs(): Polynomial: ", "HEX", " , Deg: ", "INT", " \n"} },
	{0x407, 	0x1,	 LOG_LEVEL_30,	{"PMU: Error: acsm_set_cmd to non existant instruction adddress ", "INT", " \n"} },
	{0x408, 	0x1,	 LOG_LEVEL_30,	{"PMU: Error: acsm_set_cmd with unknown ddr cmd ", "HEX", " \n"} },
	{0x409, 	0xc,	 LOG_LEVEL_30,	{"PMU1: acsm_addr ", "HEX", " , acsm_flgs ", "HEX", " , ddr_cmd ", "HEX", " , cmd_dly ", "HEX", " , ddr_addr ", "HEX", " , ddr_bnk ", "HEX", " , ddr_cs ", "HEX", " , cmd_rcnt ", "HEX", " , AcsmSeq0/1/2/3 ", "HEX", "  ", "HEX", "  ", "HEX", "  ", "HEX", " \n"} },
	{0x40a, 	0x0,	 LOG_LEVEL_30,	{"PMU: Error: Polling on ACSM done failed to complete in acsm_poll_done()...\n"} },
	{0x40b, 	0x0,	 LOG_LEVEL_30,	{"PMU1: acsm RUN\n"} },
	{0x40c, 	0x0,	 LOG_LEVEL_30,	{"PMU1: acsm STOPPED\n"} },
	{0x40d, 	0x2,	 LOG_LEVEL_30,	{"PMU1: acsm_init: acsm_mode ", "HEX", "  mxrdlat ", "HEX", " \n"} },
	{0x40e, 	0x2,	 LOG_LEVEL_30,	{"PMU: Error: setAcsmCLCWL: cl and cwl must be each >= 2 and 5, resp. CL=", "INT", "  CWL=", "INT", " \n"} },
	{0x40f, 	0x2,	 LOG_LEVEL_30,	{"PMU: Error: setAcsmCLCWL: cl and cwl must be each >= 5. CL=", "INT", "  CWL=", "INT", " \n"} },
	{0x410, 	0x2,	 LOG_LEVEL_30,	{"PMU1: setAcsmCLCWL: CASL ", "INT", "  WCASL ", "INT", " \n"} },
	{0x411, 	0x1,	 LOG_LEVEL_30,	{"PMU: Error: Reserved value of register F0RC0F found in message block: ", "HEX", " \n"} },
	{0x412, 	0x1,	 LOG_LEVEL_30,	{"PMU3: Written MRS to CS=", "HEX", " \n"} },
	{0x413, 	0x1,	 LOG_LEVEL_30,	{"PMU3: Written MRS to CS=", "HEX", " \n"} },
	{0x414, 	0x0,	 LOG_LEVEL_30,	{"PMU3: Entering Boot Freq Mode.\n"} },
	{0x415, 	0x1,	 LOG_LEVEL_30,	{"PMU: Error: Boot clock divider setting of ", "INT", "  is too small\n"} },
	{0x416, 	0x0,	 LOG_LEVEL_30,	{"PMU3: Exiting Boot Freq Mode.\n"} },
	{0x417, 	0x2,	 LOG_LEVEL_30,	{"PMU3: Writing MR", "INT", "  OP=", "HEX", " \n"} },
	{0x418, 	0x0,	 LOG_LEVEL_30,	{"PMU: Error: Delay too large in slomo\n"} },
	{0x419, 	0x1,	 LOG_LEVEL_30,	{"PMU3: Written MRS to CS=", "HEX", " \n"} },
	{0x41a, 	0x0,	 LOG_LEVEL_30,	{"PMU3: Enable Channel A\n"} },
	{0x41b, 	0x0,	 LOG_LEVEL_30,	{"PMU3: Enable Channel B\n"} },
	{0x41c, 	0x0,	 LOG_LEVEL_30,	{"PMU3: Enable All Channels\n"} },
	{0x41d, 	0x2,	 LOG_LEVEL_30,	{"PMU2: Use PDA mode to set MR", "INT", "  with value ", "HEX", " \n"} },
	{0x41e, 	0x1,	 LOG_LEVEL_30,	{"PMU3: Written Vref with PDA to CS=", "HEX", " \n"} },
	{0x41f, 	0x0,	 LOG_LEVEL_30,	{"PMU1: start_cal: DEBUG: setting CalRun to 1\n"} },
	{0x420, 	0x0,	 LOG_LEVEL_30,	{"PMU1: start_cal: DEBUG: setting CalRun to 0\n"} },
	{0x421, 	0x1,	 LOG_LEVEL_30,	{"PMU1: lock_pll_dll: DEBUG: pstate = ", "INT", " \n"} },
	{0x422, 	0x1,	 LOG_LEVEL_30,	{"PMU1: lock_pll_dll: DEBUG: dfifreqxlat_pstate = ", "INT", " \n"} },
	{0x423, 	0x1,	 LOG_LEVEL_30,	{"PMU1: lock_pll_dll: DEBUG: pllbypass = ", "INT", " \n"} },
	{0x424, 	0x1,	 LOG_LEVEL_30,	{"PMU3: SaveLcdlSeed: Saving seed seed ", "INT", " \n"} },
	{0x425, 	0x0,	 LOG_LEVEL_30,	{"PMU1: in phy_defaults()\n"} },
	{0x426, 	0x3,	 LOG_LEVEL_30,	{"PMU3: ACXConf:", "INT", "  MaxNumDbytes:", "INT", "  NumDfi:", "INT", " \n"} },
#endif
	{0x427, 	0x5,	 LOG_LEVEL_30,	{"PMU1: setAltAcsmCLCWL setting cl=", "INT", "  cwl=", "INT", " \n"} }
};

/* MailBox Dictionary for two_d_messages training stage */
static const struct mail_box_stream_message two_d_messages[] = {
	{0x0  , 	0x1,	 LOG_LEVEL_30,	{"PMU0: Converting ", "INT", "  into an MR\n"} },
#if defined(FULL_MAIL_BOX_2D)
	{0x1  , 	0x3,	 LOG_LEVEL_30,	{"PMU DEBUG: vref_idx ", "INT", "  -= ", "INT", " , range_idx = ", "INT", " \n"} },
	{0x2  , 	0x2,	 LOG_LEVEL_30,	{"PMU0: vrefIdx. Passing range ", "INT", " , remaining vrefidx = ", "INT", " \n"} },
	{0x3  , 	0x2,	 LOG_LEVEL_30,	{"PMU0: VrefIdx ", "INT", "  -> MR[6:0] ", "HEX", " \n"} },
	{0x4  , 	0x1,	 LOG_LEVEL_30,	{"PMU0: Converting MR ", "HEX", "  to vrefIdx\n"} },
	{0x5  , 	0x2,	 LOG_LEVEL_30,	{"PMU0: DAC ", "INT", "  Range ", "INT", " \n"} },
	{0x6  , 	0x3,	 LOG_LEVEL_30,	{"PMU0: Range ", "INT", " , Range_idx ", "INT", " , vref_idx offset ", "INT", "  \n"} },
	{0x7  , 	0x2,	 LOG_LEVEL_30,	{"PMU0: MR ", "HEX", "  -> VrefIdx ", "INT", " \n"} },
	{0x8  , 	0x1,	 LOG_LEVEL_30,	{"PMU: Error: Illegal timing group number ,", "INT", " , in getPtrVrefDq\n"} },
	{0x9  , 	0x3,	 LOG_LEVEL_30,	{"PMU1: VrefDqR", "INT", " Nib", "INT", "  = ", "INT", " \n"} },
	{0xa  , 	0x3,	 LOG_LEVEL_30,	{"PMU0: VrefDqR", "INT", " Nib", "INT", "  = ", "INT", " \n"} },
	{0xb  , 	0x0,	 LOG_LEVEL_30,	{"PMU0: ----------------MARGINS-------\n"} },
	{0xc  , 	0x2,	 LOG_LEVEL_30,	{"PMU0: R", "INT", " _RxClkDly_Margin = ", "INT", " \n"} },
	{0xd  , 	0x2,	 LOG_LEVEL_30,	{"PMU0: R", "INT", " _VrefDac_Margin = ", "INT", " \n"} },
	{0xe  , 	0x2,	 LOG_LEVEL_30,	{"PMU0: R", "INT", " _TxDqDly_Margin = ", "INT", " \n"} },
	{0xf  , 	0x2,	 LOG_LEVEL_30,	{"PMU0: R", "INT", " _DeviceVref_Margin = ", "INT", " \n"} },
	{0x10 , 	0x0,	 LOG_LEVEL_30,	{"PMU0: -----------------------\n"} },
	{0x11 , 	0x3,	 LOG_LEVEL_30,	{"PMU0: eye ", "INT", " 's for all TG's is [", "INT", "  ... ", "INT", " ]\n"} },
	{0x12 , 	0x0,	 LOG_LEVEL_30,	{"PMU0: ------- FFEmeasurements -----\n"} },
	{0x13 , 	0x2,	 LOG_LEVEL_30,	{"PMU0: FFE_weight ", "INT", "  @ drvStren ", "INT", " \n"} },
	{0x14 , 	0x1f,	 LOG_LEVEL_30,	{"PMU4: ", "INT", "  ", "INT", "  ", "INT", "  ", "INT", "  ", "INT", "  ", "INT", "  ", "INT", "  ", "INT", "  ", "INT", "  ", "INT", "  ", "INT", "  ", "INT", "  ", "INT", "  ", "INT", "  ", "INT", "  >", "INT", " < ", "INT", "  ", "INT", "  ", "INT", "  ", "INT", "  ", "INT", "  ", "INT", "  ", "INT", "  ", "INT", "  ", "INT", "  ", "INT", "  ", "INT", "  ", "INT", "  ", "INT", "  ", "INT", "  ", "INT", " \n"} },
	{0x15 , 	0x4,	 LOG_LEVEL_30,	{"PMU4: -- DB", "INT", "  L", "INT", "  -- centers: delay = ", "INT", " , voltage = ", "INT", "  \n"} },
	{0x16 , 	0x1,	 LOG_LEVEL_30,	{"PMU5: <<KEY>> 0 TxDqDlyTg", "INT", "  <<KEY>> coarse(6:6) fine(5:0)\n"} },
	{0x17 , 	0x1,	 LOG_LEVEL_30,	{"PMU5: <<KEY>> 0 messageBlock VrefDqR", "INT", "  <<KEY>> MR6(6:0)\n"} },
	{0x18 , 	0x1,	 LOG_LEVEL_30,	{"PMU5: <<KEY>> 0 RxClkDlyTg", "INT", "  <<KEY>> fine(5:0)\n"} },
	{0x19 , 	0x3,	 LOG_LEVEL_30,	{"PMU0: tgToCsn: tg ", "INT", "  + ", "HEX", "  -> csn ", "INT", " \n"} },
	{0x1a , 	0x2,	 LOG_LEVEL_30,	{"PMU: Error: LP4 rank ", "INT", "  cannot be mapped on tg ", "INT", " \n"} },
	{0x1b , 	0x2,	 LOG_LEVEL_30,	{"PMU3: Sending vref ", "INT", " ,  Mr = 0X", "HEX", " , to all devices\n"} },
	{0x1c , 	0x4,	 LOG_LEVEL_30,	{"PMU4: -------- ", "INT", " D Write Scanning TG ", "INT", "  (CS ", "HEX", " ) Lanes ", "HEX", "  --------\n"} },
	{0x1d , 	0x2,	 LOG_LEVEL_30,	{"PMU0: training lanes ", "HEX", "  using lanes ", "HEX", " \n"} },
	{0x1e , 	0x4,	 LOG_LEVEL_30,	{"PMU4: ------- ", "INT", " D Read Scanning TG ", "INT", "  (CS ", "HEX", " ) Lanes ", "HEX", "  -------\n"} },
	{0x1f , 	0x2,	 LOG_LEVEL_30,	{"PMU0: training lanes ", "HEX", "  using lanes ", "HEX", " \n"} },
	{0x20 , 	0x4,	 LOG_LEVEL_30,	{"PMU4: ------- ", "INT", " D Read Scanning TG ", "INT", "  (CS ", "HEX", " ) Lanes ", "HEX", "  -------\n"} },
	{0x21 , 	0x2,	 LOG_LEVEL_30,	{"PMU0: training lanes ", "HEX", "  using lanes ", "HEX", " \n"} },
	{0x22 , 	0x2,	 LOG_LEVEL_30,	{"PMU3: Sending vref ", "INT", " ,  Mr = 0X", "HEX", " , to all devices\n"} },
	{0x23 , 	0x4,	 LOG_LEVEL_30,	{"PMU4: -------- ", "INT", " D Write Scanning TG ", "INT", "  (CS ", "HEX", " ) Lanes ", "HEX", "  --------\n"} },
	{0x24 , 	0x2,	 LOG_LEVEL_30,	{"PMU4: Delay Stepsize = ", "INT", "  Fine, Voltage Stepsize = ", "INT", "  DAC\n"} },
	{0x25 , 	0x2,	 LOG_LEVEL_30,	{"PMU4: Delay Weight = ", "INT", " , Voltage Weight = ", "INT", " \n"} },
	{0x26 , 	0x3,	 LOG_LEVEL_30,	{"PMU0: raw ", "HEX", "  allFine ", "INT", "  incDec ", "INT", " "} },
	{0x27 , 	0x8,	 LOG_LEVEL_30,	{"PMU0: db", "INT", "  l", "INT", " , voltage ", "HEX", "  (u_r ", "INT", " ) delay ", "HEX", "  (u_r ", "INT", " ) - lcdl ", "INT", "  mask ", "HEX", " \n"} },
	{0x28 , 	0x5,	 LOG_LEVEL_30,	{"PMU0: DB", "INT", "  L", "INT", " , Eye ", "INT", " , Seed = (", "HEX", " , ", "HEX", " )\n"} },
	{0x29 , 	0x2,	 LOG_LEVEL_30,	{"PMU3: 2D Enables       : ", "INT", " ,                    1,                ", "INT", " \n"} },
	{0x2a , 	0x6,	 LOG_LEVEL_30,	{"PMU3: 2D Delay   Ranges: OOPL[", "HEX", " ,", "HEX", " ], IP[", "HEX", " ,", "HEX", " ], OOPR[", "HEX", " ,", "HEX", " ]\n"} },
	{0x2b , 	0x2,	 LOG_LEVEL_30,	{"PMU3: 2D Voltages      : ", "INT", "   ", "INT", " \n"} },
	{0x2c , 	0x1,	 LOG_LEVEL_30,	{"PMU0: input ", "INT", " \n"} },
	{0x2d , 	0x4,	 LOG_LEVEL_30,	{"PMU0: final: range ", "INT", "  center ", "INT", "  -> MIN ", "INT", "  MAX ", "INT", " \n"} },
	{0x2e , 	0x2,	 LOG_LEVEL_30,	{"DEBUG: min ", "INT", " , max ", "INT", " \n"} },
	{0x2f , 	0x2,	 LOG_LEVEL_30,	{"PMU0: seed 0 = (", "INT", " ,", "INT", " ) (center)\n"} },
	{0x30 , 	0x3,	 LOG_LEVEL_30,	{"PMU0: seed 1 = (", "INT", " ,", "INT", " ). edge at idx ", "INT", " \n"} },
	{0x31 , 	0x3,	 LOG_LEVEL_30,	{"PMU0: seed 2 = (", "INT", " ,", "INT", " ) edge at idx ", "INT", " \n"} },
	{0x32 , 	0x3,	 LOG_LEVEL_30,	{"PMU0: Search point ", "INT", "  = (", "INT", " ,", "INT", " )\n"} },
	{0x33 , 	0x5,	 LOG_LEVEL_30,	{"PMU0: YMARGIN: ^ ", "INT", " , - ", "INT", " , v ", "INT", " . rate ", "INT", "  = ", "INT", " \n"} },
	{0x34 , 	0x3,	 LOG_LEVEL_30,	{"PMU0: XMARGIN: center ", "INT", " , edge ", "INT", " . = ", "INT", " \n"} },
	{0x35 , 	0x2,	 LOG_LEVEL_30,	{"PMU0: ----------- weighting (", "INT", " ,", "INT", " ) ----------------\n"} },
	{0x36 , 	0x3,	 LOG_LEVEL_30,	{"PMU0: X margin - L ", "INT", "  R ", "INT", "  - Min ", "INT", " \n"} },
	{0x37 , 	0x3,	 LOG_LEVEL_30,	{"PMU0: Y margin - L ", "INT", "  R ", "INT", "  - Min ", "INT", " \n"} },
	{0x38 , 	0x3,	 LOG_LEVEL_30,	{"PMU0: center (", "INT", " ,", "INT", " ) weight = ", "INT", " \n"} },
	{0x39 , 	0x3,	 LOG_LEVEL_30,	{"PMU3: point ", "INT", "  starting at (", "INT", " ,", "INT", " )\n"} },
	{0x3a , 	0x0,	 LOG_LEVEL_30,	{"PMU1: local_max is 0, stop searching.\n"} },
	{0x3b , 	0x2,	 LOG_LEVEL_30,	{"PMU0: picking left (", "INT", "  == ", "INT", " )\n"} },
	{0x3c , 	0x2,	 LOG_LEVEL_30,	{"PMU0: picking right (", "INT", "  == ", "INT", " )\n"} },
	{0x3d , 	0x2,	 LOG_LEVEL_30,	{"PMU0: picking down (", "INT", "  == ", "INT", " )\n"} },
	{0x3e , 	0x2,	 LOG_LEVEL_30,	{"PMU0: picking up (", "INT", "  == ", "INT", " )\n"} },
	{0x3f , 	0x0,	 LOG_LEVEL_30,	{"PMU1: local_max is center, stop searching.\n"} },
	{0x40 , 	0x9,	 LOG_LEVEL_30,	{"PMU3: center (", "INT", " , ", "INT", " ) moving (%2i, %2i) -- L ", "INT", " , R ", "INT", " , C ", "INT", " , U ", "INT", " , D ", "INT", " \n"} },
	{0x41 , 	0x4,	 LOG_LEVEL_30,	{"PMU0: max iterations (", "INT", " ) reached. Final center (", "INT", " ,", "INT", " ), weight ", "INT", " \n"} },
	{0x42 , 	0x3,	 LOG_LEVEL_30,	{"PMU3: cordNum ", "INT", "  imporved ", "INT", "  to ", "INT", " \n"} },
	{0x43 , 	0x0,	 LOG_LEVEL_30,	{"PMU: Error: No passing region found for 1 or more lanes. Set hdtCtrl=4 to see passing regions\n"} },
	{0x44 , 	0x4,	 LOG_LEVEL_30,	{"PMU3: Optimal allFine Center (", "INT", " ,", "INT", " ), found in ", "INT", "  (center,left,right) region, with weight ", "INT", " .\n"} },
	{0x45 , 	0x3,	 LOG_LEVEL_30,	{"PMU0: merging lanes=", "INT", " ..", "INT", " , centerMerge_t ", "INT", " \n"} },
	{0x46 , 	0x1,	 LOG_LEVEL_30,	{"PMU0: laneVal ", "INT", "  is disable\n"} },
	{0x47 , 	0x2,	 LOG_LEVEL_30,	{"PMU0: checking common center ", "INT", "  against current center ", "INT", " \n"} },
	{0x48 , 	0x5,	 LOG_LEVEL_30,	{"PMU: Error: getCompoundEye Called on lane", "INT", "  eye with non-compatible (", "INT", "  delay, ", "INT", "  voltage) centers. ", "INT", "  != ", "INT", " \n"} },
	{0x49 , 	0x1,	 LOG_LEVEL_30,	{"PMU0: laneItr ", "INT", "  is disable\n"} },
	{0x4a , 	0x5,	 LOG_LEVEL_30,	{"PMU0: lane ", "INT", " , data_idx ", "INT", " , offset_idx ", "INT", " , = [", "INT", " ..", "INT", " ]\n"} },
	{0x4b , 	0x3,	 LOG_LEVEL_30,	{"PMU0: lane ", "INT", " , data_idx ", "INT", " , offset_idx ", "INT", " , offset_idx out of range!\n"} },
	{0x4c , 	0x3,	 LOG_LEVEL_30,	{"PMU0: mergeData[", "INT", " ] = max_v_low ", "INT", " , min_v_high ", "INT", " \n"} },
	{0x4d , 	0x5,	 LOG_LEVEL_30,	{"PMU1: writing merged center (", "INT", " ,", "INT", " ) back to dataBlock[", "INT", " ]. doDelay ", "INT", " , doVoltage ", "INT", " \n"} },
	{0x4e , 	0x5,	 LOG_LEVEL_30,	{"PMU0: applying relative (%i,%i) back to dataBlock[", "INT", " ]. doDelay ", "INT", " , doVoltage ", "INT", " \n"} },
	{0x4f , 	0x2,	 LOG_LEVEL_30,	{"PMU0: drvstren ", "HEX", "  is idx ", "INT", "  in the table\n"} },
	{0x50 , 	0x0,	 LOG_LEVEL_30,	{"PMU4: truncating FFE drive strength search range. Out of drive strengths to check.\n"} },
	{0x51 , 	0x2,	 LOG_LEVEL_30,	{"PMU5: Weak 1 changed to pull-up ", "INT", "  ohms, pull-down ", "INT", "  ohms\n"} },
	{0x52 , 	0x2,	 LOG_LEVEL_30,	{"PMU5: Weak 0 changed to pull-up ", "INT", "  ohms, pull-down ", "INT", "  ohms\n"} },
	{0x53 , 	0x3,	 LOG_LEVEL_30,	{"PMU0: dlyMargin L ", "INT", "  R ", "INT", " , min ", "INT", " \n"} },
	{0x54 , 	0x3,	 LOG_LEVEL_30,	{"PMU0: vrefMargin T ", "INT", "  B ", "INT", " , min ", "INT", " \n"} },
	{0x55 , 	0x2,	 LOG_LEVEL_30,	{"PMU3: new minimum VrefMargin (", "INT", "  < ", "INT", " ) recorded\n"} },
	{0x56 , 	0x2,	 LOG_LEVEL_30,	{"PMU3: new minimum DlyMargin (", "INT", "  < ", "INT", " ) recorded\n"} },
	{0x57 , 	0x0,	 LOG_LEVEL_30,	{"PMU0: RX finding the per-nibble, per-tg rxClkDly values\n"} },
	{0x58 , 	0x3,	 LOG_LEVEL_30,	{"PMU3: Merging collected eyes [", "INT", " ..", "INT", " ) and analyzing for nibble ", "INT", " 's optimal rxClkDly\n"} },
	{0x59 , 	0x0,	 LOG_LEVEL_30,	{"PMU0: dumping optimized eye\n"} },
	{0x5a , 	0x0,	 LOG_LEVEL_30,	{"PMU0: TX optimizing txDqDelays\n"} },
	{0x5b , 	0x1,	 LOG_LEVEL_30,	{"PMU3: Analyzing collected eye ", "INT", "  for a lane's optimal TxDqDly\n"} },
	{0x5c , 	0x1,	 LOG_LEVEL_30,	{"PMU0: eye-lane ", "INT", "  is disable\n"} },
	{0x5d , 	0x0,	 LOG_LEVEL_30,	{"PMU0: dumping optimized eye\n"} },
	{0x5e , 	0x0,	 LOG_LEVEL_30,	{"PMU0: TX optimizing device voltages\n"} },
	{0x5f , 	0x2,	 LOG_LEVEL_30,	{"PMU3: Merging collected eyes [", "INT", " ..", "INT", " ) and analyzing for optimal device txVref\n"} },
	{0x60 , 	0x0,	 LOG_LEVEL_30,	{"PMU0: dumping optimized eye\n"} },
	{0x61 , 	0x0,	 LOG_LEVEL_30,	{"PMU4: VrefDac (compound all TG) Bottom Top -> Center\n"} },
	{0x62 , 	0x5,	 LOG_LEVEL_30,	{"PMU4: DB", "INT", "  L", "INT", "    ", "INT", "    ", "INT", "   ->  ", "INT", "  (DISCONNECTED)\n"} },
	{0x63 , 	0x5,	 LOG_LEVEL_30,	{"PMU4: DB", "INT", "  L", "INT", "    ", "INT", "    ", "INT", "   ->  ", "INT", " \n"} },
	{0x64 , 	0x5,	 LOG_LEVEL_30,	{"PMU0: writing rxClkDelay for tg", "INT", "  db", "INT", "  nib", "INT", "  to ", "HEX", "  from eye[", "INT", " ] (DISCONNECTED)\n"} },
	{0x65 , 	0x3,	 LOG_LEVEL_30,	{"PMU: Error: Dbyte ", "INT", "  nibble ", "INT", " 's optimal rxClkDly of ", "HEX", "  is out of bounds\n"} },
	{0x66 , 	0x5,	 LOG_LEVEL_30,	{"PMU0: writing rxClkDelay for tg", "INT", "  db", "INT", "  nib", "INT", "  to ", "HEX", "  from eye[", "INT", " ]\n"} },
	{0x67 , 	0x5,	 LOG_LEVEL_30,	{"PMU0: tx voltage for tg", "INT", "  nib", "INT", "  to ", "INT", "  (", "INT", " ) from eye[", "INT", " ]\n"} },
	{0x68 , 	0x1,	 LOG_LEVEL_30,	{"PMU0: vref Sum = ", "INT", " \n"} },
	{0x69 , 	0x4,	 LOG_LEVEL_30,	{"PMU0: tx voltage total is ", "INT", " /", "INT", "  -> ", "INT", "  -> ", "INT", " \n"} },
	{0x6a , 	0x7,	 LOG_LEVEL_30,	{"PMU0: writing txDqDelay for tg", "INT", "  db", "INT", "  ln", "INT", "  to  ", "HEX", "  (", "INT", "  coarse, ", "INT", "  fine) from eye[", "INT", " ] (DISCONNECTED)\n"} },
	{0x6b , 	0x3,	 LOG_LEVEL_30,	{"PMU: Error: Dbyte ", "INT", "  lane ", "INT", " 's optimal txDqDly of ", "HEX", "  is out of bounds\n"} },
	{0x6c , 	0x7,	 LOG_LEVEL_30,	{"PMU0: writing txDqDelay for tg", "INT", "  db", "INT", "  l", "INT", "  to  ", "HEX", "  (", "INT", "  coarse, ", "INT", "  fine) from eye[", "INT", " ]\n"} },
	{0x6d , 	0x2,	 LOG_LEVEL_30,	{"PMU0: ", "INT", "  (0=tx, 1=rx) TgMask for this simulation: ", "HEX", " \n"} },
	{0x6e , 	0x1,	 LOG_LEVEL_30,	{"PMU0: findRange ", "INT", " \n"} },
	{0x6f , 	0x2,	 LOG_LEVEL_30,	{"PMU0: VRange = [", "INT", " ,", "INT", " ]\n"} },
	{0x70 , 	0x1,	 LOG_LEVEL_30,	{"PMU0: eye-byte ", "INT", "  is disable\n"} },
	{0x71 , 	0x1,	 LOG_LEVEL_30,	{"PMU0: eye-lane ", "INT", "  is disable\n"} },
	{0x72 , 	0x1,	 LOG_LEVEL_30,	{"PMU0: findRange ", "INT", " \n"} },
	{0x73 , 	0x2,	 LOG_LEVEL_30,	{"PMU0: VRange = [", "INT", " ,", "INT", " ]\n"} },
	{0x74 , 	0x1,	 LOG_LEVEL_30,	{"PMU0: eye-lane ", "INT", "  is disable\n"} },
	{0x75 , 	0x3,	 LOG_LEVEL_30,	{"PMU0: eye ", "INT", "  weight ", "INT", "  allTgWeight ", "INT", " \n"} },
	{0x76 , 	0x2,	 LOG_LEVEL_30,	{"PMU5: FFE figure of merit improved from ", "INT", "  to ", "INT", " \n"} },
	{0x77 , 	0x2,	 LOG_LEVEL_30,	{"PMU: Error: LP4 rank ", "INT", "  cannot be mapped on tg ", "INT", " \n"} },
	{0x78 , 	0x0,	 LOG_LEVEL_30,	{"PMU4: Adjusting vrefDac0 for just 1->x transitions\n"} },
	{0x79 , 	0x0,	 LOG_LEVEL_30,	{"PMU4: Adjusting vrefDac1 for just 0->x transitions\n"} },
	{0x7a , 	0x1,	 LOG_LEVEL_30,	{"PMU5: Strong 1, pull-up ", "INT", "  ohms\n"} },
	{0x7b , 	0x1,	 LOG_LEVEL_30,	{"PMU5: Strong 0, pull-down ", "INT", "  ohms\n"} },
	{0x7c , 	0x0,	 LOG_LEVEL_30,	{"PMU4: Enabling weak drive strengths (FFE)\n"} },
	{0x7d , 	0x0,	 LOG_LEVEL_30,	{"PMU5: Changing all weak driver strengths\n"} },
	{0x7e , 	0x0,	 LOG_LEVEL_30,	{"PMU5: Finalizing weak drive strengths\n"} },
	{0x7f , 	0x0,	 LOG_LEVEL_30,	{"PMU4: retraining with optimal drive strength settings\n"} },
	{0x80 , 	0x1,	 LOG_LEVEL_30,	{"PMU1:prbsGenCtl:", "HEX", " \n"} },
	{0x81 , 	0x0,	 LOG_LEVEL_30,	{"PMU1: loading 2D acsm sequence\n"} },
	{0x82 , 	0x0,	 LOG_LEVEL_30,	{"PMU1: loading 1D acsm sequence\n"} },
	{0x83 , 	0x2,	 LOG_LEVEL_30,	{"PMU3: ", "INT", "  memclocks @ ", "INT", "  to get half of 300ns\n"} },
	{0x84 , 	0x0,	 LOG_LEVEL_30,	{"PMU: Error: User requested MPR read pattern for read DQS training in DDR3 Mode\n"} },
	{0x85 , 	0x0,	 LOG_LEVEL_30,	{"PMU3: Running 1D search for left eye edge\n"} },
	{0x86 , 	0x1,	 LOG_LEVEL_30,	{"PMU1: In Phase Left Edge Search cs ", "INT", " \n"} },
	{0x87 , 	0x1,	 LOG_LEVEL_30,	{"PMU1: Out of Phase Left Edge Search cs ", "INT", " \n"} },
	{0x88 , 	0x0,	 LOG_LEVEL_30,	{"PMU3: Running 1D search for right eye edge\n"} },
	{0x89 , 	0x1,	 LOG_LEVEL_30,	{"PMU1: In Phase Right Edge Search cs ", "INT", " \n"} },
	{0x8a , 	0x1,	 LOG_LEVEL_30,	{"PMU1: Out of Phase Right Edge Search cs ", "INT", " \n"} },
	{0x8b , 	0x1,	 LOG_LEVEL_30,	{"PMU1: mxRdLat training pstate ", "INT", " \n"} },
	{0x8c , 	0x1,	 LOG_LEVEL_30,	{"PMU1: mxRdLat search for cs ", "INT", " \n"} },
	{0x8d , 	0x1,	 LOG_LEVEL_30,	{"PMU0: MaxRdLat non consistant DtsmLoThldXingInd ", "HEX", " \n"} },
	{0x8e , 	0x3,	 LOG_LEVEL_30,	{"PMU4: CS ", "INT", "  Dbyte ", "INT", "  worked with DFIMRL = ", "INT", "  DFICLKs \n"} },
	{0x8f , 	0x4,	 LOG_LEVEL_30,	{"PMU3: MaxRdLat Read Lane err mask for csn ", "INT", " , DFIMRL ", "INT", "  DFIClks, dbyte ", "INT", "  = ", "HEX", " \n"} },
	{0x90 , 	0x3,	 LOG_LEVEL_30,	{"PMU3: MaxRdLat Read Lane err mask for csn ", "INT", "  DFIMRL ", "INT", " , All dbytes = ", "HEX", " \n"} },
	{0x91 , 	0x1,	 LOG_LEVEL_30,	{"PMU: Error: CS", "INT", "  failed to find a DFIMRL setting that worked for all bytes during MaxRdLat training\n"} },
	{0x92 , 	0x2,	 LOG_LEVEL_30,	{"PMU3: Smallest passing DFIMRL for all dbytes in CS", "INT", "  = ", "INT", "  DFIClks\n"} },
	{0x93 , 	0x0,	 LOG_LEVEL_30,	{"PMU: Error: No passing DFIMRL value found for any chip select during MaxRdLat training\n"} },
	{0x94 , 	0x3,	 LOG_LEVEL_30,	{"PMU: Error: Dbyte ", "INT", "  lane ", "INT", "  txDqDly passing region is too small (width = ", "INT", " )\n"} },
	{0x95 , 	0x0,	 LOG_LEVEL_30,	{"PMU4: TxDqDly Passing Regions (EyeLeft EyeRight -> EyeCenter) Units=1/32 UI\n"} },
	{0x96 , 	0x5,	 LOG_LEVEL_30,	{"PMU4: DB ", "INT", "  Lane ", "INT", " : ", "INT", "  ", "INT", "  -> ", "INT", " \n"} },
	{0x97 , 	0x2,	 LOG_LEVEL_30,	{"PMU2: TXDQ delayLeft[", "INT", " ] = ", "INT", "  (DISCONNECTED)\n"} },
	{0x98 , 	0x4,	 LOG_LEVEL_30,	{"PMU2: TXDQ delayLeft[", "INT", " ] = ", "INT", "  oopScaled = ", "INT", "  selectOop ", "INT", " \n"} },
	{0x99 , 	0x2,	 LOG_LEVEL_30,	{"PMU2: TXDQ delayRight[", "INT", " ] = ", "INT", "  (DISCONNECTED)\n"} },
	{0x9a , 	0x4,	 LOG_LEVEL_30,	{"PMU2: TXDQ delayRight[", "INT", " ] = ", "INT", "  oopScaled = ", "INT", "  selectOop ", "INT", " \n"} },
	{0x9b , 	0x3,	 LOG_LEVEL_30,	{"PMU: Error: Dbyte ", "INT", "  lane ", "INT", "  txDqDly passing region is too small (width = ", "INT", " )\n"} },
	{0x9c , 	0x0,	 LOG_LEVEL_30,	{"PMU4: TxDqDly Passing Regions (EyeLeft EyeRight -> EyeCenter) Units=1/32 UI\n"} },
	{0x9d , 	0x2,	 LOG_LEVEL_30,	{"PMU4: DB ", "INT", "  Lane ", "INT", " : (DISCONNECTED)\n"} },
	{0x9e , 	0x5,	 LOG_LEVEL_30,	{"PMU4: DB ", "INT", "  Lane ", "INT", " : ", "INT", "  ", "INT", "  -> ", "INT", " \n"} },
	{0x9f , 	0x2,	 LOG_LEVEL_30,	{"PMU3: Running 1D search csn ", "INT", "  for DM Right/NotLeft(", "INT", " ) eye edge\n"} },
	{0xa0 , 	0x2,	 LOG_LEVEL_30,	{"PMU3: WrDq DM byte", "INT", "  with Errcnt ", "INT", " \n"} },
	{0xa1 , 	0x2,	 LOG_LEVEL_30,	{"PMU3: WrDq DM byte", "INT", "  avgDly ", "HEX", " \n"} },
	{0xa2 , 	0x2,	 LOG_LEVEL_30,	{"PMU1: WrDq DM byte", "INT", "  with Errcnt ", "INT", " \n"} },
	{0xa3 , 	0x1,	 LOG_LEVEL_30,	{"PMU: Error: Dbyte ", "INT", "  txDqDly DM training did not start inside the eye\n"} },
	{0xa4 , 	0x0,	 LOG_LEVEL_30,	{"PMU4: DM TxDqDly Passing Regions (EyeLeft EyeRight -> EyeCenter) Units=1/32 UI\n"} },
	{0xa5 , 	0x2,	 LOG_LEVEL_30,	{"PMU4: DB ", "INT", "  Lane ", "INT", " : (DISCONNECTED)\n"} },
	{0xa6 , 	0x5,	 LOG_LEVEL_30,	{"PMU4: DB ", "INT", "  Lane ", "INT", " : ", "INT", "  ", "INT", "  -> ", "INT", " \n"} },
	{0xa7 , 	0x3,	 LOG_LEVEL_30,	{"PMU: Error: Dbyte ", "INT", "  lane ", "INT", "  txDqDly DM passing region is too small (width = ", "INT", " )\n"} },
	{0xa8 , 	0x4,	 LOG_LEVEL_30,	{"PMU3: Errcnt for MRD/MWD search nib ", "INT", "  delay = (", "INT", " , ", "HEX", " ) = ", "INT", " \n"} },
	{0xa9 , 	0x0,	 LOG_LEVEL_30,	{"PMU3: Precharge all open banks\n"} },
	{0xaa , 	0x2,	 LOG_LEVEL_30,	{"PMU: Error: Dbyte ", "INT", "  nibble ", "INT", "  found mutliple working coarse delay setting for MRD/MWD\n"} },
	{0xab , 	0x0,	 LOG_LEVEL_30,	{"PMU4: MRD Passing Regions (coarseVal, fineLeft fineRight -> fineCenter)\n"} },
	{0xac , 	0x0,	 LOG_LEVEL_30,	{"PMU4: MRW Passing Regions (coarseVal, fineLeft fineRight -> fineCenter)\n"} },
	{0xad , 	0x4,	 LOG_LEVEL_30,	{"PMU10: Warning: DB ", "INT", "  nibble ", "INT", "  has multiple working coarse delays, ", "INT", "  and ", "INT", " , choosing the smaller delay\n"} },
	{0xae , 	0x3,	 LOG_LEVEL_30,	{"PMU: Error: Dbyte ", "INT", "  nibble ", "INT", "  MRD/MWD passing region is too small (width = ", "INT", " )\n"} },
	{0xaf , 	0x6,	 LOG_LEVEL_30,	{"PMU4: DB ", "INT", "  nibble ", "INT", " : ", "INT", " , ", "INT", "  ", "INT", "  -> ", "INT", " \n"} },
	{0xb0 , 	0x2,	 LOG_LEVEL_30,	{"PMU1: Start MRD/nMWD ", "INT", "  for csn ", "INT", " \n"} },
	{0xb1 , 	0x2,	 LOG_LEVEL_30,	{"PMU2: RXDQS delayLeft[", "INT", " ] = ", "INT", "  (DISCONNECTED)\n"} },
	{0xb2 , 	0x6,	 LOG_LEVEL_30,	{"PMU2: RXDQS delayLeft[", "INT", " ] = ", "INT", "  delayOop[", "INT", " ] = ", "INT", "  OopScaled ", "INT", " , selectOop ", "INT", " \n"} },
	{0xb3 , 	0x2,	 LOG_LEVEL_30,	{"PMU2: RXDQS delayRight[", "INT", " ] = ", "INT", "  (DISCONNECTED)\n"} },
	{0xb4 , 	0x6,	 LOG_LEVEL_30,	{"PMU2: RXDQS delayRight[", "INT", " ] = ", "INT", "  delayOop[", "INT", " ] = ", "INT", "  OopScaled ", "INT", " , selectOop ", "INT", " \n"} },
	{0xb5 , 	0x0,	 LOG_LEVEL_30,	{"PMU4: RxClkDly Passing Regions (EyeLeft EyeRight -> EyeCenter)\n"} },
	{0xb6 , 	0x2,	 LOG_LEVEL_30,	{"PMU4: DB ", "INT", "  nibble ", "INT", " : (DISCONNECTED)\n"} },
	{0xb7 , 	0x5,	 LOG_LEVEL_30,	{"PMU4: DB ", "INT", "  nibble ", "INT", " : ", "INT", "  ", "INT", "  -> ", "INT", " \n"} },
	{0xb8 , 	0x3,	 LOG_LEVEL_30,	{"PMU: Error: Dbyte ", "INT", "  nibble ", "INT", "  rxClkDly passing region is too small (width = ", "INT", " )\n"} },
	{0xb9 , 	0x2,	 LOG_LEVEL_30,	{"PMU0: goodbar = ", "INT", "  for RDWR_BLEN ", "INT", " \n"} },
	{0xba , 	0x1,	 LOG_LEVEL_30,	{"PMU3: RxClkDly = ", "INT", " \n"} },
	{0xbb , 	0x5,	 LOG_LEVEL_30,	{"PMU0: db ", "INT", "  l ", "INT", "  absLane ", "INT", "  -> bottom ", "INT", "  top ", "INT", " \n"} },
	{0xbc , 	0x9,	 LOG_LEVEL_30,	{"PMU3: BYTE ", "INT", "  - ", "INT", "  ", "INT", "  ", "INT", "  ", "INT", "  ", "INT", "  ", "INT", "  ", "INT", "  ", "INT", " \n"} },
	{0xbd , 	0x2,	 LOG_LEVEL_30,	{"PMU: Error: dbyte ", "INT", "  lane ", "INT", " 's per-lane vrefDAC's had no passing region\n"} },
	{0xbe , 	0x4,	 LOG_LEVEL_30,	{"PMU0: db", "INT", "  l", "INT", "  - ", "INT", "  ", "INT", " \n"} },
	{0xbf , 	0x2,	 LOG_LEVEL_30,	{"PMU0: goodbar = ", "INT", "  for RDWR_BLEN ", "INT", " \n"} },
	{0xc0 , 	0x4,	 LOG_LEVEL_30,	{"PMU3: db", "INT", "  l", "INT", "  saw ", "INT", "  issues at rxClkDly ", "INT", " \n"} },
	{0xc1 , 	0x3,	 LOG_LEVEL_30,	{"PMU3: db", "INT", "  l", "INT", "  first saw a pass->fail edge at rxClkDly ", "INT", " \n"} },
	{0xc2 , 	0x2,	 LOG_LEVEL_30,	{"PMU3: lane ", "INT", "  PBD = ", "INT", " \n"} },
	{0xc3 , 	0x3,	 LOG_LEVEL_30,	{"PMU3: db", "INT", "  l", "INT", "  first saw a DBI pass->fail edge at rxClkDly ", "INT", " \n"} },
	{0xc4 , 	0x3,	 LOG_LEVEL_30,	{"PMU2: db", "INT", "  l", "INT", "  already passed rxPBD = ", "INT", " \n"} },
	{0xc5 , 	0x3,	 LOG_LEVEL_30,	{"PMU0: db", "INT", "  l", "INT", " , PBD = ", "INT", " \n"} },
	{0xc6 , 	0x2,	 LOG_LEVEL_30,	{"PMU: Error: dbyte ", "INT", "  lane ", "INT", "  failed read deskew\n"} },
	{0xc7 , 	0x3,	 LOG_LEVEL_30,	{"PMU1: Running lane deskew on pstate ", "INT", "  csn ", "INT", "  rdDBIEn ", "INT", " \n"} },
	{0xc8 , 	0x0,	 LOG_LEVEL_30,	{"PMU: Error: Read deskew training has been requested, but csrMajorModeDbyte[2] is set\n"} },
	{0xc9 , 	0x2,	 LOG_LEVEL_30,	{"PMU1: AcsmCsMapCtrl", "INT", "  ", "HEX", " \n"} },
	{0xca , 	0x2,	 LOG_LEVEL_30,	{"PMU1: AcsmCsMapCtrl", "INT", "  ", "HEX", " \n"} },
	{0xcb , 	0x1,	 LOG_LEVEL_30,	{"PMU: Error: Wrong PMU image loaded. message Block DramType = ", "HEX", " , but image built for D3U Type\n"} },
	{0xcc , 	0x1,	 LOG_LEVEL_30,	{"PMU: Error: Wrong PMU image loaded. message Block DramType = ", "HEX", " , but image built for D3R Type\n"} },
	{0xcd , 	0x1,	 LOG_LEVEL_30,	{"PMU: Error: Wrong PMU image loaded. message Block DramType = ", "HEX", " , but image built for D4U Type\n"} },
	{0xce , 	0x1,	 LOG_LEVEL_30,	{"PMU: Error: Wrong PMU image loaded. message Block DramType = ", "HEX", " , but image built for D4R Type\n"} },
	{0xcf , 	0x1,	 LOG_LEVEL_30,	{"PMU: Error: Wrong PMU image loaded. message Block DramType = ", "HEX", " , but image built for D4LR Type\n"} },
	{0xd0 , 	0x0,	 LOG_LEVEL_30,	{"PMU: Error: Both 2t timing mode and ddr4 geardown mode specifed in the messageblock's PhyCfg and MR3 fields. Only one can be enabled\n"} },
	{0xd1 , 	0x3,	 LOG_LEVEL_30,	{"PMU10: PHY TOTALS - NUM_DBYTES ", "INT", "  NUM_NIBBLES ", "INT", "  NUM_ANIBS ", "INT", " \n"} },
	{0xd2 , 	0x6,	 LOG_LEVEL_30,	{"PMU10: CSA=", "HEX", " , CSB=", "HEX", " , TSTAGES=", "HEX", " , HDTOUT=", "INT", " , MMISC=", "INT", "  DRAMFreq=", "INT", " MT DramType=LPDDR3\n"} },
	{0xd3 , 	0x6,	 LOG_LEVEL_30,	{"PMU10: CSA=", "HEX", " , CSB=", "HEX", " , TSTAGES=", "HEX", " , HDTOUT=", "INT", " , MMISC=", "INT", "  DRAMFreq=", "INT", " MT DramType=LPDDR4\n"} },
	{0xd4 , 	0x8,	 LOG_LEVEL_30,	{"PMU10: CS=", "HEX", " , TSTAGES=", "HEX", " , HDTOUT=", "INT", " , 2T=", "INT", " , MMISC=", "INT", "  AddrMirror=", "INT", "  DRAMFreq=", "INT", " MT DramType=", "INT", " \n"} },
	{0xd5 , 	0x4,	 LOG_LEVEL_30,	{"PMU10: Pstate", "INT", "  MR0=", "HEX", "  MR1=", "HEX", "  MR2=", "HEX", " \n"} },
	{0xd6 , 	0x8,	 LOG_LEVEL_30,	{"PMU10: Pstate", "INT", "  MRS MR0=", "HEX", "  MR1=", "HEX", "  MR2=", "HEX", "  MR3=", "HEX", "  MR4=", "HEX", "  MR5=", "HEX", "  MR6=", "HEX", " \n"} },
	{0xd7 , 	0x5,	 LOG_LEVEL_30,	{"PMU10: Pstate", "INT", "  MRS MR1_A0=", "HEX", "  MR2_A0=", "HEX", "  MR3_A0=", "HEX", "  MR11_A0=", "HEX", " \n"} },
	{0xd8 , 	0x0,	 LOG_LEVEL_30,	{"PMU10: UseBroadcastMR set. All ranks and channels use MRXX_A0 for MR settings.\n"} },
	{0xd9 , 	0x5,	 LOG_LEVEL_30,	{"PMU10: Pstate", "INT", "  MRS MR01_A0=", "HEX", "  MR02_A0=", "HEX", "  MR03_A0=", "HEX", "  MR11_A0=", "HEX", " \n"} },
	{0xda , 	0x5,	 LOG_LEVEL_30,	{"PMU10: Pstate", "INT", "  MRS MR12_A0=", "HEX", "  MR13_A0=", "HEX", "  MR14_A0=", "HEX", "  MR22_A0=", "HEX", " \n"} },
	{0xdb , 	0x5,	 LOG_LEVEL_30,	{"PMU10: Pstate", "INT", "  MRS MR01_A1=", "HEX", "  MR02_A1=", "HEX", "  MR03_A1=", "HEX", "  MR11_A1=", "HEX", " \n"} },
	{0xdc , 	0x5,	 LOG_LEVEL_30,	{"PMU10: Pstate", "INT", "  MRS MR12_A1=", "HEX", "  MR13_A1=", "HEX", "  MR14_A1=", "HEX", "  MR22_A1=", "HEX", " \n"} },
	{0xdd , 	0x5,	 LOG_LEVEL_30,	{"PMU10: Pstate", "INT", "  MRS MR01_B0=", "HEX", "  MR02_B0=", "HEX", "  MR03_B0=", "HEX", "  MR11_B0=", "HEX", " \n"} },
	{0xde , 	0x5,	 LOG_LEVEL_30,	{"PMU10: Pstate", "INT", "  MRS MR12_B0=", "HEX", "  MR13_B0=", "HEX", "  MR14_B0=", "HEX", "  MR22_B0=", "HEX", " \n"} },
	{0xdf , 	0x5,	 LOG_LEVEL_30,	{"PMU10: Pstate", "INT", "  MRS MR01_B1=", "HEX", "  MR02_B1=", "HEX", "  MR03_B1=", "HEX", "  MR11_B1=", "HEX", " \n"} },
	{0xe0 , 	0x5,	 LOG_LEVEL_30,	{"PMU10: Pstate", "INT", "  MRS MR12_B1=", "HEX", "  MR13_B1=", "HEX", "  MR14_B1=", "HEX", "  MR22_B1=", "HEX", " \n"} },
	{0xe1 , 	0x2,	 LOG_LEVEL_30,	{"PMU1: AcsmOdtCtrl", "INT", "  ", "HEX", " \n"} },
	{0xe2 , 	0x2,	 LOG_LEVEL_30,	{"PMU1: AcsmCsMapCtrl", "INT", "  ", "HEX", " \n"} },
	{0xe3 , 	0x2,	 LOG_LEVEL_30,	{"PMU1: AcsmCsMapCtrl", "INT", "  ", "HEX", " \n"} },
	{0xe4 , 	0x0,	 LOG_LEVEL_30,	{"PMU1: HwtCAMode set\n"} },
	{0xe5 , 	0x1,	 LOG_LEVEL_30,	{"PMU3: DDR4 infinite preamble enter/exit mode ", "INT", " \n"} },
	{0xe6 , 	0x2,	 LOG_LEVEL_30,	{"PMU1: In rxenb_train() csn=", "INT", "  pstate=", "INT", " \n"} },
	{0xe7 , 	0x0,	 LOG_LEVEL_30,	{"PMU3: Finding DQS falling edge\n"} },
	{0xe8 , 	0x0,	 LOG_LEVEL_30,	{"PMU3: Searching for DDR3/LPDDR3/LPDDR4 read preamble\n"} },
	{0xe9 , 	0x9,	 LOG_LEVEL_30,	{"PMU3: dtsm fails Even Nibbles : ", "HEX", "  ", "HEX", "  ", "HEX", "  ", "HEX", "  ", "HEX", "  ", "HEX", "  ", "HEX", "  ", "HEX", "  ", "HEX", " \n"} },
	{0xea , 	0x9,	 LOG_LEVEL_30,	{"PMU3: dtsm fails Odd  Nibbles : ", "HEX", "  ", "HEX", "  ", "HEX", "  ", "HEX", "  ", "HEX", "  ", "HEX", "  ", "HEX", "  ", "HEX", "  ", "HEX", " \n"} },
	{0xeb , 	0x2,	 LOG_LEVEL_30,	{"PMU3: Preamble search pass=", "INT", "  anyfail=", "INT", " \n"} },
	{0xec , 	0x0,	 LOG_LEVEL_30,	{"PMU: Error: RxEn training preamble not found\n"} },
	{0xed , 	0x0,	 LOG_LEVEL_30,	{"PMU3: Found DQS pre-amble\n"} },
	{0xee , 	0x1,	 LOG_LEVEL_30,	{"PMU: Error: Dbyte ", "INT", "  couldn't find the rising edge of DQS during RxEn Training\n"} },
	{0xef , 	0x0,	 LOG_LEVEL_30,	{"PMU3: RxEn aligning to first rising edge of burst\n"} },
	{0xf0 , 	0x1,	 LOG_LEVEL_30,	{"PMU3: Decreasing RxEn delay by ", "INT", "  fine step to allow full capture of reads\n"} },
	{0xf1 , 	0x1,	 LOG_LEVEL_30,	{"PMU3: MREP Delay = ", "INT", " \n"} },
	{0xf2 , 	0x3,	 LOG_LEVEL_30,	{"PMU3: Errcnt for MREP nib ", "INT", "  delay = ", "INT", "  is ", "INT", " \n"} },
	{0xf3 , 	0x2,	 LOG_LEVEL_30,	{"PMU3: MREP nibble ", "INT", "  sampled a 1 at data buffer delay ", "INT", " \n"} },
	{0xf4 , 	0x2,	 LOG_LEVEL_30,	{"PMU3: MREP nibble ", "INT", "  saw a 0 to 1 transition at data buffer delay ", "INT", " \n"} },
	{0xf5 , 	0x0,	 LOG_LEVEL_30,	{"PMU2:  MREP did not find a 0 to 1 transition for all nibbles. Assuming 0 delay was already in the passing region for failing nibbles\n"} },
	{0xf6 , 	0x2,	 LOG_LEVEL_30,	{"PMU3: Training DIMM ", "INT", "  CSn ", "INT", " \n"} },
	{0xf7 , 	0x1,	 LOG_LEVEL_30,	{"PMU3: exitCAtrain_lp3 cs ", "HEX", " \n"} },
	{0xf8 , 	0x1,	 LOG_LEVEL_30,	{"PMU3: enterCAtrain_lp3 cs ", "HEX", " \n"} },
	{0xf9 , 	0x1,	 LOG_LEVEL_30,	{"PMU3: CAtrain_switchmsb_lp3 cs ", "HEX", " \n"} },
	{0xfa , 	0x1,	 LOG_LEVEL_30,	{"PMU3: CATrain_rdwr_lp3 looking for pattern ", "HEX", " \n"} },
	{0xfb , 	0x0,	 LOG_LEVEL_30,	{"PMU3: exitCAtrain_lp4\n"} },
	{0xfc , 	0x1,	 LOG_LEVEL_30,	{"PMU3: DEBUG enterCAtrain_lp4 1: cs ", "HEX", " \n"} },
	{0xfd , 	0x1,	 LOG_LEVEL_30,	{"PMU3: DEBUG enterCAtrain_lp4 3: Put dbyte ", "INT", "  in async mode\n"} },
	{0xfe , 	0x0,	 LOG_LEVEL_30,	{"PMU3: DEBUG enterCAtrain_lp4 5: Send MR13 to turn on CA training\n"} },
	{0xff , 	0x3,	 LOG_LEVEL_30,	{"PMU3: DEBUG enterCAtrain_lp4 7: idx = ", "INT", "  vref = ", "HEX", "  mr12 = ", "HEX", "  \n"} },
	{0x100, 	0x1,	 LOG_LEVEL_30,	{"PMU3: CATrain_rdwr_lp4 looking for pattern ", "HEX", " \n"} },
	{0x101, 	0x4,	 LOG_LEVEL_30,	{"PMU3: Phase ", "INT", "  CAreadbackA db:", "INT", "  ", "HEX", "  xo:", "HEX", " \n"} },
	{0x102, 	0x4,	 LOG_LEVEL_30,	{"PMU3: Phase ", "INT", "  CAreadbackB db:", "INT", "  ", "HEX", "  xo:", "HEX", " \n"} },
	{0x103, 	0x5,	 LOG_LEVEL_30,	{"PMU3: DEBUG lp4SetCatrVref 1: cs=", "INT", "  chan=", "INT", "  mr12=", "HEX", "  vref=", "INT", " .", "INT", " %%\n"} },
	{0x104, 	0x3,	 LOG_LEVEL_30,	{"PMU3: DEBUG lp4SetCatrVref 3: mr12 = ", "HEX", "  send vref= ", "HEX", "  to db=", "INT", " \n"} },
	{0x105, 	0x3,	 LOG_LEVEL_30,	{"PMU3: DEBUG lp4SetCatrVref 4: mr12= ", "HEX", "  send vref= ", "HEX", "  to db=", "INT", " \n"} },
	{0x106, 	0x0,	 LOG_LEVEL_30,	{"PMU10:Optimizing vref\n"} },
	{0x107, 	0x4,	 LOG_LEVEL_30,	{"PMU4:mr12:", "HEX", "  cs:", "INT", "  chan ", "INT", "  r:", "HEX", " \n"} },
	{0x108, 	0x5,	 LOG_LEVEL_30,	{"PMU3: i:", "INT", "  bstr:", "INT", "  bsto:", "INT", "  st:", "INT", "  r:", "INT", " \n"} },
	{0x109, 	0x2,	 LOG_LEVEL_30,	{"Failed to find sufficient CA Vref Passing Region for CS ", "INT", "  channel ", "INT", " \n"} },
	{0x10a, 	0x5,	 LOG_LEVEL_30,	{"PMU3:Found ", "INT", " .", "INT", " %% MR12:", "HEX", "  for cs:", "INT", "  chan ", "INT", " \n"} },
	{0x10b, 	0x2,	 LOG_LEVEL_30,	{"PMU3:Calculated ", "INT", "  for AtxImpedence from acx ", "INT", " .\n"} },
	{0x10c, 	0x0,	 LOG_LEVEL_30,	{"PMU3:CA Odt impedence ==0.  Use default vref.\n"} },
	{0x10d, 	0x3,	 LOG_LEVEL_30,	{"PMU3:Calculated ", "INT", " .", "INT", " %% for Vref MR12=", "HEX", " .\n"} },
	{0x10e, 	0x0,	 LOG_LEVEL_30,	{"PMU3: CAtrain_lp\n"} },
	{0x10f, 	0x0,	 LOG_LEVEL_30,	{"PMU3: CAtrain Begins.\n"} },
	{0x110, 	0x1,	 LOG_LEVEL_30,	{"PMU3: CAtrain_lp testing dly ", "INT", " \n"} },
	{0x111, 	0x1,	 LOG_LEVEL_30,	{"PMU5: CA bitmap dump for cs ", "HEX", " \n"} },
	{0x112, 	0x1,	 LOG_LEVEL_30,	{"PMU5: CAA", "INT", "  "} },
	{0x113, 	0x1,	 LOG_LEVEL_30,	{"", "HEX", " "} },
	{0x114, 	0x0,	 LOG_LEVEL_30,	{"\n"} },
	{0x115, 	0x1,	 LOG_LEVEL_30,	{"PMU5: CAB", "INT", "  "} },
	{0x116, 	0x1,	 LOG_LEVEL_30,	{"", "HEX", " "} },
	{0x117, 	0x0,	 LOG_LEVEL_30,	{"\n"} },
	{0x118, 	0x3,	 LOG_LEVEL_30,	{"PMU3: anibi=", "INT", " , anibichan[anibi]=", "INT", "  ,chan=", "INT", " \n"} },
	{0x119, 	0x1,	 LOG_LEVEL_30,	{"", "HEX", " "} },
	{0x11a, 	0x1,	 LOG_LEVEL_30,	{"\nPMU3:Raw CA setting :", "HEX", " "} },
	{0x11b, 	0x2,	 LOG_LEVEL_30,	{"\nPMU3:ATxDly setting:", "HEX", "  margin:", "INT", " \n"} },
	{0x11c, 	0x2,	 LOG_LEVEL_30,	{"\nPMU3:InvClk ATxDly setting:", "HEX", "  margin:", "INT", " \n"} },
	{0x11d, 	0x0,	 LOG_LEVEL_30,	{"\nPMU3:No Range found!\n"} },
	{0x11e, 	0x3,	 LOG_LEVEL_30,	{"PMU3: 2 anibi=", "INT", " , anibichan[anibi]=", "INT", "  ,chan=", "INT", " "} },
	{0x11f, 	0x2,	 LOG_LEVEL_30,	{"\nPMU3: no neg clock => CA setting anib=", "INT", " , :", "INT", " \n"} },
	{0x120, 	0x1,	 LOG_LEVEL_30,	{"PMU3:Normal margin:", "INT", " \n"} },
	{0x121, 	0x1,	 LOG_LEVEL_30,	{"PMU3:Inverted margin:", "INT", " \n"} },
	{0x122, 	0x0,	 LOG_LEVEL_30,	{"PMU3:Using Inverted clock\n"} },
	{0x123, 	0x0,	 LOG_LEVEL_30,	{"PMU3:Using normal clk\n"} },
	{0x124, 	0x3,	 LOG_LEVEL_30,	{"PMU3: 3 anibi=", "INT", " , anibichan[anibi]=", "INT", "  ,chan=", "INT", " \n"} },
	{0x125, 	0x2,	 LOG_LEVEL_30,	{"PMU3: Setting ATxDly for anib ", "HEX", "  to ", "HEX", " \n"} },
	{0x126, 	0x0,	 LOG_LEVEL_30,	{"PMU: Error: CA Training Failed.\n"} },
	{0x127, 	0x0,	 LOG_LEVEL_30,	{"PMU1: Writing MRs\n"} },
	{0x128, 	0x0,	 LOG_LEVEL_30,	{"PMU4:Using MR12 values from 1D CA VREF training.\n"} },
	{0x129, 	0x0,	 LOG_LEVEL_30,	{"PMU3:Writing all MRs to fsp 1\n"} },
	{0x12a, 	0x0,	 LOG_LEVEL_30,	{"PMU10:Lp4Quickboot mode.\n"} },
	{0x12b, 	0x0,	 LOG_LEVEL_30,	{"PMU3: Writing MRs\n"} },
	{0x12c, 	0x1,	 LOG_LEVEL_30,	{"PMU10: Setting boot clock divider to ", "INT", " \n"} },
	{0x12d, 	0x0,	 LOG_LEVEL_30,	{"PMU3: Resetting DRAM\n"} },
	{0x12e, 	0x0,	 LOG_LEVEL_30,	{"PMU3: setup for RCD initalization\n"} },
	{0x12f, 	0x0,	 LOG_LEVEL_30,	{"PMU3: pmu_exit_SR from dev_init()\n"} },
	{0x130, 	0x0,	 LOG_LEVEL_30,	{"PMU3: initializing RCD\n"} },
	{0x131, 	0x0,	 LOG_LEVEL_30,	{"PMU10: **** Executing 2D Image ****\n"} },
	{0x132, 	0x1,	 LOG_LEVEL_30,	{"PMU10: **** Start DDR4 Training. PMU Firmware Revision ", "HEX", "  ****\n"} },
	{0x133, 	0x1,	 LOG_LEVEL_30,	{"PMU10: **** Start DDR3 Training. PMU Firmware Revision ", "HEX", "  ****\n"} },
	{0x134, 	0x1,	 LOG_LEVEL_30,	{"PMU10: **** Start LPDDR3 Training. PMU Firmware Revision ", "HEX", "  ****\n"} },
	{0x135, 	0x1,	 LOG_LEVEL_30,	{"PMU10: **** Start LPDDR4 Training. PMU Firmware Revision ", "HEX", "  ****\n"} },
	{0x136, 	0x0,	 LOG_LEVEL_30,	{"PMU: Error: Mismatched internal revision between DCCM and ICCM images\n"} },
	{0x137, 	0x1,	 LOG_LEVEL_30,	{"PMU10: **** Testchip ", "INT", "  Specific Firmware ****\n"} },
	{0x138, 	0x0,	 LOG_LEVEL_30,	{"PMU1: LRDIMM with EncodedCS mode, one DIMM\n"} },
	{0x139, 	0x0,	 LOG_LEVEL_30,	{"PMU1: LRDIMM with EncodedCS mode, two DIMMs\n"} },
	{0x13a, 	0x0,	 LOG_LEVEL_30,	{"PMU1: RDIMM with EncodedCS mode, one DIMM\n"} },
	{0x13b, 	0x0,	 LOG_LEVEL_30,	{"PMU2: Starting LRDIMM MREP training for all ranks\n"} },
	{0x13c, 	0x0,	 LOG_LEVEL_30,	{"PMU199: LRDIMM MREP training for all ranks completed\n"} },
	{0x13d, 	0x0,	 LOG_LEVEL_30,	{"PMU2: Starting LRDIMM DWL training for all ranks\n"} },
	{0x13e, 	0x0,	 LOG_LEVEL_30,	{"PMU199: LRDIMM DWL training for all ranks completed\n"} },
	{0x13f, 	0x0,	 LOG_LEVEL_30,	{"PMU2: Starting LRDIMM MRD training for all ranks\n"} },
	{0x140, 	0x0,	 LOG_LEVEL_30,	{"PMU199: LRDIMM MRD training for all ranks completed\n"} },
	{0x141, 	0x0,	 LOG_LEVEL_30,	{"PMU2: Starting RXEN training for all ranks\n"} },
	{0x142, 	0x0,	 LOG_LEVEL_30,	{"PMU2: Starting write leveling fine delay training for all ranks\n"} },
	{0x143, 	0x0,	 LOG_LEVEL_30,	{"PMU2: Starting LRDIMM MWD training for all ranks\n"} },
	{0x144, 	0x0,	 LOG_LEVEL_30,	{"PMU199: LRDIMM MWD training for all ranks completed\n"} },
	{0x145, 	0x0,	 LOG_LEVEL_30,	{"PMU2: Starting read deskew training\n"} },
	{0x146, 	0x0,	 LOG_LEVEL_30,	{"PMU2: Starting SI friendly 1d RdDqs training for all ranks\n"} },
	{0x147, 	0x0,	 LOG_LEVEL_30,	{"PMU2: Starting write leveling coarse delay training for all ranks\n"} },
	{0x148, 	0x0,	 LOG_LEVEL_30,	{"PMU2: Starting 1d WrDq training for all ranks\n"} },
	{0x149, 	0x0,	 LOG_LEVEL_30,	{"PMU2: Running DQS2DQ Oscillator for all ranks\n"} },
	{0x14a, 	0x0,	 LOG_LEVEL_30,	{"PMU2: Starting 1d RdDqs training for all ranks\n"} },
	{0x14b, 	0x0,	 LOG_LEVEL_30,	{"PMU2: Starting MaxRdLat training\n"} },
	{0x14c, 	0x0,	 LOG_LEVEL_30,	{"PMU2: Redoing LRDIMM MREP training for all ranks\n"} },
	{0x14d, 	0x0,	 LOG_LEVEL_30,	{"PMU199: LRDIMM MREP training for all ranks completed\n"} },
	{0x14e, 	0x0,	 LOG_LEVEL_30,	{"PMU2: Redoing LRDIMM DWL training for all ranks\n"} },
	{0x14f, 	0x0,	 LOG_LEVEL_30,	{"PMU199: LRDIMM DWL training for all ranks completed\n"} },
	{0x150, 	0x0,	 LOG_LEVEL_30,	{"PMU2: Redoing LRDIMM MRD training for all ranks\n"} },
	{0x151, 	0x0,	 LOG_LEVEL_30,	{"PMU199: LRDIMM MRD training for all ranks completed\n"} },
	{0x152, 	0x0,	 LOG_LEVEL_30,	{"PMU2: Redoing LRDIMM MWD training for all ranks\n"} },
	{0x153, 	0x0,	 LOG_LEVEL_30,	{"PMU199: LRDIMM MWD training for all ranks completed\n"} },
	{0x154, 	0x0,	 LOG_LEVEL_30,	{"PMU2: Starting 2d RdDqs training for all ranks\n"} },
	{0x155, 	0x0,	 LOG_LEVEL_30,	{"PMU2: Starting 2d WrDq training for all ranks\n"} },
	{0x156, 	0x2,	 LOG_LEVEL_30,	{"PMU3:read_fifo ", "HEX", "  ", "HEX", " \n"} },
	{0x157, 	0x1,	 LOG_LEVEL_30,	{"PMU: Error: Invalid PhyDrvImpedance of ", "HEX", "  specified in message block.\n"} },
	{0x158, 	0x1,	 LOG_LEVEL_30,	{"PMU: Error: Invalid PhyOdtImpedance of ", "HEX", "  specified in message block.\n"} },
	{0x159, 	0x1,	 LOG_LEVEL_30,	{"PMU: Error: Invalid BPZNResVal of ", "HEX", "  specified in message block.\n"} },
	{0x15a, 	0x5,	 LOG_LEVEL_30,	{"PMU3: fixRxEnBackOff csn:", "INT", "  db:", "INT", "  dn:", "INT", "  bo:", "INT", "  dly:", "HEX", " \n"} },
	{0x15b, 	0x1,	 LOG_LEVEL_30,	{"PMU3: fixRxEnBackOff dly:", "HEX", " \n"} },
	{0x15c, 	0x0,	 LOG_LEVEL_30,	{"PMU3: Entering setupPpt\n"} },
	{0x15d, 	0x0,	 LOG_LEVEL_30,	{"PMU3: Start lp4PopulateHighLowBytes\n"} },
	{0x15e, 	0x2,	 LOG_LEVEL_30,	{"PMU3:Dbyte Detect: db", "INT", "  received ", "HEX", " \n"} },
	{0x15f, 	0x2,	 LOG_LEVEL_30,	{"PMU3:getDqs2Dq read ", "HEX", "  from dbyte ", "INT", " \n"} },
	{0x160, 	0x2,	 LOG_LEVEL_30,	{"PMU3:getDqs2Dq(2) read ", "HEX", "  from dbyte ", "INT", " \n"} },
	{0x161, 	0x1,	 LOG_LEVEL_30,	{"PMU: Error: Dbyte ", "INT", "  read 0 from the DQS oscillator it is connected to\n"} },
	{0x162, 	0x2,	 LOG_LEVEL_30,	{"PMU4: Dbyte ", "INT", "  dqs2dq = ", "INT", " /32 UI\n"} },
	{0x163, 	0x3,	 LOG_LEVEL_30,	{"PMU3:getDqs2Dq set dqs2dq:", "INT", " /32 ui (", "INT", "  ps) from dbyte ", "INT", " \n"} },
	{0x164, 	0x3,	 LOG_LEVEL_30,	{"PMU3: Setting coarse delay in AtxDly chiplet ", "INT", "  from ", "HEX", "  to ", "HEX", "  \n"} },
	{0x165, 	0x3,	 LOG_LEVEL_30,	{"PMU3: Clearing coarse delay in AtxDly chiplet ", "INT", "  from ", "HEX", "  to ", "HEX", "  \n"} },
	{0x166, 	0x0,	 LOG_LEVEL_30,	{"PMU3: Performing DDR4 geardown sync sequence\n"} },
	{0x167, 	0x0,	 LOG_LEVEL_30,	{"PMU1: Enter self refresh\n"} },
	{0x168, 	0x0,	 LOG_LEVEL_30,	{"PMU1: Exit self refresh\n"} },
	{0x169, 	0x0,	 LOG_LEVEL_30,	{"PMU: Error: No dbiEnable with lp4\n"} },
	{0x16a, 	0x0,	 LOG_LEVEL_30,	{"PMU: Error: No dbiDisable with lp4\n"} },
	{0x16b, 	0x1,	 LOG_LEVEL_30,	{"PMU1: DDR4 update Rx DBI Setting disable ", "INT", " \n"} },
	{0x16c, 	0x1,	 LOG_LEVEL_30,	{"PMU1: DDR4 update 2nCk WPre Setting disable ", "INT", " \n"} },
	{0x16d, 	0x5,	 LOG_LEVEL_30,	{"PMU1: read_delay: db", "INT", "  lane", "INT", "  delays[", "INT", " ] = ", "HEX", "  (max ", "HEX", " )\n"} },
	{0x16e, 	0x1,	 LOG_LEVEL_30,	{"PMU5: ID=", "INT", "  -- db0  db1  db2  db3  db4  db5  db6  db7  db8  db9 --\n"} },
	{0x16f, 	0xb,	 LOG_LEVEL_30,	{"PMU5: [", "INT", " ]:0x ", "HEX", "  ", "HEX", "  ", "HEX", "  ", "HEX", "  ", "HEX", "  ", "HEX", "  ", "HEX", "  ", "HEX", "  ", "HEX", "  ", "HEX", " \n"} },
	{0x170, 	0x3,	 LOG_LEVEL_30,	{"PMU2: dump delays - pstate=", "INT", "  dimm=", "INT", "  csn=", "INT", " \n"} },
	{0x171, 	0x0,	 LOG_LEVEL_30,	{"PMU3: Printing Mid-Training Delay Information\n"} },
	{0x172, 	0x1,	 LOG_LEVEL_30,	{"PMU5: CS", "INT", "  <<KEY>> 0 TrainingCntr <<KEY>> coarse(15:10) fine(9:0)\n"} },
	{0x173, 	0x1,	 LOG_LEVEL_30,	{"PMU5: CS", "INT", "  <<KEY>> 0 RxEnDly, 1 RxClkDly <<KEY>> coarse(10:6) fine(5:0)\n"} },
	{0x174, 	0x1,	 LOG_LEVEL_30,	{"PMU5: CS", "INT", "  <<KEY>> 0 TxDqsDly, 1 TxDqDly <<KEY>> coarse(9:6) fine(5:0)\n"} },
	{0x175, 	0x1,	 LOG_LEVEL_30,	{"PMU5: CS", "INT", "  <<KEY>> 0 RxPBDly <<KEY>> 1 Delay Unit ~= 7ps \n"} },
	{0x176, 	0x0,	 LOG_LEVEL_30,	{"PMU5: all CS <<KEY>> 0 DFIMRL <<KEY>> Units = DFI clocks\n"} },
	{0x177, 	0x0,	 LOG_LEVEL_30,	{"PMU5: all CS <<KEY>> VrefDACs <<KEY>> DAC(6:0)\n"} },
	{0x178, 	0x0,	 LOG_LEVEL_30,	{"PMU1: Set DMD in MR13 and wrDBI in MR3 for training\n"} },
	{0x179, 	0x0,	 LOG_LEVEL_30,	{"PMU: Error: getMaxRxen() failed to find largest rxen nibble delay\n"} },
	{0x17a, 	0x3,	 LOG_LEVEL_30,	{"PMU2: getMaxRxen(): maxDly ", "INT", "  maxTg ", "INT", "  maxNib ", "INT", " \n"} },
	{0x17b, 	0x3,	 LOG_LEVEL_30,	{"PMU2: getRankMaxRxen(): maxDly ", "INT", "  Tg ", "INT", "  maxNib ", "INT", " \n"} },
	{0x17c, 	0x0,	 LOG_LEVEL_30,	{"PMU1: skipping CDD calculation in 2D image\n"} },
	{0x17d, 	0x1,	 LOG_LEVEL_30,	{"PMU3: Calculating CDDs for pstate ", "INT", " \n"} },
	{0x17e, 	0x3,	 LOG_LEVEL_30,	{"PMU3: rxDly[", "INT", " ][", "INT", " ] = ", "INT", " \n"} },
	{0x17f, 	0x3,	 LOG_LEVEL_30,	{"PMU3: txDly[", "INT", " ][", "INT", " ] = ", "INT", " \n"} },
	{0x180, 	0x3,	 LOG_LEVEL_30,	{"PMU3: allFine CDD_RR_", "INT", " _", "INT", "  = ", "INT", " \n"} },
	{0x181, 	0x3,	 LOG_LEVEL_30,	{"PMU3: allFine CDD_WW_", "INT", " _", "INT", "  = ", "INT", " \n"} },
	{0x182, 	0x3,	 LOG_LEVEL_30,	{"PMU3: CDD_RR_", "INT", " _", "INT", "  = ", "INT", " \n"} },
	{0x183, 	0x3,	 LOG_LEVEL_30,	{"PMU3: CDD_WW_", "INT", " _", "INT", "  = ", "INT", " \n"} },
	{0x184, 	0x3,	 LOG_LEVEL_30,	{"PMU3: allFine CDD_RW_", "INT", " _", "INT", "  = ", "INT", " \n"} },
	{0x185, 	0x3,	 LOG_LEVEL_30,	{"PMU3: allFine CDD_WR_", "INT", " _", "INT", "  = ", "INT", " \n"} },
	{0x186, 	0x3,	 LOG_LEVEL_30,	{"PMU3: CDD_RW_", "INT", " _", "INT", "  = ", "INT", " \n"} },
	{0x187, 	0x3,	 LOG_LEVEL_30,	{"PMU3: CDD_WR_", "INT", " _", "INT", "  = ", "INT", " \n"} },
	{0x188, 	0x4,	 LOG_LEVEL_30,	{"PMU3: F", "INT", " BC2x_B", "INT", " _D", "INT", "  = ", "HEX", " \n"} },
	{0x189, 	0x4,	 LOG_LEVEL_30,	{"PMU3: F", "INT", " BC3x_B", "INT", " _D", "INT", "  = ", "HEX", " \n"} },
	{0x18a, 	0x4,	 LOG_LEVEL_30,	{"PMU3: F", "INT", " BC4x_B", "INT", " _D", "INT", "  = ", "HEX", " \n"} },
	{0x18b, 	0x4,	 LOG_LEVEL_30,	{"PMU3: F", "INT", " BC5x_B", "INT", " _D", "INT", "  = ", "HEX", " \n"} },
	{0x18c, 	0x4,	 LOG_LEVEL_30,	{"PMU3: F", "INT", " BC8x_B", "INT", " _D", "INT", "  = ", "HEX", " \n"} },
	{0x18d, 	0x4,	 LOG_LEVEL_30,	{"PMU3: F", "INT", " BC9x_B", "INT", " _D", "INT", "  = ", "HEX", " \n"} },
	{0x18e, 	0x4,	 LOG_LEVEL_30,	{"PMU3: F", "INT", " BCAx_B", "INT", " _D", "INT", "  = ", "HEX", " \n"} },
	{0x18f, 	0x4,	 LOG_LEVEL_30,	{"PMU3: F", "INT", " BCBx_B", "INT", " _D", "INT", "  = ", "HEX", " \n"} },
	{0x190, 	0x1,	 LOG_LEVEL_30,	{"PMU1: enter_lp3: DEBUG: pstate = ", "INT", " \n"} },
	{0x191, 	0x1,	 LOG_LEVEL_30,	{"PMU1: enter_lp3: DEBUG: dfifreqxlat_pstate = ", "INT", " \n"} },
	{0x192, 	0x1,	 LOG_LEVEL_30,	{"PMU1: enter_lp3: DEBUG: pllbypass = ", "INT", " \n"} },
	{0x193, 	0x1,	 LOG_LEVEL_30,	{"PMU1: enter_lp3: DEBUG: forcecal = ", "INT", " \n"} },
	{0x194, 	0x1,	 LOG_LEVEL_30,	{"PMU1: enter_lp3: DEBUG: pllmaxrange = ", "HEX", " \n"} },
	{0x195, 	0x1,	 LOG_LEVEL_30,	{"PMU1: enter_lp3: DEBUG: dacval_out = ", "HEX", " \n"} },
	{0x196, 	0x1,	 LOG_LEVEL_30,	{"PMU1: enter_lp3: DEBUG: pllctrl3 = ", "HEX", " \n"} },
	{0x197, 	0x0,	 LOG_LEVEL_30,	{"PMU3: Loading DRAM with BIOS supplied MR values and entering self refresh prior to exiting PMU code.\n"} },
	{0x198, 	0x2,	 LOG_LEVEL_30,	{"PMU3: Setting DataBuffer function space of dimmcs ", "HEX", "  to ", "INT", " \n"} },
	{0x199, 	0x2,	 LOG_LEVEL_30,	{"PMU4: Setting RCW FxRC", "HEX", " x = ", "HEX", " \n"} },
	{0x19a, 	0x2,	 LOG_LEVEL_30,	{"PMU4: Setting RCW FxRC", "HEX", "  = ", "HEX", " \n"} },
	{0x19b, 	0x1,	 LOG_LEVEL_30,	{"PMU1: DDR4 update Rd Pre Setting disable ", "INT", " \n"} },
	{0x19c, 	0x2,	 LOG_LEVEL_30,	{"PMU2: Setting BCW FxBC", "HEX", " x = ", "HEX", " \n"} },
	{0x19d, 	0x2,	 LOG_LEVEL_30,	{"PMU2: Setting BCW BC", "HEX", "  = ", "HEX", " \n"} },
	{0x19e, 	0x2,	 LOG_LEVEL_30,	{"PMU2: Setting BCW PBA mode FxBC", "HEX", " x = ", "HEX", " \n"} },
	{0x19f, 	0x2,	 LOG_LEVEL_30,	{"PMU2: Setting BCW PBA mode BC", "HEX", "  = ", "HEX", " \n"} },
	{0x1a0, 	0x3,	 LOG_LEVEL_30,	{"PMU4: BCW value for dimm ", "INT", " , fspace ", "INT", " , addr ", "HEX", " \n"} },
	{0x1a1, 	0x2,	 LOG_LEVEL_30,	{"PMU4: DB ", "INT", " , value ", "HEX", " \n"} },
	{0x1a2, 	0x0,	 LOG_LEVEL_30,	{"PMU6: WARNING MREP underflow, set to min value -2 coarse, 0 fine\n"} },
	{0x1a3, 	0x4,	 LOG_LEVEL_30,	{"PMU6: LRDIMM Writing final data buffer fine delay value nib ", "INT", " , trainDly ", "INT", " , fineDly code ", "INT", " , new MREP fine ", "INT", " \n"} },
	{0x1a4, 	0x3,	 LOG_LEVEL_30,	{"PMU6: LRDIMM Writing final data buffer fine delay value nib ", "INT", " , trainDly ", "INT", " , fineDly code ", "INT", " \n"} },
	{0x1a5, 	0x3,	 LOG_LEVEL_30,	{"PMU6: LRDIMM Writing data buffer fine delay type ", "INT", "  nib ", "INT", " , code ", "INT", " \n"} },
	{0x1a6, 	0x2,	 LOG_LEVEL_30,	{"PMU6: Writing final data buffer coarse delay value dbyte ", "INT", " , coarse = ", "HEX", " \n"} },
	{0x1a7, 	0x3,	 LOG_LEVEL_30,	{"PMU4: data ", "HEX", "  at MB addr ", "HEX", "  saved at CSR addr ", "HEX", " \n"} },
	{0x1a8, 	0x3,	 LOG_LEVEL_30,	{"PMU4: data ", "HEX", "  at MB addr ", "HEX", "  restored from CSR addr ", "HEX", " \n"} },
	{0x1a9, 	0x3,	 LOG_LEVEL_30,	{"PMU4: data ", "HEX", "  at MB addr ", "HEX", "  saved at CSR addr ", "HEX", " \n"} },
	{0x1aa, 	0x3,	 LOG_LEVEL_30,	{"PMU4: data ", "HEX", "  at MB addr ", "HEX", "  restored from CSR addr ", "HEX", " \n"} },
	{0x1ab, 	0x1,	 LOG_LEVEL_30,	{"PMU3: Update BC00, BC01, BC02 for rank-dimm ", "HEX", " \n"} },
	{0x1ac, 	0x0,	 LOG_LEVEL_30,	{"PMU3: Writing D4 RDIMM RCD Control words F0RC00 -> F0RC0F\n"} },
	{0x1ad, 	0x0,	 LOG_LEVEL_30,	{"PMU3: Disable parity in F0RC0E\n"} },
	{0x1ae, 	0x0,	 LOG_LEVEL_30,	{"PMU3: Writing D4 Data buffer Control words BC00 -> BC0E\n"} },
	{0x1af, 	0x2,	 LOG_LEVEL_30,	{"PMU1: setAltCL Sending MR0 ", "HEX", "  cl=", "INT", " \n"} },
	{0x1b0, 	0x2,	 LOG_LEVEL_30,	{"PMU1: restoreFromAltCL Sending MR0 ", "HEX", "  cl=", "INT", " \n"} },
	{0x1b1, 	0x2,	 LOG_LEVEL_30,	{"PMU1: restoreAcsmFromAltCL Sending MR0 ", "HEX", "  cl=", "INT", " \n"} },
	{0x1b2, 	0x2,	 LOG_LEVEL_30,	{"PMU2: Setting D3R RC", "INT", "  = ", "HEX", " \n"} },
	{0x1b3, 	0x0,	 LOG_LEVEL_30,	{"PMU3: Writing D3 RDIMM RCD Control words RC0 -> RC11\n"} },
	{0x1b4, 	0x2,	 LOG_LEVEL_30,	{"PMU0: VrefDAC0/1 vddqStart ", "INT", "  dacToVddq ", "INT", " \n"} },
	{0x1b5, 	0x1,	 LOG_LEVEL_30,	{"PMU: Error: Messageblock phyVref=", "HEX", "  is above the limit for TSMC28's attenuated LPDDR4 receivers. Please see the pub databook\n"} },
	{0x1b6, 	0x1,	 LOG_LEVEL_30,	{"PMU: Error: Messageblock phyVref=", "HEX", "  is above the limit for TSMC28's attenuated DDR4 receivers. Please see the pub databook\n"} },
	{0x1b7, 	0x1,	 LOG_LEVEL_30,	{"PMU0: PHY VREF @ (", "INT", " /1000) VDDQ\n"} },
	{0x1b8, 	0x2,	 LOG_LEVEL_30,	{"PMU0: initalizing phy vrefDacs to ", "INT", "  ExtVrefRange ", "HEX", " \n"} },
	{0x1b9, 	0x2,	 LOG_LEVEL_30,	{"PMU0: initalizing global vref to ", "INT", "  range ", "INT", " \n"} },
	{0x1ba, 	0x2,	 LOG_LEVEL_30,	{"PMU4: Setting initial device vrefDQ for CS", "INT", "  to MR6 = ", "HEX", " \n"} },
	{0x1bb, 	0x3,	 LOG_LEVEL_30,	{"PMU1: In write_level_fine() csn=", "INT", "  dimm=", "INT", "  pstate=", "INT", " \n"} },
	{0x1bc, 	0x0,	 LOG_LEVEL_30,	{"PMU3: Fine write leveling hardware search increasing TxDqsDly until full bursts are seen\n"} },
	{0x1bd, 	0x0,	 LOG_LEVEL_30,	{"PMU3: Exiting write leveling mode\n"} },
	{0x1be, 	0x1,	 LOG_LEVEL_30,	{"PMU3: got ", "INT", "  for cl in load_wrlvl_acsm\n"} },
	{0x1bf, 	0x3,	 LOG_LEVEL_30,	{"PMU1: In write_level_coarse() csn=", "INT", "  dimm=", "INT", "  pstate=", "INT", " \n"} },
	{0x1c0, 	0x3,	 LOG_LEVEL_30,	{"PMU3: left eye edge search db:", "INT", "  ln:", "INT", "  dly:", "HEX", " \n"} },
	{0x1c1, 	0x3,	 LOG_LEVEL_30,	{"PMU3: right eye edge search db:", "INT", "  ln:", "INT", "  dly:", "HEX", " \n"} },
	{0x1c2, 	0x4,	 LOG_LEVEL_30,	{"PMU3: eye center db:", "INT", "  ln:", "INT", "  dly:", "HEX", "  (maxdq:", "HEX", " )\n"} },
	{0x1c3, 	0x3,	 LOG_LEVEL_30,	{"PMU3: Wrote to TxDqDly db:", "INT", "  ln:", "INT", "  dly:", "HEX", " \n"} },
	{0x1c4, 	0x3,	 LOG_LEVEL_30,	{"PMU3: Wrote to TxDqDly db:", "INT", "  ln:", "INT", "  dly:", "HEX", " \n"} },
	{0x1c5, 	0x2,	 LOG_LEVEL_30,	{"PMU3: Coarse write leveling dbyte", "INT", "  is still failing for TxDqsDly=", "HEX", " \n"} },
	{0x1c6, 	0x2,	 LOG_LEVEL_30,	{"PMU4: Coarse write leveling iteration ", "INT", "  saw ", "INT", "  data miscompares across the entire phy\n"} },
	{0x1c7, 	0x0,	 LOG_LEVEL_30,	{"PMU: Error: Failed write leveling coarse\n"} },
	{0x1c8, 	0x1,	 LOG_LEVEL_30,	{"PMU3: got ", "INT", "  for cl in load_wrlvl_acsm\n"} },
	{0x1c9, 	0x3,	 LOG_LEVEL_30,	{"PMU3: In write_level_coarse() csn=", "INT", "  dimm=", "INT", "  pstate=", "INT", " \n"} },
	{0x1ca, 	0x3,	 LOG_LEVEL_30,	{"PMU3: left eye edge search db:", "INT", "  ln:", "INT", "  dly:", "HEX", " \n"} },
	{0x1cb, 	0x3,	 LOG_LEVEL_30,	{"PMU3: right eye edge search db: ", "INT", "  ln: ", "INT", "  dly: ", "HEX", " \n"} },
	{0x1cc, 	0x4,	 LOG_LEVEL_30,	{"PMU3: eye center db: ", "INT", "  ln: ", "INT", "  dly: ", "HEX", "  (maxdq: ", "HEX", " )\n"} },
	{0x1cd, 	0x3,	 LOG_LEVEL_30,	{"PMU3: Wrote to TxDqDly db: ", "INT", "  ln: ", "INT", "  dly: ", "HEX", " \n"} },
	{0x1ce, 	0x3,	 LOG_LEVEL_30,	{"PMU3: Wrote to TxDqDly db: ", "INT", "  ln: ", "INT", "  dly: ", "HEX", " \n"} },
	{0x1cf, 	0x2,	 LOG_LEVEL_30,	{"PMU3: Coarse write leveling nibble", "INT", "  is still failing for TxDqsDly=", "HEX", " \n"} },
	{0x1d0, 	0x2,	 LOG_LEVEL_30,	{"PMU4: Coarse write leveling iteration ", "INT", "  saw ", "INT", "  data miscompares across the entire phy\n"} },
	{0x1d1, 	0x0,	 LOG_LEVEL_30,	{"PMU: Error: Failed write leveling coarse\n"} },
	{0x1d2, 	0x3,	 LOG_LEVEL_30,	{"PMU3: In write_level_coarse() csn=", "INT", "  dimm=", "INT", "  pstate=", "INT", " \n"} },
	{0x1d3, 	0x5,	 LOG_LEVEL_30,	{"PMU2: Write level: dbyte ", "INT", "  nib", "INT", "  dq/dmbi ", "INT", "  dqsfine ", "HEX", "  dqDly ", "HEX", " \n"} },
	{0x1d4, 	0x2,	 LOG_LEVEL_30,	{"PMU3: Coarse write leveling nibble", "INT", "  is still failing for TxDqsDly=", "HEX", " \n"} },
	{0x1d5, 	0x2,	 LOG_LEVEL_30,	{"PMU4: Coarse write leveling iteration ", "INT", "  saw ", "INT", "  data miscompares across the entire phy\n"} },
	{0x1d6, 	0x0,	 LOG_LEVEL_30,	{"PMU: Error: Failed write leveling coarse\n"} },
	{0x1d7, 	0x1,	 LOG_LEVEL_30,	{"PMU3: DWL delay = ", "INT", " \n"} },
	{0x1d8, 	0x3,	 LOG_LEVEL_30,	{"PMU3: Errcnt for DWL nib ", "INT", "  delay = ", "INT", "  is ", "INT", " \n"} },
	{0x1d9, 	0x2,	 LOG_LEVEL_30,	{"PMU3: DWL nibble ", "INT", "  sampled a 1 at delay ", "INT", " \n"} },
	{0x1da, 	0x3,	 LOG_LEVEL_30,	{"PMU3: DWL nibble ", "INT", "  passed at delay ", "INT", " . Rising edge was at ", "INT", " \n"} },
	{0x1db, 	0x0,	 LOG_LEVEL_30,	{"PMU2: DWL did nto find a rising edge of memclk for all nibbles. Failing nibbles assumed to have rising edge at fine delay 63\n"} },
	{0x400, 	0x0,	 LOG_LEVEL_30,	{"PMU: Error:Mailbox Buffer Overflowed.\n"} },
	{0x401, 	0x0,	 LOG_LEVEL_30,	{"PMU: Error:Mailbox Buffer Overflowed.\n"} },
	{0x402, 	0x0,	 LOG_LEVEL_30,	{"PMU: ***** Assertion Error - terminating *****\n"} },
	{0x403, 	0x2,	 LOG_LEVEL_30,	{"PMU1: swapByte db ", "INT", "  by ", "INT", " \n"} },
	{0x404, 	0x3,	 LOG_LEVEL_30,	{"PMU3: get_cmd_dly max(", "INT", "  ps, ", "INT", "  memclk) = ", "INT", " \n"} },
	{0x405, 	0x2,	 LOG_LEVEL_30,	{"PMU0: Write CSR ", "HEX", "  ", "HEX", " \n"} },
	{0x406, 	0x2,	 LOG_LEVEL_30,	{"PMU0: hwt_init_ppgc_prbs(): Polynomial: ", "HEX", " , Deg: ", "INT", " \n"} },
	{0x407, 	0x1,	 LOG_LEVEL_30,	{"PMU: Error: acsm_set_cmd to non existant instruction adddress ", "INT", " \n"} },
	{0x408, 	0x1,	 LOG_LEVEL_30,	{"PMU: Error: acsm_set_cmd with unknown ddr cmd ", "HEX", " \n"} },
	{0x409, 	0xc,	 LOG_LEVEL_30,	{"PMU1: acsm_addr ", "HEX", " , acsm_flgs ", "HEX", " , ddr_cmd ", "HEX", " , cmd_dly ", "HEX", " , ddr_addr ", "HEX", " , ddr_bnk ", "HEX", " , ddr_cs ", "HEX", " , cmd_rcnt ", "HEX", " , AcsmSeq0/1/2/3 ", "HEX", "  ", "HEX", "  ", "HEX", "  ", "HEX", " \n"} },
	{0x40a, 	0x0,	 LOG_LEVEL_30,	{"PMU: Error: Polling on ACSM done failed to complete in acsm_poll_done()...\n"} },
	{0x40b, 	0x0,	 LOG_LEVEL_30,	{"PMU1: acsm RUN\n"} },
	{0x40c, 	0x0,	 LOG_LEVEL_30,	{"PMU1: acsm STOPPED\n"} },
	{0x40d, 	0x2,	 LOG_LEVEL_30,	{"PMU1: acsm_init: acsm_mode ", "HEX", "  mxrdlat ", "HEX", " \n"} },
	{0x40e, 	0x2,	 LOG_LEVEL_30,	{"PMU: Error: setAcsmCLCWL: cl and cwl must be each >= 2 and 5, resp. CL=", "INT", "  CWL=", "INT", " \n"} },
	{0x40f, 	0x2,	 LOG_LEVEL_30,	{"PMU: Error: setAcsmCLCWL: cl and cwl must be each >= 5. CL=", "INT", "  CWL=", "INT", " \n"} },
	{0x410, 	0x2,	 LOG_LEVEL_30,	{"PMU1: setAcsmCLCWL: CASL ", "INT", "  WCASL ", "INT", " \n"} },
	{0x411, 	0x1,	 LOG_LEVEL_30,	{"PMU: Error: Reserved value of register F0RC0F found in message block: ", "HEX", " \n"} },
	{0x412, 	0x1,	 LOG_LEVEL_30,	{"PMU3: Written MRS to CS=", "HEX", " \n"} },
	{0x413, 	0x1,	 LOG_LEVEL_30,	{"PMU3: Written MRS to CS=", "HEX", " \n"} },
	{0x414, 	0x0,	 LOG_LEVEL_30,	{"PMU3: Entering Boot Freq Mode.\n"} },
	{0x415, 	0x1,	 LOG_LEVEL_30,	{"PMU: Error: Boot clock divider setting of ", "INT", "  is too small\n"} },
	{0x416, 	0x0,	 LOG_LEVEL_30,	{"PMU3: Exiting Boot Freq Mode.\n"} },
	{0x417, 	0x2,	 LOG_LEVEL_30,	{"PMU3: Writing MR", "INT", "  OP=", "HEX", " \n"} },
	{0x418, 	0x0,	 LOG_LEVEL_30,	{"PMU: Error: Delay too large in slomo\n"} },
	{0x419, 	0x1,	 LOG_LEVEL_30,	{"PMU3: Written MRS to CS=", "HEX", " \n"} },
	{0x41a, 	0x0,	 LOG_LEVEL_30,	{"PMU3: Enable Channel A\n"} },
	{0x41b, 	0x0,	 LOG_LEVEL_30,	{"PMU3: Enable Channel B\n"} },
	{0x41c, 	0x0,	 LOG_LEVEL_30,	{"PMU3: Enable All Channels\n"} },
	{0x41d, 	0x2,	 LOG_LEVEL_30,	{"PMU2: Use PDA mode to set MR", "INT", "  with value ", "HEX", " \n"} },
	{0x41e, 	0x1,	 LOG_LEVEL_30,	{"PMU3: Written Vref with PDA to CS=", "HEX", " \n"} },
	{0x41f, 	0x0,	 LOG_LEVEL_30,	{"PMU1: start_cal: DEBUG: setting CalRun to 1\n"} },
	{0x420, 	0x0,	 LOG_LEVEL_30,	{"PMU1: start_cal: DEBUG: setting CalRun to 0\n"} },
	{0x421, 	0x1,	 LOG_LEVEL_30,	{"PMU1: lock_pll_dll: DEBUG: pstate = ", "INT", " \n"} },
	{0x422, 	0x1,	 LOG_LEVEL_30,	{"PMU1: lock_pll_dll: DEBUG: dfifreqxlat_pstate = ", "INT", " \n"} },
	{0x423, 	0x1,	 LOG_LEVEL_30,	{"PMU1: lock_pll_dll: DEBUG: pllbypass = ", "INT", " \n"} },
	{0x424, 	0x1,	 LOG_LEVEL_30,	{"PMU3: SaveLcdlSeed: Saving seed seed ", "INT", " \n"} },
	{0x425, 	0x0,	 LOG_LEVEL_30,	{"PMU1: in phy_defaults()\n"} },
	{0x426, 	0x3,	 LOG_LEVEL_30,	{"PMU3: ACXConf:", "INT", "  MaxNumDbytes:", "INT", "  NumDfi:", "INT", " \n"} },
#endif
	{0x427, 	0x5,	 LOG_LEVEL_30,	{"PMU1: setAltAcsmCLCWL setting cl=", "INT", "  cwl=", "INT", " \n"} }
};

#endif	/* _SNPS_MAILBOX_H_ */
