/*******************************************************************************
Copyright (C) 2016 Marvell International Ltd.

This software file (the "File") is owned and distributed by Marvell
International Ltd. and/or its affiliates ("Marvell") under the following
alternative licensing terms.  Once you have made an election to distribute the
File under one of the following license alternatives, please (i) delete this
introductory statement regarding license alternatives, (ii) delete the three
license alternatives that you have not elected to use and (iii) preserve the
Marvell copyright notice above.

********************************************************************************
Marvell Commercial License Option

If you received this File from Marvell and you have entered into a commercial
license agreement (a "Commercial License") with Marvell, the File is licensed
to you under the terms of the applicable Commercial License.

********************************************************************************
Marvell GPL License Option

This program is free software: you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by the Free
Software Foundation, either version 2 of the License, or any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.

********************************************************************************
Marvell GNU General Public License FreeRTOS Exception

If you received this File from Marvell, you may opt to use, redistribute and/or
modify this File in accordance with the terms and conditions of the Lesser
General Public License Version 2.1 plus the following FreeRTOS exception.
An independent module is a module which is not derived from or based on
FreeRTOS.
Clause 1:
Linking FreeRTOS statically or dynamically with other modules is making a
combined work based on FreeRTOS. Thus, the terms and conditions of the GNU
General Public License cover the whole combination.
As a special exception, the copyright holder of FreeRTOS gives you permission
to link FreeRTOS with independent modules that communicate with FreeRTOS solely
through the FreeRTOS API interface, regardless of the license terms of these
independent modules, and to copy and distribute the resulting combined work
under terms of your choice, provided that:
1. Every copy of the combined work is accompanied by a written statement that
details to the recipient the version of FreeRTOS used and an offer by yourself
to provide the FreeRTOS source code (including any modifications you may have
made) should the recipient request it.
2. The combined work is not itself an RTOS, scheduler, kernel or related
product.
3. The independent modules add significant and primary functionality to
FreeRTOS and do not merely extend the existing functionality already present in
FreeRTOS.
Clause 2:
FreeRTOS may not be used for any competitive or comparative purpose, including
the publication of any form of run time or compile time metric, without the
express permission of Real Time Engineers Ltd. (this is the norm within the
industry and is intended to ensure information accuracy).

********************************************************************************
Marvell BSD License Option

If you received this File from Marvell, you may opt to use, redistribute and/or
modify this File under the following licensing terms.
Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

	* Redistributions of source code must retain the above copyright notice,
	  this list of conditions and the following disclaimer.

	* Redistributions in binary form must reproduce the above copyright
	  notice, this list of conditions and the following disclaimer in the
	  documentation and/or other materials provided with the distribution.

	* Neither the name of Marvell nor the names of its contributors may be
	  used to endorse or promote products derived from this software without
	  specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

*******************************************************************************/

#ifndef __DDR3_PATTERNS_64_H
#define __DDR3_PATTERNS_64_H

#define FAB_OPT		21
/*
 * Patterns Declerations
 */

u32 wl_sup_pattern[LEN_WL_SUP_PATTERN] __aligned(32) = {
	0x04030201, 0x08070605, 0x0c0b0a09, 0x100f0e0d,
	0x14131211, 0x18171615, 0x1c1b1a19, 0x201f1e1d,
	0x24232221, 0x28272625, 0x2c2b2a29, 0x302f2e2d,
	0x34333231, 0x38373635, 0x3c3b3a39, 0x403f3e3d,
	0x44434241, 0x48474645, 0x4c4b4a49, 0x504f4e4d,
	0x54535251, 0x58575655, 0x5c5b5a59, 0x605f5e5d,
	0x64636261, 0x68676665, 0x6c6b6a69, 0x706f6e6d,
	0x74737271, 0x78777675, 0x7c7b7a79, 0x807f7e7d
};

u32 pbs_pattern_32b[2][LEN_PBS_PATTERN] __aligned(32) = {
	{
		0xaaaaaaaa, 0x55555555, 0xaaaaaaaa, 0x55555555,
		0xaaaaaaaa, 0x55555555, 0xaaaaaaaa, 0x55555555,
		0xaaaaaaaa, 0x55555555, 0xaaaaaaaa, 0x55555555,
		0xaaaaaaaa, 0x55555555, 0xaaaaaaaa, 0x55555555
	},
	{
		0x55555555, 0xaaaaaaaa, 0x55555555, 0xaaaaaaaa,
		0x55555555, 0xaaaaaaaa, 0x55555555, 0xaaaaaaaa,
		0x55555555, 0xaaaaaaaa, 0x55555555, 0xaaaaaaaa,
		0x55555555, 0xaaaaaaaa, 0x55555555, 0xaaaaaaaa
	}
};

u32 pbs_pattern_64b[2][LEN_PBS_PATTERN] __aligned(32) = {
	{
		0xaaaaaaaa, 0xaaaaaaaa, 0x55555555, 0x55555555,
		0xaaaaaaaa, 0xaaaaaaaa, 0x55555555, 0x55555555,
		0xaaaaaaaa, 0xaaaaaaaa, 0x55555555, 0x55555555,
		0xaaaaaaaa, 0xaaaaaaaa, 0x55555555, 0x55555555
	},
	{
		0x55555555, 0x55555555, 0xaaaaaaaa, 0xaaaaaaaa,
		0x55555555, 0x55555555, 0xaaaaaaaa, 0xaaaaaaaa,
		0x55555555, 0x55555555, 0xaaaaaaaa, 0xaaaaaaaa,
		0x55555555, 0x55555555, 0xaaaaaaaa, 0xaaaaaaaa
	}
};

u32 rl_pattern[LEN_STD_PATTERN] __aligned(32) = {
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x01010101, 0x01010101, 0x01010101, 0x01010101
};

u32 killer_pattern_32b[DQ_NUM][LEN_KILLER_PATTERN] __aligned(32) = {
	{
		0x01010101, 0x00000000, 0x01010101, 0xffffffff,
		0x01010101, 0x00000000, 0x01010101, 0xffffffff,
		0xfefefefe, 0xfefefefe, 0x01010101, 0xfefefefe,
		0xfefefefe, 0xfefefefe, 0x01010101, 0xfefefefe,
		0x01010101, 0xfefefefe, 0x01010101, 0x01010101,
		0x01010101, 0xfefefefe, 0x01010101, 0x01010101,
		0xfefefefe, 0x01010101, 0xfefefefe, 0x00000000,
		0xfefefefe, 0x01010101, 0xfefefefe, 0x00000000,
		0xffffffff, 0x00000000, 0xffffffff, 0x00000000,
		0xffffffff, 0x00000000, 0xffffffff, 0x00000000,
		0xffffffff, 0x00000000, 0xffffffff, 0x01010101,
		0xffffffff, 0x00000000, 0xffffffff, 0x01010101,
		0x00000000, 0xffffffff, 0x00000000, 0xffffffff,
		0x00000000, 0xffffffff, 0x00000000, 0xffffffff,
		0x00000000, 0x00000000, 0x00000000, 0xfefefefe,
		0x00000000, 0x00000000, 0x00000000, 0xfefefefe,
		0xfefefefe, 0xffffffff, 0x00000000, 0x00000000,
		0xfefefefe, 0xffffffff, 0x00000000, 0x00000000,
		0xffffffff, 0xffffffff, 0x00000000, 0xffffffff,
		0xffffffff, 0xffffffff, 0x00000000, 0xffffffff,
		0x00000000, 0xffffffff, 0xffffffff, 0x00000000,
		0x00000000, 0xffffffff, 0xffffffff, 0x00000000,
		0x00000000, 0xffffffff, 0x00000000, 0xffffffff,
		0x00000000, 0xffffffff, 0x00000000, 0xffffffff,
		0xfefefefe, 0x00000000, 0xfefefefe, 0x00000000,
		0xfefefefe, 0x00000000, 0xfefefefe, 0x00000000,
		0x00000000, 0xffffffff, 0xffffffff, 0x01010101,
		0x00000000, 0xffffffff, 0xffffffff, 0x01010101,
		0xffffffff, 0xffffffff, 0x01010101, 0x00000000,
		0xffffffff, 0xffffffff, 0x01010101, 0x00000000,
		0x01010101, 0xffffffff, 0xfefefefe, 0xfefefefe,
		0x01010101, 0xffffffff, 0xfefefefe, 0xfefefefe
	},
	{
		0x02020202, 0x00000000, 0x02020202, 0xffffffff,
		0x02020202, 0x00000000, 0x02020202, 0xffffffff,
		0xfdfdfdfd, 0xfdfdfdfd, 0x02020202, 0xfdfdfdfd,
		0xfdfdfdfd, 0xfdfdfdfd, 0x02020202, 0xfdfdfdfd,
		0x02020202, 0xfdfdfdfd, 0x02020202, 0x02020202,
		0x02020202, 0xfdfdfdfd, 0x02020202, 0x02020202,
		0xfdfdfdfd, 0x02020202, 0xfdfdfdfd, 0x00000000,
		0xfdfdfdfd, 0x02020202, 0xfdfdfdfd, 0x00000000,
		0xffffffff, 0x00000000, 0xffffffff, 0x00000000,
		0xffffffff, 0x00000000, 0xffffffff, 0x00000000,
		0xffffffff, 0x00000000, 0xffffffff, 0x02020202,
		0xffffffff, 0x00000000, 0xffffffff, 0x02020202,
		0x00000000, 0xffffffff, 0x00000000, 0xffffffff,
		0x00000000, 0xffffffff, 0x00000000, 0xffffffff,
		0x00000000, 0x00000000, 0x00000000, 0xfdfdfdfd,
		0x00000000, 0x00000000, 0x00000000, 0xfdfdfdfd,
		0xfdfdfdfd, 0xffffffff, 0x00000000, 0x00000000,
		0xfdfdfdfd, 0xffffffff, 0x00000000, 0x00000000,
		0xffffffff, 0xffffffff, 0x00000000, 0xffffffff,
		0xffffffff, 0xffffffff, 0x00000000, 0xffffffff,
		0x00000000, 0xffffffff, 0xffffffff, 0x00000000,
		0x00000000, 0xffffffff, 0xffffffff, 0x00000000,
		0x00000000, 0xffffffff, 0x00000000, 0xffffffff,
		0x00000000, 0xffffffff, 0x00000000, 0xffffffff,
		0xfdfdfdfd, 0x00000000, 0xfdfdfdfd, 0x00000000,
		0xfdfdfdfd, 0x00000000, 0xfdfdfdfd, 0x00000000,
		0x00000000, 0xffffffff, 0xffffffff, 0x02020202,
		0x00000000, 0xffffffff, 0xffffffff, 0x02020202,
		0xffffffff, 0xffffffff, 0x02020202, 0x00000000,
		0xffffffff, 0xffffffff, 0x02020202, 0x00000000,
		0x02020202, 0xffffffff, 0xfdfdfdfd, 0xfdfdfdfd,
		0x02020202, 0xffffffff, 0xfdfdfdfd, 0xfdfdfdfd
	},
	{
		0x04040404, 0x00000000, 0x04040404, 0xffffffff,
		0x04040404, 0x00000000, 0x04040404, 0xffffffff,
		0xfbfbfbfb, 0xfbfbfbfb, 0x04040404, 0xfbfbfbfb,
		0xfbfbfbfb, 0xfbfbfbfb, 0x04040404, 0xfbfbfbfb,
		0x04040404, 0xfbfbfbfb, 0x04040404, 0x04040404,
		0x04040404, 0xfbfbfbfb, 0x04040404, 0x04040404,
		0xfbfbfbfb, 0x04040404, 0xfbfbfbfb, 0x00000000,
		0xfbfbfbfb, 0x04040404, 0xfbfbfbfb, 0x00000000,
		0xffffffff, 0x00000000, 0xffffffff, 0x00000000,
		0xffffffff, 0x00000000, 0xffffffff, 0x00000000,
		0xffffffff, 0x00000000, 0xffffffff, 0x04040404,
		0xffffffff, 0x00000000, 0xffffffff, 0x04040404,
		0x00000000, 0xffffffff, 0x00000000, 0xffffffff,
		0x00000000, 0xffffffff, 0x00000000, 0xffffffff,
		0x00000000, 0x00000000, 0x00000000, 0xfbfbfbfb,
		0x00000000, 0x00000000, 0x00000000, 0xfbfbfbfb,
		0xfbfbfbfb, 0xffffffff, 0x00000000, 0x00000000,
		0xfbfbfbfb, 0xffffffff, 0x00000000, 0x00000000,
		0xffffffff, 0xffffffff, 0x00000000, 0xffffffff,
		0xffffffff, 0xffffffff, 0x00000000, 0xffffffff,
		0x00000000, 0xffffffff, 0xffffffff, 0x00000000,
		0x00000000, 0xffffffff, 0xffffffff, 0x00000000,
		0x00000000, 0xffffffff, 0x00000000, 0xffffffff,
		0x00000000, 0xffffffff, 0x00000000, 0xffffffff,
		0xfbfbfbfb, 0x00000000, 0xfbfbfbfb, 0x00000000,
		0xfbfbfbfb, 0x00000000, 0xfbfbfbfb, 0x00000000,
		0x00000000, 0xffffffff, 0xffffffff, 0x04040404,
		0x00000000, 0xffffffff, 0xffffffff, 0x04040404,
		0xffffffff, 0xffffffff, 0x04040404, 0x00000000,
		0xffffffff, 0xffffffff, 0x04040404, 0x00000000,
		0x04040404, 0xffffffff, 0xfbfbfbfb, 0xfbfbfbfb,
		0x04040404, 0xffffffff, 0xfbfbfbfb, 0xfbfbfbfb
	},
	{
		0x08080808, 0x00000000, 0x08080808, 0xffffffff,
		0x08080808, 0x00000000, 0x08080808, 0xffffffff,
		0xf7f7f7f7, 0xf7f7f7f7, 0x08080808, 0xf7f7f7f7,
		0xf7f7f7f7, 0xf7f7f7f7, 0x08080808, 0xf7f7f7f7,
		0x08080808, 0xf7f7f7f7, 0x08080808, 0x08080808,
		0x08080808, 0xf7f7f7f7, 0x08080808, 0x08080808,
		0xf7f7f7f7, 0x08080808, 0xf7f7f7f7, 0x00000000,
		0xf7f7f7f7, 0x08080808, 0xf7f7f7f7, 0x00000000,
		0xffffffff, 0x00000000, 0xffffffff, 0x00000000,
		0xffffffff, 0x00000000, 0xffffffff, 0x00000000,
		0xffffffff, 0x00000000, 0xffffffff, 0x08080808,
		0xffffffff, 0x00000000, 0xffffffff, 0x08080808,
		0x00000000, 0xffffffff, 0x00000000, 0xffffffff,
		0x00000000, 0xffffffff, 0x00000000, 0xffffffff,
		0x00000000, 0x00000000, 0x00000000, 0xf7f7f7f7,
		0x00000000, 0x00000000, 0x00000000, 0xf7f7f7f7,
		0xf7f7f7f7, 0xffffffff, 0x00000000, 0x00000000,
		0xf7f7f7f7, 0xffffffff, 0x00000000, 0x00000000,
		0xffffffff, 0xffffffff, 0x00000000, 0xffffffff,
		0xffffffff, 0xffffffff, 0x00000000, 0xffffffff,
		0x00000000, 0xffffffff, 0xffffffff, 0x00000000,
		0x00000000, 0xffffffff, 0xffffffff, 0x00000000,
		0x00000000, 0xffffffff, 0x00000000, 0xffffffff,
		0x00000000, 0xffffffff, 0x00000000, 0xffffffff,
		0xf7f7f7f7, 0x00000000, 0xf7f7f7f7, 0x00000000,
		0xf7f7f7f7, 0x00000000, 0xf7f7f7f7, 0x00000000,
		0x00000000, 0xffffffff, 0xffffffff, 0x08080808,
		0x00000000, 0xffffffff, 0xffffffff, 0x08080808,
		0xffffffff, 0xffffffff, 0x08080808, 0x00000000,
		0xffffffff, 0xffffffff, 0x08080808, 0x00000000,
		0x08080808, 0xffffffff, 0xf7f7f7f7, 0xf7f7f7f7,
		0x08080808, 0xffffffff, 0xf7f7f7f7, 0xf7f7f7f7
	},
	{
		0x10101010, 0x00000000, 0x10101010, 0xffffffff,
		0x10101010, 0x00000000, 0x10101010, 0xffffffff,
		0xefefefef, 0xefefefef, 0x10101010, 0xefefefef,
		0xefefefef, 0xefefefef, 0x10101010, 0xefefefef,
		0x10101010, 0xefefefef, 0x10101010, 0x10101010,
		0x10101010, 0xefefefef, 0x10101010, 0x10101010,
		0xefefefef, 0x10101010, 0xefefefef, 0x00000000,
		0xefefefef, 0x10101010, 0xefefefef, 0x00000000,
		0xffffffff, 0x00000000, 0xffffffff, 0x00000000,
		0xffffffff, 0x00000000, 0xffffffff, 0x00000000,
		0xffffffff, 0x00000000, 0xffffffff, 0x10101010,
		0xffffffff, 0x00000000, 0xffffffff, 0x10101010,
		0x00000000, 0xffffffff, 0x00000000, 0xffffffff,
		0x00000000, 0xffffffff, 0x00000000, 0xffffffff,
		0x00000000, 0x00000000, 0x00000000, 0xefefefef,
		0x00000000, 0x00000000, 0x00000000, 0xefefefef,
		0xefefefef, 0xffffffff, 0x00000000, 0x00000000,
		0xefefefef, 0xffffffff, 0x00000000, 0x00000000,
		0xffffffff, 0xffffffff, 0x00000000, 0xffffffff,
		0xffffffff, 0xffffffff, 0x00000000, 0xffffffff,
		0x00000000, 0xffffffff, 0xffffffff, 0x00000000,
		0x00000000, 0xffffffff, 0xffffffff, 0x00000000,
		0x00000000, 0xffffffff, 0x00000000, 0xffffffff,
		0x00000000, 0xffffffff, 0x00000000, 0xffffffff,
		0xefefefef, 0x00000000, 0xefefefef, 0x00000000,
		0xefefefef, 0x00000000, 0xefefefef, 0x00000000,
		0x00000000, 0xffffffff, 0xffffffff, 0x10101010,
		0x00000000, 0xffffffff, 0xffffffff, 0x10101010,
		0xffffffff, 0xffffffff, 0x10101010, 0x00000000,
		0xffffffff, 0xffffffff, 0x10101010, 0x00000000,
		0x10101010, 0xffffffff, 0xefefefef, 0xefefefef,
		0x10101010, 0xffffffff, 0xefefefef, 0xefefefef
	},
	{
		0x20202020, 0x00000000, 0x20202020, 0xffffffff,
		0x20202020, 0x00000000, 0x20202020, 0xffffffff,
		0xdfdfdfdf, 0xdfdfdfdf, 0x20202020, 0xdfdfdfdf,
		0xdfdfdfdf, 0xdfdfdfdf, 0x20202020, 0xdfdfdfdf,
		0x20202020, 0xdfdfdfdf, 0x20202020, 0x20202020,
		0x20202020, 0xdfdfdfdf, 0x20202020, 0x20202020,
		0xdfdfdfdf, 0x20202020, 0xdfdfdfdf, 0x00000000,
		0xdfdfdfdf, 0x20202020, 0xdfdfdfdf, 0x00000000,
		0xffffffff, 0x00000000, 0xffffffff, 0x00000000,
		0xffffffff, 0x00000000, 0xffffffff, 0x00000000,
		0xffffffff, 0x00000000, 0xffffffff, 0x20202020,
		0xffffffff, 0x00000000, 0xffffffff, 0x20202020,
		0x00000000, 0xffffffff, 0x00000000, 0xffffffff,
		0x00000000, 0xffffffff, 0x00000000, 0xffffffff,
		0x00000000, 0x00000000, 0x00000000, 0xdfdfdfdf,
		0x00000000, 0x00000000, 0x00000000, 0xdfdfdfdf,
		0xdfdfdfdf, 0xffffffff, 0x00000000, 0x00000000,
		0xdfdfdfdf, 0xffffffff, 0x00000000, 0x00000000,
		0xffffffff, 0xffffffff, 0x00000000, 0xffffffff,
		0xffffffff, 0xffffffff, 0x00000000, 0xffffffff,
		0x00000000, 0xffffffff, 0xffffffff, 0x00000000,
		0x00000000, 0xffffffff, 0xffffffff, 0x00000000,
		0x00000000, 0xffffffff, 0x00000000, 0xffffffff,
		0x00000000, 0xffffffff, 0x00000000, 0xffffffff,
		0xdfdfdfdf, 0x00000000, 0xdfdfdfdf, 0x00000000,
		0xdfdfdfdf, 0x00000000, 0xdfdfdfdf, 0x00000000,
		0x00000000, 0xffffffff, 0xffffffff, 0x20202020,
		0x00000000, 0xffffffff, 0xffffffff, 0x20202020,
		0xffffffff, 0xffffffff, 0x20202020, 0x00000000,
		0xffffffff, 0xffffffff, 0x20202020, 0x00000000,
		0x20202020, 0xffffffff, 0xdfdfdfdf, 0xdfdfdfdf,
		0x20202020, 0xffffffff, 0xdfdfdfdf, 0xdfdfdfdf
	},
	{
		0x40404040, 0x00000000, 0x40404040, 0xffffffff,
		0x40404040, 0x00000000, 0x40404040, 0xffffffff,
		0xbfbfbfbf, 0xbfbfbfbf, 0x40404040, 0xbfbfbfbf,
		0xbfbfbfbf, 0xbfbfbfbf, 0x40404040, 0xbfbfbfbf,
		0x40404040, 0xbfbfbfbf, 0x40404040, 0x40404040,
		0x40404040, 0xbfbfbfbf, 0x40404040, 0x40404040,
		0xbfbfbfbf, 0x40404040, 0xbfbfbfbf, 0x00000000,
		0xbfbfbfbf, 0x40404040, 0xbfbfbfbf, 0x00000000,
		0xffffffff, 0x00000000, 0xffffffff, 0x00000000,
		0xffffffff, 0x00000000, 0xffffffff, 0x00000000,
		0xffffffff, 0x00000000, 0xffffffff, 0x40404040,
		0xffffffff, 0x00000000, 0xffffffff, 0x40404040,
		0x00000000, 0xffffffff, 0x00000000, 0xffffffff,
		0x00000000, 0xffffffff, 0x00000000, 0xffffffff,
		0x00000000, 0x00000000, 0x00000000, 0xbfbfbfbf,
		0x00000000, 0x00000000, 0x00000000, 0xbfbfbfbf,
		0xbfbfbfbf, 0xffffffff, 0x00000000, 0x00000000,
		0xbfbfbfbf, 0xffffffff, 0x00000000, 0x00000000,
		0xffffffff, 0xffffffff, 0x00000000, 0xffffffff,
		0xffffffff, 0xffffffff, 0x00000000, 0xffffffff,
		0x00000000, 0xffffffff, 0xffffffff, 0x00000000,
		0x00000000, 0xffffffff, 0xffffffff, 0x00000000,
		0x00000000, 0xffffffff, 0x00000000, 0xffffffff,
		0x00000000, 0xffffffff, 0x00000000, 0xffffffff,
		0xbfbfbfbf, 0x00000000, 0xbfbfbfbf, 0x00000000,
		0xbfbfbfbf, 0x00000000, 0xbfbfbfbf, 0x00000000,
		0x00000000, 0xffffffff, 0xffffffff, 0x40404040,
		0x00000000, 0xffffffff, 0xffffffff, 0x40404040,
		0xffffffff, 0xffffffff, 0x40404040, 0x00000000,
		0xffffffff, 0xffffffff, 0x40404040, 0x00000000,
		0x40404040, 0xffffffff, 0xbfbfbfbf, 0xbfbfbfbf,
		0x40404040, 0xffffffff, 0xbfbfbfbf, 0xbfbfbfbf
	},
	{
		0x80808080, 0x00000000, 0x80808080, 0xffffffff,
		0x80808080, 0x00000000, 0x80808080, 0xffffffff,
		0x7f7f7f7f, 0x7f7f7f7f, 0x80808080, 0x7f7f7f7f,
		0x7f7f7f7f, 0x7f7f7f7f, 0x80808080, 0x7f7f7f7f,
		0x80808080, 0x7f7f7f7f, 0x80808080, 0x80808080,
		0x80808080, 0x7f7f7f7f, 0x80808080, 0x80808080,
		0x7f7f7f7f, 0x80808080, 0x7f7f7f7f, 0x00000000,
		0x7f7f7f7f, 0x80808080, 0x7f7f7f7f, 0x00000000,
		0xffffffff, 0x00000000, 0xffffffff, 0x00000000,
		0xffffffff, 0x00000000, 0xffffffff, 0x00000000,
		0xffffffff, 0x00000000, 0xffffffff, 0x80808080,
		0xffffffff, 0x00000000, 0xffffffff, 0x80808080,
		0x00000000, 0xffffffff, 0x00000000, 0xffffffff,
		0x00000000, 0xffffffff, 0x00000000, 0xffffffff,
		0x00000000, 0x00000000, 0x00000000, 0x7f7f7f7f,
		0x00000000, 0x00000000, 0x00000000, 0x7f7f7f7f,
		0x7f7f7f7f, 0xffffffff, 0x00000000, 0x00000000,
		0x7f7f7f7f, 0xffffffff, 0x00000000, 0x00000000,
		0xffffffff, 0xffffffff, 0x00000000, 0xffffffff,
		0xffffffff, 0xffffffff, 0x00000000, 0xffffffff,
		0x00000000, 0xffffffff, 0xffffffff, 0x00000000,
		0x00000000, 0xffffffff, 0xffffffff, 0x00000000,
		0x00000000, 0xffffffff, 0x00000000, 0xffffffff,
		0x00000000, 0xffffffff, 0x00000000, 0xffffffff,
		0x7f7f7f7f, 0x00000000, 0x7f7f7f7f, 0x00000000,
		0x7f7f7f7f, 0x00000000, 0x7f7f7f7f, 0x00000000,
		0x00000000, 0xffffffff, 0xffffffff, 0x80808080,
		0x00000000, 0xffffffff, 0xffffffff, 0x80808080,
		0xffffffff, 0xffffffff, 0x80808080, 0x00000000,
		0xffffffff, 0xffffffff, 0x80808080, 0x00000000,
		0x80808080, 0xffffffff, 0x7f7f7f7f, 0x7f7f7f7f,
		0x80808080, 0xffffffff, 0x7f7f7f7f, 0x7f7f7f7f
	}
};

u32 killer_pattern_64b[DQ_NUM][LEN_KILLER_PATTERN] __aligned(32) = {
	{
		0x01010101, 0x01010101, 0x00000000, 0x00000000,
		0x01010101, 0x01010101, 0xffffffff, 0xffffffff,
		0xfefefefe, 0xfefefefe, 0xfefefefe, 0xfefefefe,
		0x01010101, 0x01010101, 0xfefefefe, 0xfefefefe,
		0x01010101, 0x01010101, 0xfefefefe, 0xfefefefe,
		0x01010101, 0x01010101, 0x01010101, 0x01010101,
		0xfefefefe, 0xfefefefe, 0x01010101, 0x01010101,
		0xfefefefe, 0xfefefefe, 0x00000000, 0x00000000,
		0xffffffff, 0xffffffff, 0x00000000, 0x00000000,
		0xffffffff, 0xffffffff, 0x00000000, 0x00000000,
		0xffffffff, 0xffffffff, 0x00000000, 0x00000000,
		0xffffffff, 0xffffffff, 0x01010101, 0x01010101,
		0x00000000, 0x00000000, 0xffffffff, 0xffffffff,
		0x00000000, 0x00000000, 0xffffffff, 0xffffffff,
		0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0xfefefefe, 0xfefefefe,
		0xfefefefe, 0xfefefefe, 0xffffffff, 0xffffffff,
		0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
		0x00000000, 0x00000000, 0xffffffff, 0xffffffff,
		0x00000000, 0x00000000, 0xffffffff, 0xffffffff,
		0xffffffff, 0xffffffff, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0xffffffff, 0xffffffff,
		0x00000000, 0x00000000, 0xffffffff, 0xffffffff,
		0xfefefefe, 0xfefefefe, 0x00000000, 0x00000000,
		0xfefefefe, 0xfefefefe, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0xffffffff, 0xffffffff,
		0xffffffff, 0xffffffff, 0x01010101, 0x01010101,
		0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
		0x01010101, 0x01010101, 0x00000000, 0x00000000,
		0x01010101, 0x01010101, 0xffffffff, 0xffffffff,
		0xfefefefe, 0xfefefefe, 0xfefefefe, 0xfefefefe
	},
	{
		0x02020202, 0x02020202, 0x00000000, 0x00000000,
		0x02020202, 0x02020202, 0xffffffff, 0xffffffff,
		0xfdfdfdfd, 0xfdfdfdfd, 0xfdfdfdfd, 0xfdfdfdfd,
		0x02020202, 0x02020202, 0xfdfdfdfd, 0xfdfdfdfd,
		0x02020202, 0x02020202, 0xfdfdfdfd, 0xfdfdfdfd,
		0x02020202, 0x02020202, 0x02020202, 0x02020202,
		0xfdfdfdfd, 0xfdfdfdfd, 0x02020202, 0x02020202,
		0xfdfdfdfd, 0xfdfdfdfd, 0x00000000, 0x00000000,
		0xffffffff, 0xffffffff, 0x00000000, 0x00000000,
		0xffffffff, 0xffffffff, 0x00000000, 0x00000000,
		0xffffffff, 0xffffffff, 0x00000000, 0x00000000,
		0xffffffff, 0xffffffff, 0x02020202, 0x02020202,
		0x00000000, 0x00000000, 0xffffffff, 0xffffffff,
		0x00000000, 0x00000000, 0xffffffff, 0xffffffff,
		0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0xfdfdfdfd, 0xfdfdfdfd,
		0xfdfdfdfd, 0xfdfdfdfd, 0xffffffff, 0xffffffff,
		0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
		0x00000000, 0x00000000, 0xffffffff, 0xffffffff,
		0x00000000, 0x00000000, 0xffffffff, 0xffffffff,
		0xffffffff, 0xffffffff, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0xffffffff, 0xffffffff,
		0x00000000, 0x00000000, 0xffffffff, 0xffffffff,
		0xfdfdfdfd, 0xfdfdfdfd, 0x00000000, 0x00000000,
		0xfdfdfdfd, 0xfdfdfdfd, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0xffffffff, 0xffffffff,
		0xffffffff, 0xffffffff, 0x02020202, 0x02020202,
		0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
		0x02020202, 0x02020202, 0x00000000, 0x00000000,
		0x02020202, 0x02020202, 0xffffffff, 0xffffffff,
		0xfdfdfdfd, 0xfdfdfdfd, 0xfdfdfdfd, 0xfdfdfdfd
	},
	{
		0x04040404, 0x04040404, 0x00000000, 0x00000000,
		0x04040404, 0x04040404, 0xffffffff, 0xffffffff,
		0xfbfbfbfb, 0xfbfbfbfb, 0xfbfbfbfb, 0xfbfbfbfb,
		0x04040404, 0x04040404, 0xfbfbfbfb, 0xfbfbfbfb,
		0x04040404, 0x04040404, 0xfbfbfbfb, 0xfbfbfbfb,
		0x04040404, 0x04040404, 0x04040404, 0x04040404,
		0xfbfbfbfb, 0xfbfbfbfb, 0x04040404, 0x04040404,
		0xfbfbfbfb, 0xfbfbfbfb, 0x00000000, 0x00000000,
		0xffffffff, 0xffffffff, 0x00000000, 0x00000000,
		0xffffffff, 0xffffffff, 0x00000000, 0x00000000,
		0xffffffff, 0xffffffff, 0x00000000, 0x00000000,
		0xffffffff, 0xffffffff, 0x04040404, 0x04040404,
		0x00000000, 0x00000000, 0xffffffff, 0xffffffff,
		0x00000000, 0x00000000, 0xffffffff, 0xffffffff,
		0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0xfbfbfbfb, 0xfbfbfbfb,
		0xfbfbfbfb, 0xfbfbfbfb, 0xffffffff, 0xffffffff,
		0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
		0x00000000, 0x00000000, 0xffffffff, 0xffffffff,
		0x00000000, 0x00000000, 0xffffffff, 0xffffffff,
		0xffffffff, 0xffffffff, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0xffffffff, 0xffffffff,
		0x00000000, 0x00000000, 0xffffffff, 0xffffffff,
		0xfbfbfbfb, 0xfbfbfbfb, 0x00000000, 0x00000000,
		0xfbfbfbfb, 0xfbfbfbfb, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0xffffffff, 0xffffffff,
		0xffffffff, 0xffffffff, 0x04040404, 0x04040404,
		0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
		0x04040404, 0x04040404, 0x00000000, 0x00000000,
		0x04040404, 0x04040404, 0xffffffff, 0xffffffff,
		0xfbfbfbfb, 0xfbfbfbfb, 0xfbfbfbfb, 0xfbfbfbfb
	},
	{
		0x08080808, 0x08080808, 0x00000000, 0x00000000,
		0x08080808, 0x08080808, 0xffffffff, 0xffffffff,
		0xf7f7f7f7, 0xf7f7f7f7, 0xf7f7f7f7, 0xf7f7f7f7,
		0x08080808, 0x08080808, 0xf7f7f7f7, 0xf7f7f7f7,
		0x08080808, 0x08080808, 0xf7f7f7f7, 0xf7f7f7f7,
		0x08080808, 0x08080808, 0x08080808, 0x08080808,
		0xf7f7f7f7, 0xf7f7f7f7, 0x08080808, 0x08080808,
		0xf7f7f7f7, 0xf7f7f7f7, 0x00000000, 0x00000000,
		0xffffffff, 0xffffffff, 0x00000000, 0x00000000,
		0xffffffff, 0xffffffff, 0x00000000, 0x00000000,
		0xffffffff, 0xffffffff, 0x00000000, 0x00000000,
		0xffffffff, 0xffffffff, 0x08080808, 0x08080808,
		0x00000000, 0x00000000, 0xffffffff, 0xffffffff,
		0x00000000, 0x00000000, 0xffffffff, 0xffffffff,
		0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0xf7f7f7f7, 0xf7f7f7f7,
		0xf7f7f7f7, 0xf7f7f7f7, 0xffffffff, 0xffffffff,
		0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
		0x00000000, 0x00000000, 0xffffffff, 0xffffffff,
		0x00000000, 0x00000000, 0xffffffff, 0xffffffff,
		0xffffffff, 0xffffffff, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0xffffffff, 0xffffffff,
		0x00000000, 0x00000000, 0xffffffff, 0xffffffff,
		0xf7f7f7f7, 0xf7f7f7f7, 0x00000000, 0x00000000,
		0xf7f7f7f7, 0xf7f7f7f7, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0xffffffff, 0xffffffff,
		0xffffffff, 0xffffffff, 0x08080808, 0x08080808,
		0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
		0x08080808, 0x08080808, 0x00000000, 0x00000000,
		0x08080808, 0x08080808, 0xffffffff, 0xffffffff,
		0xf7f7f7f7, 0xf7f7f7f7, 0xf7f7f7f7, 0xf7f7f7f7
	},
	{
		0x10101010, 0x10101010, 0x00000000, 0x00000000,
		0x10101010, 0x10101010, 0xffffffff, 0xffffffff,
		0xefefefef, 0xefefefef, 0xefefefef, 0xefefefef,
		0x10101010, 0x10101010, 0xefefefef, 0xefefefef,
		0x10101010, 0x10101010, 0xefefefef, 0xefefefef,
		0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0xefefefef, 0xefefefef, 0x10101010, 0x10101010,
		0xefefefef, 0xefefefef, 0x00000000, 0x00000000,
		0xffffffff, 0xffffffff, 0x00000000, 0x00000000,
		0xffffffff, 0xffffffff, 0x00000000, 0x00000000,
		0xffffffff, 0xffffffff, 0x00000000, 0x00000000,
		0xffffffff, 0xffffffff, 0x10101010, 0x10101010,
		0x00000000, 0x00000000, 0xffffffff, 0xffffffff,
		0x00000000, 0x00000000, 0xffffffff, 0xffffffff,
		0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0xefefefef, 0xefefefef,
		0xefefefef, 0xefefefef, 0xffffffff, 0xffffffff,
		0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
		0x00000000, 0x00000000, 0xffffffff, 0xffffffff,
		0x00000000, 0x00000000, 0xffffffff, 0xffffffff,
		0xffffffff, 0xffffffff, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0xffffffff, 0xffffffff,
		0x00000000, 0x00000000, 0xffffffff, 0xffffffff,
		0xefefefef, 0xefefefef, 0x00000000, 0x00000000,
		0xefefefef, 0xefefefef, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0xffffffff, 0xffffffff,
		0xffffffff, 0xffffffff, 0x10101010, 0x10101010,
		0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
		0x10101010, 0x10101010, 0x00000000, 0x00000000,
		0x10101010, 0x10101010, 0xffffffff, 0xffffffff,
		0xefefefef, 0xefefefef, 0xefefefef, 0xefefefef
	},
	{
		0x20202020, 0x20202020, 0x00000000, 0x00000000,
		0x20202020, 0x20202020, 0xffffffff, 0xffffffff,
		0xdfdfdfdf, 0xdfdfdfdf, 0xdfdfdfdf, 0xdfdfdfdf,
		0x20202020, 0x20202020, 0xdfdfdfdf, 0xdfdfdfdf,
		0x20202020, 0x20202020, 0xdfdfdfdf, 0xdfdfdfdf,
		0x20202020, 0x20202020, 0x20202020, 0x20202020,
		0xdfdfdfdf, 0xdfdfdfdf, 0x20202020, 0x20202020,
		0xdfdfdfdf, 0xdfdfdfdf, 0x00000000, 0x00000000,
		0xffffffff, 0xffffffff, 0x00000000, 0x00000000,
		0xffffffff, 0xffffffff, 0x00000000, 0x00000000,
		0xffffffff, 0xffffffff, 0x00000000, 0x00000000,
		0xffffffff, 0xffffffff, 0x20202020, 0x20202020,
		0x00000000, 0x00000000, 0xffffffff, 0xffffffff,
		0x00000000, 0x00000000, 0xffffffff, 0xffffffff,
		0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0xdfdfdfdf, 0xdfdfdfdf,
		0xdfdfdfdf, 0xdfdfdfdf, 0xffffffff, 0xffffffff,
		0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
		0x00000000, 0x00000000, 0xffffffff, 0xffffffff,
		0x00000000, 0x00000000, 0xffffffff, 0xffffffff,
		0xffffffff, 0xffffffff, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0xffffffff, 0xffffffff,
		0x00000000, 0x00000000, 0xffffffff, 0xffffffff,
		0xdfdfdfdf, 0xdfdfdfdf, 0x00000000, 0x00000000,
		0xdfdfdfdf, 0xdfdfdfdf, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0xffffffff, 0xffffffff,
		0xffffffff, 0xffffffff, 0x20202020, 0x20202020,
		0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
		0x20202020, 0x20202020, 0x00000000, 0x00000000,
		0x20202020, 0x20202020, 0xffffffff, 0xffffffff,
		0xdfdfdfdf, 0xdfdfdfdf, 0xdfdfdfdf, 0xdfdfdfdf
	},
	{
		0x40404040, 0x40404040, 0x00000000, 0x00000000,
		0x40404040, 0x40404040, 0xffffffff, 0xffffffff,
		0xbfbfbfbf, 0xbfbfbfbf, 0xbfbfbfbf, 0xbfbfbfbf,
		0x40404040, 0x40404040, 0xbfbfbfbf, 0xbfbfbfbf,
		0x40404040, 0x40404040, 0xbfbfbfbf, 0xbfbfbfbf,
		0x40404040, 0x40404040, 0x40404040, 0x40404040,
		0xbfbfbfbf, 0xbfbfbfbf, 0x40404040, 0x40404040,
		0xbfbfbfbf, 0xbfbfbfbf, 0x00000000, 0x00000000,
		0xffffffff, 0xffffffff, 0x00000000, 0x00000000,
		0xffffffff, 0xffffffff, 0x00000000, 0x00000000,
		0xffffffff, 0xffffffff, 0x00000000, 0x00000000,
		0xffffffff, 0xffffffff, 0x40404040, 0x40404040,
		0x00000000, 0x00000000, 0xffffffff, 0xffffffff,
		0x00000000, 0x00000000, 0xffffffff, 0xffffffff,
		0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0xbfbfbfbf, 0xbfbfbfbf,
		0xbfbfbfbf, 0xbfbfbfbf, 0xffffffff, 0xffffffff,
		0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
		0x00000000, 0x00000000, 0xffffffff, 0xffffffff,
		0x00000000, 0x00000000, 0xffffffff, 0xffffffff,
		0xffffffff, 0xffffffff, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0xffffffff, 0xffffffff,
		0x00000000, 0x00000000, 0xffffffff, 0xffffffff,
		0xbfbfbfbf, 0xbfbfbfbf, 0x00000000, 0x00000000,
		0xbfbfbfbf, 0xbfbfbfbf, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0xffffffff, 0xffffffff,
		0xffffffff, 0xffffffff, 0x40404040, 0x40404040,
		0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
		0x40404040, 0x40404040, 0x00000000, 0x00000000,
		0x40404040, 0x40404040, 0xffffffff, 0xffffffff,
		0xbfbfbfbf, 0xbfbfbfbf, 0xbfbfbfbf, 0xbfbfbfbf
	},
	{
		0x80808080, 0x80808080, 0x00000000, 0x00000000,
		0x80808080, 0x80808080, 0xffffffff, 0xffffffff,
		0x7f7f7f7f, 0x7f7f7f7f, 0x7f7f7f7f, 0x7f7f7f7f,
		0x80808080, 0x80808080, 0x7f7f7f7f, 0x7f7f7f7f,
		0x80808080, 0x80808080, 0x7f7f7f7f, 0x7f7f7f7f,
		0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x7f7f7f7f, 0x7f7f7f7f, 0x80808080, 0x80808080,
		0x7f7f7f7f, 0x7f7f7f7f, 0x00000000, 0x00000000,
		0xffffffff, 0xffffffff, 0x00000000, 0x00000000,
		0xffffffff, 0xffffffff, 0x00000000, 0x00000000,
		0xffffffff, 0xffffffff, 0x00000000, 0x00000000,
		0xffffffff, 0xffffffff, 0x80808080, 0x80808080,
		0x00000000, 0x00000000, 0xffffffff, 0xffffffff,
		0x00000000, 0x00000000, 0xffffffff, 0xffffffff,
		0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x7f7f7f7f, 0x7f7f7f7f,
		0x7f7f7f7f, 0x7f7f7f7f, 0xffffffff, 0xffffffff,
		0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
		0x00000000, 0x00000000, 0xffffffff, 0xffffffff,
		0x00000000, 0x00000000, 0xffffffff, 0xffffffff,
		0xffffffff, 0xffffffff, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0xffffffff, 0xffffffff,
		0x00000000, 0x00000000, 0xffffffff, 0xffffffff,
		0x7f7f7f7f, 0x7f7f7f7f, 0x00000000, 0x00000000,
		0x7f7f7f7f, 0x7f7f7f7f, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0xffffffff, 0xffffffff,
		0xffffffff, 0xffffffff, 0x80808080, 0x80808080,
		0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
		0x80808080, 0x80808080, 0x00000000, 0x00000000,
		0x80808080, 0x80808080, 0xffffffff, 0xffffffff,
		0x7f7f7f7f, 0x7f7f7f7f, 0x7f7f7f7f, 0x7f7f7f7f
	}
};

u32 special_pattern[DQ_NUM][LEN_SPECIAL_PATTERN] __aligned(32) = {
	{
		0x00000000, 0x00000000, 0x01010101, 0x01010101,
		0xffffffff, 0xffffffff, 0xfefefefe, 0xfefefefe,
		0xfefefefe, 0xfefefefe, 0x01010101, 0x01010101,
		0xfefefefe, 0xfefefefe, 0x01010101, 0x01010101,
		0xfefefefe, 0xfefefefe, 0x01010101, 0x01010101,
		0x01010101, 0x01010101, 0xfefefefe, 0xfefefefe,
		0x01010101, 0x01010101, 0xfefefefe, 0xfefefefe,
		0x00000000, 0x00000000, 0xffffffff, 0xffffffff,
		0x00000000, 0x00000000, 0xffffffff, 0xffffffff,
		0x00000000, 0x00000000, 0xffffffff, 0xffffffff,
		0x00000000, 0x00000000, 0xffffffff, 0xffffffff,
		0x01010101, 0x01010101, 0x00000000, 0x00000000,
		0xffffffff, 0xffffffff, 0x00000000, 0x00000000,
		0xffffffff, 0xffffffff, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0xfefefefe, 0xfefefefe, 0xfefefefe, 0xfefefefe,
		0xffffffff, 0xffffffff, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0xffffffff, 0xffffffff,
		0xffffffff, 0xffffffff, 0x00000000, 0x00000000,
		0xffffffff, 0xffffffff, 0x00000000, 0x00000000,
		0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
		0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0xffffffff, 0xffffffff, 0x00000000, 0x00000000,
		0xffffffff, 0xffffffff, 0xfefefefe, 0xfefefefe,
		0x00000000, 0x00000000, 0xfefefefe, 0xfefefefe,
		0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
		0x01010101, 0x01010101, 0xffffffff, 0xffffffff,
		0xffffffff, 0xffffffff, 0x01010101, 0x01010101,
		0x00000000, 0x00000000, 0x01010101, 0x01010101,
		0xffffffff, 0xffffffff, 0xfefefefe, 0xfefefefe,
		0xfefefefe, 0xfefefefe, 0x00000000, 0x00000000
	},
	{
		0x00000000, 0x00000000, 0x02020202, 0x02020202,
		0xffffffff, 0xffffffff, 0xfdfdfdfd, 0xfdfdfdfd,
		0xfdfdfdfd, 0xfdfdfdfd, 0x02020202, 0x02020202,
		0xfdfdfdfd, 0xfdfdfdfd, 0x02020202, 0x02020202,
		0xfdfdfdfd, 0xfdfdfdfd, 0x02020202, 0x02020202,
		0x02020202, 0x02020202, 0xfdfdfdfd, 0xfdfdfdfd,
		0x02020202, 0x02020202, 0xfdfdfdfd, 0xfdfdfdfd,
		0x00000000, 0x00000000, 0xffffffff, 0xffffffff,
		0x00000000, 0x00000000, 0xffffffff, 0xffffffff,
		0x00000000, 0x00000000, 0xffffffff, 0xffffffff,
		0x00000000, 0x00000000, 0xffffffff, 0xffffffff,
		0x02020202, 0x02020202, 0x00000000, 0x00000000,
		0xffffffff, 0xffffffff, 0x00000000, 0x00000000,
		0xffffffff, 0xffffffff, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0xfdfdfdfd, 0xfdfdfdfd, 0xfdfdfdfd, 0xfdfdfdfd,
		0xffffffff, 0xffffffff, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0xffffffff, 0xffffffff,
		0xffffffff, 0xffffffff, 0x00000000, 0x00000000,
		0xffffffff, 0xffffffff, 0x00000000, 0x00000000,
		0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
		0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0xffffffff, 0xffffffff, 0x00000000, 0x00000000,
		0xffffffff, 0xffffffff, 0xfdfdfdfd, 0xfdfdfdfd,
		0x00000000, 0x00000000, 0xfdfdfdfd, 0xfdfdfdfd,
		0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
		0x02020202, 0x02020202, 0xffffffff, 0xffffffff,
		0xffffffff, 0xffffffff, 0x02020202, 0x02020202,
		0x00000000, 0x00000000, 0x02020202, 0x02020202,
		0xffffffff, 0xffffffff, 0xfdfdfdfd, 0xfdfdfdfd,
		0xfdfdfdfd, 0xfdfdfdfd, 0x00000000, 0x00000000
	},
	{
		0x00000000, 0x00000000, 0x04040404, 0x04040404,
		0xffffffff, 0xffffffff, 0xfbfbfbfb, 0xfbfbfbfb,
		0xfbfbfbfb, 0xfbfbfbfb, 0x04040404, 0x04040404,
		0xfbfbfbfb, 0xfbfbfbfb, 0x04040404, 0x04040404,
		0xfbfbfbfb, 0xfbfbfbfb, 0x04040404, 0x04040404,
		0x04040404, 0x04040404, 0xfbfbfbfb, 0xfbfbfbfb,
		0x04040404, 0x04040404, 0xfbfbfbfb, 0xfbfbfbfb,
		0x00000000, 0x00000000, 0xffffffff, 0xffffffff,
		0x00000000, 0x00000000, 0xffffffff, 0xffffffff,
		0x00000000, 0x00000000, 0xffffffff, 0xffffffff,
		0x00000000, 0x00000000, 0xffffffff, 0xffffffff,
		0x04040404, 0x04040404, 0x00000000, 0x00000000,
		0xffffffff, 0xffffffff, 0x00000000, 0x00000000,
		0xffffffff, 0xffffffff, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0xfbfbfbfb, 0xfbfbfbfb, 0xfbfbfbfb, 0xfbfbfbfb,
		0xffffffff, 0xffffffff, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0xffffffff, 0xffffffff,
		0xffffffff, 0xffffffff, 0x00000000, 0x00000000,
		0xffffffff, 0xffffffff, 0x00000000, 0x00000000,
		0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
		0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0xffffffff, 0xffffffff, 0x00000000, 0x00000000,
		0xffffffff, 0xffffffff, 0xfbfbfbfb, 0xfbfbfbfb,
		0x00000000, 0x00000000, 0xfbfbfbfb, 0xfbfbfbfb,
		0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
		0x04040404, 0x04040404, 0xffffffff, 0xffffffff,
		0xffffffff, 0xffffffff, 0x04040404, 0x04040404,
		0x00000000, 0x00000000, 0x04040404, 0x04040404,
		0xffffffff, 0xffffffff, 0xfbfbfbfb, 0xfbfbfbfb,
		0xfbfbfbfb, 0xfbfbfbfb, 0x00000000, 0x00000000
	},
	{
		0x00000000, 0x00000000, 0x08080808, 0x08080808,
		0xffffffff, 0xffffffff, 0xf7f7f7f7, 0xf7f7f7f7,
		0xf7f7f7f7, 0xf7f7f7f7, 0x08080808, 0x08080808,
		0xf7f7f7f7, 0xf7f7f7f7, 0x08080808, 0x08080808,
		0xf7f7f7f7, 0xf7f7f7f7, 0x08080808, 0x08080808,
		0x08080808, 0x08080808, 0xf7f7f7f7, 0xf7f7f7f7,
		0x08080808, 0x08080808, 0xf7f7f7f7, 0xf7f7f7f7,
		0x00000000, 0x00000000, 0xffffffff, 0xffffffff,
		0x00000000, 0x00000000, 0xffffffff, 0xffffffff,
		0x00000000, 0x00000000, 0xffffffff, 0xffffffff,
		0x00000000, 0x00000000, 0xffffffff, 0xffffffff,
		0x08080808, 0x08080808, 0x00000000, 0x00000000,
		0xffffffff, 0xffffffff, 0x00000000, 0x00000000,
		0xffffffff, 0xffffffff, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0xf7f7f7f7, 0xf7f7f7f7, 0xf7f7f7f7, 0xf7f7f7f7,
		0xffffffff, 0xffffffff, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0xffffffff, 0xffffffff,
		0xffffffff, 0xffffffff, 0x00000000, 0x00000000,
		0xffffffff, 0xffffffff, 0x00000000, 0x00000000,
		0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
		0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0xffffffff, 0xffffffff, 0x00000000, 0x00000000,
		0xffffffff, 0xffffffff, 0xf7f7f7f7, 0xf7f7f7f7,
		0x00000000, 0x00000000, 0xf7f7f7f7, 0xf7f7f7f7,
		0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
		0x08080808, 0x08080808, 0xffffffff, 0xffffffff,
		0xffffffff, 0xffffffff, 0x08080808, 0x08080808,
		0x00000000, 0x00000000, 0x08080808, 0x08080808,
		0xffffffff, 0xffffffff, 0xf7f7f7f7, 0xf7f7f7f7,
		0xf7f7f7f7, 0xf7f7f7f7, 0x00000000, 0x00000000
	},
	{
		0x00000000, 0x00000000, 0x10101010, 0x10101010,
		0xffffffff, 0xffffffff, 0xefefefef, 0xefefefef,
		0xefefefef, 0xefefefef, 0x10101010, 0x10101010,
		0xefefefef, 0xefefefef, 0x10101010, 0x10101010,
		0xefefefef, 0xefefefef, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0xefefefef, 0xefefefef,
		0x10101010, 0x10101010, 0xefefefef, 0xefefefef,
		0x00000000, 0x00000000, 0xffffffff, 0xffffffff,
		0x00000000, 0x00000000, 0xffffffff, 0xffffffff,
		0x00000000, 0x00000000, 0xffffffff, 0xffffffff,
		0x00000000, 0x00000000, 0xffffffff, 0xffffffff,
		0x10101010, 0x10101010, 0x00000000, 0x00000000,
		0xffffffff, 0xffffffff, 0x00000000, 0x00000000,
		0xffffffff, 0xffffffff, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0xefefefef, 0xefefefef, 0xefefefef, 0xefefefef,
		0xffffffff, 0xffffffff, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0xffffffff, 0xffffffff,
		0xffffffff, 0xffffffff, 0x00000000, 0x00000000,
		0xffffffff, 0xffffffff, 0x00000000, 0x00000000,
		0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
		0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0xffffffff, 0xffffffff, 0x00000000, 0x00000000,
		0xffffffff, 0xffffffff, 0xefefefef, 0xefefefef,
		0x00000000, 0x00000000, 0xefefefef, 0xefefefef,
		0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
		0x10101010, 0x10101010, 0xffffffff, 0xffffffff,
		0xffffffff, 0xffffffff, 0x10101010, 0x10101010,
		0x00000000, 0x00000000, 0x10101010, 0x10101010,
		0xffffffff, 0xffffffff, 0xefefefef, 0xefefefef,
		0xefefefef, 0xefefefef, 0x00000000, 0x00000000
	},
	{
		0x00000000, 0x00000000, 0x20202020, 0x20202020,
		0xffffffff, 0xffffffff, 0xdfdfdfdf, 0xdfdfdfdf,
		0xdfdfdfdf, 0xdfdfdfdf, 0x20202020, 0x20202020,
		0xdfdfdfdf, 0xdfdfdfdf, 0x20202020, 0x20202020,
		0xdfdfdfdf, 0xdfdfdfdf, 0x20202020, 0x20202020,
		0x20202020, 0x20202020, 0xdfdfdfdf, 0xdfdfdfdf,
		0x20202020, 0x20202020, 0xdfdfdfdf, 0xdfdfdfdf,
		0x00000000, 0x00000000, 0xffffffff, 0xffffffff,
		0x00000000, 0x00000000, 0xffffffff, 0xffffffff,
		0x00000000, 0x00000000, 0xffffffff, 0xffffffff,
		0x00000000, 0x00000000, 0xffffffff, 0xffffffff,
		0x20202020, 0x20202020, 0x00000000, 0x00000000,
		0xffffffff, 0xffffffff, 0x00000000, 0x00000000,
		0xffffffff, 0xffffffff, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0xdfdfdfdf, 0xdfdfdfdf, 0xdfdfdfdf, 0xdfdfdfdf,
		0xffffffff, 0xffffffff, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0xffffffff, 0xffffffff,
		0xffffffff, 0xffffffff, 0x00000000, 0x00000000,
		0xffffffff, 0xffffffff, 0x00000000, 0x00000000,
		0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
		0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0xffffffff, 0xffffffff, 0x00000000, 0x00000000,
		0xffffffff, 0xffffffff, 0xdfdfdfdf, 0xdfdfdfdf,
		0x00000000, 0x00000000, 0xdfdfdfdf, 0xdfdfdfdf,
		0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
		0x20202020, 0x20202020, 0xffffffff, 0xffffffff,
		0xffffffff, 0xffffffff, 0x20202020, 0x20202020,
		0x00000000, 0x00000000, 0x20202020, 0x20202020,
		0xffffffff, 0xffffffff, 0xdfdfdfdf, 0xdfdfdfdf,
		0xdfdfdfdf, 0xdfdfdfdf, 0x00000000, 0x00000000
	},
	{
		0x00000000, 0x00000000, 0x40404040, 0x40404040,
		0xffffffff, 0xffffffff, 0xbfbfbfbf, 0xbfbfbfbf,
		0xbfbfbfbf, 0xbfbfbfbf, 0x40404040, 0x40404040,
		0xbfbfbfbf, 0xbfbfbfbf, 0x40404040, 0x40404040,
		0xbfbfbfbf, 0xbfbfbfbf, 0x40404040, 0x40404040,
		0x40404040, 0x40404040, 0xbfbfbfbf, 0xbfbfbfbf,
		0x40404040, 0x40404040, 0xbfbfbfbf, 0xbfbfbfbf,
		0x00000000, 0x00000000, 0xffffffff, 0xffffffff,
		0x00000000, 0x00000000, 0xffffffff, 0xffffffff,
		0x00000000, 0x00000000, 0xffffffff, 0xffffffff,
		0x00000000, 0x00000000, 0xffffffff, 0xffffffff,
		0x40404040, 0x40404040, 0x00000000, 0x00000000,
		0xffffffff, 0xffffffff, 0x00000000, 0x00000000,
		0xffffffff, 0xffffffff, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0xbfbfbfbf, 0xbfbfbfbf, 0xbfbfbfbf, 0xbfbfbfbf,
		0xffffffff, 0xffffffff, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0xffffffff, 0xffffffff,
		0xffffffff, 0xffffffff, 0x00000000, 0x00000000,
		0xffffffff, 0xffffffff, 0x00000000, 0x00000000,
		0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
		0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0xffffffff, 0xffffffff, 0x00000000, 0x00000000,
		0xffffffff, 0xffffffff, 0xbfbfbfbf, 0xbfbfbfbf,
		0x00000000, 0x00000000, 0xbfbfbfbf, 0xbfbfbfbf,
		0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
		0x40404040, 0x40404040, 0xffffffff, 0xffffffff,
		0xffffffff, 0xffffffff, 0x40404040, 0x40404040,
		0x00000000, 0x00000000, 0x40404040, 0x40404040,
		0xffffffff, 0xffffffff, 0xbfbfbfbf, 0xbfbfbfbf,
		0xbfbfbfbf, 0xbfbfbfbf, 0x00000000, 0x00000000
	},
	{
		0x00000000, 0x00000000, 0x80808080, 0x80808080,
		0xffffffff, 0xffffffff, 0x7f7f7f7f, 0x7f7f7f7f,
		0x7f7f7f7f, 0x7f7f7f7f, 0x80808080, 0x80808080,
		0x7f7f7f7f, 0x7f7f7f7f, 0x80808080, 0x80808080,
		0x7f7f7f7f, 0x7f7f7f7f, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x7f7f7f7f, 0x7f7f7f7f,
		0x80808080, 0x80808080, 0x7f7f7f7f, 0x7f7f7f7f,
		0x00000000, 0x00000000, 0xffffffff, 0xffffffff,
		0x00000000, 0x00000000, 0xffffffff, 0xffffffff,
		0x00000000, 0x00000000, 0xffffffff, 0xffffffff,
		0x00000000, 0x00000000, 0xffffffff, 0xffffffff,
		0x80808080, 0x80808080, 0x00000000, 0x00000000,
		0xffffffff, 0xffffffff, 0x00000000, 0x00000000,
		0xffffffff, 0xffffffff, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x7f7f7f7f, 0x7f7f7f7f, 0x7f7f7f7f, 0x7f7f7f7f,
		0xffffffff, 0xffffffff, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0xffffffff, 0xffffffff,
		0xffffffff, 0xffffffff, 0x00000000, 0x00000000,
		0xffffffff, 0xffffffff, 0x00000000, 0x00000000,
		0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
		0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0xffffffff, 0xffffffff, 0x00000000, 0x00000000,
		0xffffffff, 0xffffffff, 0x7f7f7f7f, 0x7f7f7f7f,
		0x00000000, 0x00000000, 0x7f7f7f7f, 0x7f7f7f7f,
		0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
		0x80808080, 0x80808080, 0xffffffff, 0xffffffff,
		0xffffffff, 0xffffffff, 0x80808080, 0x80808080,
		0x00000000, 0x00000000, 0x80808080, 0x80808080,
		0xffffffff, 0xffffffff, 0x7f7f7f7f, 0x7f7f7f7f,
		0x7f7f7f7f, 0x7f7f7f7f, 0x00000000, 0x00000000
	}
};

/* Fabric ratios table */
u32 fabric_ratio[FAB_OPT] = {
	0x04010204,
	0x04020202,
	0x08020306,
	0x08020303,
	0x04020303,
	0x04020204,
	0x04010202,
	0x08030606,
	0x08030505,
	0x04020306,
	0x0804050a,
	0x04030606,
	0x04020404,
	0x04030306,
	0x04020505,
	0x08020505,
	0x04010303,
	0x08050a0a,
	0x04030408,
	0x04010102,
	0x08030306
};

u32 pbs_dq_mapping[PUP_NUM_64BIT + 1][DQ_NUM] = {
	{3, 2, 5, 7, 1, 0, 6, 4},
	{2, 3, 6, 7, 1, 0, 4, 5},
	{1, 3, 5, 6, 0, 2, 4, 7},
	{0, 2, 4, 7, 1, 3, 5, 6},
	{3, 0, 4, 6, 1, 2, 5, 7},
	{0, 3, 5, 7, 1, 2, 4, 6},
	{2, 3, 5, 7, 1, 0, 4, 6},
	{0, 2, 5, 4, 1, 3, 6, 7},
	{2, 3, 4, 7, 0, 1, 5, 6}
};

#endif /* __DDR3_PATTERNS_64_H */
