#ifndef BCM63XX_GPIO_H
#define BCM63XX_GPIO_H

#include <linux/init.h>
#include <linux/gpio/machine.h>
#include <bcm63xx_cpu.h>

int __init bcm63xx_gpio_init(void);
void bcm63xx_gpio_ephy_reset(int hw_gpio, enum gpio_lookup_flags flags);

static inline unsigned long bcm63xx_gpio_count(void)
{
	switch (bcm63xx_get_cpu_id()) {
	case BCM6318_CPU_ID:
		return 50;
	case BCM6328_CPU_ID:
		return 32;
	case BCM3368_CPU_ID:
	case BCM6358_CPU_ID:
		return 40;
	case BCM6338_CPU_ID:
		return 8;
	case BCM6345_CPU_ID:
		return 16;
	case BCM6362_CPU_ID:
		return 48;
	case BCM6368_CPU_ID:
		return 38;
	case BCM63268_CPU_ID:
		return 52;
	case BCM6348_CPU_ID:
	default:
		return 37;
	}
}

#define BCM63XX_GPIO_DIR_OUT	0x0
#define BCM63XX_GPIO_DIR_IN	0x1

#endif /* !BCM63XX_GPIO_H */
