/*
 * OF helpers for network devices.
 *
 * This file is released under the GPLv2
 */

#ifndef __LINUX_OF_NET_H
#define __LINUX_OF_NET_H

#ifdef CONFIG_OF_NET
#include <linux/of.h>
extern int of_get_phy_mode(struct device_node *np);
extern const void *of_get_mac_address(struct device_node *np);
#ifdef CONFIG_MTD
extern int of_get_mac_address_mtd(struct device_node *np, unsigned char *mac);
#else
static inline int of_get_mac_address_mtd(struct device_node *np, unsigned char *mac)
{
	return -ENOENT;
}
#endif
#else
static inline int of_get_phy_mode(struct device_node *np)
{
	return -ENODEV;
}

static inline const void *of_get_mac_address(struct device_node *np)
{
	return NULL;
}
#endif

#endif /* __LINUX_OF_NET_H */
