/***************************************************************************
 *   Copyright (C) 2004-2007 by Albert Astals Cid                          *
 *   aacid@kde.org                                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#ifndef PLACEMAPWIDGET_H
#define PLACEMAPWIDGET_H

#include <QGraphicsView>

#include "map.h"

class QGraphicsRectItem;
class QGraphicsScene;

class placeMapWidget : public QGraphicsView
{
Q_OBJECT
	public:
		explicit placeMapWidget(QWidget *parent);
		~placeMapWidget();
		
		void init(KGmap *map, QImage* mapImage);

		void setMapMove(bool b);
		void setMapZoom(bool b);

		void setCurrentDivisionImage(QImage *divisionImage);
		void placeDivision(QRect& position);
		QSize mapSize() const;

		size_t nbPixels(int pixelIndex) const;
		size_t nbBorderPixels(int pixelIndex1, int pixelIndex2) const;
		const QVector<uchar> outerPixelIndices() const { return p_outerPixelIndices;}

	public Q_SLOTS:
		void setGameImage();
		void setAutomaticZoom(bool b);
	
	Q_SIGNALS:
		void setMoveActionChecked(bool b);
		void setZoomActionChecked(bool b);
		void setMoveActionEnabled(bool b);
		// color, widget position and map position
		void clicked(QRgb, const QPoint&, const QPointF &);
	
	protected:
		void mousePressEvent(QMouseEvent *e) override;
		void mouseMoveEvent(QMouseEvent *e) override;
		void mouseReleaseEvent(QMouseEvent *e) override;
#if QT_VERSION >= QT_VERSION_CHECK(6, 0, 0)
		void enterEvent(QEnterEvent *e) override;
#else
		void enterEvent(QEvent *e) override;
#endif
		void leaveEvent(QEvent *e) override;
		void wheelEvent(QWheelEvent *e) override;
		void resizeEvent(QResizeEvent *e) override;
		void createGameMapImage();
		void updateCursor();

	private:

		/**
		 * Updates the move and zoom toggle states from the current mode.
		 */
		void updateActions();
		void updateZoom();
		
		enum Mode { Zooming, WantZoom, Moving, WantMove, None };
		Mode p_mode, p_modeBeforeMidClick;
		KGmap *p_map;
		QImage *p_mapImage;
		QImage *p_gameImage;
		QImage *p_currentDivisionImage;
		QCursor *p_currentCursor;
		QGraphicsRectItem *p_zoomRect;
		QGraphicsScene *p_scene;
		QPointF p_initial; // for rubberbanding, in scene coords
		QPoint p_prev; // for moving, in view coords
		bool p_automaticZoom;
		QGraphicsPixmapItem *p_currentDivisionItem;
		QPoint lastMouseEvent; // to first show the division under the mouse

		QVector<uchar> p_outerPixelIndices;
		QVector<size_t> p_pixelsStats; // how many pixels have given indexed val
		QVector<size_t> p_bordersStats;// how many border-like pixels have indexed vals pair
};

#endif
