/*
    SPDX-FileCopyrightText: 2018-2022 Jean-Baptiste Mardelle <jb@kdenlive.org>
    SPDX-FileCopyrightText: 2017-2019 Nicolas Carion <french.ebook.lover@gmail.com>
    SPDX-License-Identifier: GPL-3.0-only OR LicenseRef-KDE-Accepted-GPL
*/
#define CATCH_CONFIG_RUNNER
#include "catch.hpp"

#include "bin/projectitemmodel.h"
#include "core.h"
#include "mltconnection.h"
#include "src/effects/effectsrepository.hpp"
#include "src/mltcontroller/clipcontroller.h"
#include <QApplication>
#include <mlt++/MltFactory.h>
#include <mlt++/MltRepository.h>

/* This file is intended to remain empty.
Write your tests in a file with a name corresponding to what you're testing */

int main(int argc, char *argv[])
{
    QHashSeed::setDeterministicGlobalSeed();
    QApplication app(argc, argv);
    app.setApplicationName(QStringLiteral("kdenlive"));
    std::unique_ptr<Mlt::Repository> repo(Mlt::Factory::init(nullptr));
    qputenv("MLT_TESTS", QByteArray("1"));
    qSetMessagePattern(QStringLiteral("%{time hh:mm:ss.zzz } %{file}:%{line} -- %{message}"));
    Core::build(LinuxPackageType::Unknown, true);
    MltConnection::construct(QString());
    pCore->projectItemModel()->buildPlaylist(QUuid());
    // if Kdenlive is not installed, ensure we have one keyframable effect
    EffectsRepository::get()->reloadCustom(QFileInfo("../data/effects/audiobalance.xml").absoluteFilePath());

    int result = Catch::Session().run(argc, argv);
    pCore->cleanup();
    ClipController::mediaUnavailable.reset();

    // global clean-up...
    // delete repo;
    pCore->projectItemModel()->clean();
    pCore->cleanup();
    return (result < 0xff ? result : 0xff);
}
