// SPDX-License-Identifier: GPL-2.0-only OR GPL-3.0-only OR LicenseRef-KDE-Accepted-GPL
// SPDX-FileCopyrightText: 2020-2022 Harald Sitter <sitter@kde.org>

import QtQuick 2.15
import QtQuick.Layouts 1.15
import org.kde.kirigami 2.19 as Kirigami


Kirigami.ApplicationWindow {
    id: root

    title: i18nc("@title:window", "Overview")
    minimumWidth: Kirigami.Settings.isMobile ? 0 : Kirigami.Units.gridUnit * 22
    minimumHeight: Kirigami.Settings.isMobile ? 0 : Kirigami.Units.gridUnit * 22
    width: Kirigami.Settings.isMobile ? undefined : Kirigami.Units.gridUnit * 42
    height: Kirigami.Settings.isMobile ? undefined : Kirigami.Units.gridUnit * 34

    pageStack.initialPage: ListPage {}
    pageStack.defaultColumnWidth: root.width // show single page
}
