/*
 * Copyright 2013  Heena Mahour <heena393@gmail.com>
 * Copyright 2013 Sebastian Kügler <sebas@kde.org>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
import QtQuick 2.0
import QtQuick.Layouts 1.1
import org.kde.plasma.plasmoid 2.0
import org.kde.plasma.core 2.0 as PlasmaCore
import org.kde.plasma.components 2.0 as PlasmaComponents
import org.kde.plasma.calendar 2.0
import org.kde.plasma.extras 2.0 as PlasmaExtras


Item {
    id: main

    Plasmoid.switchWidth: units.gridUnit * 12
    Plasmoid.switchHeight: units.gridUnit * 12

    property int formFactor: plasmoid.formFactor

    Plasmoid.fullRepresentation: Item {

        Layout.minimumWidth: units.gridUnit * 20
        Layout.minimumHeight: units.gridUnit * 20

        PlasmaExtras.Heading {
            id: monthHeading

            anchors {
                top: parent.top
                left: parent.left
                right: parent.right
            }

            level: 1
            text: isCurrentYear(calendar.startDate) ?  calendar.selectedMonth :  calendar.selectedMonth + ", " + calendar.selectedYear
            elide: Text.ElideRight

            function isCurrentYear(date) {
                var d = new Date();
                if (d.getFullYear() == date.getFullYear()) {
                    return true;
                }
                return false;
            }

            MonthMenu {
                id: monthMenu
            }

            MouseArea {
                id: monthMouse
                anchors {
                    fill: parent
                }
                onClicked: {
                    monthMenu.open(0, height)
                }
            }
        }

        MonthView {
            id: calendar

            anchors {
                top: monthHeading.bottom
                left: parent.left
                right: parent.right
                bottom: parent.bottom
            }
        }
    }
}
