;;; CTLau.el  -*- lexical-binding:t -*-
;; Quail package `chinese-ctlau'
;;   Generated by the command `miscdic-convert'
;;   Source dictionary file: CTLau.html
;;   Copyright notice of the source file
;;------------------------------------------------------
;; "CTLau.html" is available at:
;;
;;   http://umunhum.stanford.edu/~lee/chicomp/CTLau.html
;;
;; It contains the following copyright notice:
;;
;; # Copyright (C) 1988-2001  Fung Fung Lee (lee@umunhum.stanford.edu)
;; #
;; # This program is free software; you can redistribute it and/or
;; # modify it under the terms of the GNU General Public License
;; # as published by the Free Software Foundation; either version 2
;; # of the License, or any later version.
;; #
;; # This program is distributed in the hope that it will be useful,
;; # but WITHOUT ANY WARRANTY; without even the implied warranty of
;; # MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; # GNU General Public License for more details.
;; #
;; # You should have received a copy of the GNU General Public License
;; # along with this program.  If not, see <https://www.gnu.org/licenses/>.
;;------------------------------------------------------

;;; Code:

(require 'quail)
(quail-define-package "chinese-ctlau" "Chinese-GB" "刘粤" t
"汉字输入∷刘锡祥式粤音∷

 刘锡祥式粤语注音方案
 Sidney Lau's Cantonese transcription scheme as described in his book
 \"Elementary Cantonese\", The Government Printer, Hong Kong, 1972.
 This file was prepared by Fung Fung Lee (李枫峰).
 Originally converted from CTCPS3.tit
 Last modified: June 2, 1993.

 Some infrequent GB characters are accessed by typing \\, followed by
 the Cantonese romanization of the respective radical (部首)."
  '(("" . quail-delete-last-char)
   ("." . quail-next-translation)
   (">" . quail-next-translation)
   ("," . quail-prev-translation)
   ("<" . quail-prev-translation))
  nil nil nil nil)

(quail-define-rules
("a" "阿啊鸦呀丫哑亚吖氩锕")
("aai" "埃挨嗌哎唉隘嗳")
("aan" "晏俺")
("aang" "罂")
("aap" "鸭")
("aat" "压押")
("aau" "拗")
("ak" "握扼厄龌")
("am" "暗谙黯")
("ang" "莺")
("au" "欧鸥殴呕沤")
("ba" "把巴芭叭吧笆疤靶坝霸罢爸葩钯粑")
("baai" "湃摆败拜稗呗")
("baak" "白百伯佰帛迫卜")
("baan" "办班斑颁板版扮阪坂爿舨")
("baang" "绷蹦")
("baat" "八捌")
("baau" "包苞胞饱鲍爆龅")
("bai" "币闭蓖蔽毙敝弊陛")
("bak" "北")
("bam" "泵乓")
("ban" "宾笨彬斌滨摈奔品禀傧嫔殡膑锛镔")
("bang" "崩嘣")
("bat" "不毕笔拔跋哔弼钸")
("be" "啤")
("bei" "被悲备比鼻畀脾碑卑惫彼毖庇痹臂避秘泌毗匕俾辔比妣")
("beng" "柄饼病")
("bik" "逼碧壁襞")
("bin" "匾扁便变边贬卞辨辩辫鞭汴窆")
("bing" "并兵冰丙秉炳迸")
("bit" "别鳖憋瘪必铋")
("biu" "表标彪婊镳镖")
("bo" "哺保部布报补步暴褒捕簿怖堡宝埔曝煲鸨")
("boh" "玻菠播波坡鄱啵")
("bok" "驳搏博铂箔舶膊泊陛雹缚")
("bong" "邦帮梆榜绑磅镑")
("booi" "背杯辈贝钡狈焙")
("boon" "半本般畔搬伴绊苯叛胖")
("boot" "钵悖脖拨勃渤孛")
("buk" "卜瀑钋仆")
("bung" "甭")
("cha" "镲查差叉茬茶搽岔诧挝喳齄")
("chaai" "猜踩柴豺侪钗")
("chaak" "测策册拆贼恻")
("chaam" "参蚕惭惨搀掺馋谗杉黪")
("chaan" "铲产餐残灿粲")
("chaang" "撑橙")
("chaap" "插")
("chaat" "察擦獭刷唰嚓")
("chaau" "抄钞巢吵炒耖")
("chai" "凄齐栖妻砌傺萋哜")
("cham" "寻沉侵寝沁谶吣浔鲟")
("chan" "陈尘趁衬亲疹诊哂龀")
("chang" "层曾")
("chap" "缉辑")
("chat" "七漆柒")
("chau" "秋抽酬畴踌稠筹绸瞅丑臭凑囚泅锹嗅俦糗")
("che" "车且扯哆奢邪斜")
("chek" "尺")
("cheng" "请")
("cheuk" "戳绰芍勺卓桌灼倬妁")
("cheung" "墙详窗长场祥昌猖肠畅唱倡枪呛蔷抢翔戕娼")
("chi" "痴池词刺次似始厕此迟柿翅齿炽疵茨磁雌辞慈瓷赐持匙弛驰耻侈脐矢恃帜哧啻嗤呲咫姒祠蚩糍踟")
("chik" "戚赤斥嘁叱敕")
("chim" "签潜堑僭暹锓")
("chin" "千钱纤溅前浅缠阐颤歼千迁仟阡")
("ching" "澄称情程请呈惩逞秤瞪青清晴氰拯蜻")
("chip" "妾")
("chit" "切撤彻澈沏设辙")
("chiu" "朝超潮礁悄瞧峭俏迢肖昭钊")
("cho" "草操糙槽曹粗醋措澡躁噪燥嘈徂殂臊艚")
("choh" "锉挫初锄雏楚础磋搓错刍")
("choi" "睬彩才财裁材采菜蔡赛栽塞")
("chong" "床创藏仓苍舱沧疮闯厂敞伧")
("chue" "处橱厨躇储曙署柱贮伫蹰")
("chuen" "村存传全揣川穿喘串蹿窜寸醛泉痊栓拴湍荃氚钏铨镩")
("chuet" "撮拙掇缀茁啜嘬咄")
("chui" "取吹隋随除滁炊捶锤摧崔催脆翠趋娶趣徐啐")
("chuk" "促矗搐束速蓄畜亍龊")
("chun" "春椿蠢秦循旬巡")
("chung" "重充从冲虫宠聪葱囱匆丛松衷冢铳")
("chut" "出黜黢")
("da" "打")
("daai" "大带歹戴呆")
("daam" "啖耽担胆氮淡儋聃")
("daan" "但单丹郸掸旦惮诞弹蛋钽靼")
("daap" "答踏搭瘩沓")
("daat" "达挞嗒笪鞑")
("dai" "递第隶底逮低抵帝弟氐羝")
("dak" "德得特锝")
("dang" "等蹬灯登凳邓噔戥镫")
("dat" "凸突")
("dau" "豆斗抖兜陡逗痘纠钭蚪窦")
("de" "爹嗲")
("dei" "地")
("dek" "笛")
("deng" "盯钉疔")
("deuh" "朵")
("deuk" "琢啄")
("dik" "的滴迪敌狄涤嫡嘀镝")
("dim" "点掂店")
("din" "电典碘靛垫甸奠淀殿颠巅钿癫")
("ding" "鼎定订丁叮顶锭洼仃耵酊")
("dip" "碟蝶谍叠喋牒")
("dit" "跌迭秩轶")
("diu" "吊雕掉调碉叼凋刁钓丢铞铥貂")
("do" "刀道到度都堵睹赌杜镀渡妒捣倒岛导稻悼盗嘟氘")
("doh" "多垛躲朵跺剁惰堕哚")
("doi" "代待袋岱黛")
("dok" "铎踱")
("dong" "荡当挡党档铛")
("duen" "短锻段断端缎")
("duet" "夺")
("dui" "对堆兑队")
("duk" "独督毒犊读牍笃黩")
("dun" "敦顿墩吨钝遁")
("dung" "动东懂幢冬董栋侗恫冻洞咚氡")
("fa" "花化")
("faai" "快块筷傀哙")
("faan" "泛繁反梵范凡犯藩瓣帆番翻樊矾钒烦返贩饭蕃")
("faat" "发法珐")
("fai" "挥徽费吠肺废沸辉晖镄")
("fan" "份分奋粪芬酚吩氛纷坟焚汾粉忿愤荤昏婚熏训偾薰鼢")
("fat" "佛忽拂氟弗罚筏伐乏阀唿艴")
("fau" "否埠浮涪阜剖缶")
("fe" "啡")
("fei" "飞非腓菲肥匪诽淝妃斐蜚翡霏")
("foh" "科货火伙课钬蝌")
("fok" "霍攫")
("fong" "仿况方放坊芳肪房防妨访纺荒慌晃幌恍谎彷枋肓钫舫")
("foo" "夫呼孚父富辅符釜肤副敷孵扶俘甫抚俯斧腑府腐赴赋傅付负讣附妇咐乎虎唬苦库裤枯刳芙苻呋驸骷")
("fooi" "悔诲灰恢晦奎魁诙喹喙")
("foon" "欢宽款")
("foot" "阔")
("fuk" "复服福辐幅伏袱覆腹匐馥蝠")
("fung" "风缝丰封枫蜂峰锋疯烽逢冯讽奉凤俸唪")
("ga" "架假价加嫁噶嘎嘉枷家贾稼驾镓袈")
("gaai" "解介阶界街佳戒芥疥诫届皆秸偕尬喈")
("gaak" "革格胳隔鬲嗝膈镉骼")
("gaam" "减监鉴尴鑫")
("gaan" "奸间简艰茧柬硷硷拣捡涧谏锏")
("gaang" "耕")
("gaap" "甲夹荚颊钾胛铗")
("gaau" "教较交搞胶郊搅铰狡饺绞窖佼皎蛟跤")
("gai" "计继鸡蓟偈")
("gam" "金今感甘柑敢缄锦禁噤")
("gan" "近紧跟根巾筋斤仅谨靳堇哏艮")
("gang" "梗更庚羹馆耿粳哽")
("gap" "鸽蛤急")
("gat" "疙吉桔佶")
("gau" "究旧九够苟狗垢玖韭久灸厩救咎疚抠鼽")
("gei" "几记机基既纪技箕肌饥讥姬己伎寄忌妓剞叽杞畿麂")
("geng" "镜颈")
("geuk" "脚")
("geung" "僵姜疆羌糨")
("gik" "棘激极击亟殛戟")
("gim" "剑检兼俭")
("gin" "健见件建坚肩键捷腱")
("ging" "径竟荆经京境景劲兢茎惊警敬痉竞刭儆矜")
("gip" "劫")
("git" "结洁杰桀")
("giu" "骄叫娇矫缴敫")
("go" "高稿告篙皋膏羔糕镐窑睾诰")
("goh" "歌个哥")
("goi" "该改")
("gok" "觉各搁阁角珏")
("gon" "干杆竿肝赶秆乾")
("gong" "江港冈刚钢缸肛纲岗杠讲降扛耩")
("goo" "古沽固股孤故辜菇咕估姑鼓蛊顾雇钴鸪锢")
("goon" "管冠观官灌贯棺馆罐斡倌莞鹳")
("got" "割葛褐")
("guen" "捐鹃娟倦眷卷绢券勋涓")
("gui" "具据句举惧居矩巨踞锯炬倨妪飓窭")
("guk" "局菊谷鞠喾锔")
("gung" "功工公共恭赣攻龚供躬宫弓巩拱贡蚣")
("gwa" "瓜挂剐寡卦呱")
("gwaai" "乖拐怪")
("gwaan" "关惯")
("gwaang" "逛")
("gwaat" "刮括")
("gwai" "柜季瑰圭硅归龟闺轨鬼诡桂跪贵悸岿馈匦匮刿皈")
("gwan" "君军均滚棍钧郡衮筠")
("gwang" "轰")
("gwat" "骨掘窟骰")
("gwing" "炯")
("gwoh" "过果戈裹棵颗锞")
("gwok" "郭国廓")
("gwong" "广光")
("ha" "夏下哈虾霞暇厦遐瑕铪")
("haai" "谐骸孩揩鞋械蟹懈邂")
("haak" "客吓")
("haam" "衔咸涵函喊馅")
("haan" "限闲娴")
("haang" "夯坑行")
("haap" "掐峡狭嗑呷")
("haau" "效敲校考吼酵拷烤巧哮孝姣")
("hai" "系兮奚禊鼷")
("hak" "刻赫黑喀克氪")
("ham" "憾含酣憨撼堪勘坎砍嵌陷颔")
("han" "很痕狠恨垦恳")
("hang" "幸行哼亨衡恒肯啃杏铿")
("hap" "侠合盒禽洽匣耠颌")
("hat" "核乞瞎辖劾")
("hau" "口后后候喉侯猴厚逅糇鲎")
("hei" "气起唏希喜汽嘿欺岂器弃熙嘻牺陷烯戏僖嬉曦熹禧羲")
("hek" "吃")
("heuh" "靴")
("heung" "向响享香晌乡饷")
("him" "险谦欠")
("hin" "牵献显遣谴轩掀掀宪衍祆蚬纤")
("hing" "兴轻氢卿庆兄馨罄")
("hip" "歉怯协挟胁")
("hit" "歇")
("hiu" "浇侥橇窍嚣晓哓骁")
("ho" "号浩好壕嚎豪毫耗嗥嚆昊皓颢饕")
("hoh" "何荷可河呵菏贺坷嗬舸")
("hoi" "害开海氦亥骇凯剀嗨铠锎颏")
("hok" "学鹤壳")
("hon" "寒汉看汗刊邯韩罕翰捍旱悍焊侃瀚顸鼾")
("hong" "康航行杭匡筐眶慷糠吭腔项巷哐颃")
("hot" "渴喝")
("huen" "喧圈犬劝绚萱")
("huet" "血")
("hui" "虚许去嘘墟诩栩煦翊")
("huk" "酷哭")
("hung" "汹红雄空恐哄烘虹鸿洪汞孔控凶胸匈熊酗倥")
("ja" "碴咱渣榨咋乍炸诈揸吒吒蚱")
("jaai" "斋债寨")
("jaak" "责宅翟择泽掷摘窄谪啧舴")
("jaam" "站暂斩崭蘸湛糌")
("jaan" "赞盏栈绽纂撰赚")
("jaang" "挣睁狰争")
("jaap" "习杂集袭闸眨咂飒")
("jaat" "扎札轧哳")
("jaau" "找嘲肘骤罩抓爪")
("jai" "制济挤祭剂际滞仔霁掣")
("jak" "则侧仄")
("jam" "枕浸怎斟针谮鸩")
("jan" "镇真振珍震阵圳嗔赈")
("jang" "增蹭僧憎曾赠噌峥铮锃筝")
("jap" "汁执")
("jat" "疾嫉侄质窒")
("jau" "洲酒昼就舟州走揪袖周诌帚咒皱宙奏揍邹僦啁啾纣胄")
("je" "这者借姐谢锗蔗遮嗟榭鹧")
("jek" "只脊炙唧")
("jeng" "井净郑阱")
("jeuk" "酌着雀爵嚼鹊禚")
("jeung" "张象将蒋掌长浆桨奖匠酱橡像樟章彰漳涨杖丈帐账仗胀瘴障伥怅锵蟑")
("ji" "子自紫字知智志之姿淄资治止只纸至寺嗣伺饲巳芝枝支吱蜘肢脂址指趾旨挚致置稚痔兹咨滋孜籽谘俟芷姊祀祉祗锱耔耜粢龇")
("jik" "绩职织直籍即积迹寂藉矽夕汐席植殖值渍穸鲫蛰托")
("jim" "尖渐赡砧瞻詹粘沾占谵")
("jin" "展溅笺煎剪荐践贱箭饯蔫碾毯毡辗战戋翦")
("jing" "徵正静证政整睛晶精靖贞侦蒸征怔帧症祯钲")
("jip" "接嗫咻")
("jit" "节折截捷睫浙哲蛰")
("jiu" "蕉椒焦剿招沼赵照召劁诏僬噍朝")
("jo" "早组造做祖遭糟藻枣蚤皂灶租唣祚")
("joh" "坐助阻左佐座俎唑")
("joi" "在再哉灾宰载滓甾")
("jok" "作凿昨柞")
("jong" "状藏赃脏葬桩庄装妆撞壮臧")
("jue" "主住注著诸猪株珠蛛朱诛煮拄蛀铸纵驻侏茱姝铢麈")
("juen" "传专转蹲攒钻尊遵砖啭颛")
("juet" "绝掇缀啜嘬")
("jui" "最醉序咀狙疽沮聚蛆叙诅嘴罪椎锥追赘坠龃雎屿")
("juk" "足族续俗触簇粥轴逐竹烛瞩嘱筑祝捉浊嗾妯镯镞舳竺")
("jun" "进尽准津晋烬峻枯竣浚骏臻樽镌窀")
("jung" "中种众纵宗总终颂讼诵盅忠钟肿仲鬃棕踪综偬锺舂舯粽")
("jut" "卒")
("ka" "卡咖佧咔")
("kaai" "楷")
("kaat" "咭")
("kaau" "靠铐")
("kai" "契稽启讫溪")
("kam" "衾襟琴擒禽噙妗")
("kan" "勤芹")
("kap" "及吸给汲级笈")
("kat" "咳")
("kau" "扣裘构求沟购臼舅寇球俅叩媾鸠虬闲")
("ke" "骑瘸茄伽")
("kei" "棋其期祈旗企畸冀奇歧崎祁岐琪祺颀麒鳍")
("kek" "剧")
("keuk" "却噱")
("keung" "强镪羟")
("kim" "黔钳")
("kin" "虔")
("king" "倾鲸擎顷琼黥")
("kit" "颉撅揭竭蝎孑羯黠")
("kiu" "轿桥乔侨撬翘檄")
("koh" "钶")
("koi" "概盖钙溉慨磕丐瞌")
("kok" "确郝涸榷壑")
("kong" "抗扩狂矿亢炕伉钪旷")
("koo" "箍")
("kooi" "刽烩绘贿侩溃脍聩")
("koot" "括豁聒")
("kuen" "权豢颧拳")
("kuet" "诀决抉缺炔厥劂谲噘孓镢")
("kui" "区拘驹拒距俱躯驱渠佝衢岖祛瞿")
("kuk" "曲")
("kung" "穷穹")
("kwa" "夸褂垮挎跨胯侉")
("kwaang" "框")
("kwai" "规癸亏盔窥葵愧携馗嵬逵")
("kwan" "困辊窘菌坤昆捆裙群锟幸凶须")
("kwik" "隙虢")
("kwong" "矿旷")
("la" "罅喇啦剌")
("laai" "拉赖")
("laam" "蓝槛舰婪篮揽览缆滥褴")
("laan" "兰栏拦阑澜谰懒烂镧")
("laang" "冷")
("laap" "腊垃蜡")
("laat" "辣邋瘌")
("lai" "例丽犁黎礼荔厉励俪骊粝黧")
("lak" "勒肋仂嘞")
("lam" "凛琳林霖临淋啉")
("lap" "立凹粒笠")
("lat" "甩")
("lau" "漏楼留流溜琉榴硫馏刘瘤柳娄搂篓陋偻喽骝镂镏耧髅")
("le" "咧")
("lei" "李利理璃俐厘梨篱狸离漓里鲤莉吏履凛哩俚喱娌锂")
("lek" "叻")
("leng" "靓鲮")
("leuk" "略掠")
("leung" "梁两量俩粮凉粱良辆亮谅药")
("lik" "力历沥呖")
("lim" "镰廉帘敛脸殓")
("lin" "连怜炼练莲涟链撵")
("ling" "菱领另灵零棱楞拎玲龄铃伶羚凌陵岭令呤聆")
("lip" "猎捋")
("lit" "列裂烈冽")
("liu" "寥了撩聊僚疗燎辽撂镣廖料嘹钌")
("lo" "路露卢老捞劳牢佬姥涝芦颅庐炉掳卤虏鲁赂潞驴唠噜崂橹铑镥鹭痨铹耢舻鲈")
("loh" "罗咯萝螺逻锣箩裸潦倮镙")
("loi" "来莱徕耒")
("lok" "乐落铬貉酪烙洛骆络烁乐")
("long" "琅榔狼廊郎朗浪晾啷螂")
("luen" "联峦挛孪滦乱恋娈")
("luet" "劣")
("lui" "侣里类累泪磊雷镭蕾儡垒擂吕铝旅屡缕虑滤骡羸唳戾勋")
("luk" "录鹿六陆麓碌禄戮氯绿")
("lun" "仑卵抡轮伦沦纶论磷邻鳞吝辚麟")
("lung" "胧龙聋咙笼窿隆垄拢陇弄珑")
("lut" "栗律栗率聿")
("m" "唔")
("ma" "麻妈马码玛蚂骂嘛吗")
("maai" "卖埋买迈")
("maan" "万慢晚馒蛮蔓曼漫幂鳗")
("maang" "盲锰猛孟蜢艋")
("maau" "牡猫茅矛铆卯貌")
("mai" "眯醚迷谜米咪")
("mak" "麦脉墨默陌蓦唛")
("man" "文闻民问抿敏悯闽氓蚊纹吻紊刎泯雯")
("mang" "萌盟")
("mat" "物蜜密袜勿乜谧")
("mau" "某贸谬谋牟亩茂侔")
("me" "咩")
("mei" "美未尾眉镁寐媚靡糜微味薇嵋弭娓鹛镅艉敉霾縻麋")
("mi" "咪")
("mik" "觅汩")
("min" "面免绵冕勉娩缅棉眠")
("ming" "名明命皿螟鸣铭冥茗酩")
("mit" "蔑灭篾")
("miu" "妙描苗瞄藐秒渺庙锚喵邈杳淼窈")
("mo" "武无母务摹模拇姆墓暮募慕毛冒帽巫诬芜毋舞侮戊雾哞呒妩鹉")
("moh" "么么摸蘑磨摩魔嬷耱麾")
("mok" "莫剥膜漠寞幕幂")
("mong" "茫忘亡芒忙莽网望妄罔")
("mooi" "枚玫梅霉霉煤媒每昧妹魅")
("moon" "满们门瞒闷钔颟蹒")
("moot" "末没抹沫茉殁")
("muk" "木目睦牧穆仫苜沐钼")
("mung" "蒙檬梦懵朦艨佑")
("na" "拿那哪娜挪镎")
("naai" "氖乃奶")
("naam" "南男喃岚腩")
("naan" "难")
("naap" "呐钠纳讷")
("naau" "挠闹淖呶铙")
("nai" "泥")
("nam" "谂")
("nang" "能")
("nau" "扭钮纽朽妞嬲耨糅")
("ne" "呢")
("nei" "你尼饵洱妮腻您弥旎祢铌")
("neung" "娘")
("ng" "五误梧吾吴捂午伍晤悟仵嗯蜈鼯")
("nga" "瓦芽牙蚜衙雅讶伢佤")
("ngaai" "艾崖涯刈捱")
("ngaak" "额")
("ngaam" "癌岩")
("ngaan" "雁颜眼")
("ngaang" "硬")
("ngaau" "淆咬爻肴")
("ngai" "危矮霓倪巍伪魏蚁艺毅诣呓舣羿")
("ngak" "呃")
("ngam" "庵鹌")
("ngan" "韧银龈")
("ngat" "迄屹兀仡")
("ngau" "牛钩勾藕偶耦")
("ngit" "啮")
("ngo" "傲敖熬翱聱")
("ngoh" "我卧蛾峨鹅俄讹娥饿哦锇")
("ngoi" "呆外碍阂")
("ngok" "鄂岳谔锷颚乐")
("ngon" "岸")
("ngong" "昂")
("ngung" "瓮")
("ni" "呢")
("nik" "砾匿溺")
("nim" "念拈")
("nin" "年")
("ning" "柠狞宁泡泞佞咛聍")
("nip" "捻捏聂镊镍涅颞")
("niu" "鸟尿袅")
("no" "努脑恼奴怒弩")
("noh" "懦糯傩喏")
("noi" "奈内耐馁柰")
("nok" "诺锘")
("nong" "囊瓤囔")
("nuen" "嫩暖")
("nui" "女钕")
("nuk" "衄")
("nung" "脓浓农侬哝")
("o" "苛柯喔噢婀轲疴")
("oi" "爱哀皑蔼嫒锿霭")
("ok" "恶噩垩愕")
("on" "安案鞍氨按胺铵")
("ong" "肮盎")
("ou" "澳袄奥懊坞")
("pa" "怕扒耙趴爬琶杷")
("paai" "排牌派俳")
("paak" "柏魄粕啪帕拍珀")
("paan" "扳攀盼")
("paang" "澎棒烹彭棚硼膨鹏嘭")
("paau" "炮刨豹抛咆跑泡")
("pai" "批")
("pan" "濒喷频贫")
("pang" "凭朋")
("pat" "匹疋")
("pei" "譬皮鄙砒披琵疲痞屁呸丕仳婢枇铍")
("pek" "劈")
("pik" "辟霹僻癖")
("pin" "遍编篇偏片骗蝙")
("ping" "拼平抨苹骋砰聘乒坪萍瓶评屏俜姘娉骈")
("pit" "撇瞥丿氕")
("piu" "票膘飘漂瓢剽嘌嫖殍")
("po" "谱普抱脯铺莆葡蒲圃浦袍匍溥镨")
("poh" "破婆颇叵钷皤跛")
("pok" "扑朴噗镤")
("pong" "旁膀蚌傍谤庞耪滂螃")
("pooi" "倍配培裴赔陪佩沛坯菩徘胚锫霈")
("poon" "盘潘判拌盆磐")
("poot" "泼钹")
("puk" "仆")
("pung" "蓬篷捧碰")
("sa" "洒莎砂沙纱耍卅仨嗄裟鲨")
("saai" "晒徙玺舐")
("saam" "三三衫钐")
("saan" "山散篡奢珊删汕栅潺闩姗舢跚")
("saang" "省生")
("saap" "圾匝砸霎")
("saat" "撒萨杀刹煞镙")
("saau" "鞘梢捎稍哨艄")
("sai" "细西势世誓逝噬筛硒婿犀洗粞")
("sak" "塞噻")
("sam" "心甚沈审郴忱深婶渗什森岑")
("san" "神新身晨申臣辰砷呻伸娠绅肾慎薪锌辛")
("sang" "生甥牲")
("sap" "十湿拾涩")
("sat" "失实虱室瑟膝")
("sau" "锈绣手仇愁收修首守售受寿授瘦兽漱搜艘嗽羞秀叟莠嗖狩锼艏")
("se" "写社射些舍赦啥赊蛇卸泻佘麝")
("sei" "四死")
("sek" "石硕锡")
("seng" "腥声")
("seuk" "削铄")
("seung" "双霜相上商想常尝偿商伤赏尚裳厢镶箱襄湘徜嫦孀殇熵")
("si" "肆事是市时使示诗史思士师视狮施尸屎驶嗜仕侍氏试斯撕嘶私司丝峙厮谥弑咝铈锶豉匙恣")
("sik" "色惜析式息饰释适食蚀识拭昔晰锡悉熄媳轼皙铯蜥舄蟋")
("sim" "闪蝉苫陕婵殚禅")
("sin" "先线煽擅膳善扇缮铣仙鲜腺羡癣冼倩氙籼蟮霰")
("sing" "城声胜惺性升承成乘诚圣盛绳剩星猩醒姓丞铖腥只")
("sip" "摄慑涉")
("sit" "窃舌楔泄屑薛锲")
("siu" "小笑啸销少兆消烧韶邵绍萧硝霄宵肇箫")
("so" "苏素数搔骚扫嫂擞酥塑溯诉嗉稣须致制")
("soh" "所蔬梳疏傻蓑梭唆琐锁唢嗦娑羧")
("soi" "腮鳃")
("sok" "索朔嗷嗍")
("song" "桑嗓丧爽颡")
("sue" "书殊输鼠枢抒舒薯暑黍树戍竖庶溯丨")
("suen" "算酸篆孙船蒜损吮宣旋选璇")
("suet" "说雪")
("sui" "须水税虽需垂瘁粹淬瑞墅绥髓碎岁穗遂隧祟衰帅谁睡絮绪萃邃彗胥")
("suk" "叔肃属淑赎孰熟蜀缩粟僳宿夙倏塾蓿")
("sun" "信迅醇唇淳纯笋瞬顺舜询驯殉汛讯逊谆荀徇")
("sung" "松崇耸怂送宋淞嵩竦只")
("sut" "恤术述摔戌蟀")
("ta" "他它她铊")
("taai" "太态傣贷泰太汰呔钛")
("taam" "谈贪痰潭谭探覃")
("taan" "叹摊瘫滩坛檀坦袒碳炭妲忐")
("taap" "塌塔蹋坍遢")
("tai" "体提题睇堤蒂缔梯锑蹄啼替嚏涕剃屉谛娣")
("tan" "吞")
("tang" "腾藤滕")
("tau" "头偷投透")
("tek" "踢")
("teng" "厅艇")
("tik" "剔惕倜忑铽")
("tim" "惦添甜恬舔殄憩餮")
("tin" "天滇佃填田腆")
("ting" "廷停听烃亭庭挺蜒婷铤蜓霆")
("tip" "贴帖")
("tit" "铁")
("tiu" "条调挑眺跳佻祧铫窕粜龆")
("to" "陶啕掏屠途吐土套图兔肚蹈祷涛滔绦萄桃逃淘讨徒涂荼叨韬焘钍")
("toh" "舵拖鸵陀驮驼椭妥唾佗沱")
("toi" "胎台殆递苔抬")
("tok" "托拓跖")
("tong" "塘唐汤搪堂棠膛糖倘躺淌趟烫傥熨耥羰螳醣")
("tuen" "团囤屯臀")
("tuet" "脱")
("tui" "腿推颓蜕褪退")
("tuk" "秃")
("tun" "盾")
("tung" "通同痛统疼誊桐酮瞳铜彤童桶捅筒佥僮仝嗵胴艟")
("uk" "屋渥")
("wa" "哇哗画华话畦蛙洼娃铧")
("waai" "坏怀淮歪")
("waak" "或画惑划")
("waan" "湾还环患宦幻弯顽挽鲩玩千")
("waang" "横")
("waat" "猾滑挖")
("wai" "毁为遗谓位围唯维秽讳槐慧卉惠威韦违桅惟潍苇萎委伟纬蔚畏胃喂渭尉慰卫偎喟")
("wan" "云运韵温匀魂浑混瘟稳尹耘郧陨允蕴酝晕诨芸殒氲")
("wang" "宏弘")
("wat" "屈倔")
("wik" "域")
("wing" "永扔荣颖咏泳嵘颍")
("woh" "和锅禾祸蜗涡窝倭娲窠")
("wok" "获劐镬")
("wong" "徨往黄磺蝗簧皇凰惶煌汪王枉旺")
("woo" "乌污湖狐胡瑚壶葫蝴糊惠护互沪户呜钨芋冱猢浒扈祜")
("wooi" "回会汇徊蛔")
("woon" "玩换缓桓唤痪焕涣豌碗皖腕垣援亘剜")
("woot" "活")
("ya" "也")
("yai" "曳拽")
("yam" "音任饮钦赁壬妊荫阴吟淫喑歆窨霪")
("yan" "欣人恩忍引印因衅仁刃纫忻茵殷姻寅隐孕虞甄胤仞吲氤铟蚓")
("yap" "入泣揖邑莅")
("yat" "一日壹逸溢佚佾镒")
("yau" "丘邱有由尤又酋揉柔休幽优悠忧邮铀犹油游酉友右佑釉诱幼侑呦咻猷牖铕蚯鱿黝鼬")
("ye" "夜惹椰耶爷野冶偌")
("yeuk" "跃谑约曰弱虐疟若药钥龠")
("yeung" "鸯样央攘洋酿壤嚷让殃秧杨扬佯疡羊阳氧仰痒养漾徉禳恙鞅")
("yi" "医倚尔儿二以移意而义易异议疑宜谊怡已耳拟铱依伊衣颐夷仪胰沂姨彝椅矣肄劓佴懿噫咦咿漪绮殪旖铒镱黟")
("yik" "亿抑翼逆掖腋液役臆疫亦忆益译翌绎弈奕驿蜴易")
("yim" "严炎冉染嫌厌焰验阉淹盐阎奄掩艳剡俨")
("yin" "弦现言燕然研烟燃贤舷涎砚唁彦宴谚焉咽延演堰兖谳湮妍嫣胭筵鼹")
("ying" "英影形型认凝仍应刑邢樱婴鹰缨莹萤营荧蝇迎赢盈映赝嬴嘤瀛鹦")
("yip" "叶业页孽")
("yit" "热噎谒臬")
("yiu" "绕腰要耀扰邀妖瑶摇尧遥谣姚舀夭吆徭徼娆")
("yoh" "哟唷")
("yue" "与于雨语于如予龋茹蠕儒孺乳汝余俞逾鱼愉渝渔隅娱屿禹宇羽吁遇喻峪御愈誉寓裕预豫驭迂淤盂榆虞愚舆禺伛谕嚅妤瘀铷颥窬窳臾舁竽雩龉")
("yuen" "鸳远员完原元沿椽软阮铅丸烷惋宛婉悬玄县眩渊冤袁辕园圆猿源缘苑愿怨院芫爰铉鸢")
("yuet" "月穴粤越乙悦阅哕钇钺")
("yui" "蕊锐芯裔")
("yuk" "玉育肉辱褥沃旭郁欲狱浴毓鬻顼昱钰")
("yun" "闰润")
("yung" "涌庸镛用勇融容戎茸蓉熔溶绒冗嗡翁拥佣臃痈雍踊蛹恿俑喁邕榕甬")
("\\a" "，。？、：；‘’“”〈〉（）『』【】－＿ １２３４５６７８９０！＠＃＄％∧＆＊│＋＝─")
("\\beng" "疖疠疝历疣疳疸痄疱疰痃痂痖痍痦痤痫痧瘃痱痼痿瘐瘅瘗瘊瘥瘘瘕瘙瘛瘼瘢瘠癀瘭瘰瘿瘵癃瘾瘳癍癞癔癜癯")
("\\booi" "贲贳贶贻贽赀赅赆赉赇赍赕赙")
("\\che" "轫轭轱轳轵轸轷轹轺轾辁辂辄辋辍辎辏辘軎")
("\\chi" "矧矬雉")
("\\chung" "虮虿虺虼虻蚨蚍蚋蚝蚧蚶蛄蚵蛎蚰蚺蛉蛏蚴蛩蛱蛲蛭蛳蛐蛞蛴蛘蛑蜃蜇蛸蜊蜍蜉蜣蜞蜮蜾蝈蜱蜩蜷蜿蝽蝾蝻蝰蝮螋蝓蝣蝼蝤蝥螓螯螨蟒筝螈螅螭螗螫蟥螬螵蟓螽蟊蟛蟪蟠蠖蠓蟾蠊蠛蠡蠹蠼")
("\\faat" "髟髡髦髯髫髻髭髹鬈鬏鬓鬟")
("\\foh" "炀炜炖炝炻烀炷炫炱烨烊焐焓焖焯焱煳煜煨煅煊煸煺熘熳熠燠燔燧燹爝爨")
("\\fong" "旆旄旃旌旒")
("\\fung" "飑飕飙飚")
("\\gaak" "鞒鞔鞯鞫鞣鞲鞴")
("\\gam" "钜钣钤钸铘镟镡镦铴铼锆锊锍锒锖锪锩锬锴锸锾镆镗镘銎銮鋈錾鍪鏊鎏鐾")
("\\gan" "帏帙帔帑帱帻帼彷幄幔幛幞幡")
("\\gau" "犰犴犷犸狃狁狎狍狒狨狯狲狴狷猁狳猃狺狻猗猓猡猊猞猝猕猹猥猬猸猱獐獍獗獠獬獯獾")
("\\gin" "觇觊觋觌觎觏觐觑")
("\\gok" "斛觖觞觚觜觥觫觯")
("\\gwa" "瓞瓠")
("\\gwai" "魃魇魉魈魍魑")
("\\gwoh" "戗戛戢戡戤戬")
("\\hau" "唼啶嗪嘧噼嚯呙咴哒咣哌")
("\\him" "欤欷欹歃歙")
("\\jau" "舡舭舾赳趄趔趑趱酐酎酏酤踺酡酰酯酽酾酲酴酹醌醅醐醍醑醢醪醭醮醯醵醴醺")
("\\juk" "踵踽蹉蹁蹂蹑蹊蹶蹼蹯蹴躅躏躔躐躜躞趸跫踅蹙蹩趵趿趼趺跄跗跞跎跏跆跬跷跸跣跹跻踉跽踔踝踬踮踣踯踺蹀踹")
("\\jukfa" "筻筢筲筱箐箦箧箸箬箝箨箅箪箜箢箴篑篁篌篝篚篥篦篪簌篼簏簖簋簟簪簦簸籁籀笄笕笊笫笏筇笸笙笮笱笥笤笳笾笞筘筚筅筌筮")
("\\kwat" "鬣鏖骱鹘骶骺髁髀髂髋髌髑")
("\\lai" "祓")
("\\ma" "驵驷驺驽骀骅骐骒骓骖骘骛骜骟骠骢骣骥骧")
("\\mo" "耄毪毳毽毵毹氅氇氆氍")
("\\moon" "闫闱闳闵闶闼闾阃阄阆阈阊阋阌阍阏阒阕阖阗阚")
("\\muk" "杌杓杈杩枥杪枘枧杵枨枞枭杼栉柘栊柩枰栌柙枵柚枳柝栀柃枸柢栎柁柽栲栳桠桡桎桢桄桤梃栝桕桦桁桧栾桊桉梏桴桷梓桫棂楮棼椟椠棹獒檩棰椋椁楗棣椐楱椹楠楂楝榄楫榀榘楸椴槌榇榈槎榉")
("\\nga" "瓯瓴瓿甏甑甓")
("\\ngaan" "盱眄眍盹眇眈眚眢眙眭眦眵眸睐睑睃睚睨睢睥睿瞍睽瞀瞑瞟瞠瞰瞵瞽罘罡罟詈罨罴罱罹羁罾")
("\\ngau" "牮犟牝牦牯牾牿犄犋犍犏犒")
("\\niu" "鸫鸬鸲鸱鸶鸸鸷鸹鸺鸾鹁鹂鹄鹆鹇鹈鹋鹎鹑鹕鹗鹚鹜鹞鹣鹨鹩鹪鹫鹬鹱")
("\\nooi" "妫娅吒婧婕胬媪媛婺嫫媲媸嫠嫱嫘嫜嬗嬖")
("\\pao" "貊貅貘貔")
("\\saan" "屺岍岈岘岙岜岵岢岽岬岫岣峁岷峄峒峤峋崃崧崦崮崤崞崆崛崾崴崽嵛嵯嵝嵫嵊嵴嶂嶙嶝豳嶷")
("\\sam" "忉忖忏怃忮怄忡忤忾怆忪忭忸怙怵怦怛怏怍怩怫怊怿恸恹恺恂爿恽悖悚悭悝悃悒悌悛惬悻悱惝惘惆惚悴愠愦愣惴愀愎愫慊慵憬憔憧憷懔")
("\\sam" "磔恝恚恧恁恣悫愆愍慝憝懋懑戆")
("\\sau" "扪抟抻拊拚拮挢拶挹捃掭揶捺掎掴捭掬掊捩掮掼揲揠揿揄揞揎摒揆掾摅摁搋搛搠搌搦搡摞撄摭撖撷撸撙撺擀擐擗擤擢攉攥攮挈挲掰胼擘")
("\\sek" "矶矸砀砉砗砘砑斫砭砜砝砹砺砻砟砼砥砬砣砩硎硭硖硗砦硐硇硌硪碛碓碚碇碜碡碣碲碹碥磔磙磉磬磲礅磴礓礤礞礴")
("\\si" "纡纥纨纩巛纰纾绀绁绂绉绋绌绐绔绗绛绠绡绨绫绯绱绲缍绶绺绻绾缁缂缃缇缈缋缌缏缑缒缗缙缜缛缟缡缢缣缤缥缦缧缪缫缬缭缯姜缱缲缳缵")
("\\sik" "飨餍饔饧饨饩饪饫饬饴饷饽余馄馇馊馍馐馑馓馔馕")
("\\teng" "遴遽迓迕迥迮迤迩迦迳迨逄逋逦逑逍逖逡逶逭逯遄遑遒遨遘遛")
("\\tin" "町畎畋畈畛畲畹疃")
("\\to" "坩垅坫垆坼坻坨坭坶坳垭垤垌垲埏垧垴垓垠埕埘埚埙埒垸埴埯埸埤埝堋堍埽埭堀堞堙塄堠塥塬墁墉墚墀鼙坌垡墼壅圩圬圪圹圮圯坜圻")
("\\wai" "囝囡囵囫囹囿圄圊圉圜")
("\\woh" "黏穰秕秭秣秫稆嵇稃稂稞稔稹稷穑")
("\\wong" "玎玑玮玢玟珂玷玳珉珈珥珙琊珩珧珞珲琏瑛琦琥琨琰琮琬琛琚瑁瑜瑗瑙瑷瑭瑾璜璎璀璁璇璋璞璨璩璐璧瓒璺")
("\\woo" "戽扃扉")
("\\yan" "仉攸汆籴伲俣偃儇氽佥")
("\\yat" "旮旯旰昙杲昃昕昀炅曷昝昴昶昵耆晟晔晁晡晗晷暄暌暧暝暾曛曜曩")
("\\yi" "衩衲衽衿袂袢裆袷袼裉裢裎裣裥裱褚裼裨裾裰褡褙褓褛褊褫褶襁襦襻")
("\\yider" "阢阽阼陂陉陔陟陧陬陲陴隈隍隗隰邗邛邝邙邬邡邴邳邶邺圯邰郏郅邾郐郄郇郓郦郢郜郗郛郫郯郾鄄鄢鄞鄣鄯鄹酃酆")
("\\yin" "讦讧讪讴讵诂诃诋诎诒诓诔诖诘诜诟诠诤诮诳诶诹诼诿谀谄谇谌谖谝谟谠谡谫谯")
("\\yoo" "鲂鲅鲆鲇鲋鲐鲑鲒鲔鲕鲚鲛鲞鲠鲡鲢鲣鲥鲦鲧鲭鲰鲱鲲鲳鲴鲵鲶鲷鲺鲻鲼鲽鳄鳅鳆鳇鳊鳋鬏鳎鳏鳐鳓鳔鳕鳘鳙鳜鳝鳟鳢")
("\\yuk" "膦豚脶脞脬脘尿腈腌腴腙腚腠腼腽腭腧塍媵膂膣膪臌膻臁刖肟肜肼朊肽肱肫肭肷胨胩胪胂胙胍胗朐胝胫胱脎胲胼朕脒")
)
;; Local Variables:
;; version-control: never
;; no-update-autoloads: t
;; End:

;;; CTLau.el ends here
