import _defineProperty from "@babel/runtime/helpers/defineProperty";
var _FeatureGates;
import { Client } from './Client';
import { CLIENT_VERSION } from './version';
export { EvaluationReason } from './compat/types';
export { DynamicConfig } from './compat/DynamicConfig';
export { FeatureGateEnvironment, PerimeterType } from './types';
export { CLIENT_VERSION } from './version';
/**
 * Access the FeatureGates object via the default export.
 * ```ts
 * import FeatureGates from '@atlaskit/feature-gate-js-client';
 * ```
 */
class FeatureGates {
  static isGateExists(gateName) {
    return this.client.isGateExist(gateName);
  }
  static isExperimentExists(experimentName) {
    return this.client.isExperimentExist(experimentName);
  }
}
_FeatureGates = FeatureGates;
_defineProperty(FeatureGates, "client", new Client());
_defineProperty(FeatureGates, "hasCheckGateErrorOccurred", false);
_defineProperty(FeatureGates, "hasGetExperimentValueErrorOccurred", false);
_defineProperty(FeatureGates, "checkGate", (gateName, options) => {
  try {
    // Check if the CRITERION override mechanism is available
    if (typeof window !== 'undefined' && window.__CRITERION__ && typeof window.__CRITERION__.getFeatureFlagOverride === 'function') {
      // Attempt to retrieve an override value for the feature gate
      const overrideValue = window.__CRITERION__.getFeatureFlagOverride(gateName);
      // If an override value is found, return it immediately
      if (overrideValue !== undefined) {
        return overrideValue;
      }
    }
  } catch (error) {
    // Log the first occurrence of the error
    if (!_FeatureGates.hasCheckGateErrorOccurred) {
      // eslint-disable-next-line no-console
      console.warn({
        msg: 'An error has occurred checking the feature gate from criterion override. Only the first occurrence of this error is logged.',
        gateName,
        error
      });
      _FeatureGates.hasCheckGateErrorOccurred = true;
    }
  }

  // Proceed with the main logic if no override is found
  return _FeatureGates.client.checkGate(gateName, options);
});
_defineProperty(FeatureGates, "getExperimentValue", (experimentName, parameterName, defaultValue, options) => {
  try {
    // Check if the CRITERION override mechanism is available
    if (typeof window !== 'undefined' && window.__CRITERION__ && typeof window.__CRITERION__.getExperimentValueOverride === 'function') {
      const overrideValue = window.__CRITERION__.getExperimentValueOverride(experimentName, parameterName);
      if (overrideValue !== undefined && overrideValue !== null) {
        return overrideValue;
      }
    }
  } catch (error) {
    // Log the first occurrence of the error
    if (!_FeatureGates.hasGetExperimentValueErrorOccurred) {
      // eslint-disable-next-line no-console
      console.warn({
        msg: 'An error has occurred getting the experiment value from criterion override. Only the first occurrence of this error is logged.',
        experimentName,
        defaultValue,
        options,
        error
      });
      _FeatureGates.hasGetExperimentValueErrorOccurred = true;
    }
    return defaultValue;
  }

  // Proceed with the main logic if no override is found
  return _FeatureGates.client.getExperimentValue(experimentName, parameterName, defaultValue, options);
});
_defineProperty(FeatureGates, "initializeCalled", _FeatureGates.client.initializeCalled.bind(_FeatureGates.client));
_defineProperty(FeatureGates, "initializeCompleted", _FeatureGates.client.initializeCompleted.bind(_FeatureGates.client));
_defineProperty(FeatureGates, "initialize", _FeatureGates.client.initialize.bind(_FeatureGates.client));
_defineProperty(FeatureGates, "initializeWithProvider", _FeatureGates.client.initializeWithProvider.bind(_FeatureGates.client));
_defineProperty(FeatureGates, "initializeFromValues", _FeatureGates.client.initializeFromValues.bind(_FeatureGates.client));
_defineProperty(FeatureGates, "manuallyLogGateExposure", _FeatureGates.client.manuallyLogGateExposure.bind(_FeatureGates.client));
_defineProperty(FeatureGates, "getExperiment", _FeatureGates.client.getExperiment.bind(_FeatureGates.client));
_defineProperty(FeatureGates, "manuallyLogExperimentExposure", _FeatureGates.client.manuallyLogExperimentExposure.bind(_FeatureGates.client));
_defineProperty(FeatureGates, "manuallyLogLayerExposure", _FeatureGates.client.manuallyLogLayerExposure.bind(_FeatureGates.client));
_defineProperty(FeatureGates, "shutdownStatsig", _FeatureGates.client.shutdownStatsig.bind(_FeatureGates.client));
_defineProperty(FeatureGates, "overrideGate", _FeatureGates.client.overrideGate.bind(_FeatureGates.client));
_defineProperty(FeatureGates, "clearGateOverride", _FeatureGates.client.clearGateOverride.bind(_FeatureGates.client));
_defineProperty(FeatureGates, "overrideConfig", _FeatureGates.client.overrideConfig.bind(_FeatureGates.client));
_defineProperty(FeatureGates, "clearConfigOverride", _FeatureGates.client.clearConfigOverride.bind(_FeatureGates.client));
_defineProperty(FeatureGates, "setOverrides", _FeatureGates.client.setOverrides.bind(_FeatureGates.client));
_defineProperty(FeatureGates, "getOverrides", _FeatureGates.client.getOverrides.bind(_FeatureGates.client));
_defineProperty(FeatureGates, "clearAllOverrides", _FeatureGates.client.clearAllOverrides.bind(_FeatureGates.client));
_defineProperty(FeatureGates, "isCurrentUser", _FeatureGates.client.isCurrentUser.bind(_FeatureGates.client));
_defineProperty(FeatureGates, "onGateUpdated", _FeatureGates.client.onGateUpdated.bind(_FeatureGates.client));
_defineProperty(FeatureGates, "onExperimentValueUpdated", _FeatureGates.client.onExperimentValueUpdated.bind(_FeatureGates.client));
_defineProperty(FeatureGates, "onAnyUpdated", _FeatureGates.client.onAnyUpdated.bind(_FeatureGates.client));
_defineProperty(FeatureGates, "updateUser", _FeatureGates.client.updateUser.bind(_FeatureGates.client));
_defineProperty(FeatureGates, "updateUserWithProvider", _FeatureGates.client.updateUserWithProvider.bind(_FeatureGates.client));
_defineProperty(FeatureGates, "updateUserWithValues", _FeatureGates.client.updateUserWithValues.bind(_FeatureGates.client));
_defineProperty(FeatureGates, "getPackageVersion", _FeatureGates.client.getPackageVersion.bind(_FeatureGates.client));
_defineProperty(FeatureGates, "getLayer", _FeatureGates.client.getLayer.bind(_FeatureGates.client));
_defineProperty(FeatureGates, "getLayerValue", _FeatureGates.client.getLayerValue.bind(_FeatureGates.client));
let boundFGJS = FeatureGates;

// This makes it possible to get a reference to the FeatureGates client at runtime.
// This is important for overriding values in Cypress tests, as there needs to be a
// way to get the exact instance for a window in order to mock some of its methods.
if (typeof window !== 'undefined') {
  if (window.__FEATUREGATES_JS__ === undefined) {
    window.__FEATUREGATES_JS__ = FeatureGates;
  } else {
    var _boundFGJS, _boundFGJS$getPackage;
    boundFGJS = window.__FEATUREGATES_JS__;
    const boundVersion = ((_boundFGJS = boundFGJS) === null || _boundFGJS === void 0 ? void 0 : (_boundFGJS$getPackage = _boundFGJS.getPackageVersion) === null || _boundFGJS$getPackage === void 0 ? void 0 : _boundFGJS$getPackage.call(_boundFGJS)) || '4.10.0 or earlier';
    if (boundVersion !== CLIENT_VERSION) {
      const message = `Multiple versions of FeatureGateClients found on the current page.
      The currently bound version is ${boundVersion} when module version ${CLIENT_VERSION} was loading.`;
      // eslint-disable-next-line no-console
      console.warn(message);
    }
  }
}

/**
 * @property {FeatureGates} FeatureGate default export
 */
export default boundFGJS;