/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugin.use.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.gradle.api.GradleException;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.artifacts.dsl.ComponentModuleMetadataHandler;
import org.gradle.api.internal.initialization.ClassLoaderScope;
import org.gradle.api.internal.initialization.ScriptHandlerInternal;
import org.gradle.api.internal.plugins.ClassloaderBackedPluginDescriptorLocator;
import org.gradle.api.internal.plugins.PluginDescriptorLocator;
import org.gradle.api.internal.plugins.PluginInspector;
import org.gradle.api.internal.plugins.PluginManagerInternal;
import org.gradle.api.internal.plugins.PluginRegistry;
import org.gradle.api.plugins.InvalidPluginException;
import org.gradle.api.plugins.UnknownPluginException;
import org.gradle.internal.event.ListenerManager;
import org.gradle.internal.exceptions.LocationAwareException;
import org.gradle.plugin.management.internal.PluginRequestInternal;
import org.gradle.plugin.management.internal.PluginRequests;
import org.gradle.plugin.management.internal.PluginResolutionStrategyInternal;
import org.gradle.plugin.use.PluginId;
import org.gradle.plugin.use.internal.PluginRequestApplicator;
import org.gradle.plugin.use.internal.PluginResolverFactory;
import org.gradle.plugin.use.resolve.internal.AlreadyOnClasspathPluginResolver;
import org.gradle.plugin.use.resolve.internal.PluginArtifactRepositories;
import org.gradle.plugin.use.resolve.internal.PluginArtifactRepositoriesProvider;
import org.gradle.plugin.use.resolve.internal.PluginResolution;
import org.gradle.plugin.use.resolve.internal.PluginResolutionResult;
import org.gradle.plugin.use.resolve.internal.PluginResolutionVisitor;
import org.gradle.plugin.use.resolve.internal.PluginResolver;
import org.gradle.plugin.use.tracker.internal.PluginVersionTracker;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultPluginRequestApplicator
implements PluginRequestApplicator {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultPluginRequestApplicator.class);
    private final PluginRegistry pluginRegistry;
    private final PluginResolverFactory pluginResolverFactory;
    private final PluginArtifactRepositoriesProvider pluginRepositoriesProvider;
    private final PluginResolutionStrategyInternal pluginResolutionStrategy;
    private final PluginInspector pluginInspector;
    private final PluginVersionTracker pluginVersionTracker;
    private final PluginRequestApplicator.PluginApplicationListener pluginApplicationListenerBroadcaster;

    public DefaultPluginRequestApplicator(PluginRegistry pluginRegistry, PluginResolverFactory pluginResolverFactory, PluginArtifactRepositoriesProvider pluginRepositoriesProvider, PluginResolutionStrategyInternal pluginResolutionStrategy, PluginInspector pluginInspector, PluginVersionTracker pluginVersionTracker, ListenerManager listenerManager) {
        this.pluginRegistry = pluginRegistry;
        this.pluginResolverFactory = pluginResolverFactory;
        this.pluginRepositoriesProvider = pluginRepositoriesProvider;
        this.pluginResolutionStrategy = pluginResolutionStrategy;
        this.pluginInspector = pluginInspector;
        this.pluginVersionTracker = pluginVersionTracker;
        this.pluginApplicationListenerBroadcaster = (PluginRequestApplicator.PluginApplicationListener)listenerManager.getBroadcaster(PluginRequestApplicator.PluginApplicationListener.class);
    }

    public void applyPlugins(PluginRequests requests, ScriptHandlerInternal scriptHandler, @Nullable PluginManagerInternal target, ClassLoaderScope classLoaderScope) {
        if (target == null || requests.isEmpty()) {
            classLoaderScope.export(scriptHandler.getInstrumentedScriptClassPath());
            classLoaderScope.lock();
            return;
        }
        PluginArtifactRepositories resolveContext = this.pluginRepositoriesProvider.createPluginResolveRepositories();
        resolveContext.applyRepositoriesTo(scriptHandler.getRepositories());
        ArrayList<ApplyAction> pluginApplyActions = new ArrayList<ApplyAction>();
        CollectingPluginRequestResolutionVisitor pluginDependencies = new CollectingPluginRequestResolutionVisitor();
        PluginResolver pluginResolver = this.wrapInAlreadyInClasspathResolver(classLoaderScope, resolveContext);
        for (PluginRequestInternal originalRequest : requests) {
            String pluginVersion;
            PluginRequestInternal request = this.pluginResolutionStrategy.applyTo(originalRequest);
            PluginResolution resolved = DefaultPluginRequestApplicator.resolvePluginRequest(pluginResolver, request);
            resolved.accept(pluginDependencies);
            if (request.isApply()) {
                pluginApplyActions.add(new ApplyAction(request, resolved));
            }
            if ((pluginVersion = resolved.getPluginVersion()) == null) continue;
            this.pluginVersionTracker.setPluginVersionAt(classLoaderScope, resolved.getPluginId().getId(), pluginVersion);
        }
        pluginDependencies.getAdditionalDependencies().forEach(arg_0 -> ((ScriptHandlerInternal)scriptHandler).addScriptClassPathDependency(arg_0));
        if (!pluginDependencies.getReplacements().isEmpty()) {
            ComponentModuleMetadataHandler modules = scriptHandler.getDependencies().getModules();
            for (CollectingPluginRequestResolutionVisitor.ModuleReplacement replacement : pluginDependencies.getReplacements()) {
                modules.module((Object)replacement.original, details -> details.replacedBy((Object)replacement.replacement));
            }
        }
        classLoaderScope.export(scriptHandler.getInstrumentedScriptClassPath());
        pluginDependencies.getAdditionalClassloaders().forEach(arg_0 -> ((ClassLoaderScope)classLoaderScope).export(arg_0));
        classLoaderScope.lock();
        pluginApplyActions.forEach(action -> action.apply(target));
    }

    private PluginResolver wrapInAlreadyInClasspathResolver(ClassLoaderScope classLoaderScope, PluginArtifactRepositories resolveContext) {
        ClassLoaderScope parentLoaderScope = classLoaderScope.getParent();
        ClassloaderBackedPluginDescriptorLocator scriptClasspathPluginDescriptorLocator = new ClassloaderBackedPluginDescriptorLocator(parentLoaderScope.getExportClassLoader());
        PluginResolver pluginResolver = this.pluginResolverFactory.create(resolveContext);
        return new AlreadyOnClasspathPluginResolver(pluginResolver, this.pluginRegistry, parentLoaderScope, (PluginDescriptorLocator)scriptClasspathPluginDescriptorLocator, this.pluginInspector, this.pluginVersionTracker);
    }

    private static InvalidPluginException couldNotApply(PluginRequestInternal request, PluginId id, UnknownPluginException cause) {
        return new InvalidPluginException(String.format("Could not apply requested plugin %s as it does not provide a plugin with id '%s'. This is caused by an incorrect plugin implementation. Please contact the plugin author(s).", request.getDisplayName(), id), (Throwable)cause);
    }

    private static InvalidPluginException exceptionOccurred(PluginRequestInternal request, Exception e) {
        return new InvalidPluginException(String.format("An exception occurred applying plugin request %s", request.getDisplayName()), (Throwable)e);
    }

    private static PluginResolution resolvePluginRequest(PluginResolver resolver, PluginRequestInternal request) {
        PluginResolutionResult result;
        try {
            result = resolver.resolve(request);
            LOGGER.info("Resolved plugin {}", (Object)request.getDisplayName());
        }
        catch (Exception e) {
            throw new LocationAwareException((Throwable)new GradleException(String.format("Error resolving plugin %s", request.getDisplayName()), (Throwable)e), request.getScriptDisplayName(), request.getLineNumber());
        }
        return result.getFound(request);
    }

    private static class CollectingPluginRequestResolutionVisitor
    implements PluginResolutionVisitor {
        private List<Dependency> additionalDependencies;
        private List<ModuleReplacement> replacements;
        private List<ClassLoader> additionalClassloaders;

        private CollectingPluginRequestResolutionVisitor() {
        }

        @Override
        public void visitDependency(Dependency dependency) {
            if (this.additionalDependencies == null) {
                this.additionalDependencies = new ArrayList<Dependency>();
            }
            this.additionalDependencies.add(dependency);
        }

        @Override
        public void visitReplacement(ModuleIdentifier original, ModuleIdentifier replacement) {
            if (this.replacements == null) {
                this.replacements = new ArrayList<ModuleReplacement>();
            }
            this.replacements.add(new ModuleReplacement(original, replacement));
        }

        @Override
        public void visitClassLoader(ClassLoader classLoader) {
            if (this.additionalClassloaders == null) {
                this.additionalClassloaders = new ArrayList<ClassLoader>();
            }
            this.additionalClassloaders.add(classLoader);
        }

        public List<Dependency> getAdditionalDependencies() {
            if (this.additionalDependencies == null) {
                return Collections.emptyList();
            }
            return this.additionalDependencies;
        }

        public List<ModuleReplacement> getReplacements() {
            if (this.replacements == null) {
                return Collections.emptyList();
            }
            return this.replacements;
        }

        public List<ClassLoader> getAdditionalClassloaders() {
            if (this.additionalClassloaders == null) {
                return Collections.emptyList();
            }
            return this.additionalClassloaders;
        }

        static class ModuleReplacement {
            private final ModuleIdentifier original;
            private final ModuleIdentifier replacement;

            public ModuleReplacement(ModuleIdentifier original, ModuleIdentifier replacement) {
                this.original = original;
                this.replacement = replacement;
            }
        }
    }

    private class ApplyAction {
        private final PluginRequestInternal request;
        private final PluginResolution resolved;

        public ApplyAction(PluginRequestInternal request, PluginResolution resolved) {
            this.request = request;
            this.resolved = resolved;
        }

        public void apply(PluginManagerInternal target) {
            try {
                try {
                    DefaultPluginRequestApplicator.this.pluginApplicationListenerBroadcaster.pluginApplied(this.request);
                    this.resolved.applyTo(target);
                }
                catch (UnknownPluginException e) {
                    throw DefaultPluginRequestApplicator.couldNotApply(this.request, this.request.getId(), e);
                }
                catch (Exception e) {
                    throw DefaultPluginRequestApplicator.exceptionOccurred(this.request, e);
                }
            }
            catch (Exception e) {
                throw new LocationAwareException((Throwable)e, this.request.getScriptDisplayName(), this.request.getLineNumber());
            }
        }
    }
}

