//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::cell::UnsafeCell;
use core::ffi::*;
use core::marker::{PhantomData, PhantomPinned};
use core::ptr::NonNull;
#[cfg(feature = "objc2")]
use objc2::__framework_prelude::*;

use crate::*;

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cfxmlparser?language=objc)
#[doc(alias = "CFXMLParserRef")]
#[repr(C)]
pub struct CFXMLParser {
    inner: [u8; 0],
    _p: UnsafeCell<PhantomData<(*const UnsafeCell<()>, PhantomPinned)>>,
}

cf_type!(
    unsafe impl CFXMLParser {}
);
#[cfg(feature = "objc2")]
cf_objc2_type!(
    unsafe impl RefEncode<"__CFXMLParser"> for CFXMLParser {}
);

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cfxmlparseroptions?language=objc)
// NS_OPTIONS
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct CFXMLParserOptions(pub CFOptionFlags);
bitflags::bitflags! {
    impl CFXMLParserOptions: CFOptionFlags {
        #[doc(alias = "kCFXMLParserValidateDocument")]
        const ValidateDocument = 1<<0;
        #[doc(alias = "kCFXMLParserSkipMetaData")]
        const SkipMetaData = 1<<1;
        #[doc(alias = "kCFXMLParserReplacePhysicalEntities")]
        const ReplacePhysicalEntities = 1<<2;
        #[doc(alias = "kCFXMLParserSkipWhitespace")]
        const SkipWhitespace = 1<<3;
        #[doc(alias = "kCFXMLParserResolveExternalEntities")]
        const ResolveExternalEntities = 1<<4;
        #[doc(alias = "kCFXMLParserAddImpliedAttributes")]
        const AddImpliedAttributes = 1<<5;
        #[doc(alias = "kCFXMLParserAllOptions")]
        const AllOptions = 0x00FFFFFF;
        #[doc(alias = "kCFXMLParserNoOptions")]
        const NoOptions = 0;
    }
}

#[cfg(feature = "objc2")]
unsafe impl Encode for CFXMLParserOptions {
    const ENCODING: Encoding = CFOptionFlags::ENCODING;
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for CFXMLParserOptions {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cfxmlparserstatuscode?language=objc)
// NS_OPTIONS
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct CFXMLParserStatusCode(pub CFIndex);
bitflags::bitflags! {
    impl CFXMLParserStatusCode: CFIndex {
        #[doc(alias = "kCFXMLStatusParseNotBegun")]
        const StatusParseNotBegun = -2;
        #[doc(alias = "kCFXMLStatusParseInProgress")]
        const StatusParseInProgress = -1;
        #[doc(alias = "kCFXMLStatusParseSuccessful")]
        const StatusParseSuccessful = 0;
        #[doc(alias = "kCFXMLErrorUnexpectedEOF")]
        const ErrorUnexpectedEOF = 1;
        #[doc(alias = "kCFXMLErrorUnknownEncoding")]
        const ErrorUnknownEncoding = 2;
        #[doc(alias = "kCFXMLErrorEncodingConversionFailure")]
        const ErrorEncodingConversionFailure = 3;
        #[doc(alias = "kCFXMLErrorMalformedProcessingInstruction")]
        const ErrorMalformedProcessingInstruction = 4;
        #[doc(alias = "kCFXMLErrorMalformedDTD")]
        const ErrorMalformedDTD = 5;
        #[doc(alias = "kCFXMLErrorMalformedName")]
        const ErrorMalformedName = 6;
        #[doc(alias = "kCFXMLErrorMalformedCDSect")]
        const ErrorMalformedCDSect = 7;
        #[doc(alias = "kCFXMLErrorMalformedCloseTag")]
        const ErrorMalformedCloseTag = 8;
        #[doc(alias = "kCFXMLErrorMalformedStartTag")]
        const ErrorMalformedStartTag = 9;
        #[doc(alias = "kCFXMLErrorMalformedDocument")]
        const ErrorMalformedDocument = 10;
        #[doc(alias = "kCFXMLErrorElementlessDocument")]
        const ErrorElementlessDocument = 11;
        #[doc(alias = "kCFXMLErrorMalformedComment")]
        const ErrorMalformedComment = 12;
        #[doc(alias = "kCFXMLErrorMalformedCharacterReference")]
        const ErrorMalformedCharacterReference = 13;
        #[doc(alias = "kCFXMLErrorMalformedParsedCharacterData")]
        const ErrorMalformedParsedCharacterData = 14;
        #[doc(alias = "kCFXMLErrorNoData")]
        const ErrorNoData = 15;
    }
}

#[cfg(feature = "objc2")]
unsafe impl Encode for CFXMLParserStatusCode {
    const ENCODING: Encoding = CFIndex::ENCODING;
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for CFXMLParserStatusCode {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cfxmlparsercreatexmlstructurecallback?language=objc)
#[cfg(feature = "CFXMLNode")]
pub type CFXMLParserCreateXMLStructureCallBack = Option<
    unsafe extern "C-unwind" fn(*mut CFXMLParser, *const CFXMLNode, *mut c_void) -> *mut c_void,
>;

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cfxmlparseraddchildcallback?language=objc)
pub type CFXMLParserAddChildCallBack =
    Option<unsafe extern "C-unwind" fn(*mut CFXMLParser, *mut c_void, *mut c_void, *mut c_void)>;

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cfxmlparserendxmlstructurecallback?language=objc)
pub type CFXMLParserEndXMLStructureCallBack =
    Option<unsafe extern "C-unwind" fn(*mut CFXMLParser, *mut c_void, *mut c_void)>;

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cfxmlparserresolveexternalentitycallback?language=objc)
#[cfg(all(feature = "CFData", feature = "CFURL", feature = "CFXMLNode"))]
pub type CFXMLParserResolveExternalEntityCallBack = Option<
    unsafe extern "C-unwind" fn(
        *mut CFXMLParser,
        *mut CFXMLExternalID,
        *mut c_void,
    ) -> *const CFData,
>;

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cfxmlparserhandleerrorcallback?language=objc)
pub type CFXMLParserHandleErrorCallBack = Option<
    unsafe extern "C-unwind" fn(*mut CFXMLParser, CFXMLParserStatusCode, *mut c_void) -> Boolean,
>;

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cfxmlparsercallbacks?language=objc)
#[cfg(all(feature = "CFData", feature = "CFURL", feature = "CFXMLNode"))]
#[repr(C)]
#[allow(unpredictable_function_pointer_comparisons)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct CFXMLParserCallBacks {
    pub version: CFIndex,
    pub createXMLStructure: CFXMLParserCreateXMLStructureCallBack,
    pub addChild: CFXMLParserAddChildCallBack,
    pub endXMLStructure: CFXMLParserEndXMLStructureCallBack,
    pub resolveExternalEntity: CFXMLParserResolveExternalEntityCallBack,
    pub handleError: CFXMLParserHandleErrorCallBack,
}

#[cfg(all(
    feature = "CFData",
    feature = "CFURL",
    feature = "CFXMLNode",
    feature = "objc2"
))]
unsafe impl Encode for CFXMLParserCallBacks {
    const ENCODING: Encoding = Encoding::Struct(
        "?",
        &[
            <CFIndex>::ENCODING,
            <CFXMLParserCreateXMLStructureCallBack>::ENCODING,
            <CFXMLParserAddChildCallBack>::ENCODING,
            <CFXMLParserEndXMLStructureCallBack>::ENCODING,
            <CFXMLParserResolveExternalEntityCallBack>::ENCODING,
            <CFXMLParserHandleErrorCallBack>::ENCODING,
        ],
    );
}

#[cfg(all(
    feature = "CFData",
    feature = "CFURL",
    feature = "CFXMLNode",
    feature = "objc2"
))]
unsafe impl RefEncode for CFXMLParserCallBacks {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cfxmlparserretaincallback?language=objc)
pub type CFXMLParserRetainCallBack =
    Option<unsafe extern "C-unwind" fn(*const c_void) -> *const c_void>;

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cfxmlparserreleasecallback?language=objc)
pub type CFXMLParserReleaseCallBack = Option<unsafe extern "C-unwind" fn(*const c_void)>;

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cfxmlparsercopydescriptioncallback?language=objc)
pub type CFXMLParserCopyDescriptionCallBack =
    Option<unsafe extern "C-unwind" fn(*const c_void) -> *const CFString>;

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cfxmlparsercontext?language=objc)
#[repr(C)]
#[allow(unpredictable_function_pointer_comparisons)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct CFXMLParserContext {
    pub version: CFIndex,
    pub info: *mut c_void,
    pub retain: CFXMLParserRetainCallBack,
    pub release: CFXMLParserReleaseCallBack,
    pub copyDescription: CFXMLParserCopyDescriptionCallBack,
}

#[cfg(feature = "objc2")]
unsafe impl Encode for CFXMLParserContext {
    const ENCODING: Encoding = Encoding::Struct(
        "?",
        &[
            <CFIndex>::ENCODING,
            <*mut c_void>::ENCODING,
            <CFXMLParserRetainCallBack>::ENCODING,
            <CFXMLParserReleaseCallBack>::ENCODING,
            <CFXMLParserCopyDescriptionCallBack>::ENCODING,
        ],
    );
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for CFXMLParserContext {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

unsafe impl ConcreteType for CFXMLParser {
    #[doc(alias = "CFXMLParserGetTypeID")]
    #[inline]
    fn type_id() -> CFTypeID {
        extern "C-unwind" {
            fn CFXMLParserGetTypeID() -> CFTypeID;
        }
        unsafe { CFXMLParserGetTypeID() }
    }
}

impl CFXMLParser {
    /// # Safety
    ///
    /// - `allocator` might not allow `None`.
    /// - `xml_data` might not allow `None`.
    /// - `data_source` might not allow `None`.
    /// - `call_backs` must be a valid pointer.
    /// - `context` must be a valid pointer.
    #[doc(alias = "CFXMLParserCreate")]
    #[cfg(all(feature = "CFData", feature = "CFURL", feature = "CFXMLNode"))]
    #[deprecated = "CFXMLParser is deprecated, use NSXMLParser, NSXMLDocument or libxml2 library instead"]
    #[inline]
    pub unsafe fn new(
        allocator: Option<&CFAllocator>,
        xml_data: Option<&CFData>,
        data_source: Option<&CFURL>,
        parse_options: CFOptionFlags,
        version_of_nodes: CFIndex,
        call_backs: *mut CFXMLParserCallBacks,
        context: *mut CFXMLParserContext,
    ) -> Option<CFRetained<CFXMLParser>> {
        extern "C-unwind" {
            fn CFXMLParserCreate(
                allocator: Option<&CFAllocator>,
                xml_data: Option<&CFData>,
                data_source: Option<&CFURL>,
                parse_options: CFOptionFlags,
                version_of_nodes: CFIndex,
                call_backs: *mut CFXMLParserCallBacks,
                context: *mut CFXMLParserContext,
            ) -> Option<NonNull<CFXMLParser>>;
        }
        let ret = unsafe {
            CFXMLParserCreate(
                allocator,
                xml_data,
                data_source,
                parse_options,
                version_of_nodes,
                call_backs,
                context,
            )
        };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    /// # Safety
    ///
    /// - `allocator` might not allow `None`.
    /// - `data_source` might not allow `None`.
    /// - `call_backs` must be a valid pointer.
    /// - `context` must be a valid pointer.
    #[doc(alias = "CFXMLParserCreateWithDataFromURL")]
    #[cfg(all(feature = "CFData", feature = "CFURL", feature = "CFXMLNode"))]
    #[deprecated = "CFXMLParser is deprecated, use NSXMLParser, NSXMLDocument or libxml2 library instead"]
    #[inline]
    pub unsafe fn with_data_from_url(
        allocator: Option<&CFAllocator>,
        data_source: Option<&CFURL>,
        parse_options: CFOptionFlags,
        version_of_nodes: CFIndex,
        call_backs: *mut CFXMLParserCallBacks,
        context: *mut CFXMLParserContext,
    ) -> Option<CFRetained<CFXMLParser>> {
        extern "C-unwind" {
            fn CFXMLParserCreateWithDataFromURL(
                allocator: Option<&CFAllocator>,
                data_source: Option<&CFURL>,
                parse_options: CFOptionFlags,
                version_of_nodes: CFIndex,
                call_backs: *mut CFXMLParserCallBacks,
                context: *mut CFXMLParserContext,
            ) -> Option<NonNull<CFXMLParser>>;
        }
        let ret = unsafe {
            CFXMLParserCreateWithDataFromURL(
                allocator,
                data_source,
                parse_options,
                version_of_nodes,
                call_backs,
                context,
            )
        };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    /// # Safety
    ///
    /// `context` must be a valid pointer.
    #[doc(alias = "CFXMLParserGetContext")]
    #[deprecated = "CFXMLParser is deprecated, use NSXMLParser, NSXMLDocument or libxml2 library instead"]
    #[inline]
    pub unsafe fn context(&self, context: *mut CFXMLParserContext) {
        extern "C-unwind" {
            fn CFXMLParserGetContext(parser: &CFXMLParser, context: *mut CFXMLParserContext);
        }
        unsafe { CFXMLParserGetContext(self, context) }
    }

    /// # Safety
    ///
    /// `call_backs` must be a valid pointer.
    #[doc(alias = "CFXMLParserGetCallBacks")]
    #[cfg(all(feature = "CFData", feature = "CFURL", feature = "CFXMLNode"))]
    #[deprecated = "CFXMLParser is deprecated, use NSXMLParser, NSXMLDocument or libxml2 library instead"]
    #[inline]
    pub unsafe fn call_backs(&self, call_backs: *mut CFXMLParserCallBacks) {
        extern "C-unwind" {
            fn CFXMLParserGetCallBacks(parser: &CFXMLParser, call_backs: *mut CFXMLParserCallBacks);
        }
        unsafe { CFXMLParserGetCallBacks(self, call_backs) }
    }

    #[doc(alias = "CFXMLParserGetSourceURL")]
    #[cfg(feature = "CFURL")]
    #[deprecated = "CFXMLParser is deprecated, use NSXMLParser, NSXMLDocument or libxml2 library instead"]
    #[inline]
    pub fn source_url(&self) -> Option<CFRetained<CFURL>> {
        extern "C-unwind" {
            fn CFXMLParserGetSourceURL(parser: &CFXMLParser) -> Option<NonNull<CFURL>>;
        }
        let ret = unsafe { CFXMLParserGetSourceURL(self) };
        ret.map(|ret| unsafe { CFRetained::retain(ret) })
    }

    #[doc(alias = "CFXMLParserGetLocation")]
    #[deprecated = "CFXMLParser is deprecated, use NSXMLParser, NSXMLDocument or libxml2 library instead"]
    #[inline]
    pub fn location(&self) -> CFIndex {
        extern "C-unwind" {
            fn CFXMLParserGetLocation(parser: &CFXMLParser) -> CFIndex;
        }
        unsafe { CFXMLParserGetLocation(self) }
    }

    #[doc(alias = "CFXMLParserGetLineNumber")]
    #[deprecated = "CFXMLParser is deprecated, use NSXMLParser, NSXMLDocument or libxml2 library instead"]
    #[inline]
    pub fn line_number(&self) -> CFIndex {
        extern "C-unwind" {
            fn CFXMLParserGetLineNumber(parser: &CFXMLParser) -> CFIndex;
        }
        unsafe { CFXMLParserGetLineNumber(self) }
    }

    #[doc(alias = "CFXMLParserGetDocument")]
    #[deprecated = "CFXMLParser is deprecated, use NSXMLParser, NSXMLDocument or libxml2 library instead"]
    #[inline]
    pub fn document(&self) -> *mut c_void {
        extern "C-unwind" {
            fn CFXMLParserGetDocument(parser: &CFXMLParser) -> *mut c_void;
        }
        unsafe { CFXMLParserGetDocument(self) }
    }

    #[doc(alias = "CFXMLParserGetStatusCode")]
    #[deprecated = "CFXMLParser is deprecated, use NSXMLParser, NSXMLDocument or libxml2 library instead"]
    #[inline]
    pub fn status_code(&self) -> CFXMLParserStatusCode {
        extern "C-unwind" {
            fn CFXMLParserGetStatusCode(parser: &CFXMLParser) -> CFXMLParserStatusCode;
        }
        unsafe { CFXMLParserGetStatusCode(self) }
    }

    #[doc(alias = "CFXMLParserCopyErrorDescription")]
    #[deprecated = "CFXMLParser is deprecated, use NSXMLParser, NSXMLDocument or libxml2 library instead"]
    #[inline]
    pub fn error_description(&self) -> Option<CFRetained<CFString>> {
        extern "C-unwind" {
            fn CFXMLParserCopyErrorDescription(parser: &CFXMLParser) -> Option<NonNull<CFString>>;
        }
        let ret = unsafe { CFXMLParserCopyErrorDescription(self) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    /// # Safety
    ///
    /// `error_description` might not allow `None`.
    #[doc(alias = "CFXMLParserAbort")]
    #[deprecated = "CFXMLParser is deprecated, use NSXMLParser, NSXMLDocument or libxml2 library instead"]
    #[inline]
    pub unsafe fn abort(
        &self,
        error_code: CFXMLParserStatusCode,
        error_description: Option<&CFString>,
    ) {
        extern "C-unwind" {
            fn CFXMLParserAbort(
                parser: &CFXMLParser,
                error_code: CFXMLParserStatusCode,
                error_description: Option<&CFString>,
            );
        }
        unsafe { CFXMLParserAbort(self, error_code, error_description) }
    }

    #[doc(alias = "CFXMLParserParse")]
    #[deprecated = "CFXMLParser is deprecated, use NSXMLParser, NSXMLDocument or libxml2 library instead"]
    #[inline]
    pub fn parse(&self) -> bool {
        extern "C-unwind" {
            fn CFXMLParserParse(parser: &CFXMLParser) -> Boolean;
        }
        let ret = unsafe { CFXMLParserParse(self) };
        ret != 0
    }
}

/// # Safety
///
/// - `allocator` might not allow `None`.
/// - `xml_data` might not allow `None`.
/// - `data_source` might not allow `None`.
#[cfg(all(
    feature = "CFData",
    feature = "CFTree",
    feature = "CFURL",
    feature = "CFXMLNode"
))]
#[deprecated = "CFXMLParser is deprecated, use NSXMLParser, NSXMLDocument or libxml2 library instead"]
#[inline]
pub unsafe extern "C-unwind" fn CFXMLTreeCreateFromData(
    allocator: Option<&CFAllocator>,
    xml_data: Option<&CFData>,
    data_source: Option<&CFURL>,
    parse_options: CFOptionFlags,
    version_of_nodes: CFIndex,
) -> Option<CFRetained<CFXMLTree>> {
    extern "C-unwind" {
        fn CFXMLTreeCreateFromData(
            allocator: Option<&CFAllocator>,
            xml_data: Option<&CFData>,
            data_source: Option<&CFURL>,
            parse_options: CFOptionFlags,
            version_of_nodes: CFIndex,
        ) -> Option<NonNull<CFXMLTree>>;
    }
    let ret = unsafe {
        CFXMLTreeCreateFromData(
            allocator,
            xml_data,
            data_source,
            parse_options,
            version_of_nodes,
        )
    };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

/// # Safety
///
/// - `allocator` might not allow `None`.
/// - `xml_data` might not allow `None`.
/// - `data_source` might not allow `None`.
/// - `error_dict` must be a valid pointer.
#[cfg(all(
    feature = "CFData",
    feature = "CFDictionary",
    feature = "CFTree",
    feature = "CFURL",
    feature = "CFXMLNode"
))]
#[deprecated = "CFXMLParser is deprecated, use NSXMLParser, NSXMLDocument or libxml2 library instead"]
#[inline]
pub unsafe extern "C-unwind" fn CFXMLTreeCreateFromDataWithError(
    allocator: Option<&CFAllocator>,
    xml_data: Option<&CFData>,
    data_source: Option<&CFURL>,
    parse_options: CFOptionFlags,
    version_of_nodes: CFIndex,
    error_dict: *mut *const CFDictionary,
) -> Option<CFRetained<CFXMLTree>> {
    extern "C-unwind" {
        fn CFXMLTreeCreateFromDataWithError(
            allocator: Option<&CFAllocator>,
            xml_data: Option<&CFData>,
            data_source: Option<&CFURL>,
            parse_options: CFOptionFlags,
            version_of_nodes: CFIndex,
            error_dict: *mut *const CFDictionary,
        ) -> Option<NonNull<CFXMLTree>>;
    }
    let ret = unsafe {
        CFXMLTreeCreateFromDataWithError(
            allocator,
            xml_data,
            data_source,
            parse_options,
            version_of_nodes,
            error_dict,
        )
    };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

/// # Safety
///
/// - `allocator` might not allow `None`.
/// - `data_source` might not allow `None`.
#[cfg(all(feature = "CFTree", feature = "CFURL", feature = "CFXMLNode"))]
#[deprecated = "CFXMLParser is deprecated, use NSXMLParser, NSXMLDocument or libxml2 library instead"]
#[inline]
pub unsafe extern "C-unwind" fn CFXMLTreeCreateWithDataFromURL(
    allocator: Option<&CFAllocator>,
    data_source: Option<&CFURL>,
    parse_options: CFOptionFlags,
    version_of_nodes: CFIndex,
) -> Option<CFRetained<CFXMLTree>> {
    extern "C-unwind" {
        fn CFXMLTreeCreateWithDataFromURL(
            allocator: Option<&CFAllocator>,
            data_source: Option<&CFURL>,
            parse_options: CFOptionFlags,
            version_of_nodes: CFIndex,
        ) -> Option<NonNull<CFXMLTree>>;
    }
    let ret = unsafe {
        CFXMLTreeCreateWithDataFromURL(allocator, data_source, parse_options, version_of_nodes)
    };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

/// # Safety
///
/// - `allocator` might not allow `None`.
/// - `xml_tree` might not allow `None`.
#[cfg(all(feature = "CFData", feature = "CFTree", feature = "CFXMLNode"))]
#[deprecated = "CFXMLParser is deprecated, use NSXMLParser, NSXMLDocument or libxml2 library instead"]
#[inline]
pub unsafe extern "C-unwind" fn CFXMLTreeCreateXMLData(
    allocator: Option<&CFAllocator>,
    xml_tree: Option<&CFXMLTree>,
) -> Option<CFRetained<CFData>> {
    extern "C-unwind" {
        fn CFXMLTreeCreateXMLData(
            allocator: Option<&CFAllocator>,
            xml_tree: Option<&CFXMLTree>,
        ) -> Option<NonNull<CFData>>;
    }
    let ret = unsafe { CFXMLTreeCreateXMLData(allocator, xml_tree) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

/// # Safety
///
/// - `allocator` might not allow `None`.
/// - `string` might not allow `None`.
/// - `entities_dictionary` generics must be of the correct type.
/// - `entities_dictionary` might not allow `None`.
#[cfg(feature = "CFDictionary")]
#[inline]
pub unsafe extern "C-unwind" fn CFXMLCreateStringByEscapingEntities(
    allocator: Option<&CFAllocator>,
    string: Option<&CFString>,
    entities_dictionary: Option<&CFDictionary>,
) -> Option<CFRetained<CFString>> {
    extern "C-unwind" {
        fn CFXMLCreateStringByEscapingEntities(
            allocator: Option<&CFAllocator>,
            string: Option<&CFString>,
            entities_dictionary: Option<&CFDictionary>,
        ) -> Option<NonNull<CFString>>;
    }
    let ret =
        unsafe { CFXMLCreateStringByEscapingEntities(allocator, string, entities_dictionary) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

/// # Safety
///
/// - `allocator` might not allow `None`.
/// - `string` might not allow `None`.
/// - `entities_dictionary` generics must be of the correct type.
/// - `entities_dictionary` might not allow `None`.
#[cfg(feature = "CFDictionary")]
#[inline]
pub unsafe extern "C-unwind" fn CFXMLCreateStringByUnescapingEntities(
    allocator: Option<&CFAllocator>,
    string: Option<&CFString>,
    entities_dictionary: Option<&CFDictionary>,
) -> Option<CFRetained<CFString>> {
    extern "C-unwind" {
        fn CFXMLCreateStringByUnescapingEntities(
            allocator: Option<&CFAllocator>,
            string: Option<&CFString>,
            entities_dictionary: Option<&CFDictionary>,
        ) -> Option<NonNull<CFString>>;
    }
    let ret =
        unsafe { CFXMLCreateStringByUnescapingEntities(allocator, string, entities_dictionary) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfxmltreeerrordescription?language=objc)
    pub static kCFXMLTreeErrorDescription: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfxmltreeerrorlinenumber?language=objc)
    pub static kCFXMLTreeErrorLineNumber: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfxmltreeerrorlocation?language=objc)
    pub static kCFXMLTreeErrorLocation: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfxmltreeerrorstatuscode?language=objc)
    pub static kCFXMLTreeErrorStatusCode: Option<&'static CFString>;
}

#[cfg(all(feature = "CFData", feature = "CFURL", feature = "CFXMLNode"))]
#[deprecated = "renamed to `CFXMLParser::new`"]
#[inline]
pub unsafe extern "C-unwind" fn CFXMLParserCreate(
    allocator: Option<&CFAllocator>,
    xml_data: Option<&CFData>,
    data_source: Option<&CFURL>,
    parse_options: CFOptionFlags,
    version_of_nodes: CFIndex,
    call_backs: *mut CFXMLParserCallBacks,
    context: *mut CFXMLParserContext,
) -> Option<CFRetained<CFXMLParser>> {
    extern "C-unwind" {
        fn CFXMLParserCreate(
            allocator: Option<&CFAllocator>,
            xml_data: Option<&CFData>,
            data_source: Option<&CFURL>,
            parse_options: CFOptionFlags,
            version_of_nodes: CFIndex,
            call_backs: *mut CFXMLParserCallBacks,
            context: *mut CFXMLParserContext,
        ) -> Option<NonNull<CFXMLParser>>;
    }
    let ret = unsafe {
        CFXMLParserCreate(
            allocator,
            xml_data,
            data_source,
            parse_options,
            version_of_nodes,
            call_backs,
            context,
        )
    };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(all(feature = "CFData", feature = "CFURL", feature = "CFXMLNode"))]
#[deprecated = "renamed to `CFXMLParser::with_data_from_url`"]
#[inline]
pub unsafe extern "C-unwind" fn CFXMLParserCreateWithDataFromURL(
    allocator: Option<&CFAllocator>,
    data_source: Option<&CFURL>,
    parse_options: CFOptionFlags,
    version_of_nodes: CFIndex,
    call_backs: *mut CFXMLParserCallBacks,
    context: *mut CFXMLParserContext,
) -> Option<CFRetained<CFXMLParser>> {
    extern "C-unwind" {
        fn CFXMLParserCreateWithDataFromURL(
            allocator: Option<&CFAllocator>,
            data_source: Option<&CFURL>,
            parse_options: CFOptionFlags,
            version_of_nodes: CFIndex,
            call_backs: *mut CFXMLParserCallBacks,
            context: *mut CFXMLParserContext,
        ) -> Option<NonNull<CFXMLParser>>;
    }
    let ret = unsafe {
        CFXMLParserCreateWithDataFromURL(
            allocator,
            data_source,
            parse_options,
            version_of_nodes,
            call_backs,
            context,
        )
    };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

extern "C-unwind" {
    #[deprecated = "renamed to `CFXMLParser::context`"]
    pub fn CFXMLParserGetContext(parser: &CFXMLParser, context: *mut CFXMLParserContext);
}

extern "C-unwind" {
    #[cfg(all(feature = "CFData", feature = "CFURL", feature = "CFXMLNode"))]
    #[deprecated = "renamed to `CFXMLParser::call_backs`"]
    pub fn CFXMLParserGetCallBacks(parser: &CFXMLParser, call_backs: *mut CFXMLParserCallBacks);
}

#[cfg(feature = "CFURL")]
#[deprecated = "renamed to `CFXMLParser::source_url`"]
#[inline]
pub extern "C-unwind" fn CFXMLParserGetSourceURL(
    parser: &CFXMLParser,
) -> Option<CFRetained<CFURL>> {
    extern "C-unwind" {
        fn CFXMLParserGetSourceURL(parser: &CFXMLParser) -> Option<NonNull<CFURL>>;
    }
    let ret = unsafe { CFXMLParserGetSourceURL(parser) };
    ret.map(|ret| unsafe { CFRetained::retain(ret) })
}

#[deprecated = "renamed to `CFXMLParser::location`"]
#[inline]
pub extern "C-unwind" fn CFXMLParserGetLocation(parser: &CFXMLParser) -> CFIndex {
    extern "C-unwind" {
        fn CFXMLParserGetLocation(parser: &CFXMLParser) -> CFIndex;
    }
    unsafe { CFXMLParserGetLocation(parser) }
}

#[deprecated = "renamed to `CFXMLParser::line_number`"]
#[inline]
pub extern "C-unwind" fn CFXMLParserGetLineNumber(parser: &CFXMLParser) -> CFIndex {
    extern "C-unwind" {
        fn CFXMLParserGetLineNumber(parser: &CFXMLParser) -> CFIndex;
    }
    unsafe { CFXMLParserGetLineNumber(parser) }
}

#[deprecated = "renamed to `CFXMLParser::document`"]
#[inline]
pub extern "C-unwind" fn CFXMLParserGetDocument(parser: &CFXMLParser) -> *mut c_void {
    extern "C-unwind" {
        fn CFXMLParserGetDocument(parser: &CFXMLParser) -> *mut c_void;
    }
    unsafe { CFXMLParserGetDocument(parser) }
}

#[deprecated = "renamed to `CFXMLParser::status_code`"]
#[inline]
pub extern "C-unwind" fn CFXMLParserGetStatusCode(parser: &CFXMLParser) -> CFXMLParserStatusCode {
    extern "C-unwind" {
        fn CFXMLParserGetStatusCode(parser: &CFXMLParser) -> CFXMLParserStatusCode;
    }
    unsafe { CFXMLParserGetStatusCode(parser) }
}

#[deprecated = "renamed to `CFXMLParser::error_description`"]
#[inline]
pub extern "C-unwind" fn CFXMLParserCopyErrorDescription(
    parser: &CFXMLParser,
) -> Option<CFRetained<CFString>> {
    extern "C-unwind" {
        fn CFXMLParserCopyErrorDescription(parser: &CFXMLParser) -> Option<NonNull<CFString>>;
    }
    let ret = unsafe { CFXMLParserCopyErrorDescription(parser) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

extern "C-unwind" {
    #[deprecated = "renamed to `CFXMLParser::abort`"]
    pub fn CFXMLParserAbort(
        parser: &CFXMLParser,
        error_code: CFXMLParserStatusCode,
        error_description: Option<&CFString>,
    );
}

#[deprecated = "renamed to `CFXMLParser::parse`"]
#[inline]
pub extern "C-unwind" fn CFXMLParserParse(parser: &CFXMLParser) -> bool {
    extern "C-unwind" {
        fn CFXMLParserParse(parser: &CFXMLParser) -> Boolean;
    }
    let ret = unsafe { CFXMLParserParse(parser) };
    ret != 0
}
