//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::cell::UnsafeCell;
use core::ffi::*;
use core::marker::{PhantomData, PhantomPinned};
use core::ptr::NonNull;
#[cfg(feature = "objc2")]
use objc2::__framework_prelude::*;

use crate::*;

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cfmachport?language=objc)
#[repr(C)]
pub struct CFMachPort {
    inner: [u8; 0],
    _p: UnsafeCell<PhantomData<(*const UnsafeCell<()>, PhantomPinned)>>,
}

cf_type!(
    unsafe impl CFMachPort {}
);
#[cfg(feature = "objc2")]
cf_objc2_type!(
    unsafe impl RefEncode<"__CFMachPort"> for CFMachPort {}
);

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cfmachportcontext?language=objc)
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct CFMachPortContext {
    pub version: CFIndex,
    pub info: *mut c_void,
    pub retain: Option<unsafe extern "C-unwind" fn(*const c_void) -> *const c_void>,
    pub release: Option<unsafe extern "C-unwind" fn(*const c_void)>,
    pub copyDescription: Option<unsafe extern "C-unwind" fn(*const c_void) -> *const CFString>,
}

#[cfg(feature = "objc2")]
unsafe impl Encode for CFMachPortContext {
    const ENCODING: Encoding = Encoding::Struct(
        "?",
        &[
            <CFIndex>::ENCODING,
            <*mut c_void>::ENCODING,
            <Option<unsafe extern "C-unwind" fn(*const c_void) -> *const c_void>>::ENCODING,
            <Option<unsafe extern "C-unwind" fn(*const c_void)>>::ENCODING,
            <Option<unsafe extern "C-unwind" fn(*const c_void) -> *const CFString>>::ENCODING,
        ],
    );
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for CFMachPortContext {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cfmachportcallback?language=objc)
pub type CFMachPortCallBack =
    Option<unsafe extern "C-unwind" fn(*mut CFMachPort, *mut c_void, CFIndex, *mut c_void)>;

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cfmachportinvalidationcallback?language=objc)
pub type CFMachPortInvalidationCallBack =
    Option<unsafe extern "C-unwind" fn(*mut CFMachPort, *mut c_void)>;

unsafe impl ConcreteType for CFMachPort {
    #[doc(alias = "CFMachPortGetTypeID")]
    #[inline]
    fn type_id() -> CFTypeID {
        extern "C-unwind" {
            fn CFMachPortGetTypeID() -> CFTypeID;
        }
        unsafe { CFMachPortGetTypeID() }
    }
}

impl CFMachPort {
    #[doc(alias = "CFMachPortCreate")]
    #[inline]
    pub unsafe fn new(
        allocator: Option<&CFAllocator>,
        callout: CFMachPortCallBack,
        context: *mut CFMachPortContext,
        should_free_info: *mut Boolean,
    ) -> Option<CFRetained<CFMachPort>> {
        extern "C-unwind" {
            fn CFMachPortCreate(
                allocator: Option<&CFAllocator>,
                callout: CFMachPortCallBack,
                context: *mut CFMachPortContext,
                should_free_info: *mut Boolean,
            ) -> Option<NonNull<CFMachPort>>;
        }
        let ret = unsafe { CFMachPortCreate(allocator, callout, context, should_free_info) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    #[doc(alias = "CFMachPortCreateWithPort")]
    #[cfg(feature = "libc")]
    #[inline]
    pub unsafe fn with_port(
        allocator: Option<&CFAllocator>,
        port_num: libc::mach_port_t,
        callout: CFMachPortCallBack,
        context: *mut CFMachPortContext,
        should_free_info: *mut Boolean,
    ) -> Option<CFRetained<CFMachPort>> {
        extern "C-unwind" {
            fn CFMachPortCreateWithPort(
                allocator: Option<&CFAllocator>,
                port_num: libc::mach_port_t,
                callout: CFMachPortCallBack,
                context: *mut CFMachPortContext,
                should_free_info: *mut Boolean,
            ) -> Option<NonNull<CFMachPort>>;
        }
        let ret = unsafe {
            CFMachPortCreateWithPort(allocator, port_num, callout, context, should_free_info)
        };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    #[doc(alias = "CFMachPortGetPort")]
    #[cfg(feature = "libc")]
    #[inline]
    pub fn port(self: &CFMachPort) -> libc::mach_port_t {
        extern "C-unwind" {
            fn CFMachPortGetPort(port: &CFMachPort) -> libc::mach_port_t;
        }
        unsafe { CFMachPortGetPort(self) }
    }

    #[doc(alias = "CFMachPortGetContext")]
    #[inline]
    pub unsafe fn context(self: &CFMachPort, context: *mut CFMachPortContext) {
        extern "C-unwind" {
            fn CFMachPortGetContext(port: &CFMachPort, context: *mut CFMachPortContext);
        }
        unsafe { CFMachPortGetContext(self, context) }
    }

    #[doc(alias = "CFMachPortInvalidate")]
    #[inline]
    pub fn invalidate(self: &CFMachPort) {
        extern "C-unwind" {
            fn CFMachPortInvalidate(port: &CFMachPort);
        }
        unsafe { CFMachPortInvalidate(self) }
    }

    #[doc(alias = "CFMachPortIsValid")]
    #[inline]
    pub fn is_valid(self: &CFMachPort) -> bool {
        extern "C-unwind" {
            fn CFMachPortIsValid(port: &CFMachPort) -> Boolean;
        }
        let ret = unsafe { CFMachPortIsValid(self) };
        ret != 0
    }

    #[doc(alias = "CFMachPortGetInvalidationCallBack")]
    #[inline]
    pub fn invalidation_call_back(self: &CFMachPort) -> CFMachPortInvalidationCallBack {
        extern "C-unwind" {
            fn CFMachPortGetInvalidationCallBack(
                port: &CFMachPort,
            ) -> CFMachPortInvalidationCallBack;
        }
        unsafe { CFMachPortGetInvalidationCallBack(self) }
    }

    #[doc(alias = "CFMachPortSetInvalidationCallBack")]
    #[inline]
    pub unsafe fn set_invalidation_call_back(
        self: &CFMachPort,
        callout: CFMachPortInvalidationCallBack,
    ) {
        extern "C-unwind" {
            fn CFMachPortSetInvalidationCallBack(
                port: &CFMachPort,
                callout: CFMachPortInvalidationCallBack,
            );
        }
        unsafe { CFMachPortSetInvalidationCallBack(self, callout) }
    }

    #[doc(alias = "CFMachPortCreateRunLoopSource")]
    #[cfg(feature = "CFRunLoop")]
    #[inline]
    pub fn new_run_loop_source(
        allocator: Option<&CFAllocator>,
        port: Option<&CFMachPort>,
        order: CFIndex,
    ) -> Option<CFRetained<CFRunLoopSource>> {
        extern "C-unwind" {
            fn CFMachPortCreateRunLoopSource(
                allocator: Option<&CFAllocator>,
                port: Option<&CFMachPort>,
                order: CFIndex,
            ) -> Option<NonNull<CFRunLoopSource>>;
        }
        let ret = unsafe { CFMachPortCreateRunLoopSource(allocator, port, order) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }
}

#[deprecated = "renamed to `CFMachPort::new`"]
#[inline]
pub unsafe extern "C-unwind" fn CFMachPortCreate(
    allocator: Option<&CFAllocator>,
    callout: CFMachPortCallBack,
    context: *mut CFMachPortContext,
    should_free_info: *mut Boolean,
) -> Option<CFRetained<CFMachPort>> {
    extern "C-unwind" {
        fn CFMachPortCreate(
            allocator: Option<&CFAllocator>,
            callout: CFMachPortCallBack,
            context: *mut CFMachPortContext,
            should_free_info: *mut Boolean,
        ) -> Option<NonNull<CFMachPort>>;
    }
    let ret = unsafe { CFMachPortCreate(allocator, callout, context, should_free_info) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(feature = "libc")]
#[deprecated = "renamed to `CFMachPort::with_port`"]
#[inline]
pub unsafe extern "C-unwind" fn CFMachPortCreateWithPort(
    allocator: Option<&CFAllocator>,
    port_num: libc::mach_port_t,
    callout: CFMachPortCallBack,
    context: *mut CFMachPortContext,
    should_free_info: *mut Boolean,
) -> Option<CFRetained<CFMachPort>> {
    extern "C-unwind" {
        fn CFMachPortCreateWithPort(
            allocator: Option<&CFAllocator>,
            port_num: libc::mach_port_t,
            callout: CFMachPortCallBack,
            context: *mut CFMachPortContext,
            should_free_info: *mut Boolean,
        ) -> Option<NonNull<CFMachPort>>;
    }
    let ret = unsafe {
        CFMachPortCreateWithPort(allocator, port_num, callout, context, should_free_info)
    };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(feature = "libc")]
#[deprecated = "renamed to `CFMachPort::port`"]
#[inline]
pub extern "C-unwind" fn CFMachPortGetPort(port: &CFMachPort) -> libc::mach_port_t {
    extern "C-unwind" {
        fn CFMachPortGetPort(port: &CFMachPort) -> libc::mach_port_t;
    }
    unsafe { CFMachPortGetPort(port) }
}

extern "C-unwind" {
    #[deprecated = "renamed to `CFMachPort::context`"]
    pub fn CFMachPortGetContext(port: &CFMachPort, context: *mut CFMachPortContext);
}

#[deprecated = "renamed to `CFMachPort::invalidate`"]
#[inline]
pub extern "C-unwind" fn CFMachPortInvalidate(port: &CFMachPort) {
    extern "C-unwind" {
        fn CFMachPortInvalidate(port: &CFMachPort);
    }
    unsafe { CFMachPortInvalidate(port) }
}

#[deprecated = "renamed to `CFMachPort::is_valid`"]
#[inline]
pub extern "C-unwind" fn CFMachPortIsValid(port: &CFMachPort) -> bool {
    extern "C-unwind" {
        fn CFMachPortIsValid(port: &CFMachPort) -> Boolean;
    }
    let ret = unsafe { CFMachPortIsValid(port) };
    ret != 0
}

#[deprecated = "renamed to `CFMachPort::invalidation_call_back`"]
#[inline]
pub extern "C-unwind" fn CFMachPortGetInvalidationCallBack(
    port: &CFMachPort,
) -> CFMachPortInvalidationCallBack {
    extern "C-unwind" {
        fn CFMachPortGetInvalidationCallBack(port: &CFMachPort) -> CFMachPortInvalidationCallBack;
    }
    unsafe { CFMachPortGetInvalidationCallBack(port) }
}

extern "C-unwind" {
    #[deprecated = "renamed to `CFMachPort::set_invalidation_call_back`"]
    pub fn CFMachPortSetInvalidationCallBack(
        port: &CFMachPort,
        callout: CFMachPortInvalidationCallBack,
    );
}

#[cfg(feature = "CFRunLoop")]
#[deprecated = "renamed to `CFMachPort::new_run_loop_source`"]
#[inline]
pub extern "C-unwind" fn CFMachPortCreateRunLoopSource(
    allocator: Option<&CFAllocator>,
    port: Option<&CFMachPort>,
    order: CFIndex,
) -> Option<CFRetained<CFRunLoopSource>> {
    extern "C-unwind" {
        fn CFMachPortCreateRunLoopSource(
            allocator: Option<&CFAllocator>,
            port: Option<&CFMachPort>,
            order: CFIndex,
        ) -> Option<NonNull<CFRunLoopSource>>;
    }
    let ret = unsafe { CFMachPortCreateRunLoopSource(allocator, port, order) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}
