/*
 * Decompiled with CFR 0.152.
 */
package org.testng;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.testng.TestNGException;
import org.testng.collections.Lists;
import org.testng.internal.Utils;
import org.testng.reporters.Files;
import org.testng.util.Strings;
import org.testng.xml.IPostProcessor;
import org.testng.xml.Parser;
import org.testng.xml.XmlSuite;
import org.testng.xml.internal.TestNamesMatcher;
import org.testng.xml.internal.XmlSuiteUtils;

class JarFileUtils {
    private final IPostProcessor processor;
    private final String xmlPathInJar;
    private final List<String> testNames;
    private final List<XmlSuite> suites = Lists.newLinkedList();

    JarFileUtils(IPostProcessor iPostProcessor, String string, List<String> list) {
        this.processor = iPostProcessor;
        this.xmlPathInJar = string;
        this.testNames = list;
    }

    List<XmlSuite> extractSuitesFrom(File file) {
        try {
            Utils.log("TestNG", 2, "Trying to open jar file:" + file);
            List<String> list = Lists.newArrayList();
            boolean bl = this.testngXmlExistsInJar(file, list);
            if (!bl) {
                Utils.log("TestNG", 1, "Couldn't find the " + this.xmlPathInJar + " in the jar file, running all the classes");
                this.suites.add(XmlSuiteUtils.newXmlSuiteUsing(list));
            }
        }
        catch (IOException iOException) {
            throw new TestNGException(iOException);
        }
        return this.suites;
    }

    private boolean testngXmlExistsInJar(File file, List<String> list) throws IOException {
        boolean bl = false;
        try (JarFile jarFile = new JarFile(file);){
            Object object;
            Object object2;
            Iterator iterator;
            Collection<XmlSuite> collection;
            Enumeration<JarEntry> enumeration = jarFile.entries();
            File file2 = java.nio.file.Files.createTempDirectory("testngXmlPathInJar-", new FileAttribute[0]).toFile();
            String string = null;
            while (enumeration.hasMoreElements()) {
                collection = enumeration.nextElement();
                iterator = ((ZipEntry)((Object)collection)).getName();
                if (Parser.canParse(((String)((Object)iterator)).toLowerCase())) {
                    object2 = jarFile.getInputStream((ZipEntry)((Object)collection));
                    object = new File(file2, (String)((Object)iterator));
                    Files.copyFile((InputStream)object2, (File)object);
                    if (!this.matchesXmlPathInJar((JarEntry)((Object)collection))) continue;
                    string = ((File)object).toString();
                    continue;
                }
                if (!JarFileUtils.isJavaClass((JarEntry)((Object)collection))) continue;
                list.add(JarFileUtils.constructClassName((JarEntry)((Object)collection)));
            }
            if (Strings.isNullOrEmpty(string)) {
                boolean bl2 = bl;
                return bl2;
            }
            collection = Parser.parse(string, this.processor);
            iterator = collection.iterator();
            if (iterator.hasNext()) {
                object2 = (XmlSuite)iterator.next();
                if (this.testNames != null) {
                    object = new TestNamesMatcher((XmlSuite)object2, this.testNames);
                    List<String> list2 = ((TestNamesMatcher)object).getMissMatchedTestNames();
                    if (!list2.isEmpty()) {
                        throw new TestNGException("The test(s) <" + list2 + "> cannot be found.");
                    }
                    this.suites.addAll(((TestNamesMatcher)object).getSuitesMatchingTestNames());
                } else {
                    this.suites.add((XmlSuite)object2);
                }
                boolean bl3 = true;
                return bl3;
            }
        }
        return bl;
    }

    private boolean matchesXmlPathInJar(JarEntry jarEntry) {
        return jarEntry.getName().equals(this.xmlPathInJar);
    }

    private static boolean isJavaClass(JarEntry jarEntry) {
        return jarEntry.getName().endsWith(".class");
    }

    private static String constructClassName(JarEntry jarEntry) {
        int n = jarEntry.getName().length() - ".class".length();
        return jarEntry.getName().replace("/", ".").substring(0, n);
    }
}

