// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	otlpmetrics "go.opentelemetry.io/collector/pdata/internal/data/protogen/metrics/v1"
)

func CopyOrigMetricSlice(dest, src []*otlpmetrics.Metric) []*otlpmetrics.Metric {
	var newDest []*otlpmetrics.Metric
	if cap(dest) < len(src) {
		newDest = make([]*otlpmetrics.Metric, len(src))
		// Copy old pointers to re-use.
		copy(newDest, dest)
		// Add new pointers for missing elements from len(dest) to len(srt).
		for i := len(dest); i < len(src); i++ {
			newDest[i] = NewOrigMetric()
		}
	} else {
		newDest = dest[:len(src)]
		// Cleanup the rest of the elements so GC can free the memory.
		// This can happen when len(src) < len(dest) < cap(dest).
		for i := len(src); i < len(dest); i++ {
			DeleteOrigMetric(dest[i], true)
			dest[i] = nil
		}
		// Add new pointers for missing elements.
		// This can happen when len(dest) < len(src) < cap(dest).
		for i := len(dest); i < len(src); i++ {
			newDest[i] = NewOrigMetric()
		}
	}
	for i := range src {
		CopyOrigMetric(newDest[i], src[i])
	}
	return newDest
}

func GenerateOrigTestMetricSlice() []*otlpmetrics.Metric {
	orig := make([]*otlpmetrics.Metric, 5)
	orig[0] = NewOrigMetric()
	orig[1] = GenTestOrigMetric()
	orig[2] = NewOrigMetric()
	orig[3] = GenTestOrigMetric()
	orig[4] = NewOrigMetric()
	return orig
}
