package smc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteSourceServer invokes the smc.DeleteSourceServer API synchronously
func (client *Client) DeleteSourceServer(request *DeleteSourceServerRequest) (response *DeleteSourceServerResponse, err error) {
	response = CreateDeleteSourceServerResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteSourceServerWithChan invokes the smc.DeleteSourceServer API asynchronously
func (client *Client) DeleteSourceServerWithChan(request *DeleteSourceServerRequest) (<-chan *DeleteSourceServerResponse, <-chan error) {
	responseChan := make(chan *DeleteSourceServerResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteSourceServer(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteSourceServerWithCallback invokes the smc.DeleteSourceServer API asynchronously
func (client *Client) DeleteSourceServerWithCallback(request *DeleteSourceServerRequest, callback func(response *DeleteSourceServerResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteSourceServerResponse
		var err error
		defer close(result)
		response, err = client.DeleteSourceServer(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteSourceServerRequest is the request struct for api DeleteSourceServer
type DeleteSourceServerRequest struct {
	*requests.RpcRequest
	SourceId             string           `position:"Query" name:"SourceId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	Force                requests.Boolean `position:"Query" name:"Force"`
}

// DeleteSourceServerResponse is the response struct for api DeleteSourceServer
type DeleteSourceServerResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteSourceServerRequest creates a request to invoke DeleteSourceServer API
func CreateDeleteSourceServerRequest() (request *DeleteSourceServerRequest) {
	request = &DeleteSourceServerRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("smc", "2019-06-01", "DeleteSourceServer", "smc", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteSourceServerResponse creates a response to parse from DeleteSourceServer response
func CreateDeleteSourceServerResponse() (response *DeleteSourceServerResponse) {
	response = &DeleteSourceServerResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
