package sae

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteConfigMap invokes the sae.DeleteConfigMap API synchronously
func (client *Client) DeleteConfigMap(request *DeleteConfigMapRequest) (response *DeleteConfigMapResponse, err error) {
	response = CreateDeleteConfigMapResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteConfigMapWithChan invokes the sae.DeleteConfigMap API asynchronously
func (client *Client) DeleteConfigMapWithChan(request *DeleteConfigMapRequest) (<-chan *DeleteConfigMapResponse, <-chan error) {
	responseChan := make(chan *DeleteConfigMapResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteConfigMap(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteConfigMapWithCallback invokes the sae.DeleteConfigMap API asynchronously
func (client *Client) DeleteConfigMapWithCallback(request *DeleteConfigMapRequest, callback func(response *DeleteConfigMapResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteConfigMapResponse
		var err error
		defer close(result)
		response, err = client.DeleteConfigMap(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteConfigMapRequest is the request struct for api DeleteConfigMap
type DeleteConfigMapRequest struct {
	*requests.RoaRequest
	ConfigMapId requests.Integer `position:"Query" name:"ConfigMapId"`
}

// DeleteConfigMapResponse is the response struct for api DeleteConfigMap
type DeleteConfigMapResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Message   string `json:"Message" xml:"Message"`
	Code      string `json:"Code" xml:"Code"`
	ErrorCode string `json:"ErrorCode" xml:"ErrorCode"`
	TraceId   string `json:"TraceId" xml:"TraceId"`
	Success   bool   `json:"Success" xml:"Success"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateDeleteConfigMapRequest creates a request to invoke DeleteConfigMap API
func CreateDeleteConfigMapRequest() (request *DeleteConfigMapRequest) {
	request = &DeleteConfigMapRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("sae", "2019-05-06", "DeleteConfigMap", "/pop/v1/sam/configmap/configMap", "serverless", "openAPI")
	request.Method = requests.DELETE
	return
}

// CreateDeleteConfigMapResponse creates a response to parse from DeleteConfigMap response
func CreateDeleteConfigMapResponse() (response *DeleteConfigMapResponse) {
	response = &DeleteConfigMapResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
